package com.gui;

import java.io.File;
import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import com.gui.BrowseButton.BrowseType;
import com.gui.BrowseButton.CanonicalType;
import com.model.DosboxVersion;
import com.model.Settings;
import com.util.DFendImportThread;


public final class DFendImportDialog extends Dialog {

	private Text location;
	private Text logText;
	private DosboxVersion defaultDbversion;
	private DFendImportThread importThread;
	private Button cancelButton;
	private Label profileLabel;
	private Shell shell;
	private Settings settings;


	public DFendImportDialog(final Shell parent, final int style) {
		super(parent, style);
	}

	public DFendImportDialog(final Shell parent) {
		this(parent, SWT.NONE);
	}
	
	public void setDefaultDosboxVersion(final DosboxVersion dbversion) {
		this.defaultDbversion = dbversion;
	}
	
	public Object open() {
	    settings = Settings.getInstance();
		createContents();
		shell.open();
		shell.layout();
		Display display = getParent().getDisplay();
		while (!shell.isDisposed()) {
			if (importThread != null && !importThread.isAlive() && !cancelButton.getText().equals(settings.msg("button.close"))) {
				GeneralPurposeDialogs.infoMessage(shell, settings.msg("dialog.dfendimport.notice.importok"));
				profileLabel.setText(settings.msg("dialog.dfendimport.reviewlog"));
				profileLabel.pack();
				cancelButton.setText(settings.msg("button.close"));
			}	
			if (!display.readAndDispatch()) {
				display.sleep();
			}
		}
		return importThread;
	}

	private void createContents() {
		shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
		shell.setLayout(new GridLayout());
        shell.addControlListener(new SizeControlAdapter(shell, "dfendimportdialog"));
		shell.setText(settings.msg("dialog.dfendimport.title"));

		final Group optionsGroup = new Group(shell, SWT.NONE);
		optionsGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		optionsGroup.setText(settings.msg("dialog.dfendimport.options"));
		final GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 3;
		optionsGroup.setLayout(gridLayout);

		final Label dfendLocLabel = new Label(optionsGroup, SWT.NONE);
		dfendLocLabel.setText(settings.msg("dialog.dfendimport.dfendpath"));

		location = new Text(optionsGroup, SWT.BORDER);
		location.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		location.setText(BrowseButton.DFEND_PATH + BrowseButton.DFEND_PROFILES);

		final BrowseButton browseButton = new BrowseButton(optionsGroup, SWT.NONE);
		browseButton.connect(shell, location, null, BrowseType.FILE, CanonicalType.DFEND, null);

		final Label cleanUpLabel = new Label(optionsGroup, SWT.NONE);
		cleanUpLabel.setText(settings.msg("dialog.dfendimport.cleanup"));

		final Button cleanup = new Button(optionsGroup, SWT.CHECK);
		cleanup.setText(settings.msg("dialog.dfendimport.removesections"));
		cleanup.setSelection(true);
		new Label(optionsGroup, SWT.NONE);

		final Button startImportButton = new Button(optionsGroup, SWT.NONE);
		shell.setDefaultButton(startImportButton);
		startImportButton.setLayoutData(new GridData(120, SWT.DEFAULT));
		startImportButton.setText(settings.msg("dialog.dfendimport.startimport"));

		cancelButton = new Button(optionsGroup, SWT.NONE);
		cancelButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent event) {
				shell.close();
			}
		});
		cancelButton.setLayoutData(new GridData(80, SWT.DEFAULT));
		cancelButton.setText(settings.msg("button.cancel"));
		new Label(optionsGroup, SWT.NONE);

		final Group progressGroup = new Group(shell, SWT.NONE);
		progressGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		progressGroup.setText(settings.msg("dialog.dfendimport.progress"));
		progressGroup.setLayout(new GridLayout());

		final ProgressBar progressBar = new ProgressBar(progressGroup, SWT.NONE);
		progressBar.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

		profileLabel = new Label(progressGroup, SWT.NONE);

		logText = new Text(progressGroup, SWT.V_SCROLL | SWT.MULTI | SWT.READ_ONLY | SWT.BORDER | SWT.H_SCROLL);
		logText.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		startImportButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent event) {
				try {
					importThread = new DFendImportThread(new File(location.getText()), cleanup.getSelection(), defaultDbversion, logText, progressBar, profileLabel);
					location.setEnabled(false);
					browseButton.setEnabled(false);
					cleanup.setEnabled(false);
					startImportButton.setEnabled(false);
					importThread.start();
				} catch (IOException ex) {
					GeneralPurposeDialogs.warningMessage(shell, ex.getMessage());
					importThread = null;
				}
			}
		});
	}
}
