package com.gui;

import java.io.File;
import java.sql.SQLException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import swing2swt.layout.BorderLayout;
import com.db.Database;
import com.gui.BrowseButton.BrowseType;
import com.gui.BrowseButton.CanonicalType;
import com.model.DosboxVersion;
import com.model.KeyValuePair;
import com.model.Profile;
import com.model.Settings;
import com.model.Template;
import com.model.conf.CompositeConfiguration;
import com.model.conf.Configuration;
import com.util.FileUtils;


public class EditProfileDialog extends EditTemplateDialog {

    private static int AMOUNT_OF_LINKS = 4;
    private static int AMOUNT_OF_CUSTOM_STRINGS = 4;
    
    private boolean focusOnTitle = false;
    
    private java.util.List<KeyValuePair> developersList;
    private java.util.List<KeyValuePair> publishersList;
    private java.util.List<KeyValuePair> genresList;
    private java.util.List<KeyValuePair> yearsList;
    private java.util.List<Template> templatesList;
    private java.util.List<KeyValuePair> statusList;
    private java.util.List<java.util.List<KeyValuePair>> customList = new java.util.ArrayList<java.util.List<KeyValuePair>>();

    private AutoSelectCombo developer;
    private AutoSelectCombo publisher;
    private AutoSelectCombo genre;
    private AutoSelectCombo year;
    private AutoSelectCombo status;
    private Text[] link = new Text[AMOUNT_OF_LINKS];
    private Text[] linkTitle = new Text[AMOUNT_OF_LINKS];
    private BrowseButton[] linkBrowseButton = new BrowseButton[AMOUNT_OF_LINKS];
    private Button favorite;
    private Text notes;
    
    private AutoSelectCombo[] customCombo = new AutoSelectCombo[AMOUNT_OF_CUSTOM_STRINGS];
    private Text[] customText = new Text[AMOUNT_OF_CUSTOM_STRINGS];
    private Scale custom9;
    private Spinner custom10;
    
    private Combo template;
    
    private Button loadfix;
    private Combo loadfix_value;
    
    private Text main;
    private Text main_params;
    private Text setup;
    private Text setup_params;
    private Text img1;
    private Text img2;
    
    private int templateIndex = -1;

    
    public EditProfileDialog(final Shell parent) {
        super(parent);
    }

    public void setProfile(final Profile prof) {
        this.result = prof;
    }

    public void sendToProfile(final String file) {
        this.result = FileUtils.makeRelativeToDosroot(new File(file)).getPath();
    }

    public void focusTitle() {
        this.focusOnTitle = true;
    }
    
    protected boolean init() {
        try {
            dbversionsList = dbase.readDosboxVersionsList();
            developersList = dbase.readDevelopersList();
            publishersList = dbase.readPublishersList();
            genresList = dbase.readGenresList();
            yearsList = dbase.readYearsList();
            templatesList = dbase.readTemplatesList();
            statusList = dbase.readStatusList();
            for (int i = 0; i < AMOUNT_OF_CUSTOM_STRINGS; i++) {
                customList.add(dbase.readCustomList(i));
            }
        } catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(getParent(), e.getMessage());
            return false;
        }
        if (result instanceof Profile) {
            dbversionIndex = DosboxVersion.findById(dbversionsList, ((Profile) result).getDbversionId());
            DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
            compConf = new CompositeConfiguration(dbversion, (Profile)result, true, getParent());
            if ((compConf.getCompositeConf().isIncomplete()) &&
                (!GeneralPurposeDialogs.confirmMessage(getParent(), settings.msg("dialog.profile.confirm.profileincomplete", 
                        new Object[] {FileUtils.DOSBOX_CONF, dbversion.getCanonicalConfFile()})))) {
                    return false;
            }
        } else {
            dbversionIndex = DosboxVersion.findDefault(dbversionsList);
            DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
            templateIndex = Template.findDefault(templatesList);
            if ((result instanceof String) && FileUtils.isConfFile((String) result)) {
                compConf = new CompositeConfiguration(dbversion, FileUtils.canonicalToDosroot((String) result), true, getParent());
            } else if (templateIndex != -1) {
                compConf = new CompositeConfiguration(dbversion, templatesList.get(templateIndex), true, getParent());
            } else {
                compConf = new CompositeConfiguration(dbversion, true, getParent());
            }
        }
        return true;
    }

    protected void createContents() {
        shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
        shell.setLayout(new BorderLayout(0, 0));
        shell.addControlListener(new SizeControlAdapter(shell, "profiledialog"));

        if (result instanceof Profile) {
            // meaning we are essentially editing an existing profile
            shell.setText(settings.msg("dialog.profile.title.edit", new Object[] {((Profile) result).getTitle(), ((Profile) result).getId()}));
        } else if (result instanceof String) {
            // meaning we are adding a new Profile with 'Send to...'
            shell.setText(settings.msg("dialog.profile.title.send", new Object[] {(String) result}));
        } else {
            shell.setText(settings.msg("dialog.profile.title.add"));
        }

        final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);
        createInfoTab(tabFolder);
        createCustomTab(tabFolder);
        createGeneralTab(tabFolder);
        createDisplayTab(tabFolder);
        createMachineTab(tabFolder);
        createAudioTab(tabFolder);
        createIOTab(tabFolder);
        createMountingTab(tabFolder);

        final Button okButton = createOkCancelButtons();
        okButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                if (!isValid()) {
                    return;
                }
                try {
                    if (setButton.isEnabled()) {
                        doLoadTemplateConf(setButton, true, false); // set correct dbversion
                    }
                    int profileId = dbase.addOrEditProfile(title.getText(), developer.getText(), publisher.getText(), genre.getText(),
                            year.getText(), status.getText(), setup.getText(), setup_params.getText(), notes.getText(), 
                            favorite.getSelection(), developer.getKey(), publisher.getKey(), genre.getKey(), year.getKey(),
                            status.getKey(), compConf.getDbversionId(),
                            new String[] { link[0].getText(), link[1].getText(), link[2].getText(), link[3].getText() },
                            new String[] { customCombo[0].getText(), customCombo[1].getText(), customCombo[2].getText(), customCombo[3].getText(),
                                customText[0].getText(), customText[1].getText(), customText[2].getText(), customText[3].getText() },
                            new int[] { custom9.getSelection(), custom10.getSelection() },
                            new int[] { customCombo[0].getKey(), customCombo[1].getKey(), customCombo[2].getKey(), customCombo[3].getKey() },
                            new String[] { linkTitle[0].getText(), linkTitle[1].getText(), linkTitle[2].getText(), linkTitle[3].getText() },
                            result instanceof Profile ? ((Profile) result).getId() : -1);
                    compConf.setCompositeConf(getConfigurationBySettings());

                    String confString;
                    if (result instanceof Profile) {
                        confString = ((Profile) result).getConfPathAndFile();
                    } else {
                        confString = FileUtils.constructUniqueConfigFileString(profileId, title.getText(), compConf.getCompositeConf());
                    }

                    String capturesString;
                    if (result instanceof Profile) {
                        capturesString = ((Profile) result).getCaptures();
                    } else {
                        capturesString = FileUtils.constructCapturesDir(profileId);
                        FileUtils.createDir(FileUtils.canonicalToData(capturesString));
                    }

                    if (!(result instanceof Profile)) {
                        dbase.updateProfileConf(confString, capturesString, profileId);
                    }

                    result = new Profile(profileId, title.getText(), developer.getText(), publisher.getText(),
                            genre.getText(), year.getText(), compConf.getDbversionId(), setup.getText(), setup_params.getText(),
                            notes.getText(), link[0].getText(), link[1].getText(), favorite.getSelection(),
                            status.getText(), confString, capturesString, link[2].getText(), link[3].getText(),
                            customCombo[0].getText(), customCombo[1].getText(), customCombo[2].getText(), customCombo[3].getText(),
                            customText[0].getText(), customText[1].getText(), customText[2].getText(), customText[3].getText(),
                            custom9.getSelection(), custom10.getSelection(),
                            linkTitle[0].getText(), linkTitle[1].getText(), linkTitle[2].getText(), linkTitle[3].getText());
                    
                    compConf.save((Profile)result, shell);
                } catch (SQLException e1) {
                    GeneralPurposeDialogs.warningMessage(shell, e1.getMessage());
                }
                shell.close();
            }
        });
        
        // init values
        for (DosboxVersion dbv : dbversionsList) {
            dbversion.add(dbv.getTitle());
        }
        for (Template templ : templatesList) {
            template.add(templ.getTitle());
        }
        dbversion.select(dbversionIndex);
        
        if (result instanceof Profile) {
            // meaning we are essentially editing an existing profile
            // so we need to set previous values
            title.setText(((Profile) result).getTitle());
            developer.setText(((Profile) result).getDeveloperName());
            publisher.setText(((Profile) result).getPublisherName());
            genre.setText(((Profile) result).getGenre());
            year.setText(((Profile) result).getYear());
            for (int i = 0; i < AMOUNT_OF_LINKS; i++) {
                link[i].setText(((Profile) result).getLink(i));
                linkTitle[i].setText(((Profile) result).getLinkTitle(i));
            }
            status.setText(((Profile) result).getStatus());
            favorite.setSelection(((Profile) result).isDefault());
            notes.setText(((Profile) result).getNotes());
            setup.setText(((Profile) result).getSetup());
            setup_params.setText(((Profile) result).getSetupParameters());
            for (int i = 0; i < AMOUNT_OF_CUSTOM_STRINGS; i++) {
                customCombo[i].setText(((Profile) result).getCustomString(i));
                customText[i].setText(((Profile) result).getCustomString(AMOUNT_OF_CUSTOM_STRINGS + i));
            }
            custom9.setSelection(((Profile) result).getCustomInt(0));
            custom10.setSelection(((Profile) result).getCustomInt(1));

            if (focusOnTitle) {
                title.selectAll();
                title.setFocus();
            }
            
        } else {
            // set default values for new profile
            title.setFocus();
            if (templateIndex != -1) {
                template.select(templateIndex);
            }

            if (result instanceof String) {
                // send to profile
                if (FileUtils.isExecutable((String) result)) {
                    main.setText((String) result);
                } else if (FileUtils.isBooterImage((String) result)) {
                    img1.setText((String) result);
                }
            }
        }

        enableSettingsByConfiguration();
        selectSettingsByConfiguration();
        
        startListeners();
    }
    
    protected void createMachineTab(final TabFolder tabFolder) {
        super.createMachineTab(tabFolder);
        
        final Label loadfixLabel = new Label(memoryGroup, SWT.NONE);
        loadfixLabel.setText(settings.msg("dialog.profile.loadfix"));
        loadfix = new Button(memoryGroup, SWT.CHECK);
        loadfix.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                loadfix_value.setEnabled(loadfix.getSelection());
            }
        });
        loadfix_value = new Combo(memoryGroup, SWT.NONE);
        loadfix_value.setItems(settings.getValues("profile", "loadfix_value"));
        loadfix_value.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        final Label kbLabel = new Label(memoryGroup, SWT.NONE);
        kbLabel.setText(settings.msg("dialog.profile.kb"));
    }

    protected void createInfoTab(final TabFolder tabFolder) {
        infoTabItem = new TabItem(tabFolder, SWT.NONE);
        infoTabItem.setText(settings.msg("dialog.profile.tab.info"));

        final Composite composite = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        composite.setLayout(gridLayout);
        infoTabItem.setControl(composite);

        final Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(settings.msg("dialog.profile.title"));
        title = new Text(composite, SWT.BORDER);
        title.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 5, 1));

        final Label developerLabel = new Label(composite, SWT.NONE);
        developerLabel.setText(settings.msg("dialog.profile.developer"));
        developer = new AutoSelectCombo(composite, SWT.NONE, developersList);
        developer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        developer.setVisibleItemCount(15);

        final Label publisherLabel = new Label(composite, SWT.NONE);
        publisherLabel.setLayoutData(new GridData());
        publisherLabel.setText(settings.msg("dialog.profile.publisher"));
        publisher = new AutoSelectCombo(composite, SWT.NONE, publishersList);
        publisher.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        publisher.setVisibleItemCount(15);

        final Label genreLabel = new Label(composite, SWT.NONE);
        genreLabel.setText(settings.msg("dialog.profile.genre"));
        genre = new AutoSelectCombo(composite, SWT.NONE, genresList);
        genre.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        genre.setVisibleItemCount(15);

        final Label yearLabel = new Label(composite, SWT.NONE);
        yearLabel.setLayoutData(new GridData());
        yearLabel.setText(settings.msg("dialog.profile.year"));
        year = new AutoSelectCombo(composite, SWT.NONE, yearsList);
        year.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        year.setVisibleItemCount(15);

        for (int i = 0; i < AMOUNT_OF_LINKS; i++) {
            final Label linkLabel = new Label(composite, SWT.NONE);
            linkLabel.setText(settings.msg("dialog.profile.link" + (i + 1)));
            link[i] = new Text(composite, SWT.BORDER);
            link[i].setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
            linkBrowseButton[i] = new BrowseButton(composite, SWT.NONE);
    
            final Label linkTitleLabel = new Label(composite, SWT.NONE);
            linkTitleLabel.setText(settings.msg("dialog.profile.linktitle"));
            linkTitle[i] = new Text(composite, SWT.BORDER);
            linkTitle[i].setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        }

        final Label statusLabel = new Label(composite, SWT.NONE);
        statusLabel.setText(settings.msg("dialog.profile.status"));
        status = new AutoSelectCombo(composite, SWT.NONE, statusList);
        status.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        status.setVisibleItemCount(10);

        final Label favoriteLabel = new Label(composite, SWT.NONE);
        favoriteLabel.setText(settings.msg("dialog.profile.favorite"));
        favorite = new Button(composite, SWT.CHECK);
        new Label(composite, SWT.NONE);

        final Label notesLabel = new Label(composite, SWT.NONE);
        notesLabel.setText(settings.msg("dialog.profile.notes"));
        notes = new Text(composite, SWT.V_SCROLL | SWT.MULTI | SWT.BORDER | SWT.WRAP);
        final GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true, 5, 1);
        notes.setLayoutData(gridData);
    }
    
    private void createCustomTab(final TabFolder tabFolder) {
        final TabItem customTabItem = new TabItem(tabFolder, SWT.NONE);
        customTabItem.setText(settings.msg("dialog.profile.tab.custominfo"));

        final Composite composite_8 = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout_21 = new GridLayout();
        gridLayout_21.numColumns = 2;
        composite_8.setLayout(gridLayout_21);
        customTabItem.setControl(composite_8);

        for (int i = 0; i < AMOUNT_OF_CUSTOM_STRINGS; i++) {
            final Label customLabel = new Label(composite_8, SWT.NONE);
            customLabel.setText(settings.getValue("gui", "custom" + (i + 1)));
            customCombo[i] = new AutoSelectCombo(composite_8, SWT.NONE, customList.get(i));
            customCombo[i].setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        }

        for (int i = 0; i < AMOUNT_OF_CUSTOM_STRINGS; i++) {
            final Label customLabel = new Label(composite_8, SWT.NONE);
            customLabel.setText(settings.getValue("gui", "custom" + (i + 1 + AMOUNT_OF_CUSTOM_STRINGS)));
            customText[i] = new Text(composite_8, SWT.BORDER);
            customText[i].setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        }

        final Label custom9Label = new Label(composite_8, SWT.NONE);
        custom9Label.setText(settings.getValue("gui", "custom9"));
        custom9 = new Scale(composite_8, SWT.NONE);
        custom9.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label custom10Label = new Label(composite_8, SWT.NONE);
        custom10Label.setText(settings.getValue("gui", "custom10"));
        custom10 = new Spinner(composite_8, SWT.BORDER);
        custom10.setLayoutData(new GridData(100, SWT.DEFAULT));
        custom10.setMinimum(Integer.MIN_VALUE);
        custom10.setMaximum(Integer.MAX_VALUE);
    }

    protected void createGeneralTab(final TabFolder tabFolder) {
        super.createGeneralTab(tabFolder);
        
        final Label templateLabel = new Label(associationGroup, SWT.NONE);
        templateLabel.setText(settings.msg("dialog.profile.template"));
        template = new Combo(associationGroup, SWT.READ_ONLY);
        final GridData gridData_6 = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
        template.setLayoutData(gridData_6);
        template.setVisibleItemCount(10);
        final Button reloadButton2 = new Button(associationGroup, SWT.NONE);
        reloadButton2.setText(settings.msg("dialog.profile.reloadsettings"));
        reloadButton2.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                if (template.getSelectionIndex() != -1) {
                    doLoadTemplateConf(setButton, false, true);
                }
            }
        });

        final Label configFileLabel = new Label(miscGroup, SWT.NONE);
        configFileLabel.setText(settings.msg("dialog.profile.configfile"));
        Text config_file = new Text(miscGroup, SWT.BORDER);
        config_file.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
        config_file.setEditable(false);
        config_file.setText(result instanceof Profile ? ((Profile) result).getConfPathAndFile() : 
            SettingsDialog.confLocations[settings.getIntValue("profiledefaults", "confpath")] + ", " + 
            SettingsDialog.confFilenames[settings.getIntValue("profiledefaults", "conffile")]);
    }
    
    protected void createExecuteGroup(final Composite composite) {
        final Group executeGroup = new Group(composite, SWT.NONE);
        executeGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        executeGroup.setText(settings.msg("dialog.profile.execute"));
        final GridLayout gridLayout_18 = new GridLayout();
        gridLayout_18.numColumns = 6;
        executeGroup.setLayout(gridLayout_18);

        dosButton = new Button(executeGroup, SWT.RADIO);
        dosButton.setText(settings.msg("dialog.template.dos"));
        final Label mainExeLabel = new Label(executeGroup, SWT.NONE);
        mainExeLabel.setText(settings.msg("dialog.profile.mainexe"));
        main = new Text(executeGroup, SWT.BORDER);
        final GridData gridData_1 = new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1);
        main.setLayoutData(gridData_1);

        for (int i = 0; i < AMOUNT_OF_LINKS; i++) {
            linkBrowseButton[i].connect(shell, link[i], main, BrowseType.FILE, CanonicalType.DOC, null);
        }

        final BrowseButton mainBrowseButton = new BrowseButton(executeGroup, SWT.NONE);
        mainBrowseButton.connect(shell, main, null, BrowseType.FILE, CanonicalType.EXE, pixelshader);

        final GrabButton grab1 = new GrabButton(executeGroup, SWT.NONE);
        grab1.connect(main, mountingpoints);

        new Label(executeGroup, SWT.NONE);
        new Label(executeGroup, SWT.NONE);
        final Label parametersLabel = new Label(executeGroup, SWT.NONE);
        parametersLabel.setLayoutData(new GridData());
        parametersLabel.setText(settings.msg("dialog.profile.mainparameters"));
        main_params = new Text(executeGroup, SWT.BORDER);
        main_params.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(executeGroup, SWT.NONE);
        new Label(executeGroup, SWT.NONE);
        
        new Label(executeGroup, SWT.NONE);
        final Label setupLabel = new Label(executeGroup, SWT.NONE);
        setupLabel.setLayoutData(new GridData());
        setupLabel.setText(settings.msg("dialog.profile.setupexe"));
        setup = new Text(executeGroup, SWT.BORDER);
        setup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

        final BrowseButton setupBrowseButton = new BrowseButton(executeGroup, SWT.NONE);
        setupBrowseButton.connect(shell, setup, main, BrowseType.FILE, CanonicalType.EXE, pixelshader);

        final GrabButton grab2 = new GrabButton(executeGroup, SWT.NONE);
        grab2.connect(setup, mountingpoints);

        new Label(executeGroup, SWT.NONE);
        new Label(executeGroup, SWT.NONE);
        final Label parametersLabel_1 = new Label(executeGroup, SWT.NONE);
        parametersLabel_1.setLayoutData(new GridData());
        parametersLabel_1.setText(settings.msg("dialog.profile.setupparameters"));
        setup_params = new Text(executeGroup, SWT.BORDER);
        setup_params.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(executeGroup, SWT.NONE);
        new Label(executeGroup, SWT.NONE);

        final Label label_1 = new Label(executeGroup, SWT.SEPARATOR | SWT.HORIZONTAL);
        label_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 6, 1));

        booterButton = new Button(executeGroup, SWT.RADIO);
        booterButton.setText(settings.msg("dialog.template.booter"));
        final Label image1Label = new Label(executeGroup, SWT.NONE);
        image1Label.setText(settings.msg("dialog.profile.booterimage1"));
        img1 = new Text(executeGroup, SWT.BORDER);
        img1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

        final BrowseButton img1BrowseButton = new BrowseButton(executeGroup, SWT.NONE);
        img1BrowseButton.connect(shell, img1, null, BrowseType.FILE, CanonicalType.BOOTER, null);

        final GrabButton grab3 = new GrabButton(executeGroup, SWT.NONE);
        grab3.connect(img1, mountingpoints);

        new Label(executeGroup, SWT.NONE);
        final Label image2Label = new Label(executeGroup, SWT.NONE);
        image2Label.setText(settings.msg("dialog.profile.booterimage2"));
        img2 = new Text(executeGroup, SWT.BORDER);
        img2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

        final BrowseButton img2BrowseButton = new BrowseButton(executeGroup, SWT.NONE);
        img2BrowseButton.connect(shell, img2, img1, BrowseType.FILE, CanonicalType.BOOTER, null);

        final GrabButton grab4 = new GrabButton(executeGroup, SWT.NONE);
        grab4.connect(img2, mountingpoints);
    }
    
    private void startListeners() {
        VerifyListener addMountListener = new VerifyListener() {
            public void verifyText(final VerifyEvent event) {
                if (event.text.length() > 1) {
                    boolean booter = event.widget == img1 || event.widget == img2;
                    addMountIfNoMounts(event.text, booter);
                }
            }
        };
        
        ModifyListener exeListener = new ModifyListener() {
            public void modifyText(final ModifyEvent event) {
                boolean booter = event.widget == img1 || event.widget == img2;
                dosButton.setSelection(!booter);
                booterButton.setSelection(booter);
            }
        };

        main.addVerifyListener(addMountListener);
        setup.addVerifyListener(addMountListener);
        img1.addVerifyListener(addMountListener);
        img2.addVerifyListener(addMountListener);
        main.addModifyListener(exeListener);
        main_params.addModifyListener(exeListener);
        setup.addModifyListener(exeListener);
        setup_params.addModifyListener(exeListener);
        img1.addModifyListener(exeListener);
        img2.addModifyListener(exeListener);
    }
    
    private void addMountIfNoMounts(final String hostFileLocation, final boolean booter) {
        if (mountingpoints.getItemCount() == 0) {
            try{
                mountingpoints.setItems(compConf.addRequiredMount(booter, hostFileLocation));
                mountingpoints.select(mountingpoints.getItemCount() - 1);
            } catch (Exception e) {
                // since the mounting point could not be instantiated, just forget about it
            }
        }
    }
    
    public static Profile duplicateProfile(final Profile prof, final java.util.List<DosboxVersion> dbversionsList, final Database dbase, final Shell shell) {
        try {
            int dbversionIndex = DosboxVersion.findById(dbversionsList, prof.getDbversionId());
            DosboxVersion dbversion = dbversionsList.get(dbversionIndex);
            CompositeConfiguration newCompositeConf = new CompositeConfiguration(dbversion, prof, true, shell);
            int newProfileId = dbase.duplicateProfile(prof.getId());
            String newCapturesString = FileUtils.constructCapturesDir(newProfileId);
            File newCaptures = FileUtils.canonicalToData(newCapturesString);
            FileUtils.createDir(newCaptures);
            String newConfFile = FileUtils.constructUniqueConfigFileString(newProfileId, prof.getTitle(), newCompositeConf.getCompositeConf());
            
            Profile newProfile = new Profile(newProfileId, newConfFile, newCapturesString, prof);
            
            newCompositeConf.save(newProfile, shell);

            dbase.updateProfileConf(newConfFile, newCapturesString, newProfileId);
            if (GeneralPurposeDialogs.confirmMessage(shell, Settings.getInstance().msg("dialog.profile.confirm.capturesduplication"))) {
                FileUtils.copyFiles(prof.getCanonicalCaptures(), newCaptures);
            }
            return newProfile;
        } catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(shell, e.getMessage());
            return null;
        }
    }
    
    protected CompositeConfiguration obtainNewConf(final boolean keepValues, final boolean isTemplate) {
        if (isTemplate) {
            return new CompositeConfiguration(compConf, dbversionsList.get(dbversion.getSelectionIndex()), 
                    templatesList.get(template.getSelectionIndex()), false, shell);
        } else {
            return new CompositeConfiguration(compConf, dbversionsList.get(dbversion.getSelectionIndex()), 
                    keepValues, isTemplate, shell);
        }
    }
    
    protected void selectSettingsByConfiguration() {
        super.selectSettingsByConfiguration();
        Configuration conf = compConf.getCompositeConf();
        captures.setText(result instanceof Profile ? ((Profile) result).getCaptures(): settings.msg("dialog.profile.automatic"));
        loadfix.setSelection(conf.isLoadfix());
        loadfix_value.setText(conf.getLoadfixValue());
        loadfix_value.setEnabled(conf.isLoadfix());
        if (conf.isBooter()) {
            img1.setText(conf.getImg1());
            img2.setText(conf.getImg2());
        } else {
            main.setText(conf.getMain());
            main_params.setText(conf.getMainParameters());
        }
    }
    
    protected Configuration getConfigurationBySettings() {
        Configuration conf = super.getConfigurationBySettings();
        conf.setAutoexecSettings(loadfix.getSelection(), loadfix_value.getText(), main.getText(), main_params.getText(), img1.getText(), img2.getText());
        return conf;
    }

    protected boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        String requiredMount = null;
        if (title.getText().length() == 0) {
            GeneralPurposeDialogs.addError(settings.msg("dialog.profile.required.title"), title, infoTabItem);
        }
        if (dosButton.getSelection()) {
            if (FileUtils.isExecutable(main.getText())) {
                requiredMount = dealWithField(false, main.getText());
            } else {
                GeneralPurposeDialogs.addError(settings.msg("dialog.profile.required.mainexe"), main, mountingTabItem);
            }
            if (FileUtils.isExecutable(setup.getText())) {
                requiredMount = dealWithField(false, setup.getText());
            }
        } else if (booterButton.getSelection()) {
            if (img1.getText().length() == 0) {
                GeneralPurposeDialogs.addError(settings.msg("dialog.profile.required.booterimage"), img1, mountingTabItem);
            } else {
                requiredMount = dealWithField(true, img1.getText());
            }
            if (img2.getText().length() > 0) {
                requiredMount = dealWithField(true, img2.getText());
            }
        }
        if (requiredMount != null) {
            GeneralPurposeDialogs.addError(settings.msg("dialog.profile.required.mountlocation"), mountingpoints, mountingTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(shell);
    }
    
    private String dealWithField(final boolean booter, final String loc) {
        String requiredMount = compConf.getRequiredMount(booter, loc);
        if (requiredMount != null && GeneralPurposeDialogs.confirmMessage(shell, settings.msg("dialog.profile.confirm.addmountlocation", new Object[] {requiredMount}))) {
            mountingpoints.setItems(compConf.addRequiredMount(booter, loc));
        }
        return compConf.getRequiredMount(booter, loc);
    }
}
