package com.gui;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import com.model.Settings;


public class SizeControlAdapter extends ControlAdapter {

    private Shell shell;
    private String itemName;
    private static Settings settings = Settings.getInstance();
    
    
    public SizeControlAdapter(final Shell shell, final String itemName) {
        this.shell = shell;
        this.itemName = itemName;
        shell.setSize(
                settings.getIntValue("gui", itemName + "_width"), 
                settings.getIntValue("gui", itemName + "_height"));
    }
    
    public void controlResized(final ControlEvent arg0) {
        super.controlResized(arg0);
        Rectangle rec = shell.getBounds();
        settings.setIntValue("gui", itemName + "_width", rec.width);
        settings.setIntValue("gui", itemName + "_height", rec.height);
    }
}
