package com.gui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import com.model.Settings;
import com.swtdesigner.SWTImageManager;


public final class Thumb extends Dialog {

    private static final double THUMB_FACTOR = 2.0;

    private Shell shell;
    private Display display;
    private Image thumbImage = null;
    private String filename;


    public Thumb(final Shell parent, final int style) {
        super(parent, style);
        display = parent.getDisplay();
    }

    public Thumb(final Shell parent) {
        this(parent, SWT.NONE);
    }

    public void setThumb(final String filename) {
        this.filename = filename;
        Image orgthumb = SWTImageManager.getImage(display, filename);
        ImageData bigThumb = orgthumb.getImageData();
        int width = bigThumb.width;
        int height = bigThumb.height;
        if ((width <= 400) && (height <= 350)) {
            bigThumb = bigThumb.scaledTo((int) (width * THUMB_FACTOR), (int) (height * THUMB_FACTOR));
        }
        thumbImage = new Image(display, bigThumb);
    }

    public Object open() {
        createContents();
        shell.open();
        shell.layout();
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) {
                display.sleep();
            }
        }
        if (thumbImage != null && !thumbImage.isDisposed()) {
            thumbImage.dispose();
        }
        return null;
    }

    protected void createContents() {
        if (thumbImage != null) {
            shell = new Shell(getParent(), SWT.DIALOG_TRIM | SWT.APPLICATION_MODAL);
            shell.setLayout(new FillLayout());
            shell.setSize(thumbImage.getImageData().width + 24, thumbImage.getImageData().height + 50);
            shell.setText(Settings.getInstance().msg("dialog.screenshot.title", new Object[] {filename}));
            final Button button = new Button(shell, SWT.FLAT);
            button.addSelectionListener(new SelectionAdapter() {
                public void widgetSelected(final SelectionEvent event) {
                    shell.close();
                }
            });
            button.setImage(thumbImage);
            button.pack();
        }
    }
}
