package com.model;

import java.util.List;


public class KeyValuePair {

    private final int id;
    private final String value;


    public KeyValuePair(final int id, final String value) {
        this.id = id;
        this.value = value;
    }

    public int getId() {
        return id;
    }

    public String getValue() {
        return value;
    }

    public static int findIdByValue(final List<KeyValuePair> list, final String value) {
        for (KeyValuePair element: list) {
            if (element.value.equals(value)) {
                return element.id;
            }
        }
        return -1; // value not found
    }

    public static <T extends KeyValuePair> int findById(final List<T> list, final int id) {
        int result = 0;
        for (T element: list) {
            if (element.id == id) {
                return result;
            }
            result++;
        }
        return -1; // id not found
    }
}
