package com.model;

import java.util.ArrayList;
import java.util.List;


public class OrderingVector {

    private class OrderingElement {

        private final int column;
        private final boolean ascending;


        OrderingElement(final int col, final boolean asc) {
            this.column = col;
            this.ascending = asc;
        }

        public boolean equals(final Object obj) {
            return this.column == ((OrderingElement) obj).column;
        }

        public String toString() {
            return GAME_LIST_ORDER[column] + (ascending ? " ASC": " DESC");
        }
    }


    private static final int MAX_ORDERING_COLS = 8;
    private static final String[] GAME_LIST_ORDER = { "GAM.TITLE", "GAM.SETUP", "DEV.NAME", "PUBL.NAME", "GEN.NAME",
            "YR.YEAR", "STAT.STAT", "GAM.FAVORITE", "GAM.ID", "GAM.DBVERSION_ID", "CUST1.VALUE", "CUST2.VALUE",
            "CUST3.VALUE", "CUST4.VALUE", "GAM.CUSTOM5", "GAM.CUSTOM6", "GAM.CUSTOM7", "GAM.CUSTOM8", "GAM.CUSTOM9",
            "GAM.CUSTOM10" };

    private final List<OrderingElement> vector;


    public OrderingVector(final int[] columnArray, final boolean[] ascendingArray) {
        vector = new ArrayList<OrderingElement>();
        for (int i = 0; i < columnArray.length; i++) {
            vector.add(new OrderingElement(columnArray[i], ascendingArray[i]));
        }
    }

    public void addOrdering(final int column, final boolean ascending) {
        OrderingElement newOrdering = new OrderingElement(column, ascending);
        int existingIndex = vector.indexOf(newOrdering);
        if (existingIndex != -1) {
            vector.remove(existingIndex);
        }
        vector.add(0, newOrdering);
        if (vector.size() > MAX_ORDERING_COLS) {
            vector.remove(MAX_ORDERING_COLS);
        }
    }

    public int[] getColumns() {
        int[] columnArray = new int[vector.size()];
        for (int i = 0; i < columnArray.length; i++) {
            columnArray[i] = vector.get(i).column;
        }
        return columnArray;
    }

    public boolean[] getAscendings() {
        boolean[] ascendingArray = new boolean[vector.size()];
        for (int i = 0; i < ascendingArray.length; i++) {
            ascendingArray[i] = vector.get(i).ascending;
        }
        return ascendingArray;
    }

    public String toClause() {
        StringBuffer orderingClause = new StringBuffer();
        for (int index = 0; index < vector.size(); index++) {
            OrderingElement element = vector.get(index);
            orderingClause.append(element.toString());
            if (index + 1 < vector.size()) {
                orderingClause.append(',');
            }
        }
        return orderingClause.toString();
    }
}
