package com.util;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import com.db.Database;
import com.gui.GeneralPurposeDialogs;
import com.model.Profile;
import com.model.Settings;
import com.model.conf.Configuration;


public final class MigrateThread extends Thread {

	private final File from;
	private final Display display;
	private final Text log;
	private final ProgressBar progressBar;
	private final Label profileLabel;
	private String title;
	private int profileNumber;
    private List<Profile> profilesList;
    
	
	public MigrateThread(final File from, final Text log, final ProgressBar progressBar, final Label profileLabel) throws IOException {
		this.from = from;
		this.log = log;
		this.progressBar = progressBar;
		this.profileLabel = profileLabel;
		this.display = log.getShell().getDisplay();
		this.profileNumber = 0;
		
		try {
			Database dbase = Database.getInstance();
			profilesList = dbase.readProfilesList("GAM.TITLE");
			this.progressBar.setMaximum(profilesList.size());
		} catch (SQLException e) {
			profilesList = new ArrayList<Profile>();
			GeneralPurposeDialogs.warningMessage(log.getShell(), e.getMessage());
		}
	}
	
	public void run() {
	    Database dbase = Database.getInstance();
	    final StringBuffer displayedLog = new StringBuffer();
        final StringBuffer messageLog = new StringBuffer();

	    try {
	        for (Profile prof: profilesList) {
	            title = prof.getTitle();

	            try {
	                File file = prof.getCanonicalConfFile();
	                Configuration profileConf = new Configuration(file, true);

	                profileConf.makeRelative(from);
	                profileConf.setValue("dosbox", "captures", FileUtils.constructRelativeCapturesDir(prof.getId()));
	                profileConf.saveToFile(file, false, null);

	                String newConfigPath = prof.getConfPathAndFile(); 
	                if (new File(prof.getConfPathAndFile()).isAbsolute()) {
	                    File newFile = FileUtils.makeRelativeTo(file, from);
	                    if (!newFile.isAbsolute()) {
	                        newConfigPath = FileUtils.DOSROOT_DIR + newFile.getPath();
	                    }
	                }

	                dbase.updateProfileConf(newConfigPath, prof.getCaptures(), prof.getId());

	                String setup = prof.getSetup();
	                if (setup.length() > 0) {
	                    setup = FileUtils.makeRelativeTo(new File(setup), from).getPath();
	                }
	                String[] links = prof.getLinks();
                    for (int i = 0; i < links.length; i++) {
	                    if (links[i].toLowerCase().startsWith("file://")) {
	                        links[i] = links[i].substring(7);
	                    }
	                    if (!links[i].equals("") && !links[i].contains("://")) {
	                        File newFile = FileUtils.makeRelativeTo(new File(links[i]), from);
	                        if (!newFile.isAbsolute()) {
	                            links[i] = FileUtils.DOSROOT_DIR + newFile.getPath();
	                        }
	                    }
	                }
	                dbase.updateProfileSetupAndLinks(setup, links, prof.getId());
	                
	                messageLog.append(profileConf.getParsingProblems());
	            } catch (IOException e) {
	                messageLog.append(e.getMessage()).append('\n');
	            }

	            if (display.isDisposed() || log.isDisposed() || progressBar.isDisposed()) {
	                break;
	            }
	            display.asyncExec(new Runnable() {
	                public void run() {
	                    profileLabel.setText(Settings.getInstance().msg("dialog.migration.migrating", new Object[] {title}));
	                    profileLabel.pack();
	                    if (messageLog.length() > displayedLog.length()) {
	                        String newOutput = messageLog.substring(displayedLog.length());
	                        log.append(newOutput);
	                        displayedLog.append(newOutput);
	                    }
	                    progressBar.setSelection(profileNumber++);
	                }
	            });
	        }
	    } catch (SQLException se) {
	        messageLog.append(se.getMessage());
	        display.asyncExec(new Runnable() {
	            public void run() {
	                if (messageLog.length() > displayedLog.length()) {
                        String newOutput = messageLog.substring(displayedLog.length());
                        log.append(newOutput);
                        displayedLog.append(newOutput);
                    }
	            }
	        });
	    }
	}
}
