package com.util;


public final class StringUtils {

    public static String[] textAreaToStringArray(final String contents, final String del) {
        int start = 0;
        int length = del.length();
        int finish = contents.length();
        while (contents.indexOf(del, start) == start) {
            start += length;
        }
        while (finish >= length && (contents.indexOf(del, finish - length) == (finish - length))) {
            finish -= length;
        }
        return contents.substring(start, finish).split(del);
    }

    public static String[] mountToStringArray(final String paths) {
        if (paths.length() <= 0) {
            return new String[0];
        }
        return paths.split("\" \"");
    }

    public static String intArrayToString(final int[] list) {
        StringBuffer result = new StringBuffer();
        for (int value: list) {
            result.append(value).append(' ');
        }
        return result.toString();
    }

    public static String booleanArrayToString(final boolean[] list) {
        StringBuffer result = new StringBuffer();
        for (boolean value: list) {
            result.append(value).append(' ');
        }
        return result.toString();
    }

    public static String stringArrayToString(final String[] list, final String delimiter) {
        StringBuffer result = new StringBuffer();
        for (String value: list) {
            result.append(value).append(delimiter);
        }
        return result.toString();
    }

    public static int[] stringToIntArray(final String input) {
        if (input.length() <= 0) {
            return new int[0];
        }
        String[] values = input.split(" ");
        int[] result = new int[values.length];
        for (int i = 0; i < values.length; i++) {
            try {
                result[i] = Integer.parseInt(values[i]);
            } catch (NumberFormatException e) {
                result[i] = -1;
            }
        }
        return result;
    }

    public static boolean[] stringToBooleanArray(final String input) {
        if (input.length() <= 0) {
            return new boolean[0];
        }
        String[] values = input.split(" ");
        boolean[] result = new boolean[values.length];
        for (int i = 0; i < values.length; i++) {
            result[i] = Boolean.parseBoolean(values[i]);
        }
        return result;
    }

    public static int countCharacters(final String string, final char charToCount) {
        int result = 0;
        for (int i = 0; i < string.length(); i++) {
            if (string.charAt(i) == charToCount) {
                result++;
            }
        }
        return result;
    }

    public static String shorten(final String s, final int length) {
        if (s == null || s.length() <= length)
            return s;
        return new StringBuffer(s.substring(0, length / 2 - 2)).append("....").append(s.substring(s.length() - length / 2 + 2)).toString();
    }
}
