/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import Common.ByteBuffer;
import Common.LimitedSequentialInStream;
import Common.LockedInStream;
import Common.LockedSequentialInStreamImp;
import Common.LongVector;
import Common.ObjectVector;
import Common.RecordVector;
import SevenZip.Archive.Common.BindInfo;
import SevenZip.Archive.Common.BindPair;
import SevenZip.Archive.Common.CoderMixer2;
import SevenZip.Archive.Common.CoderMixer2ST;
import SevenZip.Archive.Common.CoderStreamsInfo;
import SevenZip.Archive.Common.FilterCoder;
import SevenZip.Archive.SevenZip.AltCoderInfo;
import SevenZip.Archive.SevenZip.BindInfoEx;
import SevenZip.Archive.SevenZip.CoderInfo;
import SevenZip.Archive.SevenZip.Folder;
import SevenZip.Archive.SevenZip.MethodID;
import SevenZip.Compression.Branch.BCJ2_x86_Decoder;
import SevenZip.Compression.Branch.BCJ_x86_Decoder;
import SevenZip.ICompressCoder;
import SevenZip.ICompressCoder2;
import SevenZip.ICompressProgressInfo;
import SevenZip.ICompressSetDecoderProperties2;
import SevenZip.IInStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class Decoder {
    boolean _bindInfoExPrevIsDefined;
    BindInfoEx _bindInfoExPrev;
    boolean _multiThread;
    CoderMixer2ST _mixerCoderSTSpec;
    CoderMixer2 _mixerCoderCommon;
    ICompressCoder2 _mixerCoder;
    ObjectVector<Object> _decoders;

    public Decoder(boolean bl) {
        this._multiThread = bl;
        this._bindInfoExPrevIsDefined = false;
        this._bindInfoExPrev = new BindInfoEx();
        this._mixerCoder = null;
        this._decoders = new ObjectVector();
    }

    static void ConvertFolderItemInfoToBindInfo(Folder folder, BindInfoEx bindInfoEx) {
        int n;
        int n2;
        bindInfoEx.Clear();
        for (n2 = 0; n2 < folder.BindPairs.size(); ++n2) {
            BindPair bindPair = new BindPair();
            bindPair.InIndex = ((BindPair)folder.BindPairs.get((int)n2)).InIndex;
            bindPair.OutIndex = ((BindPair)folder.BindPairs.get((int)n2)).OutIndex;
            bindInfoEx.BindPairs.add(bindPair);
        }
        n2 = 0;
        for (n = 0; n < folder.Coders.size(); ++n) {
            CoderStreamsInfo coderStreamsInfo = new CoderStreamsInfo();
            CoderInfo coderInfo = (CoderInfo)folder.Coders.get(n);
            coderStreamsInfo.NumInStreams = coderInfo.NumInStreams;
            coderStreamsInfo.NumOutStreams = coderInfo.NumOutStreams;
            bindInfoEx.Coders.add(coderStreamsInfo);
            AltCoderInfo altCoderInfo = coderInfo.AltCoders.Front();
            bindInfoEx.CoderMethodIDs.add(altCoderInfo.MethodID);
            int n3 = 0;
            while (n3 < coderStreamsInfo.NumOutStreams) {
                if (folder.FindBindPairForOutStream(n2) < 0) {
                    bindInfoEx.OutStreams.add(n2);
                }
                ++n3;
                ++n2;
            }
        }
        for (n = 0; n < folder.PackStreams.size(); ++n) {
            bindInfoEx.InStreams.add(folder.PackStreams.get(n));
        }
    }

    static boolean AreCodersEqual(CoderStreamsInfo coderStreamsInfo, CoderStreamsInfo coderStreamsInfo2) {
        return coderStreamsInfo.NumInStreams == coderStreamsInfo2.NumInStreams && coderStreamsInfo.NumOutStreams == coderStreamsInfo2.NumOutStreams;
    }

    static boolean AreBindPairsEqual(BindPair bindPair, BindPair bindPair2) {
        return bindPair.InIndex == bindPair2.InIndex && bindPair.OutIndex == bindPair2.OutIndex;
    }

    static boolean AreBindInfoExEqual(BindInfoEx bindInfoEx, BindInfoEx bindInfoEx2) {
        int n;
        if (bindInfoEx.Coders.size() != bindInfoEx2.Coders.size()) {
            return false;
        }
        for (n = 0; n < bindInfoEx.Coders.size(); ++n) {
            if (Decoder.AreCodersEqual((CoderStreamsInfo)bindInfoEx.Coders.get(n), (CoderStreamsInfo)bindInfoEx2.Coders.get(n))) continue;
            return false;
        }
        if (bindInfoEx.BindPairs.size() != bindInfoEx2.BindPairs.size()) {
            return false;
        }
        for (n = 0; n < bindInfoEx.BindPairs.size(); ++n) {
            if (Decoder.AreBindPairsEqual((BindPair)bindInfoEx.BindPairs.get(n), (BindPair)bindInfoEx2.BindPairs.get(n))) continue;
            return false;
        }
        for (n = 0; n < bindInfoEx.CoderMethodIDs.size(); ++n) {
            if (bindInfoEx.CoderMethodIDs.get(n) == bindInfoEx2.CoderMethodIDs.get(n)) continue;
            return false;
        }
        if (bindInfoEx.InStreams.size() != bindInfoEx2.InStreams.size()) {
            return false;
        }
        return bindInfoEx.OutStreams.size() == bindInfoEx2.OutStreams.size();
    }

    int Decode(IInStream iInStream, long l, LongVector longVector, int n, Folder folder, OutputStream outputStream, ICompressProgressInfo iCompressProgressInfo) throws IOException {
        int n2;
        Object object;
        Object object2;
        boolean bl;
        Object object3;
        Object object4;
        int n3;
        ObjectVector<LimitedSequentialInStream> objectVector = new ObjectVector<LimitedSequentialInStream>();
        LockedInStream lockedInStream = new LockedInStream();
        lockedInStream.Init(iInStream);
        for (n3 = 0; n3 < folder.PackStreams.size(); ++n3) {
            object4 = new LockedSequentialInStreamImp();
            LockedSequentialInStreamImp lockedSequentialInStreamImp = object4;
            ((LockedSequentialInStreamImp)object4).Init(lockedInStream, l);
            l += longVector.get(n3 + n);
            LimitedSequentialInStream limitedSequentialInStream = new LimitedSequentialInStream();
            object3 = limitedSequentialInStream;
            limitedSequentialInStream.SetStream(lockedSequentialInStreamImp);
            limitedSequentialInStream.Init(longVector.get(n3 + n));
            objectVector.add((LimitedSequentialInStream)object3);
        }
        n3 = folder.Coders.size();
        object4 = new BindInfoEx();
        Decoder.ConvertFolderItemInfoToBindInfo(folder, (BindInfoEx)object4);
        if (!this._bindInfoExPrevIsDefined) {
            bl = true;
        } else {
            boolean bl2 = bl = !Decoder.AreBindInfoExEqual((BindInfoEx)object4, this._bindInfoExPrev);
        }
        if (bl) {
            this._decoders.clear();
            if (this._mixerCoder != null) {
                this._mixerCoder.close();
            }
            if (this._multiThread) {
                throw new IOException("multithreaded decoder not implemented");
            }
            this._mixerCoderSTSpec = new CoderMixer2ST();
            this._mixerCoder = this._mixerCoderSTSpec;
            this._mixerCoderCommon = this._mixerCoderSTSpec;
            this._mixerCoderCommon.SetBindInfo((BindInfo)object4);
            for (int i = 0; i < n3; ++i) {
                Object object5;
                object3 = (CoderInfo)folder.Coders.get(i);
                AltCoderInfo altCoderInfo = ((CoderInfo)object3).AltCoders.Front();
                if (((CoderInfo)object3).IsSimpleCoder()) {
                    object5 = null;
                    object2 = null;
                    if (altCoderInfo.MethodID.equals(MethodID.k_LZMA)) {
                        object5 = new SevenZip.Compression.LZMA.Decoder();
                    }
                    if (altCoderInfo.MethodID.equals(MethodID.k_PPMD)) {
                        System.out.println("PPMD not implemented");
                    }
                    if (altCoderInfo.MethodID.equals(MethodID.k_BCJ_X86)) {
                        object2 = new BCJ_x86_Decoder();
                    }
                    if (altCoderInfo.MethodID.equals(MethodID.k_Deflate)) {
                        System.out.println("DEFLATE not implemented");
                    }
                    if (altCoderInfo.MethodID.equals(MethodID.k_BZip2)) {
                        System.out.println("BZIP2 not implemented");
                    }
                    if (altCoderInfo.MethodID.equals(MethodID.k_Copy)) {
                        object5 = new SevenZip.Compression.Copy.Decoder();
                    }
                    if (altCoderInfo.MethodID.equals(MethodID.k_7zAES)) {
                        throw new IOException("k_7zAES not implemented");
                    }
                    if (object2 != null) {
                        object = new FilterCoder();
                        object5 = object;
                        object.Filter = object2;
                    }
                    if (object5 == null) {
                        return -2147467263;
                    }
                    this._decoders.add(object5);
                    if (this._multiThread) {
                        throw new IOException("Multithreaded decoder is not implemented");
                    }
                    this._mixerCoderSTSpec.AddCoder((ICompressCoder)object5, false);
                    continue;
                }
                object5 = null;
                if (altCoderInfo.MethodID.equals(MethodID.k_BCJ2)) {
                    object5 = new BCJ2_x86_Decoder();
                }
                if (object5 == null) {
                    return -2147467263;
                }
                this._decoders.add(object5);
                if (this._multiThread) {
                    throw new IOException("Multithreaded decoder is not implemented");
                }
                this._mixerCoderSTSpec.AddCoder2((ICompressCoder2)object5, false);
            }
            this._bindInfoExPrev = object4;
            this._bindInfoExPrevIsDefined = true;
        }
        this._mixerCoderCommon.ReInit();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = (CoderInfo)folder.Coders.get(n2);
            object = object2.AltCoders.Front();
            Object e = this._decoders.get(n6);
            try {
                boolean bl3;
                ICompressSetDecoderProperties2 iCompressSetDecoderProperties2 = (ICompressSetDecoderProperties2)e;
                ByteBuffer byteBuffer = object.Properties;
                int n7 = byteBuffer.GetCapacity();
                if (n7 == -1) {
                    return -2147467263;
                }
                if (n7 > 0 && !(bl3 = iCompressSetDecoderProperties2.SetDecoderProperties2(byteBuffer.data()))) {
                    return -2147467259;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n6;
            int n8 = object2.NumInStreams;
            int n9 = object2.NumOutStreams;
            LongVector longVector2 = new LongVector();
            LongVector longVector3 = new LongVector();
            longVector2.Reserve(n8);
            longVector3.Reserve(n9);
            int n10 = 0;
            while (n10 < n9) {
                longVector3.add(folder.UnPackSizes.get(n5));
                ++n10;
                ++n5;
            }
            n10 = 0;
            while (n10 < n8) {
                int n11 = folder.FindBindPairForInStream(n4);
                if (n11 >= 0) {
                    longVector2.add(folder.UnPackSizes.get(((BindPair)folder.BindPairs.get((int)n11)).OutIndex));
                } else {
                    int n12 = folder.FindPackStreamArrayIndex(n4);
                    if (n12 < 0) {
                        return -2147467259;
                    }
                    longVector2.add(longVector.get(n12));
                }
                ++n10;
                ++n4;
            }
            this._mixerCoderCommon.SetCoderInfo(n2, longVector2, longVector3);
        }
        object2 = new int[1];
        object = new int[1];
        ((BindInfo)object4).FindOutStream(((BindInfoEx)object4).OutStreams.get(0), (int[])object, (int[])object2);
        int n13 = object[0];
        if (this._multiThread) {
            throw new IOException("Multithreaded decoder is not implemented");
        }
        if (n3 == 0) {
            return 0;
        }
        RecordVector<InputStream> recordVector = new RecordVector<InputStream>();
        recordVector.Reserve(objectVector.size());
        for (n2 = 0; n2 < objectVector.size(); ++n2) {
            recordVector.add((InputStream)objectVector.get(n2));
        }
        RecordVector<OutputStream> recordVector2 = new RecordVector<OutputStream>();
        recordVector2.add(outputStream);
        return this._mixerCoder.Code(recordVector, null, objectVector.size(), recordVector2, null, 1, iCompressProgressInfo);
    }
}

