/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSComboBox;
import org.eclipse.swt.internal.cocoa.NSComboBoxCell;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTComboBox;
import org.eclipse.swt.internal.cocoa.SWTPopUpButton;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    int textLimit = LIMIT;
    boolean receivingFocus;
    boolean ignoreVerify;
    boolean ignoreSelection;
    NSRange selectionRange;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        NSString nSString = NSString.stringWith(string);
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            int n = nSPopUpButton.indexOfSelectedItem();
            NSMenu nSMenu = nSPopUpButton.menu();
            NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
            nSMenuItem.initWithTitle(nSString, 0, NSString.stringWith(""));
            nSMenu.addItem(nSMenuItem);
            nSMenuItem.release();
            if (n == -1) {
                nSPopUpButton.selectItemAtIndex(-1);
            }
        } else {
            ((NSComboBox)this.view).addItemWithObjectValue(nSString);
        }
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        if (n < 0 || n > n2) {
            this.error(6);
        }
        NSString nSString = NSString.stringWith(string);
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)this.view;
            int n3 = nSPopUpButton.indexOfSelectedItem();
            NSMenu nSMenu = nSPopUpButton.menu();
            NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
            nSMenuItem.initWithTitle(nSString, 0, NSString.stringWith(""));
            nSMenu.insertItem(nSMenuItem, n);
            nSMenuItem.release();
            if (n3 == -1) {
                nSPopUpButton.selectItemAtIndex(-1);
            }
        } else {
            ((NSComboBox)this.view).insertItemWithObjectValue(nSString, n);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    boolean becomeFirstResponder(int n, int n2) {
        this.receivingFocus = true;
        boolean bl = super.becomeFirstResponder(n, n2);
        this.receivingFocus = false;
        return bl;
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            Point point = this.getSelection();
            point.y = point.x;
            this.setSelection(point);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        NSControl nSControl = (NSControl)this.view;
        NSCell nSCell = nSControl.cell();
        NSSize nSSize = nSCell.cellSize();
        n3 = (int)Math.ceil(nSSize.width);
        n4 = (int)Math.ceil(nSSize.height);
        if ((this.style & 8) == 0) {
            this.ignoreVerify = true;
            NSComboBoxCell nSComboBoxCell = new NSComboBoxCell(nSCell.id);
            NSArray nSArray = nSComboBoxCell.objectValues();
            int n5 = nSArray.count();
            if (n5 > 0) {
                nSComboBoxCell = new NSComboBoxCell(nSComboBoxCell.copy());
                int n6 = 0;
                while (n6 < n5) {
                    id id2 = nSArray.objectAtIndex(n6);
                    nSComboBoxCell.setTitle(new NSString(id2));
                    nSSize = nSComboBoxCell.cellSize();
                    n3 = Math.max(n3, (int)Math.ceil(nSSize.width));
                    ++n6;
                }
                nSComboBoxCell.release();
            }
            this.ignoreVerify = false;
        }
        if (n2 != -1 && ((this.style & 8) != 0 || n2 < n4)) {
            n4 = n2;
        }
        if (n != -1) {
            n3 = n;
        }
        return new Point(n3, n4);
    }

    public void copy() {
        this.checkWidget();
        Point point = this.getSelection();
        if (point.x == point.y) {
            return;
        }
        this.copyToClipboard(this.getText(point.x, point.y));
    }

    void createHandle() {
        if ((this.style & 8) != 0) {
            NSPopUpButton nSPopUpButton = (NSPopUpButton)new SWTPopUpButton().alloc();
            nSPopUpButton.initWithFrame(new NSRect(), false);
            nSPopUpButton.menu().setAutoenablesItems(false);
            nSPopUpButton.setTarget(nSPopUpButton);
            nSPopUpButton.setAction(OS.sel_sendSelection);
            this.view = nSPopUpButton;
        } else {
            NSComboBox nSComboBox = (NSComboBox)new SWTComboBox().alloc();
            nSComboBox.init();
            nSComboBox.setDelegate(nSComboBox);
            nSComboBox.setTarget(nSComboBox);
            nSComboBox.setAction(OS.sel_sendSelection);
            this.view = nSComboBox;
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point point = this.getSelection();
        if (point.x == point.y) {
            return;
        }
        int n = point.x;
        int n2 = point.y;
        String string = this.getText();
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2, string.length());
        String string4 = string.substring(n, n2);
        String string5 = "";
        if ((this.hooks(25) || this.filters(25)) && (string5 = this.verifyText(string5, n, n2, null)) == null) {
            return;
        }
        char[] cArray = new char[string4.length()];
        string4.getChars(0, cArray.length, cArray, 0);
        this.copyToClipboard(cArray);
        this.setText(String.valueOf(string2) + string5 + string3, false);
        this.setSelection(new Point(n += string5.length(), n));
        this.sendEvent(24);
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        if ((this.style & 8) != 0) {
            return this.display.popUpButtonFont;
        }
        return this.display.comboBoxFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(((NSControl)this.view).cell());
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n == -1) {
            return;
        }
        if (n == this.getSelectionIndex()) {
            if ((this.style & 8) != 0) {
                ((NSPopUpButton)this.view).selectItem(null);
                this.sendEvent(24);
            } else {
                ((NSComboBox)this.view).deselectItemAtIndex(n);
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).selectItem(null);
            this.sendEvent(24);
        } else {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            int n = nSComboBox.indexOfSelectedItem();
            if (n != -1) {
                nSComboBox.deselectItemAtIndex(n);
            }
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        if ((this.style & 8) == 0) {
            NSText nSText = ((NSControl)this.view).currentEditor();
            if (nSText != null) {
                NSPoint nSPoint;
                NSTextView nSTextView;
                int n3;
                NSRange nSRange = nSText.selectedRange();
                if (nSRange.length > 0 && (n3 = (nSTextView = new NSTextView(nSText)).characterIndexForInsertionAtPoint(nSPoint = NSEvent.mouseLocation())) != Integer.MAX_VALUE && n3 >= nSRange.location && n3 < nSRange.location + nSRange.length && super.dragDetect(n, n2, bl, blArray)) {
                    if (blArray != null) {
                        blArray[0] = true;
                    }
                    return true;
                }
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, blArray);
    }

    int getCharCount() {
        NSString nSString = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).titleOfSelectedItem() : new NSCell(((NSComboBox)this.view).cell()).title();
        if (nSString == null) {
            return 0;
        }
        return nSString.length();
    }

    public String getItem(int n) {
        NSString nSString;
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        if ((nSString = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).itemTitleAtIndex(n) : new NSString(((NSComboBox)this.view).itemObjectValueAtIndex(n))) == null) {
            this.error(8);
        }
        return nSString.getString();
    }

    public int getItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return ((NSPopUpButton)this.view).numberOfItems();
        }
        return ((NSComboBox)this.view).numberOfItems();
    }

    public int getItemHeight() {
        this.checkWidget();
        return 26;
    }

    public String[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    public boolean getListVisible() {
        return false;
    }

    int getMininumHeight() {
        return this.getTextHeight();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, this.getCharCount());
        }
        if (this.selectionRange == null) {
            NSString nSString = new NSTextFieldCell(((NSTextField)this.view).cell()).title();
            return new Point(nSString.length(), nSString.length());
        }
        return new Point(this.selectionRange.location, this.selectionRange.location + this.selectionRange.length);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return ((NSPopUpButton)this.view).indexOfSelectedItem();
        }
        return ((NSComboBox)this.view).indexOfSelectedItem();
    }

    public String getText() {
        this.checkWidget();
        return new String(this.getText(0, -1));
    }

    char[] getText(int n, int n2) {
        NSString nSString = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).titleOfSelectedItem() : new NSCell(((NSComboBox)this.view).cell()).title();
        if (nSString == null) {
            return new char[0];
        }
        NSRange nSRange = new NSRange();
        nSRange.location = n;
        if (n2 == -1) {
            int n3 = nSString.length();
            nSRange.length = n3 - n;
        } else {
            nSRange.length = n2 - n;
        }
        char[] cArray = new char[nSRange.length];
        nSString.getCharacters(cArray, nSRange);
        return cArray;
    }

    public int getTextHeight() {
        this.checkWidget();
        NSCell nSCell = (this.style & 8) != 0 ? ((NSPopUpButton)this.view).cell() : ((NSComboBox)this.view).cell();
        return (int)nSCell.cellSize().height;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return this.getItemCount();
        }
        return ((NSComboBox)this.view).numberOfVisibleItems();
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            return -1;
        }
        int n3 = n;
        while (n3 < n2) {
            if (string.equals(this.getItem(n3))) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    void insertEditText(String string) {
        this.ignoreVerify = true;
        int n = string.length();
        Point point = this.getSelection();
        if (this.hasFocus()) {
            int n2;
            if (this.textLimit != LIMIT && (n2 = this.getCharCount()) - (point.y - point.x) + n > this.textLimit) {
                n = this.textLimit - n2 + (point.y - point.x);
            }
            char[] cArray = new char[n];
            string.getChars(0, cArray.length, cArray, 0);
            NSString nSString = NSString.stringWithCharacters(cArray, cArray.length);
            NSText nSText = ((NSTextField)this.view).currentEditor();
            nSText.replaceCharactersInRange(nSText.selectedRange(), nSString);
            this.selectionRange = null;
        } else {
            int n3;
            String string2 = this.getText();
            if (this.textLimit != LIMIT && (n3 = string2.length()) - (point.y - point.x) + n > this.textLimit) {
                string = string.substring(0, this.textLimit - n3 + (point.y - point.x));
            }
            String string3 = String.valueOf(string2.substring(0, point.x)) + string + string2.substring(point.y);
            NSString nSString = NSString.stringWith(string3);
            new NSCell(((NSTextField)this.view).cell()).setTitle(nSString);
            this.selectionRange = null;
            this.setSelection(new Point(point.x + string.length(), 0));
        }
        this.ignoreVerify = false;
    }

    boolean isEventView(int n) {
        return true;
    }

    void mouseDown(int n, int n2, int n3) {
        NSView nSView = this.view;
        nSView.retain();
        super.mouseDown(n, n2, n3);
        nSView.release();
    }

    public void paste() {
        int n;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        Point point = this.getSelection();
        int n2 = point.x;
        int n3 = point.y;
        String string = this.getText();
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n3, string.length());
        String string4 = this.getClipboardText();
        if (string4 == null) {
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string4 = this.verifyText(string4, n2, n3, null)) == null) {
            return;
        }
        if (this.textLimit != LIMIT && (n = string.length()) - (n3 - n2) + string4.length() > this.textLimit) {
            string4 = string4.substring(0, this.textLimit - n + (n3 - n2));
        }
        this.setText(String.valueOf(string2) + string4 + string3, false);
        this.setSelection(new Point(n2 += string4.length(), n2));
        this.sendEvent(24);
    }

    void register() {
        super.register();
        this.display.addWidget(((NSControl)this.view).cell(), this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if ((this.style & 8) == 0) {
            ((NSControl)this.view).abortEditing();
        }
        this.selectionRange = null;
    }

    public void remove(int n) {
        this.checkWidget();
        if (n == -1) {
            this.error(6);
        }
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).removeItemAtIndex(n);
        } else {
            ((NSComboBox)this.view).removeItemAtIndex(n);
        }
    }

    public void remove(int n, int n2) {
        int n3;
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n4 = this.getItemCount();
        if (n < 0 || n > n2 || n2 >= n4) {
            this.error(6);
        }
        int n5 = n3 = Math.min(n2, n4 - 1);
        while (n5 >= n) {
            this.remove(n5);
            --n5;
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).removeAllItems();
        } else {
            this.setText("", true);
            ((NSComboBox)this.view).removeAllItems();
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        this.ignoreSelection = true;
        if (n >= 0 && n < n2) {
            if ((this.style & 8) != 0) {
                ((NSPopUpButton)this.view).selectItemAtIndex(n);
            } else {
                ((NSComboBox)this.view).selectItemAtIndex(n);
            }
        }
        this.ignoreSelection = false;
        this.sendEvent(24);
    }

    void sendSelection() {
        this.sendEvent(24);
        if (!this.ignoreSelection) {
            this.postEvent(13);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        int n2 = 0;
        int n3 = nSEvent.modifierFlags();
        if ((n3 & 0x80000) != 0) {
            n2 |= 0x10000;
        }
        if ((n3 & 0x20000) != 0) {
            n2 |= 0x20000;
        }
        if ((n3 & 0x40000) != 0) {
            n2 |= 0x40000;
        }
        if ((n3 & 0x100000) != 0) {
            n2 |= 0x400000;
        }
        if (n != 1) {
            return bl;
        }
        short s = nSEvent.keyCode();
        if (n2 == 0x400000) {
            switch (s) {
                case 7: {
                    this.cut();
                    return false;
                }
                case 8: {
                    this.copy();
                    return false;
                }
                case 9: {
                    this.paste();
                    return false;
                }
                case 0: {
                    if ((this.style & 8) != 0) break;
                    ((NSComboBox)this.view).selectText(null);
                    return false;
                }
            }
        }
        switch (s) {
            case 36: 
            case 76: {
                this.postEvent(14);
            }
        }
        return bl;
    }

    void updateBackground() {
        NSColor nSColor = null;
        nSColor = this.backgroundImage != null ? NSColor.colorWithPatternImage(this.backgroundImage.handle) : (this.background != null ? NSColor.colorWithDeviceRed(this.background[0], this.background[1], this.background[2], this.background[3]) : NSColor.textBackgroundColor());
        if ((this.style & 8) == 0) {
            ((NSTextField)this.view).setBackgroundColor(nSColor);
        }
    }

    void setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if ((this.style & 8) == 0) {
            NSControl nSControl = (NSControl)this.view;
            NSSize nSSize = nSControl.cell().cellSize();
            n4 = Math.min(n4, (int)Math.ceil(nSSize.height));
        }
        super.setBounds(n, n2, n3, n4, bl, bl2);
    }

    void setForeground(float[] fArray) {
        NSColor nSColor = fArray == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], 1.0f);
        if ((this.style & 8) == 0) {
            ((NSTextField)this.view).setTextColor(nSColor);
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        NSString nSString = NSString.stringWith(string);
        if ((this.style & 8) != 0) {
            NSMenuItem nSMenuItem = ((NSPopUpButton)this.view).itemAtIndex(n);
            nSMenuItem.setTitle(nSString);
        } else {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            nSComboBox.insertItemWithObjectValue(nSString, n);
            nSComboBox.removeItemAtIndex(n + 1);
        }
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                this.error(5);
            }
            ++n;
        }
        this.removeAll();
        if (stringArray.length == 0) {
            return;
        }
        n = 0;
        while (n < stringArray.length) {
            NSString nSString = NSString.stringWith(stringArray[n]);
            if ((this.style & 8) != 0) {
                NSMenu nSMenu = ((NSPopUpButton)this.view).menu();
                NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
                nSMenuItem.initWithTitle(nSString, 0, NSString.stringWith(""));
                nSMenu.addItem(nSMenuItem);
                nSMenuItem.release();
                ((NSPopUpButton)this.view).selectItemAtIndex(-1);
            } else {
                ((NSComboBox)this.view).addItemWithObjectValue(nSString);
            }
            ++n;
        }
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            ((NSPopUpButton)this.view).setPullsDown(bl);
        }
    }

    public void setOrientation(int n) {
        this.checkWidget();
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((this.style & 8) == 0) {
            NSComboBox nSComboBox = (NSComboBox)this.view;
            NSString nSString = new NSCell(nSComboBox.cell()).title();
            int n = nSString.length();
            int n2 = Math.min(Math.max(Math.min(point.x, point.y), 0), n);
            int n3 = Math.min(Math.max(Math.max(point.x, point.y), 0), n);
            this.selectionRange = new NSRange();
            this.selectionRange.location = n2;
            this.selectionRange.length = n3 - n2;
            NSText nSText = nSComboBox.currentEditor();
            if (nSText != null) {
                nSText.setSelectedRange(this.selectionRange);
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.setText(string, true);
    }

    void setText(String string, boolean bl) {
        this.ignoreVerify = true;
        if (bl && (this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if ((this.style & 8) != 0) {
            int n = this.indexOf(string);
            if (n != -1 && n != this.getSelectionIndex()) {
                this.select(n);
                if (bl) {
                    this.sendEvent(24);
                }
            }
        } else {
            char[] cArray = new char[Math.min(string.length(), this.textLimit)];
            string.getChars(0, cArray.length, cArray, 0);
            NSString nSString = NSString.stringWithCharacters(cArray, cArray.length);
            new NSCell(((NSComboBox)this.view).cell()).setTitle(nSString);
            if (bl) {
                this.sendEvent(24);
            }
        }
        this.selectionRange = null;
        this.ignoreVerify = false;
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        this.textLimit = n;
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if ((this.style & 8) == 0) {
            ((NSComboBox)this.view).setNumberOfVisibleItems(n);
        }
    }

    boolean shouldChangeTextInRange_replacementString(int n, int n2, int n3, int n4) {
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, n3, NSRange.sizeof);
        boolean bl = this.callSuperBoolean(n, n2, nSRange, n4);
        if (this.hooks(25)) {
            String string;
            String string2 = new NSString(n4).getString();
            NSEvent nSEvent = this.display.application.currentEvent();
            int n5 = nSEvent.type();
            if (n5 != 10 && n5 != 11) {
                nSEvent = null;
            }
            if ((string = this.verifyText(string2, nSRange.location, nSRange.location + nSRange.length, nSEvent)) == null) {
                return false;
            }
            if (string2 != string) {
                this.insertEditText(string);
                bl = false;
            }
            if (!bl) {
                this.sendEvent(24);
            }
        }
        return bl;
    }

    void textViewDidChangeSelection(int n, int n2, int n3) {
        NSNotification nSNotification = new NSNotification(n3);
        NSText nSText = new NSText(nSNotification.object().id);
        this.selectionRange = nSText.selectedRange();
    }

    void textDidChange(int n, int n2, int n3) {
        super.textDidChange(n, n2, n3);
        this.postEvent(24);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(int n, int n2, int n3, int n4, int n5) {
        if (this.receivingFocus && this.selectionRange != null) {
            return this.selectionRange;
        }
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, n5, NSRange.sizeof);
        return nSRange;
    }

    String verifyText(String string, int n, int n2, NSEvent nSEvent) {
        Event event = new Event();
        if (nSEvent != null) {
            this.setKeyState(event, 3, nSEvent);
        }
        event.text = string;
        event.start = n;
        event.end = n2;
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

