/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOpenPanel;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSResponder;
import org.eclipse.swt.internal.cocoa.NSSavePanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    NSSavePanel panel;
    NSPopUpButton popup;
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    int filterIndex = -1;
    boolean overwrite = false;
    static final char EXTENSION_SEPARATOR = ';';

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        if (Display.getSheetEnabled() && shell != null && (n & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        NSObject nSObject;
        NSObject nSObject2;
        NSResponder nSResponder;
        NSSavePanel nSSavePanel;
        String string = null;
        this.fileNames = new String[0];
        int n = 0;
        int n2 = 0;
        Callback callback = null;
        if ((this.style & 0x2000) != 0) {
            this.panel = nSSavePanel = NSSavePanel.savePanel();
            if (!this.overwrite) {
                callback = new Callback(this, "_overwriteExistingFileCheck", 3);
                int n3 = callback.getAddress();
                if (n3 == 0) {
                    this.error(3);
                }
                if ((n = OS.class_getInstanceMethod(OS.class_NSSavePanel, OS.sel_overwriteExistingFileCheck)) != 0) {
                    n2 = OS.method_setImplementation(n, n3);
                }
            }
        } else {
            nSSavePanel = NSOpenPanel.openPanel();
            ((NSOpenPanel)nSSavePanel).setAllowsMultipleSelection((this.style & 2) != 0);
            this.panel = nSSavePanel;
        }
        this.panel.setCanCreateDirectories(true);
        int n4 = 0;
        SWTPanelDelegate sWTPanelDelegate = null;
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            sWTPanelDelegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
            n4 = OS.NewGlobalRef(this);
            if (n4 == 0) {
                SWT.error(2);
            }
            OS.object_setInstanceVariable(sWTPanelDelegate.id, Display.SWT_OBJECT, n4);
            this.panel.setDelegate(sWTPanelDelegate);
            nSResponder = (NSPopUpButton)new NSPopUpButton().alloc();
            ((NSPopUpButton)nSResponder).initWithFrame(new NSRect(), false);
            ((NSControl)nSResponder).setTarget(sWTPanelDelegate);
            ((NSControl)nSResponder).setAction(OS.sel_sendSelection_);
            nSObject2 = ((NSPopUpButton)nSResponder).menu();
            ((NSMenu)nSObject2).setAutoenablesItems(false);
            int n5 = 0;
            while (n5 < this.filterExtensions.length) {
                String string2 = this.filterExtensions[n5];
                if (this.filterNames != null && this.filterNames.length > n5) {
                    string2 = this.filterNames[n5];
                }
                nSObject = (NSMenuItem)new NSMenuItem().alloc();
                ((NSMenuItem)nSObject).initWithTitle(NSString.stringWith(string2), 0, NSString.stringWith(""));
                ((NSMenu)nSObject2).addItem((NSMenuItem)nSObject);
                nSObject.release();
                ++n5;
            }
            ((NSPopUpButton)nSResponder).selectItemAtIndex(this.filterIndex >= 0 && this.filterIndex < this.filterExtensions.length ? this.filterIndex : 0);
            ((NSControl)nSResponder).sizeToFit();
            this.panel.setAccessoryView((NSView)nSResponder);
            this.popup = nSResponder;
        }
        this.panel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        nSResponder = NSApplication.sharedApplication();
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            ((NSApplication)nSResponder).beginSheet(this.panel, this.parent.window, null, 0, 0);
        }
        nSObject2 = this.filterPath != null ? NSString.stringWith(this.filterPath) : null;
        NSString nSString = this.fileName != null ? NSString.stringWith(this.fileName) : null;
        int n6 = this.panel.runModalForDirectory((NSString)nSObject2, nSString);
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            ((NSApplication)nSResponder).endSheet(this.panel, 0);
        }
        if (!this.overwrite) {
            if (n != 0) {
                OS.method_setImplementation(n, n2);
            }
            if (callback != null) {
                callback.dispose();
            }
        }
        if (n6 == 1) {
            nSObject = this.panel.filename();
            string = ((NSString)nSObject).getString();
            if ((this.style & 0x2000) == 0) {
                NSArray nSArray = ((NSOpenPanel)this.panel).filenames();
                int n7 = nSArray.count();
                this.fileNames = new String[n7];
                int n8 = 0;
                while (n8 < n7) {
                    nSObject = new NSString(nSArray.objectAtIndex(n8));
                    NSString nSString2 = ((NSString)nSObject).lastPathComponent();
                    NSString nSString3 = ((NSString)nSObject).stringByDeletingLastPathComponent();
                    if (n8 == 0) {
                        this.filterPath = nSString3.getString();
                        this.fileName = this.fileNames[0] = nSString2.getString();
                    } else {
                        this.fileNames[n8] = nSString3.getString().equals(this.filterPath) ? nSString2.getString() : ((NSString)nSObject).getString();
                    }
                    ++n8;
                }
            }
            this.filterIndex = -1;
        }
        if (this.popup != null) {
            this.filterIndex = this.popup.indexOfSelectedItem();
            this.panel.setAccessoryView(null);
            this.popup.release();
            this.popup = null;
        }
        if (sWTPanelDelegate != null) {
            this.panel.setDelegate(null);
            sWTPanelDelegate.release();
        }
        if (n4 != 0) {
            OS.DeleteGlobalRef(n4);
        }
        this.panel = null;
        return string;
    }

    int _overwriteExistingFileCheck(int n, int n2, int n3) {
        return 1;
    }

    int panel_shouldShowFilename(int n, int n2, int n3, int n4) {
        NSString nSString = new NSString(n4);
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            NSFileManager nSFileManager = NSFileManager.defaultManager();
            int n5 = OS.malloc(1);
            boolean bl = nSFileManager.fileExistsAtPath(nSString, n5);
            byte[] byArray = new byte[1];
            OS.memmove(byArray, n5, 1);
            OS.free(n5);
            if (bl) {
                if (byArray[0] != 0) {
                    return 1;
                }
                NSString nSString2 = nSString.pathExtension();
                if (nSString2 != null) {
                    int n6 = this.popup.indexOfSelectedItem();
                    String string = nSString2.getString();
                    String string2 = this.filterExtensions[n6];
                    int n7 = 0;
                    int n8 = string2.length();
                    while (n7 < n8) {
                        String string3;
                        int n9 = string2.indexOf(59, n7);
                        if (n9 == -1) {
                            n9 = n8;
                        }
                        if ((string3 = string2.substring(n7, n9).trim()).equals("*") || string3.equals("*.*")) {
                            return 1;
                        }
                        if (string3.startsWith("*.")) {
                            string3 = string3.substring(2);
                        }
                        if (string3.toLowerCase().equals(string.toLowerCase())) {
                            return 1;
                        }
                        n7 = n9 + 1;
                    }
                }
                return 0;
            }
        }
        return 1;
    }

    void sendSelection(int n, int n2, int n3) {
        this.panel.validateVisibleColumns();
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }
}

