/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSNumberFormatter;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSStepper;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTStepper;
import org.eclipse.swt.internal.cocoa.SWTTextField;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    NSTextField textView;
    NSNumberFormatter textFormatter;
    NSStepper buttonView;
    int pageIncrement = 10;
    int digits = 0;
    int textLimit = LIMIT;
    static int GAP = 0;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Spinner(Composite composite, int n) {
        super(composite, Spinner.checkStyle(n));
    }

    boolean acceptsFirstResponder(int n, int n2) {
        if (n == this.view.id) {
            return false;
        }
        return super.acceptsFirstResponder(n, n2);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        float f = 0.0f;
        float f2 = 0.0f;
        String string = Double.toString(this.buttonView.maxValue());
        Font font = Font.cocoa_new(this.display, this.textView.font());
        NSAttributedString nSAttributedString = this.parent.createString(string, font, null, 0, true, false);
        NSSize nSSize = nSAttributedString.size();
        nSAttributedString.release();
        f = nSSize.width;
        f2 = nSSize.height;
        NSRect nSRect = this.textView.frame();
        NSCell nSCell = new NSCell(this.textView.cell());
        NSRect nSRect2 = nSCell.drawingRectForBounds(nSRect);
        f += nSRect.width - nSRect2.width;
        f2 += nSRect.height - nSRect2.height;
        f += (float)GAP;
        nSSize = this.buttonView.cell().cellSize();
        f += (float)((int)nSSize.width);
        f2 = Math.max(f2, nSSize.height);
        if (n != -1) {
            f = n;
        }
        if (n2 != -1) {
            f2 = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, (int)Math.ceil(f), (int)Math.ceil(f2));
        return new Point(rectangle.width, rectangle.height);
    }

    public void copy() {
        this.checkWidget();
        NSText nSText = this.textView.currentEditor();
        if (nSText != null) {
            nSText.copy(null);
        }
    }

    void createHandle() {
        NSView nSView = (NSView)new SWTView().alloc();
        nSView.init();
        NSStepper nSStepper = (NSStepper)new SWTStepper().alloc();
        nSStepper.init();
        nSStepper.setValueWraps((this.style & 0x40) != 0);
        nSStepper.setTarget(nSStepper);
        nSStepper.setAction(OS.sel_sendSelection);
        nSStepper.setMaxValue(100.0);
        NSTextField nSTextField = (NSTextField)new SWTTextField().alloc();
        nSTextField.init();
        nSTextField.setEditable((this.style & 8) == 0);
        this.textFormatter = (NSNumberFormatter)new NSNumberFormatter().alloc();
        this.textFormatter.init();
        nSView.addSubview(nSTextField);
        nSView.addSubview(nSStepper);
        this.buttonView = nSStepper;
        this.textView = nSTextField;
        this.view = nSView;
        this.setSelection(0, false, true, false);
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        NSText nSText = this.textView.currentEditor();
        if (nSText != null) {
            nSText.cut(null);
        }
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        this.buttonView.setEnabled(bl);
        this.textView.setEnabled(bl);
    }

    NSFont defaultNSFont() {
        return this.display.textFieldFont;
    }

    void deregister() {
        super.deregister();
        if (this.textView != null) {
            this.display.removeWidget(this.textView);
            this.display.removeWidget(this.textView.cell());
        }
        if (this.buttonView != null) {
            this.display.removeWidget(this.buttonView);
            this.display.removeWidget(this.buttonView.cell());
        }
    }

    NSView focusView() {
        return this.textView;
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    public int getIncrement() {
        this.checkWidget();
        return (int)this.buttonView.increment();
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)this.buttonView.maxValue();
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)this.buttonView.minValue();
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return (int)this.buttonView.doubleValue();
    }

    int getSelectionText(boolean[] blArray) {
        String string = this.textView.stringValue().getString();
        try {
            int n;
            int n2;
            if (this.digits > 0) {
                String string2 = this.textFormatter.decimalSeparator().getString();
                n2 = string.indexOf(string2);
                if (n2 != -1) {
                    int n3;
                    int n4;
                    int n5 = string.startsWith("+") || string.startsWith("-") ? 1 : 0;
                    String string3 = n5 != n2 ? string.substring(n5, n2) : "0";
                    String string4 = string.substring(n2 + 1);
                    if (string4.length() > this.digits) {
                        string4 = string4.substring(0, this.digits);
                    } else {
                        n4 = this.digits - string4.length();
                        n3 = 0;
                        while (n3 < n4) {
                            string4 = String.valueOf(string4) + "0";
                            ++n3;
                        }
                    }
                    n4 = Integer.parseInt(string3);
                    n3 = Integer.parseInt(string4);
                    int n6 = 0;
                    while (n6 < this.digits) {
                        n4 *= 10;
                        ++n6;
                    }
                    n = n4 + n3;
                    if (string.startsWith("-")) {
                        n = -n;
                    }
                } else {
                    n = Integer.parseInt(string);
                    int n7 = 0;
                    while (n7 < this.digits) {
                        n *= 10;
                        ++n7;
                    }
                }
            } else {
                n = Integer.parseInt(string);
            }
            int n8 = this.getMaximum();
            n2 = this.getMinimum();
            if (n2 <= n && n <= n8) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        blArray[0] = true;
        return -1;
    }

    public String getText() {
        this.checkWidget();
        NSString nSString = new NSTextFieldCell(this.textView.cell()).title();
        return nSString.getString();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    boolean isEventView(int n) {
        return true;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        NSText nSText = this.textView.currentEditor();
        if (nSText != null) {
            nSText.paste(null);
        }
    }

    void register() {
        super.register();
        if (this.textView != null) {
            this.display.addWidget(this.textView, this);
            this.display.addWidget(this.textView.cell(), this);
        }
        if (this.buttonView != null) {
            this.display.addWidget(this.buttonView, this);
            this.display.addWidget(this.buttonView.cell(), this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.textFormatter != null) {
            this.textFormatter.release();
        }
        if (this.buttonView != null) {
            this.buttonView.release();
        }
        if (this.textView != null) {
            this.textView.release();
        }
        this.textFormatter = null;
        this.buttonView = null;
        this.textView = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.textView != null) {
            this.textView.abortEditing();
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    void resized() {
        super.resized();
        this.buttonView.sizeToFit();
        NSSize nSSize = this.textView.cell().cellSize();
        NSRect nSRect = this.buttonView.bounds();
        NSRect nSRect2 = this.view.frame();
        nSRect.x = nSRect2.width - nSRect.width;
        nSRect.y = (nSRect2.height - nSRect.height) / 2.0f;
        int n = (int)Math.min(nSSize.height, nSRect2.height);
        nSRect2.x = 0.0f;
        nSRect2.y = (nSRect2.height - (float)n) / 2.0f;
        nSRect2.width -= nSRect.width + (float)GAP;
        nSRect2.height = n;
        this.textView.setFrame(nSRect2);
        this.buttonView.setFrame(nSRect);
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        if (n != 1) {
            return bl;
        }
        int n2 = 0;
        short s = nSEvent.keyCode();
        switch (s) {
            case 36: 
            case 76: {
                this.postEvent(14);
                return true;
            }
            case 116: {
                n2 = this.pageIncrement;
                break;
            }
            case 121: {
                n2 = -this.pageIncrement;
                break;
            }
            case 125: {
                n2 = -this.getIncrement();
                break;
            }
            case 126: {
                n2 = this.getIncrement();
            }
        }
        if (n2 != 0) {
            boolean[] blArray = new boolean[1];
            int n3 = this.getSelectionText(blArray);
            if (blArray[0]) {
                n3 = (int)this.buttonView.doubleValue();
            }
            int n4 = n3 + n2;
            int n5 = (int)this.buttonView.maxValue();
            int n6 = (int)this.buttonView.minValue();
            if ((this.style & 0x40) != 0) {
                if (n4 > n5) {
                    n4 = n6;
                }
                if (n4 < n6) {
                    n4 = n5;
                }
            }
            if (n3 != (n4 = Math.min(Math.max(n6, n4), n5))) {
                this.setSelection(n4, true, true, true);
            }
            bl = false;
        } else {
            int n7;
            boolean[] blArray = new boolean[1];
            int n8 = this.getSelectionText(blArray);
            if (!blArray[0] && (n7 = (int)this.buttonView.doubleValue()) != n8) {
                this.setSelection(n8, true, false, true);
            }
        }
        return bl;
    }

    void sendSelection() {
        this.setSelection(this.getSelection(), false, true, true);
    }

    void updateBackground() {
        NSColor nSColor = null;
        nSColor = this.backgroundImage != null ? NSColor.colorWithPatternImage(this.backgroundImage.handle) : (this.background != null ? NSColor.colorWithDeviceRed(this.background[0], this.background[1], this.background[2], this.background[3]) : NSColor.textBackgroundColor());
        this.textView.setBackgroundColor(nSColor);
    }

    public void setDigits(int n) {
        this.checkWidget();
        if (n < 0) {
            this.error(5);
        }
        if (n == this.digits) {
            return;
        }
        this.digits = n;
        int n2 = (int)this.buttonView.doubleValue();
        this.setSelection(n2, false, true, false);
    }

    void setFont(NSFont nSFont) {
        this.textView.setFont(nSFont);
    }

    void setForeground(float[] fArray) {
        NSColor nSColor = fArray == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], 1.0f);
        this.textView.setTextColor(nSColor);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.buttonView.setIncrement(n);
    }

    public void setMaximum(int n) {
        this.checkWidget();
        int n2 = this.getMinimum();
        if (n <= n2) {
            return;
        }
        int n3 = this.getSelection();
        this.buttonView.setMaxValue(n);
        if (n3 > n) {
            this.setSelection(n, true, true, false);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        int n2 = this.getMaximum();
        if (n >= n2) {
            return;
        }
        int n3 = this.getSelection();
        this.buttonView.setMinValue(n);
        if (n3 < n) {
            this.setSelection(n, true, true, false);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.pageIncrement = n;
    }

    public void setSelection(int n) {
        this.checkWidget();
        int n2 = this.getMinimum();
        int n3 = this.getMaximum();
        n = Math.min(Math.max(n2, n), n3);
        this.setSelection(n, true, true, false);
    }

    void setSelection(int n, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.buttonView.setDoubleValue(n);
        }
        if (bl2) {
            Object object;
            int n2;
            Object object2;
            String string = String.valueOf(n);
            if (this.digits > 0) {
                object2 = this.textFormatter.decimalSeparator().getString();
                n2 = string.length() - this.digits;
                object = new StringBuffer();
                if (n2 > 0) {
                    ((StringBuffer)object).append(string.substring(0, n2));
                    ((StringBuffer)object).append((String)object2);
                    ((StringBuffer)object).append(string.substring(n2));
                } else {
                    ((StringBuffer)object).append("0");
                    ((StringBuffer)object).append((String)object2);
                    while (n2++ < 0) {
                        ((StringBuffer)object).append("0");
                    }
                    ((StringBuffer)object).append(string);
                }
                string = ((StringBuffer)object).toString();
            }
            object2 = new NSCell(this.textView.cell());
            if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, n2 = ((NSCell)object2).title().length(), null)) == null) {
                return;
            }
            this.textView.setStringValue(NSString.stringWith(string));
            NSRange nSRange = new NSRange();
            nSRange.location = 0;
            nSRange.length = string.length();
            object = this.textView.currentEditor();
            if (object != null) {
                ((NSText)object).setSelectedRange(nSRange);
            }
            this.sendEvent(24);
        }
        if (bl3) {
            this.postEvent(13);
        }
    }

    void setSmallSize() {
        this.textView.cell().setControlSize(1);
        this.buttonView.cell().setControlSize(1);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        this.textLimit = n;
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n3 <= n2) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        n = Math.min(Math.max(n2, n), n3);
        this.pageIncrement = n6;
        this.digits = n4;
        this.buttonView.setIncrement(n5);
        this.buttonView.setMaxValue(n3);
        this.buttonView.setMinValue(n2);
        this.setSelection(n, true, true, false);
    }

    boolean shouldChangeTextInRange_replacementString(int n, int n2, int n3, int n4) {
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, n3, NSRange.sizeof);
        boolean bl = this.callSuperBoolean(n, n2, nSRange, n4);
        if (this.hooks(25)) {
            String string;
            String string2 = new NSString(n4).getString();
            NSEvent nSEvent = this.display.application.currentEvent();
            int n5 = nSEvent.type();
            if (n5 != 10 && n5 != 11) {
                nSEvent = null;
            }
            if ((string = this.verifyText(string2, nSRange.location, nSRange.location + nSRange.length, nSEvent)) == null) {
                return false;
            }
            if (string2 != string) {
                int n6 = string.length();
                NSText nSText = this.textView.currentEditor();
                if (nSText != null) {
                    int n7;
                    NSRange nSRange2 = nSText.selectedRange();
                    if (this.textLimit != LIMIT && (n7 = nSText.string().length()) - nSRange2.length + n6 > this.textLimit) {
                        n6 = this.textLimit - n7 + nSRange2.length;
                    }
                    char[] cArray = new char[n6];
                    string.getChars(0, cArray.length, cArray, 0);
                    NSString nSString = NSString.stringWithCharacters(cArray, cArray.length);
                    nSText.replaceCharactersInRange(nSText.selectedRange(), nSString);
                    bl = false;
                }
            }
            if (!bl) {
                this.sendEvent(24);
            }
        }
        return bl;
    }

    void textDidChange(int n, int n2, int n3) {
        int n4;
        super.textDidChange(n, n2, n3);
        boolean[] blArray = new boolean[1];
        int n5 = this.getSelectionText(blArray);
        if (!blArray[0] && n5 != (n4 = (int)this.buttonView.doubleValue())) {
            this.setSelection(n5, true, false, true);
        }
        this.postEvent(24);
    }

    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(int n, int n2, int n3, int n4, int n5) {
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, n5, NSRange.sizeof);
        return nSRange;
    }

    void textDidEndEditing(int n, int n2, int n3) {
        boolean[] blArray = new boolean[1];
        int n4 = this.getSelectionText(blArray);
        if (blArray[0]) {
            n4 = (int)this.buttonView.doubleValue();
            this.setSelection(n4, false, true, false);
        }
        super.textDidEndEditing(n, n2, n3);
    }

    void updateCursorRects(boolean bl) {
        super.updateCursorRects(bl);
        this.updateCursorRects(bl, this.textView);
        this.updateCursorRects(bl, this.buttonView);
    }

    String verifyText(String string, int n, int n2, NSEvent nSEvent) {
        Event event = new Event();
        if (nSEvent != null) {
            this.setKeyState(event, 3, nSEvent);
        }
        event.text = string;
        event.start = n;
        event.end = n2;
        int n3 = 0;
        if (this.digits > 0) {
            String string2 = ".";
            n3 = string.indexOf(string2);
            if (n3 != -1) {
                string = String.valueOf(string.substring(0, n3)) + string.substring(n3 + 1);
            }
            n3 = 0;
        }
        while (n3 < string.length()) {
            if (!Character.isDigit(string.charAt(n3))) break;
            ++n3;
        }
        event.doit = n3 == string.length();
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

