/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.gtk.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String URI_LIST = "text/uri-list";
    private static final int URI_LIST_ID = FileTransfer.registerType("text/uri-list");
    private static final String GNOME_LIST = "x-special/gnome-copied-files";
    private static final int GNOME_LIST_ID = FileTransfer.registerType("x-special/gnome-copied-files");

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        byte[] byArray;
        byte[] byArray2;
        boolean bl;
        transferData.result = 0;
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        boolean bl2 = bl = transferData.type == (long)GNOME_LIST_ID;
        if (bl) {
            byArray2 = new byte[]{99, 111, 112, 121};
            byArray = new byte[]{10};
        } else {
            byArray2 = new byte[]{};
            byArray = new byte[]{13, 10};
        }
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            String string = stringArray[n];
            if (string != null && (n2 = string.length()) != 0) {
                char[] cArray = new char[n2];
                string.getChars(0, n2, cArray, 0);
                long[] lArray = new long[1];
                long l = OS.g_utf16_to_utf8(cArray, cArray.length, null, null, lArray);
                if (lArray[0] == 0L && l != 0L) {
                    long l2 = OS.g_filename_from_utf8(l, -1L, null, null, lArray);
                    OS.g_free(l);
                    if (lArray[0] == 0L && l2 != 0L) {
                        long l3 = OS.g_filename_to_uri(l2, 0L, lArray);
                        OS.g_free(l2);
                        if (lArray[0] == 0L && l3 != 0L) {
                            n2 = OS.strlen(l3);
                            byte[] byArray3 = new byte[n2];
                            OS.memmove(byArray3, l3, (long)n2);
                            OS.g_free(l3);
                            int n3 = byArray2.length > 0 ? byArray2.length + byArray.length + byArray3.length : byArray3.length;
                            byte[] byArray4 = new byte[n3];
                            int n4 = 0;
                            if (byArray2.length > 0) {
                                System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
                                System.arraycopy(byArray, 0, byArray4, n4 += byArray2.length, byArray.length);
                                n4 += byArray.length;
                            }
                            System.arraycopy(byArray3, 0, byArray4, n4, byArray3.length);
                            byArray2 = byArray4;
                        }
                    }
                }
            }
            ++n;
        }
        if (byArray2.length == 0) {
            return;
        }
        long l = OS.g_malloc(byArray2.length + 1);
        OS.memset(l, 0, byArray2.length + 1);
        OS.memmove(l, byArray2, (long)byArray2.length);
        transferData.pValue = l;
        transferData.length = byArray2.length;
        transferData.format = 8;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        long l;
        int n;
        if (!this.isSupportedType(transferData) || transferData.pValue == 0L || transferData.length <= 0) {
            return null;
        }
        int n2 = transferData.length;
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, transferData.pValue, (long)n2);
        boolean bl = transferData.type == (long)GNOME_LIST_ID;
        int n3 = bl ? 1 : 2;
        long[] lArray = new long[]{};
        int n4 = 0;
        int n5 = 0;
        while (n5 < byArray.length - 1) {
            int n6 = bl ? (byArray[n5] == 10 ? 1 : 0) : (n = byArray[n5] == 13 && byArray[n5 + 1] == 10 ? 1 : 0);
            if (n != 0) {
                if (!bl || n4 != 0) {
                    int n7 = n5 - n4;
                    l = OS.g_malloc(n7 + 1);
                    byte[] byArray2 = new byte[n7 + 1];
                    System.arraycopy(byArray, n4, byArray2, 0, n7);
                    OS.memmove(l, byArray2, (long)(n7 + 1));
                    long[] lArray2 = new long[lArray.length + 1];
                    System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
                    lArray2[lArray.length] = l;
                    lArray = lArray2;
                }
                n4 = n5 + n3;
            }
            ++n5;
        }
        if (n4 < byArray.length - n3) {
            n5 = byArray.length - n4;
            long l2 = OS.g_malloc(n5 + 1);
            byte[] byArray3 = new byte[n5 + 1];
            System.arraycopy(byArray, n4, byArray3, 0, n5);
            OS.memmove(l2, byArray3, (long)(n5 + 1));
            long[] lArray3 = new long[lArray.length + 1];
            System.arraycopy(lArray, 0, lArray3, 0, lArray.length);
            lArray3[lArray.length] = l2;
            lArray = lArray3;
        }
        String[] stringArray = new String[]{};
        n = 0;
        while (n < lArray.length) {
            long[] lArray4 = new long[1];
            l = OS.g_filename_from_uri(lArray[n], null, lArray4);
            OS.g_free(lArray[n]);
            if (lArray4[0] == 0L && l != 0L) {
                long l3 = OS.g_filename_to_utf8(l, -1L, null, null, lArray4);
                OS.g_free(l);
                if (lArray4[0] == 0L && l3 != 0L) {
                    long[] lArray5 = new long[1];
                    long l4 = OS.g_utf8_to_utf16(l3, -1L, null, lArray5, null);
                    OS.g_free(l3);
                    n2 = (int)lArray5[0];
                    char[] cArray = new char[n2];
                    OS.memmove(cArray, l4, (long)(n2 * 2));
                    OS.g_free(l4);
                    String string = new String(cArray);
                    String[] stringArray2 = new String[stringArray.length + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray2[stringArray.length] = string;
                    stringArray = stringArray2;
                }
            }
            ++n;
        }
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    protected int[] getTypeIds() {
        return new int[]{URI_LIST_ID, GNOME_LIST_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{URI_LIST, GNOME_LIST};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null || stringArray[n].length() == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

