/*
 *  Copyright (C) 2006-2009  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.gui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.dbgl.model.Settings;
import org.dbgl.swtdesigner.SWTImageManager;


public final class GeneralPurposeGUI {

    public static Button createIconButton(final Composite composite, final int style, final Settings settings, final String title, final String img) {
    	Button button = new Button(composite, style);
    	int displaySelection = settings.getIntValue("gui", "buttondisplay");
    	if (displaySelection != 1) {
    		button.setImage(SWTImageManager.getResourceImage(button.getDisplay(), img));
    	}
    	if (displaySelection == 2) {
    		button.setToolTipText(title);
    	} else {
    		button.setText(title);
    	}
    	return button;
    }

    public static ToolItem createIconToolItem(final ToolBar toolBar, final Settings settings, final String title, final String img, final SelectionListener listener) {
    	final ToolItem button = new ToolItem(toolBar, SWT.PUSH | SWT.BORDER);
    	int displaySelection = settings.getIntValue("gui", "buttondisplay");
    	if (displaySelection != 1) {
    		button.setImage(SWTImageManager.getResourceImage(button.getDisplay(), img));
    	}
    	if (displaySelection == 2) {
    		button.setToolTipText(title);
    	} else {
    		button.setText(title);
    	}
    	button.addSelectionListener(listener);
    	return button;
    }
    
    public static MenuItem createIconMenuItem(final Menu menu, final int style, final Settings settings, final String title, final String img, final SelectionListener listener) {
	    final MenuItem menuItem = new MenuItem(menu, style);
	    menuItem.setText(title);
	    if ((img != null) && (settings.getIntValue("gui", "buttondisplay") != 1)) {
	    	menuItem.setImage(SWTImageManager.getResourceImage(menu.getDisplay(), img));
	    }
	    if (listener != null) {
	    	menuItem.addSelectionListener(listener);
	    }
	    return menuItem;
    }
}
