/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTrackingArea;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTWindow;
import org.eclipse.swt.internal.cocoa.SWTWindowDelegate;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Shell
extends Decorations {
    NSWindow window;
    SWTWindowDelegate windowDelegate;
    int tooltipOwner;
    int tooltipTag;
    int tooltipUserData;
    boolean opened;
    boolean moved;
    boolean resized;
    boolean fullScreen;
    boolean center;
    Control lastActive;
    Rectangle normalBounds;
    boolean keyInputHappened;
    NSRect currentFrame;
    NSRect fullScreenFrame;
    static int DEFAULT_CLIENT_WIDTH = -1;
    static int DEFAULT_CLIENT_HEIGHT = -1;

    public Shell() {
        this((Display)null);
    }

    public Shell(int n) {
        this((Display)null, n);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int n) {
        this(display, null, n, 0, false);
    }

    Shell(Display display, Shell shell, int n, int n2, boolean bl) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (shell != null && shell.isDisposed()) {
            this.error(5);
        }
        if (!Display.getSheetEnabled()) {
            this.center = shell != null && (n & 0x10000000) != 0;
        }
        this.style = Shell.checkStyle(shell, n);
        this.parent = shell;
        this.display = display;
        if (n2 != 0) {
            if (bl) {
                this.view = new NSView(n2);
            } else {
                this.window = new NSWindow(n2);
                this.state |= 0x20000;
            }
        }
        this.createWidget();
    }

    public Shell(Shell shell) {
        this(shell, 2144);
    }

    public Shell(Shell shell, int n) {
        this(shell != null ? shell.display : null, shell, n, 0, false);
    }

    public static Shell internal_new(Display display, int n) {
        return new Shell(display, null, 8, n, false);
    }

    public static Shell cocoa_new(Display display, int n) {
        return new Shell(display, null, 8, n, true);
    }

    static int checkStyle(Shell shell, int n) {
        n = Decorations.checkStyle(n);
        int n2 = 229376;
        if (((n &= 0xBFFFFFFF) & 0x10000000) != 0) {
            if (Display.getSheetEnabled()) {
                n &= 0xFFFFFB1F;
                if (shell == null) {
                    n &= 0xEFFFFFFF;
                    n |= 0x4F0;
                }
            } else {
                n &= 0xEFFFFFFF;
                n |= shell == null ? 1264 : 2144;
            }
            if ((n & n2) == 0) {
                n |= shell == null ? 65536 : 32768;
            }
        }
        int n3 = n & ~n2;
        if ((n & 0x20000) != 0) {
            return n3 | 0x20000;
        }
        if ((n & 0x10000) != 0) {
            return n3 | 0x10000;
        }
        if ((n & 0x8000) != 0) {
            return n3 | 0x8000;
        }
        return n3;
    }

    boolean accessibilityIsIgnored(int n, int n2) {
        if (n == this.view.id) {
            return true;
        }
        return super.accessibilityIsIgnored(n, n2);
    }

    public void addShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(shellListener);
        this.addListener(26, typedListener);
        this.addListener(21, typedListener);
        this.addListener(27, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
    }

    void becomeKeyWindow(int n, int n2) {
        Display display = this.display;
        display.keyWindow = this.window;
        super.becomeKeyWindow(n, n2);
        display.checkFocus();
        display.keyWindow = null;
    }

    void bringToTop(boolean bl) {
        if (this.getMinimized()) {
            return;
        }
        if (bl) {
            this.forceActive();
        } else {
            this.setActive();
        }
    }

    boolean canBecomeKeyWindow(int n, int n2) {
        if (this.window.styleMask() == 0) {
            return true;
        }
        return super.canBecomeKeyWindow(n, n2);
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.display.map((Control)this.parent, null, this.parent.getClientArea());
        int n = Math.max(rectangle2.x, rectangle2.x + (rectangle2.width - rectangle.width) / 2);
        int n2 = Math.max(rectangle2.y, rectangle2.y + (rectangle2.height - rectangle.height) / 2);
        Rectangle rectangle3 = this.parent.getMonitor().getClientArea();
        n = n + rectangle.width > rectangle3.x + rectangle3.width ? Math.max(rectangle3.x, rectangle3.x + rectangle3.width - rectangle.width) : Math.max(n, rectangle3.x);
        n2 = n2 + rectangle.height > rectangle3.y + rectangle3.height ? Math.max(rectangle3.y, rectangle3.y + rectangle3.height - rectangle.height) : Math.max(n2, rectangle3.y);
        this.setLocation(n, n2);
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        NSRect nSRect = new NSRect();
        nSRect.x = rectangle.x;
        nSRect.y = rectangle.y;
        nSRect.width = rectangle.width;
        nSRect.height = rectangle.height;
        if (this.window != null && !this.fixResize()) {
            nSRect = this.window.frameRectForContentRect(nSRect);
        }
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    void createHandle() {
        this.state |= 0x10;
        if (this.window == null) {
            Object object;
            this.window = (NSWindow)new SWTWindow().alloc();
            int n = 0;
            if ((this.style & 8) == 0) {
                if ((this.style & 0x20) != 0) {
                    n |= 1;
                }
                if ((this.style & 0x40) != 0) {
                    n |= 2;
                }
                if ((this.style & 0x80) != 0) {
                    n |= 4;
                }
                if ((this.style & 0x400) != 0) {
                    n |= 8;
                }
                if ((this.style & 0x10) != 0) {
                    n |= 8;
                }
            }
            NSScreen nSScreen = null;
            NSScreen nSScreen2 = new NSScreen(NSScreen.screens().objectAtIndex(0));
            if (this.parent != null) {
                nSScreen = this.parent.getShell().window.screen();
            }
            if (nSScreen == null) {
                nSScreen = nSScreen2;
            }
            this.window = this.window.initWithContentRect(new NSRect(), n, 2, false, nSScreen);
            if ((this.style & 0xCF8) == 0 || (this.style & 0x10000004) != 0) {
                this.window.setHasShadow(true);
            }
            if ((this.style & 8) == 0) {
                object = this.window.minSize();
                ((NSSize)object).width = NSWindow.minFrameWidthWithTitle(NSString.stringWith(""), n);
                this.window.setMinSize((NSSize)object);
            }
            if (this.fixResize() && this.window.respondsToSelector(OS.sel_setMovable_)) {
                OS.objc_msgSend(this.window.id, OS.sel_setMovable_, 0);
            }
            this.display.cascadeWindow(this.window, nSScreen);
            object = nSScreen.frame();
            float f = ((NSRect)object).width * 5.0f / 8.0f;
            float f2 = ((NSRect)object).height * 5.0f / 8.0f;
            NSRect nSRect = this.window.frame();
            NSRect nSRect2 = nSScreen2.frame();
            nSRect.y = nSRect2.height - (nSRect2.height - (nSRect.y + nSRect.height) + f2);
            nSRect.width = f;
            nSRect.height = f2;
            this.window.setFrame(nSRect, false);
            if ((this.style & 0x4000) != 0) {
                this.window.setLevel(25);
            }
            super.createHandle();
            this.topView().setHidden(true);
        } else {
            this.state &= 0xFFFFFFEF;
            super.createHandle();
            this.style |= 0x40000;
        }
        this.window.setAcceptsMouseMovedEvents(true);
        this.windowDelegate = (SWTWindowDelegate)new SWTWindowDelegate().alloc().init();
        this.window.setDelegate(this.windowDelegate);
        NSText nSText = this.window.fieldEditor(true, null);
        if (nSText != null) {
            OS.object_setClass(nSText.id, OS.objc_getClass("SWTEditorView"));
        }
    }

    void deregister() {
        super.deregister();
        if (this.window != null) {
            this.display.removeWidget(this.window);
        }
        if (this.windowDelegate != null) {
            this.display.removeWidget(this.windowDelegate);
        }
    }

    void destroyWidget() {
        NSWindow nSWindow = this.window;
        Display display = this.display;
        boolean bl = (this.style & 0x10000000) != 0;
        this.releaseHandle();
        if (nSWindow != null) {
            if (bl) {
                NSApplication nSApplication = NSApplication.sharedApplication();
                nSApplication.endSheet(nSWindow, 0);
            }
            nSWindow.close();
        }
        if (!display.isDisposed() && display.getShells().length == 0) {
            display.setMenuBar(null);
        }
    }

    void drawBackground(int n, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (n != this.view.id) {
            return;
        }
        if (this.regionPath != null && this.background == null) {
            nSGraphicsContext.saveGraphicsState();
            NSColor.windowBackgroundColor().setFill();
            NSBezierPath.fillRect(nSRect);
            nSGraphicsContext.restoreGraphicsState();
            return;
        }
        super.drawBackground(n, nSGraphicsContext, nSRect);
    }

    Control findBackgroundControl() {
        return this.background != null || this.backgroundImage != null ? this : null;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    Cursor findCursor() {
        return this.cursor;
    }

    boolean fixResize() {
        return (this.style & 8) == 0 && (this.style & 0x10) != 0 && (this.style & 0x4E0) == 0;
    }

    void fixShell(Shell shell, Control control) {
        if (this == shell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
    }

    public void forceActive() {
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        if (this.window == null) {
            return;
        }
        this.makeKeyAndOrderFront();
        NSApplication nSApplication = NSApplication.sharedApplication();
        nSApplication.activateIgnoringOtherApps(true);
    }

    public int getAlpha() {
        this.checkWidget();
        if (this.window == null) {
            return 255;
        }
        return (int)(this.window.alphaValue() * 255.0f);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        NSRect nSRect = this.window == null ? this.view.frame() : this.window.frame();
        float f = this.display.getPrimaryFrame().height - (float)((int)(nSRect.y + nSRect.height));
        return new Rectangle((int)nSRect.x, (int)f, (int)nSRect.width, (int)nSRect.height);
    }

    public Rectangle getClientArea() {
        NSRect nSRect;
        this.checkWidget();
        if (this.window != null) {
            nSRect = this.window.frame();
            if (!this.fixResize()) {
                nSRect = this.window.contentRectForFrameRect(nSRect);
            }
        } else {
            nSRect = this.scrollView != null ? this.scrollView.frame() : this.view.frame();
        }
        int n = (int)nSRect.width;
        int n2 = (int)nSRect.height;
        if (this.scrollView != null) {
            NSSize nSSize = new NSSize();
            nSSize.width = n;
            nSSize.height = n2;
            nSSize = NSScrollView.contentSizeForFrameSize(nSSize, (this.style & 0x100) != 0, (this.style & 0x200) != 0, 0);
            n = (int)nSSize.width;
            n2 = (int)nSSize.height;
        }
        return new Rectangle(0, 0, n, n2);
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this.fullScreen;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    public Point getLocation() {
        this.checkWidget();
        NSRect nSRect = this.window != null ? this.window.frame() : this.view.frame();
        float f = this.display.getPrimaryFrame().height - (float)((int)(nSRect.y + nSRect.height));
        return new Point((int)nSRect.x, (int)f);
    }

    public boolean getMaximized() {
        this.checkWidget();
        if (this.window == null) {
            return false;
        }
        return !this.fullScreen && this.window.isZoomed();
    }

    Shell getModalShell() {
        Shell shell = null;
        Shell[] shellArray = this.display.modalShells;
        if (shellArray != null) {
            int n = 196608;
            int n2 = shellArray.length;
            while (--n2 >= 0) {
                Shell shell2 = shellArray[n2];
                if (shell2 == null) continue;
                if ((shell2.style & n) != 0) {
                    Composite composite = this;
                    while (composite != null) {
                        if (composite == shell2) break;
                        composite = composite.parent;
                    }
                    if (composite == shell2) break;
                    return shell2;
                }
                if ((shell2.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (shell2.parent != shell) continue;
                return shell2;
            }
        }
        return null;
    }

    public boolean getModified() {
        this.checkWidget();
        return this.window.isDocumentEdited();
    }

    public boolean getMinimized() {
        this.checkWidget();
        if (!this.getVisible()) {
            return super.getMinimized();
        }
        if (this.window == null) {
            return false;
        }
        return this.window.isMiniaturized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        if (this.window == null) {
            return new Point(0, 0);
        }
        NSSize nSSize = this.window.minSize();
        return new Point((int)nSSize.width, (int)nSSize.height);
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        Shell[] shellArray;
        this.checkWidget();
        int n = 0;
        Shell[] shellArray2 = this.display.getShells();
        int n2 = 0;
        while (n2 < shellArray2.length) {
            shellArray = shellArray2[n2];
            while ((shellArray = shellArray.parent) != null && shellArray != this) {
            }
            if (shellArray == this) {
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        shellArray = new Shell[n];
        int n3 = 0;
        while (n3 < shellArray2.length) {
            Composite composite = shellArray2[n3];
            while ((composite = composite.parent) != null && composite != this) {
            }
            if (composite == this) {
                shellArray[n2++] = shellArray2[n3];
            }
            ++n3;
        }
        return shellArray;
    }

    public Point getSize() {
        this.checkWidget();
        NSRect nSRect = this.window != null ? this.window.frame() : this.view.frame();
        return new Point((int)nSRect.width, (int)nSRect.height);
    }

    float getThemeAlpha() {
        return 1.0f;
    }

    boolean hasBorder() {
        return false;
    }

    void helpRequested(int n, int n2, int n3) {
        Control control = this.display.getFocusControl();
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                break;
            }
            control = control.parent;
        }
    }

    void invalidateVisibleRegion() {
        this.resetVisibleRegion();
        this.invalidateChildrenVisibleRegion();
    }

    boolean isDrawing() {
        return this.getDrawing();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isEnabledCursor() {
        return true;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    boolean makeFirstResponder(int n, int n2, int n3) {
        Display display = this.display;
        boolean bl = super.makeFirstResponder(n, n2, n3);
        display.checkFocus();
        return bl;
    }

    void makeKeyAndOrderFront() {
        if (this.parent != null) {
            Shell shell = (Shell)this.parent;
            if (shell.window.isMiniaturized()) {
                shell.window.deminiaturize(null);
            }
        }
        this.window.makeKeyAndOrderFront(null);
    }

    void noResponderFor(int n, int n2, int n3) {
        if (n3 != OS.sel_keyDown_) {
            super.noResponderFor(n, n2, n3);
        }
    }

    public void open() {
        this.checkWidget();
        int n = 229376;
        if ((this.style & n) != 0) {
            this.display.setModalShell(this);
        } else {
            this.updateModal();
        }
        this.bringToTop(false);
        this.setWindowVisible(true, true);
        if (this.isDisposed()) {
            return;
        }
        if (!(this.restoreFocus() || this.traverseGroup(true) || this.parent != null && ((Shell)this.parent).window.isMiniaturized())) {
            this.setFocus();
        }
    }

    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    void register() {
        super.register();
        if (this.window != null) {
            this.display.addWidget(this.window, this);
        }
        if (this.windowDelegate != null) {
            this.display.addWidget(this.windowDelegate, this);
        }
    }

    void releaseChildren(boolean bl) {
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (shell != null && !shell.isDisposed()) {
                shell.dispose();
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        if (this.window != null) {
            this.window.setDelegate(null);
        }
        if (this.windowDelegate != null) {
            this.windowDelegate.release();
        }
        this.windowDelegate = null;
        super.releaseHandle();
        this.window = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        super.releaseWidget();
        this.display.clearModal(this);
        this.updateParent(false);
        this.display.updateQuitMenu();
        this.lastActive = null;
    }

    public void removeShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(26, shellListener);
        this.eventTable.unhook(21, shellListener);
        this.eventTable.unhook(27, shellListener);
        this.eventTable.unhook(19, shellListener);
        this.eventTable.unhook(20, shellListener);
    }

    void sendToolTipEvent(boolean bl) {
        NSObject nSObject;
        Object object;
        if (!this.isVisible()) {
            return;
        }
        if (this.tooltipTag == 0) {
            object = this.window.contentView();
            this.tooltipTag = ((NSView)object).addToolTipRect(new NSRect(), this.window, 0);
            if (this.tooltipTag != 0) {
                NSDictionary nSDictionary;
                nSObject = new NSTrackingArea(this.tooltipTag);
                id id2 = nSObject.owner();
                if (id2 != null) {
                    this.tooltipOwner = id2.id;
                }
                if ((nSDictionary = nSObject.userInfo()) != null) {
                    this.tooltipUserData = nSDictionary.id;
                } else {
                    int[] nArray = new int[1];
                    OS.object_getInstanceVariable(this.tooltipTag, new byte[]{95, 117, 115, 101, 114, 73, 110, 102, 111}, nArray);
                    this.tooltipUserData = nArray[0];
                }
            }
        }
        if (this.tooltipTag == 0 || this.tooltipOwner == 0 || this.tooltipUserData == 0) {
            return;
        }
        object = this.window.convertScreenToBase(NSEvent.mouseLocation());
        nSObject = NSEvent.enterExitEventWithType(bl ? 8 : 9, (NSPoint)object, 0, 0.0, this.window.windowNumber(), null, 0, this.tooltipTag, this.tooltipUserData);
        OS.objc_msgSend(this.tooltipOwner, bl ? OS.sel_mouseEntered_ : OS.sel_mouseExited_, ((NSEvent)nSObject).id);
    }

    public void setActive() {
        if (this.window == null) {
            return;
        }
        this.checkWidget();
        if (!this.isVisible()) {
            return;
        }
        this.makeKeyAndOrderFront();
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] controlArray = control == null ? new Control[]{} : control.getPath();
        Control[] controlArray2 = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int n = 0;
        int n2 = Math.min(controlArray.length, controlArray2.length);
        while (n < n2) {
            if (controlArray[n] != controlArray2[n]) break;
            ++n;
        }
        int n3 = controlArray2.length - 1;
        while (n3 >= n) {
            if (!controlArray2[n3].isDisposed()) {
                controlArray2[n3].sendEvent(27);
            }
            --n3;
        }
        n3 = controlArray.length - 1;
        while (n3 >= n) {
            if (!controlArray[n3].isDisposed()) {
                controlArray[n3].sendEvent(26);
            }
            --n3;
        }
    }

    public void setAlpha(int n) {
        if (this.window == null) {
            return;
        }
        this.checkWidget();
        this.window.setAlphaValue((float)(n &= 0xFF) / 255.0f);
    }

    void setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        Object object;
        boolean bl3;
        if (this.window == null) {
            return;
        }
        if (this.fullScreen) {
            this.setFullScreen(false);
        }
        if ((bl3 = this.window.isSheet()) && bl && !bl2) {
            return;
        }
        int n5 = (int)this.display.getPrimaryFrame().height;
        NSRect nSRect = this.window.frame();
        if (!bl) {
            n = (int)nSRect.x;
            n2 = n5 - (int)(nSRect.y + nSRect.height);
        }
        if (bl2) {
            object = this.window.minSize();
            n3 = Math.max(n3, (int)((NSSize)object).width);
            n4 = Math.max(n4, (int)((NSSize)object).height);
        } else {
            n3 = (int)nSRect.width;
            n4 = (int)nSRect.height;
        }
        if (bl3) {
            n2 = n5 - (int)(nSRect.y + nSRect.height);
            object = this.parent.getShell().window.frame();
            nSRect.width = n3;
            nSRect.height = n4;
            nSRect.x = ((NSRect)object).x + (((NSRect)object).width - nSRect.width) / 2.0f;
            nSRect.y = n5 - (int)((float)n2 + nSRect.height);
            this.window.setFrame(nSRect, this.isVisible(), true);
        } else {
            nSRect.x = n;
            nSRect.y = n5 - (n2 + n4);
            nSRect.width = n3;
            nSRect.height = n4;
            this.window.setFrame(nSRect, this.isVisible());
        }
    }

    void setClipRegion(float f, float f2) {
        if (this.regionPath != null) {
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(-f, -f2);
            this.regionPath.transformUsingAffineTransform(nSAffineTransform);
            this.regionPath.addClip();
            nSAffineTransform.translateXBy(2.0f * f, 2.0f * f2);
            this.regionPath.transformUsingAffineTransform(nSAffineTransform);
        }
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 8) == 0 == bl) {
            return;
        }
        super.setEnabled(bl);
    }

    public void setFullScreen(boolean bl) {
        this.checkWidget();
        if (this.fullScreen == bl) {
            return;
        }
        this.fullScreen = bl;
        if (bl) {
            this.currentFrame = this.window.frame();
            this.window.setShowsResizeIndicator(false);
            if (this.window.respondsToSelector(OS.sel_setMovable_)) {
                OS.objc_msgSend(this.window.id, OS.sel_setMovable_, 0);
            }
            this.fullScreenFrame = NSScreen.mainScreen().frame();
            if (this.getMonitor().equals(this.display.getPrimaryMonitor())) {
                if (this.menuBar != null) {
                    float f = this.currentFrame.height - this.contentView().frame().height;
                    this.fullScreenFrame.height -= f;
                    OS.SetSystemUIMode(2, 0);
                } else {
                    OS.SetSystemUIMode(3, 0);
                }
            }
            this.window.setFrame(this.fullScreenFrame, true);
            this.window.contentView().setFrame(this.fullScreenFrame);
        } else {
            this.window.setShowsResizeIndicator(true);
            if (this.window.respondsToSelector(OS.sel_setMovable_)) {
                OS.objc_msgSend(this.window.id, OS.sel_setMovable_, 1);
            }
            OS.SetSystemUIMode(0, 0);
            this.window.setFrame(this.currentFrame, true);
        }
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        super.setMenuBar(menu);
        if (this.display.getActiveShell() == this) {
            this.display.setMenuBar(this.menuBar);
        }
    }

    public void setImeInputMode(int n) {
        this.checkWidget();
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        super.setMaximized(bl);
        if (this.window == null) {
            return;
        }
        if (this.window.isZoomed() == bl) {
            return;
        }
        this.window.zoom(null);
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        super.setMinimized(bl);
        if (this.window == null) {
            return;
        }
        if (bl) {
            this.window.miniaturize(null);
        } else {
            this.window.deminiaturize(null);
        }
    }

    public void setMinimumSize(int n, int n2) {
        this.checkWidget();
        if (this.window == null) {
            return;
        }
        NSSize nSSize = new NSSize();
        nSSize.width = n;
        nSSize.height = n2;
        this.window.setMinSize(nSSize);
        NSRect nSRect = this.window.frame();
        if ((float)n > nSRect.width || (float)n2 > nSRect.height) {
            n = (int)((float)n > nSRect.width ? (float)n : nSRect.width);
            n2 = (int)((float)n2 > nSRect.height ? (float)n2 : nSRect.height);
            this.setBounds(0, 0, n, n2, false, true);
        }
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSize(point.x, point.y);
    }

    public void setModified(boolean bl) {
        this.checkWidget();
        this.window.setDocumentEdited(bl);
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (this.window == null) {
            return;
        }
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        this.region = region;
        if (this.regionPath != null) {
            this.regionPath.release();
        }
        this.regionPath = this.getPath(region);
        if (region != null) {
            this.window.setBackgroundColor(NSColor.clearColor());
            this.window.setOpaque(false);
        } else {
            this.window.setBackgroundColor(NSColor.windowBackgroundColor());
            this.window.setOpaque(true);
        }
        this.window.contentView().setNeedsDisplay(true);
        if (this.isVisible() && this.window.hasShadow()) {
            this.window.display();
            this.window.invalidateShadow();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.window == null) {
            return;
        }
        super.setText(string);
        NSString nSString = NSString.stringWith(string);
        this.window.setTitle(nSString);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        int n = 229376;
        if ((this.style & n) != 0) {
            if (bl) {
                this.display.setModalShell(this);
            } else {
                this.display.clearModal(this);
            }
        } else {
            this.updateModal();
        }
        if (this.window == null) {
            super.setVisible(bl);
        } else {
            this.setWindowVisible(bl, false);
        }
    }

    void setWindowVisible(boolean bl, boolean bl2) {
        if (bl) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        if (this.window != null && this.window.isVisible() == bl) {
            return;
        }
        if (bl) {
            this.display.clearPool();
            if (this.center && !this.moved) {
                if (this.isDisposed()) {
                    return;
                }
                this.center();
            }
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.topView().setHidden(false);
            this.invalidateVisibleRegion();
            if ((this.style & 0x10000000) != 0) {
                NSApplication nSApplication = NSApplication.sharedApplication();
                nSApplication.beginSheet(this.window, ((Shell)this.parent).window, null, 0, 0);
                if (OS.VERSION <= 4192 && this.window.respondsToSelector(OS.sel__setNeedsToUseHeartBeatWindow_)) {
                    OS.objc_msgSend(this.window.id, OS.sel__setNeedsToUseHeartBeatWindow_, 0);
                }
            } else {
                boolean bl3;
                boolean bl4 = bl3 = this.parent != null && ((Shell)this.parent).window.isMiniaturized();
                if (!bl3) {
                    if (bl2) {
                        this.makeKeyAndOrderFront();
                    } else {
                        this.window.orderFront(null);
                    }
                }
            }
            this.updateParent(bl);
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            this.updateParent(bl);
            if ((this.style & 0x10000000) != 0) {
                NSApplication nSApplication = NSApplication.sharedApplication();
                nSApplication.endSheet(this.window, 0);
            }
            this.window.orderOut(null);
            this.topView().setHidden(true);
            this.invalidateVisibleRegion();
            this.sendEvent(23);
        }
        this.display.updateQuitMenu();
    }

    void setZOrder() {
        if (this.scrollView != null) {
            this.scrollView.setDocumentView(this.view);
        }
        if (this.window == null) {
            return;
        }
        this.window.setContentView(this.scrollView != null ? this.scrollView : this.view);
        if (this.fixResize()) {
            NSRect nSRect = this.window.frame();
            nSRect.y = 0.0f;
            nSRect.x = 0.0f;
            this.window.contentView().setFrame(nSRect);
        }
    }

    void setZOrder(Control control, boolean bl) {
        if (this.window == null) {
            return;
        }
        if (control == null) {
            if (bl) {
                this.window.orderFront(null);
            } else {
                this.window.orderBack(null);
            }
        } else {
            NSWindow nSWindow = control.getShell().window;
            this.window.orderWindow(bl ? 1 : -1, nSWindow.windowNumber());
        }
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    void updateModal() {
    }

    void updateParent(boolean bl) {
        Shell[] shellArray;
        if (bl) {
            if (this.parent != null && this.parent.getVisible()) {
                ((Shell)this.parent).window.addChildWindow(this.window, 1);
            }
        } else {
            shellArray = this.window.parentWindow();
            if (shellArray != null) {
                shellArray.removeChildWindow(this.window);
            }
        }
        shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (shell.parent == this && shell.getVisible()) {
                shell.updateParent(bl);
            }
            ++n;
        }
    }

    void updateSystemUIMode() {
        if (!this.getMonitor().equals(this.display.getPrimaryMonitor())) {
            return;
        }
        if (this.fullScreen) {
            int n = 3;
            if (this.menuBar != null) {
                n = 2;
            }
            int[] nArray = new int[1];
            OS.GetSystemUIMode(nArray, null);
            if (nArray[0] != n) {
                OS.SetSystemUIMode(n, 0);
            }
            this.window.setFrame(this.fullScreenFrame, true);
        } else {
            int[] nArray = new int[1];
            OS.GetSystemUIMode(nArray, null);
            if (nArray[0] != 0) {
                OS.SetSystemUIMode(0, 0);
            }
        }
    }

    int view_stringForToolTip_point_userData(int n, int n2, int n3, int n4, int n5, int n6) {
        NSPoint nSPoint = new NSPoint();
        OS.memmove(nSPoint, n5, NSPoint.sizeof);
        Control control = this.display.findControl(false);
        if (control == null) {
            return 0;
        }
        Widget widget = control.findTooltip(new NSView(n3).convertPoint_toView_(nSPoint, null));
        String string = widget.tooltipText();
        if (string == null) {
            return 0;
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n7 = this.fixMnemonic(cArray);
        return NSString.stringWithCharacters((char[])cArray, (int)n7).id;
    }

    void windowDidBecomeKey(int n, int n2, int n3) {
        super.windowDidBecomeKey(n, n2, n3);
        Display display = this.display;
        display.setMenuBar(this.menuBar);
        this.sendEvent(26);
        if (this.isDisposed()) {
            return;
        }
        Shell shell = this;
        while (shell.parent != null) {
            shell = (Shell)shell.parent;
            if (shell.fullScreen) break;
        }
        if (!shell.fullScreen || this.menuBar != null) {
            this.updateSystemUIMode();
        } else {
            shell.updateSystemUIMode();
        }
    }

    void windowDidMove(int n, int n2, int n3) {
        this.moved = true;
        this.sendEvent(10);
    }

    void windowDidResize(int n, int n2, int n3) {
        if (this.fullScreen) {
            this.window.setFrame(this.fullScreenFrame, true);
            this.window.contentView().setFrame(this.fullScreenFrame);
        }
        if (this.fixResize()) {
            NSRect nSRect = this.window.frame();
            nSRect.y = 0.0f;
            nSRect.x = 0.0f;
            this.window.contentView().setFrame(nSRect);
        }
        this.resized = true;
        this.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
    }

    void windowDidResignKey(int n, int n2, int n3) {
        super.windowDidResignKey(n, n2, n3);
        this.sendEvent(27);
    }

    void windowSendEvent(int n, int n2, int n3) {
        NSEvent nSEvent = new NSEvent(n3);
        int n4 = nSEvent.type();
        switch (n4) {
            case 2: 
            case 4: 
            case 5: 
            case 26: {
                Widget widget;
                NSView[] nSViewArray = new NSView[1];
                Control control = this.display.findControl(false, nSViewArray);
                if (!(control == null || control.isActive() && control.isEnabled())) {
                    control = null;
                }
                if (n4 == 5) {
                    widget = control;
                    if (widget != null && ((Control)widget).isTrim(nSViewArray[0])) {
                        widget = null;
                    }
                    this.display.checkEnterExit((Control)widget, nSEvent, false);
                    if (widget != null) {
                        ((Control)widget).sendMouseEvent(nSEvent, n4, false);
                    }
                }
                widget = null;
                if (control != null) {
                    widget = control.findTooltip(nSEvent.locationInWindow());
                }
                if (this.display.tooltipControl != control || this.display.tooltipTarget != widget) {
                    Shell shell;
                    Control control2 = this.display.tooltipControl;
                    Shell shell2 = control2 != null && !control2.isDisposed() ? control2.getShell() : null;
                    Shell shell3 = shell = control != null && !control.isDisposed() ? control.getShell() : null;
                    if (shell2 != null) {
                        shell2.sendToolTipEvent(false);
                    }
                    if (shell != null) {
                        shell.sendToolTipEvent(true);
                    }
                }
                this.display.tooltipControl = control;
                this.display.tooltipTarget = widget;
                break;
            }
            case 10: {
                NSString nSString;
                if ((nSEvent.modifierFlags() & 0x40000) == 0 || (nSString = nSEvent.characters()) == null || nSString.length() != 1) break;
                int n5 = nSString.characterAtIndex(0);
                switch (n5) {
                    case 9: 
                    case 25: 
                    case 63276: 
                    case 63277: {
                        this.window.firstResponder().keyDown(nSEvent);
                        return;
                    }
                }
            }
        }
        super.windowSendEvent(n, n2, n3);
    }

    boolean windowShouldClose(int n, int n2, int n3) {
        this.closeWidget();
        return false;
    }
}

