package org.dbgl.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dbgl.gui.MainWindow;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.ExpGame;
import org.dbgl.model.Profile;
import org.dbgl.model.conf.CompositeConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;


public final class ExportThread extends Thread {

    private final static String FORMAT_VERSION = "1.0";
    
    private String title;
    private int profileNumber;
    private StringBuffer messageLog;
    private Display display;
    private Text log;
    private ProgressBar progressBar;
    private Label profileLabel;
    private Profile[] profs;
    private List<DosboxVersion> dbversionsList;
    private String exportTitle;
    private String exportNotes;
    private boolean exportCaptures;
    private boolean exportGameData;
    private File target;
    private File xmlFile;


    public ExportThread(Profile[] p, List<DosboxVersion> dbList, String et, String en,
            boolean ec, boolean eg,
            File n, Text log, ProgressBar progressBar, Label profileLabel) throws IOException {
        this.log = log;
        this.progressBar = progressBar;
        this.profileLabel = profileLabel;
        this.display = log.getShell().getDisplay();
        this.profs = p;
        this.dbversionsList = dbList;
        this.exportTitle = et;
        this.exportNotes = en;
        this.exportCaptures = ec;
        this.exportGameData = eg;
        this.xmlFile = new File(FileUtils.PROFILES_XML);
        this.target = n;
        this.messageLog = new StringBuffer();
        this.progressBar.setMaximum(profs.length);
    }

    public void run() {
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(target));

            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xmldoc = builder.newDocument();
            Element root = xmldoc.createElement("document");
            Element export = xmldoc.createElement("export");
            XmlUtils.addElement(xmldoc, export, "format-version", FORMAT_VERSION);
            XmlUtils.addElement(xmldoc, export, "title", exportTitle);
            XmlUtils.addCDataElement(xmldoc, export, "notes", exportNotes);
            XmlUtils.addElement(xmldoc, export, "generator-title", MainWindow.PROGRAM_NAME_FULL);
            XmlUtils.addElement(xmldoc, export, "generator-version", MainWindow.PROGRAM_VERSION);
            XmlUtils.addElement(xmldoc, export, "captures-available", String.valueOf(exportCaptures));
            XmlUtils.addElement(xmldoc, export, "gamedata-available", String.valueOf(exportGameData));
            root.appendChild(export);

            for (profileNumber = 0; profileNumber < profs.length; profileNumber++) {
                Profile prof = profs[profileNumber];
                title = prof.getTitle();
                messageLog = new StringBuffer();

                //Configuration fullConf = null, incrConf = null;
                
                int dbIndex = DosboxVersion.findById(dbversionsList, prof.getDbversionId());
                //fullConf = new Configuration(dbversionsList.get(dbIndex).getCanonicalConfFile());
                CompositeConfiguration fullCConf = new CompositeConfiguration(dbversionsList.get(dbIndex), prof, false, null, System.out);
                //fullConf.parseConfigurationFile(prof.getCanonicalConfFile());
                //incrConf = new Configuration(prof.getCanonicalConfFile(), false);
                //messageLog.append(fullConf.getParsingProblems());

                //String relCapDir = FileUtils.constructRelativeCapturesDir(profileNumber);
                //fullConf.setValue("dosbox", "captures", relCapDir);
                //incrConf.setValue("dosbox", "captures", relCapDir);

                //Autoexec autoexec = new Autoexec(fullConf.getValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC));
                //autoexec.setSetup(prof.getSetup());
                //File canonicalSrc = FileUtils.canonicalToDosroot(autoexec.getMainDir().getPath());
                File canonicalSrc = fullCConf.getCompositeConf().getCanonicalMainDir();
                //File dst = autoexec.prepareForExport(new File(FileUtils.constructGameDir(profileNumber)));
                File dst = fullCConf.getExportGameDir(profileNumber);
                
                /*String autoString = autoexec.toString(false);
                fullConf.setValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC, autoString);
                incrConf.setValue(Configuration.AUTOEXEC, Configuration.AUTOEXEC, autoString);*/
                
                if (exportCaptures) {
                    File captures = new File(FileUtils.constructCapturesDir(profileNumber));
                    try {
                        FileUtils.zipDir(prof.getCanonicalCaptures(), zos, captures);
                    } catch (IOException e) {
                        messageLog.append(title + ": Captures could not be exported: " + e.getMessage() + "\n");
                    }
                }

                if (exportGameData) {
                    try {
                        FileUtils.zipDir(canonicalSrc, zos, new File(FileUtils.DOSROOT_DIR, dst.getPath()));
                    } catch (IOException e) {
                        messageLog.append(title + ": Game data could not be exported: " + e.getMessage() + "\n");
                    }
                }

                //String setup = autoexec.getSetup();
                String setup = prof.getSetup();
                ExpGame expProf = new ExpGame(profileNumber, FileUtils.PROFILES_DIR + profileNumber + FileUtils.CONF_EXT,
                        FileUtils.CAPTURES_DIR + profileNumber, setup,
                        fullCConf.getFullConf(), fullCConf.getIncrConf(), dst, prof);

                Element profElement = expProf.getXml(xmldoc, dbversionsList);
                root.appendChild(profElement);

                if (display.isDisposed() || log.isDisposed() || progressBar.isDisposed()) break;
                display.asyncExec(new Runnable() {
                    public void run() {
                        profileLabel.setText("Exported " + title);
                        profileLabel.pack();
                        log.append(messageLog.toString());
                        progressBar.setSelection(profileNumber + 1);
                    }
                });
            }

            xmldoc.appendChild(root);
            FileUtils.zipEntry(xmlFile, zos, XmlUtils.domToInputStream(xmldoc));
            zos.close();

        } catch (Exception e) {
            messageLog.append(e.getMessage() + '\n');
            display.asyncExec(new Runnable() {
                public void run() {
                    log.append(messageLog.toString());
                }
            });
        }
    }
}
