/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSOpenPanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";

    public DirectoryDialog(Shell shell) {
        this(shell, 65536);
    }

    public DirectoryDialog(Shell shell, int n) {
        super(shell, DirectoryDialog.checkStyle(shell, n));
        if (Display.getSheetEnabled() && shell != null && (n & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        String string = null;
        NSOpenPanel nSOpenPanel = NSOpenPanel.openPanel();
        nSOpenPanel.setCanCreateDirectories(true);
        nSOpenPanel.setAllowsMultipleSelection((this.style & 2) != 0);
        nSOpenPanel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        nSOpenPanel.setMessage(NSString.stringWith(this.message != null ? this.message : ""));
        nSOpenPanel.setCanChooseFiles(false);
        nSOpenPanel.setCanChooseDirectories(true);
        NSApplication nSApplication = NSApplication.sharedApplication();
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            nSApplication.beginSheet(nSOpenPanel, this.parent.window, null, 0, 0);
        }
        NSString nSString = this.filterPath != null ? NSString.stringWith(this.filterPath) : null;
        int n = nSOpenPanel.runModalForDirectory(nSString, null);
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            nSApplication.endSheet(nSOpenPanel, 0);
        }
        if (n == 1) {
            NSString nSString2 = nSOpenPanel.filename();
            string = this.filterPath = nSString2.getString();
        }
        return string;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

