/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSImageView;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSStatusBar;
import org.eclipse.swt.internal.cocoa.NSStatusItem;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTImageView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    ToolTip toolTip;
    String toolTipText;
    boolean visible = true;
    boolean highlight;
    NSStatusItem item;
    NSImageView view;
    static final float BORDER = 8.0f;

    public TrayItem(Tray tray, int n) {
        super(tray, n);
        this.parent = tray;
        tray.createItem(this, tray.getItemCount());
        this.createWidget();
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle() {
        NSStatusBar nSStatusBar = NSStatusBar.systemStatusBar();
        this.item = nSStatusBar.statusItemWithLength(0.0f);
        if (this.item == null) {
            this.error(2);
        }
        this.item.retain();
        this.item.setHighlightMode(true);
        this.view = (NSImageView)new SWTImageView().alloc();
        if (this.view == null) {
            this.error(2);
        }
        this.view.init();
        this.item.setView(this.view);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
        this.display.removeWidget(this.view.cell());
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    Point getLocation() {
        NSRect nSRect = this.view.frame();
        NSRect nSRect2 = this.view.window().frame();
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = nSRect.width / 2.0f;
        nSPoint = this.view.convertPoint_fromView_(nSPoint, null);
        nSPoint.x += nSRect2.x;
        return new Point((int)nSPoint.x, (int)nSPoint.y);
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    void register() {
        super.register();
        this.display.addWidget(this.view, this);
        this.display.addWidget(this.view.cell(), this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        if (this.item != null) {
            this.item.release();
        }
        if (this.view != null) {
            this.view.release();
        }
        this.item = null;
        this.view = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        NSStatusBar nSStatusBar = NSStatusBar.systemStatusBar();
        nSStatusBar.removeStatusItem(this.item);
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        float f = 0.0f;
        if (image == null) {
            this.view.setImage(null);
        } else {
            NSImage nSImage = this.view.image();
            if (nSImage != null && nSImage.id == image.handle.id) {
                this.view.setImage(null);
            }
            this.view.setImage(image.handle);
            if (this.visible) {
                f = image.handle.size().width + 8.0f;
            }
        }
        this.item.setLength(f);
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip toolTip2 = this.toolTip;
        ToolTip toolTip3 = toolTip;
        if (toolTip2 != null) {
            toolTip2.item = null;
        }
        this.toolTip = toolTip3;
        if (toolTip3 != null) {
            toolTip3.item = this;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this._setToolTipText(string);
    }

    void _setToolTipText(String string) {
        if (string != null) {
            char[] cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            int n = this.fixMnemonic(cArray);
            NSString nSString = NSString.stringWithCharacters(cArray, n);
            this.view.setToolTip(nSString);
        } else {
            this.view.setToolTip(null);
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.visible == bl) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        this.visible = bl;
        float f = this.image != null && bl ? this.image.handle.size().width + 8.0f : 0.0f;
        this.item.setLength(f);
        if (!bl) {
            this.sendEvent(23);
        }
    }

    void showMenu(Menu menu) {
        this.display.trayItemMenu = menu;
        this.item.popUpStatusItemMenu(menu.nsMenu);
    }

    void showMenu() {
        this._setToolTipText(null);
        Display display = this.display;
        display.currentTrayItem = this;
        this.sendEvent(35);
        if (!this.isDisposed()) {
            display.runPopups();
        }
        display.currentTrayItem = null;
        if (this.isDisposed()) {
            return;
        }
        this._setToolTipText(this.toolTipText);
    }

    void displayMenu() {
        if (this.highlight) {
            this.view.display();
            this.display.trayItemMenu = null;
            this.showMenu();
            if (this.display.trayItemMenu != null) {
                this.display.trayItemMenu = null;
                this.highlight = false;
                this.view.setNeedsDisplay(true);
            }
        }
    }

    boolean shouldShowMenu(NSEvent nSEvent) {
        if (!this.hooks(35)) {
            return false;
        }
        switch (nSEvent.type()) {
            case 3: {
                return true;
            }
            case 1: {
                if (!this.hooks(13) && !this.hooks(14)) {
                    return true;
                }
                return (nSEvent.modifierFlags() & 0xFFFF0000) == 262144;
            }
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    void mouseDown(int n, int n2, int n3) {
        NSEvent nSEvent = new NSEvent(n3);
        this.highlight = true;
        this.view.setNeedsDisplay(true);
        if (this.shouldShowMenu(nSEvent)) {
            this.displayMenu();
        }
    }

    void mouseDragged(int n, int n2, int n3) {
        NSEvent nSEvent = new NSEvent(n3);
        NSRect nSRect = this.view.frame();
        this.highlight = OS.NSPointInRect(nSEvent.locationInWindow(), nSRect);
        this.view.setNeedsDisplay(true);
        if (this.shouldShowMenu(nSEvent)) {
            this.displayMenu();
        }
    }

    void mouseUp(int n, int n2, int n3) {
        NSEvent nSEvent;
        if (this.highlight && (nSEvent = new NSEvent(n3)).type() == 2) {
            this.postEvent(nSEvent.clickCount() == 2 ? 14 : 13);
        }
        this.highlight = false;
        this.view.setNeedsDisplay(true);
    }

    void rightMouseDown(int n, int n2, int n3) {
        this.mouseDown(n, n2, n3);
    }

    void rightMouseUp(int n, int n2, int n3) {
        this.mouseUp(n, n2, n3);
    }

    void rightMouseDragged(int n, int n2, int n3) {
        this.mouseDragged(n, n2, n3);
    }

    void drawRect(int n, int n2, NSRect nSRect) {
        this.item.drawStatusBarBackgroundInRect(nSRect, this.highlight);
        super.drawRect(n, n2, nSRect);
    }
}

