/*
 *  Copyright (C) 2006-2009  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.gui;

import java.sql.SQLException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;
import org.dbgl.db.Database;
import org.dbgl.model.DosboxVersion;
import org.dbgl.model.Mount;
import org.dbgl.model.Settings;
import org.dbgl.model.Template;
import org.dbgl.model.conf.CompositeConfiguration;
import org.dbgl.model.conf.Configuration;
import swing2swt.layout.BorderLayout;


public class EditTemplateDialog extends Dialog {

    protected Text title;
    protected Button defaultButton;
    protected Combo dbversion;
    protected Button setButton;
    protected Button reloadButton;
    protected Combo priority_active, priority_inactive;
    protected Button waitonerror, exit;
    protected Text language, captures;
    protected Combo output, frameskip;
    protected Combo scaler, pixelshader;
    protected Button fulldouble, fullscreen;
    protected Combo fullresolution, windowresolution;
    protected Button aspect;
    protected Text overscan;
    protected Combo svgachipset, videoram;
    protected Combo vsyncmode;
    protected Text vsyncrate;
    protected Button glide;
    protected Text glideport;
    protected Combo lfbGlide;
    protected Combo machine, cpu_type, core;
    protected Combo cycles, cycles_up, cycles_down;
    protected Button timesynched;
    protected Combo memsize;
    protected Button xms, ems;
    protected Combo umb;
    protected Button nosound;
    protected Combo rate, blocksize, prebuffer, mpu401, midi_device;
    protected Text midi_config;
    protected Text mixer_config;
    protected Combo mt32rate;
    protected Combo sbtype, oplrate, oplmode, oplemu, sbbase, irq, dma, hdma;
    protected Button sbmixer;
    protected Button gus;
    protected Combo gusrate, gusbase, gusdma1, gusdma2, gusirq1, gusirq2;
    protected Text ultradir;
    protected Button pcspeaker;
    protected Combo pcrate;
    protected Combo tandy, tandyrate;
    protected Button disney;
    protected Button usescancodes;
    protected Text mapperfile;
    protected Combo keyboard_layout;
    protected Text keyb;
    protected Button autolock;
    protected Combo sensitivity;
    protected Combo joysticktype;
    protected Button timed, autofire, swap34, buttonwrap;
    protected Text serial1, serial2, serial3, serial4;
    protected Button ipx;
    protected Text ipxnet;
    protected List mountingpoints;
    protected Button booterButton, dosButton;
    protected Group memoryGroup, associationGroup, miscGroup, executeGroup;
    protected TabItem infoTabItem, mountingTabItem;
    protected Button okButton, cancelButton;
    
    protected int dbversionIndex = -1;
    
    protected Shell shell;
    protected java.util.List<DosboxVersion> dbversionsList;
    protected Database dbase;
    protected CompositeConfiguration compConf;
    protected Settings settings;
    protected Object result;


    public EditTemplateDialog(final Shell parent) {
        super(parent, SWT.NONE);
    }

    public void setTemplate(final Template template) {
        this.result = template;
    }

    public Object open() {
        settings = Settings.getInstance();
        dbase = Database.getInstance();
        if (init()) { 
            createContents();
            shell.open();
            shell.layout();
            Display display = getParent().getDisplay();
            while (!shell.isDisposed()) {
                if (!display.readAndDispatch()) {
                    display.sleep();
                }
            }
        }
        return result;
    }

    protected boolean init() {
        try {
            dbversionsList = dbase.readDosboxVersionsList();
        } catch (SQLException e) {
            GeneralPurposeDialogs.warningMessage(getParent(), e.getMessage());
            return false;
        }
        if (result == null) {
            dbversionIndex = DosboxVersion.findDefault(dbversionsList);
            compConf = new CompositeConfiguration(dbversionsList.get(dbversionIndex), true, getParent(), System.out);
        } else {
            dbversionIndex = DosboxVersion.findById(dbversionsList, ((Template)result).getDbversionId());
            compConf = new CompositeConfiguration(dbversionsList.get(dbversionIndex), (Template)result, true, getParent(), System.out);
        }
        return true;
    }
    
    protected void createContents() {
        shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
        shell.setLayout(new BorderLayout(0, 0));
        shell.addControlListener(new SizeControlAdapter(shell, "templatedialog"));
        if (result == null) {
            shell.setText(settings.msg("dialog.template.title.add"));
        } else {
            // meaning we are essentially editing an existing template
            shell.setText(settings.msg("dialog.template.title.edit", new Object[] {((Template)result).getTitle(), ((Template) result).getId()}));
        }

        final TabFolder tabFolder = new TabFolder(shell, SWT.NONE);
        createInfoTab(tabFolder);
        createGeneralTab(tabFolder);
        createDisplayTab(tabFolder);
        createMachineTab(tabFolder);
        createAudioTab(tabFolder);
        createIOTab(tabFolder);
        createMountingTab(tabFolder);

        createOkCancelButtons();
        okButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                if (!isValid()) {
                    return;
                }
                try {
                    if (setButton.isEnabled()) {
                        doLoadTemplateConf(setButton, true, false); // set correct dbversion
                    }
                    int templateId = dbase.addOrEditTemplate(title.getText(), compConf.getDbversionId(),
                            defaultButton.getSelection(), result == null ? -1: ((Template)result).getId());
                    compConf.setCompositeConf(getConfigurationBySettings());
                    result = new Template(templateId, title.getText(), compConf.getDbversionId(), defaultButton.getSelection());
                    compConf.save((Template)result, shell, System.out);
                } catch (SQLException e1) {
                    GeneralPurposeDialogs.warningMessage(shell, e1.getMessage());
                }
                shell.close();
            }
        });

        // init values
        for (DosboxVersion dbv : dbversionsList) {
            dbversion.add(dbv.getTitle());
        }
        dbversion.select(dbversionIndex);
        
        if (result == null) {
            title.setFocus();
        } else {
            // meaning we are essentially editing an existing template
            // so we need to set previous values
            title.setText(((Template)result).getTitle());
            defaultButton.setSelection(((Template)result).isDefault());
        }

        enableSettingsByConfiguration();
        selectSettingsByConfiguration();
    }
    
    protected void createOkCancelButtons() {
        final Composite composite_7 = new Composite(shell, SWT.NONE);
        composite_7.setLayout(new GridLayout(2, true));
        composite_7.setLayoutData(BorderLayout.SOUTH);

        okButton = new Button(composite_7, SWT.NONE);
        shell.setDefaultButton(okButton);
        final GridData gridData = new GridData();
        gridData.horizontalAlignment = SWT.FILL;
        gridData.widthHint = 80;
        okButton.setLayoutData(gridData);
        okButton.setText(settings.msg("button.ok"));
        
        cancelButton = new Button(composite_7, SWT.NONE);
        final GridData gridData_1 = new GridData();
        gridData_1.horizontalAlignment = SWT.FILL;
        cancelButton.setLayoutData(gridData_1);
        cancelButton.setText(settings.msg("button.cancel"));
        cancelButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                if (cancelButton.getText().equals(settings.msg("button.cancel"))) {
                    result = null;
                }
                shell.close();
            }
        });
    }

    protected void createMountingTab(final TabFolder tabFolder) {
        mountingTabItem = new TabItem(tabFolder, SWT.NONE);
        mountingTabItem.setText(settings.msg("dialog.template.tab.mounting"));

        final Composite composite = new Composite(tabFolder, SWT.NONE);
        composite.setLayout(new GridLayout());
        mountingTabItem.setControl(composite);

        createMountingGroup(composite);
        createExecuteGroup(composite);
    }

    protected void createExecuteGroup(final Composite composite) {
        executeGroup = new Group(composite, SWT.NONE);
        executeGroup.setLayoutData(new GridData());
        executeGroup.setText(settings.msg("dialog.template.execute"));
        final GridLayout gridLayout_18 = new GridLayout();
        executeGroup.setLayout(gridLayout_18);

        dosButton = new Button(executeGroup, SWT.RADIO);
        dosButton.setText(settings.msg("dialog.template.dos"));

        final Label label_1 = new Label(executeGroup, SWT.SEPARATOR | SWT.HORIZONTAL);
        label_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));

        booterButton = new Button(executeGroup, SWT.RADIO);
        booterButton.setText(settings.msg("dialog.template.booter"));
    }

    protected void createMountingGroup(final Composite composite) {
        final Group mountGroup = new Group(composite, SWT.NONE);
        mountGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        mountGroup.setText(settings.msg("dialog.template.mountingoverview"));
        final GridLayout gridLayout_19 = new GridLayout();
        gridLayout_19.numColumns = 2;
        mountGroup.setLayout(gridLayout_19);

        mountingpoints = new List(mountGroup, SWT.V_SCROLL | SWT.BORDER);
        final GridData gridData_2 = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 3);
        mountingpoints.setLayoutData(gridData_2);
        mountingpoints.addMouseListener(new MouseAdapter() {
            public void mouseDoubleClick(final MouseEvent event) {
                if (mountingpoints.getSelectionIndex() == -1) {
                    doAddMount();
                } else {
                    doEditMount();
                }
            }
        });

        final Button addButton = new Button(mountGroup, SWT.NONE);
        addButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
        addButton.setText(settings.msg("dialog.template.mount.add"));
        addButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                doAddMount();
            }
        });

        final Button editButton = new Button(mountGroup, SWT.NONE);
        editButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
        editButton.setText(settings.msg("dialog.template.mount.edit"));
        editButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                doEditMount();
            }
        });

        final Button removeButton = new Button(mountGroup, SWT.NONE);
        removeButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
        removeButton.setText(settings.msg("dialog.template.mount.remove"));
        removeButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                doRemoveMount();
            }
        });
    }

    protected void createIOTab(final TabFolder tabFolder) {
        final TabItem inputTabItem = new TabItem(tabFolder, SWT.NONE);
        inputTabItem.setText(settings.msg("dialog.template.tab.io"));

        final Composite composite_5 = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout_17 = new GridLayout();
        gridLayout_17.numColumns = 3;
        composite_5.setLayout(gridLayout_17);
        inputTabItem.setControl(composite_5);

        final Group mouseGroup = new Group(composite_5, SWT.NONE);
        mouseGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
        mouseGroup.setText(settings.msg("dialog.template.mouse"));
        final GridLayout gridLayout_13 = new GridLayout();
        gridLayout_13.numColumns = 2;
        mouseGroup.setLayout(gridLayout_13);

        final Label autolockLabel = new Label(mouseGroup, SWT.NONE);
        autolockLabel.setText(settings.msg("dialog.template.autolock"));
        autolock = new Button(mouseGroup, SWT.CHECK);
        autolock.setToolTipText(settings.msg("dialog.template.autolock.tooltip"));

        final Label sensitivityLabel = new Label(mouseGroup, SWT.NONE);
        sensitivityLabel.setText(settings.msg("dialog.template.sensitivity"));
        sensitivity = new Combo(mouseGroup, SWT.READ_ONLY);
        sensitivity.setItems(settings.getValues("profile", "sensitivity"));
        sensitivity.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false));
        sensitivity.setVisibleItemCount(20);
        sensitivity.setToolTipText(settings.msg("dialog.template.sensitivity.tooltip"));
        
        final Group keyboardGroup = new Group(composite_5, SWT.NONE);
        keyboardGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        keyboardGroup.setText(settings.msg("dialog.template.keyboard"));
        final GridLayout gridLayout_14 = new GridLayout();
        gridLayout_14.numColumns = 2;
        keyboardGroup.setLayout(gridLayout_14);

        final Label useScancodesLabel = new Label(keyboardGroup, SWT.NONE);
        useScancodesLabel.setText(settings.msg("dialog.template.usescancodes"));
        usescancodes = new Button(keyboardGroup, SWT.CHECK);
        usescancodes.setToolTipText(settings.msg("dialog.template.usescancodes.tooltip"));

        final Label mapperFileLabel = new Label(keyboardGroup, SWT.NONE);
        mapperFileLabel.setText(settings.msg("dialog.template.mapperfile"));
        mapperfile = new Text(keyboardGroup, SWT.BORDER);
        mapperfile.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        mapperfile.setToolTipText(settings.msg("dialog.template.mapperfile.tooltip"));

        final Label layoutLabel = new Label(keyboardGroup, SWT.NONE);
        layoutLabel.setText(settings.msg("dialog.template.keyboardlayout"));
        keyboard_layout = new Combo(keyboardGroup, SWT.NONE);
        keyboard_layout.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        keyboard_layout.setVisibleItemCount(15);
        keyboard_layout.setItems(settings.getValues("profile", "keyboardlayout"));
        keyboard_layout.setToolTipText(settings.msg("dialog.template.keyboardlayout.tooltip"));
        
        final Label keybLabel = new Label(keyboardGroup, SWT.NONE);
        keybLabel.setText(settings.msg("dialog.template.keybcommand"));
        keyb = new Text(keyboardGroup, SWT.BORDER);
        keyb.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Group joystickGroup = new Group(composite_5, SWT.NONE);
        joystickGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
        joystickGroup.setText(settings.msg("dialog.template.joystick"));
        final GridLayout gridLayout_15 = new GridLayout();
        gridLayout_15.numColumns = 2;
        joystickGroup.setLayout(gridLayout_15);

        final Label typeLabel_1 = new Label(joystickGroup, SWT.NONE);
        typeLabel_1.setText(settings.msg("dialog.template.joysticktype"));
        joysticktype = new Combo(joystickGroup, SWT.READ_ONLY);
        joysticktype.setItems(settings.getValues("profile", "joysticktype"));
        joysticktype.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        joysticktype.setToolTipText(settings.msg("dialog.template.joysticktype.tooltip"));

        final Label timedLabel = new Label(joystickGroup, SWT.NONE);
        timedLabel.setText(settings.msg("dialog.template.timedemulation"));
        timed = new Button(joystickGroup, SWT.CHECK);
        timed.setToolTipText(settings.msg("dialog.template.timedemulation.tooltip"));

        final Label autofireLabel = new Label(joystickGroup, SWT.NONE);
        autofireLabel.setText(settings.msg("dialog.template.autofire"));
        autofire = new Button(joystickGroup, SWT.CHECK);
        autofire.setToolTipText(settings.msg("dialog.template.autofire.tooltip"));

        final Label swapAxes3Label = new Label(joystickGroup, SWT.NONE);
        swapAxes3Label.setText(settings.msg("dialog.template.swap34"));
        swap34 = new Button(joystickGroup, SWT.CHECK);
        swap34.setToolTipText(settings.msg("dialog.template.swap34.tooltip"));

        final Label buttonWrapLabel = new Label(joystickGroup, SWT.NONE);
        buttonWrapLabel.setText(settings.msg("dialog.template.buttonwrapping"));
        buttonwrap = new Button(joystickGroup, SWT.CHECK);
        buttonwrap.setToolTipText(settings.msg("dialog.template.buttonwrapping.tooltip"));

        final Group modemGroup = new Group(composite_5, SWT.NONE);
        modemGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        modemGroup.setText(settings.msg("dialog.template.modem"));
        final GridLayout gridLayout_16 = new GridLayout();
        gridLayout_16.numColumns = 2;
        modemGroup.setLayout(gridLayout_16);

        final Label serial1Label = new Label(modemGroup, SWT.NONE);
        serial1Label.setText(settings.msg("dialog.template.serial1"));
        serial1 = new Text(modemGroup, SWT.BORDER);
        serial1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        serial1.setToolTipText(settings.msg("dialog.template.serial.tooltip"));

        final Label serial2Label = new Label(modemGroup, SWT.NONE);
        serial2Label.setText(settings.msg("dialog.template.serial2"));
        serial2 = new Text(modemGroup, SWT.BORDER);
        serial2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        serial2.setToolTipText(settings.msg("dialog.template.serial.tooltip"));

        final Label serial3Label = new Label(modemGroup, SWT.NONE);
        serial3Label.setText(settings.msg("dialog.template.serial3"));
        serial3 = new Text(modemGroup, SWT.BORDER);
        serial3.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        serial3.setToolTipText(settings.msg("dialog.template.serial.tooltip"));

        final Label serial4Label = new Label(modemGroup, SWT.NONE);
        serial4Label.setText(settings.msg("dialog.template.serial4"));
        serial4 = new Text(modemGroup, SWT.BORDER);
        serial4.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        serial4.setToolTipText(settings.msg("dialog.template.serial.tooltip"));

        final Group networkGroup = new Group(composite_5, SWT.NONE);
        networkGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
        networkGroup.setText(settings.msg("dialog.template.network"));
        final GridLayout gridLayout_20 = new GridLayout();
        gridLayout_20.numColumns = 2;
        networkGroup.setLayout(gridLayout_20);

        final Label ipxLabel = new Label(networkGroup, SWT.NONE);
        ipxLabel.setText(settings.msg("dialog.template.enableipx"));
        ipx = new Button(networkGroup, SWT.CHECK);
        ipx.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                ipxnet.setEnabled(ipx.getSelection());
            }
        });
        ipx.setToolTipText(settings.msg("dialog.template.enableipx.tooltip"));
        
        final Label ipxnetCommandLabel = new Label(networkGroup, SWT.NONE);
        ipxnetCommandLabel.setText(settings.msg("dialog.template.ipxnetcommand"));
        new Label(networkGroup, SWT.NONE);
        
        ipxnet = new Text(networkGroup, SWT.BORDER);
        ipxnet.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
    }

    protected void createAudioTab(final TabFolder tabFolder) {
        final TabItem audioTabItem = new TabItem(tabFolder, SWT.NONE);
        audioTabItem.setText(settings.msg("dialog.template.tab.audio"));

        final Composite composite_4 = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout_9 = new GridLayout();
        gridLayout_9.numColumns = 3;
        composite_4.setLayout(gridLayout_9);
        audioTabItem.setControl(composite_4);

        final Group generalGroup = new Group(composite_4, SWT.NONE);
        generalGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        final GridLayout gridLayout_6 = new GridLayout();
        gridLayout_6.numColumns = 2;
        generalGroup.setLayout(gridLayout_6);
        generalGroup.setText(settings.msg("dialog.template.general"));

        final Label silentModeLabel = new Label(generalGroup, SWT.NONE);
        silentModeLabel.setText(settings.msg("dialog.template.silentmode"));
        nosound = new Button(generalGroup, SWT.CHECK);
        nosound.setToolTipText(settings.msg("dialog.template.silentmode.tooltip"));

        final Label sampleRateLabel = new Label(generalGroup, SWT.NONE);
        sampleRateLabel.setText(settings.msg("dialog.template.samplerate"));
        rate = new Combo(generalGroup, SWT.READ_ONLY);
        rate.setVisibleItemCount(10);
        rate.setItems(settings.getValues("profile", "rate"));
        rate.setLayoutData(new GridData());
        rate.setToolTipText(settings.msg("dialog.template.samplerate.tooltip"));

        final Label blockSizeLabel = new Label(generalGroup, SWT.NONE);
        blockSizeLabel.setText(settings.msg("dialog.template.blocksize"));
        blocksize = new Combo(generalGroup, SWT.READ_ONLY);
        blocksize.setItems(settings.getValues("profile", "blocksize"));
        blocksize.setLayoutData(new GridData());
        blocksize.setToolTipText(settings.msg("dialog.template.blocksize.tooltip"));

        final Label prebufferLabel = new Label(generalGroup, SWT.NONE);
        prebufferLabel.setText(settings.msg("dialog.template.prebuffer"));
        prebuffer = new Combo(generalGroup, SWT.NONE);
        prebuffer.setItems(settings.getValues("profile", "prebuffer"));
        prebuffer.setLayoutData(new GridData(70, SWT.DEFAULT));
        prebuffer.setToolTipText(settings.msg("dialog.template.prebuffer.tooltip"));

        final Label mpu401Label = new Label(generalGroup, SWT.NONE);
        mpu401Label.setText(settings.msg("dialog.template.mpu401"));
        mpu401 = new Combo(generalGroup, SWT.READ_ONLY);
        mpu401.setItems(settings.getValues("profile", "mpu401"));
        mpu401.setLayoutData(new GridData());
        mpu401.setToolTipText(settings.msg("dialog.template.mpu401.tooltip"));

        final Label midiDeviceLabel = new Label(generalGroup, SWT.NONE);
        midiDeviceLabel.setText(settings.msg("dialog.template.mididevice"));
        midi_device = new Combo(generalGroup, SWT.READ_ONLY);
        midi_device.setVisibleItemCount(10);
        midi_device.setItems(settings.getValues("profile", "device"));
        midi_device.setLayoutData(new GridData());
        midi_device.setToolTipText(settings.msg("dialog.template.mididevice.tooltip"));

        final Label configLabel = new Label(generalGroup, SWT.NONE);
        configLabel.setText(settings.msg("dialog.template.midiconfig"));
        midi_config = new Text(generalGroup, SWT.BORDER);
        midi_config.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        midi_config.setToolTipText(settings.msg("dialog.template.midiconfig.tooltip"));

        final Label mixerConfigLabel = new Label(generalGroup, SWT.NONE);
        mixerConfigLabel.setText(settings.msg("dialog.template.mixercommand"));
        mixer_config = new Text(generalGroup, SWT.BORDER);
        mixer_config.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Group soundblasterGroup = new Group(composite_4, SWT.NONE);
        soundblasterGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
        soundblasterGroup.setText(settings.msg("dialog.template.soundblaster"));
        final GridLayout gridLayout_7 = new GridLayout();
        gridLayout_7.numColumns = 2;
        soundblasterGroup.setLayout(gridLayout_7);

        final Label typeLabel = new Label(soundblasterGroup, SWT.NONE);
        typeLabel.setText(settings.msg("dialog.template.sbtype"));
        sbtype = new Combo(soundblasterGroup, SWT.READ_ONLY);
        sbtype.setVisibleItemCount(10);
        sbtype.setItems(settings.getValues("profile", "sbtype"));
        sbtype.setLayoutData(new GridData());
        sbtype.setToolTipText(settings.msg("dialog.template.sbtype.tooltip"));

        final Label oplRateLabel = new Label(soundblasterGroup, SWT.NONE);
        oplRateLabel.setText(settings.msg("dialog.template.sboplrate"));
        oplrate = new Combo(soundblasterGroup, SWT.READ_ONLY);
        oplrate.setVisibleItemCount(10);
        oplrate.setItems(settings.getValues("profile", "oplrate"));
        oplrate.setLayoutData(new GridData());
        oplrate.setToolTipText(settings.msg("dialog.template.sboplrate.tooltip"));

        final Label oplModeLabel = new Label(soundblasterGroup, SWT.NONE);
        oplModeLabel.setLayoutData(new GridData());
        oplModeLabel.setText(settings.msg("dialog.template.sboplmode"));
        oplmode = new Combo(soundblasterGroup, SWT.READ_ONLY);
        oplmode.setItems(settings.getValues("profile", "oplmode"));
        oplmode.setLayoutData(new GridData());
        oplmode.setToolTipText(settings.msg("dialog.template.sboplmode.tooltip"));
        
        final Label oplEmuLabel = new Label(soundblasterGroup, SWT.NONE);
        oplEmuLabel.setLayoutData(new GridData());
        oplEmuLabel.setText(settings.msg("dialog.template.sboplemu"));
        oplemu = new Combo(soundblasterGroup, SWT.READ_ONLY);
        oplemu.setItems(settings.getValues("profile", "oplemu"));
        oplemu.setLayoutData(new GridData());
        oplemu.setToolTipText(settings.msg("dialog.template.sboplemu.tooltip"));

        final Label addressLabel = new Label(soundblasterGroup, SWT.NONE);
        addressLabel.setText(settings.msg("dialog.template.sbaddress"));
        sbbase = new Combo(soundblasterGroup, SWT.READ_ONLY);
        sbbase.setItems(settings.getValues("profile", "sbbase"));
        sbbase.setLayoutData(new GridData());
        sbbase.setToolTipText(settings.msg("dialog.template.sbaddress.tooltip"));

        final Label irqLabel = new Label(soundblasterGroup, SWT.NONE);
        irqLabel.setText(settings.msg("dialog.template.sbirq"));
        irq = new Combo(soundblasterGroup, SWT.READ_ONLY);
        irq.setItems(settings.getValues("profile", "irq"));
        irq.setLayoutData(new GridData());
        irq.setToolTipText(settings.msg("dialog.template.sbirq.tooltip"));

        final Label dmaLabel = new Label(soundblasterGroup, SWT.NONE);
        dmaLabel.setText(settings.msg("dialog.template.sbdma"));
        dma = new Combo(soundblasterGroup, SWT.READ_ONLY);
        dma.setItems(settings.getValues("profile", "dma"));
        dma.setLayoutData(new GridData());
        dma.setToolTipText(settings.msg("dialog.template.sbdma.tooltip"));

        final Label hdmaLabel = new Label(soundblasterGroup, SWT.NONE);
        hdmaLabel.setLayoutData(new GridData());
        hdmaLabel.setText(settings.msg("dialog.template.sbhdma"));
        hdma = new Combo(soundblasterGroup, SWT.READ_ONLY);
        hdma.setItems(settings.getValues("profile", "hdma"));
        hdma.setLayoutData(new GridData());
        hdma.setToolTipText(settings.msg("dialog.template.sbhdma.tooltip"));

        final Label mixerLabel = new Label(soundblasterGroup, SWT.NONE);
        mixerLabel.setText(settings.msg("dialog.template.mixer"));
        sbmixer = new Button(soundblasterGroup, SWT.CHECK);
        sbmixer.setToolTipText(settings.msg("dialog.template.mixer.tooltip"));

        final Group gusGroup = new Group(composite_4, SWT.NONE);
        gusGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        gusGroup.setText(settings.msg("dialog.template.gravisultrasound"));
        final GridLayout gridLayout_8 = new GridLayout();
        gridLayout_8.numColumns = 2;
        gusGroup.setLayout(gridLayout_8);

        final Label enableLabel_1 = new Label(gusGroup, SWT.NONE);
        enableLabel_1.setLayoutData(new GridData());
        enableLabel_1.setText(settings.msg("dialog.template.enablegus"));
        gus = new Button(gusGroup, SWT.CHECK);
        gus.setLayoutData(new GridData());
        gus.setToolTipText(settings.msg("dialog.template.enablegus.tooltip"));

        final Label sampleRateLabel_2 = new Label(gusGroup, SWT.NONE);
        sampleRateLabel_2.setText(settings.msg("dialog.template.gusrate"));
        gusrate = new Combo(gusGroup, SWT.READ_ONLY);
        gusrate.setVisibleItemCount(10);
        gusrate.setItems(settings.getValues("profile", "gusrate"));
        gusrate.setLayoutData(new GridData());
        gusrate.setToolTipText(settings.msg("dialog.template.gusrate.tooltip"));

        final Label addressLabel_1 = new Label(gusGroup, SWT.NONE);
        addressLabel_1.setText(settings.msg("dialog.template.gusaddress"));
        gusbase = new Combo(gusGroup, SWT.READ_ONLY);
        gusbase.setItems(settings.getValues("profile", "gusbase"));
        gusbase.setLayoutData(new GridData());
        gusbase.setToolTipText(settings.msg("dialog.template.gusaddress.tooltip"));

        final Label irqLabel_1 = new Label(gusGroup, SWT.NONE);
        irqLabel_1.setText(settings.msg("dialog.template.gusirq1"));
        gusirq1 = new Combo(gusGroup, SWT.READ_ONLY);
        gusirq1.setItems(settings.getValues("profile", "irq1"));
        gusirq1.setLayoutData(new GridData());
        gusirq1.setToolTipText(settings.msg("dialog.template.gusirq1.tooltip"));

        final Label irq2Label = new Label(gusGroup, SWT.NONE);
        irq2Label.setText(settings.msg("dialog.template.gusirq2"));
        gusirq2 = new Combo(gusGroup, SWT.READ_ONLY);
        gusirq2.setItems(settings.getValues("profile", "irq2"));
        gusirq2.setLayoutData(new GridData());

        final Label dmaLabel_1 = new Label(gusGroup, SWT.NONE);
        dmaLabel_1.setText(settings.msg("dialog.template.gusdma1"));
        gusdma1 = new Combo(gusGroup, SWT.READ_ONLY);
        gusdma1.setItems(settings.getValues("profile", "dma1"));
        gusdma1.setLayoutData(new GridData());
        gusdma1.setToolTipText(settings.msg("dialog.template.gusdma1.tooltip"));

        final Label hdmaLabel_1 = new Label(gusGroup, SWT.NONE);
        hdmaLabel_1.setLayoutData(new GridData());
        hdmaLabel_1.setText(settings.msg("dialog.template.gusdma2"));
        gusdma2 = new Combo(gusGroup, SWT.READ_ONLY);
        gusdma2.setItems(settings.getValues("profile", "dma2"));
        gusdma2.setLayoutData(new GridData());

        final Label ultradirLabel = new Label(gusGroup, SWT.NONE);
        ultradirLabel.setText(settings.msg("dialog.template.ultradir"));
        ultradir = new Text(gusGroup, SWT.BORDER);
        ultradir.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        ultradir.setToolTipText(settings.msg("dialog.template.ultradir.tooltip"));

        final Group speakerGroup = new Group(composite_4, SWT.NONE);
        speakerGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        speakerGroup.setText(settings.msg("dialog.template.pcspeaker"));
        final GridLayout gridLayout_10 = new GridLayout();
        gridLayout_10.numColumns = 2;
        speakerGroup.setLayout(gridLayout_10);

        final Label enableLabel = new Label(speakerGroup, SWT.NONE);
        enableLabel.setText(settings.msg("dialog.template.enablepcspeaker"));
        pcspeaker = new Button(speakerGroup, SWT.CHECK);
        pcspeaker.setToolTipText(settings.msg("dialog.template.enablepcspeaker.tooltip"));

        final Label sampleRateLabel_1 = new Label(speakerGroup, SWT.NONE);
        sampleRateLabel_1.setText(settings.msg("dialog.template.pcrate"));
        pcrate = new Combo(speakerGroup, SWT.READ_ONLY);
        pcrate.setVisibleItemCount(10);
        pcrate.setItems(settings.getValues("profile", "pcrate"));
        pcrate.setLayoutData(new GridData());
        pcrate.setToolTipText(settings.msg("dialog.template.pcrate.tooltip"));

        final Group tandyGroup = new Group(composite_4, SWT.NONE);
        tandyGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false));
        tandyGroup.setText(settings.msg("dialog.template.tandy"));
        final GridLayout gridLayout_11 = new GridLayout();
        gridLayout_11.numColumns = 2;
        tandyGroup.setLayout(gridLayout_11);

        final Label enableLabel_2 = new Label(tandyGroup, SWT.NONE);
        enableLabel_2.setText(settings.msg("dialog.template.enabletandy"));
        tandy = new Combo(tandyGroup, SWT.READ_ONLY);
        tandy.setItems(settings.getValues("profile", "tandy"));
        tandy.setLayoutData(new GridData());
        tandy.setToolTipText(settings.msg("dialog.template.enabletandy.tooltip"));

        final Label sampleLabel2 = new Label(tandyGroup, SWT.NONE);
        sampleLabel2.setText(settings.msg("dialog.template.tandyrate"));
        tandyrate = new Combo(tandyGroup, SWT.READ_ONLY);
        tandyrate.setVisibleItemCount(10);
        tandyrate.setItems(settings.getValues("profile", "tandyrate"));
        tandyrate.setLayoutData(new GridData());
        tandyrate.setToolTipText(settings.msg("dialog.template.tandyrate.tooltip"));

        final Group disneyGroup = new Group(composite_4, SWT.NONE);
        disneyGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        disneyGroup.setText(settings.msg("dialog.template.miscellaneous"));
        final GridLayout gridLayout_12 = new GridLayout();
        gridLayout_12.numColumns = 2;
        disneyGroup.setLayout(gridLayout_12);

        final Label enableLabel_3 = new Label(disneyGroup, SWT.NONE);
        enableLabel_3.setText(settings.msg("dialog.template.enablesoundsource"));
        disney = new Button(disneyGroup, SWT.CHECK);
        disney.setToolTipText(settings.msg("dialog.template.enablesoundsource.tooltip"));
        
        final Composite composite2 = new Composite(disneyGroup, SWT.NONE);
        composite2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        final GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.numColumns = 2;
        composite2.setLayout(gridLayout2);
        
        final Label mt32RateLabel = new Label(composite2, SWT.NONE);
        mt32RateLabel.setText(settings.msg("dialog.template.mt32rate"));
        mt32rate = new Combo(composite2, SWT.READ_ONLY);
        mt32rate.setVisibleItemCount(10);
        mt32rate.setItems(settings.getValues("profile", "mt32rate"));
    }

    protected void createMachineTab(final TabFolder tabFolder) {
        final TabItem machineTabItem = new TabItem(tabFolder, SWT.NONE);
        machineTabItem.setText(settings.msg("dialog.template.tab.machine"));

        final Composite composite_3 = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout_2 = new GridLayout();
        composite_3.setLayout(gridLayout_2);
        machineTabItem.setControl(composite_3);

        final Group cpuGroup = new Group(composite_3, SWT.NONE);
        cpuGroup.setText(settings.msg("dialog.template.cpu"));
        final GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.numColumns = 6;
        cpuGroup.setLayout(gridLayout_3);

        final Label machineLabel = new Label(cpuGroup, SWT.NONE);
        machineLabel.setText(settings.msg("dialog.template.machine"));
        machine = new Combo(cpuGroup, SWT.READ_ONLY);
        machine.setItems(settings.getValues("profile", "machine"));
        machine.setLayoutData(new GridData());
        machine.setVisibleItemCount(20);
        machine.setToolTipText(settings.msg("dialog.template.machine.tooltip"));
        
        final Label cputypeLabel = new Label(cpuGroup, SWT.NONE);
        cputypeLabel.setText(settings.msg("dialog.template.cputype"));
        cpu_type = new Combo(cpuGroup, SWT.READ_ONLY);
        cpu_type.setItems(settings.getValues("profile", "cputype"));
        cpu_type.setLayoutData(new GridData());
        cpu_type.setVisibleItemCount(10);
        cpu_type.setToolTipText(settings.msg("dialog.template.cputype.tooltip"));
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);

        final Label coreLabel = new Label(cpuGroup, SWT.NONE);
        coreLabel.setText(settings.msg("dialog.template.core"));
        core = new Combo(cpuGroup, SWT.READ_ONLY);
        core.setItems(settings.getValues("profile", "core"));
        core.setLayoutData(new GridData());
        core.setToolTipText(settings.msg("dialog.template.core.tooltip"));
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);

        final Label cyclesLabel = new Label(cpuGroup, SWT.NONE);
        cyclesLabel.setText(settings.msg("dialog.template.cycles"));
        cycles = new Combo(cpuGroup, SWT.NONE);
        cycles.setItems(settings.getValues("profile", "cycles"));
        cycles.setLayoutData(new GridData(100, SWT.DEFAULT));
        cycles.setVisibleItemCount(15);
        cycles.setToolTipText(settings.msg("dialog.template.cycles.tooltip"));

        final Label upLabel = new Label(cpuGroup, SWT.NONE);
        upLabel.setLayoutData(new GridData());
        upLabel.setText(settings.msg("dialog.template.up"));
        cycles_up = new Combo(cpuGroup, SWT.NONE);
        cycles_up.setItems(settings.getValues("profile", "cycles_up"));
        cycles_up.setLayoutData(new GridData(75, SWT.DEFAULT));
        cycles_up.setToolTipText(settings.msg("dialog.template.up.tooltip"));

        final Label downLabel = new Label(cpuGroup, SWT.NONE);
        downLabel.setLayoutData(new GridData());
        downLabel.setText(settings.msg("dialog.template.down"));
        cycles_down = new Combo(cpuGroup, SWT.NONE);
        cycles_down.setItems(settings.getValues("profile", "cycles_down"));
        cycles_down.setLayoutData(new GridData(75, SWT.DEFAULT));
        cycles_down.setToolTipText(settings.msg("dialog.template.down.tooltip"));

        final Label timesynchedLabel = new Label(cpuGroup, SWT.NONE);
        timesynchedLabel.setText(settings.msg("dialog.template.timesynched"));
        timesynched = new Button(cpuGroup, SWT.CHECK);
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);
        new Label(cpuGroup, SWT.NONE);

        memoryGroup = new Group(composite_3, SWT.NONE);
        memoryGroup.setText(settings.msg("dialog.template.memory"));
        memoryGroup.setLayoutData(new GridData());
        final GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        memoryGroup.setLayout(gridLayout_4);

        final Label sizeLabel = new Label(memoryGroup, SWT.NONE);
        sizeLabel.setText(settings.msg("dialog.template.memorysize"));
        memsize = new Combo(memoryGroup, SWT.READ_ONLY);
        memsize.setItems(settings.getValues("profile", "memsize"));
        memsize.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        memsize.setToolTipText(settings.msg("dialog.template.memorysize.tooltip"));
        new Label(memoryGroup, SWT.NONE);
        new Label(memoryGroup, SWT.NONE);

        final Label xmsLabel = new Label(memoryGroup, SWT.NONE);
        xmsLabel.setText(settings.msg("dialog.template.xms"));
        xms = new Button(memoryGroup, SWT.CHECK);
        xms.setToolTipText(settings.msg("dialog.template.xms.tooltip"));
        new Label(memoryGroup, SWT.NONE);
        new Label(memoryGroup, SWT.NONE);

        final Label emsLabel = new Label(memoryGroup, SWT.NONE);
        emsLabel.setText(settings.msg("dialog.template.ems"));
        ems = new Button(memoryGroup, SWT.CHECK);
        ems.setToolTipText(settings.msg("dialog.template.ems.tooltip"));
        new Label(memoryGroup, SWT.NONE);
        new Label(memoryGroup, SWT.NONE);

        final Label umbLabel = new Label(memoryGroup, SWT.NONE);
        umbLabel.setText(settings.msg("dialog.template.umb"));
        umb = new Combo(memoryGroup, SWT.READ_ONLY);
        umb.setItems(settings.getValues("profile", "umb"));
        umb.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        umb.setToolTipText(settings.msg("dialog.template.umb.tooltip"));
        new Label(memoryGroup, SWT.NONE);
        new Label(memoryGroup, SWT.NONE);
    }

    protected void createDisplayTab(final TabFolder tabFolder) {
        final TabItem displayTabItem = new TabItem(tabFolder, SWT.NONE);
        displayTabItem.setText(settings.msg("dialog.template.tab.display"));

        final Composite composite_2 = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 4;
        composite_2.setLayout(gridLayout_5);
        displayTabItem.setControl(composite_2);

        final Label outputLabel = new Label(composite_2, SWT.NONE);
        outputLabel.setText(settings.msg("dialog.template.output"));
        output = new Combo(composite_2, SWT.READ_ONLY);
        output.setItems(settings.getValues("profile", "output"));
        output.setVisibleItemCount(10);
        output.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        output.setToolTipText(settings.msg("dialog.template.output.tooltip"));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label frameskipLabel = new Label(composite_2, SWT.NONE);
        frameskipLabel.setText(settings.msg("dialog.template.frameskip"));
        frameskip = new Combo(composite_2, SWT.READ_ONLY);
        frameskip.setItems(settings.getValues("profile", "frameskip"));
        frameskip.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        frameskip.setToolTipText(settings.msg("dialog.template.frameskip.tooltip"));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label scalerLabel = new Label(composite_2, SWT.NONE);
        scalerLabel.setText(settings.msg("dialog.template.scaler"));
        scaler = new Combo(composite_2, SWT.READ_ONLY);
        scaler.setItems(settings.getValues("profile", "scaler"));
        scaler.setVisibleItemCount(15);
        scaler.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        scaler.setToolTipText(settings.msg("dialog.template.scaler.tooltip"));

        final Label pixelshaderLabel = new Label(composite_2, SWT.NONE);
        pixelshaderLabel.setLayoutData(new GridData());
        pixelshaderLabel.setText(settings.msg("dialog.template.pixelshader"));
        pixelshader = new Combo(composite_2, SWT.READ_ONLY);
        pixelshader.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        pixelshader.setVisibleItemCount(15);
        pixelshader.setItems(settings.getValues("profile", "pixelshader"));

        final Label fullscreenLabel = new Label(composite_2, SWT.NONE);
        fullscreenLabel.setText(settings.msg("dialog.template.fullscreen"));
        fullscreen = new Button(composite_2, SWT.CHECK);
        fullscreen.setToolTipText(settings.msg("dialog.template.fullscreen.tooltip"));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label doubleBuffLabel = new Label(composite_2, SWT.NONE);
        doubleBuffLabel.setText(settings.msg("dialog.template.doublebuffering"));
        fulldouble = new Button(composite_2, SWT.CHECK);
        fulldouble.setToolTipText(settings.msg("dialog.template.doublebuffering.tooltip"));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label resolutionLabel = new Label(composite_2, SWT.NONE);
        resolutionLabel.setText(settings.msg("dialog.template.fullscreenresolution"));
        fullresolution = new Combo(composite_2, SWT.READ_ONLY);
        fullresolution.setItems(settings.getValues("profile", "fullresolution"));
        fullresolution.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        fullresolution.setVisibleItemCount(10);
        fullresolution.setToolTipText(settings.msg("dialog.template.fullscreenresolution.tooltip"));

        final Label windowResLabel = new Label(composite_2, SWT.NONE);
        windowResLabel.setText(settings.msg("dialog.template.windowresolution"));
        windowresolution = new Combo(composite_2, SWT.READ_ONLY);
        windowresolution.setItems(settings.getValues("profile", "windowresolution"));
        windowresolution.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        windowresolution.setVisibleItemCount(10);
        windowresolution.setToolTipText(settings.msg("dialog.template.windowresolution.tooltip"));

        final Label aspectLabel = new Label(composite_2, SWT.NONE);
        aspectLabel.setText(settings.msg("dialog.template.aspectcorrection"));
        aspect = new Button(composite_2, SWT.CHECK);
        aspect.setToolTipText(settings.msg("dialog.template.aspectcorrection.tooltip"));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);
        
        final Label overscanLabel = new Label(composite_2, SWT.NONE);
        overscanLabel.setText(settings.msg("dialog.template.overscan"));
        overscan = new Text(composite_2, SWT.BORDER);
        overscan.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label svgaChipsetLabel = new Label(composite_2, SWT.NONE);
        svgaChipsetLabel.setText(settings.msg("dialog.template.svgachipset"));
        svgachipset = new Combo(composite_2, SWT.READ_ONLY);
        svgachipset.setItems(settings.getValues("profile", "svgachipset"));
        svgachipset.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label videoRamLabel = new Label(composite_2, SWT.NONE);
        videoRamLabel.setText(settings.msg("dialog.template.videoram"));
        videoram = new Combo(composite_2, SWT.READ_ONLY);
        videoram.setItems(settings.getValues("profile", "videoram"));
        videoram.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);

        final Label vsyncModeLabel = new Label(composite_2, SWT.NONE);
        vsyncModeLabel.setText(settings.msg("dialog.template.vsyncmode"));
        vsyncmode = new Combo(composite_2, SWT.READ_ONLY);
        vsyncmode.setItems(settings.getValues("profile", "vsyncmode"));
        vsyncmode.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label vsyncRateLabel = new Label(composite_2, SWT.NONE);
        vsyncRateLabel.setLayoutData(new GridData());
        vsyncRateLabel.setText(settings.msg("dialog.template.vsyncrate"));
        vsyncrate = new Text(composite_2, SWT.BORDER);
        vsyncrate.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        final Label glideLabel = new Label(composite_2, SWT.NONE);
        glideLabel.setText(settings.msg("dialog.template.glide"));
        glide = new Button(composite_2, SWT.CHECK);

        final Label glidePortLabel = new Label(composite_2, SWT.NONE);
        glidePortLabel.setText(settings.msg("dialog.template.glideport"));
        glideport = new Text(composite_2, SWT.BORDER);
        glideport.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        new Label(composite_2, SWT.NONE);
        new Label(composite_2, SWT.NONE);
        final Label lfbGlideLabel = new Label(composite_2, SWT.NONE);
        lfbGlideLabel.setText(settings.msg("dialog.template.lfbglide"));
        lfbGlide = new Combo(composite_2, SWT.READ_ONLY);
        lfbGlide.setItems(settings.getValues("profile", "lfbglide"));
        lfbGlide.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
    }

    protected void createGeneralTab(final TabFolder tabFolder) {
        final TabItem generalTabItem = new TabItem(tabFolder, SWT.NONE);
        generalTabItem.setText(settings.msg("dialog.template.tab.general"));

        final Composite composite_1 = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout_1 = new GridLayout();
        composite_1.setLayout(gridLayout_1);
        generalTabItem.setControl(composite_1);

        associationGroup = new Group(composite_1, SWT.NONE);
        associationGroup.setText(settings.msg("dialog.template.association"));
        associationGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        final GridLayout gridLayout_4 = new GridLayout();
        gridLayout_4.numColumns = 4;
        associationGroup.setLayout(gridLayout_4);
        
        final Label dbversionLabel = new Label(associationGroup, SWT.NONE);
        dbversionLabel.setText(settings.msg("dialog.template.dosboxversion"));
        dbversion = new Combo(associationGroup, SWT.READ_ONLY);
        dbversion.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        dbversion.setVisibleItemCount(20);

        setButton = new Button(associationGroup, SWT.NONE);
        setButton.setText(settings.msg("dialog.template.set"));
        setButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                doLoadTemplateConf(setButton, true, false);
            }
        });
        setButton.setEnabled(false);

        dbversion.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                setButton.setEnabled(true);
            }
        });

        reloadButton = new Button(associationGroup, SWT.NONE);
        reloadButton.setText(settings.msg("dialog.template.reloadsettings"));
        reloadButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(final SelectionEvent event) {
                doLoadTemplateConf(setButton, false, false);
            }
        });

        miscGroup = new Group(composite_1, SWT.NONE);
        miscGroup.setText(settings.msg("dialog.template.miscellaneous"));
        miscGroup.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        final GridLayout gridLayout_5 = new GridLayout();
        gridLayout_5.numColumns = 3;
        miscGroup.setLayout(gridLayout_5);
        
        new Label(miscGroup, SWT.NONE);
        final Label activeLabel = new Label(miscGroup, SWT.NONE);
        activeLabel.setText(settings.msg("dialog.template.active"));
        final Label inactiveLabel = new Label(miscGroup, SWT.NONE);
        inactiveLabel.setText(settings.msg("dialog.template.inactive"));

        final Label priorityLabel = new Label(miscGroup, SWT.NONE);
        priorityLabel.setText(settings.msg("dialog.template.priority"));
        priority_active = new Combo(miscGroup, SWT.READ_ONLY);
        priority_active.setItems(settings.getValues("profile", "priority_active"));
        priority_active.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
        priority_active.setToolTipText(settings.msg("dialog.template.priority.tooltip"));
        priority_inactive = new Combo(miscGroup, SWT.READ_ONLY);
        priority_inactive.setItems(settings.getValues("profile", "priority_inactive"));
        priority_inactive.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
        priority_inactive.setToolTipText(settings.msg("dialog.template.priority.tooltip"));

        final Label waitOnErrorLabel = new Label(miscGroup, SWT.NONE);
        waitOnErrorLabel.setText(settings.msg("dialog.template.waitonerror"));
        waitonerror = new Button(miscGroup, SWT.CHECK);
        waitonerror.setToolTipText(settings.msg("dialog.template.waitonerror.tooltip"));
        new Label(miscGroup, SWT.NONE);

        final Label exitLabel = new Label(miscGroup, SWT.NONE);
        exitLabel.setText(settings.msg("dialog.template.exitafterwards"));
        exit = new Button(miscGroup, SWT.CHECK);
        new Label(miscGroup, SWT.NONE);

        final Label languageFileLabel = new Label(miscGroup, SWT.NONE);
        languageFileLabel.setLayoutData(new GridData());
        languageFileLabel.setText(settings.msg("dialog.template.languagefile"));
        language = new Text(miscGroup, SWT.BORDER);
        language.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        language.setToolTipText(settings.msg("dialog.template.languagefile.tooltip"));
        
        final Label capturesLabel = new Label(miscGroup, SWT.NONE);
        capturesLabel.setLayoutData(new GridData());
        capturesLabel.setText(settings.msg("dialog.template.captures"));
        captures = new Text(miscGroup, SWT.BORDER);
        captures.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        captures.setEditable(false);
        captures.setToolTipText(settings.msg("dialog.template.captures.tooltip"));
    }

    protected void createInfoTab(final TabFolder tabFolder) {
        infoTabItem = new TabItem(tabFolder, SWT.NONE);
        infoTabItem.setText(settings.msg("dialog.template.tab.info"));

        final Composite composite = new Composite(tabFolder, SWT.NONE);
        final GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout(gridLayout);
        infoTabItem.setControl(composite);

        final Label titleLabel = new Label(composite, SWT.NONE);
        titleLabel.setText(settings.msg("dialog.template.title"));
        title = new Text(composite, SWT.BORDER);
        title.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        
        final Label defaultLabel = new Label(composite, SWT.NONE);
        defaultLabel.setText(settings.msg("dialog.template.default"));
        defaultButton = new Button(composite, SWT.CHECK);
    }

    protected void selectSettingsByConfiguration() {
        Configuration conf = compConf.getCompositeConf();
        String priority = conf.getValue("sdl", "priority");
        String[] priorities = priority.split(",");
        if ((priorities != null) && (priorities.length >= 2)) {
            priority_active.setText(priorities[0]);
            priority_inactive.setText(priorities[1]);
        }
        setIfEnabled(conf, "sdl", "waitonerror", waitonerror);
        setIfEnabled(conf, "dosbox", "language", language);
        setIfEnabled(conf, "dosbox", "captures", captures);
        setIfEnabled(conf, "sdl", "output", output);
        setIfEnabled(conf, "render", "frameskip", frameskip);
        setIfEnabled(conf, "render", "scaler", scaler);
        setIfEnabled(conf, "sdl", "pixelshader", pixelshader);
        setIfEnabled(conf, "sdl", "fullscreen", fullscreen);
        setIfEnabled(conf, "sdl", "fulldouble", fulldouble);
        setIfEnabled(conf, "sdl", "fullresolution", fullresolution);
        setIfEnabled(conf, "sdl", "windowresolution", windowresolution);
        setIfEnabled(conf, "render", "aspect", aspect);
        setIfEnabled(conf, "sdl", "overscan", overscan);
        setIfEnabled(conf, "vga", "svgachipset", svgachipset);
        setIfEnabled(conf, "vga", "videoram", videoram);
        setIfEnabled(conf, "vsync", "vsyncmode", vsyncmode);
        setIfEnabled(conf, "vsync", "vsyncrate", vsyncrate);
        setIfEnabled(conf, "glide", "glide", glide);
        setIfEnabled(conf, "glide", "port", "grport", glideport);
        setIfEnabled(conf, "glide", "lfb", lfbGlide);
        setIfEnabled(conf, "dosbox", "machine", machine);
        setIfEnabled(conf, "cpu", "cputype", cpu_type);
        setIfEnabled(conf, "cpu", "core", core);
        setIfEnabled(conf, "cpu", "cycles", cycles);
        setIfEnabled(conf, "cpu", "cycleup", cycles_up);
        setIfEnabled(conf, "cpu", "cycledown", cycles_down);
        setIfEnabled(conf, "cpu", "timesynched", timesynched);
        setIfEnabled(conf, "dosbox", "memsize", memsize);
        setIfEnabled(conf, "dos", "xms", xms);
        setIfEnabled(conf, "dos", "ems", ems);
        setIfEnabled(conf, "dos", "umb", umb);
        setIfEnabled(conf, "mixer", "nosound", nosound);
        setIfEnabled(conf, "mixer", "rate", rate);
        setIfEnabled(conf, "midi", "mt32rate", mt32rate);
        setIfEnabled(conf, "mixer", "blocksize", blocksize);
        setIfEnabled(conf, "mixer", "prebuffer", prebuffer);
        setIfEnabled(conf, "midi", "mpu401", mpu401);
        setIfEnabled(conf, "midi", "device", "mididevice", midi_device);
        setIfEnabled(conf, "midi", "config", "midiconfig", midi_config);
        setIfEnabled(conf, "sblaster", "type", "sbtype", sbtype);
        setIfEnabled(conf, "sblaster", "oplmode", oplmode);
        setIfEnabled(conf, "sblaster", "oplrate", oplrate);
        setIfEnabled(conf, "sblaster", "oplemu", oplemu);
        setIfEnabled(conf, "sblaster", "base", "sbbase", sbbase);
        setIfEnabled(conf, "sblaster", "irq", irq);
        setIfEnabled(conf, "sblaster", "dma", dma);
        setIfEnabled(conf, "sblaster", "hdma", hdma);
        setIfEnabled(conf, "sblaster", "mixer", "sbmixer", sbmixer);
        setIfEnabled(conf, "gus", "gus", gus);
        setIfEnabled(conf, "gus", "rate", "gusrate", gusrate);
        setIfEnabled(conf, "gus", "base", "gusbase", gusbase);
        setIfEnabled(conf, "gus", "irq1", "gusirq", gusirq1);
        setIfEnabled(conf, "gus", "irq2", "gusirq", gusirq2);
        setIfEnabled(conf, "gus", "dma1", "gusdma", gusdma1);
        setIfEnabled(conf, "gus", "dma2", "gusdma", gusdma2);
        setIfEnabled(conf, "gus", "ultradir", ultradir);
        setIfEnabled(conf, "speaker", "pcspeaker", pcspeaker);
        setIfEnabled(conf, "speaker", "pcrate", pcrate);
        setIfEnabled(conf, "speaker", "tandy", tandy);
        setIfEnabled(conf, "speaker", "tandyrate", tandyrate);
        setIfEnabled(conf, "speaker", "disney", disney);
        setIfEnabled(conf, "sdl", "autolock", autolock);
        setIfEnabled(conf, "sdl", "sensitivity", sensitivity);
        setIfEnabled(conf, "sdl", "usescancodes", usescancodes);
        setIfEnabled(conf, "sdl", "mapperfile", mapperfile);
        setIfEnabled(conf, "dos", "keyboardlayout", keyboard_layout);
        if (conf.hasValue("joystick", "joysticktype")) {
            setIfEnabled(conf, "joystick", "joysticktype", joysticktype);
            setIfEnabled(conf, "joystick", "timed", timed);
            setIfEnabled(conf, "joystick", "autofire", autofire);
            setIfEnabled(conf, "joystick", "swap34", swap34);
            setIfEnabled(conf, "joystick", "buttonwrap", buttonwrap);
        } else {
            setIfEnabled(conf, "bios", "joysticktype", joysticktype);
        }
        setIfEnabled(conf, "serial", "serial1", serial1);
        setIfEnabled(conf, "serial", "serial2", serial2);
        setIfEnabled(conf, "serial", "serial3", serial3);
        setIfEnabled(conf, "serial", "serial4", serial4);
        setIfEnabled(conf, "ipx", "ipx", ipx);
        
        exit.setSelection(conf.isExit());
        mixer_config.setText(conf.getMixer());
        keyb.setText(conf.getKeyb());
        ipxnet.setEnabled(ipx.getSelection());
        ipxnet.setText(conf.getIpxnet());
        mountingpoints.setItems(conf.getMountingpoints());
        dosButton.setSelection(!conf.isBooter());
        booterButton.setSelection(conf.isBooter());
    }

    protected Configuration getConfigurationBySettings() {
        Configuration base = compConf.getBaseConf();
        Configuration conf = new Configuration(compConf.getCompositeConf(), false, null, false);
        conf.updateValue("sdl", "priority", priority_active.getText() + "," + priority_inactive.getText());
        conf.updateValue("sdl", "waitonerror", String.valueOf(waitonerror.getSelection()));
        conf.updateValue("dosbox", "language", language.getText());
        conf.updateValue("dosbox", "captures", captures.getText());
        conf.updateValue("sdl", "output", output.getText());
        conf.updateValue("render", "frameskip", frameskip.getText());
        conf.updateValue("render", "scaler", scaler.getText());
        conf.updateValue("sdl", "pixelshader", pixelshader.getText());
        conf.updateValue("sdl", "fullscreen", String.valueOf(fullscreen.getSelection()));
        conf.updateValue("sdl", "fulldouble", String.valueOf(fulldouble.getSelection()));
        conf.updateValue("sdl", "fullresolution", fullresolution.getText());
        conf.updateValue("sdl", "windowresolution", windowresolution.getText());
        conf.updateValue("render", "aspect", String.valueOf(aspect.getSelection()));
        conf.updateValue("sdl", "overscan", overscan.getText());
        conf.updateValue("vga", "svgachipset", svgachipset.getText());
        conf.updateValue("vga", "videoram", videoram.getText());
        conf.updateValue("vsync", "vsyncmode", vsyncmode.getText());
        conf.updateValue("vsync", "vsyncrate", vsyncrate.getText());
        conf.updateValue("glide", "glide", String.valueOf(glide.getSelection()));
        conf.updateValue("glide", "port", "grport", glideport.getText(), base);
        conf.updateValue("glide", "lfb", lfbGlide.getText());
        conf.updateValue("dosbox", "machine", machine.getText());
        conf.updateValue("cpu", "cputype", cpu_type.getText());
        conf.updateValue("cpu", "core", core.getText());
        conf.updateValue("cpu", "cycles", cycles.getText());
        conf.updateValue("cpu", "cycleup", cycles_up.getText());
        conf.updateValue("cpu", "cycledown", cycles_down.getText());
        conf.updateValue("cpu", "timesynched", String.valueOf(timesynched.getSelection()));
        conf.updateValue("dosbox", "memsize", memsize.getText());
        conf.updateValue("dos", "xms", String.valueOf(xms.getSelection()));
        conf.updateValue("dos", "ems", String.valueOf(ems.getSelection()));
        conf.updateValue("dos", "umb", umb.getText());
        conf.updateValue("mixer", "nosound", String.valueOf(nosound.getSelection()));
        conf.updateValue("mixer", "rate", rate.getText());
        conf.updateValue("midi", "mt32rate", mt32rate.getText());
        conf.updateValue("mixer", "blocksize", blocksize.getText());
        conf.updateValue("mixer", "prebuffer", prebuffer.getText());
        conf.updateValue("midi", "mpu401", mpu401.getText());
        conf.updateValue("midi", "device", "mididevice", midi_device.getText(), base);
        conf.updateValue("midi", "config", "midiconfig", midi_config.getText(), base);
        conf.updateValue("sblaster", "type", "sbtype", sbtype.getText(), base);
        conf.updateValue("sblaster", "oplmode", oplmode.getText());
        conf.updateValue("sblaster", "oplrate", oplrate.getText());
        conf.updateValue("sblaster", "oplemu", oplemu.getText());
        conf.updateValue("sblaster", "base", "sbbase", sbbase.getText(), base);
        conf.updateValue("sblaster", "sbbase", sbbase.getText());
        conf.updateValue("sblaster", "irq", irq.getText());
        conf.updateValue("sblaster", "dma", dma.getText());
        conf.updateValue("sblaster", "hdma", hdma.getText());
        conf.updateValue("sblaster", "mixer", "sbmixer", String.valueOf(sbmixer.getSelection()), base);
        conf.updateValue("gus", "gus", String.valueOf(gus.getSelection()));
        conf.updateValue("gus", "rate", "gusrate", gusrate.getText(), base);
        conf.updateValue("gus", "base", "gusbase", gusbase.getText(), base);
        conf.updateValue("gus", "irq1", "gusirq", gusirq1.getText(), base);
        conf.updateValue("gus", "irq2", gusirq2.getText());
        conf.updateValue("gus", "dma1", "gusdma", gusdma1.getText(), base);
        conf.updateValue("gus", "dma2", gusdma2.getText());
        conf.updateValue("gus", "ultradir", ultradir.getText());
        conf.updateValue("speaker", "pcspeaker", String.valueOf(pcspeaker.getSelection()));
        conf.updateValue("speaker", "pcrate", pcrate.getText());
        conf.updateValue("speaker", "tandy", tandy.getText());
        conf.updateValue("speaker", "tandyrate", tandyrate.getText());
        conf.updateValue("speaker", "disney", String.valueOf(disney.getSelection()));
        conf.updateValue("sdl", "autolock", String.valueOf(autolock.getSelection()));
        conf.updateValue("sdl", "sensitivity", sensitivity.getText());
        conf.updateValue("sdl", "usescancodes", String.valueOf(usescancodes.getSelection()));
        conf.updateValue("sdl", "mapperfile", mapperfile.getText());
        conf.updateValue("dos", "keyboardlayout", keyboard_layout.getText());
        if (base.hasValue("joystick", "joysticktype")) {
            conf.updateValue("joystick", "joysticktype", joysticktype.getText());
            conf.updateValue("joystick", "timed", String.valueOf(timed.getSelection()));
            conf.updateValue("joystick", "autofire", String.valueOf(autofire.getSelection()));
            conf.updateValue("joystick", "swap34", String.valueOf(swap34.getSelection()));
            conf.updateValue("joystick", "buttonwrap", String.valueOf(buttonwrap.getSelection()));
        } else {
            conf.updateValue("bios", "joysticktype", joysticktype.getText());
        }
        conf.updateValue("serial", "serial1", serial1.getText());
        conf.updateValue("serial", "serial2", serial2.getText());
        conf.updateValue("serial", "serial3", serial3.getText());
        conf.updateValue("serial", "serial4", serial4.getText());
        conf.updateValue("ipx", "ipx", String.valueOf(ipx.getSelection()));
        conf.setAutoexecSettings(exit.getSelection(), mixer_config.getText(), 
                keyb.getText(), ipx.getSelection()? ipxnet.getText(): "", 
                booterButton.getSelection());
        return conf;
    }

    protected void doAddMount() {
        final EditMountDialog addMountDialog = new EditMountDialog(shell);
        try {
            addMountDialog.setDefaultDriveletter(
               Mount.getFreeDriveletter(booterButton.getSelection(), mountingpoints.getItems()));
        } catch (Exception e) {
            // nothing we can do, just take default 'C'
        }
        String mount = (String) addMountDialog.open();
        if (mount != null) {
            mountingpoints.setItems(compConf.addMount(mount));
            mountingpoints.select(mountingpoints.getItemCount() - 1);
        }
    }

    protected void doEditMount() {
        int mounts = mountingpoints.getItemCount();
        int sel = mountingpoints.getSelectionIndex();
        if (sel != -1) {
            final EditMountDialog editMountDialog = new EditMountDialog(shell);
            editMountDialog.setMount(mountingpoints.getItem(sel));
            String mount = (String) editMountDialog.open();
            if (mount != null) {
                mountingpoints.setItems(compConf.editMount(sel, mount));
                if (mountingpoints.getItemCount() == mounts) {
                    mountingpoints.select(sel);
                } else {
                    mountingpoints.select(mountingpoints.getItemCount() - 1);
                }
            }
        }
    }
    
    protected void doRemoveMount() {
        int mounts = mountingpoints.getItemCount();
        int sel = mountingpoints.getSelectionIndex();
        if (sel == -1 && mounts == 1) { sel = 0; mountingpoints.select(sel); }
        if (sel != -1) {
            mountingpoints.setItems(compConf.removeMount(sel));
            if (mountingpoints.getItemCount() == mounts) {
                mountingpoints.select(sel);
            } else {
                if (mountingpoints.getItemCount() > 0) {
                    mountingpoints.select(mountingpoints.getItemCount() - 1);
                }
            }
        }
    }

    protected void enableSettingsByConfiguration() {
        Configuration conf = compConf.getBaseConf();
        
        if (conf.hasValue("cpu", "cputype")) {
            machine.setItems(settings.getValues("profile", "machine073"));
        } else {
            machine.setItems(settings.getValues("profile", "machine"));
        }
        
        enableDisableControl(conf, "cpu", "cputype", cpu_type);
        enableDisableControl(conf, "sdl", "pixelshader", pixelshader);
        enableDisableControl(conf, "sdl", "overscan", overscan);
        enableDisableControl(conf, "vga", "svgachipset", svgachipset);
        enableDisableControl(conf, "vga", "videoram", videoram);
        enableDisableControl(conf, "vsync", "vsyncmode", vsyncmode);
        enableDisableControl(conf, "vsync", "vsyncrate", vsyncrate);
        enableDisableControl(conf, "glide", "glide", glide);
        enableDisableControl(conf, "glide", "port", "grport", glideport);
        enableDisableControl(conf, "glide", "lfb", lfbGlide);
        enableDisableControl(conf, "cpu", "timesynched", timesynched);
        enableDisableControl(conf, "sblaster", "oplemu", oplemu);
        enableDisableControl(conf, "gus", "irq2", gusirq2);
        enableDisableControl(conf, "gus", "dma2", gusdma2);
        enableDisableControl(conf, "midi", "mt32rate", mt32rate);
        enableDisableControl(conf, "joystick", "timed", timed);
        enableDisableControl(conf, "joystick", "autofire", autofire);
        enableDisableControl(conf, "joystick", "swap34", swap34);
        enableDisableControl(conf, "joystick", "buttonwrap", buttonwrap);
        enableDisableControl(conf, "dos", "keyboardlayout", keyboard_layout);
    }

    protected void doLoadTemplateConf(final Button setButton, final boolean keepValues, final boolean isTemplate) {
        compConf.setCompositeConf(getConfigurationBySettings());
        CompositeConfiguration newCompConf = obtainNewConf(keepValues, isTemplate);
        
        if (newCompConf.getCompositeConf() == null) {
            GeneralPurposeDialogs.infoMessage(shell, settings.msg("dialog.template.notice.noloadnochanges"));
        } else {
            compConf = newCompConf;
            enableSettingsByConfiguration();
            selectSettingsByConfiguration();
            setButton.setEnabled(false);
        }
    }
    
    protected CompositeConfiguration obtainNewConf(final boolean keepValues, final boolean isTemplate) {
        return new CompositeConfiguration(compConf,
                dbversionsList.get(dbversion.getSelectionIndex()), keepValues, true, shell, System.out);
    }
    
    protected static void enableDisableControl(final Configuration dbConf, final String section, final String oldItem,
    		final String newItem, final Control control) {
    	control.setEnabled(dbConf.hasValue(section, newItem) || dbConf.hasValue(section, oldItem));
    }

    protected static void enableDisableControl(final Configuration dbConf, final String section, final String item,
            final Control control) {
        control.setEnabled(dbConf.hasValue(section, item));
    }
    
    protected static void setIfEnabled(final Configuration conf, final String section, final String item, final Control control) {
        if (control.isEnabled()) {
            if (control instanceof Text) {
                ((Text)control).setText(conf.getValue(section, item));
            } else if (control instanceof Combo) {
                ((Combo)control).setText(conf.getValue(section, item));
            } else if (control instanceof Button) {
                ((Button)control).setSelection(conf.getBooleanValue(section, item));
            }
        }
    }
    
    protected static void setIfEnabled(final Configuration conf, final String section, 
            final String oldItem, final String newItem, final Control control) {
        if (conf.hasValue(section, newItem)) {
            setIfEnabled(conf, section, newItem, control);
        } else {
            setIfEnabled(conf, section, oldItem, control);
        }
    }
    
    protected boolean isValid() {
        GeneralPurposeDialogs.initErrorDialog();
        if (title.getText().equals("")) {
            GeneralPurposeDialogs.addError(settings.msg("dialog.template.required.title"), title, infoTabItem);
        }
        return !GeneralPurposeDialogs.displayErrorDialog(shell);
    }
}
