/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSFontPanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;
    boolean selected;
    int fontID;
    int fontSize;

    public FontDialog(Shell shell) {
        this(shell, 65536);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, FontDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    void changeFont(int n, int n2, int n3) {
        this.selected = true;
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        NSFont nSFont;
        Display display = this.parent != null ? this.parent.display : Display.getCurrent();
        NSFontPanel nSFontPanel = NSFontPanel.sharedFontPanel();
        nSFontPanel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        boolean bl = this.fontData != null;
        Font font = bl ? new Font((Device)display, this.fontData) : display.getSystemFont();
        nSFontPanel.setPanelFont(font.handle, false);
        SWTPanelDelegate sWTPanelDelegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
        int n = OS.NewGlobalRef(this);
        if (n == 0) {
            SWT.error(2);
        }
        OS.object_setInstanceVariable(sWTPanelDelegate.id, Display.SWT_OBJECT, n);
        nSFontPanel.setDelegate(sWTPanelDelegate);
        this.fontData = null;
        this.selected = false;
        nSFontPanel.orderFront(null);
        display.setModalDialog(this);
        NSApplication.sharedApplication().runModalForWindow(nSFontPanel);
        display.setModalDialog(null);
        if (this.selected && (nSFont = nSFontPanel.panelConvertFont(font.handle)) != null) {
            this.fontData = Font.cocoa_new(display, nSFont).getFontData()[0];
        }
        nSFontPanel.setDelegate(null);
        sWTPanelDelegate.release();
        OS.DeleteGlobalRef(n);
        if (bl) {
            font.dispose();
        }
        return this.fontData;
    }

    void setColor_forAttribute(int n, int n2, int n3, int n4) {
        if (n4 != 0 && NSString.stringWith("NSColor").isEqualToString(new NSString(n4))) {
            if (n3 != 0) {
                NSColor nSColor = new NSColor(n3);
                nSColor = nSColor.colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                this.rgb = new RGB((int)(nSColor.redComponent() * 255.0f), (int)(nSColor.greenComponent() * 255.0f), (int)(nSColor.blueComponent() * 255.0f));
            } else {
                this.rgb = null;
            }
        }
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }

    void windowWillClose(int n, int n2, int n3) {
        NSApplication.sharedApplication().stop(null);
    }
}

