/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.ControlEditTextSelectionRec;
import org.eclipse.swt.internal.carbon.ControlFontStyleRec;
import org.eclipse.swt.internal.carbon.HILayoutInfo;
import org.eclipse.swt.internal.carbon.HISideBinding;
import org.eclipse.swt.internal.carbon.HIThemeFrameDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.carbon.TXNTab;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class Text
extends Scrollable {
    int txnObject;
    int frameHandle;
    int textLimit = LIMIT;
    int tabs = 8;
    ControlEditTextSelectionRec selection;
    char echoCharacter;
    boolean doubleClick;
    String hiddenText;
    String message;
    public static final int LIMIT = Integer.MAX_VALUE;
    public static final String DELIMITER = "\r";
    static final char PASSWORD = '\u2022';
    static final String[] AX_ATTRIBUTES = new String[]{"AXTitle", "AXValue", "AXNumberOfCharacters", "AXSelectedText", "AXSelectedTextRange", "AXStringForRange"};

    public Text(Composite composite, int n) {
        super(composite, Text.checkStyle(n));
        if ((n & 0x80) != 0) {
            int n2 = 0;
            if ((n & 0x100) != 0) {
                this.style |= 0x100;
                n2 |= 1;
            }
            if ((n & 0x200) != 0) {
                this.style |= 0x200;
                n2 |= 2;
            }
            if (n2 != 0) {
                OS.HISearchFieldChangeAttributes(this.handle, n2, 0);
            }
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    public void append(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, n = this.getCharCount(), n, null)) == null) {
            return;
        }
        if (this.txnObject == 0) {
            this.setSelection(this.getCharCount());
            this.insertEditText(string);
        } else {
            this.setTXNText(Integer.MAX_VALUE, Integer.MAX_VALUE, string);
            OS.TXNSetSelection(this.txnObject, Integer.MAX_VALUE, Integer.MAX_VALUE);
            OS.TXNShowSelection(this.txnObject, false);
        }
        if (string.length() != 0) {
            this.sendModifyEvent(true);
        }
    }

    static int checkStyle(int n) {
        if ((n & 0x80) != 0) {
            n |= 0x804;
            n &= 0xFFBFFFFF;
        }
        if ((n & 4) != 0 && (n & 2) != 0) {
            n &= 0xFFFFFFFD;
        }
        if (((n = Text.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0)) & 4) != 0) {
            n &= 0xFFFFFCBF;
        }
        if ((n & 0x40) != 0) {
            n |= 2;
            n &= 0xFFFFFEFF;
        }
        if ((n & 2) != 0) {
            n &= 0xFFBFFFFF;
        }
        if ((n & 6) != 0) {
            return n;
        }
        if ((n & 0x300) != 0) {
            return n | 2;
        }
        return n | 4;
    }

    int callPaintEventHandler(int n, int n2, int n3, int n4, int n5) {
        int n6 = super.callPaintEventHandler(n, n2, n3, n4, n5);
        if (this.frameHandle == n) {
            int[] nArray = new int[1];
            OS.GetEventParameter(n4, 1668183160, 1668183160, null, 4, null, nArray);
            OS.CGContextSaveGState(nArray[0]);
            int[] nArray2 = new int[1];
            OS.GetThemeMetric(7, nArray2);
            CGRect cGRect = new CGRect();
            OS.HIViewGetBounds(this.frameHandle, cGRect);
            cGRect.x += (float)nArray2[0];
            cGRect.y += (float)nArray2[0];
            cGRect.width -= (float)(nArray2[0] * 2);
            cGRect.height -= (float)(nArray2[0] * 2);
            int n7 = OS.IsControlEnabled(n) ? (OS.IsControlActive(n) ? 1 : 0) : (OS.IsControlActive(n) ? 7 : 8);
            HIThemeFrameDrawInfo hIThemeFrameDrawInfo = new HIThemeFrameDrawInfo();
            hIThemeFrameDrawInfo.state = n7;
            hIThemeFrameDrawInfo.isFocused = this.hasFocus();
            hIThemeFrameDrawInfo.kind = 0;
            OS.HIThemeDrawFrame(cGRect, hIThemeFrameDrawInfo, nArray[0], 0);
            if ((this.style & 0x300) == 768) {
                OS.HIViewGetBounds(this.frameHandle, cGRect);
                cGRect.x = cGRect.width - (float)nArray2[0];
                cGRect.y = cGRect.height - (float)nArray2[0];
                OS.GetThemeMetric(5, nArray2);
                cGRect.x -= (float)nArray2[0];
                cGRect.y -= (float)nArray2[0];
                OS.GetThemeMetric(0, nArray2);
                cGRect.x -= (float)nArray2[0];
                cGRect.y -= (float)nArray2[0];
                cGRect.width = cGRect.height = (float)nArray2[0];
                OS.CGContextSetFillColor(nArray[0], new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                OS.CGContextFillRect(nArray[0], cGRect);
            }
            OS.CGContextRestoreGState(nArray[0]);
        }
        return n6;
    }

    int callFocusEventHandler(int n, int n2) {
        short[] sArray = new short[1];
        if (this.txnObject == 0) {
            OS.GetEventParameter(n2, 1668313716, 1668313716, null, 2, null, sArray);
            if (sArray[0] == 0) {
                this.selection = new ControlEditTextSelectionRec();
                OS.GetControlData(this.handle, (short)0, 1936026725, 4, this.selection, null);
            }
        }
        int n3 = super.callFocusEventHandler(n, n2);
        if (this.isDisposed()) {
            return n3;
        }
        if (this.frameHandle != 0) {
            OS.HIViewSetNeedsDisplay(this.frameHandle, true);
        }
        if (this.txnObject == 0 && sArray[0] != 0 && this.selection != null) {
            OS.SetControlData(this.handle, 0, 1936026725, 4, this.selection);
            this.selection = null;
        }
        return n3;
    }

    public void clearSelection() {
        this.checkWidget();
        if (this.txnObject == 0) {
            Point point = this.getSelection();
            this.setSelection(point.x);
        } else {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.TXNGetSelection(this.txnObject, nArray, nArray2);
            OS.TXNSetSelection(this.txnObject, nArray[0], nArray[0]);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (this.txnObject == 0) {
            if ((this.style & 0x80) != 0) {
                object3 = new int[1];
                OS.GetControlData(this.handle, (short)0, 1667658612, 4, object3, null);
                object2 = this.textExtent(object3[0], 0);
                if (object3[0] != 0) {
                    OS.CFRelease(object3[0]);
                }
                n3 = ((Point)object2).x;
                n4 = ((Point)object2).y;
                object = new int[1];
                OS.GetThemeMetric(4, object);
                n4 += object[0] * 2;
                OS.GetThemeMetric(5, object);
                n4 += object[0] * 2;
            } else {
                if ((this.style & 0x20000) != 0) {
                    OS.SetControlData(this.handle, 0, 1936157795, 1, new byte[]{1});
                }
                object3 = new Rect();
                OS.GetBestControlRect(this.handle, (Rect)object3, null);
                if ((this.style & 0x20000) != 0) {
                    OS.SetControlData(this.handle, 0, 1936157795, 1, new byte[1]);
                }
                n3 = object3.right - object3.left;
                n4 = object3.bottom - object3.top;
            }
        } else {
            object3 = new int[1];
            OS.TXNGetData(this.txnObject, 0, Integer.MAX_VALUE, object3);
            if (object3[0] != 0) {
                Object object4;
                int n5 = OS.GetHandleSize(object3[0]);
                int n6 = 0;
                if (n5 != 0) {
                    object4 = new int[1];
                    OS.HLock(object3[0]);
                    OS.memmove(object4, object3[0], 4);
                    n6 = OS.CFStringCreateWithCharacters(0, object4[0], n5 / 2);
                    OS.HUnlock(object3[0]);
                }
                OS.DisposeHandle(object3[0]);
                object4 = this.textExtent(n6, n != -1 && (this.style & 0x40) != 0 ? n : 0);
                if (n6 != 0) {
                    OS.CFRelease(n6);
                }
                n3 = object4.x;
                n4 = object4.y;
            }
        }
        int n7 = this.message.length();
        if ((this.style & 4) != 0 && n7 > 0) {
            object2 = new char[n7];
            this.message.getChars(0, n7, (char[])object2, 0);
            object = this.textExtent((char[])object2, 0);
            n3 = Math.max(n3, object.x);
        }
        if (n3 <= 0) {
            n3 = 64;
        }
        if (n4 <= 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        object2 = this.computeTrim(0, 0, n3, n4);
        n3 = ((Rectangle)object2).width;
        n4 = ((Rectangle)object2).height;
        return new Point(n3, n4);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.GetThemeMetric(0, nArray);
        if (this.horizontalBar != null) {
            n4 += nArray[0];
        }
        if (this.verticalBar != null) {
            n3 += nArray[0];
        }
        Rect rect = this.inset();
        n -= rect.left;
        n2 -= rect.top;
        n3 += rect.left + rect.right;
        n4 += rect.top + rect.bottom;
        if (this.txnObject == 0) {
            rect = this.getInset();
            n -= rect.left;
            n2 -= rect.top;
            n3 += rect.left + rect.right;
            n4 += rect.top + rect.bottom;
        }
        if ((this.style & 0x80) != 0) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            OS.HISearchFieldGetAttributes(this.handle, nArray4);
            if ((nArray4[0] & 2) != 0) {
                OS.GetThemeMetric(this.display.smallFonts ? 123 : 109, nArray2);
            } else {
                OS.GetThemeMetric(this.display.smallFonts ? 120 : 76, nArray2);
            }
            if ((nArray4[0] & 1) != 0) {
                OS.GetThemeMetric(this.display.smallFonts ? 124 : 110, nArray3);
            } else {
                OS.GetThemeMetric(this.display.smallFonts ? 121 : 77, nArray3);
            }
            n3 += nArray2[0] + nArray3[0];
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public void copy() {
        this.checkWidget();
        if ((this.style & 0x400000) != 0 || this.echoCharacter != '\u0000') {
            return;
        }
        if (this.txnObject == 0) {
            Point point = this.getSelection();
            if (point.x == point.y) {
                return;
            }
            this.copyToClipboard(this.getEditText(point.x, point.y - 1));
        } else {
            OS.TXNCopy(this.txnObject);
        }
    }

    void createHandle() {
        if ((this.style & 8) != 0 && (this.style & 0xB00) == 0) {
            this.state |= 0x800;
        }
        int[] nArray = new int[1];
        if ((this.style & 2) != 0 || (this.style & 0x880) == 0) {
            int n;
            int n2;
            if ((this.style & 0x300) != 0 || OS.VERSION >= 4176) {
                n2 = 0;
                if ((this.style & 0x300) == 768) {
                    n2 |= 4;
                }
                if ((this.style & 0x100) != 0) {
                    n2 |= 2;
                }
                if ((this.style & 0x200) != 0) {
                    n2 |= 1;
                }
                if (n2 == 0) {
                    n2 |= 1;
                }
                OS.HIScrollViewCreate(n2, nArray);
                if (nArray[0] == 0) {
                    this.error(2);
                }
                this.scrolledHandle = nArray[0];
                OS.HIViewSetVisible(this.scrolledHandle, true);
            }
            n2 = 135168;
            if ((this.style & 0x20000) == 0 && (this.style & 4) != 0) {
                n2 |= 0x4000;
            }
            if ((this.style & 0x40) != 0) {
                n2 |= 0x800;
            }
            OS.HITextViewCreate(null, 0, n2, nArray);
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.handle = nArray[0];
            OS.HIViewSetVisible(this.handle, true);
            if ((this.state & 0x800) != 0) {
                OS.HITextViewSetBackgroundColor(this.handle, 0);
            }
            if ((this.style & 2) != 0 && (this.style & 0x800) != 0) {
                n = 2;
                OS.CreateUserPaneControl(0, null, n, nArray);
                if (nArray[0] == 0) {
                    this.error(2);
                }
                this.frameHandle = nArray[0];
            }
            this.txnObject = OS.HITextViewGetTXNObject(this.handle);
            n = OS.NewPtr(8);
            Rect rect = (this.style & 4) != 0 ? this.inset() : new Rect();
            OS.memmove(n, rect, 8);
            int[] nArray2 = new int[]{1685217639, 1716745570, 1768910966, 1835102823, 1786082164, 1819174002};
            int n3 = 1;
            if ((this.style & 0x1000000) != 0) {
                n3 = 4;
            }
            if ((this.style & 0x20000) != 0) {
                n3 = 2;
            }
            int n4 = 0;
            if ((this.style & 0x4000000) != 0) {
                n4 = 1;
            }
            int[] nArray3 = new int[]{1, 1, (this.style & 8) != 0 ? 1 : 0, n, n3, n4};
            OS.TXNSetTXNObjectControls(this.txnObject, false, nArray2.length, nArray2, nArray3);
            OS.DisposePtr(n);
        } else {
            if ((this.style & 0x80) != 0) {
                OS.HISearchFieldCreate(null, 0, 0, 0, nArray);
            } else {
                int n = OS.GetControlOwner(this.parent.handle);
                OS.CreateEditUnicodeTextControl(n, null, 0, (this.style & 0x400000) != 0, null, nArray);
            }
            if (nArray[0] == 0) {
                this.error(2);
            }
            this.handle = nArray[0];
            if ((this.style & 0x80) != 0 && this.display.smallFonts) {
                OS.SetControlData(this.handle, 0, 1936292453, 2, new short[]{1});
            }
            if ((this.style & 0x20000) == 0) {
                OS.SetControlData(this.handle, 0, 1936157795, 1, new byte[]{1});
            }
            if ((this.style & 8) != 0) {
                OS.SetControlData(this.handle, 0, 1819239275, 1, new byte[]{1});
            }
            if ((this.style & 0x1020000) != 0) {
                ControlFontStyleRec controlFontStyleRec = new ControlFontStyleRec();
                controlFontStyleRec.flags = (short)(controlFontStyleRec.flags | 0x40);
                if ((this.style & 0x1000000) != 0) {
                    controlFontStyleRec.just = 1;
                }
                if ((this.style & 0x20000) != 0) {
                    controlFontStyleRec.just = (short)-1;
                }
                OS.SetControlFontStyle(this.handle, controlFontStyleRec);
            }
            if ((this.style & 0x80) != 0) {
                OS.HIViewSetVisible(this.handle, true);
            }
        }
    }

    ScrollBar createScrollBar(int n) {
        return this.createStandardBar(n);
    }

    void createWidget() {
        super.createWidget();
        this.doubleClick = true;
        if ((this.style & 0x400000) != 0) {
            this.setEchoChar('\u2022');
        }
        this.message = "";
    }

    public void cut() {
        Object object;
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        boolean bl = true;
        char[] cArray = null;
        Point point = this.getSelection();
        if ((this.hooks(25) || this.filters(25)) && point.x != point.y) {
            cArray = this.getEditText(point.x, point.y - 1);
            object = this.verifyText("", point.x, point.y, null);
            if (object == null) {
                return;
            }
            if (((String)object).length() != 0) {
                this.copyToClipboard(cArray);
                if (this.txnObject == 0) {
                    this.insertEditText((String)object);
                } else {
                    this.setTXNText(-1, -1, (String)object);
                    OS.TXNShowSelection(this.txnObject, false);
                }
                bl = false;
            }
        }
        if (bl) {
            if (this.txnObject == 0) {
                if (cArray == null) {
                    cArray = this.getEditText(point.x, point.y - 1);
                }
                this.copyToClipboard(cArray);
                this.insertEditText("");
            } else {
                OS.TXNCut(this.txnObject);
                if (OS.TXNDataSize(this.txnObject) / 2 == 0) {
                    this.setFontStyle(this.font);
                }
            }
        }
        object = this.getSelection();
        if (!bl || !point.equals(object)) {
            this.sendModifyEvent(true);
        }
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    void deregister() {
        super.deregister();
        if (this.frameHandle != 0) {
            this.display.removeWidget(this.frameHandle);
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        if (bl) {
            int n3;
            Point point = this.getSelection();
            if (point.x != point.y && point.x <= (n3 = this.getPosition(n, n2)) && n3 < point.y && super.dragDetect(n, n2, bl, blArray)) {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, blArray);
    }

    void drawWidget(int n, int n2, int n3, int n4, int n5) {
        if ((this.style & 0x80) == 0 && (this.style & 4) != 0 && this.message.length() > 0 && !this.hasFocus() && this.getCharCount() == 0) {
            GCData gCData = new GCData();
            gCData.paintEvent = n5;
            gCData.visibleRgn = n4;
            GC gC = GC.carbon_new(this, gCData);
            Display display = this.getDisplay();
            short s = (short)display.getDepth();
            RGBColor rGBColor = new RGBColor();
            OS.GetThemeTextColor((short)13, s, true, rGBColor);
            float f = (float)(rGBColor.red >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(rGBColor.green >> 8 & 0xFF) / 255.0f;
            float f3 = (float)(rGBColor.blue >> 8 & 0xFF) / 255.0f;
            Color color = Color.carbon_new(display, new float[]{f, f2, f3, 1.0f});
            gC.setForeground(color);
            Rect rect = this.inset();
            gC.drawText(this.message, rect.left, rect.top);
            gC.dispose();
        }
        super.drawWidget(n, n2, n3, n4, n5);
    }

    int focusPart() {
        if ((this.style & 0x80) != 0) {
            return 5;
        }
        return super.focusPart();
    }

    String[] getAxAttributes() {
        return AX_ATTRIBUTES;
    }

    public int getBorderWidth() {
        this.checkWidget();
        if (this.hasBorder()) {
            int[] nArray = new int[1];
            OS.GetThemeMetric(5, nArray);
            return nArray[0];
        }
        return 0;
    }

    public int getCaretLineNumber() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return (this.getTopPixel() + this.getCaretLocation().y) / this.getLineHeight();
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if (this.txnObject == 0) {
            return new Point(0, 0);
        }
        CGPoint cGPoint = new CGPoint();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.TXNGetSelection(this.txnObject, nArray, nArray2);
        OS.TXNOffsetToHIPoint(this.txnObject, nArray[0], cGPoint);
        Rect rect = new Rect();
        OS.TXNGetViewRect(this.txnObject, rect);
        return new Point((int)cGPoint.x - rect.left, (int)cGPoint.y - rect.top);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if (this.txnObject == 0) {
            return this.getSelection().x;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.TXNGetSelection(this.txnObject, nArray, nArray2);
        return nArray[0];
    }

    public int getCharCount() {
        this.checkWidget();
        if (this.txnObject == 0) {
            int[] nArray = new int[1];
            int n = OS.GetControlData(this.handle, (short)0, 1667658612, 4, nArray, null);
            if (n != 0) {
                return 0;
            }
            int n2 = OS.CFStringGetLength(nArray[0]);
            OS.CFRelease(nArray[0]);
            return n2;
        }
        return OS.TXNDataSize(this.txnObject) / 2;
    }

    public boolean getDoubleClickEnabled() {
        this.checkWidget();
        return this.doubleClick;
    }

    public char getEchoChar() {
        this.checkWidget();
        return this.echoCharacter;
    }

    public boolean getEditable() {
        this.checkWidget();
        return (this.style & 8) == 0;
    }

    Rect getInset() {
        if ((this.style & 0x80) != 0) {
            return this.display.searchTextInset;
        }
        if (this.txnObject != 0) {
            return super.getInset();
        }
        return this.display.editTextInset;
    }

    public int getLineCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 1;
        }
        int[] nArray = new int[1];
        OS.TXNGetLineCount(this.txnObject, nArray);
        return nArray[0];
    }

    public String getLineDelimiter() {
        this.checkWidget();
        return DELIMITER;
    }

    public int getLineHeight() {
        this.checkWidget();
        if (this.txnObject == 0) {
            return this.textExtent((char[])new char[]{' '}, (int)0).y;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.TXNGetLineMetrics(this.txnObject, 0, nArray, nArray2);
        return OS.Fix2Long(nArray2[0]);
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    int getPosition(int n, int n2) {
        if (this.txnObject == 0) {
            return -1;
        }
        int[] nArray = new int[1];
        Rect rect = new Rect();
        OS.TXNGetViewRect(this.txnObject, rect);
        CGPoint cGPoint = new CGPoint();
        cGPoint.x = n + rect.left;
        cGPoint.y = n2 + rect.top;
        return OS.TXNHIPointToOffset(this.txnObject, cGPoint, nArray) == 0 ? nArray[0] : -1;
    }

    int getPosition(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.getPosition(point.x, point.y);
    }

    public Point getSelection() {
        this.checkWidget();
        if (this.txnObject == 0) {
            ControlEditTextSelectionRec controlEditTextSelectionRec;
            if (this.selection != null) {
                controlEditTextSelectionRec = this.selection;
            } else {
                controlEditTextSelectionRec = new ControlEditTextSelectionRec();
                OS.GetControlData(this.handle, (short)0, 1936026725, 4, controlEditTextSelectionRec, null);
            }
            return new Point(controlEditTextSelectionRec.selStart, controlEditTextSelectionRec.selEnd);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.TXNGetSelection(this.txnObject, nArray, nArray2);
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionCount() {
        this.checkWidget();
        if (this.txnObject == 0) {
            Point point = this.getSelection();
            return point.y - point.x;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.TXNGetSelection(this.txnObject, nArray, nArray2);
        return nArray2[0] - nArray[0];
    }

    public String getSelectionText() {
        this.checkWidget();
        if (this.txnObject == 0) {
            Point point = this.getSelection();
            if (point.x == point.y) {
                return "";
            }
            return new String(this.getEditText(point.x, point.y - 1));
        }
        return this.getTXNText(-1, -1);
    }

    public int getTabs() {
        this.checkWidget();
        return this.tabs;
    }

    public String getText() {
        this.checkWidget();
        if (this.txnObject == 0) {
            return new String(this.getEditText());
        }
        return this.getTXNText(0, Integer.MAX_VALUE);
    }

    public String getText(int n, int n2) {
        this.checkWidget();
        if (n > n2 || n2 < 0) {
            return "";
        }
        if (this.txnObject == 0) {
            return new String(this.getEditText(n, n2));
        }
        int n3 = OS.TXNDataSize(this.txnObject) / 2;
        if (n > (n2 = Math.min(n2, n3 - 1))) {
            return "";
        }
        n = Math.max(0, n);
        return this.getTXNText(n, n2 + 1);
    }

    char[] getEditText() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = OS.GetControlData(this.handle, (short)0, 1667658612, 4, nArray, nArray2);
        if (n != 0) {
            return new char[0];
        }
        int n2 = OS.CFStringGetLength(nArray[0]);
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        char[] cArray = new char[cFRange.length];
        if (this.hiddenText != null) {
            this.hiddenText.getChars(0, cFRange.length, cArray, 0);
        } else {
            OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
        }
        OS.CFRelease(nArray[0]);
        return cArray;
    }

    char[] getEditText(int n, int n2) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n3 = OS.GetControlData(this.handle, (short)0, 1667658612, 4, nArray, nArray2);
        if (n3 != 0) {
            return new char[0];
        }
        int n4 = OS.CFStringGetLength(nArray[0]);
        if (n > (n2 = Math.min(n2, n4 - 1))) {
            return new char[0];
        }
        n = Math.max(0, n);
        CFRange cFRange = new CFRange();
        cFRange.location = n;
        cFRange.length = Math.max(0, n2 - n + 1);
        char[] cArray = new char[cFRange.length];
        if (this.hiddenText != null) {
            this.hiddenText.getChars(cFRange.location, cFRange.location + cFRange.length, cArray, 0);
        } else {
            OS.CFStringGetCharacters(nArray[0], cFRange, cArray);
        }
        OS.CFRelease(nArray[0]);
        return cArray;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public int getTopIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        return this.getTopPixel() / this.getLineHeight();
    }

    public int getTopPixel() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return 0;
        }
        CGRect cGRect = new CGRect();
        OS.TXNGetHIRect(this.txnObject, 1, cGRect);
        int n = (int)cGRect.y;
        OS.TXNGetHIRect(this.txnObject, 2, cGRect);
        return n - (int)cGRect.y;
    }

    char[] getTXNChars(int n, int n2) {
        int[] nArray = new int[1];
        OS.TXNGetData(this.txnObject, n, n2, nArray);
        if (nArray[0] == 0) {
            return new char[0];
        }
        int n3 = OS.GetHandleSize(nArray[0]);
        if (n3 == 0) {
            return new char[0];
        }
        int[] nArray2 = new int[1];
        OS.HLock(nArray[0]);
        OS.memmove(nArray2, nArray[0], 4);
        char[] cArray = new char[n3 / 2];
        OS.memmove(cArray, nArray2[0], n3);
        OS.HUnlock(nArray[0]);
        OS.DisposeHandle(nArray[0]);
        return cArray;
    }

    String getTXNText(int n, int n2) {
        return new String(this.getTXNChars(n, n2));
    }

    void hookEvents() {
        int n;
        int[] nArray;
        int n2;
        super.hookEvents();
        if ((this.style & 0x80) != 0) {
            n2 = this.display.searchProc;
            nArray = new int[]{1936877156, 1, 1936877156, 2};
            n = OS.GetControlEventTarget(this.handle);
            OS.InstallEventHandler(n, n2, nArray.length / 2, nArray, this.handle, null);
        }
        if (this.frameHandle != 0) {
            n2 = this.display.controlProc;
            nArray = new int[]{1668183148, 4};
            n = OS.GetControlEventTarget(this.frameHandle);
            OS.InstallEventHandler(n, n2, nArray.length / 2, nArray, this.frameHandle, null);
        }
    }

    Rect inset() {
        if ((this.style & 0x80) != 0) {
            return super.inset();
        }
        if ((this.style & 4) != 0 && (this.style & 0x800) == 0) {
            Rect rect = new Rect();
            rect.bottom = 1;
            rect.right = 1;
            rect.top = 1;
            rect.left = 1;
            return rect;
        }
        if ((this.style & 2) != 0 && (this.style & 0x800) != 0) {
            int[] nArray = new int[1];
            OS.GetThemeMetric(7, nArray);
            Rect rect = new Rect();
            rect.left = (short)(rect.left + nArray[0]);
            rect.top = (short)(rect.top + nArray[0]);
            rect.right = (short)(rect.right + nArray[0]);
            rect.bottom = (short)(rect.bottom + nArray[0]);
            OS.GetThemeMetric(5, nArray);
            rect.left = (short)(rect.left + nArray[0]);
            rect.top = (short)(rect.top + nArray[0]);
            rect.right = (short)(rect.right + nArray[0]);
            rect.bottom = (short)(rect.bottom + nArray[0]);
            return rect;
        }
        return new Rect();
    }

    public void insert(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.hooks(25) || this.filters(25)) {
            Point point = this.getSelection();
            if ((string = this.verifyText(string, point.x, point.y, null)) == null) {
                return;
            }
        }
        if (this.txnObject == 0) {
            this.insertEditText(string);
        } else {
            this.setTXNText(-1, -1, string);
            OS.TXNShowSelection(this.txnObject, false);
        }
        if (string.length() != 0) {
            this.sendModifyEvent(true);
        }
    }

    void insertEditText(String string) {
        int n = string.length();
        Point point = this.getSelection();
        if (this.hasFocus() && this.hiddenText == null) {
            int n2;
            if (this.textLimit != LIMIT && (n2 = this.getCharCount()) - (point.y - point.x) + n > this.textLimit) {
                n = this.textLimit - n2 + (point.y - point.x);
            }
            char[] cArray = new char[n];
            string.getChars(0, cArray.length, cArray, 0);
            int n3 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
            if (n3 == 0) {
                this.error(13);
            }
            OS.SetControlData(this.handle, 0, 1768842086, 4, new int[]{n3});
            OS.CFRelease(n3);
        } else {
            int n4;
            String string2 = this.getText();
            if (this.textLimit != LIMIT && (n4 = string2.length()) - (point.y - point.x) + n > this.textLimit) {
                string = string.substring(0, this.textLimit - n4 + (point.y - point.x));
            }
            String string3 = String.valueOf(string2.substring(0, point.x)) + string + string2.substring(point.y);
            this.setEditText(string3);
            this.setSelection(point.x + string.length());
        }
    }

    int kEventAccessibleGetNamedAttribute(int n, int n2, int n3) {
        int n4 = -9874;
        if (this.txnObject != 0) {
            boolean bl;
            int[] nArray;
            int n5;
            int[] nArray2 = new int[1];
            OS.GetEventParameter(n2, 1635020397, 1667658612, null, 4, null, nArray2);
            int n6 = 0;
            if (nArray2[0] != 0) {
                n6 = OS.CFStringGetLength(nArray2[0]);
            }
            char[] cArray = new char[n6];
            CFRange cFRange = new CFRange();
            cFRange.length = n6;
            OS.CFStringGetCharacters(nArray2[0], cFRange, cArray);
            String string = new String(cArray);
            if (string.equals("AXRole") || string.equals("AXRoleDescription")) {
                String string2 = (this.style & 2) != 0 ? "AXTextArea" : "AXTextField";
                cArray = new char[string2.length()];
                string2.getChars(0, cArray.length, cArray, 0);
                nArray2[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                if (nArray2[0] != 0) {
                    if (string.equals("AXRole")) {
                        OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray2);
                    } else {
                        int n7 = OS.HICopyAccessibilityRoleDescription(nArray2[0], 0);
                        OS.SetEventParameter(n2, 1635022444, 1667658612, 4, new int[]{n7});
                        OS.CFRelease(n7);
                    }
                    OS.CFRelease(nArray2[0]);
                    n4 = 0;
                }
            } else if (OS.VERSION < 4176 && string.equals("AXFocused")) {
                OS.SetEventParameter(n2, 1635022444, 1651470188, 4, new boolean[]{this.hasFocus()});
                n4 = 0;
            } else if (string.equals("AXTitle")) {
                n4 = 0;
            } else if (string.equals("AXValue")) {
                cArray = this.getTXNChars(0, Integer.MAX_VALUE);
                nArray2[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                if (nArray2[0] != 0) {
                    OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray2);
                    OS.CFRelease(nArray2[0]);
                    n4 = 0;
                }
            } else if (string.equals("AXNumberOfCharacters")) {
                OS.SetEventParameter(n2, 1635022444, 1819242087, 4, new int[]{this.getCharCount()});
                n4 = 0;
            } else if (string.equals("AXSelectedText")) {
                Point point = this.getSelection();
                cArray = this.getTXNChars(point.x, point.y);
                nArray2[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                if (nArray2[0] != 0) {
                    OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray2);
                    OS.CFRelease(nArray2[0]);
                    n4 = 0;
                }
            } else if (string.equals("AXSelectedTextRange")) {
                Point point = this.getSelection();
                cFRange = new CFRange();
                cFRange.location = point.x;
                cFRange.length = point.y - point.x;
                int n8 = OS.AXValueCreate(4, cFRange);
                OS.SetEventParameter(n2, 1635022444, 1667658873, 4, new int[]{n8});
                OS.CFRelease(n8);
                n4 = 0;
            } else if (string.equals("AXStringForRange") && (n5 = OS.GetEventParameter(n2, 1635020897, 1667658873, null, 4, null, nArray = new int[1])) == 0 && (bl = OS.AXValueGetValue(nArray[0], 4, cFRange = new CFRange()))) {
                cArray = this.getTXNChars(cFRange.location, cFRange.location + cFRange.length);
                nArray2[0] = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
                if (nArray2[0] != 0) {
                    OS.SetEventParameter(n2, 1635022444, 1667658612, 4, nArray2);
                    OS.CFRelease(nArray2[0]);
                    n4 = 0;
                }
            }
        }
        if (this.accessible != null) {
            n4 = this.accessible.internal_kEventAccessibleGetNamedAttribute(n, n2, n4);
        }
        return n4;
    }

    int kEventMouseDown(int n, int n2, int n3) {
        int n4 = super.kEventMouseDown(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if (!this.doubleClick) {
            int[] nArray = new int[1];
            OS.GetEventParameter(n2, 1667460724, 1835100014, null, 4, null, nArray);
            if (nArray[0] > 1) {
                return 0;
            }
        }
        return n4;
    }

    int kEventSearchFieldCancelClicked(int n, int n2, int n3) {
        int n4 = super.kEventSearchFieldCancelClicked(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        this.setText("");
        Event event = new Event();
        event.detail = 256;
        this.sendSelectionEvent(14, event, false);
        return n4;
    }

    int kEventSearchFieldSearchClicked(int n, int n2, int n3) {
        int n4 = super.kEventSearchFieldSearchClicked(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        Event event = new Event();
        event.detail = 512;
        this.sendSelectionEvent(14, event, false);
        return n4;
    }

    int kEventUnicodeKeyPressed(int n, int n2, int n3) {
        int[] nArray;
        int n4 = super.kEventUnicodeKeyPressed(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        int[] nArray2 = new int[1];
        OS.GetEventParameter(n2, 1953721189, 1702261350, null, nArray2.length * 4, null, nArray2);
        int[] nArray3 = new int[1];
        OS.GetEventParameter(nArray2[0], 1802334052, 1835100014, null, 4, null, nArray3);
        if (nArray3[0] == 256) {
            nArray = new int[1];
            OS.GetEventParameter(nArray2[0], 1801678692, 1835100014, null, nArray.length * 4, null, nArray);
            switch (nArray[0]) {
                case 7: {
                    this.cut();
                    return 0;
                }
                case 8: {
                    this.copy();
                    return 0;
                }
                case 9: {
                    this.paste();
                    return 0;
                }
            }
        }
        if ((this.style & 4) != 0) {
            nArray = new int[1];
            OS.GetEventParameter(nArray2[0], 1801678692, 1835100014, null, nArray.length * 4, null, nArray);
            switch (nArray[0]) {
                case 36: 
                case 76: {
                    this.sendSelectionEvent(14);
                    return 0;
                }
                case 48: {
                    return 0;
                }
            }
        }
        return n4;
    }

    int kEventTextInputUpdateActiveInputArea(int n, int n2, int n3) {
        int[] nArray = new int[1];
        OS.GetEventParameter(n2, 1953723512, 1970567284, null, 0, nArray, null);
        int[] nArray2 = new int[1];
        OS.GetEventParameter(n2, 1953719928, 1819242087, null, 4, null, nArray2);
        if (nArray2[0] == -1 || nArray2[0] == nArray[0]) {
            this.sendModifyEvent(false);
        }
        return -9874;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        boolean bl = true;
        String string = null;
        if ((this.hooks(25) || this.filters(25)) && (string = this.getClipboardText()) != null) {
            Point point = this.getSelection();
            String string2 = this.verifyText(string, point.x, point.y, null);
            if (string2 == null) {
                return;
            }
            if (!string2.equals(string)) {
                if (this.txnObject == 0) {
                    this.insertEditText(string2);
                } else {
                    this.setTXNText(-1, -1, string2);
                    OS.TXNShowSelection(this.txnObject, false);
                }
                bl = false;
            }
        }
        if (bl) {
            if (this.txnObject == 0) {
                if (string == null) {
                    string = this.getClipboardText();
                }
                this.insertEditText(string);
            } else if (this.textLimit != LIMIT) {
                if (string == null) {
                    string = this.getClipboardText();
                }
                this.setTXNText(-1, -1, string);
                OS.TXNShowSelection(this.txnObject, false);
            } else {
                OS.TXNPaste(this.txnObject);
            }
        }
        this.sendModifyEvent(true);
    }

    boolean pollTrackEvent() {
        return true;
    }

    void register() {
        super.register();
        if (this.frameHandle != 0) {
            this.display.addWidget(this.frameHandle, this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.txnObject = 0;
        this.message = null;
        this.hiddenText = null;
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void selectAll() {
        this.checkWidget();
        if (this.txnObject == 0) {
            this.setSelection(0, this.getCharCount());
        } else {
            OS.TXNSelectAll(this.txnObject);
        }
    }

    boolean sendKeyEvent(int n, Event event) {
        boolean bl;
        String string;
        if (!super.sendKeyEvent(n, event)) {
            return false;
        }
        if (n != 1) {
            return true;
        }
        if ((this.style & 8) != 0) {
            return true;
        }
        if (event.character == '\u0000') {
            return true;
        }
        if ((event.stateMask & 0x400000) != 0) {
            return true;
        }
        String string2 = "";
        int n2 = this.getCharCount();
        Point point = this.getSelection();
        int n3 = point.x;
        int n4 = point.y;
        switch (event.character) {
            case '\b': {
                if (n3 != n4) break;
                if (n3 == 0) {
                    return true;
                }
                n3 = Math.max(0, n3 - 1);
                break;
            }
            case '\u007f': {
                if (n3 != n4) break;
                if (n3 == n2) {
                    return true;
                }
                n4 = Math.min(n4 + 1, n2);
                break;
            }
            case '\r': {
                if ((this.style & 4) != 0) {
                    return true;
                }
                string2 = DELIMITER;
                break;
            }
            default: {
                if (event.character != '\t' && event.character < ' ') {
                    return true;
                }
                string2 = new String(new char[]{event.character});
            }
        }
        if ((string = this.verifyText(string2, n3, n4, event)) == null) {
            return false;
        }
        if (n2 - (n4 - n3) + string.length() > this.textLimit) {
            return false;
        }
        boolean bl2 = bl = string == string2;
        if (string != string2 || this.hiddenText != null) {
            if (this.txnObject == 0) {
                String string3 = new String(this.getEditText());
                String string4 = string3.substring(0, n3);
                String string5 = string3.substring(n4, string3.length());
                this.setEditText(String.valueOf(string4) + string + string5);
                this.setSelection(new Point(n3 += string.length(), n3));
                bl = false;
            } else {
                this.setTXNText(n3, n4, string);
            }
        }
        this.sendModifyEvent(false);
        return bl;
    }

    void sendModifyEvent(boolean bl) {
        String string = "AXSelectedTextChanged";
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        OS.AXNotificationHIObjectNotify(n, this.handle, 0L);
        OS.CFRelease(n);
        string = "AXValueChanged";
        cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        n = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        OS.AXNotificationHIObjectNotify(n, this.handle, 0L);
        OS.CFRelease(n);
        if (bl) {
            this.sendEvent(24);
        } else {
            this.postEvent(24);
        }
    }

    void setBackground(float[] fArray) {
        if (this.txnObject == 0) {
            super.setBackground(fArray);
        } else {
            int n = OS.CGColorSpaceCreateDeviceRGB();
            int n2 = OS.CGColorCreate(n, fArray);
            OS.HITextViewSetBackgroundColor(this.handle, n2);
            OS.CGColorRelease(n2);
            OS.CGColorSpaceRelease(n);
        }
    }

    void setBackground(int n, float[] fArray) {
        if (this.handle == n) {
            ControlFontStyleRec controlFontStyleRec = new ControlFontStyleRec();
            OS.GetControlData(n, (short)0, 1718578804, 24, controlFontStyleRec, null);
            controlFontStyleRec.flags = (short)(controlFontStyleRec.flags | 0x10);
            OS.SetControlFontStyle(n, controlFontStyleRec);
            controlFontStyleRec.backColor_blue = (short)-1;
            controlFontStyleRec.backColor_green = (short)-1;
            controlFontStyleRec.backColor_red = (short)-1;
            OS.SetControlFontStyle(n, controlFontStyleRec);
        }
        super.setBackground(n, fArray);
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        Rectangle rectangle = null;
        if (this.txnObject == 0 && bl2) {
            rectangle = this.getBounds();
        }
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2, bl3);
        if (rectangle != null && (n5 & 0x80) != 0) {
            Rect rect = this.getInset();
            int n6 = rect.left + rect.right;
            if (rectangle.width <= n6 && n3 > n6) {
                if (this.hasFocus()) {
                    ControlEditTextSelectionRec controlEditTextSelectionRec = new ControlEditTextSelectionRec();
                    if (OS.GetControlData(this.handle, (short)0, 1936026725, 4, controlEditTextSelectionRec, null) == 0) {
                        OS.SetControlData(this.handle, 0, 1936026725, 4, controlEditTextSelectionRec);
                    }
                } else {
                    int[] nArray = new int[1];
                    if (OS.GetControlData(this.handle, (short)0, 1667658612, 4, nArray, null) == 0) {
                        OS.SetControlData(this.handle, 0, 1667658612, 4, nArray);
                    }
                    if (nArray[0] != 0) {
                        OS.CFRelease(nArray[0]);
                    }
                }
            }
        }
        if (this.scrolledHandle != 0 && (this.style & 0x300) == 0) {
            OS.HIScrollViewSetScrollBarAutoHide(this.scrolledHandle, true);
        }
        return n5;
    }

    public void setDoubleClickEnabled(boolean bl) {
        this.checkWidget();
        this.doubleClick = bl;
    }

    public void setEchoChar(char c) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.txnObject == 0) {
            if ((this.style & 0x400000) == 0) {
                Point point = this.getSelection();
                String string = this.getText();
                this.echoCharacter = c;
                this.setEditText(string);
                this.setSelection(point);
            }
        } else {
            OS.TXNEchoMode(this.txnObject, c, 126, c != '\u0000');
        }
        this.echoCharacter = c;
    }

    public void setEditable(boolean bl) {
        this.checkWidget();
        this.style = bl ? (this.style &= 0xFFFFFFF7) : (this.style |= 8);
        if (this.txnObject == 0) {
            OS.SetControlData(this.handle, 0, 1819239275, 1, new byte[]{(byte)((this.style & 8) != 0 ? 1 : 0)});
        } else {
            OS.TXNSetTXNObjectControls(this.txnObject, false, 1, new int[]{1768910966}, new int[]{(this.style & 8) != 0 ? 1 : 0});
        }
    }

    void setForeground(float[] fArray) {
        if (this.txnObject == 0) {
            super.setForeground(fArray);
        } else {
            int n = OS.NewPtr(6);
            RGBColor rGBColor = fArray == null ? new RGBColor() : this.toRGBColor(fArray);
            OS.memmove(n, rGBColor, 6);
            int[] nArray = new int[]{1802268530, 6, n};
            int n2 = OS.NewPtr(nArray.length * 4);
            OS.memmove(n2, nArray, nArray.length * 4);
            boolean bl = (this.style & 8) != 0;
            int[] nArray2 = new int[]{1768910966};
            if (bl) {
                OS.TXNSetTXNObjectControls(this.txnObject, false, 1, nArray2, new int[1]);
            }
            OS.TXNSetTypeAttributes(this.txnObject, nArray.length / 3, n2, 0, 0);
            if (bl) {
                OS.TXNSetTXNObjectControls(this.txnObject, false, 1, nArray2, new int[]{1});
            }
            OS.DisposePtr(n2);
            OS.DisposePtr(n);
        }
    }

    void setFontStyle(Font font) {
        if (this.txnObject == 0) {
            super.setFontStyle(font);
        } else {
            Object[] objectArray;
            int n = 0;
            int n2 = 0;
            int n3 = 786432;
            if (font != null) {
                objectArray = new short[1];
                short[] sArray = new short[1];
                OS.FMGetFontFamilyInstanceFromFont(font.handle, objectArray, sArray);
                n = objectArray[0];
                n2 = sArray[0] | font.style;
                n3 = OS.X2Fix(font.size);
            }
            objectArray = new int[]{1936292453, 2, n3, 1717658469, 2, n2, 1718578804, 2, n};
            int n4 = OS.NewPtr(objectArray.length * 4);
            OS.memmove(n4, (int[])objectArray, objectArray.length * 4);
            boolean bl = (this.style & 8) != 0;
            int[] nArray = new int[]{1768910966};
            if (bl) {
                OS.TXNSetTXNObjectControls(this.txnObject, false, 1, nArray, new int[1]);
            }
            OS.TXNSetTypeAttributes(this.txnObject, objectArray.length / 3, n4, 0, 0);
            if (bl) {
                OS.TXNSetTXNObjectControls(this.txnObject, false, 1, nArray, new int[]{1});
            }
            OS.DisposePtr(n4);
        }
    }

    public void setOrientation(int n) {
        this.checkWidget();
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if ((this.style & 0x80) != 0) {
            char[] cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            int n = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
            if (n == 0) {
                this.error(13);
            }
            OS.HISearchFieldSetDescriptiveText(this.handle, n);
            OS.CFRelease(n);
        } else {
            this.redraw(false);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.setSelection(n, n);
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        if (this.txnObject == 0) {
            int n3 = this.getCharCount();
            ControlEditTextSelectionRec controlEditTextSelectionRec = new ControlEditTextSelectionRec();
            controlEditTextSelectionRec.selStart = (short)Math.min(Math.max(Math.min(n, n2), 0), n3);
            controlEditTextSelectionRec.selEnd = (short)Math.min(Math.max(Math.max(n, n2), 0), n3);
            if (this.hasFocus()) {
                OS.SetControlData(this.handle, 0, 1936026725, 4, controlEditTextSelectionRec);
            } else {
                this.selection = controlEditTextSelectionRec;
            }
        } else {
            int n4 = OS.TXNDataSize(this.txnObject) / 2;
            int n5 = Math.min(Math.max(Math.min(n, n2), 0), n4);
            int n6 = Math.min(Math.max(Math.max(n, n2), 0), n4);
            OS.TXNSetSelection(this.txnObject, n5, n6);
            OS.TXNShowSelection(this.txnObject, false);
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSelection(point.x, point.y);
    }

    public void setTabs(int n) {
        this.checkWidget();
        if (this.tabs == n) {
            return;
        }
        if (this.txnObject == 0) {
            return;
        }
        this.tabs = n;
        TXNTab tXNTab = new TXNTab();
        tXNTab.value = (short)(this.textExtent((char[])new char[]{' '}, (int)0).x * n);
        int[] nArray = new int[]{1952539251};
        int[] nArray2 = new int[1];
        OS.memmove(nArray2, tXNTab, 4);
        OS.TXNSetTXNObjectControls(this.txnObject, false, nArray.length, nArray, nArray2);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, this.getCharCount(), null)) == null) {
            return;
        }
        if (this.txnObject == 0) {
            this.setEditText(string);
        } else {
            this.setTXNText(0, Integer.MAX_VALUE, string);
            OS.TXNSetSelection(this.txnObject, 0, 0);
            OS.TXNShowSelection(this.txnObject, false);
        }
        this.sendModifyEvent(true);
    }

    void setEditText(String string) {
        int n;
        char[] cArray;
        if ((this.style & 0x400000) == 0 && this.echoCharacter != '\u0000') {
            this.hiddenText = string;
            cArray = new char[Math.min(this.hiddenText.length(), this.textLimit)];
            n = 0;
            while (n < cArray.length) {
                cArray[n] = this.echoCharacter;
                ++n;
            }
        } else {
            this.hiddenText = null;
            cArray = new char[Math.min(string.length(), this.textLimit)];
            string.getChars(0, cArray.length, cArray, 0);
        }
        n = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
        if (n == 0) {
            this.error(13);
        }
        OS.SetControlData(this.handle, 0, 1667658612, 4, new int[]{n});
        OS.CFRelease(n);
        if (this.selection != null) {
            this.selection = null;
        }
    }

    void setTXNText(int n, int n2, String string) {
        int n3;
        int n4 = string.length();
        if (this.textLimit != LIMIT) {
            int n5 = OS.TXNDataSize(this.txnObject) / 2;
            n3 = n;
            int n6 = n2;
            if (n == -1 || n2 == -1) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.TXNGetSelection(this.txnObject, nArray, nArray2);
                n3 = nArray[0];
                n6 = nArray2[0];
            } else {
                if (n == Integer.MAX_VALUE) {
                    n3 = n5;
                }
                if (n2 == Integer.MAX_VALUE) {
                    n6 = n5;
                }
            }
            if (n5 - (n6 - n3) + n4 > this.textLimit) {
                n4 = this.textLimit - n5 + (n6 - n3);
            }
        }
        char[] cArray = new char[n4];
        string.getChars(0, cArray.length, cArray, 0);
        n3 = (this.style & 8) != 0 ? 1 : 0;
        int[] nArray = new int[]{1768910966};
        if (n3 != 0) {
            OS.TXNSetTXNObjectControls(this.txnObject, false, 1, nArray, new int[1]);
        }
        OS.TXNSetData(this.txnObject, 1970567284, cArray, cArray.length * 2, n, n2);
        if (n3 != 0) {
            OS.TXNSetTXNObjectControls(this.txnObject, false, 1, nArray, new int[]{1});
        }
        if (OS.TXNDataSize(this.txnObject) / 2 == 0) {
            this.setFontStyle(this.font);
        }
    }

    void setZOrder() {
        if (this.frameHandle != 0) {
            int n = this.scrolledHandle != 0 ? this.scrolledHandle : this.handle;
            OS.HIViewAddSubview(this.frameHandle, n);
            HILayoutInfo hILayoutInfo = new HILayoutInfo();
            hILayoutInfo.version = 0;
            OS.HIViewGetLayoutInfo(n, hILayoutInfo);
            HISideBinding hISideBinding = hILayoutInfo.binding.top;
            hISideBinding.toView = 0;
            hISideBinding.kind = 1;
            hISideBinding.offset = 0.0f;
            hISideBinding = hILayoutInfo.binding.left;
            hISideBinding.toView = 0;
            hISideBinding.kind = 1;
            hISideBinding.offset = 0.0f;
            hISideBinding = hILayoutInfo.binding.bottom;
            hISideBinding.toView = 0;
            hISideBinding.kind = (short)2;
            hISideBinding.offset = 0.0f;
            hISideBinding = hILayoutInfo.binding.right;
            hISideBinding.toView = 0;
            hISideBinding.kind = (short)2;
            hISideBinding.offset = 0.0f;
            CGRect cGRect = new CGRect();
            cGRect.height = 100.0f;
            cGRect.width = 100.0f;
            OS.HIViewSetFrame(this.frameHandle, cGRect);
            Rect rect = this.inset();
            cGRect.x += (float)rect.left;
            cGRect.y += (float)rect.top;
            cGRect.width -= (float)(rect.left + rect.right);
            cGRect.height -= (float)(rect.top + rect.bottom);
            OS.HIViewSetFrame(n, cGRect);
            OS.HIViewSetLayoutInfo(n, hILayoutInfo);
        }
        super.setZOrder();
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        this.textLimit = n;
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int[] nArray = new int[1];
        OS.CreateEvent(0, 1935897196, 10, 0.0, 0, nArray);
        if (nArray[0] != 0) {
            int n2 = this.getLineHeight();
            CGPoint cGPoint = new CGPoint();
            cGPoint.y = n2 * Math.min(this.getLineCount(), n);
            OS.SetEventParameter(nArray[0], 1869768558, 1751740532, 8, cGPoint);
            OS.SendEventToEventTarget(nArray[0], OS.GetControlEventTarget(this.handle));
            OS.ReleaseEvent(nArray[0]);
        }
    }

    public void showSelection() {
        this.checkWidget();
        if (this.txnObject == 0) {
            this.setSelection(this.getSelection());
        } else {
            OS.TXNShowSelection(this.txnObject, false);
        }
    }

    int topHandle() {
        if (this.frameHandle != 0) {
            return this.frameHandle;
        }
        return super.topHandle();
    }

    int traversalCode(int n, int n2) {
        int n3 = super.traversalCode(n, n2);
        if ((this.style & 8) != 0) {
            return n3;
        }
        if ((this.style & 2) != 0) {
            n3 &= 0xFFFFFFFB;
            if (n == 48 && n2 != 0) {
                boolean bl;
                int[] nArray = new int[1];
                OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, nArray);
                boolean bl2 = bl = (nArray[0] & 0x200) == 0;
                if (bl && (nArray[0] & 0x1000) == 0) {
                    n3 &= 0xFFFFFFE7;
                }
            }
        }
        return n3;
    }

    String verifyText(String string, int n, int n2, Event event) {
        Event event2 = new Event();
        event2.text = string;
        event2.start = n;
        event2.end = n2;
        if (event != null) {
            event2.character = event.character;
            event2.keyCode = event.keyCode;
            event2.stateMask = event.stateMask;
        }
        this.sendEvent(25, event2);
        if (!event2.doit || this.isDisposed()) {
            return null;
        }
        return event2.text;
    }
}

