/*
 *  Copyright (C) 2006-2010  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.gui;

import java.util.Vector;
import org.dbgl.model.conf.Settings;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;


public abstract class Wizard extends Dialog {

	protected int stepNr;
	protected Vector<Control> steps;
	protected Composite wizardPanel;
	protected StackLayout wizardLayout;
	protected Button back, next, finish, cancel;
    protected Shell shell;
    protected Settings settings;
    
    
	public Wizard(Shell arg0, int arg1) {
		super(arg0, arg1);
		settings = Settings.getInstance();
		stepNr = 0;
		steps = new Vector<Control>();
	}

    protected void createContents(final String title, final String dialog) {
        shell = new Shell(getParent(), SWT.TITLE | SWT.CLOSE | SWT.BORDER | SWT.RESIZE | SWT.APPLICATION_MODAL);
        shell.setText(title);
        shell.setLayout(new GridLayout(4, false));
        shell.addControlListener(new SizeControlAdapter(shell, dialog));

        SelectionAdapter closeAdapter = new SelectionAdapter() { public void widgetSelected(final SelectionEvent event) { shell.close(); }};
        
		wizardPanel = new Composite(shell, SWT.NONE);
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.horizontalSpan = 4;
		wizardPanel.setLayoutData(gd);

		wizardLayout = new StackLayout();
		wizardPanel.setLayout(wizardLayout);

		back = new Button(shell, SWT.PUSH);
		back.setText(settings.msg("button.back"));
		final GridData gridData = new GridData();
        gridData.horizontalAlignment = SWT.FILL;
        gridData.widthHint = 80;
        back.setLayoutData(gridData);
		back.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent event) {
				previousStep();
			}
		});
		
		next = new Button(shell, SWT.PUSH);
		next.setText(settings.msg("button.next"));
		next.setLayoutData(gridData);
		next.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(final SelectionEvent event) {
				nextStep();
			}
		});
		
		final GridData gridData2 = new GridData();
		gridData2.horizontalAlignment = SWT.FILL;
		gridData2.widthHint = 80;
		gridData2.horizontalIndent = 10;
		finish = new Button(shell, SWT.PUSH);
		finish.setText(settings.msg("button.finish"));
		finish.setLayoutData(gridData2);
		finish.addSelectionListener(closeAdapter);
		finish.setEnabled(false);
		
		cancel = new Button(shell, SWT.PUSH);
		cancel.setText(settings.msg("button.cancel"));
		cancel.setLayoutData(new GridData());
		cancel.addSelectionListener(closeAdapter);
		
		fillPages();
        showCurrentStep();
        shell.setDefaultButton(next);
    }
    
    protected abstract void fillPages();

    protected int stepSize(boolean up) {
		return 1;
	}
    
    protected boolean isValid() {
    	return true;
    }
    
    protected void nextStep() {
		if (isValid()) {
			stepNr += stepSize(true);
			showCurrentStep();
		}
	}

    protected void previousStep() {
		stepNr -= stepSize(false);
		showCurrentStep();
	}

    protected void showCurrentStep() {
		wizardLayout.topControl = steps.get(stepNr);
		wizardPanel.layout();
		back.setEnabled(stepNr > 0);
		next.setEnabled(stepNr < steps.size() - 1);
	}

	public void addStep(Control c) {
		c.setParent(wizardPanel);
		steps.addElement(c);
	}
}
