/*
 *  Copyright (C) 2006-2010  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dbgl.swtdesigner.SWTImageManager;
import org.dbgl.util.MobyGamesUtils;
import org.eclipse.swt.graphics.ImageData;


public class MobyProfile implements Comparable<MobyProfile> {

    private String title;
	private String platform;
	private String year;
	private String url;
	private String developerName;
    private String publisherName;
    private String genre;
    private String notes;
    private int rank;
    private String coreGameCoverUrl;
    private MobyImageInformation[] mobygamesImages;
    
	
    public MobyProfile() { 
    }

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	public String getPlatform() {
		return platform;
	}

	public void setPlatform(String platform) {
		this.platform = platform;
	}

	public String getYear() {
		return year;
	}

	public void setYear(String year) {
		this.year = year;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getScreenshotsUrl() {
		return url + "/screenshots";
	}
	
	public String getCoverArtUrl() {
		return url + "/cover-art";
	}
	
	public MobyImageInformation[] getImageDescriptions(int coverArtMax, int screenshotsMax) throws IOException {
		List<MobyImageInformation> result = new ArrayList<MobyImageInformation>();
		if (coverArtMax > 0) {
			result.addAll(MobyGamesUtils.getEntryCoverArtInformation(this, coverArtMax));
		}
		if (screenshotsMax > 0) {
			result.addAll(MobyGamesUtils.getEntryScreenshotInformation(this, screenshotsMax));
		}
		mobygamesImages = result.toArray(new MobyImageInformation[0]);
		return mobygamesImages;
	}
	
	public String getCoreGameCoverUrl() {
		return coreGameCoverUrl;
	}

	public void setCoreGameCoverUrl(String coreGameCoverUrl) {
		this.coreGameCoverUrl = coreGameCoverUrl;
	}

	public ImageData getMobygamesImage(int i) throws IOException {
		mobygamesImages[i].data = SWTImageManager.getImageData(mobygamesImages[i].url);
		return mobygamesImages[i].data;
	}

	public String getDeveloperName() {
		return developerName;
	}

	public void setDeveloperName(String developerName) {
		this.developerName = developerName;
	}

	public String getPublisherName() {
		return publisherName;
	}

	public void setPublisherName(String publisherName) {
		this.publisherName = publisherName;
	}

	public String getGenre() {
		return genre;
	}

	public void setGenre(String genre) {
		this.genre = genre;
	}
	
	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	public int getRank() {
		return rank;
	}

	public void setRank(int rank) {
		this.rank = rank;
	}

	public int compareTo(MobyProfile otherProfile) {
		if (otherProfile.platform.equalsIgnoreCase(platform)) {
			return title.compareToIgnoreCase(otherProfile.title);
		}
		return platform.compareToIgnoreCase(otherProfile.platform);
	}
}
