/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTButton;
import org.eclipse.swt.internal.cocoa.SWTButtonCell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    String text;
    Image image;
    boolean grayed;
    static final int EXTRA_HEIGHT = 2;
    static final int EXTRA_WIDTH = 6;
    static final int IMAGE_GAP = 2;

    public Button(Composite composite, int n) {
        super(composite, Button.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    NSSize cellSize(int n, int n2) {
        NSSize nSSize = super.cellSize(n, n2);
        if (this.image != null && (this.style & 0x30) != 0) {
            NSSize nSSize2 = this.image.handle.size();
            nSSize.width += nSSize2.width + 2.0f;
            nSSize.height = Math.max(nSSize.height, nSSize2.height);
        }
        return nSSize;
    }

    static int checkStyle(int n) {
        if (((n = Button.checkBits(n, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(n, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((n & 0x30) != 0) {
            return Button.checkBits(n, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((n & 4) != 0) {
            return Button.checkBits(n |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return n;
    }

    void click() {
        this.sendSelectionEvent(13);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n3 = n != -1 ? n : 14;
            int n4 = n2 != -1 ? n2 : 14;
            return new Point(n3, n4);
        }
        NSSize nSSize = ((NSButton)this.view).cell().cellSize();
        int n5 = (int)Math.ceil(nSSize.width);
        int n6 = (int)Math.ceil(nSSize.height);
        if (n != -1) {
            n5 = n;
        }
        if (n2 != -1) {
            n6 = n2;
        }
        if ((this.style & 0xA) != 0 && (this.style & 0x800000) == 0) {
            if (this.display.smallFonts) {
                n6 += 2;
            }
            n5 += 6;
        }
        return new Point(n5, n6);
    }

    NSAttributedString createString() {
        NSAttributedString nSAttributedString = this.createString(this.text, null, this.foreground, this.style, false, true, true);
        nSAttributedString.autorelease();
        return nSAttributedString;
    }

    void createHandle() {
        if ((this.style & 8) == 0) {
            this.state |= 0x800;
        }
        NSButton nSButton = (NSButton)new SWTButton().alloc();
        nSButton.init();
        NSButtonCell nSButtonCell = (NSButtonCell)new SWTButtonCell().alloc().init();
        nSButton.setCell(nSButtonCell);
        nSButtonCell.release();
        int n = 0;
        if ((this.style & 8) != 0) {
            boolean bl;
            boolean bl2 = bl = (this.style & 0x800000) != 0;
            if (!bl) {
                NSView nSView = nSButton.superview();
                while (nSView != null) {
                    if (nSView.isKindOfClass(OS.class_NSTableView)) {
                        bl = true;
                        break;
                    }
                    nSView = nSView.superview();
                }
            }
            if (bl) {
                nSButton.setBezelStyle(6);
            } else {
                nSButton.setBezelStyle(1);
            }
        } else if ((this.style & 0x20) != 0) {
            n = 3;
        } else if ((this.style & 0x10) != 0) {
            n = 4;
        } else if ((this.style & 2) != 0) {
            n = 1;
            if ((this.style & 0x800000) != 0) {
                nSButton.setBezelStyle(6);
            } else {
                nSButton.setBezelStyle(1);
            }
        } else if ((this.style & 4) != 0) {
            nSButton.setBezelStyle(6);
        }
        nSButton.setButtonType(n);
        nSButton.setTitle(NSString.string());
        nSButton.setImagePosition(2);
        nSButton.setTarget(nSButton);
        nSButton.setAction(OS.sel_sendSelection);
        this.view = nSButton;
        this._setAlignment(this.style);
    }

    void createWidget() {
        this.text = "";
        super.createWidget();
    }

    NSFont defaultNSFont() {
        return this.display.buttonFont;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(((NSControl)this.view).cell());
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        boolean bl2;
        blArray[0] = bl2 = super.dragDetect(n, n2, bl, blArray);
        return bl2;
    }

    boolean drawsBackground() {
        return this.background != null || this.backgroundImage != null;
    }

    void drawImageWithFrameInView(int n, int n2, int n3, NSRect nSRect, int n4) {
        if (this.display.smallFonts && (this.style & 0xA) != 0 && (this.style & 0x800000) == 0) {
            nSRect.y += 1.0f;
            nSRect.height += 2.0f;
        }
        this.callSuper(n, n2, n3, nSRect, n4);
    }

    void drawInteriorWithFrame_inView(int n, int n2, NSRect nSRect, int n3) {
        if ((this.style & 0x30) != 0 && this.backgroundImage != null) {
            this.fillBackground(new NSView(n3), NSGraphicsContext.currentContext(), nSRect, -1);
        }
        super.drawInteriorWithFrame_inView(n, n2, nSRect, n3);
        if (this.image != null && (this.style & 0x30) != 0) {
            NSSize nSSize = this.image.handle.size();
            NSCell nSCell = new NSCell(n);
            float f = 0.0f;
            float f2 = (nSSize.height - nSRect.height) / 2.0f;
            NSRect nSRect2 = nSCell.imageRectForBounds(nSRect);
            NSSize nSSize2 = ((NSButton)this.view).attributedTitle().size();
            switch (this.style & 0x1024000) {
                case 16384: {
                    f = nSRect2.x + nSRect2.width + 2.0f;
                    break;
                }
                case 0x1000000: {
                    f = nSRect.x + nSRect2.x + nSRect2.width + (nSRect.width - nSSize2.width) / 2.0f - nSSize.width - 2.0f;
                    break;
                }
                case 131072: {
                    f = nSRect.x + nSRect.width - nSSize2.width - nSSize.width - 2.0f;
                }
            }
            NSRect nSRect3 = new NSRect();
            nSRect3.x = f;
            nSRect3.y = f2;
            nSRect3.width = nSSize.width;
            nSRect3.height = nSSize.height;
            NSGraphicsContext.static_saveGraphicsState();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.scaleXBy(1.0f, -1.0f);
            nSAffineTransform.translateXBy(0.0f, -nSSize.height);
            nSAffineTransform.concat();
            this.image.handle.drawInRect(nSRect3, new NSRect(), 2, 1.0f);
            NSGraphicsContext.static_restoreGraphicsState();
        }
    }

    void drawWidget(int n, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if ((this.style & 4) != 0) {
            NSRect nSRect2 = this.view.frame();
            int n2 = Math.min((int)nSRect2.height, (int)nSRect2.width) / 2;
            nSGraphicsContext.saveGraphicsState();
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = -n2 / 2;
            nSPoint.y = -n2 / 2;
            NSPoint nSPoint2 = new NSPoint();
            nSPoint2.x = n2 / 2;
            nSPoint2.y = nSPoint.y;
            NSPoint nSPoint3 = new NSPoint();
            nSPoint3.y = n2 / 2;
            NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
            nSBezierPath.moveToPoint(nSPoint);
            nSBezierPath.lineToPoint(nSPoint2);
            nSBezierPath.lineToPoint(nSPoint3);
            nSBezierPath.closePath();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            if ((this.style & 0x4000) != 0) {
                nSAffineTransform.rotateByDegrees(90.0f);
            } else if ((this.style & 0x80) != 0) {
                nSAffineTransform.rotateByDegrees(180.0f);
            } else if ((this.style & 0x20000) != 0) {
                nSAffineTransform.rotateByDegrees(-90.0f);
            }
            nSBezierPath.transformUsingAffineTransform(nSAffineTransform);
            nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(nSRect2.width / 2.0f, nSRect2.height / 2.0f);
            nSBezierPath.transformUsingAffineTransform(nSAffineTransform);
            NSColor nSColor = this.isEnabled() ? NSColor.blackColor() : NSColor.disabledControlTextColor();
            nSColor.set();
            nSBezierPath.fill();
            nSGraphicsContext.restoreGraphicsState();
        }
        super.drawWidget(n, nSGraphicsContext, nSRect);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        if ((this.style & 0x20) != 0 && this.grayed) {
            return ((NSButton)this.view).state() == -1;
        }
        return ((NSButton)this.view).state() == 1;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    boolean isDescribedByLabel() {
        return false;
    }

    int nextState(int n, int n2) {
        if ((this.style & 0x20) != 0 && this.grayed) {
            return ((NSButton)this.view).state() == -1 ? 0 : -1;
        }
        return super.nextState(n, n2);
    }

    void register() {
        super.register();
        this.display.addWidget(((NSControl)this.view).cell(), this);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectRadio() {
        Control[] controlArray = this.parent._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (this != control) {
                control.setRadioSelection(false);
            }
            ++n;
        }
        this.setSelection(true);
    }

    void sendSelection() {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        if ((this.style & 0x20) != 0) {
            if (this.grayed && ((NSButton)this.view).state() == 1) {
                ((NSButton)this.view).setState(0);
            }
            if (!this.grayed && ((NSButton)this.view).state() == -1) {
                ((NSButton)this.view).setState(1);
            }
        }
        this.sendSelectionEvent(13);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        this._setAlignment(n);
        this.redraw();
    }

    void _setAlignment(int n) {
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= n & 0x24480;
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        if (this.text != null) {
            ((NSButton)this.view).setAttributedTitle(this.createString());
        }
    }

    void setBackgroundColor(NSColor nSColor) {
        Control control = this.findBackgroundControl();
        if (control == null || control.backgroundImage == null) {
            NSButtonCell nSButtonCell = new NSButtonCell(((NSButton)this.view).cell());
            nSButtonCell.setBackgroundColor(nSColor);
        }
    }

    void setBackgroundImage(NSImage nSImage) {
        if (nSImage != null) {
            NSButtonCell nSButtonCell = new NSButtonCell(((NSButton)this.view).cell());
            nSButtonCell.setBackgroundColor(null);
        }
    }

    void setFont(NSFont nSFont) {
        if (this.text != null) {
            ((NSButton)this.view).setAttributedTitle(this.createString());
        }
    }

    void setForeground(float[] fArray) {
        ((NSButton)this.view).setAttributedTitle(this.createString());
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        boolean bl2 = this.getSelection();
        this.grayed = bl;
        ((NSButton)this.view).setAllowsMixedState(bl);
        if (bl2) {
            if (bl) {
                ((NSButton)this.view).setState(-1);
            } else {
                ((NSButton)this.view).setState(1);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.image = image;
        if ((this.style & 0x30) == 0) {
            ((NSButton)this.view).setImage(image != null ? image.handle : null);
            this.view.setNeedsDisplay(true);
        } else {
            ((NSButton)this.view).setAttributedTitle(this.createString());
        }
        this.updateAlignment();
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        if (this.grayed) {
            ((NSButton)this.view).setState(bl ? -1 : 0);
        } else {
            ((NSButton)this.view).setState(bl ? 1 : 0);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        ((NSButton)this.view).setAttributedTitle(this.createString());
        this.updateAlignment();
    }

    NSRect titleRectForBounds(int n, int n2, NSRect nSRect) {
        NSRect nSRect2 = super.titleRectForBounds(n, n2, nSRect);
        if (this.image != null && (this.style & 0x30) != 0) {
            NSSize nSSize = this.image.handle.size();
            nSRect2.x += nSSize.width + 2.0f;
            nSRect2.width -= nSSize.width + 2.0f;
            nSRect2.width = Math.max(0.0f, nSRect2.width);
        }
        return nSRect2;
    }

    int traversalCode(int n, NSEvent nSEvent) {
        int n2 = super.traversalCode(n, nSEvent);
        if ((this.style & 4) != 0) {
            n2 &= 0xFFFFFFE7;
        }
        if ((this.style & 0x10) != 0) {
            n2 |= 0x60;
        }
        return n2;
    }

    void updateAlignment() {
        NSButton nSButton = (NSButton)this.view;
        if ((this.style & 0xA) != 0) {
            if (this.text.length() != 0 && this.image != null) {
                nSButton.setImagePosition(2);
            } else {
                nSButton.setImagePosition(this.text.length() != 0 ? 0 : 1);
            }
        }
    }
}

