/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSInputManager;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTrackingArea;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    public NSView view;
    Composite parent;
    String toolTipText;
    Object layoutData;
    int drawCount;
    Menu menu;
    float[] foreground;
    float[] background;
    Image backgroundImage;
    Font font;
    Cursor cursor;
    Region region;
    NSBezierPath regionPath;
    int visibleRgn;
    Accessible accessible;
    static final int CLIPPING = 1024;
    static final int VISIBLE_REGION = 4096;
    static final int DEFAULT_DRAG_HYSTERESIS = 5;
    static final double SYNTHETIC_BOLD = -2.5;
    static final double SYNTHETIC_ITALIC = 0.2;

    Control() {
    }

    public Control(Composite composite, int n) {
        super(composite, n);
        this.parent = composite;
        this.createWidget();
    }

    boolean acceptsFirstMouse(int n, int n2, int n3) {
        Shell shell = this.getShell();
        if ((shell.style & 0x4000) != 0) {
            return true;
        }
        return super.acceptsFirstMouse(n, n2, n3);
    }

    int accessibleHandle() {
        int n = this.view.id;
        if (this.view instanceof NSControl && ((NSControl)this.view).cell() != null) {
            n = ((NSControl)this.view).cell().id;
        }
        return n;
    }

    int accessibilityActionDescription(int n, int n2, int n3) {
        NSString nSString;
        id id2;
        if (this.handleIsAccessible(n) && this.accessible != null && (id2 = this.accessible.internal_accessibilityActionDescription(nSString = new NSString(n3), -1)) != null) {
            return id2.id;
        }
        return super.accessibilityActionDescription(n, n2, n3);
    }

    int accessibilityActionNames(int n, int n2) {
        NSArray nSArray;
        if (this.handleIsAccessible(n) && this.accessible != null && (nSArray = this.accessible.internal_accessibilityActionNames(-1)) != null) {
            return nSArray.id;
        }
        return super.accessibilityActionNames(n, n2);
    }

    int accessibilityAttributeNames(int n, int n2) {
        int n3 = 0;
        if (this.handleIsAccessible(n) && this.accessible != null) {
            NSArray nSArray = this.accessible.internal_accessibilityAttributeNames(-1);
            int n4 = n3 = nSArray != null ? nSArray.id : 0;
            if (n3 == 0) {
                n3 = super.accessibilityAttributeNames(n, n2);
            }
            n3 = this.accessible.internal_addRelationAttributes(n3);
        }
        if (n3 == 0) {
            n3 = super.accessibilityAttributeNames(n, n2);
        }
        return n3;
    }

    boolean handleIsAccessible(int n) {
        return n == this.accessibleHandle();
    }

    int accessibilityParameterizedAttributeNames(int n, int n2) {
        NSArray nSArray;
        if (this.handleIsAccessible(n) && this.accessible != null && (nSArray = this.accessible.internal_accessibilityParameterizedAttributeNames(-1)) != null) {
            return nSArray.id;
        }
        return super.accessibilityParameterizedAttributeNames(n, n2);
    }

    void accessibilityPerformAction(int n, int n2, int n3) {
        NSString nSString;
        if (this.handleIsAccessible(n) && this.accessible != null && this.accessible.internal_accessibilityPerformAction(nSString = new NSString(n3), -1)) {
            return;
        }
        super.accessibilityPerformAction(n, n2, n3);
    }

    int accessibilityFocusedUIElement(int n, int n2) {
        id id2 = null;
        if (this.handleIsAccessible(n) && this.accessible != null) {
            id2 = this.accessible.internal_accessibilityFocusedUIElement(-1);
        }
        if (id2 == null) {
            return super.accessibilityFocusedUIElement(n, n2);
        }
        return id2.id;
    }

    int accessibilityHitTest(int n, int n2, NSPoint nSPoint) {
        id id2 = null;
        if (this.handleIsAccessible(n) && this.accessible != null) {
            id2 = this.accessible.internal_accessibilityHitTest(nSPoint, -1);
        }
        if (id2 == null) {
            return super.accessibilityHitTest(n, n2, nSPoint);
        }
        return id2.id;
    }

    int accessibilityAttributeValue(int n, int n2, int n3) {
        NSString nSString = new NSString(n3);
        int n4 = 0;
        id id2 = null;
        if (this.handleIsAccessible(n) && this.accessible != null) {
            id2 = this.accessible.internal_accessibilityAttributeValue(nSString, -1);
        }
        if (id2 == null) {
            n4 = super.accessibilityAttributeValue(n, n2, n3);
            if (nSString.isEqualToString(OS.NSAccessibilityHelpAttribute) && this.toolTipText != null) {
                n4 = NSString.stringWith((String)this.toolTipText).id;
            }
        } else {
            n4 = id2.id;
        }
        return n4;
    }

    int accessibilityAttributeValue_forParameter(int n, int n2, int n3, int n4) {
        NSString nSString = new NSString(n3);
        id id2 = null;
        if (this.handleIsAccessible(n) && this.accessible != null) {
            id id3 = new id(n4);
            id2 = this.accessible.internal_accessibilityAttributeValue_forParameter(nSString, id3, -1);
        }
        if (id2 == null) {
            return super.accessibilityAttributeValue_forParameter(n, n2, n3, n4);
        }
        return id2.id;
    }

    boolean accessibilityIsAttributeSettable(int n, int n2, int n3) {
        boolean bl = false;
        if (this.handleIsAccessible(n) && this.accessible != null) {
            NSString nSString = new NSString(n3);
            bl = this.accessible.internal_accessibilityIsAttributeSettable(nSString, -1);
        }
        if (!bl) {
            bl = super.accessibilityIsAttributeSettable(n, n2, n3);
        }
        return bl;
    }

    void accessibilitySetValue_forAttribute(int n, int n2, int n3, int n4) {
        if (this.handleIsAccessible(n) && this.accessible != null) {
            id id2 = new id(n3);
            NSString nSString = new NSString(n4);
            this.accessible.internal_accessibilitySetValue_forAttribute(id2, nSString, -1);
        } else {
            super.accessibilitySetValue_forAttribute(n, n2, n3, n4);
        }
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(dragDetectListener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(focusListener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuDetectListener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseListener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseTrackListener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseMoveListener);
        this.addListener(5, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseWheelListener);
        this.addListener(37, typedListener);
    }

    void addRelation(Control control) {
    }

    public void addPaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(paintListener);
        this.addListener(9, typedListener);
    }

    void addTraits(NSMutableDictionary nSMutableDictionary, Font font) {
        if ((font.extraTraits & 2) != 0) {
            nSMutableDictionary.setObject(NSNumber.numberWithDouble(-2.5), OS.NSStrokeWidthAttributeName);
        }
        if ((font.extraTraits & 1) != 0) {
            nSMutableDictionary.setObject(NSNumber.numberWithDouble(0.2), OS.NSObliquenessAttributeName);
        }
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(traverseListener);
        this.addListener(31, typedListener);
    }

    boolean becomeFirstResponder(int n, int n2) {
        if ((this.state & 8) != 0) {
            return false;
        }
        return super.becomeFirstResponder(n, n2);
    }

    void calculateVisibleRegion(NSView nSView, int n, boolean bl) {
        int n2 = OS.NewRgn();
        if (!nSView.isHiddenOrHasHiddenAncestor() && this.isDrawing()) {
            int n3 = OS.NewRgn();
            NSWindow nSWindow = nSView.window();
            NSView nSView2 = nSWindow.contentView();
            NSView nSView3 = nSView2.superview();
            NSRect nSRect = nSView2.visibleRect();
            nSRect = nSView2.convertRect_toView_(nSRect, nSView);
            short[] sArray = new short[4];
            OS.SetRect(sArray, (short)nSRect.x, (short)nSRect.y, (short)(nSRect.x + nSRect.width), (short)(nSRect.y + nSRect.height));
            OS.RectRgn(n, sArray);
            NSView nSView4 = nSView;
            NSView nSView5 = null;
            while (nSView4.id != nSView3.id) {
                nSRect = nSView4.visibleRect();
                nSRect = nSView4.convertRect_toView_(nSRect, nSView);
                OS.SetRect(sArray, (short)nSRect.x, (short)nSRect.y, (short)(nSRect.x + nSRect.width), (short)(nSRect.y + nSRect.height));
                OS.RectRgn(n2, sArray);
                OS.SectRgn(n2, n, n);
                if (OS.EmptyRgn(n)) break;
                if (bl || nSView4.id != nSView.id) {
                    NSArray nSArray = nSView4.subviews();
                    int n4 = nSArray.count();
                    int n5 = 0;
                    while (n5 < n4) {
                        NSView nSView6 = new NSView(nSArray.objectAtIndex(n4 - n5 - 1));
                        if (nSView5 != null && nSView6.id == nSView5.id) break;
                        if (!nSView6.isHidden()) {
                            nSRect = nSView6.visibleRect();
                            nSRect = nSView6.convertRect_toView_(nSRect, nSView);
                            OS.SetRect(sArray, (short)nSRect.x, (short)nSRect.y, (short)(nSRect.x + nSRect.width), (short)(nSRect.y + nSRect.height));
                            OS.RectRgn(n2, sArray);
                            OS.UnionRgn(n2, n3, n3);
                        }
                        ++n5;
                    }
                }
                nSView5 = nSView4;
                nSView4 = nSView4.superview();
            }
            OS.DiffRgn(n, n3, n);
            OS.DisposeRgn(n3);
        } else {
            OS.CopyRgn(n2, n);
        }
        OS.DisposeRgn(n2);
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFFFBFF;
        Composite composite = this.parent;
        while (true) {
            int n;
            if ((n = composite.backgroundMode) != 0) {
                if (n == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x800) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x400;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBuffered() {
        this.style |= 0x20000000;
    }

    void checkToolTip(Widget widget) {
        if (this.isVisible() && this.display.tooltipControl == this && (widget == null || this.display.tooltipTarget == widget)) {
            Shell shell = this.getShell();
            shell.sendToolTipEvent(false);
            shell.sendToolTipEvent(true);
        }
    }

    public Point computeSize(int n, int n2) {
        return this.computeSize(n, n2, true);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 64;
        int n4 = 64;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidth();
        return new Point(n3 += n5 * 2, n4 += n5 * 2);
    }

    Widget computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Widget[]{this};
        }
        return new Widget[0];
    }

    Control computeTabRoot() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) break;
                ++n;
            }
            if (n == controlArray.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    NSView contentView() {
        return this.view;
    }

    NSAttributedString createString(String string, Font font, float[] fArray, int n, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        NSObject nSObject;
        NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5);
        if (font == null) {
            font = this.font != null ? this.font : this.defaultFont();
        }
        nSMutableDictionary.setObject(font.handle, OS.NSFontAttributeName);
        this.addTraits(nSMutableDictionary, font);
        if (bl2) {
            if (fArray != null) {
                nSObject = NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], fArray[3]);
                nSMutableDictionary.setObject(nSObject, OS.NSForegroundColorAttributeName);
            }
        } else {
            nSMutableDictionary.setObject(NSColor.disabledControlTextColor(), OS.NSForegroundColorAttributeName);
        }
        nSObject = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
        ((NSMutableParagraphStyle)nSObject).setLineBreakMode(bl ? 0 : 2);
        if (n != 0) {
            n2 = 16384;
            if ((n & 0x1000000) != 0) {
                n2 = 2;
            } else if ((n & 0x20000) != 0) {
                n2 = 1;
            }
            ((NSMutableParagraphStyle)nSObject).setAlignment(n2);
        }
        if ((this.style & 0x4000000) != 0) {
            ((NSMutableParagraphStyle)nSObject).setBaseWritingDirection(1);
        } else {
            ((NSMutableParagraphStyle)nSObject).setBaseWritingDirection(0);
        }
        nSMutableDictionary.setObject(nSObject, OS.NSParagraphStyleAttributeName);
        nSObject.release();
        n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, cArray.length, cArray, 0);
        if (bl3) {
            n2 = this.fixMnemonic(cArray);
        }
        NSString nSString = ((NSString)new NSString().alloc()).initWithCharacters(cArray, n2);
        NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSString, nSMutableDictionary);
        nSString.release();
        nSMutableDictionary.release();
        return nSAttributedString;
    }

    void createWidget() {
        this.state |= 0x40000;
        this.checkOrientation(this.parent);
        super.createWidget();
        this.checkBackground();
        this.checkBuffered();
        this.setDefaultFont();
        this.setZOrder();
        this.setRelations();
        if ((this.state & 0x400) != 0) {
            this.setBackground();
        }
        this.display.clearPool();
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(22);
    }

    Font defaultFont() {
        if (this.display.smallFonts) {
            return this.display.getSystemFont();
        }
        return Font.cocoa_new(this.display, this.defaultNSFont());
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(21);
    }

    NSFont defaultNSFont() {
        return this.display.getSystemFont().handle;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
    }

    void destroyWidget() {
        NSView nSView = this.topView();
        nSView.removeFromSuperview();
        this.releaseHandle();
    }

    void doCommandBySelector(int n, int n2, int n3) {
        if (this.hasKeyboardFocus(n)) {
            if (this.imeInComposition()) {
                return;
            }
            Shell shell = this.getShell();
            NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
            if (nSEvent != null && nSEvent.type() == 10) {
                int n4 = nSEvent.modifierFlags();
                if (!shell.keyInputHappened || (n4 & 0x100000) != 0) {
                    shell.keyInputHappened = true;
                    boolean[] blArray = new boolean[1];
                    if (this.translateTraversal(nSEvent.keyCode(), nSEvent, blArray)) {
                        return;
                    }
                    if (this.isDisposed()) {
                        return;
                    }
                    if (!this.sendKeyEvent(nSEvent, 1)) {
                        return;
                    }
                    if (blArray[0]) {
                        return;
                    }
                }
            }
            if ((this.state & 2) != 0) {
                return;
            }
        }
        super.doCommandBySelector(n, n2, n3);
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent mouseEvent) {
        this.checkWidget();
        if (mouseEvent == null) {
            this.error(4);
        }
        return this.dragDetect(mouseEvent.button, mouseEvent.count, mouseEvent.stateMask, mouseEvent.x, mouseEvent.y);
    }

    boolean dragDetect(int n, int n2, int n3, int n4, int n5) {
        if (n != 1 || n2 != 1) {
            return false;
        }
        if (!this.dragDetect(n4, n5, false, null)) {
            return false;
        }
        return this.sendDragEvent(n, n3, n4, n5);
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        NSEvent nSEvent;
        NSApplication nSApplication = NSApplication.sharedApplication();
        boolean bl2 = false;
        int n3 = 1;
        float f = n;
        float f2 = n2;
        NSEvent nSEvent2 = null;
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(10);
        while (n3 != 2) {
            nSEvent = nSApplication.nextEventMatchingMask(68, NSDate.distantFuture(), OS.NSEventTrackingRunLoopMode, true);
            n3 = nSEvent.type();
            if (n3 == 6) {
                nSMutableArray.addObject(nSEvent);
                NSPoint nSPoint = nSEvent.locationInWindow();
                NSPoint nSPoint2 = this.view.convertPoint_fromView_(nSPoint, null);
                if (!this.view.isFlipped()) {
                    nSPoint2.y = this.view.bounds().height - nSPoint2.y;
                }
                if (!(Math.abs(nSPoint2.x - f) > 5.0f) && !(Math.abs(nSPoint2.y - f2) > 5.0f)) continue;
                bl2 = true;
                break;
            }
            if (n3 != 2) continue;
            nSEvent2 = nSEvent;
        }
        if (nSEvent2 != null) {
            nSApplication.postEvent(nSEvent2, true);
        }
        if (nSMutableArray.count() > 0) {
            while (nSMutableArray.count() > 0) {
                nSEvent = new NSEvent(nSMutableArray.objectAtIndex((int)(nSMutableArray.count() - 1)).id);
                nSMutableArray.removeLastObject();
                nSApplication.postEvent(nSEvent, true);
            }
        }
        return bl2;
    }

    boolean drawGripper(int n, int n2, int n3, int n4, boolean bl) {
        return false;
    }

    void drawWidget(int n, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (n != this.paintView().id) {
            return;
        }
        if (!this.hooks(9) && !this.filters(9)) {
            return;
        }
        GCData gCData = new GCData();
        gCData.paintRect = nSRect;
        GC gC = GC.cocoa_new(this, gCData);
        Event event = new Event();
        event.gc = gC;
        event.x = (int)nSRect.x;
        event.y = (int)nSRect.y;
        event.width = (int)nSRect.width;
        event.height = (int)nSRect.height;
        this.sendEvent(9, event);
        event.gc = null;
        gC.dispose();
    }

    void enableWidget(boolean bl) {
        if (this.view instanceof NSControl) {
            ((NSControl)this.view).setEnabled(bl);
        }
        this.updateCursorRects(this.isEnabled());
    }

    boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray == null) {
            return fArray2 == null;
        }
        if (fArray2 == null) {
            return fArray == null;
        }
        int n = 0;
        while (n < fArray.length) {
            if (fArray[n] != fArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    NSView eventView() {
        return this.view;
    }

    boolean drawsBackground() {
        return true;
    }

    void fillBackground(NSView nSView, NSGraphicsContext nSGraphicsContext, NSRect nSRect, int n) {
        this.fillBackground(nSView, nSGraphicsContext, nSRect, n, null, 0, 0);
    }

    void fillBackground(NSView nSView, NSGraphicsContext nSGraphicsContext, NSRect nSRect, int n, NSView nSView2, int n2, int n3) {
        float f;
        Image image;
        if (!this.drawsBackground()) {
            return;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if ((image = control.backgroundImage) != null && !image.isDisposed()) {
            Object object;
            nSGraphicsContext.saveGraphicsState();
            NSColor.colorWithPatternImage(image.handle).setFill();
            NSPoint nSPoint = new NSPoint();
            NSView nSView3 = control.view;
            if (!nSView3.isFlipped()) {
                nSPoint.y = nSView3.bounds().height;
            }
            if (n == -1) {
                object = nSView3.window().contentView();
                nSPoint = nSView3.convertPoint_toView_(nSPoint, (NSView)object);
                nSPoint.y = ((NSView)object).bounds().height - nSPoint.y;
            } else {
                nSPoint = nSView.convertPoint_toView_(nSPoint, nSView3);
                nSPoint.y += (float)(n - this.backgroundImage.getBounds().height);
            }
            if (nSView2 != null) {
                object = nSView2.convertPoint_toView_(new NSPoint(), nSView);
                nSPoint.x += ((NSPoint)object).x;
                nSPoint.y -= ((NSPoint)object).y;
            }
            nSPoint.x -= (float)n2;
            nSPoint.y += (float)n3;
            nSGraphicsContext.setPatternPhase(nSPoint);
            NSBezierPath.fillRect(nSRect);
            nSGraphicsContext.restoreGraphicsState();
            return;
        }
        float[] fArray = control.background;
        if (fArray == null) {
            if (this.isTransparent()) {
                return;
            }
            fArray = control.defaultBackground().handle;
            f = this.getThemeAlpha();
        } else {
            f = fArray[3];
        }
        nSGraphicsContext.saveGraphicsState();
        NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], f).setFill();
        NSBezierPath.fillRect(nSRect);
        nSGraphicsContext.restoreGraphicsState();
    }

    Cursor findCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent.findCursor();
    }

    Control findBackgroundControl() {
        if (this.backgroundImage != null || this.background != null) {
            return this;
        }
        return !this.isTransparent() && (this.state & 0x400) != 0 ? this.parent.findBackgroundControl() : null;
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    Widget findTooltip(NSPoint nSPoint) {
        return this;
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        shell2.fixShell(shell, this);
        decorations2.fixDecorations(decorations, this, menuArray);
    }

    void fixFocus(Control control) {
        Shell shell = this.getShell();
        Control control2 = this;
        while (control2 != shell && (control2 = control2.parent) != null) {
            if (!control2.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(control);
        NSWindow nSWindow = this.view.window();
        nSWindow.becomeKeyWindow();
    }

    void flagsChanged(int n, int n2, int n3) {
        if (this.hasKeyboardFocus(n) && (this.state & 0x80000) == 0) {
            Shell shell = this.getShell();
            shell.keyInputHappened = false;
            int n4 = 0;
            NSEvent nSEvent = new NSEvent(n3);
            int n5 = nSEvent.modifierFlags();
            int n6 = Display.translateKey(nSEvent.keyCode());
            switch (n6) {
                case 65536: {
                    n4 = 524288;
                    break;
                }
                case 262144: {
                    n4 = 262144;
                    break;
                }
                case 0x400000: {
                    n4 = 0x100000;
                    break;
                }
                case 131072: {
                    n4 = 131072;
                    break;
                }
                case 16777298: {
                    Event event = new Event();
                    event.keyCode = n6;
                    this.setInputState(event, nSEvent, 1);
                    this.sendKeyEvent(1, event);
                    this.setInputState(event, nSEvent, 2);
                    this.sendKeyEvent(2, event);
                }
            }
            if (n4 != 0) {
                shell.keyInputHappened = true;
                int n7 = (n4 & n5) != 0 ? 1 : 2;
                Event event = new Event();
                event.keyCode = n6;
                this.setLocationMask(event, nSEvent);
                this.setInputState(event, nSEvent, n7);
                if (!this.sendKeyEvent(n7, event)) {
                    return;
                }
            }
        }
        super.flagsChanged(n, n2, n3);
    }

    NSView focusView() {
        return this.view;
    }

    public boolean forceFocus() {
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations decorations = this.menuShell();
        decorations.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        decorations.setSavedFocus(null);
        NSView nSView = this.focusView();
        if (!nSView.canBecomeKeyView()) {
            return false;
        }
        boolean bl = this.forceFocus(nSView);
        if (this.isDisposed()) {
            return false;
        }
        decorations.bringToTop(false);
        if (this.isDisposed()) {
            return false;
        }
        decorations.setSavedFocus(this);
        return bl;
    }

    boolean forceFocus(NSView nSView) {
        return this.view.window().makeFirstResponder(nSView);
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.getBackgroundColor();
    }

    Color getBackgroundColor() {
        return this.background != null ? Color.cocoa_new(this.display, this.background) : this.defaultBackground();
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    public int getBorderWidth() {
        this.checkWidget();
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        NSRect nSRect = this.topView().frame();
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x40000) != 0;
    }

    boolean getDrawing() {
        return this.drawCount <= 0;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font != null ? this.font : this.defaultFont();
    }

    public Color getForeground() {
        this.checkWidget();
        return this.getForegroundColor();
    }

    Color getForegroundColor() {
        return this.foreground != null ? Color.cocoa_new(this.display, this.foreground) : this.defaultForeground();
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        NSRect nSRect = this.topView().frame();
        return new Point((int)nSRect.x, (int)nSRect.y);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    int getMininumHeight() {
        return 0;
    }

    public Monitor getMonitor() {
        int n;
        this.checkWidget();
        Monitor[] monitorArray = this.display.getMonitors();
        if (monitorArray.length == 1) {
            return monitorArray[0];
        }
        int n2 = -1;
        int n3 = -1;
        Rectangle rectangle = this.getBounds();
        if (this != this.getShell()) {
            rectangle = this.display.map((Control)this.parent, null, rectangle);
        }
        int n4 = 0;
        while (n4 < monitorArray.length) {
            Rectangle rectangle2 = rectangle.intersection(monitorArray[n4].getBounds());
            n = rectangle2.width * rectangle2.height;
            if (n > 0 && n > n3) {
                n2 = n4;
                n3 = n;
            }
            ++n4;
        }
        if (n2 >= 0) {
            return monitorArray[n2];
        }
        n4 = rectangle.x + rectangle.width / 2;
        int n5 = rectangle.y + rectangle.height / 2;
        n = 0;
        while (n < monitorArray.length) {
            int n6;
            Rectangle rectangle3 = monitorArray[n].getBounds();
            int n7 = n4 < rectangle3.x ? rectangle3.x - n4 : (n6 = n4 > rectangle3.x + rectangle3.width ? n4 - rectangle3.x - rectangle3.width : 0);
            int n8 = n5 < rectangle3.y ? rectangle3.y - n5 : (n5 > rectangle3.y + rectangle3.height ? n5 - rectangle3.y - rectangle3.height : 0);
            int n9 = n6 * n6 + n8 * n8;
            if (n2 == -1 || n9 < n3) {
                n2 = n;
                n3 = n9;
            }
            ++n;
        }
        return monitorArray[n2];
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int n = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++n;
            control = control.parent;
        }
        control = this;
        Control[] controlArray = new Control[n];
        while (control != shell) {
            controlArray[--n] = control;
            control = control.parent;
        }
        return controlArray;
    }

    NSBezierPath getPath(Region region) {
        if (region == null) {
            return null;
        }
        return this.getPath(region.handle);
    }

    NSBezierPath getPath(int n) {
        Callback callback = new Callback(this, "regionToRects", 4);
        if (callback.getAddress() == 0) {
            SWT.error(3);
        }
        NSBezierPath nSBezierPath = NSBezierPath.bezierPath();
        nSBezierPath.retain();
        OS.QDRegionToRects(n, 5, callback.getAddress(), nSBezierPath.id);
        callback.dispose();
        if (nSBezierPath.isEmpty()) {
            nSBezierPath.appendBezierPathWithRect(new NSRect());
        }
        return nSBezierPath;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        NSRect nSRect = this.topView().frame();
        return new Point((int)nSRect.width, (int)nSRect.height);
    }

    float getThemeAlpha() {
        return 1.0f * this.parent.getThemeAlpha();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    int getVisibleRegion() {
        if (this.visibleRgn == 0) {
            this.visibleRgn = OS.NewRgn();
            this.calculateVisibleRegion(this.view, this.visibleRgn, true);
        }
        int n = OS.NewRgn();
        OS.CopyRgn(this.visibleRgn, n);
        return n;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    boolean hasFocus() {
        return this.display.getFocusControl() == this;
    }

    boolean hasRegion() {
        return this.region != null || this.parent.hasRegion();
    }

    int hitTest(int n, int n2, NSPoint nSPoint) {
        if ((this.state & 8) != 0) {
            return 0;
        }
        if (!this.isActive()) {
            return 0;
        }
        if (this.regionPath != null) {
            NSPoint nSPoint2;
            NSView nSView = this.topView();
            if (!nSView.isFlipped()) {
                nSView = this.eventView();
            }
            if (!this.regionPath.containsPoint(nSPoint2 = nSView.convertPoint_fromView_(nSPoint, new NSView(n).superview()))) {
                return 0;
            }
        }
        return super.hitTest(n, n2, nSPoint);
    }

    boolean imeInComposition() {
        return false;
    }

    boolean insertText(int n, int n2, int n3) {
        if (this.hasKeyboardFocus(n)) {
            int n4;
            Shell shell = this.getShell();
            NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
            if (nSEvent != null && ((n4 = nSEvent.type()) == 10 || n4 == 14)) {
                NSString nSString = new NSString(n3);
                if (nSString.isKindOfClass(OS.class_NSAttributedString)) {
                    nSString = new NSAttributedString(n3).string();
                }
                int n5 = nSString.length();
                char[] cArray = new char[n5];
                nSString.getCharacters(cArray);
                int n6 = 0;
                while (n6 < cArray.length) {
                    shell.keyInputHappened = true;
                    Event event = new Event();
                    if (n6 == 0 && n4 == 10) {
                        this.setKeyState(event, 1, nSEvent);
                    }
                    event.character = cArray[n6];
                    if (!this.sendKeyEvent(1, event)) {
                        return false;
                    }
                    ++n6;
                }
            }
            if ((this.state & 2) != 0) {
                return true;
            }
        }
        return super.insertText(n, n2, n3);
    }

    public int internal_new_GC(GCData gCData) {
        Object object;
        NSObject nSObject;
        this.checkWidget();
        NSView nSView = this.paintView();
        int n = 0;
        if (gCData != null && gCData.paintRect != null) {
            nSObject = NSGraphicsContext.currentContext();
            n = ((NSGraphicsContext)nSObject).id;
            if (!nSView.isFlipped()) {
                gCData.state &= 0xFFFFEFFF;
            }
        } else {
            nSObject = nSView.window();
            if (((NSWindow)nSObject).windowNumber() <= 0) {
                ((NSWindow)nSObject).orderBack(null);
                ((NSWindow)nSObject).orderOut(null);
            }
            object = NSGraphicsContext.graphicsContextWithWindow((NSWindow)nSObject);
            NSGraphicsContext nSGraphicsContext = NSGraphicsContext.graphicsContextWithGraphicsPort(((NSGraphicsContext)object).graphicsPort(), true);
            object = nSGraphicsContext;
            n = ((NSGraphicsContext)object).id;
            if (gCData != null) {
                gCData.flippedContext = nSGraphicsContext;
                gCData.state &= 0xFFFFEFFF;
                gCData.visibleRgn = this.getVisibleRegion();
                this.display.addContext(gCData);
            }
        }
        if (gCData != null) {
            int n2 = 0x6000000;
            if ((gCData.style & n2) == 0) {
                gCData.style |= this.style & (n2 | 0x8000000);
            }
            gCData.device = this.display;
            gCData.thread = this.display.thread;
            gCData.view = nSView;
            gCData.foreground = this.getForegroundColor().handle;
            object = this.findBackgroundControl();
            if (object == null) {
                object = this;
            }
            gCData.background = ((Control)object).getBackgroundColor().handle;
            gCData.font = this.font != null ? this.font : this.defaultFont();
        }
        return n;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        this.checkWidget();
        NSGraphicsContext nSGraphicsContext = new NSGraphicsContext(n);
        this.display.removeContext(gCData);
        if (gCData != null) {
            if (gCData.paintRect == null) {
                nSGraphicsContext.flushGraphics();
            }
            if (gCData.visibleRgn != 0) {
                OS.DisposeRgn(gCData.visibleRgn);
            }
            gCData.visibleRgn = 0;
        }
    }

    void invalidateChildrenVisibleRegion() {
    }

    void invalidateVisibleRegion() {
        int n = 0;
        Control[] controlArray = this.parent._getChildren();
        while (n < controlArray.length && controlArray[n] != this) {
            ++n;
        }
        int n2 = n;
        while (n2 < controlArray.length) {
            Control control = controlArray[n2];
            control.resetVisibleRegion();
            control.invalidateChildrenVisibleRegion();
            ++n2;
        }
        this.parent.resetVisibleRegion();
    }

    boolean isActive() {
        return this.getShell().getModalShell() == null && this.display.getModalDialog() == null;
    }

    boolean isDescribedByLabel() {
        return true;
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isEnabledCursor() {
        return this.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        Control control = this.display.focusControl;
        if (control != null && !control.isDisposed()) {
            return this == control;
        }
        return this.hasFocus();
    }

    boolean isObscured() {
        int n = this.getVisibleRegion();
        int n2 = OS.NewRgn();
        short[] sArray = new short[4];
        NSRect nSRect = this.view.visibleRect();
        OS.SetRect(sArray, (short)nSRect.x, (short)nSRect.y, (short)(nSRect.x + nSRect.width), (short)(nSRect.y + nSRect.height));
        OS.RectRgn(n2, sArray);
        OS.DiffRgn(n2, n, n2);
        boolean bl = !OS.EmptyRgn(n2);
        OS.DisposeRgn(n2);
        OS.DisposeRgn(n);
        return bl;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point point = control.getSize();
            if (point.x == 0 || point.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) {
                    return true;
                }
                ++n;
            }
        }
        if (((n = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (n & 0x18) != 0;
    }

    boolean isTabItem() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) {
                    return false;
                }
                ++n;
            }
        }
        return ((n = this.traversalCode(0, null)) & 0x60) != 0;
    }

    boolean isTransparent() {
        if (this.background != null) {
            return false;
        }
        return this.parent.isTransparent();
    }

    boolean isTrim(NSView nSView) {
        return false;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void keyDown(int n, int n2, int n3) {
        if (this.hasKeyboardFocus(n)) {
            boolean bl;
            Shell shell = this.getShell();
            shell.keyInputHappened = false;
            boolean bl2 = bl = OS.objc_msgSend(n, OS.sel_conformsToProtocol_, OS.objc_getProtocol("NSTextInput")) != 0;
            if (!bl) {
                NSEvent nSEvent = new NSEvent(n3);
                boolean[] blArray = new boolean[1];
                if (this.translateTraversal(nSEvent.keyCode(), nSEvent, blArray)) {
                    return;
                }
                if (this.isDisposed()) {
                    return;
                }
                if (!this.sendKeyEvent(nSEvent, 1)) {
                    return;
                }
                if (blArray[0]) {
                    return;
                }
            } else {
                super.keyDown(n, n2, n3);
                if (this.imeInComposition()) {
                    return;
                }
                if (!shell.keyInputHappened) {
                    NSEvent nSEvent = new NSEvent(n3);
                    boolean[] blArray = new boolean[1];
                    if (this.translateTraversal(nSEvent.keyCode(), nSEvent, blArray)) {
                        return;
                    }
                    if (this.isDisposed()) {
                        return;
                    }
                    if (!this.sendKeyEvent(nSEvent, 1)) {
                        return;
                    }
                    if (blArray[0]) {
                        return;
                    }
                }
                return;
            }
        }
        super.keyDown(n, n2, n3);
    }

    boolean hasKeyboardFocus(int n) {
        return this.view.window().firstResponder().id == n;
    }

    void keyUp(int n, int n2, int n3) {
        NSEvent nSEvent;
        if (this.hasKeyboardFocus(n) && !this.sendKeyEvent(nSEvent = new NSEvent(n3), 2)) {
            return;
        }
        super.keyUp(n, n2, n3);
    }

    void markLayout(boolean bl, boolean bl2) {
    }

    int menuForEvent(int n, int n2, int n3) {
        if (!this.isEnabled()) {
            return 0;
        }
        NSPoint nSPoint = NSEvent.mouseLocation();
        nSPoint.y = (int)(this.display.getPrimaryFrame().height - nSPoint.y);
        int n4 = (int)nSPoint.x;
        int n5 = (int)nSPoint.y;
        Event event = new Event();
        event.x = n4;
        event.y = n5;
        this.sendEvent(35, event);
        if (this.isDisposed()) {
            return 0;
        }
        if (!event.doit) {
            return 0;
        }
        Menu menu = this.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (n4 != event.x || n5 != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0;
        }
        return super.menuForEvent(n, n2, n3);
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    void scrollWheel(int n, int n2, int n3) {
        boolean bl = false;
        if (n == this.view.id) {
            NSEvent nSEvent;
            if ((this.hooks(37) || this.filters(37)) && (nSEvent = new NSEvent(n3)).deltaY() != 0.0f && !this.sendMouseEvent(nSEvent, 37, true)) {
                bl = true;
            }
            if ((this.hooks(38) || this.filters(38)) && (nSEvent = new NSEvent(n3)).deltaX() != 0.0f && !this.sendMouseEvent(nSEvent, 38, true)) {
                bl = true;
            }
        }
        if (!bl) {
            super.scrollWheel(n, n2, n3);
        }
    }

    boolean isEventView(int n) {
        return true;
    }

    boolean mouseEvent(int n, int n2, int n3, int n4) {
        if (!this.display.sendEvent) {
            return true;
        }
        this.display.sendEvent = false;
        if (!this.isEventView(n)) {
            return true;
        }
        boolean bl = false;
        boolean[] blArray = null;
        NSEvent nSEvent = new NSEvent(n3);
        int n5 = nSEvent.type();
        NSInputManager nSInputManager = NSInputManager.currentInputManager();
        if (nSInputManager != null && nSInputManager.wantsToHandleMouseEvents() && nSInputManager.handleMouseEvent(nSEvent)) {
            return true;
        }
        switch (n5) {
            case 1: {
                if (nSEvent.clickCount() != 1 || (this.state & 0x40000) == 0 || !this.hooks(29)) break;
                blArray = new boolean[1];
                NSPoint nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null);
                if (!this.view.isFlipped()) {
                    nSPoint.y = this.view.bounds().height - nSPoint.y;
                }
                bl = this.dragDetect((int)nSPoint.x, (int)nSPoint.y, false, blArray);
                break;
            }
            case 6: 
            case 7: 
            case 27: {
                this.display.checkEnterExit(this, nSEvent, false);
                break;
            }
            case 2: 
            case 4: 
            case 26: {
                this.display.checkEnterExit(this.display.findControl(true), nSEvent, false);
            }
        }
        this.sendMouseEvent(nSEvent, n4, false);
        if (n4 == 3 && nSEvent.clickCount() == 2) {
            this.sendMouseEvent(nSEvent, 8, false);
        }
        if (bl) {
            this.sendMouseEvent(nSEvent, 29, false);
        }
        return blArray == null || !blArray[0];
    }

    void mouseDown(int n, int n2, int n3) {
        if (!this.mouseEvent(n, n2, n3, 3)) {
            return;
        }
        boolean bl = this.isEventView(n);
        Display display = this.display;
        if (bl) {
            display.trackingControl = this;
        }
        super.mouseDown(n, n2, n3);
        if (bl) {
            display.trackingControl = null;
        }
    }

    void mouseUp(int n, int n2, int n3) {
        if (!this.mouseEvent(n, n2, n3, 4)) {
            return;
        }
        super.mouseUp(n, n2, n3);
    }

    void mouseDragged(int n, int n2, int n3) {
        if (!this.mouseEvent(n, n2, n3, 5)) {
            return;
        }
        super.mouseDragged(n, n2, n3);
    }

    void rightMouseDown(int n, int n2, int n3) {
        if (!this.mouseEvent(n, n2, n3, 3)) {
            return;
        }
        super.rightMouseDown(n, n2, n3);
    }

    void rightMouseUp(int n, int n2, int n3) {
        if (!this.mouseEvent(n, n2, n3, 4)) {
            return;
        }
        super.rightMouseUp(n, n2, n3);
    }

    void rightMouseDragged(int n, int n2, int n3) {
        if (!this.mouseEvent(n, n2, n3, 5)) {
            return;
        }
        super.rightMouseDragged(n, n2, n3);
    }

    void otherMouseDown(int n, int n2, int n3) {
        if (!this.mouseEvent(n, n2, n3, 3)) {
            return;
        }
        super.otherMouseDown(n, n2, n3);
    }

    void otherMouseUp(int n, int n2, int n3) {
        if (!this.mouseEvent(n, n2, n3, 4)) {
            return;
        }
        super.otherMouseUp(n, n2, n3);
    }

    void otherMouseDragged(int n, int n2, int n3) {
        if (!this.mouseEvent(n, n2, n3, 5)) {
            return;
        }
        super.otherMouseDragged(n, n2, n3);
    }

    void moved() {
        this.sendEvent(10);
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false);
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean bl) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, bl));
    }

    NSView paintView() {
        return this.eventView();
    }

    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        NSGraphicsContext.static_saveGraphicsState();
        NSGraphicsContext.setCurrentContext(gC.handle);
        NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
        nSAffineTransform.translateXBy(0.0f, this.view.bounds().height);
        nSAffineTransform.scaleXBy(1.0f, -1.0f);
        nSAffineTransform.concat();
        this.view.displayRectIgnoringOpacity(this.view.bounds(), gC.handle);
        NSGraphicsContext.static_restoreGraphicsState();
        return true;
    }

    public void redraw() {
        this.checkWidget();
        this.view.setNeedsDisplay(true);
    }

    void redraw(boolean bl) {
        this.view.setNeedsDisplay(true);
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        NSRect nSRect = new NSRect();
        nSRect.x = n;
        nSRect.y = n2;
        nSRect.width = n3;
        nSRect.height = n4;
        this.view.setNeedsDisplayInRect(nSRect);
    }

    int regionToRects(int n, int n2, int n3, int n4) {
        NSPoint nSPoint = new NSPoint();
        short[] sArray = new short[4];
        if (n == 2) {
            OS.memmove(sArray, n3, sArray.length * 2);
            nSPoint.x = sArray[1];
            nSPoint.y = sArray[0];
            OS.objc_msgSend(n4, OS.sel_moveToPoint_, nSPoint);
            nSPoint.x = sArray[3];
            OS.objc_msgSend(n4, OS.sel_lineToPoint_, nSPoint);
            nSPoint.x = sArray[3];
            nSPoint.y = sArray[2];
            OS.objc_msgSend(n4, OS.sel_lineToPoint_, nSPoint);
            nSPoint.x = sArray[1];
            OS.objc_msgSend(n4, OS.sel_lineToPoint_, nSPoint);
            OS.objc_msgSend(n4, OS.sel_closePath);
        }
        return 0;
    }

    void register() {
        super.register();
        this.display.addWidget(this.view, this);
    }

    void release(boolean bl) {
        Control control = null;
        Control control2 = null;
        if (bl && this.parent != null) {
            Control[] controlArray = this.parent._getChildren();
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) break;
                ++n;
            }
            if (n > 0 && n + 1 < controlArray.length) {
                control = controlArray[n + 1];
                control2 = controlArray[n - 1];
            }
        }
        super.release(bl);
        if (bl && control2 != null) {
            control2.addRelation(control);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.view != null) {
            this.view.release();
        }
        this.view = null;
        this.parent = null;
    }

    void releaseParent() {
        this.invalidateVisibleRegion();
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentControl == this) {
            this.display.currentControl = null;
            this.display.timerExec(-1, this.display.hoverTimer);
        }
        if (this.display.trackingControl == this) {
            this.display.trackingControl = null;
        }
        if (this.display.tooltipControl == this) {
            this.display.tooltipControl = null;
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
        }
        this.visibleRgn = 0;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
        this.region = null;
        if (this.regionPath != null) {
            this.regionPath.release();
        }
        this.regionPath = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeDragDetectListener(DragDetectListener dragDetectListener) {
        this.checkWidget();
        if (dragDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, dragDetectListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, focusListener);
        this.eventTable.unhook(16, focusListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void removeMenuDetectListener(MenuDetectListener menuDetectListener) {
        this.checkWidget();
        if (menuDetectListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, menuDetectListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, mouseListener);
        this.eventTable.unhook(4, mouseListener);
        this.eventTable.unhook(8, mouseListener);
    }

    public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, mouseMoveListener);
    }

    public void removeMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, mouseTrackListener);
        this.eventTable.unhook(7, mouseTrackListener);
        this.eventTable.unhook(32, mouseTrackListener);
    }

    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.checkWidget();
        if (mouseWheelListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, mouseWheelListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, paintListener);
    }

    void removeRelation() {
        NSControl nSControl;
        if (!this.isDescribedByLabel()) {
            return;
        }
        NSObject nSObject = this.focusView();
        if (nSObject instanceof NSControl && (nSControl = (NSControl)nSObject).cell() != null) {
            nSObject = nSControl.cell();
        }
        nSObject.accessibilitySetOverrideValue(nSObject, OS.NSAccessibilityTitleUIElementAttribute);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, traverseListener);
    }

    void resetVisibleRegion() {
        GCData[] gCDataArray;
        if (this.visibleRgn != 0) {
            OS.DisposeRgn(this.visibleRgn);
            this.visibleRgn = 0;
        }
        if ((gCDataArray = this.display.contexts) != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < gCDataArray.length) {
                GCData gCData = gCDataArray[n2];
                if (gCData != null && gCData.view == this.view) {
                    if (n == 0) {
                        n = this.getVisibleRegion();
                    }
                    gCData.state &= 0xFFFFEFFF;
                    OS.CopyRgn(n, gCData.visibleRgn);
                }
                ++n2;
            }
            if (n != 0) {
                OS.DisposeRgn(n);
            }
        }
    }

    void resized() {
        this.sendEvent(11);
    }

    boolean sendDragEvent(int n, int n2, int n3, int n4) {
        Event event = new Event();
        event.button = n;
        event.x = n3;
        event.y = n4;
        event.stateMask = n2;
        this.postEvent(29, event);
        return event.doit;
    }

    void sendFocusEvent(int n) {
        Display display = this.display;
        Shell shell = this.getShell();
        display.focusEvent = n;
        display.focusControl = this;
        this.sendEvent(n);
        display.focusEvent = 0;
        display.focusControl = null;
        if (!shell.isDisposed()) {
            switch (n) {
                case 15: {
                    shell.setActiveControl(this);
                    break;
                }
                case 16: {
                    if (shell == display.getActiveShell()) break;
                    shell.setActiveControl(null);
                }
            }
        }
    }

    boolean sendMouseEvent(NSEvent nSEvent, int n, boolean bl) {
        NSPoint nSPoint;
        Object object;
        Shell shell = null;
        Event event = new Event();
        switch (n) {
            case 3: {
                shell = this.getShell();
            }
            case 4: 
            case 8: 
            case 29: {
                int n2 = nSEvent.buttonNumber();
                switch (n2) {
                    case 0: {
                        event.button = 1;
                        break;
                    }
                    case 1: {
                        event.button = 3;
                        break;
                    }
                    case 2: {
                        event.button = 2;
                        break;
                    }
                    case 3: {
                        event.button = 4;
                        break;
                    }
                    case 4: {
                        event.button = 5;
                    }
                }
                break;
            }
            case 37: {
                event.detail = 1;
                float f = nSEvent.deltaY();
                event.count = f > 0.0f ? Math.max(1, (int)f) : Math.min(-1, (int)f);
                break;
            }
            case 38: {
                float f = nSEvent.deltaX();
                int n3 = event.count = f > 0.0f ? Math.max(1, (int)f) : Math.min(-1, (int)f);
            }
        }
        if (event.button != 0) {
            event.count = nSEvent.clickCount();
        }
        NSView nSView = this.eventView();
        if (nSEvent == null || nSEvent.type() == 5) {
            object = nSView.window();
            nSPoint = ((NSWindow)object).convertScreenToBase(NSEvent.mouseLocation());
        } else {
            nSPoint = nSEvent.locationInWindow();
        }
        object = nSView.convertPoint_fromView_(nSPoint, null);
        if (!nSView.isFlipped()) {
            ((NSPoint)object).y = nSView.bounds().height - ((NSPoint)object).y;
        }
        event.x = (int)((NSPoint)object).x;
        event.y = (int)((NSPoint)object).y;
        this.setInputState(event, nSEvent, n);
        if (bl) {
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(n, event);
        }
        if (shell != null) {
            shell.setActiveControl(this);
        }
        return event.doit;
    }

    void setBackground() {
        if (!this.drawsBackground()) {
            return;
        }
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.setBackgroundImage(control.backgroundImage.handle);
        } else {
            float[] fArray = control.background != null ? control.background : control.defaultBackground().handle;
            NSColor nSColor = NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], fArray[3]);
            this.setBackgroundColor(nSColor);
        }
    }

    public void setBackground(Color color) {
        float[] fArray;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        float[] fArray2 = fArray = color != null ? color.handle : null;
        if (this.equals(fArray, this.background)) {
            return;
        }
        this.background = fArray;
        this.updateBackgroundColor();
        this.redrawWidget(this.view, true);
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        if (image == this.backgroundImage) {
            return;
        }
        this.backgroundImage = image;
        this.updateBackgroundImage();
    }

    void setBackgroundImage(NSImage nSImage) {
        this.redrawWidget(this.view, true);
    }

    void setBackgroundColor(NSColor nSColor) {
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        this.setBounds(n, n2, Math.max(0, n3), Math.max(0, n4), true, true);
    }

    void setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        NSView nSView = this.topView();
        if (bl && bl2) {
            NSRect nSRect = new NSRect();
            nSRect.x = n;
            nSRect.y = n2;
            nSRect.width = n3;
            nSRect.height = n4;
            nSView.setFrame(nSRect);
        } else if (bl) {
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = n;
            nSPoint.y = n2;
            nSView.setFrameOrigin(nSPoint);
        } else if (bl2) {
            NSSize nSSize = new NSSize();
            nSSize.width = n3;
            nSSize.height = n4;
            nSView.setFrameSize(nSSize);
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, Math.max(0, rectangle.width), Math.max(0, rectangle.height), true, true);
    }

    public void setCapture(boolean bl) {
        this.checkWidget();
    }

    void setClipRegion(NSView nSView) {
        if (this.regionPath != null) {
            NSView nSView2 = this.topView();
            if (!nSView2.isFlipped()) {
                nSView2 = this.eventView();
            }
            NSPoint nSPoint = nSView.convertPoint_toView_(new NSPoint(), nSView2);
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(-nSPoint.x, -nSPoint.y);
            this.regionPath.transformUsingAffineTransform(nSAffineTransform);
            this.regionPath.addClip();
            nSAffineTransform.translateXBy(2.0f * nSPoint.x, 2.0f * nSPoint.y);
            this.regionPath.transformUsingAffineTransform(nSAffineTransform);
        }
        this.parent.setClipRegion(nSView);
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        if (!this.isEnabled()) {
            return;
        }
        if (!this.view.window().areCursorRectsEnabled()) {
            return;
        }
        this.display.setCursor(this.display.currentControl);
    }

    void setDefaultFont() {
        if (this.display.smallFonts) {
            this.setFont(this.defaultFont().handle);
            this.setSmallSize();
        }
    }

    public void setDragDetect(boolean bl) {
        this.checkWidget();
        this.state = bl ? (this.state |= 0x40000) : (this.state &= 0xFFFBFFFF);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if ((this.state & 8) == 0 == bl) {
            return;
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.state = bl ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        this.enableWidget(bl);
        if (bl2) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        this.setFont(font != null ? font.handle : this.defaultFont().handle);
    }

    void setFont(NSFont nSFont) {
        if (this.view instanceof NSControl) {
            ((NSControl)this.view).setFont(nSFont);
        }
    }

    public void setForeground(Color color) {
        float[] fArray;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        float[] fArray2 = fArray = color != null ? color.handle : null;
        if (this.equals(fArray, this.foreground)) {
            return;
        }
        this.foreground = fArray;
        this.setForeground(fArray);
        this.redrawWidget(this.view, false);
    }

    void setForeground(float[] fArray) {
    }

    void setFrameOrigin(int n, int n2, NSPoint nSPoint) {
        NSView nSView = this.topView();
        if (nSView.id != n) {
            super.setFrameOrigin(n, n2, nSPoint);
            return;
        }
        NSRect nSRect = nSView.frame();
        super.setFrameOrigin(n, n2, nSPoint);
        if (nSRect.x != nSPoint.x || nSRect.y != nSPoint.y) {
            this.invalidateVisibleRegion();
            this.moved();
        }
    }

    void setFrameSize(int n, int n2, NSSize nSSize) {
        NSView nSView = this.topView();
        if (nSView.id != n) {
            super.setFrameSize(n, n2, nSSize);
            return;
        }
        NSRect nSRect = nSView.frame();
        super.setFrameSize(n, n2, nSSize);
        if (nSRect.width != nSSize.width || nSRect.height != nSSize.height) {
            this.invalidateVisibleRegion();
            this.resized();
        }
    }

    public void setLayoutData(Object object) {
        this.checkWidget();
        this.layoutData = object;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        this.setBounds(n, n2, 0, 0, true, false);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(point.x, point.y, 0, 0, true, false);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public boolean setParent(Composite composite) {
        Object object;
        this.checkWidget();
        if (composite == null) {
            this.error(4);
        }
        if (composite.isDisposed()) {
            SWT.error(5);
        }
        if (this.parent == composite) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        this.releaseParent();
        Shell shell = composite.getShell();
        Shell shell2 = this.getShell();
        Decorations decorations = composite.menuShell();
        Decorations decorations2 = this.menuShell();
        if (shell2 != shell || decorations2 != decorations) {
            object = shell2.findMenus(this);
            this.fixChildren(shell, shell2, decorations, decorations2, (Menu[])object);
        }
        object = this.topView();
        ((NSObject)object).retain();
        ((NSView)object).removeFromSuperview();
        composite.contentView().addSubview((NSView)object, -1, null);
        ((NSObject)object).release();
        this.parent = composite;
        this.reskin(1);
        return true;
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        if (bl) {
            if (--this.drawCount == 0) {
                this.invalidateVisibleRegion();
                this.redrawWidget(this.topView(), true);
            }
        } else {
            if (this.drawCount == 0) {
                this.invalidateVisibleRegion();
            }
            ++this.drawCount;
        }
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        this.region = region;
        if (this.regionPath != null) {
            this.regionPath.release();
        }
        this.regionPath = this.getPath(region);
        this.redrawWidget(this.view, true);
    }

    void setRelations() {
        Control control;
        if (this.parent == null) {
            return;
        }
        Control[] controlArray = this.parent._getChildren();
        int n = controlArray.length;
        if (n > 1 && (control = controlArray[n - 2]) != this) {
            control.addRelation(this);
        }
    }

    boolean setRadioSelection(boolean bl) {
        return false;
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, n), Math.max(0, n2), false, true);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setBounds(0, 0, Math.max(0, point.x), Math.max(0, point.y), false, true);
    }

    void setSmallSize() {
        NSCell nSCell;
        if (this.view instanceof NSControl && (nSCell = ((NSControl)this.view).cell()) != null) {
            nSCell.setControlSize(1);
        }
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.checkToolTip(null);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (bl) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.topView().setHidden(!bl);
        if (this.isDisposed()) {
            return;
        }
        this.invalidateVisibleRegion();
        if (!bl) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (bl2) {
            this.fixFocus(control);
        }
    }

    void setZOrder() {
        NSView nSView = this.topView();
        this.parent.contentView().addSubview(nSView, -1, null);
    }

    boolean shouldDelayWindowOrderingForEvent(int n, int n2, int n3) {
        Shell shell = this.getShell();
        if ((shell.style & 0x4000) != 0) {
            return false;
        }
        return super.shouldDelayWindowOrderingForEvent(n, n2, n3);
    }

    void setZOrder(Control control, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        Control[] controlArray = null;
        controlArray = this.parent._getChildren();
        while (n < controlArray.length) {
            if (controlArray[n] == this) break;
            ++n;
        }
        if (control != null) {
            while (n2 < controlArray.length) {
                if (controlArray[n2] == control) break;
                ++n2;
            }
        }
        this.removeRelation();
        if (n + 1 < controlArray.length) {
            n3 = n + 1;
            controlArray[n3].removeRelation();
        }
        if (control != null) {
            if (bl) {
                control.removeRelation();
            } else if (n2 + 1 < controlArray.length) {
                controlArray[n2 + 1].removeRelation();
            }
        }
        NSView nSView = control == null ? null : control.topView();
        NSView nSView2 = this.topView();
        nSView2.retain();
        nSView2.removeFromSuperview();
        this.parent.contentView().addSubview(nSView2, bl ? 1 : -1, nSView);
        nSView2.release();
        this.invalidateVisibleRegion();
        n = control != null ? (bl ? n2 - (n < n2 ? 1 : 0) : n2 + (n2 < n ? 1 : 0)) : (bl ? 0 : controlArray.length - 1);
        controlArray = this.parent._getChildren();
        if (n > 0) {
            controlArray[n - 1].addRelation(this);
        }
        if (n + 1 < controlArray.length) {
            this.addRelation(controlArray[n + 1]);
        }
        if (n3 != -1) {
            if (n3 <= n) {
                --n3;
            }
            if (n3 > 0 && n3 != n && n3 != n + 1) {
                controlArray[n3 - 1].addRelation(controlArray[n3]);
            }
        }
    }

    void sort(int[] nArray) {
        int n = nArray.length;
        int n2 = n / 2;
        while (n2 > 0) {
            int n3 = n2;
            while (n3 < n) {
                int n4 = n3 - n2;
                while (n4 >= 0) {
                    if (nArray[n4] <= nArray[n4 + n2]) {
                        int n5 = nArray[n4];
                        nArray[n4] = nArray[n4 + n2];
                        nArray[n4 + n2] = n5;
                    }
                    n4 -= n2;
                }
                ++n3;
            }
            n2 /= 2;
        }
    }

    NSSize textExtent(String string) {
        NSAttributedString nSAttributedString = this.createString(string, null, null, 0, false, true, false);
        NSSize nSSize = nSAttributedString.size();
        nSAttributedString.release();
        return nSSize;
    }

    String tooltipText() {
        return this.toolTipText;
    }

    public Point toControl(int n, int n2) {
        this.checkWidget();
        return this.display.map(null, this, n, n2);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int n, int n2) {
        this.checkWidget();
        return this.display.map(this, null, n, n2);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    NSView topView() {
        return this.view;
    }

    boolean translateTraversal(int n, NSEvent nSEvent, boolean[] blArray) {
        int n2 = 0;
        int n3 = this.traversalCode(n, nSEvent);
        boolean bl = false;
        switch (n) {
            case 53: {
                bl = true;
                n2 = 2;
                break;
            }
            case 36: 
            case 76: {
                bl = true;
                n2 = 4;
                break;
            }
            case 48: {
                int n4 = nSEvent.modifierFlags();
                boolean bl2 = (n4 & 0x20000) == 0;
                n2 = bl2 ? 16 : 8;
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                int n4 = n != 125 && n != 124 ? 0 : 1;
                n2 = n4 != 0 ? 64 : 32;
                break;
            }
            case 116: 
            case 121: {
                bl = true;
                int n4 = nSEvent.modifierFlags();
                if ((n4 & 0x40000) == 0) {
                    return false;
                }
                n2 = n == 121 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        blArray[0] = (n3 & n2) != 0;
        event.doit = blArray[0];
        event.detail = n2;
        if (!this.setKeyState(event, 31, nSEvent)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl && control != null);
        return false;
    }

    int traversalCode(int n, NSEvent nSEvent) {
        int n2 = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            n2 |= 2;
        }
        return n2;
    }

    boolean traverseMnemonic(char c) {
        return false;
    }

    public boolean traverse(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.traverse(n, event.character, event.keyCode, event.keyLocation, event.stateMask, event.doit);
    }

    public boolean traverse(int n, KeyEvent keyEvent) {
        this.checkWidget();
        if (keyEvent == null) {
            this.error(4);
        }
        return this.traverse(n, keyEvent.character, keyEvent.keyCode, keyEvent.keyLocation, keyEvent.stateMask, keyEvent.doit);
    }

    boolean traverse(int n, char c, int n2, int n3, int n4, boolean bl) {
        if (n == 0) {
            switch (n2) {
                case 27: {
                    n = 2;
                    bl = true;
                    break;
                }
                case 13: {
                    n = 4;
                    bl = true;
                    break;
                }
                case 0x1000002: 
                case 0x1000004: {
                    n = 64;
                    bl = false;
                    break;
                }
                case 0x1000001: 
                case 0x1000003: {
                    n = 32;
                    bl = false;
                    break;
                }
                case 9: {
                    n = (n4 & 0x20000) != 0 ? 8 : 16;
                    bl = true;
                    break;
                }
                case 0x1000006: {
                    if ((n4 & 0x40000) == 0) break;
                    n = 512;
                    bl = true;
                    break;
                }
                case 0x1000005: {
                    if ((n4 & 0x40000) == 0) break;
                    n = 256;
                    bl = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        Event event = new Event();
        event.character = c;
        event.detail = n;
        event.doit = bl;
        event.keyCode = n2;
        event.keyLocation = n3;
        event.stateMask = n4;
        Shell shell = this.getShell();
        boolean bl2 = false;
        switch (n) {
            case 2: 
            case 4: 
            case 256: 
            case 512: {
                bl2 = true;
            }
            case 8: 
            case 16: 
            case 32: 
            case 64: {
                break;
            }
            default: {
                return false;
            }
        }
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl2 && control != null);
        return false;
    }

    public boolean traverse(int n) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = n;
        return this.traverse(event);
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean bl) {
        Control control = this.computeTabRoot();
        Widget widget = this.computeTabGroup();
        Widget[] widgetArray = control.computeTabList();
        int n = widgetArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (widgetArray[n2] == widget) break;
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        int n3 = n2;
        int n4 = bl ? 1 : -1;
        while ((n2 = (n2 + n4 + n) % n) != n3) {
            Widget widget2 = widgetArray[n2];
            if (widget2.isDisposed() || !widget2.setTabGroupFocus()) continue;
            return true;
        }
        if (widget.isDisposed()) {
            return false;
        }
        return widget.setTabGroupFocus();
    }

    boolean traverseItem(boolean bl) {
        Control[] controlArray = this.parent._getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (controlArray[n2] == this) break;
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        int n3 = n2;
        int n4 = bl ? 1 : -1;
        while ((n2 = (n2 + n4 + n) % n) != n3) {
            Control control = controlArray[n2];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    boolean traversePage(boolean bl) {
        return false;
    }

    boolean traverseMnemonic(Event event) {
        return false;
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    /*
     * Exception decompiling
     */
    void update(boolean var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 89->93)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void updateBackgroundColor() {
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        float[] fArray = control.background != null ? control.background : control.defaultBackground().handle;
        NSColor nSColor = NSColor.colorWithDeviceRed(fArray[0], fArray[1], fArray[2], fArray[3]);
        this.setBackgroundColor(nSColor);
    }

    void updateBackgroundImage() {
        Control control = this.findBackgroundControl();
        Image image = control != null ? control.backgroundImage : this.backgroundImage;
        this.setBackgroundImage(image != null ? image.handle : null);
    }

    void updateBackgroundMode() {
        int n = this.state & 0x400;
        this.checkBackground();
        if (n != (this.state & 0x400)) {
            this.setBackground();
        }
    }

    void resetCursorRects(int n, int n2) {
        if (this.isEnabled()) {
            this.callSuper(n, n2);
        }
    }

    void updateTrackingAreas(int n, int n2) {
        if (this.isEnabled()) {
            this.callSuper(n, n2);
        }
    }

    void updateCursorRects(boolean bl) {
        this.updateCursorRects(bl, this.view);
    }

    void updateCursorRects(boolean bl, NSView nSView) {
        if (bl) {
            nSView.resetCursorRects();
            nSView.updateTrackingAreas();
        } else {
            nSView.discardCursorRects();
            NSArray nSArray = nSView.trackingAreas();
            int n = 0;
            while (n < nSArray.count()) {
                nSView.removeTrackingArea(new NSTrackingArea(nSArray.objectAtIndex(n)));
                ++n;
            }
        }
    }

    void updateLayout(boolean bl) {
    }
}

