/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDate;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean cancelled;
    boolean stippled;
    Cursor clientCursor;
    Cursor resizeCursor;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int cursorOrientation = 0;
    boolean inEvent = false;
    NSWindow window;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite composite, int n) {
        super(composite, Tracker.checkStyle(n));
        this.parent = composite;
    }

    public Tracker(Display display, int n) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(n);
        this.display = display;
        this.reskinWidget();
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n = this.bounds.x + this.bounds.width / 2;
        int n2 = this.bounds.y;
        if (this.parent != null) {
            Point point = this.parent.toDisplay(n, n2);
            n = point.x;
            n2 = point.y;
        }
        this.display.setCursorLocation(n, n2);
        return new Point(n, n2);
    }

    Point adjustResizeCursor(boolean bl) {
        Object object;
        if (this.bounds == null) {
            return null;
        }
        int n = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int n2 = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        if (this.parent != null) {
            object = this.parent.toDisplay(n, n2);
            n = ((Point)object).x;
            n2 = ((Point)object).y;
        }
        if (bl) {
            this.display.setCursorLocation(n, n2);
        }
        if (this.clientCursor == null) {
            object = null;
            switch (this.cursorOrientation) {
                case 128: {
                    object = new Cursor(this.display, 7);
                    break;
                }
                case 1024: {
                    object = new Cursor(this.display, 7);
                    break;
                }
                case 16384: {
                    object = new Cursor(this.display, 9);
                    break;
                }
                case 131072: {
                    object = new Cursor(this.display, 9);
                    break;
                }
                case 16512: {
                    object = new Cursor(this.display, 8);
                    break;
                }
                case 132096: {
                    object = new Cursor(this.display, 8);
                    break;
                }
                case 17408: {
                    object = new Cursor(this.display, 6);
                    break;
                }
                case 131200: {
                    object = new Cursor(this.display, 6);
                    break;
                }
                default: {
                    object = new Cursor(this.display, 5);
                }
            }
            this.display.lockCursor = false;
            ((Cursor)object).handle.set();
            this.display.lockCursor = true;
            if (this.resizeCursor != null) {
                this.resizeCursor.dispose();
            }
            this.resizeCursor = object;
        }
        return new Point(n, n2);
    }

    static int checkStyle(int n) {
        if ((n & 0x24480) == 0) {
            n |= 0x24480;
        }
        return n;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int n = this.rectangles[0].x;
        int n2 = this.rectangles[0].y;
        int n3 = this.rectangles[0].x + this.rectangles[0].width;
        int n4 = this.rectangles[0].y + this.rectangles[0].height;
        int n5 = 1;
        while (n5 < this.rectangles.length) {
            int n6;
            int n7;
            if (this.rectangles[n5].x < n) {
                n = this.rectangles[n5].x;
            }
            if (this.rectangles[n5].y < n2) {
                n2 = this.rectangles[n5].y;
            }
            if ((n7 = this.rectangles[n5].x + this.rectangles[n5].width) > n3) {
                n3 = n7;
            }
            if ((n6 = this.rectangles[n5].y + this.rectangles[n5].height) > n4) {
                n4 = n6;
            }
            ++n5;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    Rectangle[] computeProportions(Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            int n = 0;
            while (n < rectangleArray.length) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                if (this.bounds.width != 0) {
                    n2 = (rectangleArray[n].x - this.bounds.x) * 100 / this.bounds.width;
                    n4 = rectangleArray[n].width * 100 / this.bounds.width;
                } else {
                    n4 = 100;
                }
                if (this.bounds.height != 0) {
                    n3 = (rectangleArray[n].y - this.bounds.y) * 100 / this.bounds.height;
                    n5 = rectangleArray[n].height * 100 / this.bounds.height;
                } else {
                    n5 = 100;
                }
                rectangleArray2[n] = new Rectangle(n2, n3, n4, n5);
                ++n;
            }
        }
        return rectangleArray2;
    }

    void drawRectangles(NSWindow nSWindow, Rectangle[] rectangleArray, boolean bl) {
        NSGraphicsContext nSGraphicsContext = nSWindow.graphicsContext();
        NSGraphicsContext.static_saveGraphicsState();
        NSGraphicsContext.setCurrentContext(nSGraphicsContext);
        nSGraphicsContext.saveGraphicsState();
        Point point = this.parent != null ? this.display.map(this.parent, null, 0, 0) : new Point(0, 0);
        nSGraphicsContext.setCompositingOperation(bl ? 0 : 2);
        NSRect nSRect = new NSRect();
        NSPoint nSPoint = new NSPoint();
        float f = this.display.getPrimaryFrame().height;
        int n = 0;
        while (n < rectangleArray.length) {
            Rectangle rectangle = rectangleArray[n];
            nSRect.x = rectangle.x + point.x;
            nSRect.y = f - (float)(rectangle.y + point.y + rectangle.height);
            nSRect.width = rectangle.width;
            nSRect.height = rectangle.height;
            nSPoint.x = nSRect.x;
            nSPoint.y = nSRect.y;
            nSPoint = nSWindow.convertScreenToBase(nSPoint);
            nSRect.x = nSPoint.x;
            nSRect.y = nSPoint.y;
            if (bl) {
                nSRect.width += 1.0f;
                nSRect.height += 1.0f;
                NSBezierPath.fillRect(nSRect);
            } else {
                nSRect.x += 0.5f;
                nSRect.y += 0.5f;
                NSBezierPath.strokeRect(nSRect);
            }
            ++n;
        }
        if (!bl) {
            nSGraphicsContext.flushGraphics();
        }
        nSGraphicsContext.restoreGraphicsState();
        NSGraphicsContext.static_restoreGraphicsState();
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        int n = 0;
        while (n < this.rectangles.length) {
            Rectangle rectangle = this.rectangles[n];
            rectangleArray[n] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n;
        }
        return rectangleArray;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void mouse(NSEvent nSEvent) {
        NSPoint nSPoint;
        if (nSEvent == null || nSEvent.type() == 5) {
            nSPoint = NSEvent.mouseLocation();
        } else {
            nSPoint = nSEvent.locationInWindow();
            nSPoint = nSEvent.window().convertBaseToScreen(nSPoint);
        }
        nSPoint.y = this.display.getPrimaryFrame().height - nSPoint.y;
        int n = (int)nSPoint.x;
        int n2 = (int)nSPoint.y;
        if (n != this.oldX || n2 != this.oldY) {
            Rectangle[] rectangleArray = this.rectangles;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            int n3 = 0;
            while (n3 < this.rectangles.length) {
                Rectangle rectangle = this.rectangles[n3];
                rectangleArray2[n3] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n3;
            }
            Event event = new Event();
            event.x = n;
            event.y = n2;
            if ((this.style & 0x10) != 0) {
                Point point;
                boolean bl = this.resizeRectangles(n - this.oldX, n2 - this.oldY);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean bl2 = false;
                if (this.rectangles != rectangleArray) {
                    int n4 = this.rectangles.length;
                    if (n4 != rectangleArray2.length) {
                        bl2 = true;
                    } else {
                        int n5 = 0;
                        while (n5 < n4) {
                            if (!this.rectangles[n5].equals(rectangleArray2[n5])) {
                                bl2 = true;
                                break;
                            }
                            ++n5;
                        }
                    }
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    this.drawRectangles(this.window, rectangleArray2, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
                if ((point = this.adjustResizeCursor(bl)) != null) {
                    n = point.x;
                    n2 = point.y;
                }
            } else {
                this.moveRectangles(n - this.oldX, n2 - this.oldY);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n6 = this.rectangles.length;
                    if (n6 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        int n7 = 0;
                        while (n7 < n6) {
                            if (!this.rectangles[n7].equals(rectangleArray2[n7])) {
                                bl = true;
                                break;
                            }
                            ++n7;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(this.window, rectangleArray2, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
            }
            this.oldX = n;
            this.oldY = n2;
        }
        switch (nSEvent.type()) {
            case 2: 
            case 4: 
            case 26: {
                this.tracking = false;
            }
        }
    }

    void key(NSEvent nSEvent) {
        int n = nSEvent.modifierFlags();
        int n2 = (n & 0x40000) != 0 ? 1 : 9;
        int n3 = 0;
        int n4 = 0;
        switch (nSEvent.keyCode()) {
            case 53: {
                this.cancelled = true;
                this.tracking = false;
                break;
            }
            case 36: 
            case 76: {
                this.tracking = false;
                break;
            }
            case 123: {
                n3 = -n2;
                break;
            }
            case 124: {
                n3 = n2;
                break;
            }
            case 126: {
                n4 = -n2;
                break;
            }
            case 125: {
                n4 = n2;
            }
        }
        if (n3 != 0 || n4 != 0) {
            Point point;
            Rectangle[] rectangleArray = this.rectangles;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            int n5 = 0;
            while (n5 < this.rectangles.length) {
                Rectangle rectangle = this.rectangles[n5];
                rectangleArray2[n5] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n5;
            }
            Event event = new Event();
            int n6 = this.oldX + n3;
            int n7 = this.oldY + n4;
            event.x = n6;
            event.y = n7;
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(n3, n4);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n8 = this.rectangles.length;
                    if (n8 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        int n9 = 0;
                        while (n9 < n8) {
                            if (!this.rectangles[n9].equals(rectangleArray2[n9])) {
                                bl = true;
                                break;
                            }
                            ++n9;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(this.window, rectangleArray2, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
                point = this.adjustResizeCursor(true);
            } else {
                this.moveRectangles(n3, n4);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n10 = this.rectangles.length;
                    if (n10 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        int n11 = 0;
                        while (n11 < n10) {
                            if (!this.rectangles[n11].equals(rectangleArray2[n11])) {
                                bl = true;
                                break;
                            }
                            ++n11;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(this.window, rectangleArray2, true);
                    this.drawRectangles(this.window, this.rectangles, false);
                }
                point = this.adjustMoveCursor();
            }
            if (point != null) {
                this.oldX = point.x;
                this.oldY = point.y;
            }
        }
    }

    void moveRectangles(int n, int n2) {
        if (this.bounds == null) {
            return;
        }
        if (n < 0 && (this.style & 0x4000) == 0) {
            n = 0;
        }
        if (n > 0 && (this.style & 0x20000) == 0) {
            n = 0;
        }
        if (n2 < 0 && (this.style & 0x80) == 0) {
            n2 = 0;
        }
        if (n2 > 0 && (this.style & 0x400) == 0) {
            n2 = 0;
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        this.bounds.x += n;
        this.bounds.y += n2;
        int n3 = 0;
        while (n3 < this.rectangles.length) {
            this.rectangles[n3].x += n;
            this.rectangles[n3].y += n2;
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean open() {
        Point point;
        int n;
        NSObject nSObject;
        this.checkWidget();
        Display display = this.display;
        this.cancelled = false;
        this.tracking = true;
        this.window = (NSWindow)new NSWindow().alloc();
        NSArray nSArray = NSScreen.screens();
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        float f3 = Float.MAX_VALUE;
        float f4 = Float.MIN_VALUE;
        int n2 = nSArray.count();
        int n3 = 0;
        while (n3 < n2) {
            nSObject = new NSScreen(nSArray.objectAtIndex(n3));
            NSRect nSRect = ((NSScreen)nSObject).frame();
            float f5 = nSRect.x;
            float f6 = nSRect.x + nSRect.width;
            float f7 = nSRect.y;
            float f8 = nSRect.y + nSRect.height;
            if (f5 < f) {
                f = f5;
            }
            if (f6 < f) {
                f = f6;
            }
            if (f5 > f2) {
                f2 = f5;
            }
            if (f6 > f2) {
                f2 = f6;
            }
            if (f7 < f3) {
                f3 = f7;
            }
            if (f8 < f3) {
                f3 = f8;
            }
            if (f7 > f4) {
                f4 = f7;
            }
            if (f8 > f4) {
                f4 = f8;
            }
            ++n3;
        }
        NSRect nSRect = new NSRect();
        nSRect.x = f;
        nSRect.y = f3;
        nSRect.width = f2 - f;
        nSRect.height = f4 - f3;
        this.window = this.window.initWithContentRect(nSRect, 0, 2, false);
        this.window.setOpaque(false);
        this.window.setContentView(null);
        this.window.setBackgroundColor(NSColor.clearColor());
        nSObject = this.window.graphicsContext();
        NSGraphicsContext.static_saveGraphicsState();
        NSGraphicsContext.setCurrentContext((NSGraphicsContext)nSObject);
        ((NSGraphicsContext)nSObject).setCompositingOperation(0);
        nSRect.y = 0.0f;
        nSRect.x = 0.0f;
        NSBezierPath.fillRect(nSRect);
        NSGraphicsContext.static_restoreGraphicsState();
        this.window.orderFrontRegardless();
        this.drawRectangles(this.window, this.rectangles, false);
        int n4 = this.style & 0x480;
        if (n4 == 128 || n4 == 1024) {
            this.cursorOrientation |= n4;
        }
        if ((n = this.style & 0x24000) == 16384 || n == 131072) {
            this.cursorOrientation |= n;
        }
        boolean bl = false;
        NSApplication nSApplication = NSApplication.sharedApplication();
        NSEvent nSEvent = nSApplication.currentEvent();
        if (nSEvent != null) {
            switch (nSEvent.type()) {
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 25: 
                case 27: {
                    bl = true;
                    break;
                }
            }
        }
        if ((point = bl ? display.getCursorLocation() : ((this.style & 0x10) != 0 ? this.adjustResizeCursor(true) : this.adjustMoveCursor())) != null) {
            this.oldX = point.x;
            this.oldY = point.y;
        }
        Control control = display.trackingControl;
        display.trackingControl = null;
        while (this.tracking && !this.cancelled) {
            Object var20_26;
            display.addPool();
            try {
                NSEvent nSEvent2 = nSApplication.nextEventMatchingMask(0, NSDate.distantFuture(), OS.NSDefaultRunLoopMode, true);
                if (nSEvent2 == null) {
                    var20_26 = null;
                    display.removePool();
                    continue;
                }
                int n5 = nSEvent2.type();
                switch (n5) {
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 26: 
                    case 27: {
                        this.mouse(nSEvent2);
                        break;
                    }
                    case 10: 
                    case 12: {
                        this.key(nSEvent2);
                        break;
                    }
                }
                boolean bl2 = true;
                switch (n5) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 25: 
                    case 26: 
                    case 27: {
                        bl2 = false;
                        break;
                    }
                }
                if (bl2) {
                    nSApplication.sendEvent(nSEvent2);
                }
                if (this.clientCursor != null && this.resizeCursor == null) {
                    display.lockCursor = false;
                    this.clientCursor.handle.set();
                    display.lockCursor = true;
                }
                var20_26 = null;
                display.removePool();
            }
            catch (Throwable throwable) {
                var20_26 = null;
                display.removePool();
                throw throwable;
            }
        }
        if (this.resizeCursor != null) {
            this.resizeCursor.dispose();
        }
        this.resizeCursor = null;
        if (control != null && !control.isDisposed()) {
            display.trackingControl = control;
        }
        display.setCursor(display.findControl(true));
        if (!this.isDisposed()) {
            this.drawRectangles(this.window, this.rectangles, true);
        }
        if (this.window != null) {
            this.window.close();
        }
        this.tracking = false;
        this.window = null;
        if (!this.cancelled) return true;
        return false;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, controlListener);
        this.eventTable.unhook(10, controlListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    boolean resizeRectangles(int n, int n2) {
        Rectangle rectangle;
        int n3;
        if (this.bounds == null) {
            return false;
        }
        boolean bl = false;
        if (n < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x4000;
            bl = true;
        }
        if (n > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x20000;
            bl = true;
        }
        if (n2 < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x80;
            bl = true;
        }
        if (n2 > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x400;
            bl = true;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (n > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return bl;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                n -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    n3 = 0;
                    while (n3 < this.proportions.length) {
                        rectangle = this.proportions[n3];
                        rectangle.x = 100 - rectangle.x - rectangle.width;
                        ++n3;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -n) {
            if ((this.style & 0x4000) == 0) {
                return bl;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            n += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                n3 = 0;
                while (n3 < this.proportions.length) {
                    rectangle = this.proportions[n3];
                    rectangle.x = 100 - rectangle.x - rectangle.width;
                    ++n3;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (n2 > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return bl;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                n2 -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    n3 = 0;
                    while (n3 < this.proportions.length) {
                        rectangle = this.proportions[n3];
                        rectangle.y = 100 - rectangle.y - rectangle.height;
                        ++n3;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -n2) {
            if ((this.style & 0x80) == 0) {
                return bl;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            n2 += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                n3 = 0;
                while (n3 < this.proportions.length) {
                    rectangle = this.proportions[n3];
                    rectangle.y = 100 - rectangle.y - rectangle.height;
                    ++n3;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += n;
            this.bounds.width -= n;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += n;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += n2;
            this.bounds.height -= n2;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += n2;
        }
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        int n4 = 0;
        while (n4 < this.rectangles.length) {
            Rectangle rectangle2 = this.proportions[n4];
            rectangleArray[n4] = new Rectangle(rectangle2.x * this.bounds.width / 100 + this.bounds.x, rectangle2.y * this.bounds.height / 100 + this.bounds.y, rectangle2.width * this.bounds.width / 100, rectangle2.height * this.bounds.height / 100);
            ++n4;
        }
        this.rectangles = rectangleArray;
        return bl;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.clientCursor = cursor;
        if (cursor != null) {
            this.display.lockCursor = false;
            if (this.inEvent) {
                cursor.handle.set();
            }
            this.display.lockCursor = true;
        }
    }

    public void setRectangles(Rectangle[] rectangleArray) {
        this.checkWidget();
        if (rectangleArray == null) {
            this.error(4);
        }
        int n = rectangleArray.length;
        this.rectangles = new Rectangle[n];
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle = rectangleArray[n2];
            if (rectangle == null) {
                this.error(4);
            }
            this.rectangles[n2] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++n2;
        }
        this.proportions = this.computeProportions(rectangleArray);
    }

    public void setStippled(boolean bl) {
        this.checkWidget();
        this.stippled = bl;
    }
}

