/*
 *  Copyright (C) 2006-2011  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.test;

import static org.junit.Assert.*;
import java.io.File;
import org.junit.Test;
import org.dbgl.util.FileUtils;


public class FilesTest {

    @Test
    public void testGetCanonicalPath() {
        assertEquals("C:\\data\\bla.exe", FileUtils.getCanonicalPath("c:\\data\\bla.exe"));
        assertEquals("D:\\Projects\\Personal\\DBGL\\data\\bla.exe", FileUtils.getCanonicalPath("data\\bla.exe"));
        assertEquals("C:\\data2\\bla.exe", FileUtils.getCanonicalPath("c:\\data\\..\\data2\\bla.exe"));
        assertEquals("C:\\data\\bla.exe", FileUtils.getCanonicalPath("c:\\data\\..\\data\\bla.exe"));
    }

    @Test
    public void testIsExistingFile() {
        assertTrue(FileUtils.isExistingFile(new File("com\\test\\FilesTest.java")));
        assertFalse(FileUtils.isExistingFile(new File("com\\test")));
    }

    @Test
    public void testAreRelated() {
        File f1 = FileUtils.canonicalToDosroot(".");
        File f2 = FileUtils.canonicalToDosroot("ACTION\\KEEN4\\KEEN4.EXE");
        assertTrue(FileUtils.areRelated(f1, f2));
        assertFalse(FileUtils.areRelated(f2, f1));
    }

    @Test
    public void testGetDosRoot() {
        assertEquals("D:\\Projects\\Personal\\DBGL\\dosroot", FileUtils.getDosRoot());
    }

    @Test
    public void testMakeRelativeTo() {
        File f1 = FileUtils.canonicalToDosroot(".");
        File f2 = FileUtils.canonicalToDosroot("ACTION\\KEEN4\\KEEN4.EXE");
        assertEquals("ACTION\\KEEN4\\KEEN4.EXE", FileUtils.makeRelativeTo(f2, f1).getPath());
    }

    @Test
    public void testMakeRelativeToData() {
        fail("Not yet implemented");
    }

    @Test
    public void testMakeRelativeToDosroot() {
        fail("Not yet implemented");
    }

    @Test
    public void testMakeRelativeToDosbox() {
        fail("Not yet implemented");
    }

    @Test
    public void testCanonicalToData() {
        fail("Not yet implemented");
    }

    @Test
    public void testCanonicalToDosbox() {
        fail("Not yet implemented");
    }

    @Test
    public void testCanonicalToDosroot() {
        fail("Not yet implemented");
    }

    @Test
    public void testSanitizeToDosroot() {
        fail("Not yet implemented");
    }

    @Test
    public void testConstructCanonicalDBConfLocation() {
        fail("Not yet implemented");
    }

    @Test
    public void testConstructCanonicalDBExeLocation() {
        fail("Not yet implemented");
    }

    @Test
    public void testConstructCapturesDir() {
        fail("Not yet implemented");
    }

    @Test
    public void testConstructRelativeCapturesDir() {
        fail("Not yet implemented");
    }

    @Test
    public void testConstructCanonicalTemplateFileLocation() {
        fail("Not yet implemented");
    }

    @Test
    public void testConstructUniqueConfigFileString() {
        fail("Not yet implemented");
    }

    @Test
    public void testDoRunDosbox() {
        fail("Not yet implemented");
    }

    @Test
    public void testDoCreateDosboxConf() {
        fail("Not yet implemented");
    }

    @Test
    public void testDoRunProfileProfileListOfDosboxVersionBoolean() {
        fail("Not yet implemented");
    }

    @Test
    public void testDoRunProfileProfileDosboxVersionBoolean() {
        fail("Not yet implemented");
    }

    @Test
    public void testCreateDir() {
        fail("Not yet implemented");
    }

    @Test
    public void testCopyFiles() {
        fail("Not yet implemented");
    }

    @Test
    public void testRemoveFile() {
        fail("Not yet implemented");
    }

    @Test
    public void testRemoveFilesInDirAndDir() {
        fail("Not yet implemented");
    }

    @Test
    public void testIsReadableFile() {
        fail("Not yet implemented");
    }

    @Test
    public void testCreateDosrootIfNecessary() {
        fail("Not yet implemented");
    }

    @Test
    public void testIsExecutable() {
        fail("Not yet implemented");
    }

    @Test
    public void testIsArchive() {
        fail("Not yet implemented");
    }

    @Test
    public void testIsPhysFS() {
        fail("Not yet implemented");
    }

    @Test
    public void testContainsPhysFS() {
        fail("Not yet implemented");
    }

    @Test
    public void testIsBooterImage() {
        fail("Not yet implemented");
    }

    @Test
    public void testIsConfFile() {
        fail("Not yet implemented");
    }

    @Test
    public void testIsIsoFile() {
        fail("Not yet implemented");
    }

    @Test
    public void testContainsIso() {
        fail("Not yet implemented");
    }

    @Test
    public void testGetCanMainFile() {
        fail("Not yet implemented");
    }

    @Test
    public void testGetExecutablesInZipOrIso() {
        fail("Not yet implemented");
    }

    @Test
    public void testZipEntry() {
        fail("Not yet implemented");
    }

    @Test
    public void testGetUrlFromFile() {
        fail("Not yet implemented");
    }

}
