/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.EventRecord;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static final String DRAG_STARTED = "org.eclipse.swt.internal.dragStarted";
    static Callback DragSendDataProc;
    static /* synthetic */ Class class$0;

    static {
        int n;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((n = (DragSendDataProc = new Callback(clazz, "DragSendDataProc", 4)).getAddress()) == 0) {
            SWT.error(3);
        }
    }

    public DragSource(Control control, int n) {
        super(control, DragSource.checkStyle(n));
        this.control = control;
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DragSource.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (object instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)object;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    static int DragSendDataProc(int n, int n2, int n3, int n4) {
        DragSource dragSource = DragSource.FindDragSource(n2, n4);
        if (dragSource == null) {
            return -1854;
        }
        return dragSource.dragSendDataProc(n, n2, n3, n4);
    }

    static DragSource FindDragSource(int n, int n2) {
        if (n == 0) {
            return null;
        }
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return null;
        }
        return (DragSource)widget.getData("DragSource");
    }

    public void addDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dragSourceListener);
        dNDListener.dndWidget = this;
        this.addListener(2008, dNDListener);
        this.addListener(2001, dNDListener);
        this.addListener(2000, dNDListener);
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void drag(Event event) {
        Object object;
        int[] nArray;
        block14: {
            DNDEvent dNDEvent = new DNDEvent();
            dNDEvent.widget = this;
            dNDEvent.x = event.x;
            dNDEvent.y = event.y;
            dNDEvent.time = event.time;
            dNDEvent.doit = true;
            this.notifyListeners(2008, dNDEvent);
            if (!dNDEvent.doit || this.transferAgents == null || this.transferAgents.length == 0) {
                return;
            }
            nArray = new int[1];
            if (OS.NewDrag(nArray) != 0) {
                dNDEvent = new DNDEvent();
                dNDEvent.widget = this;
                dNDEvent.time = (int)System.currentTimeMillis();
                dNDEvent.doit = false;
                dNDEvent.detail = 0;
                this.notifyListeners(2000, dNDEvent);
                return;
            }
            Point point = new Point();
            OS.GetGlobalMouse(point);
            int n = 0;
            while (n < this.transferAgents.length) {
                object = this.transferAgents[n];
                if (object != null) {
                    int[] nArray2 = ((Transfer)object).getTypeIds();
                    int n2 = 0;
                    while (n2 < nArray2.length) {
                        OS.AddDragItemFlavor(nArray[0], 1, nArray2[n2], null, 0, 0);
                        ++n2;
                    }
                }
                ++n;
            }
            OS.SetDragSendProc(nArray[0], DragSendDataProc.getAddress(), this.control.handle);
            n = 0;
            object = null;
            try {
                Object object2;
                n = OS.NewRgn();
                OS.SetRectRgn(n, point.h, point.v, (short)(point.h + 20), (short)(point.v + 20));
                int n3 = this.opToOsOp(this.getStyle());
                OS.SetDragAllowableActions(nArray[0], n3, true);
                OS.SetDragAllowableActions(nArray[0], n3, false);
                Object object3 = dNDEvent.image;
                if (object3 != null) {
                    object2 = new CGPoint();
                    ((CGPoint)object2).x = 0.0f;
                    ((CGPoint)object2).y = 0.0f;
                    if (OS.CGImageGetAlphaInfo(((Image)object3).handle) == 6) {
                        ImageData imageData = ((Image)object3).getImageData();
                        imageData.alpha = 255;
                        object3 = object = new Image(((Resource)object3).getDevice(), imageData);
                    }
                    OS.SetDragImageWithCGImage(nArray[0], ((Image)object3).handle, (CGPoint)object2, 0);
                }
                object2 = new EventRecord();
                ((EventRecord)object2).message = 5;
                ((EventRecord)object2).modifiers = (short)OS.GetCurrentEventKeyModifiers();
                ((EventRecord)object2).what = (short)15;
                ((EventRecord)object2).where_h = point.h;
                ((EventRecord)object2).where_v = point.v;
                this.control.setData(DRAG_STARTED, new Object());
                int n4 = OS.TrackDrag(nArray[0], (EventRecord)object2, n);
                this.control.setData(DRAG_STARTED, null);
                int n5 = 0;
                if (n4 == 0) {
                    int[] nArray3 = new int[1];
                    OS.GetDragDropAction(nArray[0], nArray3);
                    n5 = this.osOpToOp(nArray3[0]);
                }
                dNDEvent = new DNDEvent();
                dNDEvent.widget = this;
                dNDEvent.time = (int)System.currentTimeMillis();
                dNDEvent.doit = n4 == 0;
                dNDEvent.detail = n5;
                this.notifyListeners(2000, dNDEvent);
                Object var13_18 = null;
                if (n == 0) break block14;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                if (n != 0) {
                    OS.DisposeRgn(n);
                }
                if (object != null) {
                    ((Resource)object).dispose();
                }
                throw throwable;
            }
            OS.DisposeRgn(n);
        }
        if (object != null) {
            ((Resource)object).dispose();
        }
        OS.DisposeDrag(nArray[0]);
    }

    int dragSendDataProc(int n, int n2, int n3, int n4) {
        this.control.setData(DRAG_STARTED, null);
        if (n == 0) {
            return -1852;
        }
        TransferData transferData = new TransferData();
        transferData.type = n;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = (int)System.currentTimeMillis();
        dNDEvent.dataType = transferData;
        this.notifyListeners(2001, dNDEvent);
        if (!dNDEvent.doit) {
            return -1857;
        }
        Transfer transfer = null;
        int n5 = 0;
        while (n5 < this.transferAgents.length) {
            Transfer transfer2 = this.transferAgents[n5];
            if (transfer2 != null && transfer2.isSupportedType(transferData)) {
                transfer = transfer2;
                break;
            }
            ++n5;
        }
        if (transfer == null) {
            return -1852;
        }
        transfer.javaToNative(dNDEvent.data, transferData);
        if (transferData.result != 0) {
            return transferData.result;
        }
        byte[] byArray = transferData.data[0];
        if (byArray == null) {
            return -1854;
        }
        int n6 = OS.SetDragItemFlavorData(n4, n3, n, byArray, byArray.length, 0);
        if (n6 == 0 && transfer instanceof FileTransfer) {
            int n7 = 1;
            while (n7 < transferData.data.length) {
                byArray = transferData.data[n7];
                if (byArray == null) {
                    return -1854;
                }
                n6 = OS.AddDragItemFlavor(n4, 1 + n7, n, byArray, byArray.length, 0);
                if (n6 != 0) break;
                ++n7;
            }
        }
        return n6;
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listenerArray = this.getListeners(2008);
        int n = listenerArray.length;
        DragSourceListener[] dragSourceListenerArray = new DragSourceListener[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Listener listener = listenerArray[n3];
            if (listener instanceof DNDListener) {
                dragSourceListenerArray[n2] = (DragSourceListener)((DNDListener)listener).getEventListener();
                ++n2;
            }
            ++n3;
        }
        if (n2 == n) {
            return dragSourceListenerArray;
        }
        DragSourceListener[] dragSourceListenerArray2 = new DragSourceListener[n2];
        System.arraycopy(dragSourceListenerArray, 0, dragSourceListenerArray2, 0, n2);
        return dragSourceListenerArray2;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
    }

    int opToOsOp(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 2;
        }
        if ((n & 2) != 0) {
            n2 |= 0x10;
        }
        if ((n & 8) != 0) {
            n2 |= 0x20;
        }
        return n2;
    }

    int osOpToOp(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 2) != 0) {
            n2 |= 4;
        }
        if ((n & 0x20) != 0) {
            n2 |= 8;
        }
        if ((n & 0x10) != 0) {
            n2 |= 2;
        }
        if (n == -1) {
            n2 = 7;
        }
        return n2;
    }

    public void removeDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        this.removeListener(2008, dragSourceListener);
        this.removeListener(2001, dragSourceListener);
        this.removeListener(2000, dragSourceListener);
    }

    public void setDragSourceEffect(DragSourceEffect dragSourceEffect) {
        this.dragEffect = dragSourceEffect;
    }

    public void setTransfer(Transfer[] transferArray) {
        this.transferAgents = transferArray;
    }
}

