/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    int modelHandle;
    int checkRenderer;
    int itemCount;
    int columnCount;
    int lastIndexOf;
    int sortDirection;
    int ignoreCell;
    TableItem[] items;
    TableColumn[] columns;
    TableItem currentItem;
    TableColumn sortColumn;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    int drawState;
    int drawFlags;
    GdkColor drawForeground;
    boolean ownerDraw;
    boolean ignoreSize;
    boolean ignoreAccessibility;
    static final int CHECKED_COLUMN = 0;
    static final int GRAYED_COLUMN = 1;
    static final int FOREGROUND_COLUMN = 2;
    static final int BACKGROUND_COLUMN = 3;
    static final int FONT_COLUMN = 4;
    static final int FIRST_COLUMN = 5;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_TYPES = 5;

    public Table(Composite composite, int n) {
        super(composite, Table.checkStyle(n));
    }

    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        if (!this.ownerDraw) {
            switch (n) {
                case 40: 
                case 41: 
                case 42: {
                    this.ownerDraw = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TableItem _getItem(int n) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[n];
        }
        if (this.items[n] != null) {
            return this.items[n];
        }
        this.items[n] = new TableItem(this, 0, n, false);
        return this.items[n];
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Table.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    int cellDataProc(int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        if (n2 == this.ignoreCell) {
            return 0;
        }
        int n6 = OS.gtk_tree_model_get_path(n3, n4);
        int[] nArray = new int[1];
        OS.memmove(nArray, OS.gtk_tree_path_get_indices(n6), 4);
        TableItem tableItem = this._getItem(nArray[0]);
        OS.gtk_tree_path_free(n6);
        if (tableItem != null) {
            OS.g_object_set_qdata(n2, Display.SWT_OBJECT_INDEX2, tableItem.handle);
        }
        if (!(bl = OS.GTK_IS_CELL_RENDERER_PIXBUF(n2)) && !OS.GTK_IS_CELL_RENDERER_TEXT(n2)) {
            return 0;
        }
        int n7 = -1;
        boolean bl2 = false;
        if (this.columnCount == 0) {
            n7 = 5;
            bl2 = this.firstCustomDraw;
        } else {
            TableColumn tableColumn = (TableColumn)this.display.getWidget(n);
            if (tableColumn != null) {
                n7 = tableColumn.modelIndex;
                bl2 = tableColumn.customDraw;
            }
        }
        if (n7 == -1) {
            return 0;
        }
        boolean bl3 = false;
        if ((this.style & 0x10000000) != 0 && !tableItem.cached) {
            this.lastIndexOf = nArray[0];
            bl3 = this.checkData(tableItem);
        }
        int[] nArray2 = new int[1];
        if (bl3) {
            nArray2[0] = 0;
            if (bl) {
                OS.gtk_tree_model_get(n3, n4, n7 + 0, nArray2, -1);
                OS.g_object_set(n2, OS.pixbuf, nArray2[0], 0);
                if (nArray2[0] != 0) {
                    OS.g_object_unref(nArray2[0]);
                }
            } else {
                OS.gtk_tree_model_get(n3, n4, n7 + 1, nArray2, -1);
                if (nArray2[0] != 0) {
                    OS.g_object_set(n2, OS.text, nArray2[0], 0);
                    OS.g_free(nArray2[0]);
                }
            }
        }
        if (bl2) {
            if (!this.ownerDraw) {
                nArray2[0] = 0;
                OS.gtk_tree_model_get(n3, n4, n7 + 3, nArray2, -1);
                if (nArray2[0] != 0) {
                    OS.g_object_set(n2, OS.cell_background_gdk, nArray2[0], 0);
                    OS.gdk_color_free(nArray2[0]);
                }
            }
            if (!bl) {
                nArray2[0] = 0;
                OS.gtk_tree_model_get(n3, n4, n7 + 2, nArray2, -1);
                if (nArray2[0] != 0) {
                    OS.g_object_set(n2, OS.foreground_gdk, nArray2[0], 0);
                    OS.gdk_color_free(nArray2[0]);
                }
                nArray2[0] = 0;
                OS.gtk_tree_model_get(n3, n4, n7 + 4, nArray2, -1);
                if (nArray2[0] != 0) {
                    OS.g_object_set(n2, OS.font_desc, nArray2[0], 0);
                    OS.pango_font_description_free(nArray2[0]);
                }
            }
        }
        if (bl3) {
            this.ignoreCell = n2;
            this.setScrollWidth(n, tableItem);
            this.ignoreCell = 0;
        }
        return 0;
    }

    boolean checkData(TableItem tableItem) {
        if (tableItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = this.indexOf(tableItem);
            int n = 17;
            int n2 = OS.g_signal_lookup(OS.row_changed, OS.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, n, n2, 0, 0, 0, this.handle);
            this.currentItem = tableItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, n, n2, 0, 0, 0, this.handle);
            if (tableItem.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int calculateWidth(int n, int n2) {
        OS.gtk_tree_view_column_cell_set_cell_data(n, this.modelHandle, n2, false, false);
        int n3 = 0;
        int[] nArray = new int[1];
        OS.gtk_widget_style_get(this.handle, OS.focus_line_width, nArray, 0);
        n3 += 2 * nArray[0];
        int n4 = 0;
        n4 = OS.GTK_VERSION >= OS.VERSION(2, 12, 0) ? OS.gtk_cell_layout_get_cells(n) : OS.gtk_tree_view_column_get_cell_renderers(n);
        if (n4 == 0) {
            return 0;
        }
        int n5 = n4;
        while (n5 != 0) {
            int n6 = OS.g_list_data(n5);
            if (n6 != 0) {
                OS.gtk_cell_renderer_get_size(n6, this.handle, null, null, null, nArray, null);
                n3 += nArray[0];
            }
            n5 = OS.g_list_next(n5);
        }
        OS.g_list_free(n4);
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0) && OS.gtk_tree_view_get_rules_hint(this.handle)) {
            OS.gtk_widget_style_get(this.handle, OS.grid_line_width, nArray, 0);
            n3 += 2 * nArray[0];
        }
        return n3;
    }

    public void clear(int n) {
        TableItem tableItem;
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        if ((tableItem = this.items[n]) != null) {
            tableItem.clear();
        }
    }

    public void clear(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        if (n == 0 && n2 == this.itemCount - 1) {
            this.clearAll();
        } else {
            int n3 = n;
            while (n3 <= n2) {
                TableItem tableItem = this.items[n3];
                if (tableItem != null) {
                    tableItem.clear();
                }
                ++n3;
            }
        }
    }

    public void clear(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0 || nArray[n] >= this.itemCount) {
                this.error(6);
            }
            ++n;
        }
        n = 0;
        while (n < nArray.length) {
            TableItem tableItem = this.items[nArray[n]];
            if (tableItem != null) {
                tableItem.clear();
            }
            ++n;
        }
    }

    public void clearAll() {
        this.checkWidget();
        int n = 0;
        while (n < this.itemCount) {
            TableItem tableItem = this.items[n];
            if (tableItem != null) {
                tableItem.clear();
            }
            ++n;
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if (point.x == 0 && n == -1) {
            point.x = 64;
        }
        if (point.y == 0 && n2 == -1) {
            point.y = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        point.x = rectangle.width;
        point.y = rectangle.height;
        return point;
    }

    void createColumn(TableColumn tableColumn, int n) {
        Object object;
        int n2;
        int n3 = 5;
        if (this.columnCount != 0) {
            int n4;
            n2 = OS.gtk_tree_model_get_n_columns(this.modelHandle);
            object = new boolean[n2];
            int n5 = 0;
            while (n5 < this.columnCount) {
                int n6 = this.columns[n5].modelIndex;
                n4 = 0;
                while (n4 < 5) {
                    object[n6 + n4] = true;
                    ++n4;
                }
                ++n5;
            }
            while (n3 < n2) {
                if (!object[n3]) break;
                ++n3;
            }
            if (n3 == n2) {
                n5 = this.modelHandle;
                int[] nArray = this.getColumnTypes(this.columnCount + 4);
                n4 = OS.gtk_list_store_newv(nArray.length, nArray);
                if (n4 == 0) {
                    this.error(2);
                }
                int[] nArray2 = new int[1];
                int n7 = 0;
                while (n7 < this.itemCount) {
                    int n8 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                    if (n8 == 0) {
                        this.error(2);
                    }
                    OS.gtk_list_store_append(n4, n8);
                    TableItem tableItem = this.items[n7];
                    if (tableItem != null) {
                        int n9 = tableItem.handle;
                        int n10 = 0;
                        while (n10 < n2) {
                            OS.gtk_tree_model_get(n5, n9, n10, nArray2, -1);
                            OS.gtk_list_store_set(n4, n8, n10, nArray2[0], -1);
                            if (nArray[n10] == OS.G_TYPE_STRING()) {
                                OS.g_free(nArray2[0]);
                            } else if (nArray2[0] != 0) {
                                if (nArray[n10] == OS.GDK_TYPE_COLOR()) {
                                    OS.gdk_color_free(nArray2[0]);
                                } else if (nArray[n10] == OS.GDK_TYPE_PIXBUF()) {
                                    OS.g_object_unref(nArray2[0]);
                                } else if (nArray[n10] == OS.PANGO_TYPE_FONT_DESCRIPTION()) {
                                    OS.pango_font_description_free(nArray2[0]);
                                }
                            }
                            ++n10;
                        }
                        OS.gtk_list_store_remove(n5, n9);
                        OS.g_free(n9);
                        tableItem.handle = n8;
                    } else {
                        OS.g_free(n8);
                    }
                    ++n7;
                }
                OS.gtk_tree_view_set_model(this.handle, n4);
                OS.g_object_unref(n5);
                this.modelHandle = n4;
            }
        }
        if ((n2 = OS.gtk_tree_view_column_new()) == 0) {
            this.error(2);
        }
        if (n == 0 && this.columnCount > 0) {
            object = this.columns[0];
            this.createRenderers(object.handle, object.modelIndex, false, object.style);
        }
        this.createRenderers(n2, n3, n == 0, tableColumn == null ? 0 : tableColumn.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            OS.gtk_tree_view_column_set_sizing(n2, 0);
        } else {
            OS.gtk_tree_view_column_set_sizing(n2, 2);
            if (this.columnCount != 0) {
                OS.gtk_tree_view_column_set_visible(n2, false);
            }
        }
        OS.gtk_tree_view_column_set_resizable(n2, true);
        OS.gtk_tree_view_column_set_clickable(n2, true);
        OS.gtk_tree_view_column_set_min_width(n2, 0);
        OS.gtk_tree_view_insert_column(this.handle, n2, n);
        if (tableColumn != null) {
            tableColumn.handle = n2;
            tableColumn.modelIndex = n3;
        }
        if (!this.searchEnabled()) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        } else {
            int n11 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n11 + 1);
        }
    }

    void createHandle(int n) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = OS.gtk_scrolled_window_new(0, 0);
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        int[] nArray = this.getColumnTypes(1);
        this.modelHandle = OS.gtk_list_store_newv(nArray.length, nArray);
        if (this.modelHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        OS.gtk_container_add(this.scrolledHandle, this.handle);
        int n2 = (this.style & 2) != 0 ? 3 : 2;
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.gtk_tree_selection_set_mode(n3, n2);
        OS.gtk_tree_view_set_headers_visible(this.handle, false);
        int n4 = (this.style & 0x100) != 0 ? 1 : 2;
        int n5 = (this.style & 0x200) != 0 ? 1 : 2;
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, n4, n5);
        if ((this.style & 0x800) != 0) {
            OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.style & 0x10000000) != 0) {
            OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0);
        }
        if (!this.searchEnabled()) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        }
    }

    void createItem(TableColumn tableColumn, int n) {
        int n2;
        int n3;
        if (n < 0 || n > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == 0) {
            tableColumn.handle = OS.gtk_tree_view_get_column(this.handle, 0);
            OS.gtk_tree_view_column_set_sizing(tableColumn.handle, 2);
            OS.gtk_tree_view_column_set_visible(tableColumn.handle, false);
            tableColumn.modelIndex = 5;
            this.createRenderers(tableColumn.handle, tableColumn.modelIndex, true, tableColumn.style);
            tableColumn.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(tableColumn, n);
        }
        int n4 = OS.gtk_hbox_new(false, 3);
        if (n4 == 0) {
            this.error(2);
        }
        if ((n3 = OS.gtk_label_new_with_mnemonic(null)) == 0) {
            this.error(2);
        }
        if ((n2 = OS.gtk_image_new()) == 0) {
            this.error(2);
        }
        OS.gtk_container_add(n4, n2);
        OS.gtk_container_add(n4, n3);
        OS.gtk_widget_show(n4);
        OS.gtk_widget_show(n3);
        tableColumn.labelHandle = n3;
        tableColumn.imageHandle = n2;
        OS.gtk_tree_view_column_set_widget(tableColumn.handle, n4);
        int n5 = OS.gtk_widget_get_parent(n4);
        while (n5 != this.handle) {
            if (OS.GTK_IS_BUTTON(n5)) {
                tableColumn.buttonHandle = n5;
                break;
            }
            n5 = OS.gtk_widget_get_parent(n5);
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] tableColumnArray = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columns.length);
            this.columns = tableColumnArray;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = tableColumn;
        if ((this.state & 0x4000) != 0) {
            tableColumn.setFontDescription(this.getFontDescription());
        }
        if (this.columnCount >= 1) {
            int n6 = 0;
            while (n6 < this.itemCount) {
                Font[] fontArray;
                TableItem tableItem = this.items[n6];
                if (tableItem != null && (fontArray = tableItem.cellFont) != null) {
                    Font[] fontArray2 = new Font[this.columnCount];
                    System.arraycopy(fontArray, 0, fontArray2, 0, n);
                    System.arraycopy(fontArray, n, fontArray2, n + 1, this.columnCount - n - 1);
                    tableItem.cellFont = fontArray2;
                }
                ++n6;
            }
        }
        if (!this.isVisible()) {
            OS.gtk_container_resize_children(this.handle);
        }
    }

    void createItem(TableItem tableItem, int n) {
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int n2 = this.drawCount <= 0 ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] tableItemArray = new TableItem[n2];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
            this.items = tableItemArray;
        }
        tableItem.handle = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (tableItem.handle == 0) {
            this.error(2);
        }
        if (n == this.itemCount) {
            OS.gtk_list_store_append(this.modelHandle, tableItem.handle);
        } else {
            OS.gtk_list_store_insert(this.modelHandle, tableItem.handle, n);
        }
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = tableItem;
    }

    void createRenderers(int n, int n2, boolean bl, int n3) {
        int n4;
        int n5;
        OS.gtk_tree_view_column_clear(n);
        if ((this.style & 0x20) != 0 && bl) {
            OS.gtk_tree_view_column_pack_start(n, this.checkRenderer, false);
            OS.gtk_tree_view_column_add_attribute(n, this.checkRenderer, OS.active, 0);
            OS.gtk_tree_view_column_add_attribute(n, this.checkRenderer, OS.inconsistent, 1);
            if (!this.ownerDraw) {
                OS.gtk_tree_view_column_add_attribute(n, this.checkRenderer, OS.cell_background_gdk, 3);
            }
            if (this.ownerDraw) {
                OS.gtk_tree_view_column_set_cell_data_func(n, this.checkRenderer, this.display.cellDataProc, this.handle, 0);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, n);
            }
        }
        int n6 = n5 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0) : OS.gtk_cell_renderer_pixbuf_new();
        if (n5 == 0) {
            this.error(2);
        }
        int n7 = n4 = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0) : OS.gtk_cell_renderer_text_new();
        if (n4 == 0) {
            this.error(2);
        }
        if (this.ownerDraw) {
            OS.g_object_set_qdata(n5, Display.SWT_OBJECT_INDEX1, n);
            OS.g_object_set_qdata(n4, Display.SWT_OBJECT_INDEX1, n);
        }
        if ((this.style & 0x20) != 0 && bl) {
            OS.g_object_set(n5, OS.mode, 1, 0);
        }
        if ((n3 & 0x20000) != 0) {
            OS.g_object_set(n4, OS.xalign, 1.0f, 0);
            OS.gtk_tree_view_column_pack_end(n, n4, true);
            OS.gtk_tree_view_column_pack_end(n, n5, false);
            OS.gtk_tree_view_column_set_alignment(n, 1.0f);
        } else if ((n3 & 0x1000000) != 0) {
            OS.g_object_set(n4, OS.xalign, 0.5f, 0);
            OS.gtk_tree_view_column_pack_start(n, n5, false);
            OS.gtk_tree_view_column_pack_end(n, n4, true);
            OS.gtk_tree_view_column_set_alignment(n, 0.5f);
        } else {
            OS.gtk_tree_view_column_pack_start(n, n5, false);
            OS.gtk_tree_view_column_pack_start(n, n4, true);
            OS.gtk_tree_view_column_set_alignment(n, 0.0f);
        }
        OS.gtk_tree_view_column_add_attribute(n, n5, OS.pixbuf, n2 + 0);
        if (!this.ownerDraw) {
            OS.gtk_tree_view_column_add_attribute(n, n5, OS.cell_background_gdk, 3);
            OS.gtk_tree_view_column_add_attribute(n, n4, OS.cell_background_gdk, 3);
        }
        OS.gtk_tree_view_column_add_attribute(n, n4, OS.text, n2 + 1);
        OS.gtk_tree_view_column_add_attribute(n, n4, OS.foreground_gdk, 2);
        OS.gtk_tree_view_column_add_attribute(n, n4, OS.font_desc, 4);
        boolean bl2 = this.firstCustomDraw;
        if (this.columnCount != 0) {
            int n8 = 0;
            while (n8 < this.columnCount) {
                if (this.columns[n8].handle == n) {
                    bl2 = this.columns[n8].customDraw;
                    break;
                }
                ++n8;
            }
        }
        if ((this.style & 0x10000000) != 0 || bl2 || this.ownerDraw) {
            OS.gtk_tree_view_column_set_cell_data_func(n, n4, this.display.cellDataProc, this.handle, 0);
            OS.gtk_tree_view_column_set_cell_data_func(n, n5, this.display.cellDataProc, this.handle, 0);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
        this.columnCount = 0;
        this.itemCount = 0;
    }

    GdkColor defaultBackground() {
        return this.display.COLOR_LIST_BACKGROUND;
    }

    GdkColor defaultForeground() {
        return this.display.COLOR_LIST_FOREGROUND;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(OS.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
        }
        this.display.removeWidget(this.modelHandle);
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n2, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_unselect_iter(n2, this._getItem((int)n).handle);
        OS.g_signal_handlers_unblock_matched(n2, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
        int n4 = n;
        while (n4 <= n2) {
            if (n4 >= 0 && n4 < this.itemCount) {
                OS.gtk_tree_selection_unselect_iter(n3, this._getItem((int)n4).handle);
            }
            ++n4;
        }
        OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        boolean bl = this.showFirstColumn();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            if (n3 >= 0 && n3 < this.itemCount) {
                OS.gtk_tree_selection_unselect_iter(n, this._getItem((int)n3).handle);
            }
            ++n2;
        }
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_unselect_all(n);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TableColumn tableColumn) {
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == tableColumn) break;
            ++n;
        }
        if (n == this.columnCount) {
            return;
        }
        int n2 = tableColumn.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = tableColumn.customDraw;
        }
        System.arraycopy(this.columns, n + 1, this.columns, n, --this.columnCount - n);
        this.columns[this.columnCount] = null;
        OS.gtk_tree_view_remove_column(this.handle, n2);
        if (this.columnCount == 0) {
            int n3 = this.modelHandle;
            int[] nArray = this.getColumnTypes(1);
            int n4 = OS.gtk_list_store_newv(nArray.length, nArray);
            if (n4 == 0) {
                this.error(2);
            }
            int[] nArray2 = new int[1];
            int n5 = 0;
            while (n5 < this.itemCount) {
                int n6 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                if (n6 == 0) {
                    this.error(2);
                }
                OS.gtk_list_store_append(n4, n6);
                TableItem tableItem = this.items[n5];
                if (tableItem != null) {
                    int n7 = tableItem.handle;
                    int n8 = 0;
                    while (n8 < 5) {
                        OS.gtk_tree_model_get(n3, n7, n8, nArray2, -1);
                        OS.gtk_list_store_set(n4, n6, n8, nArray2[0], -1);
                        if (nArray2[0] != 0) {
                            if (n8 == 2 || n8 == 3) {
                                OS.gdk_color_free(nArray2[0]);
                            } else if (n8 == 4) {
                                OS.pango_font_description_free(nArray2[0]);
                            }
                        }
                        ++n8;
                    }
                    OS.gtk_tree_model_get(n3, n7, tableColumn.modelIndex + 0, nArray2, -1);
                    OS.gtk_list_store_set(n4, n6, 5, nArray2[0], -1);
                    if (nArray2[0] != 0) {
                        OS.g_object_unref(nArray2[0]);
                    }
                    OS.gtk_tree_model_get(n3, n7, tableColumn.modelIndex + 1, nArray2, -1);
                    OS.gtk_list_store_set(n4, n6, 6, nArray2[0], -1);
                    OS.g_free(nArray2[0]);
                    OS.gtk_tree_model_get(n3, n7, tableColumn.modelIndex + 2, nArray2, -1);
                    OS.gtk_list_store_set(n4, n6, 7, nArray2[0], -1);
                    if (nArray2[0] != 0) {
                        OS.gdk_color_free(nArray2[0]);
                    }
                    OS.gtk_tree_model_get(n3, n7, tableColumn.modelIndex + 3, nArray2, -1);
                    OS.gtk_list_store_set(n4, n6, 8, nArray2[0], -1);
                    if (nArray2[0] != 0) {
                        OS.gdk_color_free(nArray2[0]);
                    }
                    OS.gtk_tree_model_get(n3, n7, tableColumn.modelIndex + 4, nArray2, -1);
                    OS.gtk_list_store_set(n4, n6, 9, nArray2[0], -1);
                    if (nArray2[0] != 0) {
                        OS.pango_font_description_free(nArray2[0]);
                    }
                    OS.gtk_list_store_remove(n3, n7);
                    OS.g_free(n7);
                    tableItem.handle = n6;
                } else {
                    OS.g_free(n6);
                }
                ++n5;
            }
            OS.gtk_tree_view_set_model(this.handle, n4);
            OS.g_object_unref(n3);
            this.modelHandle = n4;
            this.createColumn(null, 0);
        } else {
            int n9 = 0;
            while (n9 < this.itemCount) {
                TableItem tableItem = this.items[n9];
                if (tableItem != null) {
                    int n10 = tableItem.handle;
                    int n11 = tableColumn.modelIndex;
                    OS.gtk_list_store_set(this.modelHandle, n10, n11 + 0, 0, -1);
                    OS.gtk_list_store_set(this.modelHandle, n10, n11 + 1, 0, -1);
                    OS.gtk_list_store_set(this.modelHandle, n10, n11 + 2, 0, -1);
                    OS.gtk_list_store_set(this.modelHandle, n10, n11 + 3, 0, -1);
                    OS.gtk_list_store_set(this.modelHandle, n10, n11 + 4, 0, -1);
                    Font[] fontArray = tableItem.cellFont;
                    if (fontArray != null) {
                        if (this.columnCount == 0) {
                            tableItem.cellFont = null;
                        } else {
                            Font[] fontArray2 = new Font[this.columnCount];
                            System.arraycopy(fontArray, 0, fontArray2, 0, n);
                            System.arraycopy(fontArray, n + 1, fontArray2, n, this.columnCount - n);
                            tableItem.cellFont = fontArray2;
                        }
                    }
                }
                ++n9;
            }
            if (n == 0) {
                TableColumn tableColumn2 = this.columns[0];
                this.createRenderers(tableColumn2.handle, tableColumn2.modelIndex, true, tableColumn2.style);
            }
        }
        if (!this.searchEnabled()) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        } else {
            int n12 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n12 + 1);
        }
    }

    void destroyItem(TableItem tableItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == tableItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n2, 16, 0, 0, 0, 0, 6);
        OS.gtk_list_store_remove(this.modelHandle, tableItem.handle);
        OS.g_signal_handlers_unblock_matched(n2, 16, 0, 0, 0, 0, 6);
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        if (this.itemCount == 0) {
            this.resetCustomDraw();
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        boolean bl3;
        boolean bl4 = false;
        if (bl) {
            int[] nArray = new int[1];
            if (OS.gtk_tree_view_get_path_at_pos(this.handle, n, n2, nArray, null, null, null)) {
                if (nArray[0] != 0) {
                    int n3 = OS.gtk_tree_view_get_selection(this.handle);
                    if (OS.gtk_tree_selection_path_is_selected(n3, nArray[0])) {
                        bl4 = true;
                    }
                    OS.gtk_tree_path_free(nArray[0]);
                }
            } else {
                return false;
            }
        }
        if ((bl3 = super.dragDetect(n, n2, bl, false, blArray)) && bl4 && blArray != null) {
            blArray[0] = true;
        }
        return bl3;
    }

    int eventWindow() {
        return this.paintWindow();
    }

    boolean fixAccessibility() {
        return OS.GTK_VERSION >= OS.VERSION(2, 12, 0);
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        int n = 0;
        while (n < this.columnCount) {
            TableColumn tableColumn = this.columns[n];
            if (tableColumn.toolTipText != null) {
                tableColumn.setToolTipText(shell2, null);
                tableColumn.setToolTipText(shell, tableColumn.toolTipText);
            }
            ++n;
        }
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        OS.gtk_widget_realize(this.handle);
        int n = OS.GTK_WIDGET_WINDOW(this.fixedHandle);
        int n2 = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(n2, nArray, nArray2);
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.gdk_window_get_origin(n, nArray3, nArray4);
        int n3 = this.clientHandle();
        int n4 = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(n3);
        int n5 = (this.state & 0x400) != 0 ? 0 : OS.GTK_WIDGET_HEIGHT(n3);
        return new Rectangle(nArray3[0] - nArray[0], nArray4[0] - nArray2[0], n4, n5);
    }

    int getClientWidth() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.handle);
        OS.gdk_drawable_get_size(OS.gtk_tree_view_get_bin_window(this.handle), nArray, nArray2);
        return nArray[0];
    }

    public TableColumn getColumn(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    int[] getColumnTypes(int n) {
        int[] nArray = new int[5 + n * 5];
        nArray[0] = OS.G_TYPE_BOOLEAN();
        nArray[1] = OS.G_TYPE_BOOLEAN();
        nArray[2] = OS.GDK_TYPE_COLOR();
        nArray[3] = OS.GDK_TYPE_COLOR();
        nArray[4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        int n2 = 5;
        while (n2 < nArray.length) {
            nArray[n2 + 0] = OS.GDK_TYPE_PIXBUF();
            nArray[n2 + 1] = OS.G_TYPE_STRING();
            nArray[n2 + 2] = OS.GDK_TYPE_COLOR();
            nArray[n2 + 3] = OS.GDK_TYPE_COLOR();
            nArray[n2 + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
            n2 += 5;
        }
        return nArray;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        int n = OS.gtk_tree_view_get_columns(this.handle);
        if (n == 0) {
            return new int[0];
        }
        int n2 = 0;
        int n3 = OS.g_list_length(n);
        int[] nArray = new int[n3];
        int n4 = n;
        while (n4 != 0) {
            int n5 = OS.g_list_data(n4);
            if (n5 != 0) {
                int n6 = 0;
                while (n6 < this.columnCount) {
                    if (this.columns[n6].handle == n5) {
                        nArray[n2++] = n6;
                        break;
                    }
                    ++n6;
                }
            }
            n4 = OS.g_list_next(n4);
        }
        OS.g_list_free(n);
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    TableItem getFocusItem() {
        int[] nArray = new int[1];
        OS.gtk_tree_view_get_cursor(this.handle, nArray, null);
        if (nArray[0] == 0) {
            return null;
        }
        TableItem tableItem = null;
        int n = OS.gtk_tree_path_get_indices(nArray[0]);
        if (n != 0) {
            int[] nArray2 = new int[]{-1};
            OS.memmove(nArray2, n, 4);
            tableItem = this._getItem(nArray2[0]);
        }
        OS.gtk_tree_path_free(nArray[0]);
        return tableItem;
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!OS.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        if (this.columnCount > 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            int n = 0;
            int n2 = 0;
            while (n2 < this.columnCount) {
                int n3 = this.columns[n2].buttonHandle;
                if (n3 != 0) {
                    OS.gtk_widget_size_request(n3, gtkRequisition);
                    n = Math.max(n, gtkRequisition.height);
                }
                ++n2;
            }
            return n;
        }
        OS.gtk_widget_realize(this.handle);
        int n = OS.GTK_WIDGET_WINDOW(this.fixedHandle);
        int n4 = OS.gtk_tree_view_get_bin_window(this.handle);
        int[] nArray = new int[1];
        OS.gdk_window_get_origin(n4, null, nArray);
        int[] nArray2 = new int[1];
        OS.gdk_window_get_origin(n, null, nArray2);
        return nArray[0] - nArray2[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_headers_visible(this.handle);
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(n);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int[] nArray = new int[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, point.x, point.y, nArray, null, null, null)) {
            return null;
        }
        if (nArray[0] == 0) {
            return null;
        }
        int n = OS.gtk_tree_path_get_indices(nArray[0]);
        TableItem tableItem = null;
        if (n != 0) {
            int[] nArray2 = new int[1];
            OS.memmove(nArray2, n, 4);
            tableItem = this._getItem(nArray2[0]);
        }
        OS.gtk_tree_path_free(nArray[0]);
        return tableItem;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        if (this.itemCount == 0) {
            int n = OS.gtk_tree_view_get_column(this.handle, 0);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            this.ignoreSize = true;
            OS.gtk_tree_view_column_cell_get_size(n, null, null, null, nArray, nArray2);
            this.ignoreSize = false;
            return nArray2[0];
        }
        int n = 0;
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        OS.gtk_tree_model_get_iter_first(this.modelHandle, n2);
        int n3 = Math.max(1, this.columnCount);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = OS.gtk_tree_view_get_column(this.handle, n4);
            OS.gtk_tree_view_column_cell_set_cell_data(n5, this.modelHandle, n2, false, false);
            int[] nArray = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_tree_view_column_cell_get_size(n5, null, null, null, nArray, nArray3);
            n = Math.max(n, nArray3[0]);
            ++n4;
        }
        OS.g_free(n2);
        return n;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] tableItemArray = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            int n = 0;
            while (n < this.itemCount) {
                tableItemArray[n] = this._getItem(n);
                ++n;
            }
        } else {
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return OS.gtk_tree_view_get_rules_hint(this.handle);
    }

    int getPixbufRenderer(int n) {
        int n2 = 0;
        n2 = OS.GTK_VERSION >= OS.VERSION(2, 12, 0) ? OS.gtk_cell_layout_get_cells(n) : OS.gtk_tree_view_column_get_cell_renderers(n);
        if (n2 == 0) {
            return 0;
        }
        int n3 = OS.g_list_length(n2);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = OS.g_list_nth_data(n2, n5);
            if (OS.GTK_IS_CELL_RENDERER_PIXBUF(n6)) {
                n4 = n6;
                break;
            }
            ++n5;
        }
        OS.g_list_free(n2);
        return n4;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        int n2 = OS.gtk_tree_selection_get_selected_rows(n, null);
        if (n2 != 0) {
            int n3;
            int n4 = OS.g_list_length(n2);
            int[] nArray = new int[n4];
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                n3 = OS.g_list_nth_data(n2, n6);
                int n7 = OS.gtk_tree_path_get_indices(n3);
                if (n7 != 0) {
                    int[] nArray2 = new int[1];
                    OS.memmove(nArray2, n7, 4);
                    nArray[n5] = nArray2[0];
                    ++n5;
                }
                OS.gtk_tree_path_free(n3);
                ++n6;
            }
            OS.g_list_free(n2);
            TableItem[] tableItemArray = new TableItem[n5];
            n3 = 0;
            while (n3 < tableItemArray.length) {
                tableItemArray[n3] = this._getItem(nArray[n3]);
                ++n3;
            }
            return tableItemArray;
        }
        return new TableItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        return OS.gtk_tree_selection_count_selected_rows(n);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        int n2 = OS.gtk_tree_selection_get_selected_rows(n, null);
        if (n2 != 0) {
            int n3 = OS.g_list_length(n2);
            int[] nArray = new int[1];
            int n4 = 0;
            while (n4 < n3) {
                int n5 = OS.g_list_nth_data(n2, n4);
                int n6 = OS.gtk_tree_path_get_indices(n5);
                if (n6 != 0) {
                    OS.memmove(nArray, n6, 4);
                    int n7 = n4;
                    while (n7 < n3) {
                        n5 = OS.g_list_nth_data(n2, n7);
                        OS.gtk_tree_path_free(n5);
                        ++n7;
                    }
                    break;
                }
                OS.gtk_tree_path_free(n5);
                ++n4;
            }
            OS.g_list_free(n2);
            return nArray[0];
        }
        return -1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        int n2 = OS.gtk_tree_selection_get_selected_rows(n, null);
        if (n2 != 0) {
            int n3 = OS.g_list_length(n2);
            int[] nArray = new int[n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                int n6 = OS.g_list_nth_data(n2, n5);
                int n7 = OS.gtk_tree_path_get_indices(n6);
                if (n7 != 0) {
                    int[] nArray2 = new int[1];
                    OS.memmove(nArray2, n7, 4);
                    nArray[n4] = nArray2[0];
                    ++n4;
                }
                OS.gtk_tree_path_free(n6);
                ++n5;
            }
            OS.g_list_free(n2);
            int[] nArray3 = new int[n4];
            System.arraycopy(nArray, 0, nArray3, 0, n4);
            return nArray3;
        }
        return new int[0];
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    int getTextRenderer(int n) {
        int n2 = 0;
        n2 = OS.GTK_VERSION >= OS.VERSION(2, 12, 0) ? OS.gtk_cell_layout_get_cells(n) : OS.gtk_tree_view_column_get_cell_renderers(n);
        if (n2 == 0) {
            return 0;
        }
        int n3 = OS.g_list_length(n2);
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = OS.g_list_nth_data(n2, n5);
            if (OS.GTK_IS_CELL_RENDERER_TEXT(n6)) {
                n4 = n6;
                break;
            }
            ++n5;
        }
        OS.g_list_free(n2);
        return n4;
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] nArray = new int[1];
        OS.gtk_widget_realize(this.handle);
        if (!OS.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, nArray, null, null, null)) {
            return 0;
        }
        if (nArray[0] == 0) {
            return 0;
        }
        int n = OS.gtk_tree_path_get_indices(nArray[0]);
        int[] nArray2 = new int[1];
        if (n != 0) {
            OS.memmove(nArray2, n, 4);
        }
        OS.gtk_tree_path_free(nArray[0]);
        return nArray2[0];
    }

    int gtk_button_press_event(int n, int n2) {
        int n3;
        int[] nArray;
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        if (gdkEventButton.window != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        int n4 = super.gtk_button_press_event(n, n2);
        if (n4 != 0) {
            return n4;
        }
        int n5 = gdkEventButton.button;
        if (n5 == 3 && gdkEventButton.type == 4 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, nArray = new int[1], null, null, null) && nArray[0] != 0) {
            n3 = OS.gtk_tree_view_get_selection(this.handle);
            if (OS.gtk_tree_selection_path_is_selected(n3, nArray[0])) {
                n4 = 1;
            }
            OS.gtk_tree_path_free(nArray[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && OS.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEventButton.x, (int)gdkEventButton.y, nArray = new int[1], null, null, null) && nArray[0] != 0) {
            n3 = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_view_set_cursor(this.handle, nArray[0], 0, false);
            OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
            OS.gtk_tree_path_free(nArray[0]);
        }
        if (!OS.GTK_WIDGET_HAS_FOCUS(this.handle)) {
            OS.gtk_widget_grab_focus(this.handle);
        }
        return n4;
    }

    int gtk_button_release_event(int n, int n2) {
        int n3 = OS.GDK_EVENT_WINDOW(n2);
        if (n3 != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        return super.gtk_button_release_event(n, n2);
    }

    int gtk_changed(int n) {
        TableItem tableItem = this.getFocusItem();
        if (tableItem != null) {
            Event event = new Event();
            event.item = tableItem;
            this.sendSelectionEvent(13, event, false);
        }
        return 0;
    }

    int gtk_event_after(int n, int n2) {
        switch (OS.GDK_EVENT_TYPE(n2)) {
            case 2: {
                if (OS.gtk_tree_model_iter_n_children(this.modelHandle, 0) != 0) break;
                this.gtk_expose_event(n, n2);
            }
        }
        return super.gtk_event_after(n, n2);
    }

    int gtk_expose_event(int n, int n2) {
        Control control;
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        if (((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
            GdkEventExpose gdkEventExpose = new GdkEventExpose();
            OS.memmove(gdkEventExpose, n2, GdkEventExpose.sizeof);
            int n3 = OS.gtk_tree_view_get_bin_window(this.handle);
            if (n3 == gdkEventExpose.window) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.gdk_drawable_get_size(n3, nArray, nArray2);
                int n4 = 0;
                if (this.itemCount != 0) {
                    int n5 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                    OS.gtk_tree_model_iter_nth_child(this.modelHandle, n5, 0, this.itemCount - 1);
                    int n6 = OS.gtk_tree_model_get_path(this.modelHandle, n5);
                    GdkRectangle gdkRectangle = new GdkRectangle();
                    OS.gtk_tree_view_get_cell_area(this.handle, n6, 0, gdkRectangle);
                    n4 = gdkRectangle.y + gdkRectangle.height;
                    OS.gtk_tree_path_free(n6);
                    OS.g_free(n5);
                }
                if (nArray2[0] > n4) {
                    this.drawBackground(control, n3, gdkEventExpose.region, 0, n4, nArray[0], nArray2[0] - n4);
                }
            }
        }
        return super.gtk_expose_event(n, n2);
    }

    int gtk_popup_menu(int n) {
        int n2 = super.gtk_popup_menu(n);
        return OS.GTK_VERSION < OS.VERSION(2, 6, 5) ? 1 : n2;
    }

    int gtk_motion_notify_event(int n, int n2) {
        int n3 = OS.GDK_EVENT_WINDOW(n2);
        if (n3 != OS.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        return super.gtk_motion_notify_event(n, n2);
    }

    int gtk_row_activated(int n, int n2, int n3) {
        Object object;
        TableItem tableItem = null;
        int n4 = OS.gtk_tree_path_get_indices(n2);
        if (n4 != 0) {
            object = new int[]{-1};
            OS.memmove((int[])object, n4, 4);
            tableItem = this._getItem((int)object[0]);
        }
        object = new Event();
        ((Event)object).item = tableItem;
        this.sendSelectionEvent(14, (Event)object, false);
        return 0;
    }

    int gtk_row_deleted(int n, int n2) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(n, OS.row_deleted);
        }
        return 0;
    }

    int gtk_row_inserted(int n, int n2, int n3) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(n, OS.row_inserted);
        }
        return 0;
    }

    int gtk_start_interactive_search(int n) {
        if (!this.searchEnabled()) {
            OS.g_signal_stop_emission_by_name(n, OS.start_interactive_search);
            return 1;
        }
        return 0;
    }

    int gtk_toggled(int n, int n2) {
        int n3 = OS.gtk_tree_path_new_from_string(n2);
        if (n3 == 0) {
            return 0;
        }
        int n4 = OS.gtk_tree_path_get_indices(n3);
        if (n4 != 0) {
            int[] nArray = new int[1];
            OS.memmove(nArray, n4, 4);
            TableItem tableItem = this._getItem(nArray[0]);
            tableItem.setChecked(!tableItem.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = tableItem;
            this.sendSelectionEvent(13, event, false);
        }
        OS.gtk_tree_path_free(n3);
        return 0;
    }

    void gtk_widget_size_request(int n, GtkRequisition gtkRequisition) {
        int n2;
        int n3;
        if (this.columnCount == 0) {
            super.gtk_widget_size_request(n, gtkRequisition);
            return;
        }
        int n4 = n3 = OS.gtk_tree_view_get_columns(this.handle);
        boolean bl = n3 != 0;
        while (n4 != 0) {
            n2 = OS.g_list_data(n4);
            if (OS.gtk_tree_view_column_get_visible(n2)) {
                bl = false;
                break;
            }
            n4 = OS.g_list_next(n4);
        }
        n2 = 0;
        if (bl) {
            n2 = OS.g_list_data(n3);
            OS.gtk_tree_view_column_set_visible(n2, true);
        }
        super.gtk_widget_size_request(n, gtkRequisition);
        if (bl) {
            OS.gtk_tree_view_column_set_visible(n2, false);
        }
        if (n3 != 0) {
            OS.g_list_free(n3);
        }
    }

    void hideFirstColumn() {
        int n = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(n, false);
    }

    void hookEvents() {
        super.hookEvents();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(n, OS.changed, this.display.closures[6], false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.closures[41], false);
        if (this.checkRenderer != 0) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.closures[53], false);
        }
        OS.g_signal_connect_closure(this.handle, OS.start_interactive_search, this.display.closures[69], false);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.closures[64], true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.closures[65], true);
        }
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == tableColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == tableItem) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == tableItem) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == tableItem) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            int n = 0;
            while (n < this.itemCount) {
                if (this.items[n] == tableItem) {
                    this.lastIndexOf = n;
                    return this.lastIndexOf;
                }
                ++n;
            }
        } else {
            int n = this.itemCount - 1;
            while (n >= 0) {
                if (this.items[n] == tableItem) {
                    this.lastIndexOf = n;
                    return this.lastIndexOf;
                }
                --n;
            }
        }
        return -1;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        byte[] byArray = Converter.wcsToMbcs(null, Integer.toString(n), true);
        int n3 = OS.gtk_tree_path_new_from_string(byArray);
        boolean bl = OS.gtk_tree_selection_path_is_selected(n2, n3);
        OS.gtk_tree_path_free(n3);
        return bl;
    }

    boolean mnemonicHit(char c) {
        int n = 0;
        while (n < this.columnCount) {
            int n2 = this.columns[n].labelHandle;
            if (n2 != 0 && this.mnemonicHit(n2, c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean mnemonicMatch(char c) {
        int n = 0;
        while (n < this.columnCount) {
            int n2 = this.columns[n].labelHandle;
            if (n2 != 0 && this.mnemonicMatch(n2, c)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    int paintWindow() {
        OS.gtk_widget_realize(this.handle);
        return OS.gtk_tree_view_get_bin_window(this.handle);
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            int n = this.checkRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0) : OS.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.closures[53], false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(OS.gtk_tree_view_get_column(this.handle, 0), 5, true, 0);
        } else {
            int n = 0;
            while (n < this.columnCount) {
                TableColumn tableColumn = this.columns[n];
                this.createRenderers(tableColumn.handle, tableColumn.modelIndex, n == 0, tableColumn.style);
                ++n;
            }
        }
    }

    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    void register() {
        super.register();
        this.display.addWidget(OS.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0) {
            this.display.addWidget(this.checkRenderer, this);
        }
        this.display.addWidget(this.modelHandle, this);
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n;
        if (this.items != null) {
            n = 0;
            while (n < this.itemCount) {
                item = this.items[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        if (this.columns != null) {
            n = 0;
            while (n < this.columnCount) {
                item = this.columns[n];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++n;
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0;
        if (this.checkRenderer != 0) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    public void remove(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            this.error(15);
        }
        int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        TableItem tableItem = this.items[n];
        boolean bl = false;
        if (tableItem != null) {
            bl = tableItem.isDisposed();
            if (!bl) {
                OS.memmove(n2, tableItem.handle, OS.GtkTreeIter_sizeof());
                tableItem.release(false);
            }
        } else {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, n2, 0, n);
        }
        if (!bl) {
            int n3 = OS.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
            OS.gtk_list_store_remove(this.modelHandle, n2);
            OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
            System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
            this.items[this.itemCount] = null;
        }
        OS.g_free(n2);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        int n4 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (n4 == 0) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        int n5 = n2;
        while (n5 >= n) {
            OS.gtk_tree_model_iter_nth_child(this.modelHandle, n4, 0, n5);
            TableItem tableItem = this.items[n5];
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
            OS.gtk_list_store_remove(this.modelHandle, n4);
            OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
            --n5;
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(n4);
        n5 = n2 + 1;
        System.arraycopy(this.items, n5, this.items, n, this.itemCount - n5);
        int n6 = this.itemCount - (n5 - n);
        while (n6 < this.itemCount) {
            this.items[n6] = null;
            ++n6;
        }
        this.itemCount -= n5 - n;
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        if (n < 0 || n > n2 || n2 >= this.itemCount) {
            this.error(6);
        }
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        int n4 = -1;
        int n5 = OS.g_malloc(OS.GtkTreeIter_sizeof());
        if (n5 == 0) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        int n6 = 0;
        while (n6 < nArray2.length) {
            int n7 = nArray2[n6];
            if (n7 != n4) {
                TableItem tableItem = this.items[n7];
                boolean bl = false;
                if (tableItem != null) {
                    bl = tableItem.isDisposed();
                    if (!bl) {
                        OS.memmove(n5, tableItem.handle, OS.GtkTreeIter_sizeof());
                        tableItem.release(false);
                    }
                } else {
                    OS.gtk_tree_model_iter_nth_child(this.modelHandle, n5, 0, n7);
                }
                if (!bl) {
                    OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
                    OS.gtk_list_store_remove(this.modelHandle, n5);
                    OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
                    System.arraycopy(this.items, n7 + 1, this.items, n7, --this.itemCount - n7);
                    this.items[this.itemCount] = null;
                }
                n4 = n7;
            }
            ++n6;
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(n5);
    }

    public void removeAll() {
        this.checkWidget();
        int n = this.itemCount - 1;
        while (n >= 0) {
            TableItem tableItem = this.items[n];
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            --n;
        }
        this.items = new TableItem[4];
        this.itemCount = 0;
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n2, 16, 0, 0, 0, 0, 6);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        OS.gtk_list_store_clear(this.modelHandle);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_signal_handlers_unblock_matched(n2, 16, 0, 0, 0, 0, 6);
        this.resetCustomDraw();
        if (!this.searchEnabled()) {
            if (OS.GTK_VERSION >= OS.VERSION(2, 6, 5)) {
                OS.gtk_tree_view_set_search_column(this.handle, -1);
            } else {
                OS.gtk_tree_view_set_enable_search(this.handle, false);
            }
        } else {
            int n3 = this.columnCount == 0 ? 5 : this.columns[0].modelIndex;
            OS.gtk_tree_view_set_search_column(this.handle, n3 + 1);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    int rendererGetSizeProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(n));
        GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
        OS.memmove(gtkCellRendererClass, n8);
        int n9 = OS.call(gtkCellRendererClass.get_size, n, this.handle, n3, n4, n5, n6, n7);
        if (!this.ignoreSize && OS.GTK_IS_CELL_RENDERER_TEXT(n)) {
            int n10;
            int[] nArray;
            int n11;
            int n12 = OS.g_object_get_qdata(n, Display.SWT_OBJECT_INDEX2);
            TableItem tableItem = null;
            boolean bl = false;
            if (n12 != 0) {
                n11 = OS.gtk_tree_model_get_path(this.modelHandle, n12);
                nArray = new int[1];
                OS.memmove(nArray, OS.gtk_tree_path_get_indices(n11), 4);
                n10 = nArray[0];
                tableItem = this._getItem(n10);
                int n13 = OS.gtk_tree_view_get_selection(this.handle);
                bl = OS.gtk_tree_selection_path_is_selected(n13, n11);
                OS.gtk_tree_path_free(n11);
            }
            if (tableItem != null) {
                n11 = 0;
                if (this.columnCount > 0) {
                    int n14 = OS.g_object_get_qdata(n, Display.SWT_OBJECT_INDEX1);
                    n10 = 0;
                    while (n10 < this.columnCount) {
                        if (this.columns[n10].handle == n14) {
                            n11 = n10;
                            break;
                        }
                        ++n10;
                    }
                }
                if (this.hooks(41)) {
                    Object object;
                    nArray = new int[1];
                    int[] nArray2 = new int[1];
                    if (n6 != 0) {
                        OS.memmove(nArray, n6, 4);
                    }
                    if (n7 != 0) {
                        OS.memmove(nArray2, n7, 4);
                    }
                    Image image = tableItem.getImage(n11);
                    int n15 = 0;
                    if (image != null) {
                        object = image.getBounds();
                        n15 = ((Rectangle)object).width;
                    }
                    nArray[0] = nArray[0] + n15;
                    object = new GC(this);
                    ((GC)object).setFont(tableItem.getFont(n11));
                    Event event = new Event();
                    event.item = tableItem;
                    event.index = n11;
                    event.gc = object;
                    event.width = nArray[0];
                    event.height = nArray2[0];
                    if (bl) {
                        event.detail = 2;
                    }
                    this.sendEvent(41, event);
                    ((Resource)object).dispose();
                    nArray[0] = event.width - n15;
                    if (nArray2[0] < event.height) {
                        nArray2[0] = event.height;
                    }
                    if (n6 != 0) {
                        OS.memmove(n6, nArray, 4);
                    }
                    if (n7 != 0) {
                        OS.memmove(n7, nArray2, 4);
                    }
                }
            }
        }
        return n9;
    }

    int rendererRenderProc(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object;
        Object object2;
        int n8;
        Object object3;
        int n9;
        int n10;
        TableItem tableItem = null;
        int n11 = OS.g_object_get_qdata(n, Display.SWT_OBJECT_INDEX2);
        if (n11 != 0) {
            n10 = OS.gtk_tree_model_get_path(this.modelHandle, n11);
            int[] nArray = new int[1];
            OS.memmove(nArray, OS.gtk_tree_path_get_indices(n10), 4);
            n9 = nArray[0];
            tableItem = this._getItem(n9);
            OS.gtk_tree_path_free(n10);
        }
        n10 = OS.g_object_get_qdata(n, Display.SWT_OBJECT_INDEX1);
        int n12 = 0;
        if (this.columnCount > 0) {
            n9 = 0;
            while (n9 < this.columnCount) {
                if (this.columns[n9].handle == n10) {
                    n12 = n9;
                    break;
                }
                ++n9;
            }
        }
        if (tableItem != null && (OS.GTK_IS_CELL_RENDERER_TOGGLE(n) || OS.GTK_IS_CELL_RENDERER_PIXBUF(n) && (n12 != 0 || (this.style & 0x20) == 0))) {
            int n13;
            Control control;
            this.drawFlags = n7;
            this.drawState = 16;
            int[] nArray = new int[1];
            OS.gtk_tree_model_get(this.modelHandle, tableItem.handle, 3, nArray, -1);
            if (nArray[0] == 0) {
                int n14 = this.columnCount == 0 ? 5 : this.columns[n12].modelIndex;
                OS.gtk_tree_model_get(this.modelHandle, tableItem.handle, n14 + 3, nArray, -1);
            }
            if (nArray[0] != 0) {
                this.drawState |= 8;
                OS.gdk_color_free(nArray[0]);
            }
            if ((n7 & 1) != 0) {
                this.drawState |= 2;
            }
            if ((n7 & 0x10) != 0) {
                this.drawState |= 4;
            }
            object3 = new GdkRectangle();
            n8 = OS.gtk_tree_model_get_path(this.modelHandle, n11);
            OS.gtk_tree_view_get_background_area(this.handle, n8, n10, (GdkRectangle)object3);
            OS.gtk_tree_path_free(n8);
            if ((this.drawState & 2) == 0 && ((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
                this.drawBackground(control, n2, 0, ((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
            }
            if ((n13 = this.getTextRenderer(n10)) != 0) {
                OS.gtk_cell_renderer_get_size(n13, this.handle, null, null, null, null, null);
            }
            if (this.hooks(40)) {
                boolean bl;
                boolean bl2 = bl = (this.drawState & 2) != 0;
                if (bl) {
                    object2 = this.findBackgroundControl();
                    if (object2 == null) {
                        object2 = this;
                    }
                    this.drawBackground((Control)object2, n2, 0, ((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
                }
                object2 = new GC(this);
                if ((this.drawState & 2) != 0) {
                    ((GC)object2).setBackground(this.display.getSystemColor(26));
                    ((GC)object2).setForeground(this.display.getSystemColor(27));
                } else {
                    ((GC)object2).setBackground(tableItem.getBackground(n12));
                    ((GC)object2).setForeground(tableItem.getForeground(n12));
                }
                ((GC)object2).setFont(tableItem.getFont(n12));
                if ((this.style & 0x8000000) != 0) {
                    ((GdkRectangle)object3).x = this.getClientWidth() - ((GdkRectangle)object3).width - ((GdkRectangle)object3).x;
                }
                ((GC)object2).setClipping(((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
                Event event = new Event();
                event.item = tableItem;
                event.index = n12;
                event.gc = object2;
                event.x = ((GdkRectangle)object3).x;
                event.y = ((GdkRectangle)object3).y;
                event.width = ((GdkRectangle)object3).width;
                event.height = ((GdkRectangle)object3).height;
                event.detail = this.drawState;
                this.sendEvent(40, event);
                this.drawForeground = null;
                this.drawState = event.doit ? event.detail : 0;
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) != 0) {
                    int n15 = OS.gtk_widget_get_style(n3);
                    object = Converter.wcsToMbcs(null, "cell_odd", true);
                    OS.gtk_paint_flat_box(n15, n2, 3, 0, (GdkRectangle)object3, n3, (byte[])object, ((GdkRectangle)object3).x, ((GdkRectangle)object3).y, ((GdkRectangle)object3).width, ((GdkRectangle)object3).height);
                } else if (bl) {
                    this.drawForeground = ((GC)object2).getForeground().handle;
                }
                ((Resource)object2).dispose();
            }
        }
        int n16 = 0;
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            object3 = new GC(this);
            ((GC)object3).setBackground(tableItem.getBackground(n12));
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.memmove(gdkRectangle, n4, GdkRectangle.sizeof);
            ((GC)object3).fillRectangle(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            ((Resource)object3).dispose();
        }
        if ((this.drawState & 0x10) != 0 || OS.GTK_IS_CELL_RENDERER_TOGGLE(n)) {
            int n17 = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(n));
            GtkCellRendererClass gtkCellRendererClass = new GtkCellRendererClass();
            OS.memmove(gtkCellRendererClass, n17);
            if (this.drawForeground != null && OS.GTK_IS_CELL_RENDERER_TEXT(n)) {
                OS.g_object_set(n, OS.foreground_gdk, this.drawForeground, 0);
            }
            n16 = OS.call(gtkCellRendererClass.render, n, n2, this.handle, n4, n5, n6, this.drawFlags);
        }
        if (tableItem != null && OS.GTK_IS_CELL_RENDERER_TEXT(n) && this.hooks(42)) {
            GdkRectangle gdkRectangle = new GdkRectangle();
            n8 = OS.gtk_tree_model_get_path(this.modelHandle, n11);
            OS.gtk_tree_view_get_background_area(this.handle, n8, n10, gdkRectangle);
            OS.gtk_tree_path_free(n8);
            this.ignoreSize = true;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_cell_renderer_get_size(n, this.handle, null, null, null, nArray2, null);
            OS.gtk_tree_view_column_cell_get_position(n10, n, nArray, null);
            this.ignoreSize = false;
            object2 = tableItem.getImage(n12);
            int n18 = 0;
            if (object2 != null) {
                Rectangle rectangle = ((Image)object2).getBounds();
                n18 = rectangle.width;
            }
            nArray[0] = nArray[0] - n18;
            nArray2[0] = nArray2[0] + n18;
            GC gC = new GC(this);
            if ((this.drawState & 2) != 0) {
                gC.setBackground(this.display.getSystemColor(26));
                gC.setForeground(this.display.getSystemColor(27));
            } else {
                gC.setBackground(tableItem.getBackground(n12));
                object = this.drawForeground != null ? Color.gtk_new(this.display, this.drawForeground) : tableItem.getForeground(n12);
                gC.setForeground((Color)object);
            }
            gC.setFont(tableItem.getFont(n12));
            if ((this.style & 0x8000000) != 0) {
                gdkRectangle.x = this.getClientWidth() - gdkRectangle.width - gdkRectangle.x;
            }
            gC.setClipping(gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
            object = new Event();
            ((Event)object).item = tableItem;
            ((Event)object).index = n12;
            ((Event)object).gc = gC;
            ((Event)object).x = gdkRectangle.x + nArray[0];
            ((Event)object).y = gdkRectangle.y;
            ((Event)object).width = nArray2[0];
            ((Event)object).height = gdkRectangle.height;
            ((Event)object).detail = this.drawState;
            this.sendEvent(42, (Event)object);
            gC.dispose();
        }
        return n16;
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.ownerDraw) {
            return;
        }
        int n = Math.max(1, this.columnCount);
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            boolean bl2 = bl = this.columnCount != 0 ? this.columns[n2].customDraw : this.firstCustomDraw;
            if (bl) {
                int n3 = OS.gtk_tree_view_get_column(this.handle, n2);
                int n4 = this.getTextRenderer(n3);
                OS.gtk_tree_view_column_set_cell_data_func(n3, n4, 0, 0, 0);
                if (this.columnCount != 0) {
                    this.columns[n2].customDraw = false;
                }
            }
            ++n2;
        }
        this.firstCustomDraw = false;
    }

    void reskinChildren(int n) {
        Item item;
        int n2;
        if (this.items != null) {
            n2 = 0;
            while (n2 < this.itemCount) {
                item = this.items[n2];
                if (item != null) {
                    item.reskin(n);
                }
                ++n2;
            }
        }
        if (this.columns != null) {
            n2 = 0;
            while (n2 < this.columnCount) {
                item = this.columns[n2];
                if (!item.isDisposed()) {
                    item.reskin(n);
                }
                ++n2;
            }
        }
        super.reskinChildren(n);
    }

    boolean searchEnabled() {
        if ((this.style & 0x10000000) != 0) {
            return false;
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0)) {
            int n = 229376;
            Shell shell = this.getShell();
            if ((shell.style & n) != 0) {
                return false;
            }
        }
        return true;
    }

    public void select(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n2, 16, 0, 0, 0, 0, 6);
        TableItem tableItem = this._getItem(n);
        OS.gtk_tree_selection_select_iter(n2, tableItem.handle);
        if ((this.style & 4) != 0) {
            int n3 = OS.gtk_tree_model_get_path(this.modelHandle, tableItem.handle);
            OS.gtk_tree_view_set_cursor(this.handle, n3, 0, false);
            OS.gtk_tree_path_free(n3);
        }
        OS.g_signal_handlers_unblock_matched(n2, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        boolean bl = this.showFirstColumn();
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
        int n4 = n;
        while (n4 <= n2) {
            TableItem tableItem = this._getItem(n4);
            OS.gtk_tree_selection_select_iter(n3, tableItem.handle);
            if ((this.style & 4) != 0) {
                int n5 = OS.gtk_tree_model_get_path(this.modelHandle, tableItem.handle);
                OS.gtk_tree_view_set_cursor(this.handle, n5, 0, false);
                OS.gtk_tree_path_free(n5);
            }
            ++n4;
        }
        OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        int n2 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n2, 16, 0, 0, 0, 0, 6);
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray[n3];
            if (n4 >= 0 && n4 < this.itemCount) {
                TableItem tableItem = this._getItem(n4);
                OS.gtk_tree_selection_select_iter(n2, tableItem.handle);
                if ((this.style & 4) != 0) {
                    int n5 = OS.gtk_tree_model_get_path(this.modelHandle, tableItem.handle);
                    OS.gtk_tree_view_set_cursor(this.handle, n5, 0, false);
                    OS.gtk_tree_path_free(n5);
                }
            }
            ++n3;
        }
        OS.g_signal_handlers_unblock_matched(n2, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean bl = this.showFirstColumn();
        int n = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_selection_select_all(n);
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 6);
        if (bl) {
            this.hideFirstColumn();
        }
    }

    void selectFocusIndex(int n) {
        if (n < 0 || n >= this.itemCount) {
            return;
        }
        TableItem tableItem = this._getItem(n);
        int n2 = OS.gtk_tree_model_get_path(this.modelHandle, tableItem.handle);
        int n3 = OS.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(n3, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_view_set_cursor(this.handle, n2, 0, false);
        OS.gtk_tree_selection_select_iter(n3, tableItem.handle);
        OS.g_signal_handlers_unblock_matched(n3, 16, 0, 0, 0, 0, 6);
        OS.gtk_tree_path_free(n2);
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
    }

    void setBackgroundPixmap(Image image) {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        OS.gtk_widget_realize(this.handle);
        if (OS.GTK_VERSION < OS.VERSION(2, 6, 0) && this.itemCount == 0) {
            this.redraw(false);
        }
        return n5;
    }

    public void setColumnOrder(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length > 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        boolean[] blArray = new boolean[this.columnCount];
        int n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[n2];
            if (n < 0 || n >= this.columnCount) {
                this.error(6);
            }
            if (blArray[n]) {
                this.error(5);
            }
            blArray[n] = true;
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray.length) {
            n = this.columns[nArray[n2]].handle;
            int n3 = n2 == 0 ? 0 : this.columns[nArray[n2 - 1]].handle;
            OS.gtk_tree_view_move_column_after(this.handle, n, n3);
            ++n2;
        }
    }

    void setFontDescription(int n) {
        super.setFontDescription(n);
        TableColumn[] tableColumnArray = this.getColumns();
        int n2 = 0;
        while (n2 < tableColumnArray.length) {
            if (tableColumnArray[n2] != null) {
                tableColumnArray[n2].setFontDescription(n);
            }
            ++n2;
        }
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_set_headers_visible(this.handle, bl);
    }

    public void setItemCount(int n) {
        boolean bl;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.itemCount) {
            return;
        }
        boolean bl2 = bl = (this.style & 0x10000000) != 0;
        if (!bl) {
            this.setRedraw(false);
        }
        this.remove(n, this.itemCount - 1);
        int n2 = Math.max(4, (n + 3) / 4 * 4);
        TableItem[] tableItemArray = new TableItem[n2];
        System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
        this.items = tableItemArray;
        if (bl) {
            int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (n3 == 0) {
                this.error(2);
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = true;
            }
            int n4 = this.itemCount;
            while (n4 < n) {
                OS.gtk_list_store_append(this.modelHandle, n3);
                ++n4;
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = false;
                OS.g_object_notify(this.handle, OS.model);
            }
            OS.g_free(n3);
            this.itemCount = n;
        } else {
            int n5 = this.itemCount;
            while (n5 < n) {
                new TableItem(this, 0, n5, true);
                ++n5;
            }
        }
        if (!bl) {
            this.setRedraw(true);
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_set_rules_hint(this.handle, bl);
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            OS.gtk_tree_view_set_grid_lines(this.handle, bl ? 2 : 0);
        }
    }

    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] != null) {
                this.items[n].setOrientation(bl);
            }
            ++n;
        }
        n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] != null) {
                this.columns[n].setOrientation(bl);
            }
            ++n;
        }
    }

    void setParentBackground() {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    void setParentWindow(int n) {
        int n2 = this.eventWindow();
        OS.gtk_widget_set_parent_window(n, n2);
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0 && this.items.length > 4 && this.items.length - this.itemCount > 3) {
            int n = Math.max(4, (this.itemCount + 3) / 4 * 4);
            TableItem[] tableItemArray = new TableItem[n];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.itemCount);
            this.items = tableItemArray;
        }
    }

    void setScrollWidth(int n, TableItem tableItem) {
        int n2;
        if (this.columnCount != 0 || this.currentItem == tableItem) {
            return;
        }
        int n3 = OS.gtk_tree_view_column_get_fixed_width(n);
        if (n3 < (n2 = this.calculateWidth(n, tableItem.handle))) {
            OS.gtk_tree_view_column_set_fixed_width(n, n2);
        }
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = tableColumn;
        if (this.sortColumn != null && this.sortDirection != 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            OS.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            OS.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        boolean bl = this.showFirstColumn();
        this.deselectAll();
        this.selectFocusIndex(n);
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        if (this.itemCount == 0 || n >= this.itemCount) {
            return;
        }
        boolean bl = this.showFirstColumn();
        n = Math.max(0, n);
        n2 = Math.min(n2, this.itemCount - 1);
        this.selectFocusIndex(n);
        if ((this.style & 2) != 0) {
            this.select(n, n2);
        }
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        boolean bl = this.showFirstColumn();
        this.selectFocusIndex(nArray[0]);
        if ((this.style & 2) != 0) {
            this.select(nArray);
        }
        this.showSelection();
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setSelection(TableItem tableItem) {
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        boolean bl = this.showFirstColumn();
        this.deselectAll();
        int n = tableItemArray.length;
        if (n != 0 && ((this.style & 4) == 0 || n <= 1)) {
            boolean bl2 = true;
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.indexOf(tableItemArray[n2]);
                if (n3 != -1) {
                    if (bl2) {
                        bl2 = false;
                        this.selectFocusIndex(n3);
                    } else {
                        this.select(n3);
                    }
                }
                ++n2;
            }
            this.showSelection();
        }
        if (bl) {
            this.hideFirstColumn();
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.itemCount) {
            return;
        }
        int n2 = OS.gtk_tree_model_get_path(this.modelHandle, this._getItem((int)n).handle);
        OS.gtk_tree_view_scroll_to_cell(this.handle, n2, 0, true, 0.0f, 0.0f);
        if (OS.GTK_VERSION < OS.VERSION(2, 8, 0)) {
            OS.gtk_widget_realize(this.handle);
            GdkRectangle gdkRectangle = new GdkRectangle();
            OS.gtk_tree_view_get_cell_area(this.handle, n2, 0, gdkRectangle);
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_tree_view_widget_to_tree_coords(this.handle, gdkRectangle.x, gdkRectangle.y, nArray, nArray2);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
        }
        OS.gtk_tree_path_free(n2);
    }

    public void showColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        OS.gtk_widget_realize(this.handle);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, 0, tableColumn.handle, gdkRectangle);
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, gdkRectangle2);
        if (gdkRectangle.x < gdkRectangle2.x) {
            OS.gtk_tree_view_scroll_to_point(this.handle, gdkRectangle.x, -1);
        } else {
            int n = Math.min(gdkRectangle2.width, gdkRectangle.width);
            if (gdkRectangle.x + n > gdkRectangle2.x + gdkRectangle2.width) {
                int n2 = gdkRectangle.x + n - gdkRectangle2.width;
                OS.gtk_tree_view_scroll_to_point(this.handle, n2, -1);
            }
        }
    }

    boolean showFirstColumn() {
        int n = Math.max(1, this.columnCount);
        int n2 = 0;
        while (n2 < n) {
            int n3 = OS.gtk_tree_view_get_column(this.handle, n2);
            if (OS.gtk_tree_view_column_get_visible(n3)) {
                return false;
            }
            ++n2;
        }
        n2 = OS.gtk_tree_view_get_column(this.handle, 0);
        OS.gtk_tree_view_column_set_visible(n2, true);
        return true;
    }

    public void showItem(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if (tableItem.parent != this) {
            return;
        }
        this.showItem(tableItem.handle);
    }

    void showItem(int n) {
        int n2 = OS.gtk_tree_model_get_path(this.modelHandle, n);
        OS.gtk_widget_realize(this.handle);
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.gtk_tree_view_get_visible_rect(this.handle, gdkRectangle);
        GdkRectangle gdkRectangle2 = new GdkRectangle();
        OS.gtk_tree_view_get_cell_area(this.handle, n2, 0, gdkRectangle2);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (OS.GTK_VERSION >= OS.VERSION(2, 12, 0)) {
            OS.gtk_tree_view_convert_widget_to_bin_window_coords(this.handle, gdkRectangle2.x, gdkRectangle2.y, nArray, nArray2);
        } else {
            OS.gtk_tree_view_widget_to_tree_coords(this.handle, gdkRectangle2.x, gdkRectangle2.y, nArray, nArray2);
        }
        if (nArray2[0] < gdkRectangle.y) {
            OS.gtk_tree_view_scroll_to_cell(this.handle, n2, 0, true, 0.0f, 0.0f);
            OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
        } else {
            int n3 = Math.min(gdkRectangle.height, gdkRectangle2.height);
            if (nArray2[0] + n3 > gdkRectangle.y + gdkRectangle.height) {
                OS.gtk_tree_view_scroll_to_cell(this.handle, n2, 0, true, 1.0f, 0.0f);
                nArray2[0] = nArray2[0] + (gdkRectangle2.height - gdkRectangle.height);
                OS.gtk_tree_view_scroll_to_point(this.handle, -1, nArray2[0]);
            }
        }
        OS.gtk_tree_path_free(n2);
    }

    public void showSelection() {
        this.checkWidget();
        TableItem[] tableItemArray = this.getSelection();
        if (tableItemArray.length == 0) {
            return;
        }
        TableItem tableItem = tableItemArray[0];
        this.showItem(tableItem.handle);
    }

    void updateScrollBarValue(ScrollBar scrollBar) {
        super.updateScrollBarValue(scrollBar);
        int n = this.parentingHandle();
        int n2 = OS.gtk_container_get_children(n);
        if (n2 == 0) {
            return;
        }
        int n3 = n2;
        while (n3 != 0) {
            int n4 = OS.g_list_data(n3);
            if (n4 != 0) {
                OS.gtk_widget_queue_resize(n4);
            }
            n3 = OS.g_list_next(n3);
        }
        OS.g_list_free(n2);
    }

    int windowProc(int n, int n2, int n3) {
        switch (n3) {
            case 19: {
                Control control;
                if (this.itemCount != 0 || (this.state & 0x40) != 0 || (this.state & 0x8000) == 0 && this.backgroundImage == null || (control = this.findBackgroundControl()) == null) break;
                GdkEventExpose gdkEventExpose = new GdkEventExpose();
                OS.memmove(gdkEventExpose, n2, GdkEventExpose.sizeof);
                int n4 = OS.gtk_tree_view_get_bin_window(n);
                if (n4 != gdkEventExpose.window) break;
                this.drawBackground(control, n4, gdkEventExpose.region, gdkEventExpose.area_x, gdkEventExpose.area_y, gdkEventExpose.area_width, gdkEventExpose.area_height);
            }
        }
        return super.windowProc(n, n2, n3);
    }
}

