/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    int feedback = 0;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    long dragOverStart;
    Runnable dragOverHeartbeat;
    DNDEvent dragOverEvent;
    static DropTarget CurrentDropTarget;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static final int DRAGOVER_HYSTERESIS = 50;
    static final String IS_ACTIVE = "org.eclipse.swt.internal.isActive";
    static Callback DragTrackingHandler;
    static Callback DragReceiveHandler;
    static /* synthetic */ Class class$0;

    static {
        int n;
        Class<?> clazz;
        int n2;
        CurrentDropTarget = null;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((n2 = (DragTrackingHandler = new Callback(clazz2, "DragTrackingHandler", 4)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((n = (DragReceiveHandler = new Callback(clazz, "DragReceiveHandler", 3)).getAddress()) == 0) {
            SWT.error(3);
        }
        OS.InstallTrackingHandler(n2, 0, null);
        OS.InstallReceiveHandler(n, 0, null);
    }

    public DropTarget(Control control, int n) {
        super(control, DropTarget.checkStyle(n));
        this.control = control;
        if (DragTrackingHandler == null || DragTrackingHandler == null) {
            DND.error(2001);
        }
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (object instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)object;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
        this.dragOverHeartbeat = new Runnable(){

            public void run() {
                Control control = DropTarget.this.control;
                if (control == null || control.isDisposed() || DropTarget.this.dragOverStart == 0L) {
                    return;
                }
                long l = System.currentTimeMillis();
                int n = 50;
                if (l < DropTarget.this.dragOverStart) {
                    n = (int)(DropTarget.this.dragOverStart - l);
                } else {
                    int n2 = DropTarget.this.dragOverEvent.operations;
                    TransferData[] transferDataArray = DropTarget.this.dragOverEvent.dataTypes;
                    TransferData[] transferDataArray2 = new TransferData[transferDataArray.length];
                    System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray2.length);
                    DNDEvent dNDEvent = new DNDEvent();
                    dNDEvent.widget = DropTarget.this.dragOverEvent.widget;
                    dNDEvent.x = DropTarget.this.dragOverEvent.x;
                    dNDEvent.y = DropTarget.this.dragOverEvent.y;
                    dNDEvent.time = (int)l;
                    dNDEvent.feedback = 1;
                    dNDEvent.dataTypes = transferDataArray2;
                    dNDEvent.dataType = DropTarget.this.selectedDataType;
                    dNDEvent.operations = DropTarget.this.dragOverEvent.operations;
                    dNDEvent.detail = DropTarget.this.selectedOperation;
                    if (DropTarget.this.dropEffect != null) {
                        dNDEvent.item = DropTarget.this.dropEffect.getItem(dNDEvent.x, dNDEvent.y);
                    }
                    DropTarget.this.selectedDataType = null;
                    DropTarget.this.selectedOperation = 0;
                    DropTarget.this.notifyListeners(2004, dNDEvent);
                    if (dNDEvent.dataType != null) {
                        int n3 = 0;
                        while (n3 < transferDataArray.length) {
                            if (transferDataArray[n3].type == dNDEvent.dataType.type) {
                                DropTarget.this.selectedDataType = dNDEvent.dataType;
                                break;
                            }
                            ++n3;
                        }
                    }
                    if (DropTarget.this.selectedDataType != null && (dNDEvent.detail & n2) != 0) {
                        DropTarget.this.selectedOperation = dNDEvent.detail;
                    }
                }
                control = DropTarget.this.control;
                if (control == null || control.isDisposed()) {
                    return;
                }
                control.getDisplay().timerExec(n, DropTarget.this.dragOverHeartbeat);
            }
        };
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    static int DragReceiveHandler(int n, int n2, int n3) {
        DropTarget dropTarget = DropTarget.FindDropTarget(n, n3);
        if (dropTarget == null) {
            return 0;
        }
        return dropTarget.dragReceiveHandler(n, n2, n3);
    }

    static int DragTrackingHandler(int n, int n2, int n3, int n4) {
        if (n == 5 || n == 1) {
            CurrentDropTarget = null;
            return 0;
        }
        DropTarget dropTarget = DropTarget.FindDropTarget(n2, n4);
        if (CurrentDropTarget != null) {
            if (dropTarget == null || DropTarget.CurrentDropTarget.control.handle != dropTarget.control.handle) {
                CurrentDropTarget.dragTrackingHandler(4, n2, n3, n4);
                CurrentDropTarget = dropTarget;
                n = 2;
            }
        } else {
            CurrentDropTarget = dropTarget;
            n = 2;
        }
        if (dropTarget == null) {
            return 0;
        }
        return dropTarget.dragTrackingHandler(n, n2, n3, n4);
    }

    static DropTarget FindDropTarget(int n, int n2) {
        Widget widget;
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Point point = new Point();
        OS.GetDragMouse(n2, point, null);
        int[] nArray = new int[1];
        OS.GetRootControl(n, nArray);
        int[] nArray2 = new int[1];
        Rect rect = new Rect();
        OS.GetWindowBounds(n, (short)32, rect);
        CGPoint cGPoint = new CGPoint();
        cGPoint.x = point.h - rect.left;
        cGPoint.y = point.v - rect.top;
        int[] nArray3 = new int[1];
        OS.CreateEvent(0, 1836021107, 1, 0.0, 0, nArray3);
        OS.SetEventParameter(nArray3[0], 2003660661, 1751740532, 8, cGPoint);
        OS.HIViewGetViewForMouseEvent(nArray[0], nArray3[0], nArray2);
        OS.ReleaseEvent(nArray3[0]);
        if (!OS.IsControlEnabled(nArray2[0])) {
            return null;
        }
        DropTarget dropTarget = null;
        while ((widget = display.findWidget(nArray2[0])) == null || (dropTarget = (DropTarget)widget.getData("DropTarget")) == null) {
            OS.GetSuperControl(nArray2[0], nArray2);
            if (nArray2[0] != 0) continue;
        }
        return dropTarget;
    }

    public void addDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dropTargetListener);
        dNDListener.dndWidget = this;
        this.addListener(2002, dNDListener);
        this.addListener(2003, dNDListener);
        this.addListener(2004, dNDListener);
        this.addListener(2005, dNDListener);
        this.addListener(2006, dNDListener);
        this.addListener(2007, dNDListener);
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    int dragReceiveHandler(int n, int n2, int n3) {
        Object object;
        this.updateDragOverHover(0L, null);
        if (this.keyOperation == -1) {
            return -1857;
        }
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = (int)System.currentTimeMillis();
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
        dNDEvent = new DNDEvent();
        if (!this.setEventData(n3, dNDEvent)) {
            return -1857;
        }
        this.keyOperation = -1;
        int n4 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, dNDEvent.dataTypes.length);
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(2007, dNDEvent);
        if (dNDEvent.dataType != null) {
            int n5 = 0;
            while (n5 < transferDataArray.length) {
                if (transferDataArray[n5].type == dNDEvent.dataType.type) {
                    this.selectedDataType = transferDataArray[n5];
                    break;
                }
                ++n5;
            }
        }
        if (this.selectedDataType != null && (dNDEvent.detail & n4) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            return -1857;
        }
        byte[][] byArrayArray = new byte[][]{};
        short[] sArray = new short[1];
        OS.CountDragItems(n3, sArray);
        short s = 0;
        while (s < sArray[0]) {
            int[] nArray = new int[1];
            OS.GetDragItemReferenceNumber(n3, (short)(s + 1), nArray);
            object = new int[1];
            OS.GetFlavorDataSize(n3, nArray[0], this.selectedDataType.type, (int[])object);
            if (object[0] > 0) {
                byte[] byArray = new byte[object[0]];
                OS.GetFlavorData(n3, nArray[0], this.selectedDataType.type, byArray, (int[])object, 0);
                byte[][] byArrayArray2 = new byte[byArrayArray.length + 1][];
                System.arraycopy(byArrayArray, 0, byArrayArray2, 0, byArrayArray.length);
                byArrayArray2[byArrayArray.length] = byArray;
                byArrayArray = byArrayArray2;
            }
            s = (short)(s + 1);
        }
        Object object2 = null;
        int n6 = 0;
        while (n6 < this.transferAgents.length) {
            object = this.transferAgents[n6];
            if (object != null && ((Transfer)object).isSupportedType(this.selectedDataType)) {
                this.selectedDataType.data = byArrayArray;
                object2 = ((Transfer)object).nativeToJava(this.selectedDataType);
                break;
            }
            ++n6;
        }
        if (object2 == null) {
            this.selectedOperation = 0;
        }
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        dNDEvent.data = object2;
        this.notifyListeners(2006, dNDEvent);
        this.selectedOperation = 0;
        if ((n4 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        n6 = this.opToOsOp(this.selectedOperation);
        OS.SetDragDropAction(n3, n6);
        return this.selectedOperation == 0 ? -1857 : 0;
    }

    int dragTrackingHandler(int n, int n2, int n3, int n4) {
        DNDEvent dNDEvent;
        if (n == 4) {
            this.updateDragOverHover(0L, null);
            OS.SetThemeCursor(0);
            if (this.keyOperation == -1) {
                return -1857;
            }
            this.keyOperation = -1;
            DNDEvent dNDEvent2 = new DNDEvent();
            dNDEvent2.widget = this;
            dNDEvent2.time = (int)System.currentTimeMillis();
            dNDEvent2.detail = 0;
            this.notifyListeners(2003, dNDEvent2);
            return 0;
        }
        int n5 = this.keyOperation;
        if (n == 2) {
            this.selectedDataType = null;
            this.selectedOperation = 0;
        }
        if (!this.setEventData(n4, dNDEvent = new DNDEvent()) || !((Boolean)this.control.getData(IS_ACTIVE)).booleanValue()) {
            this.keyOperation = -1;
            OS.SetThemeCursor(18);
            return -1857;
        }
        int n6 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        switch (n) {
            case 2: {
                dNDEvent.type = 2002;
                break;
            }
            case 3: {
                if (this.keyOperation == n5) {
                    dNDEvent.type = 2004;
                    dNDEvent.dataType = this.selectedDataType;
                    dNDEvent.detail = this.selectedOperation;
                    break;
                }
                dNDEvent.type = 2005;
                dNDEvent.dataType = this.selectedDataType;
            }
        }
        this.updateDragOverHover(50L, dNDEvent);
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(dNDEvent.type, dNDEvent);
        if (dNDEvent.detail == 16) {
            int n7 = dNDEvent.detail = (n6 & 2) != 0 ? 2 : 0;
        }
        if (dNDEvent.dataType != null) {
            int n8 = 0;
            while (n8 < transferDataArray.length) {
                if (transferDataArray[n8].type == dNDEvent.dataType.type) {
                    this.selectedDataType = transferDataArray[n8];
                    break;
                }
                ++n8;
            }
        }
        if (this.selectedDataType != null && (n6 & dNDEvent.detail) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.SetDragDropAction(n4, this.opToOsOp(this.selectedOperation));
        switch (this.selectedOperation) {
            case 1: {
                OS.SetThemeCursor(1);
                break;
            }
            case 4: {
                OS.SetThemeCursor(2);
                break;
            }
            case 2: {
                OS.SetThemeCursor(0);
                break;
            }
            default: {
                OS.SetThemeCursor(18);
            }
        }
        if (n == 2) {
            this.dragOverHeartbeat.run();
        }
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listenerArray = this.getListeners(2002);
        int n = listenerArray.length;
        DropTargetListener[] dropTargetListenerArray = new DropTargetListener[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            Listener listener = listenerArray[n3];
            if (listener instanceof DNDListener) {
                dropTargetListenerArray[n2] = (DropTargetListener)((DNDListener)listener).getEventListener();
                ++n2;
            }
            ++n3;
        }
        if (n2 == n) {
            return dropTargetListenerArray;
        }
        DropTargetListener[] dropTargetListenerArray2 = new DropTargetListener[n2];
        System.arraycopy(dropTargetListenerArray, 0, dropTargetListenerArray2, 0, n2);
        return dropTargetListenerArray2;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState(int n) {
        boolean bl;
        short[] sArray = new short[1];
        OS.GetDragModifiers(n, sArray, null, null);
        boolean bl2 = (sArray[0] & 0x800) == 2048;
        boolean bl3 = bl = (sArray[0] & 0x100) == 256;
        if (bl2 && bl) {
            return 4;
        }
        if (bl2) {
            return 1;
        }
        if (bl) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DropTarget", null);
        this.transferAgents = null;
        this.control = null;
    }

    int opToOsOp(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 2;
        }
        if ((n & 2) != 0) {
            n2 |= 0x10;
        }
        return n2;
    }

    int osOpToOp(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 2) != 0) {
            n2 |= 4;
        }
        if ((n & 0x10) != 0) {
            n2 |= 2;
        }
        if (n == -1) {
            n2 = 7;
        }
        return n2;
    }

    public void removeDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        this.removeListener(2002, dropTargetListener);
        this.removeListener(2003, dropTargetListener);
        this.removeListener(2004, dropTargetListener);
        this.removeListener(2005, dropTargetListener);
        this.removeListener(2006, dropTargetListener);
        this.removeListener(2007, dropTargetListener);
    }

    public void setDropTargetEffect(DropTargetEffect dropTargetEffect) {
        this.dropEffect = dropTargetEffect;
    }

    boolean setEventData(int n, DNDEvent dNDEvent) {
        Object object;
        int n2;
        if (n == 0) {
            return false;
        }
        int n3 = this.getStyle();
        int[] nArray = new int[1];
        OS.GetDragAllowableActions(n, nArray);
        int n4 = this.osOpToOp(nArray[0]) & n3;
        if (n4 == 0) {
            return false;
        }
        this.keyOperation = n2 = this.getOperationFromKeyState(n);
        if (n2 == 16) {
            if ((n3 & 0x10) == 0) {
                n2 = (n4 & 2) != 0 ? 2 : 0;
            }
        } else if ((n2 & n4) == 0) {
            n2 = 0;
        }
        short[] sArray = new short[1];
        OS.CountDragItems(n, sArray);
        int[] nArray2 = new int[10];
        int n5 = -1;
        short s = 0;
        while (s < sArray[0]) {
            int[] nArray3 = new int[1];
            OS.GetDragItemReferenceNumber(n, (short)(s + 1), nArray3);
            object = new short[1];
            OS.CountDragItemFlavors(n, nArray3[0], object);
            int[] nArray4 = new int[1];
            int n6 = 0;
            while (n6 < object[0]) {
                nArray4[0] = 0;
                if (OS.GetFlavorType(n, nArray3[0], (short)(n6 + 1), nArray4) == 0) {
                    boolean bl = true;
                    int n7 = 0;
                    while (n7 < nArray2.length) {
                        if (nArray2[n7] == nArray4[0]) {
                            bl = false;
                            break;
                        }
                        ++n7;
                    }
                    if (bl) {
                        if (n5 == nArray2.length - 1) {
                            int[] nArray5 = new int[nArray2.length + 10];
                            System.arraycopy(nArray2, 0, nArray5, 0, nArray2.length);
                            nArray2 = nArray5;
                        }
                        nArray2[++n5] = nArray4[0];
                    }
                }
                ++n6;
            }
            s = (short)(s + 1);
        }
        if (n5 == -1) {
            return false;
        }
        TransferData[] transferDataArray = new TransferData[n5 + 1];
        n5 = -1;
        int n8 = 0;
        while (n8 < transferDataArray.length) {
            if (nArray2[n8] != 0) {
                object = new TransferData();
                object.type = nArray2[n8];
                int n9 = 0;
                while (n9 < this.transferAgents.length) {
                    Transfer transfer = this.transferAgents[n9];
                    if (transfer != null && transfer.isSupportedType((TransferData)object)) {
                        transferDataArray[++n5] = object;
                        break;
                    }
                    ++n9;
                }
            }
            ++n8;
        }
        if (n5 == -1) {
            return false;
        }
        if (n5 < transferDataArray.length - 1) {
            TransferData[] transferDataArray2 = new TransferData[n5 + 1];
            System.arraycopy(transferDataArray, 0, transferDataArray2, 0, n5 + 1);
            transferDataArray = transferDataArray2;
        }
        Point point = new Point();
        OS.GetDragMouse(n, point, null);
        dNDEvent.widget = this;
        dNDEvent.x = point.h;
        dNDEvent.y = point.v;
        dNDEvent.time = (int)System.currentTimeMillis();
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = transferDataArray;
        dNDEvent.dataType = transferDataArray[0];
        dNDEvent.operations = n4;
        dNDEvent.detail = n2;
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(dNDEvent.x, dNDEvent.y);
        }
        return true;
    }

    public void setTransfer(Transfer[] transferArray) {
        if (transferArray == null) {
            DND.error(4);
        }
        this.transferAgents = transferArray;
    }

    void updateDragOverHover(long l, DNDEvent dNDEvent) {
        if (l == 0L) {
            this.dragOverStart = 0L;
            this.dragOverEvent = null;
            return;
        }
        this.dragOverStart = System.currentTimeMillis() + l;
        if (this.dragOverEvent == null) {
            this.dragOverEvent = new DNDEvent();
        }
        this.dragOverEvent.x = dNDEvent.x;
        this.dragOverEvent.y = dNDEvent.y;
        this.dragOverEvent.dataTypes = dNDEvent.dataTypes;
        this.dragOverEvent.operations = dNDEvent.operations;
        this.dragOverEvent.dataType = dNDEvent.dataType;
        this.dragOverEvent.detail = dNDEvent.detail;
    }
}

