/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    Display display;
    static /* synthetic */ Class class$0;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.Clipboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int n) {
        this.checkWidget();
        if ((n & 1) == 0) {
            return;
        }
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard != null) {
            nSPasteboard.declareTypes(NSMutableArray.arrayWithCapacity(0L), null);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int n) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        if ((n & 1) == 0) {
            return null;
        }
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            return null;
        }
        String[] stringArray = transfer.getTypeNames();
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(stringArray.length);
        int n2 = 0;
        while (n2 < stringArray.length) {
            nSMutableArray.addObject(NSString.stringWith(stringArray[n2]));
            ++n2;
        }
        NSString nSString = nSPasteboard.availableTypeFromArray(nSMutableArray);
        if (nSString != null) {
            TransferData transferData = new TransferData();
            transferData.type = Transfer.registerType(nSString.getString());
            transferData.data = nSString.isEqual(OS.NSStringPboardType) || nSString.isEqual(OS.NSRTFPboardType) || nSString.isEqual(OS.NSHTMLPboardType) ? nSPasteboard.stringForType(nSString) : (nSString.isEqual(OS.NSFilenamesPboardType) ? new NSArray(nSPasteboard.propertyListForType((NSString)nSString).id) : (nSString.isEqual(OS.NSURLPboardType) ? NSURL.URLFromPasteboard(nSPasteboard) : nSPasteboard.dataForType(nSString)));
            if (transferData.data != null) {
                return transfer.nativeToJava(transferData);
            }
        }
        return null;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray) {
        this.setContents(objectArray, transferArray, 1);
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray, int n) {
        this.checkWidget();
        if (objectArray == null || transferArray == null || objectArray.length != transferArray.length || objectArray.length == 0) {
            DND.error(5);
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] == null || transferArray[n2] == null || !transferArray[n2].validate(objectArray[n2])) {
                DND.error(5);
            }
            ++n2;
        }
        if ((n & 1) == 0) {
            return;
        }
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            DND.error(2002);
        }
        nSPasteboard.declareTypes(NSMutableArray.arrayWithCapacity(0L), null);
        int n3 = 0;
        while (n3 < transferArray.length) {
            String[] stringArray = transferArray[n3].getTypeNames();
            int n4 = 0;
            while (n4 < stringArray.length) {
                TransferData transferData = new TransferData();
                transferData.type = Transfer.registerType(stringArray[n4]);
                transferArray[n3].javaToNative(objectArray[n3], transferData);
                NSObject nSObject = transferData.data;
                NSString nSString = NSString.stringWith(stringArray[n4]);
                nSPasteboard.addTypes(NSArray.arrayWithObject(nSString), null);
                if (nSString.isEqual(OS.NSStringPboardType) || nSString.isEqual(OS.NSRTFPboardType) || nSString.isEqual(OS.NSHTMLPboardType)) {
                    nSPasteboard.setString((NSString)nSObject, nSString);
                } else if (nSString.isEqual(OS.NSURLPboardType)) {
                    NSURL nSURL = (NSURL)nSObject;
                    nSURL.writeToPasteboard(nSPasteboard);
                } else if (nSString.isEqual(OS.NSFilenamesPboardType)) {
                    nSPasteboard.setPropertyList((NSArray)nSObject, nSString);
                } else {
                    nSPasteboard.setData((NSData)nSObject, nSString);
                }
                ++n4;
            }
            ++n3;
        }
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int n) {
        this.checkWidget();
        if ((n & 1) == 0) {
            return new TransferData[0];
        }
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            return new TransferData[0];
        }
        NSArray nSArray = nSPasteboard.types();
        if (nSArray == null) {
            return new TransferData[0];
        }
        int n2 = (int)nSArray.count();
        TransferData[] transferDataArray = new TransferData[n2];
        int n3 = 0;
        while (n3 < n2) {
            transferDataArray[n3] = new TransferData();
            transferDataArray[n3].type = Transfer.registerType(new NSString(nSArray.objectAtIndex(n3)).getString());
            ++n3;
        }
        return transferDataArray;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        NSPasteboard nSPasteboard = NSPasteboard.generalPasteboard();
        if (nSPasteboard == null) {
            return new String[0];
        }
        NSArray nSArray = nSPasteboard.types();
        if (nSArray == null) {
            return new String[0];
        }
        int n = (int)nSArray.count();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = new NSString(nSArray.objectAtIndex(n2)).getString();
            ++n2;
        }
        return stringArray;
    }
}

