/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSToolbar;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTToolbar;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    int itemCount;
    ToolItem[] items;
    NSToolbar nsToolbar;
    NSArray accessibilityAttributes = null;
    ToolItem lastFocus;
    static int NEXT_ID;

    public ToolBar(Composite composite, int n) {
        this(composite, n, false);
    }

    ToolBar(Composite composite, int n, boolean bl) {
        super(composite, ToolBar.checkStyle(composite, n, bl));
        this.style = (n & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    long accessibilityAttributeValue(long l, long l2, long l3) {
        id id2;
        NSString nSString = new NSString(l3);
        if (l == this.accessibleHandle() && this.accessible != null && (id2 = this.accessible.internal_accessibilityAttributeValue(nSString, -1)) != null) {
            return id2.id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute) || nSString.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            id2 = OS.NSAccessibilityToolbarRole;
            if (nSString.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
                return ((NSString)id2).id;
            }
            long l4 = OS.NSAccessibilityRoleDescription(((NSString)id2).id, 0L);
            return l4;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityChildrenAttribute)) {
            id2 = NSMutableArray.arrayWithCapacity(this.itemCount);
            int n = 0;
            while (n < this.itemCount) {
                ((NSMutableArray)id2).addObject(new id(this.getItem(n).accessibleHandle()));
                ++n;
            }
            return ((NSMutableArray)id2).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return NSNumber.numberWithBool((boolean)this.isEnabled()).id;
        }
        if (nSString.isEqualToString(OS.NSAccessibilityFocusedAttribute)) {
            boolean bl = this.view.id == this.view.window().firstResponder().id;
            return NSNumber.numberWithBool((boolean)bl).id;
        }
        return super.accessibilityAttributeValue(l, l2, l3);
    }

    boolean accessibilityIsIgnored(long l, long l2) {
        if (l == this.view.id) {
            return false;
        }
        return super.accessibilityIsIgnored(l, l2);
    }

    static int checkStyle(Composite composite, int n, boolean bl) {
        int n2 = n & 0xFFFFFCFF;
        if (!bl && (n2 & 0x10000) != 0) {
            n2 &= 0xFFFEFFFF;
        }
        if ((n & 0x10000) != 0) {
            if (composite instanceof Shell) {
                Shell shell = (Shell)composite;
                if (shell.window.toolbar() != null) {
                    n2 &= 0xFFFEFFFF;
                }
            } else {
                n2 &= 0xFFFEFFFF;
            }
        }
        if ((n2 & 0x10000) != 0) {
            n2 &= 0xFFFFFDBF;
            n2 |= 0x100;
        }
        return n2;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = n;
        int n4 = n2;
        if (n == -1) {
            n3 = Integer.MAX_VALUE;
        }
        if (n2 == -1) {
            n4 = Integer.MAX_VALUE;
        }
        int[] nArray = this.layout(n3, n4, false);
        Point point = new Point(nArray[1], nArray[2]);
        if (n != -1) {
            point.x = n;
        }
        if (n2 != -1) {
            point.y = n2;
        }
        Rectangle rectangle = this.computeTrim(0, 0, point.x, point.y);
        return new Point(rectangle.width, rectangle.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        if (this.nsToolbar != null) {
            NSRect nSRect = this.view.frame();
            NSRect nSRect2 = new NSView(this.view.subviews().objectAtIndex(0L)).frame();
            n3 += (int)nSRect.width - (int)nSRect2.width;
        } else if (this.scrollView != null) {
            NSSize nSSize = new NSSize();
            nSSize.width = n3;
            nSSize.height = n4;
            nSSize = NSScrollView.frameSizeForContentSize(nSSize, false, false, 2L);
            n3 = (int)nSSize.width;
            n4 = (int)nSSize.height;
            NSRect nSRect = this.scrollView.contentView().frame();
            n = (int)((double)n - nSRect.x);
            n2 = (int)((double)n2 - nSRect.y);
        }
        return new Rectangle(n, n2, n3, n4);
    }

    void createHandle() {
        if ((this.style & 0x10000) != 0) {
            this.nsToolbar = ((NSToolbar)new SWTToolbar().alloc()).initWithIdentifier(NSString.stringWith(String.valueOf(NEXT_ID++)));
            this.nsToolbar.setDelegate(this.nsToolbar);
            this.nsToolbar.setDisplayMode(2L);
            NSWindow nSWindow = this.parent.view.window();
            nSWindow.setToolbar(this.nsToolbar);
            this.nsToolbar.setVisible(true);
            NSArray nSArray = nSWindow.contentView().superview().subviews();
            int n = 0;
            while ((long)n < nSArray.count()) {
                id id2 = nSArray.objectAtIndex(n);
                if (new NSObject(id2).className().getString().equals("NSToolbarView")) {
                    this.view = new NSView(id2);
                    OS.object_setClass(this.view.id, OS.objc_getClass("SWTToolbarView"));
                    this.view.retain();
                    break;
                }
                ++n;
            }
            this.style &= 0xFFFEFFFF;
        } else {
            Object object;
            this.state |= 0x800;
            if (this.hasBorder()) {
                object = new NSRect();
                NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
                nSScrollView.initWithFrame((NSRect)object);
                nSScrollView.setDrawsBackground(false);
                nSScrollView.setBorderType(2L);
                this.scrollView = nSScrollView;
            }
            object = (NSView)new SWTView().alloc();
            ((NSObject)object).init();
            this.view = object;
            if (this.scrollView != null) {
                this.view.setAutoresizingMask(18L);
            }
        }
    }

    void createItem(ToolItem toolItem, int n) {
        if (n < 0 || n > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ToolItem[] toolItemArray = new ToolItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, toolItemArray, 0, this.items.length);
            this.items = toolItemArray;
        }
        toolItem.createWidget();
        System.arraycopy(this.items, n, this.items, n + 1, this.itemCount++ - n);
        this.items[n] = toolItem;
        if (this.nsToolbar != null) {
            this.nsToolbar.insertItemWithItemIdentifier(toolItem.getItemID(), n);
        } else {
            this.view.addSubview(toolItem.view);
        }
        this.relayout();
    }

    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.itemCount = 0;
    }

    NSFont defaultNSFont() {
        return NSFont.systemFontOfSize(11.0);
    }

    void deregister() {
        super.deregister();
        if (this.nsToolbar != null) {
            this.display.removeWidget(this.nsToolbar);
        }
    }

    void destroyItem(ToolItem toolItem) {
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == toolItem) break;
            ++n;
        }
        if (n == this.itemCount) {
            return;
        }
        if (toolItem == this.lastFocus) {
            this.lastFocus = null;
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        if (this.nsToolbar != null) {
            this.nsToolbar.removeItemAtIndex(n);
        } else {
            toolItem.view.removeFromSuperview();
        }
        this.relayout();
    }

    void drawBackground(long l, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        if (l != this.view.id) {
            return;
        }
        if (this.background != null) {
            this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
        }
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null) {
                toolItem.enableWidget(bl && toolItem.getEnabled());
            }
            ++n;
        }
    }

    Widget findTooltip(NSPoint nSPoint) {
        nSPoint = this.view.convertPoint_fromView_(nSPoint, null);
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if (OS.NSPointInRect(nSPoint, toolItem.view.frame())) {
                return toolItem;
            }
            ++n;
        }
        return super.findTooltip(nSPoint);
    }

    void setZOrder() {
        if (this.nsToolbar != null) {
            return;
        }
        super.setZOrder();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.nsToolbar != null) {
            NSRect nSRect = this.view.frame();
            nSRect = this.view.convertRect_toView_(nSRect, null);
            return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
        }
        return super.getBounds();
    }

    boolean forceFocus(NSView nSView) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem.setFocus()) {
                this.lastFocus = toolItem;
                return true;
            }
            ++n;
        }
        return false;
    }

    public ToolItem getItem(int n) {
        this.checkWidget();
        if (n >= 0 && n < this.itemCount) {
            return this.items[n];
        }
        this.error(6);
        return null;
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.itemCount) {
            Rectangle rectangle = this.items[n].getBounds();
            if (rectangle.contains(point)) {
                return this.items[n];
            }
            ++n;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        ToolItem[] toolItemArray = new ToolItem[this.itemCount];
        System.arraycopy(this.items, 0, toolItemArray, 0, this.itemCount);
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        Rectangle rectangle = this.getClientArea();
        return this.layout(rectangle.width, rectangle.height, false)[0];
    }

    boolean hasKeyboardFocus(int n) {
        return this.hasFocus();
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        if (toolItem.isDisposed()) {
            this.error(5);
        }
        int n = 0;
        while (n < this.itemCount) {
            if (this.items[n] == toolItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int[] layoutHorizontal(int n, int n2, boolean bl) {
        Object object;
        int n3 = 0;
        int n4 = 2;
        int n5 = 0;
        int n6 = 0;
        int n7 = n5;
        int n8 = n6;
        int n9 = 0;
        int n10 = 1;
        boolean bl2 = (this.style & 0x40) != 0;
        int n11 = 0;
        Point[] pointArray = new Point[this.itemCount];
        int n12 = 0;
        while (n12 < this.itemCount) {
            pointArray[n12] = this.items[n12].computeSize();
            object = pointArray[n12];
            n11 = Math.max(n11, ((Point)object).y);
            ++n12;
        }
        n12 = 0;
        while (n12 < this.itemCount) {
            object = this.items[n12];
            Point point = pointArray[n12];
            if (bl2 && n12 != 0 && n7 + point.x > n) {
                ++n10;
                n7 = n5;
                n8 += n4 + n11;
            }
            if (bl) {
                ((ToolItem)object).setBounds(n7, n8, point.x, n11);
                boolean bl3 = n7 + point.x <= n && n8 + n11 <= n2;
                ((ToolItem)object).setVisible(bl3);
                Control control = ((ToolItem)object).control;
                if (control != null) {
                    control.setBounds(n7, n8, point.x, n11);
                }
            }
            n9 = Math.max(n9, n7 += n3 + point.x);
            ++n12;
        }
        return new int[]{n10, n9, n8 + n11};
    }

    int[] layoutUnified(int n, int n2, boolean bl) {
        Object object;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Point[] pointArray = new Point[this.itemCount];
        NSRect[] nSRectArray = new NSRect[this.itemCount];
        NSArray nSArray = new NSView(this.view.subviews().objectAtIndex(0L)).subviews();
        int n7 = 0;
        while (n7 < this.itemCount) {
            pointArray[n7] = this.items[n7].computeSize();
            object = pointArray[n7];
            nSRectArray[n7] = new NSView(nSArray.objectAtIndex(n7)).frame();
            if (n7 == 0) {
                n3 = (int)nSRectArray[0].x;
            }
            n5 = Math.max(n5, ((Point)object).y);
            ++n7;
        }
        n7 = 0;
        while (n7 < this.itemCount) {
            object = this.items[n7];
            Point point = pointArray[n7];
            if (bl) {
                ((ToolItem)object).setBounds(0, 0, point.x, n5);
                Control control = ((ToolItem)object).control;
                if (control != null) {
                    control.setBounds(n3, n4, point.x, n5);
                }
            }
            n3 = (int)((double)n3 + nSRectArray[n7].width);
            n6 = Math.max(n6, n3);
            ++n7;
        }
        return new int[]{1, n6, n5};
    }

    int[] layoutVertical(int n, int n2, boolean bl) {
        Object object;
        int n3 = 2;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n5;
        int n8 = n6;
        int n9 = 0;
        int n10 = 1;
        boolean bl2 = (this.style & 0x40) != 0;
        int n11 = 0;
        Point[] pointArray = new Point[this.itemCount];
        int n12 = 0;
        while (n12 < this.itemCount) {
            pointArray[n12] = this.items[n12].computeSize();
            object = pointArray[n12];
            n11 = Math.max(n11, ((Point)object).x);
            ++n12;
        }
        n12 = 0;
        while (n12 < this.itemCount) {
            object = this.items[n12];
            Point point = pointArray[n12];
            if (bl2 && n12 != 0 && n8 + point.y > n2) {
                ++n10;
                n7 += n3 + n11;
                n8 = n6;
            }
            if (bl) {
                ((ToolItem)object).setBounds(n7, n8, n11, point.y);
                boolean bl3 = n7 + n11 <= n && n8 + point.y <= n2;
                ((ToolItem)object).setVisible(bl3);
                Control control = ((ToolItem)object).control;
                if (control != null) {
                    control.setBounds(n7, n8, n11, point.y);
                }
            }
            n9 = Math.max(n9, n8 += n4 + point.y);
            ++n12;
        }
        return new int[]{n10, n7 + n11, n9};
    }

    int[] layout(int n, int n2, boolean bl) {
        if (this.nsToolbar != null) {
            return this.layoutUnified(n, n2, bl);
        }
        if ((this.style & 0x200) != 0) {
            return this.layoutVertical(n, n2, bl);
        }
        return this.layoutHorizontal(n, n2, bl);
    }

    void register() {
        super.register();
        if (this.nsToolbar != null) {
            this.display.addWidget(this.nsToolbar, this);
        }
    }

    void relayout() {
        if (!this.getDrawing()) {
            return;
        }
        Rectangle rectangle = this.getClientArea();
        this.layout(rectangle.width, rectangle.height, true);
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.itemCount) {
                ToolItem toolItem = this.items[n];
                if (toolItem != null && !toolItem.isDisposed()) {
                    toolItem.release(false);
                }
                ++n;
            }
            this.itemCount = 0;
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.nsToolbar != null) {
            this.nsToolbar.release();
            this.nsToolbar = null;
        }
        if (this.accessibilityAttributes != null) {
            this.accessibilityAttributes.release();
        }
        this.accessibilityAttributes = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if (toolItem.control == control) {
                toolItem.setControl(null);
            }
            ++n;
        }
    }

    void resized() {
        super.resized();
        this.relayout();
    }

    void reskinChildren(int n) {
        if (this.items != null) {
            int n2 = 0;
            while (n2 < this.items.length) {
                ToolItem toolItem = this.items[n2];
                if (toolItem != null) {
                    toolItem.reskin(n);
                }
                ++n2;
            }
        }
        super.reskinChildren(n);
    }

    boolean sendMouseEvent(NSEvent nSEvent, int n, boolean bl) {
        switch (n) {
            case 5: 
            case 6: {
                NSPoint nSPoint = NSEvent.mouseLocation();
                nSPoint = this.view.window().convertScreenToBase(nSPoint);
                int n2 = 0;
                while (n2 < this.itemCount) {
                    ToolItem toolItem = this.items[n2];
                    int n3 = toolItem.state;
                    NSPoint nSPoint2 = toolItem.view.convertPoint_fromView_(nSPoint, null);
                    toolItem.state = toolItem.view.mouse(nSPoint2, toolItem.view.bounds()) ? (toolItem.state |= 0x20) : (toolItem.state &= 0xFFFFFFDF);
                    if (n3 != toolItem.state) {
                        toolItem.updateImage(true);
                    }
                    ++n2;
                }
                break;
            }
            case 7: {
                int n4 = 0;
                while (n4 < this.itemCount) {
                    ToolItem toolItem = this.items[n4];
                    int n5 = toolItem.state;
                    toolItem.state &= 0xFFFFFFDF;
                    if (n5 != toolItem.state) {
                        toolItem.updateImage(true);
                    }
                    ++n4;
                }
                break;
            }
        }
        return super.sendMouseEvent(nSEvent, n, bl);
    }

    void setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (this.nsToolbar != null) {
            return;
        }
        super.setBounds(n, n2, n3, n4, bl, bl2);
    }

    void setFont(NSFont nSFont) {
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if (toolItem.button != null) {
                toolItem.button.setAttributedTitle(toolItem.createString());
            }
            ++n;
        }
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0) {
            this.relayout();
        }
    }

    public void setVisible(boolean bl) {
        if (this.nsToolbar != null) {
            this.nsToolbar.setVisible(bl);
        }
        super.setVisible(bl);
    }

    long toolbar_itemForItemIdentifier_willBeInsertedIntoToolbar(long l, long l2, long l3, long l4, boolean bl) {
        NSString nSString = new NSString(l4);
        int n = 0;
        while (n < this.itemCount) {
            ToolItem toolItem = this.items[n];
            if (nSString.isEqual(toolItem.nsItem.itemIdentifier())) {
                return toolItem.nsItem.id;
            }
            ++n;
        }
        return 0L;
    }

    long toolbarAllowedItemIdentifiers(long l, long l2, long l3) {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(this.itemCount);
        int n = 0;
        while (n < this.itemCount) {
            nSMutableArray.addObject(this.items[n].nsItem.itemIdentifier());
            ++n;
        }
        return nSMutableArray.id;
    }

    long toolbarDefaultItemIdentifiers(long l, long l2, long l3) {
        return this.toolbarAllowedItemIdentifiers(l, l2, l3);
    }

    long toolbarSelectableItemIdentifiers(long l, long l2, long l3) {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(this.itemCount);
        int n = 0;
        while (n < this.itemCount) {
            if ((this.items[n].style & 0x10) != 0) {
                nSMutableArray.addObject(this.items[n].nsItem.itemIdentifier());
            }
            ++n;
        }
        return nSMutableArray.id;
    }

    boolean translateTraversal(int n, NSEvent nSEvent, boolean[] blArray) {
        boolean bl = super.translateTraversal(n, nSEvent, blArray);
        if (bl) {
            return bl;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        switch (n) {
            case 123: {
                bl2 = false;
                break;
            }
            case 124: {
                bl2 = true;
                break;
            }
            case 126: {
                bl2 = false;
                bl3 = true;
                break;
            }
            case 125: {
                bl2 = true;
                bl3 = true;
                break;
            }
            default: {
                return false;
            }
        }
        blArray[0] = true;
        if (bl3 && this.lastFocus != null && this.lastFocus.handleKeyDown()) {
            return false;
        }
        ToolItem[] toolItemArray = this.getItems();
        ToolItem toolItem = this.lastFocus;
        int n2 = toolItemArray.length;
        int n3 = 0;
        while (n3 < n2) {
            if (toolItemArray[n3] == toolItem) break;
            ++n3;
        }
        if (n3 == n2) {
            return false;
        }
        int n4 = n3;
        int n5 = bl2 ? 1 : -1;
        while ((n3 = (n3 + n5 + n2) % n2) != n4) {
            ToolItem toolItem2 = toolItemArray[n3];
            if (toolItem2.isDisposed() || !toolItem2.setFocus()) continue;
            this.lastFocus = toolItem2;
            return false;
        }
        return false;
    }
}

