/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.io.Serializable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderLayout;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class CTabFolder
extends Composite {
    public int marginWidth = 0;
    public int marginHeight = 0;
    public int MIN_TAB_WIDTH = 4;
    public static RGB borderInsideRGB = new RGB(132, 130, 132);
    public static RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static RGB borderOutsideRGB = new RGB(171, 168, 165);
    boolean onBottom = false;
    boolean single = false;
    boolean simple = true;
    int fixedTabHeight = -1;
    int tabHeight;
    int minChars = 20;
    boolean borderVisible = false;
    CTabFolderRenderer renderer;
    CTabItem[] items = new CTabItem[0];
    int firstIndex = -1;
    int selectedIndex = -1;
    int[] priority = new int[0];
    boolean mru = false;
    Listener listener;
    boolean ignoreTraverse;
    CTabFolder2Listener[] folderListeners = new CTabFolder2Listener[0];
    CTabFolderListener[] tabListeners = new CTabFolderListener[0];
    Image selectionBgImage;
    Color[] selectionGradientColors;
    int[] selectionGradientPercents;
    boolean selectionGradientVertical;
    Color selectionForeground;
    Color selectionBackground;
    Color[] gradientColors;
    int[] gradientPercents;
    boolean gradientVertical;
    boolean showUnselectedImage = true;
    boolean showClose = false;
    boolean showUnselectedClose = true;
    boolean showMin = false;
    boolean minimized = false;
    boolean showMax = false;
    boolean maximized = false;
    ToolBar minMaxTb;
    ToolItem maxItem;
    ToolItem minItem;
    Image maxImage;
    Image minImage;
    boolean hoverTb;
    Rectangle hoverRect = new Rectangle(0, 0, 0, 0);
    boolean hovering;
    boolean hoverTimerRunning;
    boolean showChevron = false;
    Menu showMenu;
    ToolBar chevronTb;
    ToolItem chevronItem;
    Image chevronImage;
    int chevronCount;
    boolean chevronVisible = true;
    Control topRight;
    int topRightAlignment = 131072;
    boolean ignoreResize;
    Control[] controls;
    int[] controlAlignments;
    Rectangle[] controlRects;
    Image[] controlBkImages;
    boolean inDispose = false;
    Point oldSize;
    Font oldFont;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int SELECTION_FOREGROUND = 24;
    static final int SELECTION_BACKGROUND = 25;
    static final int FOREGROUND = 21;
    static final int BACKGROUND = 22;
    static final int SPACING = 3;

    public CTabFolder(Composite composite, int n) {
        super(composite, CTabFolder.checkStyle(composite, n));
        this.init(n);
    }

    void init(int n) {
        super.setLayout(new CTabFolderLayout());
        int n2 = super.getStyle();
        this.oldFont = this.getFont();
        this.onBottom = (n2 & 0x400) != 0;
        this.showClose = (n2 & 0x40) != 0;
        this.single = (n2 & 4) != 0;
        this.borderVisible = (n & 0x800) != 0;
        Display display = this.getDisplay();
        this.selectionForeground = display.getSystemColor(24);
        this.selectionBackground = display.getSystemColor(25);
        this.renderer = new CTabFolderRenderer(this);
        this.controls = new Control[0];
        this.controlAlignments = new int[0];
        this.controlRects = new Rectangle[0];
        this.controlBkImages = new Image[0];
        this.updateTabHeight(false);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        CTabFolder.this.onDispose(event);
                        break;
                    }
                    case 29: {
                        CTabFolder.this.onDragDetect(event);
                        break;
                    }
                    case 15: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 16: {
                        CTabFolder.this.onFocus(event);
                        break;
                    }
                    case 1: {
                        CTabFolder.this.onKeyDown(event);
                        break;
                    }
                    case 8: {
                        CTabFolder.this.onMouseDoubleClick(event);
                        break;
                    }
                    case 3: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 6: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 7: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 32: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 5: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 4: {
                        CTabFolder.this.onMouse(event);
                        break;
                    }
                    case 9: {
                        CTabFolder.this.onPaint(event);
                        break;
                    }
                    case 11: {
                        CTabFolder.this.onResize(event);
                        break;
                    }
                    case 31: {
                        CTabFolder.this.onTraverse(event);
                        break;
                    }
                    case 13: {
                        CTabFolder.this.onSelection(event);
                    }
                }
            }
        };
        int[] nArray = new int[]{12, 29, 15, 16, 1, 8, 3, 6, 7, 32, 5, 4, 9, 11, 31};
        int n3 = 0;
        while (n3 < nArray.length) {
            this.addListener(nArray[n3], this.listener);
            ++n3;
        }
        this.initAccessible();
    }

    static int checkStyle(Composite composite, int n) {
        int n2 = 109053126;
        if (((n &= n2) & 0x80) != 0) {
            n &= 0xFFFFFBFF;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        if (((n |= 0x100000) & 0x4000000) != 0) {
            return n;
        }
        if ((composite.getStyle() & 0x8000000) != 0 && (n & 0x2000000) == 0) {
            return n;
        }
        return n | 0x20000000;
    }

    public void addCTabFolder2Listener(CTabFolder2Listener cTabFolder2Listener) {
        this.checkWidget();
        if (cTabFolder2Listener == null) {
            SWT.error(4);
        }
        CTabFolder2Listener[] cTabFolder2ListenerArray = new CTabFolder2Listener[this.folderListeners.length + 1];
        System.arraycopy(this.folderListeners, 0, cTabFolder2ListenerArray, 0, this.folderListeners.length);
        this.folderListeners = cTabFolder2ListenerArray;
        this.folderListeners[this.folderListeners.length - 1] = cTabFolder2Listener;
    }

    public void addCTabFolderListener(CTabFolderListener cTabFolderListener) {
        this.checkWidget();
        if (cTabFolderListener == null) {
            SWT.error(4);
        }
        CTabFolderListener[] cTabFolderListenerArray = new CTabFolderListener[this.tabListeners.length + 1];
        System.arraycopy(this.tabListeners, 0, cTabFolderListenerArray, 0, this.tabListeners.length);
        this.tabListeners = cTabFolderListenerArray;
        this.tabListeners[this.tabListeners.length - 1] = cTabFolderListener;
        if (!this.showClose) {
            this.showClose = true;
            this.updateItems();
            this.redraw();
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    Rectangle[] computeControlBounds(Point point, boolean[][] blArray) {
        int n;
        int n2;
        Point point2;
        int n3;
        int n4;
        int n5;
        if (this.controls == null || this.controls.length == 0) {
            return new Rectangle[0];
        }
        Rectangle[] rectangleArray = new Rectangle[this.controls.length];
        int n6 = 0;
        while (n6 < rectangleArray.length) {
            rectangleArray[n6] = new Rectangle(0, 0, 0, 0);
            ++n6;
        }
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int n7 = rectangle.width + rectangle.x;
        int n8 = -rectangle.x;
        int n9 = rectangle.height + rectangle.y;
        int n10 = -rectangle.y;
        Point[] pointArray = new Point[this.controls.length];
        boolean[] blArray2 = new boolean[this.controls.length];
        int n11 = 0;
        int n12 = n8 + 3;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        while (n15 < this.controls.length) {
            pointArray[n15] = this.controls[n15].getVisible() ? this.controls[n15].computeSize(-1, -1) : new Point(0, 0);
            Point point3 = pointArray[n15];
            n5 = this.controlAlignments[n15];
            if ((n5 & 0x4000) != 0) {
                rectangleArray[n15].width = point3.x;
                rectangleArray[n15].height = this.getControlHeight(point3);
                rectangleArray[n15].x = n12;
                rectangleArray[n15].y = this.getControlY(point, rectangleArray, n9, n10, n15);
                n12 += point3.x;
                n11 += point3.x;
            } else {
                if ((n5 & 0x44) == 0) {
                    n13 += point3.x;
                }
                n14 += point3.x;
            }
            ++n15;
        }
        if (n11 > 0) {
            n11 += 6;
        }
        n15 = 0;
        int n16 = 0;
        while (n16 < this.items.length) {
            if (this.items[n16].showing) {
                n15 += this.items[n16].width;
            }
            ++n16;
        }
        n16 = point.x - n8 - n11 - n7;
        n5 = Math.max(0, n16 - n15 - n13);
        if (n13 > 0) {
            n5 -= 6;
        }
        n12 = point.x - n7 - 3;
        if (n15 + n14 <= n16) {
            n4 = 0;
            while (n4 < this.controls.length) {
                n3 = this.controlAlignments[n4];
                if ((n3 & 0x20000) != 0) {
                    point2 = pointArray[n4];
                    rectangleArray[n4].width = point2.x;
                    rectangleArray[n4].height = this.getControlHeight(point2);
                    rectangleArray[n4].x = n12 -= point2.x;
                    rectangleArray[n4].y = this.getControlY(point, rectangleArray, n9, n10, n4);
                    if ((n3 & 0x44) != 0) {
                        n5 -= point2.x;
                    }
                }
                ++n4;
            }
        } else {
            n4 = 0;
            while (n4 < this.controls.length) {
                n3 = this.controlAlignments[n4];
                point2 = pointArray[n4];
                if ((n3 & 0x20000) != 0) {
                    if ((n3 & 0x44) == 0) {
                        rectangleArray[n4].width = point2.x;
                        rectangleArray[n4].height = this.getControlHeight(point2);
                        rectangleArray[n4].x = n12 -= point2.x;
                        rectangleArray[n4].y = this.getControlY(point, rectangleArray, n9, n10, n4);
                    } else if ((n3 & 0x40) != 0 && point2.x < n5) {
                        rectangleArray[n4].width = point2.x;
                        rectangleArray[n4].height = this.getControlHeight(point2);
                        rectangleArray[n4].x = n12 -= point2.x;
                        rectangleArray[n4].y = this.getControlY(point, rectangleArray, n9, n10, n4);
                        n5 -= point2.x;
                    } else if ((n3 & 4) != 0 && (n3 & 0x40) == 0) {
                        rectangleArray[n4].width = 0;
                        rectangleArray[n4].height = this.getControlHeight(point2);
                        rectangleArray[n4].x = n12;
                        rectangleArray[n4].y = this.getControlY(point, rectangleArray, n9, n10, n4);
                    } else if ((n3 & 0x40) != 0) {
                        blArray2[n4] = true;
                    }
                }
                ++n4;
            }
        }
        if (n5 > 0) {
            n4 = 0;
            n3 = 0;
            while (n3 < this.controls.length) {
                int n17 = this.controlAlignments[n3];
                if ((n17 & 0x20000) != 0 && (n17 & 4) != 0 && !blArray2[n3]) {
                    ++n4;
                }
                ++n3;
            }
            if (n4 != 0) {
                n3 = n5 / n4;
                int n18 = 0;
                n2 = 0;
                while (n2 < this.controls.length) {
                    n = this.controlAlignments[n2];
                    if ((n & 0x20000) != 0) {
                        if ((n & 4) != 0 && !blArray2[n2]) {
                            rectangleArray[n2].width += n3;
                            n18 += n3;
                        }
                        if (!blArray2[n2]) {
                            rectangleArray[n2].x -= n18;
                        }
                    }
                    ++n2;
                }
            }
        }
        Rectangle rectangle2 = this.renderer.computeTrim(-1, 0, 0, 0, 0, 0);
        n3 = rectangle2.width + rectangle2.x;
        int n19 = -rectangle2.x;
        n2 = point.x - n19 - n3;
        n12 = point.x - n3;
        n = -rectangle2.y;
        n5 = n2;
        int n20 = 0;
        int n21 = 0;
        while (n21 < this.controls.length) {
            Point point4 = pointArray[n21];
            if (blArray2[n21]) {
                if (n5 > point4.x) {
                    rectangleArray[n21].width = point4.x;
                    rectangleArray[n21].y = n;
                    rectangleArray[n21].height = point4.y;
                    rectangleArray[n21].x = n12 -= point4.x;
                    n5 -= point4.x;
                    n20 = Math.max(n20, point4.y);
                } else {
                    n12 = point.x - n3;
                    n += n20;
                    n20 = 0;
                    n5 = n2;
                    if (n5 > point4.x) {
                        --n21;
                    } else {
                        point4 = this.controls[n21].computeSize(n2, -1);
                        rectangleArray[n21].width = n2;
                        rectangleArray[n21].y = n;
                        rectangleArray[n21].height = point4.y;
                        rectangleArray[n21].x = point.x - point4.x - n3;
                        n += point4.y;
                    }
                }
            }
            ++n21;
        }
        if (this.showChevron) {
            n21 = 0;
            int n22 = -1;
            while (n21 < this.priority.length && this.items[this.priority[n21]].showing) {
                n22 = Math.max(n22, this.priority[n21++]);
            }
            if (n22 == -1) {
                n22 = this.selectedIndex;
            }
            if (n22 != -1) {
                CTabItem cTabItem = this.items[n22];
                int n23 = cTabItem.x + cTabItem.width + 3;
                if (!this.simple && n22 == this.selectedIndex) {
                    n23 -= this.renderer.curveIndent - 7;
                }
                rectangleArray[this.controls.length - 1].x = n23;
            }
        }
        if (blArray != null) {
            blArray[0] = blArray2;
        }
        return rectangleArray;
    }

    int getControlHeight(Point point) {
        return this.fixedTabHeight == -1 ? Math.max(this.tabHeight - 1, point.y) : point.y;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = this.renderer.computeTrim(-1, 0, n, n2, n3, n4);
        Point point = new Point(n3, n4);
        int n5 = this.getWrappedHeight(point);
        if (this.onBottom) {
            rectangle.height += n5;
        } else {
            rectangle.y -= n5;
            rectangle.height += n5;
        }
        return rectangle;
    }

    Image createButtonImage(Display display, int n) {
        Point point = this.renderer.computeSize(n, 0, null, -1, -1);
        Rectangle rectangle = this.renderer.computeTrim(n, 0, 0, 0, 0, 0);
        Image image = new Image((Device)display, point.x - rectangle.width, point.y - rectangle.height);
        GC gC = new GC(image);
        RGB rGB = n == -7 ? new RGB(255, 255, 255) : new RGB(253, 0, 0);
        Color color = new Color(display, rGB);
        gC.setBackground(color);
        gC.fillRectangle(image.getBounds());
        this.renderer.draw(n, 0, new Rectangle(rectangle.x, rectangle.y, point.x, point.y), gC);
        gC.dispose();
        color.dispose();
        ImageData imageData = image.getImageData();
        imageData.transparentPixel = imageData.palette.getPixel(rGB);
        image.dispose();
        image = new Image((Device)display, imageData);
        return image;
    }

    void createItem(CTabItem cTabItem, int n) {
        if (n < 0 || n > this.getItemCount()) {
            SWT.error(6);
        }
        cTabItem.parent = this;
        CTabItem[] cTabItemArray = new CTabItem[this.items.length + 1];
        System.arraycopy(this.items, 0, cTabItemArray, 0, n);
        cTabItemArray[n] = cTabItem;
        System.arraycopy(this.items, n, cTabItemArray, n + 1, this.items.length - n);
        this.items = cTabItemArray;
        if (this.selectedIndex >= n) {
            ++this.selectedIndex;
        }
        int[] nArray = new int[this.priority.length + 1];
        int n2 = 0;
        int n3 = this.priority.length;
        int n4 = 0;
        while (n4 < this.priority.length) {
            if (!this.mru && (this.priority[n4] == n || this.priority[n4] == 0 && n + 1 == this.items.length)) {
                n3 = n2++;
            }
            nArray[n2++] = this.priority[n4] >= n ? this.priority[n4] + 1 : this.priority[n4];
            ++n4;
        }
        nArray[n3] = n;
        this.priority = nArray;
        if (this.items.length == 1) {
            if (!this.updateTabHeight(false)) {
                this.updateItems();
            }
            this.redraw();
        } else {
            this.updateItems();
            this.redrawTabs();
        }
    }

    void destroyItem(CTabItem cTabItem) {
        if (this.inDispose) {
            return;
        }
        int n = this.indexOf(cTabItem);
        if (n == -1) {
            return;
        }
        if (this.items.length == 1) {
            this.items = new CTabItem[0];
            this.priority = new int[0];
            this.firstIndex = -1;
            this.selectedIndex = -1;
            Control control = cTabItem.getControl();
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
            this.setToolTipText(null);
            GC gC = new GC(this);
            this.setButtonBounds(gC);
            gC.dispose();
            this.redraw();
            return;
        }
        CTabItem[] cTabItemArray = new CTabItem[this.items.length - 1];
        System.arraycopy(this.items, 0, cTabItemArray, 0, n);
        System.arraycopy(this.items, n + 1, cTabItemArray, n, this.items.length - n - 1);
        this.items = cTabItemArray;
        int[] nArray = new int[this.priority.length - 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.priority.length) {
            if (this.priority[n3] != n) {
                nArray[n2++] = this.priority[n3] > n ? this.priority[n3] - 1 : this.priority[n3];
            }
            ++n3;
        }
        this.priority = nArray;
        if (this.selectedIndex == n) {
            Control control = cTabItem.getControl();
            this.selectedIndex = -1;
            int n4 = this.mru ? this.priority[0] : Math.max(0, n - 1);
            this.setSelection(n4, true);
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        } else if (this.selectedIndex > n) {
            --this.selectedIndex;
        }
        this.updateItems();
        this.redrawTabs();
    }

    public boolean getBorderVisible() {
        this.checkWidget();
        return this.borderVisible;
    }

    ToolBar getChevron() {
        if (this.chevronTb == null) {
            this.chevronTb = new ToolBar(this, 0x800000);
            this.initAccessibleChevronTb();
            this.addTabControl(this.chevronTb, 131072, -1, false);
        }
        if (this.chevronItem == null) {
            this.chevronItem = new ToolItem(this.chevronTb, 8);
            this.chevronItem.setToolTipText(SWT.getMessage("SWT_ShowList"));
            this.chevronItem.addListener(13, this.listener);
        }
        return this.chevronTb;
    }

    boolean getChevronVisible() {
        this.checkWidget();
        return this.chevronVisible;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle rectangle = this.renderer.computeTrim(-1, 4, 0, 0, 0, 0);
        Point point = this.getSize();
        int n = this.getWrappedHeight(point);
        if (this.onBottom) {
            rectangle.height += n;
        } else {
            rectangle.y -= n;
            rectangle.height += n;
        }
        if (this.minimized) {
            return new Rectangle(-rectangle.x, -rectangle.y, 0, 0);
        }
        int n2 = point.x - rectangle.width;
        int n3 = point.y - rectangle.height;
        return new Rectangle(-rectangle.x, -rectangle.y, n2, n3);
    }

    public CTabItem getItem(int n) {
        if (n < 0 || n >= this.items.length) {
            SWT.error(6);
        }
        return this.items[n];
    }

    public CTabItem getItem(Point point) {
        if (this.items.length == 0) {
            return null;
        }
        Point point2 = this.getSize();
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        if (point2.x <= rectangle.width) {
            return null;
        }
        int n = 0;
        while (n < this.priority.length) {
            CTabItem cTabItem = this.items[this.priority[n]];
            Rectangle rectangle2 = cTabItem.getBounds();
            if (rectangle2.contains(point)) {
                return cTabItem;
            }
            ++n;
        }
        return null;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public CTabItem[] getItems() {
        CTabItem[] cTabItemArray = new CTabItem[this.items.length];
        System.arraycopy(this.items, 0, cTabItemArray, 0, this.items.length);
        return cTabItemArray;
    }

    int getLeftItemEdge(GC gC, int n) {
        Rectangle rectangle = this.renderer.computeTrim(n, 0, 0, 0, 0, 0);
        int n2 = -rectangle.x;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.controls.length) {
            if ((this.controlAlignments[n4] & 0x4000) != 0 && this.controls[n4].getVisible()) {
                n3 += this.controls[n4].computeSize((int)-1, (int)-1).x;
            }
            ++n4;
        }
        if (n3 != 0) {
            n3 += 6;
        }
        return Math.max(0, n2 += n3);
    }

    char _findMnemonic(String string) {
        if (string == null) {
            return '\u0000';
        }
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return Character.toLowerCase(string.charAt(n));
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    String stripMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return string;
            }
            if (string.charAt(n) != '&') {
                return String.valueOf(string.substring(0, n - 1)) + string.substring(n, n2);
            }
            if (++n >= n2) break;
        }
        return string;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    public boolean getMinimizeVisible() {
        this.checkWidget();
        return this.showMin;
    }

    public int getMinimumCharacters() {
        this.checkWidget();
        return this.minChars;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public boolean getMaximizeVisible() {
        this.checkWidget();
        return this.showMax;
    }

    public boolean getMRUVisible() {
        this.checkWidget();
        return this.mru;
    }

    public CTabFolderRenderer getRenderer() {
        this.checkWidget();
        return this.renderer;
    }

    int getRightItemEdge(GC gC) {
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int n = this.getSize().x - (rectangle.width + rectangle.x);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.controls.length) {
            int n4 = this.controlAlignments[n3];
            if ((n4 & 0x40) == 0 && (n4 & 0x4000) == 0 && this.controls[n3].getVisible()) {
                Point point = this.controls[n3].computeSize(-1, -1);
                n2 += point.x;
            }
            ++n3;
        }
        if (n2 != 0) {
            n2 += 6;
        }
        return Math.max(0, n -= n2);
    }

    public CTabItem getSelection() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.items[this.selectedIndex];
    }

    public Color getSelectionBackground() {
        this.checkWidget();
        return this.selectionBackground;
    }

    public Color getSelectionForeground() {
        this.checkWidget();
        return this.selectionForeground;
    }

    public int getSelectionIndex() {
        return this.selectedIndex;
    }

    public boolean getSimple() {
        this.checkWidget();
        return this.simple;
    }

    public boolean getSingle() {
        this.checkWidget();
        return this.single;
    }

    public int getStyle() {
        int n = super.getStyle();
        n &= 0xFFFFFB7F;
        n |= this.onBottom ? 1024 : 128;
        n &= 0xFFFFFFF9;
        n |= this.single ? 4 : 2;
        if (this.borderVisible) {
            n |= 0x800;
        }
        n &= 0xFFFFFFBF;
        if (this.showClose) {
            n |= 0x40;
        }
        return n;
    }

    public int getTabHeight() {
        this.checkWidget();
        if (this.fixedTabHeight != -1) {
            return this.fixedTabHeight;
        }
        return this.tabHeight - 1;
    }

    public int getTabPosition() {
        this.checkWidget();
        return this.onBottom ? 1024 : 128;
    }

    public Control getTopRight() {
        this.checkWidget();
        return this.topRight;
    }

    public int getTopRightAlignment() {
        this.checkWidget();
        return this.topRightAlignment;
    }

    public boolean getUnselectedCloseVisible() {
        this.checkWidget();
        return this.showUnselectedClose;
    }

    public boolean getUnselectedImageVisible() {
        this.checkWidget();
        return this.showUnselectedImage;
    }

    public int indexOf(CTabItem cTabItem) {
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        int n = 0;
        while (n < this.items.length) {
            if (this.items[n] == cTabItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                String string = null;
                int n = accessibleEvent.childID;
                if (n >= 0 && n < CTabFolder.this.items.length) {
                    string = CTabFolder.this.stripMnemonic(CTabFolder.this.items[n].getText());
                }
                accessibleEvent.result = string;
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                String string = null;
                int n = accessibleEvent.childID;
                if (n == -1) {
                    string = CTabFolder.this.getToolTipText();
                } else if (n >= 0 && n < CTabFolder.this.items.length) {
                    string = CTabFolder.this.items[n].getToolTipText();
                }
                accessibleEvent.result = string;
            }

            public void getKeyboardShortcut(AccessibleEvent accessibleEvent) {
                char c;
                String string;
                String string2 = null;
                int n = accessibleEvent.childID;
                if (n >= 0 && n < CTabFolder.this.items.length && (string = CTabFolder.this.items[n].getText()) != null && (c = CTabFolder.this._findMnemonic(string)) != '\u0000') {
                    string2 = SWT.getMessage("SWT_Page_Mnemonic", new Object[]{new Character(c)});
                }
                if (n == -1) {
                    string2 = SWT.getMessage("SWT_SwitchPage_Shortcut");
                }
                accessibleEvent.result = string2;
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                Point point = CTabFolder.this.toControl(accessibleControlEvent.x, accessibleControlEvent.y);
                int n = -2;
                int n2 = 0;
                while (n2 < CTabFolder.this.items.length) {
                    if (CTabFolder.this.items[n2].getBounds().contains(point)) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
                if (n == -2) {
                    Rectangle rectangle = CTabFolder.this.getBounds();
                    rectangle.y = 0;
                    rectangle.x = 0;
                    rectangle.height -= CTabFolder.this.getClientArea().height;
                    if (rectangle.contains(point)) {
                        n = -1;
                    }
                }
                accessibleControlEvent.childID = n;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = null;
                Point point = null;
                int n = accessibleControlEvent.childID;
                if (n == -1) {
                    rectangle = CTabFolder.this.getBounds();
                    point = CTabFolder.this.getParent().toDisplay(rectangle.x, rectangle.y);
                } else {
                    if (n >= 0 && n < CTabFolder.this.items.length && CTabFolder.this.items[n].isShowing()) {
                        rectangle = CTabFolder.this.items[n].getBounds();
                    }
                    if (rectangle != null) {
                        point = CTabFolder.this.toDisplay(rectangle.x, rectangle.y);
                    }
                }
                if (rectangle != null && point != null) {
                    accessibleControlEvent.x = point.x;
                    accessibleControlEvent.y = point.y;
                    accessibleControlEvent.width = rectangle.width;
                    accessibleControlEvent.height = rectangle.height;
                }
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = CTabFolder.this.items.length;
            }

            public void getDefaultAction(AccessibleControlEvent accessibleControlEvent) {
                String string = null;
                int n = accessibleControlEvent.childID;
                if (n >= 0 && n < CTabFolder.this.items.length) {
                    string = SWT.getMessage("SWT_Switch");
                }
                accessibleControlEvent.result = string;
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                int n = -2;
                if (CTabFolder.this.isFocusControl()) {
                    n = CTabFolder.this.selectedIndex == -1 ? -1 : CTabFolder.this.selectedIndex;
                }
                accessibleControlEvent.childID = n;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                int n = 0;
                int n2 = accessibleControlEvent.childID;
                if (n2 == -1) {
                    n = 60;
                } else if (n2 >= 0 && n2 < CTabFolder.this.items.length) {
                    n = 37;
                }
                accessibleControlEvent.detail = n;
            }

            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = CTabFolder.this.selectedIndex == -1 ? -2 : CTabFolder.this.selectedIndex;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                int n = 0;
                int n2 = accessibleControlEvent.childID;
                if (n2 == -1) {
                    n = 0;
                } else if (n2 >= 0 && n2 < CTabFolder.this.items.length) {
                    n = 0x200000;
                    if (CTabFolder.this.isFocusControl()) {
                        n |= 0x100000;
                    }
                    if (CTabFolder.this.selectedIndex == n2) {
                        n |= 2;
                        if (CTabFolder.this.isFocusControl()) {
                            n |= 4;
                        }
                    }
                }
                accessibleControlEvent.detail = n;
            }

            public void getChildren(AccessibleControlEvent accessibleControlEvent) {
                int n = CTabFolder.this.items.length;
                Object[] objectArray = new Object[n];
                int n2 = 0;
                while (n2 < n) {
                    objectArray[n2] = new Integer(n2);
                    ++n2;
                }
                accessibleControlEvent.children = objectArray;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.isFocusControl()) {
                    if (CTabFolder.this.selectedIndex == -1) {
                        accessible.setFocus(-1);
                    } else {
                        accessible.setFocus(CTabFolder.this.selectedIndex);
                    }
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                if (CTabFolder.this.selectedIndex == -1) {
                    accessible.setFocus(-1);
                } else {
                    accessible.setFocus(CTabFolder.this.selectedIndex);
                }
            }
        });
    }

    void initAccessibleMinMaxTb() {
        this.minMaxTb.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                if (accessibleEvent.childID != -1) {
                    if (CTabFolder.this.minItem != null && accessibleEvent.childID == CTabFolder.this.minMaxTb.indexOf(CTabFolder.this.minItem)) {
                        accessibleEvent.result = CTabFolder.this.minItem.getToolTipText();
                    } else if (CTabFolder.this.maxItem != null && accessibleEvent.childID == CTabFolder.this.minMaxTb.indexOf(CTabFolder.this.maxItem)) {
                        accessibleEvent.result = CTabFolder.this.maxItem.getToolTipText();
                    }
                }
            }
        });
    }

    void initAccessibleChevronTb() {
        this.chevronTb.getAccessible().addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                if (accessibleEvent.childID != -1 && CTabFolder.this.chevronItem != null && accessibleEvent.childID == CTabFolder.this.chevronTb.indexOf(CTabFolder.this.chevronItem)) {
                    accessibleEvent.result = CTabFolder.this.chevronItem.getToolTipText();
                }
            }
        });
    }

    void onKeyDown(Event event) {
        switch (event.keyCode) {
            case 0x1000003: 
            case 0x1000004: {
                int n;
                int n2;
                int n3 = this.items.length;
                if (n3 == 0) {
                    return;
                }
                if (this.selectedIndex == -1) {
                    return;
                }
                int n4 = (this.getStyle() & 0x4000000) != 0 ? 0x1000004 : 0x1000003;
                int n5 = n2 = event.keyCode == n4 ? -1 : 1;
                if (!this.mru) {
                    n = this.selectedIndex + n2;
                } else {
                    int[] nArray = new int[this.items.length];
                    int n6 = 0;
                    int n7 = -1;
                    int n8 = 0;
                    while (n8 < this.items.length) {
                        if (this.items[n8].showing) {
                            if (n8 == this.selectedIndex) {
                                n7 = n6;
                            }
                            nArray[n6++] = n8;
                        }
                        ++n8;
                    }
                    if (n7 + n2 >= 0 && n7 + n2 < n6) {
                        n = nArray[n7 + n2];
                    } else {
                        if (this.showChevron) {
                            Rectangle rectangle = this.chevronItem.getBounds();
                            rectangle = event.display.map((Control)this.chevronTb, (Control)this, rectangle);
                            CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                            cTabFolderEvent.widget = this;
                            cTabFolderEvent.time = event.time;
                            cTabFolderEvent.x = rectangle.x;
                            cTabFolderEvent.y = rectangle.y;
                            cTabFolderEvent.width = rectangle.width;
                            cTabFolderEvent.height = rectangle.height;
                            cTabFolderEvent.doit = true;
                            int n9 = 0;
                            while (n9 < this.folderListeners.length) {
                                this.folderListeners[n9].showList(cTabFolderEvent);
                                ++n9;
                            }
                            if (cTabFolderEvent.doit && !this.isDisposed()) {
                                this.showList(rectangle);
                            }
                        }
                        return;
                    }
                }
                if (n < 0 || n >= n3) {
                    return;
                }
                this.setSelection(n, true);
                this.forceFocus();
            }
        }
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        if (this.showMenu != null && !this.showMenu.isDisposed()) {
            this.showMenu.dispose();
            this.showMenu = null;
        }
        int n = this.items.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.items[n2] != null) {
                this.items[n2].dispose();
            }
            ++n2;
        }
        this.selectionGradientColors = null;
        this.selectionGradientPercents = null;
        this.selectionBgImage = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        if (this.controlBkImages != null) {
            n2 = 0;
            while (n2 < this.controlBkImages.length) {
                if (this.controlBkImages[n2] != null) {
                    this.controlBkImages[n2].dispose();
                    this.controlBkImages[n2] = null;
                }
                ++n2;
            }
            this.controlBkImages = null;
        }
        this.controls = null;
        this.controlAlignments = null;
        this.controlRects = null;
        if (this.maxImage != null) {
            this.maxImage.dispose();
        }
        this.maxImage = null;
        if (this.minImage != null) {
            this.minImage.dispose();
        }
        this.minImage = null;
        if (this.chevronImage != null) {
            this.chevronImage.dispose();
        }
        this.chevronImage = null;
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        this.renderer = null;
    }

    void onDragDetect(Event event) {
        boolean bl = false;
        int n = 0;
        while (n < this.items.length) {
            if (this.items[n].closeRect.contains(event.x, event.y)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            event.type = 0;
        }
    }

    void onFocus(Event event) {
        this.checkWidget();
        if (this.selectedIndex >= 0) {
            this.redraw();
        } else {
            this.setSelection(0, true);
        }
    }

    boolean onMnemonic(Event event, boolean bl) {
        char c = event.character;
        int n = 0;
        while (n < this.items.length) {
            char c2;
            if (this.items[n] != null && (c2 = this._findMnemonic(this.items[n].getText())) != '\u0000' && Character.toLowerCase(c) == c2) {
                if (bl) {
                    this.setSelection(n, true);
                    this.forceFocus();
                }
                return true;
            }
            ++n;
        }
        return false;
    }

    void onMouseDoubleClick(Event event) {
        if (event.button != 1 || (event.stateMask & 0x100000) != 0 || (event.stateMask & 0x200000) != 0) {
            return;
        }
        Event event2 = new Event();
        event2.item = this.getItem(new Point(event.x, event.y));
        if (event2.item != null) {
            this.notifyListeners(14, event2);
        }
    }

    void onMouse(Event event) {
        if (this.isDisposed()) {
            return;
        }
        int n = event.x;
        int n2 = event.y;
        switch (event.type) {
            case 6: {
                this.setToolTipText(null);
                break;
            }
            case 7: {
                int n3 = 0;
                while (n3 < this.items.length) {
                    CTabItem cTabItem = this.items[n3];
                    if (n3 != this.selectedIndex && cTabItem.closeImageState != 8) {
                        cTabItem.closeImageState = 8;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    if ((cTabItem.state & 0x20) != 0) {
                        cTabItem.state &= 0xFFFFFFDF;
                        this.redraw(cTabItem.x, cTabItem.y, cTabItem.width, cTabItem.height, false);
                    }
                    if (n3 == this.selectedIndex && cTabItem.closeImageState != 0) {
                        cTabItem.closeImageState = 0;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    ++n3;
                }
                break;
            }
            case 3: 
            case 32: {
                if (this.hoverTb && this.hoverRect.contains(n, n2) && !this.hovering) {
                    this.hovering = true;
                    this.updateItems();
                    this.hoverTimerRunning = true;
                    event.display.timerExec(2000, new Runnable(){

                        public void run() {
                            if (CTabFolder.this.isDisposed()) {
                                return;
                            }
                            if (CTabFolder.this.hovering) {
                                Display display = CTabFolder.this.getDisplay();
                                Control control = display.getCursorControl();
                                boolean bl = false;
                                if (control != null) {
                                    int n = 0;
                                    while (n < CTabFolder.this.controls.length) {
                                        Control control2 = control;
                                        do {
                                            if (control2.equals(CTabFolder.this.controls[n])) {
                                                bl = true;
                                                continue;
                                            }
                                            if ((control2 = control2.getParent()) == null || control2.equals(CTabFolder.this)) break;
                                        } while (!bl);
                                        if (bl) break;
                                        ++n;
                                    }
                                }
                                if (bl && CTabFolder.this.hoverTimerRunning) {
                                    display.timerExec(2000, this);
                                } else {
                                    CTabFolder.this.hovering = false;
                                    CTabFolder.this.updateItems();
                                }
                            }
                        }
                    });
                    return;
                }
                if (event.button != 1) {
                    return;
                }
                CTabItem cTabItem = null;
                if (this.single) {
                    Rectangle rectangle;
                    if (this.selectedIndex != -1 && (rectangle = this.items[this.selectedIndex].getBounds()).contains(n, n2)) {
                        cTabItem = this.items[this.selectedIndex];
                    }
                } else {
                    int n4 = 0;
                    while (n4 < this.items.length) {
                        Rectangle rectangle = this.items[n4].getBounds();
                        if (rectangle.contains(n, n2)) {
                            cTabItem = this.items[n4];
                        }
                        ++n4;
                    }
                }
                if (cTabItem == null) break;
                if (cTabItem.closeRect.contains(n, n2)) {
                    cTabItem.closeImageState = 2;
                    this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    this.update();
                    return;
                }
                int n5 = this.indexOf(cTabItem);
                if (cTabItem.showing) {
                    int n6 = this.selectedIndex;
                    this.setSelection(n5, true);
                    if (n6 == this.selectedIndex) {
                        this.forceFocus();
                    }
                }
                return;
            }
            case 5: {
                this._setToolTipText(event.x, event.y);
                boolean bl = false;
                int n7 = 0;
                while (n7 < this.items.length) {
                    CTabItem cTabItem = this.items[n7];
                    bl = false;
                    if (cTabItem.getBounds().contains(n, n2)) {
                        bl = true;
                        if (cTabItem.closeRect.contains(n, n2)) {
                            if (cTabItem.closeImageState != 2 && cTabItem.closeImageState != 32) {
                                cTabItem.closeImageState = 32;
                                this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                            }
                        } else if (cTabItem.closeImageState != 0) {
                            cTabItem.closeImageState = 0;
                            this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                        }
                        if ((cTabItem.state & 0x20) == 0) {
                            cTabItem.state |= 0x20;
                            this.redraw(cTabItem.x, cTabItem.y, cTabItem.width, cTabItem.height, false);
                        }
                    }
                    if (n7 != this.selectedIndex && cTabItem.closeImageState != 8 && !bl) {
                        cTabItem.closeImageState = 8;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    if ((cTabItem.state & 0x20) != 0 && !bl) {
                        cTabItem.state &= 0xFFFFFFDF;
                        this.redraw(cTabItem.x, cTabItem.y, cTabItem.width, cTabItem.height, false);
                    }
                    if (n7 == this.selectedIndex && cTabItem.closeImageState != 0 && !bl) {
                        cTabItem.closeImageState = 0;
                        this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                    }
                    ++n7;
                }
                break;
            }
            case 4: {
                Object object;
                Serializable serializable;
                if (event.button != 1) {
                    return;
                }
                CTabItem cTabItem = null;
                if (this.single) {
                    Rectangle rectangle;
                    if (this.selectedIndex != -1 && (rectangle = this.items[this.selectedIndex].getBounds()).contains(n, n2)) {
                        cTabItem = this.items[this.selectedIndex];
                    }
                } else {
                    int n8 = 0;
                    while (n8 < this.items.length) {
                        serializable = this.items[n8].getBounds();
                        if (serializable.contains(n, n2)) {
                            cTabItem = this.items[n8];
                        }
                        ++n8;
                    }
                }
                if (cTabItem == null || !cTabItem.closeRect.contains(n, n2)) break;
                boolean bl = cTabItem.closeImageState == 2;
                cTabItem.closeImageState = 32;
                this.redraw(cTabItem.closeRect.x, cTabItem.closeRect.y, cTabItem.closeRect.width, cTabItem.closeRect.height, false);
                if (!bl) {
                    return;
                }
                serializable = new CTabFolderEvent(this);
                ((CTabFolderEvent)serializable).widget = this;
                ((CTabFolderEvent)serializable).time = event.time;
                ((CTabFolderEvent)serializable).item = cTabItem;
                ((CTabFolderEvent)serializable).doit = true;
                int n9 = 0;
                while (n9 < this.folderListeners.length) {
                    object = this.folderListeners[n9];
                    object.close((CTabFolderEvent)serializable);
                    ++n9;
                }
                n9 = 0;
                while (n9 < this.tabListeners.length) {
                    object = this.tabListeners[n9];
                    object.itemClosed((CTabFolderEvent)serializable);
                    ++n9;
                }
                if (((CTabFolderEvent)serializable).doit) {
                    cTabItem.dispose();
                }
                if (!this.isDisposed() && cTabItem.isDisposed()) {
                    Display display = this.getDisplay();
                    object = display.getCursorLocation();
                    object = display.map(null, this, ((Point)object).x, ((Point)object).y);
                    CTabItem cTabItem2 = this.getItem((Point)object);
                    if (cTabItem2 != null) {
                        if (cTabItem2.closeRect.contains((Point)object)) {
                            if (cTabItem2.closeImageState != 2 && cTabItem2.closeImageState != 32) {
                                cTabItem2.closeImageState = 32;
                                this.redraw(cTabItem2.closeRect.x, cTabItem2.closeRect.y, cTabItem2.closeRect.width, cTabItem2.closeRect.height, false);
                            }
                        } else if (cTabItem2.closeImageState != 0) {
                            cTabItem2.closeImageState = 0;
                            this.redraw(cTabItem2.closeRect.x, cTabItem2.closeRect.y, cTabItem2.closeRect.width, cTabItem2.closeRect.height, false);
                        }
                    }
                }
                return;
            }
        }
    }

    void onPageTraversal(Event event) {
        int n = this.items.length;
        if (n == 0) {
            return;
        }
        int n2 = this.selectedIndex;
        if (n2 == -1) {
            n2 = 0;
        } else {
            int n3;
            int n4 = n3 = event.detail == 512 ? 1 : -1;
            if (!this.mru) {
                n2 = (this.selectedIndex + n3 + n) % n;
            } else {
                int[] nArray = new int[this.items.length];
                int n5 = 0;
                int n6 = -1;
                int n7 = 0;
                while (n7 < this.items.length) {
                    if (this.items[n7].showing) {
                        if (n7 == this.selectedIndex) {
                            n6 = n5;
                        }
                        nArray[n5++] = n7;
                    }
                    ++n7;
                }
                if (n6 + n3 >= 0 && n6 + n3 < n5) {
                    n2 = nArray[n6 + n3];
                } else if (this.showChevron) {
                    Rectangle rectangle = this.chevronItem.getBounds();
                    rectangle = event.display.map((Control)this.chevronTb, (Control)this, rectangle);
                    CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
                    cTabFolderEvent.widget = this;
                    cTabFolderEvent.time = event.time;
                    cTabFolderEvent.x = rectangle.x;
                    cTabFolderEvent.y = rectangle.y;
                    cTabFolderEvent.width = rectangle.width;
                    cTabFolderEvent.height = rectangle.height;
                    cTabFolderEvent.doit = true;
                    int n8 = 0;
                    while (n8 < this.folderListeners.length) {
                        this.folderListeners[n8].showList(cTabFolderEvent);
                        ++n8;
                    }
                    if (cTabFolderEvent.doit && !this.isDisposed()) {
                        this.showList(rectangle);
                    }
                }
            }
        }
        this.setSelection(n2, true);
    }

    void onPaint(Event event) {
        if (this.inDispose) {
            return;
        }
        Font font = this.getFont();
        if (this.oldFont == null || !this.oldFont.equals(font)) {
            this.oldFont = font;
            if (!this.updateTabHeight(false)) {
                this.updateItems();
                this.redraw();
                return;
            }
        }
        GC gC = event.gc;
        Font font2 = gC.getFont();
        Color color = gC.getBackground();
        Color color2 = gC.getForeground();
        Point point = this.getSize();
        Rectangle rectangle = new Rectangle(0, 0, point.x, point.y);
        this.renderer.draw(-1, 24, rectangle, gC);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        this.renderer.draw(-2, 24, rectangle, gC);
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        if (!this.single) {
            int n = 0;
            while (n < this.items.length) {
                Rectangle rectangle2 = this.items[n].getBounds();
                if (n != this.selectedIndex && event.getBounds().intersects(rectangle2)) {
                    this.renderer.draw(n, 0x18 | this.items[n].state, rectangle2, gC);
                }
                ++n;
            }
        }
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        if (this.selectedIndex != -1) {
            this.renderer.draw(this.selectedIndex, this.items[this.selectedIndex].state | 8 | 0x10, this.items[this.selectedIndex].getBounds(), gC);
        }
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
        if (this.hoverTb) {
            Rectangle rectangle3 = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
            int n = this.getSize().x - (rectangle3.width + rectangle3.x);
            this.hoverRect = new Rectangle(n - 16 - 3, 2, 16, this.getTabHeight() - 2);
            gC.setForeground(gC.getDevice().getSystemColor(18));
            n = this.hoverRect.x;
            int n2 = this.hoverRect.y;
            gC.setBackground(gC.getDevice().getSystemColor(1));
            gC.fillRectangle(n + this.hoverRect.width - 6, n2, 5, 5);
            gC.drawRectangle(n + this.hoverRect.width - 6, n2, 5, 5);
            gC.drawLine(n + this.hoverRect.width - 6, n2 + 2, n + this.hoverRect.width - 6 + 5, n2 + 2);
            gC.fillRectangle(n, n2, 5, 2);
            gC.drawRectangle(n, n2, 5, 2);
        }
        gC.setFont(font2);
        gC.setForeground(color2);
        gC.setBackground(color);
    }

    void onResize(Event event) {
        if (this.inDispose) {
            return;
        }
        if (this.ignoreResize) {
            return;
        }
        if (this.updateItems()) {
            this.redrawTabs();
        }
        Point point = this.getSize();
        if (this.oldSize == null) {
            this.redraw();
        } else if (this.onBottom && point.y != this.oldSize.y) {
            this.redraw();
        } else {
            int n = Math.min(point.x, this.oldSize.x);
            Rectangle rectangle = this.renderer.computeTrim(-1, 0, 0, 0, 0, 0);
            if (point.x != this.oldSize.x) {
                n -= rectangle.width + rectangle.x - this.marginWidth + 2;
            }
            if (!this.simple) {
                n -= 5;
            }
            int n2 = Math.min(point.y, this.oldSize.y);
            if (point.y != this.oldSize.y) {
                n2 -= rectangle.height + rectangle.y - this.marginHeight;
            }
            int n3 = Math.max(point.x, this.oldSize.x);
            int n4 = Math.max(point.y, this.oldSize.y);
            this.redraw(0, n2, n3, n4 - n2, false);
            this.redraw(n, 0, n3 - n, n4, false);
            if (this.hoverTb) {
                this.redraw(this.hoverRect.x, this.hoverRect.y, this.hoverRect.width, this.hoverRect.height, false);
            }
        }
        this.oldSize = point;
    }

    void onSelection(Event event) {
        if (this.hovering) {
            this.hovering = false;
            this.updateItems();
        }
        if (event.widget == this.maxItem) {
            CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
            cTabFolderEvent.widget = this;
            cTabFolderEvent.time = event.time;
            int n = 0;
            while (n < this.folderListeners.length) {
                if (this.maximized) {
                    this.folderListeners[n].restore(cTabFolderEvent);
                } else {
                    this.folderListeners[n].maximize(cTabFolderEvent);
                }
                ++n;
            }
        } else if (event.widget == this.minItem) {
            CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
            cTabFolderEvent.widget = this;
            cTabFolderEvent.time = event.time;
            int n = 0;
            while (n < this.folderListeners.length) {
                if (this.minimized) {
                    this.folderListeners[n].restore(cTabFolderEvent);
                } else {
                    this.folderListeners[n].minimize(cTabFolderEvent);
                }
                ++n;
            }
        } else if (event.widget == this.chevronItem) {
            Rectangle rectangle = this.chevronItem.getBounds();
            rectangle = event.display.map((Control)this.chevronTb, (Control)this, rectangle);
            CTabFolderEvent cTabFolderEvent = new CTabFolderEvent(this);
            cTabFolderEvent.widget = this;
            cTabFolderEvent.time = event.time;
            cTabFolderEvent.x = rectangle.x;
            cTabFolderEvent.y = rectangle.y;
            cTabFolderEvent.width = rectangle.width;
            cTabFolderEvent.height = rectangle.height;
            cTabFolderEvent.doit = true;
            int n = 0;
            while (n < this.folderListeners.length) {
                this.folderListeners[n].showList(cTabFolderEvent);
                ++n;
            }
            if (cTabFolderEvent.doit && !this.isDisposed()) {
                this.showList(rectangle);
            }
        }
    }

    void onTraverse(Event event) {
        if (this.ignoreTraverse) {
            return;
        }
        switch (event.detail) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                Control control = this.getDisplay().getFocusControl();
                if (control != this) break;
                event.doit = true;
                break;
            }
            case 128: {
                event.doit = this.onMnemonic(event, false);
                break;
            }
            case 256: 
            case 512: {
                event.doit = this.items.length > 0;
            }
        }
        this.ignoreTraverse = true;
        this.notifyListeners(31, event);
        this.ignoreTraverse = false;
        event.type = 0;
        if (this.isDisposed()) {
            return;
        }
        if (!event.doit) {
            return;
        }
        switch (event.detail) {
            case 128: {
                this.onMnemonic(event, true);
                event.detail = 0;
                break;
            }
            case 256: 
            case 512: {
                this.onPageTraversal(event);
                event.detail = 0;
            }
        }
    }

    void redrawTabs() {
        Point point = this.getSize();
        Rectangle rectangle = this.renderer.computeTrim(-1, 0, 0, 0, 0, 0);
        if (this.onBottom) {
            int n = rectangle.height + rectangle.y - this.marginHeight;
            this.redraw(0, point.y - n - 1, point.x, n + 1, false);
        } else {
            this.redraw(0, 0, point.x, -rectangle.y - this.marginHeight + 1, false);
        }
    }

    public void removeCTabFolder2Listener(CTabFolder2Listener cTabFolder2Listener) {
        this.checkWidget();
        if (cTabFolder2Listener == null) {
            SWT.error(4);
        }
        if (this.folderListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.folderListeners.length) {
            if (cTabFolder2Listener == this.folderListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.folderListeners.length == 1) {
            this.folderListeners = new CTabFolder2Listener[0];
            return;
        }
        CTabFolder2Listener[] cTabFolder2ListenerArray = new CTabFolder2Listener[this.folderListeners.length - 1];
        System.arraycopy(this.folderListeners, 0, cTabFolder2ListenerArray, 0, n);
        System.arraycopy(this.folderListeners, n + 1, cTabFolder2ListenerArray, n, this.folderListeners.length - n - 1);
        this.folderListeners = cTabFolder2ListenerArray;
    }

    public void removeCTabFolderListener(CTabFolderListener cTabFolderListener) {
        this.checkWidget();
        if (cTabFolderListener == null) {
            SWT.error(4);
        }
        if (this.tabListeners.length == 0) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.tabListeners.length) {
            if (cTabFolderListener == this.tabListeners[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (this.tabListeners.length == 1) {
            this.tabListeners = new CTabFolderListener[0];
            return;
        }
        CTabFolderListener[] cTabFolderListenerArray = new CTabFolderListener[this.tabListeners.length - 1];
        System.arraycopy(this.tabListeners, 0, cTabFolderListenerArray, 0, n);
        System.arraycopy(this.tabListeners, n + 1, cTabFolderListenerArray, n, this.tabListeners.length - n - 1);
        this.tabListeners = cTabFolderListenerArray;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            SWT.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void reskin(int n) {
        super.reskin(n);
        int n2 = 0;
        while (n2 < this.items.length) {
            this.items[n2].reskin(n);
            ++n2;
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.renderer.createAntialiasColors();
        this.updateBkImages();
        this.redraw();
    }

    public void setBackground(Color[] colorArray, int[] nArray) {
        this.setBackground(colorArray, nArray, false);
    }

    public void setBackground(Color[] colorArray, int[] nArray, boolean bl) {
        int n;
        this.checkWidget();
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1) {
                SWT.error(5);
            }
            n = 0;
            while (n < nArray.length) {
                if (nArray[n] < 0 || nArray[n] > 100) {
                    SWT.error(5);
                }
                if (n > 0 && nArray[n] < nArray[n - 1]) {
                    SWT.error(5);
                }
                ++n;
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[colorArray.length - 1]};
                nArray = new int[]{};
            }
        }
        if (this.gradientColors != null && colorArray != null && this.gradientColors.length == colorArray.length) {
            n = 0;
            int n2 = 0;
            while (n2 < this.gradientColors.length) {
                n = this.gradientColors[n2] == null ? (colorArray[n2] == null ? 1 : 0) : (int)(this.gradientColors[n2].equals(colorArray[n2]) ? 1 : 0);
                if (n == 0) break;
                ++n2;
            }
            if (n != 0) {
                n2 = 0;
                while (n2 < this.gradientPercents.length) {
                    int n3 = n = this.gradientPercents[n2] == nArray[n2] ? 1 : 0;
                    if (n == 0) break;
                    ++n2;
                }
            }
            if (n != 0 && this.gradientVertical == bl) {
                return;
            }
        }
        if (colorArray == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
            this.setBackground(null);
        } else {
            this.gradientColors = new Color[colorArray.length];
            n = 0;
            while (n < colorArray.length) {
                this.gradientColors[n] = colorArray[n];
                ++n;
            }
            this.gradientPercents = new int[nArray.length];
            n = 0;
            while (n < nArray.length) {
                this.gradientPercents[n] = nArray[n];
                ++n;
            }
            this.gradientVertical = bl;
            this.setBackground(this.gradientColors[this.gradientColors.length - 1]);
        }
        this.redraw();
    }

    public void setBackgroundImage(Image image) {
        super.setBackgroundImage(image);
        this.renderer.createAntialiasColors();
        this.redraw();
    }

    public void setBorderVisible(boolean bl) {
        this.checkWidget();
        if (this.borderVisible == bl) {
            return;
        }
        this.borderVisible = bl;
        Rectangle rectangle = this.getClientArea();
        this.updateItems();
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.notifyListeners(11, new Event());
        }
        this.redraw();
    }

    void setButtonBounds(GC gC) {
        int n;
        int n2;
        Point point = this.getSize();
        Display display = this.getDisplay();
        if (this.showMax) {
            if (this.minMaxTb == null) {
                this.minMaxTb = new ToolBar(this, 0x800000);
                this.initAccessibleMinMaxTb();
                this.addTabControl(this.minMaxTb, 131072, 0, false);
            }
            if (this.maxItem == null) {
                this.maxItem = new ToolItem(this.minMaxTb, 8);
                if (this.maxImage == null) {
                    this.maxImage = this.createButtonImage(display, -5);
                }
                this.maxItem.setImage(this.maxImage);
                this.maxItem.setToolTipText(this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize"));
                this.maxItem.addListener(13, this.listener);
            }
        } else if (this.maxItem != null) {
            this.maxItem.dispose();
            this.maxItem = null;
        }
        if (this.showMin) {
            if (this.minMaxTb == null) {
                this.minMaxTb = new ToolBar(this, 0x800000);
                this.initAccessibleMinMaxTb();
                this.addTabControl(this.minMaxTb, 131072, 0, false);
            }
            if (this.minItem == null) {
                this.minItem = new ToolItem(this.minMaxTb, 8, 0);
                if (this.minImage == null) {
                    this.minImage = this.createButtonImage(display, -6);
                }
                this.minItem.setImage(this.minImage);
                this.minItem.setToolTipText(this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize"));
                this.minItem.addListener(13, this.listener);
            }
        } else if (this.minItem != null) {
            this.minItem.dispose();
            this.minItem = null;
        }
        if (this.minMaxTb != null && this.minMaxTb.getItemCount() == 0) {
            this.removeTabControl(this.minMaxTb, false);
            this.minMaxTb.dispose();
            this.minMaxTb = null;
        }
        if (this.showChevron) {
            int n3;
            int n4 = this.items.length;
            if (this.single) {
                n3 = this.selectedIndex == -1 ? n4 : n4 - 1;
            } else {
                n2 = 0;
                while (n2 < this.priority.length && this.items[this.priority[n2]].showing) {
                    ++n2;
                }
                n3 = n4 - n2;
            }
            if (n3 != this.chevronCount) {
                this.chevronCount = n3;
                if (this.chevronImage != null) {
                    this.chevronImage.dispose();
                }
                this.chevronImage = this.createButtonImage(display, -7);
                this.chevronItem.setImage(this.chevronImage);
            }
        }
        boolean[][] blArray = new boolean[1][0];
        Rectangle[] rectangleArray = this.computeControlBounds(point, blArray);
        if (this.fixedTabHeight != -1) {
            n2 = this.fixedTabHeight;
            if (!this.hovering) {
                this.hoverTb = false;
                Rectangle rectangle = this.getBounds();
                n = 0;
                while (n < rectangleArray.length) {
                    if (!blArray[0][n] && rectangleArray[n].height > n2) {
                        this.hoverTb = true;
                        break;
                    }
                    ++n;
                }
                if (this.hoverTb) {
                    n = 0;
                    while (n < rectangleArray.length) {
                        if (!blArray[0][n] && rectangleArray[n].height > n2) {
                            rectangleArray[n].x = rectangle.width + 20;
                        }
                        ++n;
                    }
                }
            }
        }
        n2 = 0;
        int n5 = 0;
        while (n5 < rectangleArray.length) {
            if (!blArray[0][n5]) {
                n2 = Math.max(rectangleArray[n5].height, n2);
            }
            ++n5;
        }
        n5 = 0;
        this.ignoreResize = true;
        n = 0;
        while (n < this.controls.length) {
            if (blArray[0][n]) {
                this.controls[n].setBounds(rectangleArray[n]);
            } else {
                this.controls[n].moveAbove(null);
                this.controls[n].setBounds(rectangleArray[n].x, rectangleArray[n].y, rectangleArray[n].width, n2);
            }
            if (n5 == 0 && !rectangleArray[n].equals(this.controlRects[n])) {
                n5 = 1;
            }
            ++n;
        }
        this.ignoreResize = false;
        this.controlRects = rectangleArray;
        if (n5 != 0 || this.hovering) {
            this.updateBkImages();
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.equals(this.getFont())) {
            return;
        }
        super.setFont(font);
        this.oldFont = this.getFont();
        if (!this.updateTabHeight(false)) {
            this.updateItems();
            this.redraw();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.redraw();
    }

    public void setInsertMark(CTabItem cTabItem, boolean bl) {
        this.checkWidget();
    }

    public void setInsertMark(int n, boolean bl) {
        this.checkWidget();
        if (n < -1 || n >= this.getItemCount()) {
            SWT.error(5);
        }
    }

    boolean setItemLocation(GC gC) {
        boolean bl = false;
        if (this.items.length == 0) {
            return false;
        }
        Rectangle rectangle = this.renderer.computeTrim(-3, 0, 0, 0, 0, 0);
        int n = rectangle.height + rectangle.y;
        int n2 = -rectangle.y;
        Point point = this.getSize();
        int n3 = this.onBottom ? Math.max(n, point.y - n - this.tabHeight) : n2;
        Point point2 = this.renderer.computeSize(-8, 0, gC, -1, -1);
        int n4 = this.getLeftItemEdge(gC, -3);
        if (this.single) {
            int n5 = this.getDisplay().getBounds().width + 10;
            int n6 = 0;
            while (n6 < this.items.length) {
                CTabItem cTabItem = this.items[n6];
                if (n6 == this.selectedIndex) {
                    this.firstIndex = this.selectedIndex;
                    int n7 = cTabItem.x;
                    int n8 = cTabItem.y;
                    cTabItem.x = n4;
                    cTabItem.y = n3;
                    cTabItem.showing = true;
                    if (this.showClose || cTabItem.showClose) {
                        cTabItem.closeRect.x = n4 - this.renderer.computeTrim((int)n6, (int)0, (int)0, (int)0, (int)0, (int)0).x;
                        int n9 = cTabItem.closeRect.y = this.onBottom ? point.y - n - this.tabHeight + (this.tabHeight - point2.y) / 2 : n2 + (this.tabHeight - point2.y) / 2;
                    }
                    if (cTabItem.x != n7 || cTabItem.y != n8) {
                        bl = true;
                    }
                } else {
                    cTabItem.x = n5;
                    cTabItem.showing = false;
                }
                ++n6;
            }
        } else {
            int n10 = this.getRightItemEdge(gC);
            int n11 = n10 - n4;
            int n12 = 0;
            int n13 = 0;
            while (n13 < this.priority.length) {
                CTabItem cTabItem = this.items[this.priority[n13]];
                cTabItem.showing = n13 == 0 ? true : cTabItem.width > 0 && (n12 += cTabItem.width) <= n11;
                ++n13;
            }
            n13 = this.getLeftItemEdge(gC, -2);
            int n14 = this.getDisplay().getBounds().width + 10;
            this.firstIndex = this.items.length - 1;
            int n15 = 0;
            while (n15 < this.items.length) {
                CTabItem cTabItem = this.items[n15];
                if (!cTabItem.showing) {
                    if (cTabItem.x != n14) {
                        bl = true;
                    }
                    cTabItem.x = n14;
                } else {
                    this.firstIndex = Math.min(this.firstIndex, n15);
                    if (cTabItem.x != n13 || cTabItem.y != n3) {
                        bl = true;
                    }
                    cTabItem.x = n13;
                    cTabItem.y = n3;
                    int n16 = 0;
                    if (n15 == this.selectedIndex) {
                        n16 |= 2;
                    }
                    Rectangle rectangle2 = this.renderer.computeTrim(n15, n16, 0, 0, 0, 0);
                    cTabItem.closeRect.x = cTabItem.x + cTabItem.width - (rectangle2.width + rectangle2.x) - point2.x;
                    cTabItem.closeRect.y = this.onBottom ? point.y - n - this.tabHeight + (this.tabHeight - point2.y) / 2 : n2 + (this.tabHeight - point2.y) / 2;
                    n13 += cTabItem.width;
                    if (!this.simple && n15 == this.selectedIndex) {
                        n13 -= this.renderer.curveIndent;
                    }
                }
                ++n15;
            }
        }
        return bl;
    }

    void setItemOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            SWT.error(4);
        }
        if (nArray.length != this.items.length) {
            SWT.error(5);
        }
        int n = -1;
        boolean[] blArray = new boolean[this.items.length];
        CTabItem[] cTabItemArray = new CTabItem[this.items.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            if (n3 < 0 || n3 >= this.items.length) {
                SWT.error(5);
            }
            if (blArray[n3]) {
                SWT.error(5);
            }
            blArray[n3] = true;
            if (n3 == this.selectedIndex) {
                n = n2;
            }
            cTabItemArray[n2] = this.items[n3];
            ++n2;
        }
        this.items = cTabItemArray;
        this.selectedIndex = n;
        this.updateItems();
        this.redraw();
    }

    boolean setItemSize(GC gC) {
        int[] nArray;
        int n;
        boolean bl = false;
        if (this.isDisposed()) {
            return bl;
        }
        Point point = this.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return bl;
        }
        ToolBar toolBar = this.getChevron();
        if (toolBar != null) {
            toolBar.setVisible(false);
        }
        this.showChevron = false;
        if (this.single) {
            boolean bl2 = this.showChevron = this.chevronVisible && this.items.length > 1;
            if (this.showChevron) {
                toolBar.setVisible(true);
            }
            if (this.selectedIndex != -1) {
                CTabItem cTabItem = this.items[this.selectedIndex];
                int n2 = this.renderer.computeSize((int)this.selectedIndex, (int)2, (GC)gC, (int)-1, (int)-1).x;
                n2 = Math.min(n2, this.getRightItemEdge(gC) - this.getLeftItemEdge(gC, -3));
                if (cTabItem.height != this.tabHeight || cTabItem.width != n2) {
                    bl = true;
                    cTabItem.shortenedText = null;
                    cTabItem.shortenedTextWidth = 0;
                    cTabItem.height = this.tabHeight;
                    cTabItem.width = n2;
                    cTabItem.closeRect.height = 0;
                    cTabItem.closeRect.width = 0;
                    if (this.showClose || cTabItem.showClose) {
                        Point point2 = this.renderer.computeSize(-8, 2, gC, -1, -1);
                        cTabItem.closeRect.width = point2.x;
                        cTabItem.closeRect.height = point2.y;
                    }
                }
            }
            return bl;
        }
        if (this.items.length == 0) {
            return bl;
        }
        int n3 = Math.max(0, this.getRightItemEdge(gC) - this.getLeftItemEdge(gC, -3));
        int n4 = 0;
        int[] nArray2 = new int[this.items.length];
        int n5 = 0;
        while (n5 < this.priority.length) {
            int n6 = this.priority[n5];
            n = 0x1000000;
            if (n6 == this.selectedIndex) {
                n |= 2;
            }
            nArray2[n6] = this.renderer.computeSize((int)n6, (int)n, (GC)gC, (int)-1, (int)-1).x;
            if ((n4 += nArray2[n6]) > n3) break;
            ++n5;
        }
        if (n4 > n3) {
            boolean bl3 = this.showChevron = this.chevronVisible && this.items.length > 1;
            if (this.showChevron) {
                n3 -= toolBar.computeSize((int)-1, (int)-1).x;
                toolBar.setVisible(true);
            }
            nArray = nArray2;
            int n7 = n5 = this.selectedIndex != -1 ? this.selectedIndex : 0;
            if (n3 < nArray[n5]) {
                nArray[n5] = Math.max(0, n3);
            }
        } else {
            int n8;
            n5 = 0;
            int[] nArray3 = new int[this.items.length];
            n = 0;
            while (n < this.items.length) {
                n8 = 0;
                if (n == this.selectedIndex) {
                    n8 |= 2;
                }
                nArray3[n] = this.renderer.computeSize((int)n, (int)n8, (GC)gC, (int)-1, (int)-1).x;
                n5 += nArray3[n];
                ++n;
            }
            if (n5 <= n3) {
                nArray = nArray3;
            } else {
                n = (n3 - n4) / this.items.length;
                while (true) {
                    n8 = 0;
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < this.items.length) {
                        if (nArray3[n10] > nArray2[n10] + n) {
                            n9 += nArray2[n10] + n;
                            ++n8;
                        } else {
                            n9 += nArray3[n10];
                        }
                        ++n10;
                    }
                    if (n9 >= n3) {
                        --n;
                        break;
                    }
                    if (n8 == 0 || n3 - n9 < n8) break;
                    ++n;
                }
                nArray = new int[this.items.length];
                n8 = 0;
                while (n8 < this.items.length) {
                    nArray[n8] = Math.min(nArray3[n8], nArray2[n8] + n);
                    ++n8;
                }
            }
        }
        n5 = 0;
        while (n5 < this.items.length) {
            CTabItem cTabItem = this.items[n5];
            n = nArray[n5];
            if (cTabItem.height != this.tabHeight || cTabItem.width != n) {
                bl = true;
                cTabItem.shortenedText = null;
                cTabItem.shortenedTextWidth = 0;
                cTabItem.height = this.tabHeight;
                cTabItem.width = n;
                cTabItem.closeRect.height = 0;
                cTabItem.closeRect.width = 0;
                if ((this.showClose || cTabItem.showClose) && (n5 == this.selectedIndex || this.showUnselectedClose)) {
                    Point point3 = this.renderer.computeSize(-8, 0, gC, -1, -1);
                    cTabItem.closeRect.width = point3.x;
                    cTabItem.closeRect.height = point3.y;
                }
            }
            ++n5;
        }
        return bl;
    }

    public void setMaximizeVisible(boolean bl) {
        this.checkWidget();
        if (this.showMax == bl) {
            return;
        }
        this.showMax = bl;
        this.updateItems();
        this.redraw();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        if (this.maximized == bl) {
            return;
        }
        if (bl && this.minimized) {
            this.setMinimized(false);
        }
        this.maximized = bl;
        if (this.minMaxTb != null && this.maxItem != null) {
            if (this.maxImage != null) {
                this.maxImage.dispose();
            }
            this.maxImage = this.createButtonImage(this.getDisplay(), -5);
            this.maxItem.setImage(this.maxImage);
            this.maxItem.setToolTipText(this.maximized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Maximize"));
        }
    }

    public void setMinimizeVisible(boolean bl) {
        this.checkWidget();
        if (this.showMin == bl) {
            return;
        }
        this.showMin = bl;
        this.updateItems();
        this.redraw();
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        if (this.minimized == bl) {
            return;
        }
        if (bl && this.maximized) {
            this.setMaximized(false);
        }
        this.minimized = bl;
        if (this.minMaxTb != null && this.minItem != null) {
            if (this.minImage != null) {
                this.minImage.dispose();
            }
            this.minImage = this.createButtonImage(this.getDisplay(), -6);
            this.minItem.setImage(this.minImage);
            this.minItem.setToolTipText(this.minimized ? SWT.getMessage("SWT_Restore") : SWT.getMessage("SWT_Minimize"));
        }
    }

    public void setMinimumCharacters(int n) {
        this.checkWidget();
        if (n < 0) {
            SWT.error(6);
        }
        if (this.minChars == n) {
            return;
        }
        this.minChars = n;
        if (this.updateItems()) {
            this.redrawTabs();
        }
    }

    public void setMRUVisible(boolean bl) {
        this.checkWidget();
        if (this.mru == bl) {
            return;
        }
        this.mru = bl;
        if (!this.mru) {
            if (this.firstIndex == -1) {
                return;
            }
            int n = this.firstIndex;
            int n2 = 0;
            int n3 = this.firstIndex;
            while (n3 < this.items.length) {
                this.priority[n2++] = n3++;
            }
            n3 = 0;
            while (n3 < n) {
                this.priority[n2++] = n3++;
            }
            if (this.updateItems()) {
                this.redrawTabs();
            }
        }
    }

    public void setRenderer(CTabFolderRenderer cTabFolderRenderer) {
        this.checkWidget();
        if (this.renderer == cTabFolderRenderer) {
            return;
        }
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        if (cTabFolderRenderer == null) {
            cTabFolderRenderer = new CTabFolderRenderer(this);
        }
        this.renderer = cTabFolderRenderer;
        this.updateTabHeight(false);
        Rectangle rectangle = this.getClientArea();
        this.updateItems();
        Rectangle rectangle2 = this.getClientArea();
        if (!rectangle.equals(rectangle2)) {
            this.notifyListeners(11, new Event());
        }
        this.redraw();
    }

    public void setSelection(CTabItem cTabItem) {
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        int n = this.indexOf(cTabItem);
        this.setSelection(n);
    }

    public void setSelection(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        CTabItem cTabItem = this.items[n];
        if (this.selectedIndex == n) {
            this.showItem(cTabItem);
            return;
        }
        int n2 = this.selectedIndex;
        this.selectedIndex = n;
        if (n2 != -1) {
            this.items[n2].closeImageState = 8;
            this.items[n2].state &= 0xFFFFFFFD;
        }
        cTabItem.closeImageState = 0;
        cTabItem.showing = false;
        cTabItem.state |= 2;
        Control control = cTabItem.control;
        Control control2 = null;
        if (n2 != -1) {
            control2 = this.items[n2].control;
        }
        if (control != control2) {
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (control2 != null && !control2.isDisposed()) {
                control2.setVisible(false);
            }
        }
        this.showItem(cTabItem);
        this.redraw();
    }

    void setSelection(int n, boolean bl) {
        int n2 = this.selectedIndex;
        this.setSelection(n);
        if (bl && this.selectedIndex != n2 && this.selectedIndex != -1) {
            Event event = new Event();
            event.item = this.getItem(this.selectedIndex);
            this.notifyListeners(13, event);
        }
    }

    public void setSelectionBackground(Color color) {
        if (this.inDispose) {
            return;
        }
        this.checkWidget();
        this.setSelectionHighlightGradientColor(null);
        if (this.selectionBackground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(25);
        }
        this.selectionBackground = color;
        this.renderer.createAntialiasColors();
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray) {
        this.setSelectionBackground(colorArray, nArray, false);
    }

    public void setSelectionBackground(Color[] colorArray, int[] nArray, boolean bl) {
        int n;
        int n2;
        this.checkWidget();
        Color color = null;
        if (colorArray != null) {
            if (nArray == null || nArray.length != colorArray.length - 1 && nArray.length != colorArray.length - 2) {
                SWT.error(5);
            }
            n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] < 0 || nArray[n2] > 100) {
                    SWT.error(5);
                }
                if (n2 > 0 && nArray[n2] < nArray[n2 - 1]) {
                    SWT.error(5);
                }
                ++n2;
            }
            if (nArray.length == colorArray.length - 2) {
                color = colorArray[colorArray.length - 1];
                n = colorArray.length - 1;
            } else {
                n = colorArray.length;
            }
            if (this.getDisplay().getDepth() < 15) {
                colorArray = new Color[]{colorArray[n - 1]};
                n = colorArray.length;
                nArray = new int[]{};
            }
        } else {
            n = 0;
        }
        if (this.selectionBgImage == null) {
            if (this.selectionGradientColors != null && colorArray != null && this.selectionGradientColors.length == n) {
                n2 = 0;
                int n3 = 0;
                while (n3 < this.selectionGradientColors.length) {
                    n2 = this.selectionGradientColors[n3] == null ? (colorArray[n3] == null ? 1 : 0) : (int)(this.selectionGradientColors[n3].equals(colorArray[n3]) ? 1 : 0);
                    if (n2 == 0) break;
                    ++n3;
                }
                if (n2 != 0) {
                    n3 = 0;
                    while (n3 < this.selectionGradientPercents.length) {
                        int n4 = n2 = this.selectionGradientPercents[n3] == nArray[n3] ? 1 : 0;
                        if (n2 == 0) break;
                        ++n3;
                    }
                }
                if (n2 != 0 && this.selectionGradientVertical == bl) {
                    return;
                }
            }
        } else {
            this.selectionBgImage = null;
        }
        if (colorArray == null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.selectionGradientVertical = false;
            this.setSelectionBackground((Color)null);
            this.setSelectionHighlightGradientColor(null);
        } else {
            this.selectionGradientColors = new Color[n];
            n2 = 0;
            while (n2 < n) {
                this.selectionGradientColors[n2] = colorArray[n2];
                ++n2;
            }
            this.selectionGradientPercents = new int[nArray.length];
            n2 = 0;
            while (n2 < nArray.length) {
                this.selectionGradientPercents[n2] = nArray[n2];
                ++n2;
            }
            this.selectionGradientVertical = bl;
            this.setSelectionBackground(this.selectionGradientColors[this.selectionGradientColors.length - 1]);
            this.setSelectionHighlightGradientColor(color);
        }
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    void setSelectionHighlightGradientColor(Color color) {
        if (this.inDispose) {
            return;
        }
        this.renderer.setSelectionHighlightGradientColor(color);
    }

    public void setSelectionBackground(Image image) {
        this.checkWidget();
        this.setSelectionHighlightGradientColor(null);
        if (image == this.selectionBgImage) {
            return;
        }
        if (image != null) {
            this.selectionGradientColors = null;
            this.selectionGradientPercents = null;
            this.renderer.disposeSelectionHighlightGradientColors();
        }
        this.selectionBgImage = image;
        this.renderer.createAntialiasColors();
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSelectionForeground(Color color) {
        this.checkWidget();
        if (this.selectionForeground == color) {
            return;
        }
        if (color == null) {
            color = this.getDisplay().getSystemColor(24);
        }
        this.selectionForeground = color;
        if (this.selectedIndex > -1) {
            this.redraw();
        }
    }

    public void setSimple(boolean bl) {
        this.checkWidget();
        if (this.simple != bl) {
            this.simple = bl;
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setSingle(boolean bl) {
        this.checkWidget();
        if (this.single != bl) {
            this.single = bl;
            if (!bl) {
                int n = 0;
                while (n < this.items.length) {
                    if (n != this.selectedIndex && this.items[n].closeImageState == 0) {
                        this.items[n].closeImageState = 8;
                    }
                    ++n;
                }
            }
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    int getControlY(Point point, Rectangle[] rectangleArray, int n, int n2, int n3) {
        int n4 = this.fixedTabHeight != -1 ? 0 : (this.tabHeight - rectangleArray[n3].height) / 2;
        return this.onBottom ? point.y - 1 - n - this.tabHeight + n4 : 1 + n2 + n4;
    }

    public void setTabHeight(int n) {
        this.checkWidget();
        if (n < -1) {
            SWT.error(5);
        }
        this.fixedTabHeight = n;
        this.updateTabHeight(false);
    }

    public void setTabPosition(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024) {
            SWT.error(5);
        }
        if (this.onBottom != (n == 1024)) {
            this.onBottom = n == 1024;
            this.updateTabHeight(true);
            Rectangle rectangle = this.getClientArea();
            this.updateItems();
            Rectangle rectangle2 = this.getClientArea();
            if (!rectangle.equals(rectangle2)) {
                this.notifyListeners(11, new Event());
            }
            this.redraw();
        }
    }

    public void setTopRight(Control control) {
        this.setTopRight(control, 131072);
    }

    public void setTopRight(Control control, int n) {
        this.checkWidget();
        if (n != 131072 && n != 4 && n != 131136) {
            SWT.error(5);
        }
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        if (this.topRight == control && this.topRightAlignment == n) {
            return;
        }
        if (this.topRight != null) {
            this.removeTabControl(this.topRight, false);
        }
        this.topRight = control;
        this.topRightAlignment = n;
        n &= 0xFFFDFFFF;
        if (control != null) {
            this.addTabControl(control, 0x20000 | n, -1, false);
        }
        this.updateTabHeight(false);
        if (this.updateItems()) {
            this.redraw();
        }
        this.updateBkImages();
    }

    public void setUnselectedCloseVisible(boolean bl) {
        this.checkWidget();
        if (this.showUnselectedClose == bl) {
            return;
        }
        this.showUnselectedClose = bl;
        this.updateItems();
        this.redraw();
    }

    public void setUnselectedImageVisible(boolean bl) {
        this.checkWidget();
        if (this.showUnselectedImage == bl) {
            return;
        }
        this.showUnselectedImage = bl;
        this.updateItems();
        this.redraw();
    }

    public void showItem(CTabItem cTabItem) {
        int n;
        this.checkWidget();
        if (cTabItem == null) {
            SWT.error(4);
        }
        if (cTabItem.isDisposed()) {
            SWT.error(5);
        }
        if ((n = this.indexOf(cTabItem)) == -1) {
            SWT.error(5);
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.priority.length) {
            if (this.priority[n3] == n) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        if (this.mru) {
            int[] nArray = new int[this.priority.length];
            System.arraycopy(this.priority, 0, nArray, 1, n2);
            System.arraycopy(this.priority, n2 + 1, nArray, n2 + 1, this.priority.length - n2 - 1);
            nArray[0] = n;
            this.priority = nArray;
        }
        if (cTabItem.isShowing()) {
            return;
        }
        this.updateItems(n);
        this.redrawTabs();
    }

    void showList(Rectangle rectangle) {
        Object object;
        if (this.items.length == 0 || !this.showChevron) {
            return;
        }
        if (this.showMenu == null || this.showMenu.isDisposed()) {
            this.showMenu = new Menu(this.getShell(), this.getStyle() & 0x6000000);
        } else {
            MenuItem[] menuItemArray = this.showMenu.getItems();
            int n = 0;
            while (n < menuItemArray.length) {
                menuItemArray[n].dispose();
                ++n;
            }
        }
        int n = 0;
        while (n < this.items.length) {
            CTabItem cTabItem = this.items[n];
            if (!cTabItem.showing) {
                object = new MenuItem(this.showMenu, 0);
                ((MenuItem)object).setText(cTabItem.getText());
                ((MenuItem)object).setImage(cTabItem.getImage());
                ((Widget)object).setData("CTabFolder_showList_Index", cTabItem);
                ((MenuItem)object).addSelectionListener(new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        MenuItem menuItem = (MenuItem)selectionEvent.widget;
                        int n = CTabFolder.this.indexOf((CTabItem)menuItem.getData("CTabFolder_showList_Index"));
                        CTabFolder.this.setSelection(n, true);
                    }
                });
            }
            ++n;
        }
        n = rectangle.x;
        int n2 = rectangle.y + rectangle.height;
        object = this.getDisplay().map(this, null, n, n2);
        this.showMenu.setLocation(((Point)object).x, ((Point)object).y);
        this.showMenu.setVisible(true);
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedIndex != -1) {
            this.showItem(this.getSelection());
        }
    }

    void _setToolTipText(int n, int n2) {
        String string = this.getToolTipText();
        String string2 = this._getToolTip(n, n2);
        if (string2 == null || !string2.equals(string)) {
            this.setToolTipText(string2);
        }
    }

    boolean updateItems() {
        return this.updateItems(this.selectedIndex);
    }

    boolean updateItems(int n) {
        int n3;
        GC gC = new GC(this);
        if (!this.single && !this.mru && n != -1) {
            int n2;
            n3 = n;
            if (this.priority[0] < n) {
                int n4;
                int n22 = this.getRightItemEdge(gC) - this.getLeftItemEdge(gC, -3);
                n2 = 0;
                int[] nArray = new int[this.items.length];
                int n5 = this.priority[0];
                while (n5 <= n) {
                    n4 = 0x1000000;
                    if (n5 == this.selectedIndex) {
                        n4 |= 2;
                    }
                    nArray[n5] = this.renderer.computeSize((int)n5, (int)n4, (GC)gC, (int)-1, (int)-1).x;
                    if ((n2 += nArray[n5]) > n22) break;
                    ++n5;
                }
                if (n2 > n22) {
                    n2 = 0;
                    n5 = n;
                    while (n5 >= 0) {
                        n4 = 0x1000000;
                        if (n5 == this.selectedIndex) {
                            n4 |= 2;
                        }
                        if (nArray[n5] == 0) {
                            nArray[n5] = this.renderer.computeSize((int)n5, (int)n4, (GC)gC, (int)-1, (int)-1).x;
                        }
                        if ((n2 += nArray[n5]) <= n22) {
                            n3 = n5--;
                            continue;
                        }
                        break;
                    }
                } else {
                    n3 = this.priority[0];
                    n5 = n + 1;
                    while (n5 < this.items.length) {
                        n4 = 0x1000000;
                        if (n5 == this.selectedIndex) {
                            n4 |= 2;
                        }
                        nArray[n5] = this.renderer.computeSize((int)n5, (int)n4, (GC)gC, (int)-1, (int)-1).x;
                        if ((n2 += nArray[n5]) >= n22) break;
                        ++n5;
                    }
                    if (n2 < n22) {
                        n5 = this.priority[0] - 1;
                        while (n5 >= 0) {
                            n4 = 0x1000000;
                            if (n5 == this.selectedIndex) {
                                n4 |= 2;
                            }
                            if (nArray[n5] == 0) {
                                nArray[n5] = this.renderer.computeSize((int)n5, (int)n4, (GC)gC, (int)-1, (int)-1).x;
                            }
                            if ((n2 += nArray[n5]) <= n22) {
                                n3 = n5--;
                                continue;
                            }
                            break;
                        }
                    }
                }
            }
            if (n3 != this.priority[0]) {
                boolean bl = false;
                n2 = n3;
                while (n2 < this.items.length) {
                    this.priority[++var4_6] = n2++;
                }
                n2 = 0;
                while (n2 < n3) {
                    this.priority[++var4_7] = n2++;
                }
            }
        }
        n3 = this.showChevron;
        int n7 = this.setItemSize(gC);
        n7 = n7 | this.setItemLocation(gC);
        this.setButtonBounds(gC);
        boolean bl = n7 | this.showChevron ^ n3;
        if (bl && this.getToolTipText() != null) {
            Point point = this.getDisplay().getCursorLocation();
            point = this.toControl(point);
            this._setToolTipText(point.x, point.y);
        }
        gC.dispose();
        return bl;
    }

    boolean updateTabHeight(boolean bl) {
        int n = this.tabHeight;
        GC gC = new GC(this);
        this.tabHeight = this.renderer.computeSize((int)-2, (int)0, (GC)gC, (int)-1, (int)-1).y;
        gC.dispose();
        if (this.fixedTabHeight == -1 && this.controls != null && this.controls.length > 0) {
            int n2 = 0;
            while (n2 < this.controls.length) {
                if ((this.controlAlignments[n2] & 0x40) == 0 && this.controls[n2].getVisible()) {
                    int n3 = this.controls[n2].computeSize((int)-1, (int)-1).y;
                    this.tabHeight = Math.max(n3 += this.renderer.computeTrim((int)-2, (int)0, (int)0, (int)0, (int)0, (int)0).height + 1, this.tabHeight);
                }
                ++n2;
            }
        }
        if (!bl && this.tabHeight == n) {
            return false;
        }
        this.oldSize = null;
        this.notifyListeners(11, new Event());
        return true;
    }

    void updateBkImages() {
        if (this.controls != null && this.controls.length > 0) {
            int n = 0;
            while (n < this.controls.length) {
                Control control = this.controls[n];
                if (this.hovering) {
                    if (control instanceof Composite) {
                        ((Composite)control).setBackgroundMode(0);
                    }
                    control.setBackgroundImage(null);
                    control.setBackground(this.getBackground());
                } else {
                    if (control instanceof Composite) {
                        ((Composite)control).setBackgroundMode(1);
                    }
                    Rectangle rectangle = control.getBounds();
                    if (rectangle.y > this.getTabHeight() || this.gradientColors == null) {
                        control.setBackgroundImage(null);
                        control.setBackground(this.getBackground());
                    } else {
                        rectangle.width = 10;
                        rectangle.y = -rectangle.y;
                        rectangle.height -= 2 * rectangle.y - 1;
                        rectangle.x = 0;
                        if (this.controlBkImages[n] != null) {
                            this.controlBkImages[n].dispose();
                        }
                        this.controlBkImages[n] = new Image((Device)control.getDisplay(), rectangle);
                        GC gC = new GC(this.controlBkImages[n]);
                        this.renderer.drawBackground(gC, rectangle, 0);
                        gC.dispose();
                        control.setBackground(null);
                        control.setBackgroundImage(this.controlBkImages[n]);
                    }
                }
                ++n;
            }
        }
    }

    String _getToolTip(int n, int n2) {
        CTabItem cTabItem = this.getItem(new Point(n, n2));
        if (cTabItem == null) {
            return null;
        }
        if (!cTabItem.showing) {
            return null;
        }
        if ((this.showClose || cTabItem.showClose) && cTabItem.closeRect.contains(n, n2)) {
            return SWT.getMessage("SWT_Close");
        }
        return cTabItem.getToolTipText();
    }

    void addTabControl(Control control, int n) {
        this.checkWidget();
        this.addTabControl(control, n, -1, true);
    }

    void addTabControl(Control control, int n, int n2, boolean bl) {
        switch (n) {
            case 16384: 
            case 131072: 
            case 131076: 
            case 131136: 
            case 131140: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        int n3 = 0;
        while (n3 < this.controls.length) {
            if (this.controls[n3] == control) {
                SWT.error(5);
            }
            ++n3;
        }
        n3 = this.controls.length;
        control.addListener(11, this.listener);
        Control[] controlArray = new Control[n3 + 1];
        System.arraycopy(this.controls, 0, controlArray, 0, n3);
        this.controls = controlArray;
        int[] nArray = new int[n3 + 1];
        System.arraycopy(this.controlAlignments, 0, nArray, 0, n3);
        this.controlAlignments = nArray;
        Rectangle[] rectangleArray = new Rectangle[n3 + 1];
        System.arraycopy(this.controlRects, 0, rectangleArray, 0, n3);
        this.controlRects = rectangleArray;
        Image[] imageArray = new Image[n3 + 1];
        System.arraycopy(this.controlBkImages, 0, imageArray, 0, n3);
        this.controlBkImages = imageArray;
        if (n2 == -1) {
            n2 = n3;
            if (this.chevronTb != null && control != this.chevronTb) {
                --n2;
            }
        }
        System.arraycopy(this.controls, n2, this.controls, n2 + 1, n3 - n2);
        System.arraycopy(this.controlAlignments, n2, this.controlAlignments, n2 + 1, n3 - n2);
        System.arraycopy(this.controlRects, n2, this.controlRects, n2 + 1, n3 - n2);
        System.arraycopy(this.controlBkImages, n2, this.controlBkImages, n2 + 1, n3 - n2);
        this.controls[n2] = control;
        this.controlAlignments[n2] = n;
        this.controlRects[n2] = new Rectangle(0, 0, 0, 0);
        if (bl) {
            this.updateTabHeight(false);
            if (this.updateItems()) {
                this.redraw();
            }
            this.updateBkImages();
        }
    }

    void removeTabControl(Control control) {
        this.checkWidget();
        this.removeTabControl(control, true);
    }

    void removeTabControl(Control control, boolean bl) {
        if (control != null && control.getParent() != this) {
            SWT.error(5);
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.controls.length) {
            if (this.controls[n2] == control) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        if (!control.isDisposed()) {
            control.removeListener(11, this.listener);
            control.setBackground(null);
            control.setBackgroundImage(null);
            if (control instanceof Composite) {
                ((Composite)control).setBackgroundMode(0);
            }
        }
        if (this.controlBkImages[n] != null && !this.controlBkImages[n].isDisposed()) {
            this.controlBkImages[n].dispose();
        }
        if (this.controls.length == 1) {
            this.controls = new Control[0];
            this.controlAlignments = new int[0];
            this.controlRects = new Rectangle[0];
            this.controlBkImages = new Image[0];
        } else {
            Control[] controlArray = new Control[this.controls.length - 1];
            System.arraycopy(this.controls, 0, controlArray, 0, n);
            System.arraycopy(this.controls, n + 1, controlArray, n, this.controls.length - n - 1);
            this.controls = controlArray;
            int[] nArray = new int[this.controls.length];
            System.arraycopy(this.controlAlignments, 0, nArray, 0, n);
            System.arraycopy(this.controlAlignments, n + 1, nArray, n, this.controls.length - n);
            this.controlAlignments = nArray;
            Rectangle[] rectangleArray = new Rectangle[this.controls.length];
            System.arraycopy(this.controlRects, 0, rectangleArray, 0, n);
            System.arraycopy(this.controlRects, n + 1, rectangleArray, n, this.controls.length - n);
            this.controlRects = rectangleArray;
            Image[] imageArray = new Image[this.controls.length];
            System.arraycopy(this.controlBkImages, 0, imageArray, 0, n);
            System.arraycopy(this.controlBkImages, n + 1, imageArray, n, this.controls.length - n);
            this.controlBkImages = imageArray;
        }
        if (bl) {
            this.updateItems();
            this.redraw();
        }
    }

    int getWrappedHeight(Point point) {
        boolean[][] blArrayArray = new boolean[1][];
        Rectangle[] rectangleArray = this.computeControlBounds(point, blArrayArray);
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < rectangleArray.length) {
            if (blArrayArray[0][n4]) {
                n = Math.min(n, rectangleArray[n4].y);
                n2 = Math.max(n2, rectangleArray[n4].y + rectangleArray[n4].height);
                n3 = n2 - n;
            }
            ++n4;
        }
        return n3;
    }

    void setChevronVisible(boolean bl) {
        this.checkWidget();
        if (this.chevronVisible == bl) {
            return;
        }
        this.chevronVisible = bl;
        this.updateItems();
        this.redraw();
    }
}

