/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.HDHITTESTINFO;
import org.eclipse.swt.internal.win32.HDITEM;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.LVCOLUMN;
import org.eclipse.swt.internal.win32.LVHITTESTINFO;
import org.eclipse.swt.internal.win32.LVITEM;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMHEADER;
import org.eclipse.swt.internal.win32.NMLISTVIEW;
import org.eclipse.swt.internal.win32.NMLVCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMLVDISPINFO;
import org.eclipse.swt.internal.win32.NMLVODSTATECHANGE;
import org.eclipse.swt.internal.win32.NMRGINFO;
import org.eclipse.swt.internal.win32.NMTTCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.NMTTDISPINFOA;
import org.eclipse.swt.internal.win32.NMTTDISPINFOW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.SHDRAGIMAGE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    TableItem[] items;
    int[] keys;
    TableColumn[] columns;
    int columnCount;
    int customCount;
    int keyCount;
    ImageList imageList;
    ImageList headerImageList;
    TableItem currentItem;
    TableColumn sortColumn;
    RECT focusRect;
    long headerToolTipHandle;
    boolean ignoreCustomDraw;
    boolean ignoreDrawForeground;
    boolean ignoreDrawBackground;
    boolean ignoreDrawFocus;
    boolean ignoreDrawSelection;
    boolean ignoreDrawHot;
    boolean customDraw;
    boolean dragStarted;
    boolean explorerTheme;
    boolean firstColumnImage;
    boolean fixScrollWidth;
    boolean tipRequested;
    boolean wasSelected;
    boolean wasResized;
    boolean painted;
    boolean ignoreActivate;
    boolean ignoreSelect;
    boolean ignoreShrink;
    boolean ignoreResize;
    boolean ignoreColumnMove;
    boolean ignoreColumnResize;
    boolean fullRowSelect;
    int itemHeight;
    int lastIndexOf;
    int lastWidth;
    int sortDirection;
    int resizeCount;
    int selectionForeground;
    int hotIndex;
    static long HeaderProc;
    static final int INSET = 4;
    static final int GRID_WIDTH = 1;
    static final int SORT_WIDTH = 10;
    static final int HEADER_MARGIN = 12;
    static final int HEADER_EXTRA = 3;
    static final int VISTA_EXTRA = 2;
    static final int EXPLORER_EXTRA = 2;
    static final int H_SCROLL_LIMIT = 32;
    static final int V_SCROLL_LIMIT = 16;
    static final int DRAG_IMAGE_SIZE = 301;
    static final boolean EXPLORER_THEME = true;
    static boolean COMPRESS_ITEMS;
    static final long TableProc;
    static final TCHAR TableClass;

    static {
        COMPRESS_ITEMS = true;
        TableClass = new TCHAR(0, "SysListView32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0L, TableClass, wNDCLASS);
        TableProc = wNDCLASS.lpfnWndProc;
    }

    public Table(Composite composite, int n) {
        super(composite, Table.checkStyle(n));
    }

    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        switch (n) {
            case 40: 
            case 41: 
            case 42: {
                this.setCustomDraw(true);
                this.setBackgroundTransparent(true);
                if (OS.COMCTL32_MAJOR < 6) {
                    this.style |= 0x20000000;
                }
                if (!OS.IsWinCE) break;
                OS.SendMessage(this.handle, 4150, 16384L, 0L);
            }
        }
    }

    boolean _checkGrow(int n) {
        if (this.keys == null) {
            if (n == this.items.length) {
                boolean bl = this.getDrawing() && OS.IsWindowVisible(this.handle);
                int n2 = bl ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
                TableItem[] tableItemArray = new TableItem[n2];
                System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
                this.items = tableItemArray;
            }
        } else {
            if (!this.ignoreShrink && this.keyCount > n / 2) {
                boolean bl = this.getDrawing() && OS.IsWindowVisible(this.handle);
                int n3 = bl ? n + 4 : Math.max(4, n * 3 / 2);
                TableItem[] tableItemArray = new TableItem[n3];
                int n4 = 0;
                while (n4 < this.keyCount) {
                    tableItemArray[this.keys[n4]] = this.items[n4];
                    ++n4;
                }
                this.items = tableItemArray;
                this.keys = null;
                this.keyCount = 0;
                return true;
            }
            if (this.keyCount == this.keys.length) {
                boolean bl = this.getDrawing() && OS.IsWindowVisible(this.handle);
                int n5 = bl ? this.keys.length + 4 : Math.max(4, this.keys.length * 3 / 2);
                int[] nArray = new int[n5];
                System.arraycopy(this.keys, 0, nArray, 0, this.keys.length);
                this.keys = nArray;
                TableItem[] tableItemArray = new TableItem[n5];
                System.arraycopy(this.items, 0, tableItemArray, 0, this.items.length);
                this.items = tableItemArray;
            }
        }
        return false;
    }

    void _checkShrink() {
        if (this.keys == null) {
            if (!this.ignoreShrink) {
                int n = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
                if (this.items.length > 4 && this.items.length - n > 3) {
                    int n2 = Math.max(4, (n + 3) / 4 * 4);
                    TableItem[] tableItemArray = new TableItem[n2];
                    System.arraycopy(this.items, 0, tableItemArray, 0, n);
                    this.items = tableItemArray;
                }
            }
        } else if (!this.ignoreShrink && this.keys.length > 4 && this.keys.length - this.keyCount > 3) {
            int n = Math.max(4, (this.keyCount + 3) / 4 * 4);
            int[] nArray = new int[n];
            System.arraycopy(this.keys, 0, nArray, 0, this.keyCount);
            this.keys = nArray;
            TableItem[] tableItemArray = new TableItem[n];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.keyCount);
            this.items = tableItemArray;
        }
    }

    void _clearItems() {
        this.items = null;
        this.keys = null;
        this.keyCount = 0;
    }

    TableItem _getItem(int n) {
        return this._getItem(n, true);
    }

    TableItem _getItem(int n, boolean bl) {
        return this._getItem(n, bl, -1);
    }

    TableItem _getItem(int n, boolean bl, int n2) {
        if (this.keys == null) {
            if ((this.style & 0x10000000) == 0 || !bl) {
                return this.items[n];
            }
            if (this.items[n] != null) {
                return this.items[n];
            }
            this.items[n] = new TableItem(this, 0, -1, false);
            return this.items[n];
        }
        if ((this.style & 0x10000000) == 0 || !bl) {
            if (this.keyCount == 0) {
                return null;
            }
            if (n > this.keys[this.keyCount - 1]) {
                return null;
            }
        }
        int n3 = this.binarySearch(this.keys, 0, this.keyCount, n);
        if ((this.style & 0x10000000) == 0 || !bl) {
            return n3 < 0 ? null : this.items[n3];
        }
        if (n3 < 0) {
            if (n2 == -1) {
                n2 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
            }
            if (this._checkGrow(n2)) {
                if (this.items[n] != null) {
                    return this.items[n];
                }
                this.items[n] = new TableItem(this, 0, -1, false);
                return this.items[n];
            }
            if ((n3 = -n3 - 1) < this.keyCount) {
                System.arraycopy(this.keys, n3, this.keys, n3 + 1, this.keyCount - n3);
                System.arraycopy(this.items, n3, this.items, n3 + 1, this.keyCount - n3);
            }
            ++this.keyCount;
            this.keys[n3] = n;
        } else if (this.items[n3] != null) {
            return this.items[n3];
        }
        this.items[n3] = new TableItem(this, 0, -1, false);
        return this.items[n3];
    }

    void _getItems(TableItem[] tableItemArray, int n) {
        if (this.keys == null) {
            System.arraycopy(this.items, 0, tableItemArray, 0, n);
        } else {
            int n2 = 0;
            while (n2 < this.keyCount) {
                if (this.keys[n2] >= n) break;
                tableItemArray[this.keys[n2]] = this.items[this.keys[n2]];
                ++n2;
            }
        }
    }

    boolean _hasItems() {
        return this.items != null;
    }

    void _initItems() {
        this.items = new TableItem[4];
        if (COMPRESS_ITEMS && (this.style & 0x10000000) != 0) {
            this.keyCount = 0;
            this.keys = new int[4];
        }
    }

    void _insertItem(int n, TableItem tableItem, int n2) {
        if (this.keys == null) {
            System.arraycopy(this.items, n, this.items, n + 1, n2 - n);
            this.items[n] = tableItem;
        } else {
            int n3 = this.binarySearch(this.keys, 0, this.keyCount, n);
            if (n3 < 0) {
                n3 = -n3 - 1;
            }
            System.arraycopy(this.keys, n3, this.keys, n3 + 1, this.keyCount - n3);
            this.keys[n3] = n;
            System.arraycopy(this.items, n3, this.items, n3 + 1, this.keyCount - n3);
            this.items[n3] = tableItem;
            ++this.keyCount;
            int n4 = n3 + 1;
            while (n4 < this.keyCount) {
                int n5 = n4++;
                this.keys[n5] = this.keys[n5] + 1;
            }
        }
    }

    void _removeItem(int n, int n2) {
        if (this.keys == null) {
            System.arraycopy(this.items, n + 1, this.items, n, --n2 - n);
            this.items[n2] = null;
        } else {
            int n3 = this.binarySearch(this.keys, 0, this.keyCount, n);
            if (n3 < 0) {
                n3 = -n3 - 1;
            } else {
                --this.keyCount;
                System.arraycopy(this.keys, n3 + 1, this.keys, n3, this.keyCount - n3);
                this.keys[this.keyCount] = 0;
                System.arraycopy(this.items, n3 + 1, this.items, n3, this.keyCount - n3);
                this.items[this.keyCount] = null;
            }
            int n4 = n3;
            while (n4 < this.keyCount) {
                int n5 = n4++;
                this.keys[n5] = this.keys[n5] - 1;
            }
        }
    }

    void _removeItems(int n, int n2, int n3) {
        if (this.keys == null) {
            System.arraycopy(this.items, n2, this.items, n, n3 - n2);
            int n4 = n3 - (n2 - n);
            while (n4 < n3) {
                this.items[n4] = null;
                ++n4;
            }
        } else {
            int n5;
            int n6 = n2;
            int n7 = this.binarySearch(this.keys, 0, this.keyCount, n);
            if (n7 < 0) {
                n7 = -n7 - 1;
            }
            if ((n5 = this.binarySearch(this.keys, n7, this.keyCount, n6)) < 0) {
                n5 = -n5 - 1;
            }
            System.arraycopy(this.keys, n5, this.keys, n7, this.keyCount - n5);
            int n8 = this.keyCount - (n5 - n7);
            while (n8 < this.keyCount) {
                this.keys[n8] = 0;
                ++n8;
            }
            System.arraycopy(this.items, n5, this.items, n7, this.keyCount - n5);
            n8 = this.keyCount - (n5 - n7);
            while (n8 < this.keyCount) {
                this.items[n8] = null;
                ++n8;
            }
            this.keyCount -= n5 - n7;
            n8 = n7;
            while (n8 < this.keyCount) {
                int n9 = n8++;
                this.keys[n9] = this.keys[n9] - (n5 - n7);
            }
        }
    }

    void _setItemCount(int n, int n2) {
        if (this.keys == null) {
            int n3 = Math.max(4, (n + 3) / 4 * 4);
            TableItem[] tableItemArray = new TableItem[n3];
            System.arraycopy(this.items, 0, tableItemArray, 0, Math.min(n, n2));
            this.items = tableItemArray;
        } else {
            int n4 = Math.min(n, n2);
            this.keyCount = this.binarySearch(this.keys, 0, this.keyCount, n4);
            if (this.keyCount < 0) {
                this.keyCount = -this.keyCount - 1;
            }
            int n5 = Math.max(4, (this.keyCount + 3) / 4 * 4);
            int[] nArray = new int[n5];
            System.arraycopy(this.keys, 0, nArray, 0, this.keyCount);
            this.keys = nArray;
            TableItem[] tableItemArray = new TableItem[n5];
            System.arraycopy(this.items, 0, tableItemArray, 0, this.keyCount);
            this.items = tableItemArray;
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    long callWindowProc(long l, int n, long l2, long l3) {
        return this.callWindowProc(l, n, l2, l3, false);
    }

    long callWindowProc(long l, int n, long l2, long l3, boolean bl) {
        int n2;
        if (this.handle == 0L) {
            return 0L;
        }
        if (this.handle != l) {
            return OS.CallWindowProc(HeaderProc, l, n, l2, l3);
        }
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        switch (n) {
            case 256: {
                bl3 = true;
            }
            case 71: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 277: 
            case 646: {
                boolean bl5 = bl4 = this.findImageControl() != null && this.getDrawing() && OS.IsWindowVisible(this.handle);
                if (bl4) {
                    OS.DefWindowProc(this.handle, 11, 0L, 0L);
                    OS.SendMessage(this.handle, 4097, 0L, 0xFFFFFFL);
                }
            }
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 673: 
            case 675: {
                bl2 = true;
            }
            case 48: 
            case 275: {
                if (this.findImageControl() == null) break;
                n3 = (int)OS.SendMessage(this.handle, 4135, 0L, 0L);
            }
        }
        boolean bl6 = this.wasSelected;
        if (bl2) {
            this.wasSelected = false;
        }
        if (bl3) {
            this.ignoreActivate = true;
        }
        boolean bl7 = false;
        if (n == 15 && ((n2 = OS.GetWindowLong(this.handle, -16)) & 0x4000) == 0) {
            long l4 = OS.GetParent(this.handle);
            long l5 = 0L;
            while (l4 != 0L) {
                int n4 = OS.GetWindowLong(l4, -20);
                if ((n4 & 0x2000000) != 0) {
                    bl7 = true;
                    break;
                }
                l5 = OS.GetWindow(l4, 4);
                if (l5 != 0L) break;
                l4 = OS.GetParent(l4);
            }
        }
        n2 = 0;
        if ((this.style & 0x100) == 0 || (this.style & 0x200) == 0) {
            switch (n) {
                case 15: 
                case 70: 
                case 133: {
                    int n5 = OS.GetWindowLong(l, -16);
                    if ((this.style & 0x100) == 0 && (n5 & 0x100000) != 0) {
                        n2 = 1;
                        n5 &= 0xFFEFFFFF;
                    }
                    if ((this.style & 0x200) == 0 && (n5 & 0x200000) != 0) {
                        n2 = 1;
                        n5 &= 0xFFDFFFFF;
                    }
                    if (n2 == 0) break;
                    OS.SetWindowLong(this.handle, -16, n5);
                }
            }
        }
        long l6 = 0L;
        if (bl7) {
            PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
            long l7 = OS.BeginPaint(l, pAINTSTRUCT);
            l6 = OS.CallWindowProc(TableProc, l, 15, l7, l3);
            OS.EndPaint(l, pAINTSTRUCT);
        } else {
            l6 = OS.CallWindowProc(TableProc, l, n, l2, l3);
        }
        if (n2 != 0) {
            int n6 = 1025;
            OS.RedrawWindow(this.handle, null, 0L, n6);
        }
        if (bl3) {
            this.ignoreActivate = false;
        }
        if (bl2) {
            if (this.wasSelected || bl) {
                Event event = new Event();
                int n7 = (int)OS.SendMessage(this.handle, 4108, -1L, 1L);
                if (n7 != -1) {
                    event.item = this._getItem(n7);
                }
                this.sendSelectionEvent(13, event, false);
            }
            this.wasSelected = bl6;
        }
        switch (n) {
            case 71: 
            case 256: 
            case 257: 
            case 258: 
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 277: 
            case 646: {
                if (bl4) {
                    OS.SendMessage(this.handle, 4097, 0L, -1L);
                    OS.DefWindowProc(this.handle, 11, 1L, 0L);
                    OS.InvalidateRect(this.handle, null, true);
                    long l8 = OS.SendMessage(this.handle, 4127, 0L, 0L);
                    if (l8 != 0L) {
                        OS.InvalidateRect(l8, null, true);
                    }
                }
            }
            case 48: 
            case 275: 
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 520: 
            case 521: 
            case 522: 
            case 523: 
            case 524: 
            case 525: 
            case 673: 
            case 675: {
                if (this.findImageControl() == null || (long)n3 == OS.SendMessage(this.handle, 4135, 0L, 0L)) break;
                OS.InvalidateRect(this.handle, null, true);
                break;
            }
            case 15: {
                this.painted = true;
            }
        }
        return l6;
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Table.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    LRESULT CDDS_ITEMPOSTPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, long l, long l2) {
        int n;
        int n2;
        long l3 = nMLVCUSTOMDRAW.hdc;
        if (this.explorerTheme && !this.ignoreCustomDraw) {
            this.hotIndex = -1;
            if (this.hooks(40) && nMLVCUSTOMDRAW.left != nMLVCUSTOMDRAW.right) {
                OS.RestoreDC(l3, -1);
            }
        }
        if (!this.ignoreCustomDraw && !this.ignoreDrawFocus && nMLVCUSTOMDRAW.left != nMLVCUSTOMDRAW.right && OS.IsWindowVisible(this.handle) && OS.IsWindowEnabled(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) == -1 && ((n2 = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 0x20) == 0 && OS.SendMessage(this.handle, 4108, -1L, 1L) == nMLVCUSTOMDRAW.dwItemSpec && this.handle == OS.GetFocus() && ((n = (int)OS.SendMessage(this.handle, 297, 0L, 0L)) & 1) == 0) {
            RECT rECT = new RECT();
            rECT.left = 0;
            boolean bl = this.ignoreCustomDraw;
            this.ignoreCustomDraw = true;
            OS.SendMessage(this.handle, 4110, nMLVCUSTOMDRAW.dwItemSpec, rECT);
            long l4 = OS.SendMessage(this.handle, 4127, 0L, 0L);
            int n3 = (int)OS.SendMessage(l4, 4623, 0L, 0L);
            RECT rECT2 = new RECT();
            if (n3 == 0) {
                rECT2.left = 2;
                OS.SendMessage(this.handle, 4110, (long)n3, rECT2);
            } else {
                rECT2.top = n3;
                rECT2.left = 1;
                OS.SendMessage(this.handle, 4152, nMLVCUSTOMDRAW.dwItemSpec, rECT2);
            }
            this.ignoreCustomDraw = bl;
            rECT.left = rECT2.left;
            OS.DrawFocusRect(nMLVCUSTOMDRAW.hdc, rECT);
        }
        return null;
    }

    LRESULT CDDS_ITEMPREPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, long l, long l2) {
        int n;
        if (!this.ignoreCustomDraw && OS.IsWindowVisible(this.handle) && OS.IsWindowEnabled(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) == -1 && ((n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 0x20) == 0 && (nMLVCUSTOMDRAW.uItemState & 0x10) != 0) {
            nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFEF;
            OS.MoveMemory(l2, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
        }
        if (this.explorerTheme && !this.ignoreCustomDraw) {
            int n2 = this.hotIndex = (nMLVCUSTOMDRAW.uItemState & 0x40) != 0 ? (int)nMLVCUSTOMDRAW.dwItemSpec : -1;
            if (this.hooks(40) && nMLVCUSTOMDRAW.left != nMLVCUSTOMDRAW.right) {
                OS.SaveDC(nMLVCUSTOMDRAW.hdc);
                long l3 = OS.CreateRectRgn(0, 0, 0, 0);
                OS.SelectClipRgn(nMLVCUSTOMDRAW.hdc, l3);
                OS.DeleteObject(l3);
            }
        }
        return new LRESULT(48L);
    }

    LRESULT CDDS_POSTPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, long l, long l2) {
        int n;
        if (this.ignoreCustomDraw) {
            return null;
        }
        if (--this.customCount == 0 && OS.IsWindowVisible(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) == -1 && ((n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 0x20) == 0) {
            int n2 = 32;
            long l3 = OS.SendMessage(this.handle, 4170, 0L, 0L);
            if (OS.IsWinCE) {
                RECT rECT = new RECT();
                boolean bl = OS.GetUpdateRect(this.handle, rECT, true);
                OS.SendMessage(this.handle, 4150, (long)n2, (long)n2);
                OS.ValidateRect(this.handle, null);
                if (bl) {
                    OS.InvalidateRect(this.handle, rECT, true);
                }
            } else {
                long l4 = OS.CreateRectRgn(0, 0, 0, 0);
                int n3 = OS.GetUpdateRgn(this.handle, l4, true);
                OS.SendMessage(this.handle, 4150, (long)n2, (long)n2);
                OS.ValidateRect(this.handle, null);
                if (n3 != 1) {
                    OS.InvalidateRgn(this.handle, l4, true);
                }
                OS.DeleteObject(l4);
            }
            l3 = OS.SendMessage(this.handle, 4170, l3, l3);
        }
        return null;
    }

    LRESULT CDDS_PREPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, long l, long l2) {
        int n;
        if (this.ignoreCustomDraw) {
            return new LRESULT(48L);
        }
        if (this.customCount++ == 0 && OS.IsWindowVisible(this.handle) && !this.explorerTheme && (this.style & 0x10000) != 0 && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) == -1 && ((n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 0x20) != 0) {
            int n2 = 32;
            long l3 = OS.SendMessage(this.handle, 4170, 0L, 0L);
            if (OS.IsWinCE) {
                RECT rECT = new RECT();
                boolean bl = OS.GetUpdateRect(this.handle, rECT, true);
                OS.SendMessage(this.handle, 4150, (long)n2, 0L);
                OS.ValidateRect(this.handle, null);
                if (bl) {
                    OS.InvalidateRect(this.handle, rECT, true);
                }
            } else {
                long l4 = OS.CreateRectRgn(0, 0, 0, 0);
                int n3 = OS.GetUpdateRgn(this.handle, l4, true);
                OS.SendMessage(this.handle, 4150, (long)n2, 0L);
                OS.ValidateRect(this.handle, null);
                if (n3 != 1) {
                    OS.InvalidateRgn(this.handle, l4, true);
                }
                OS.DeleteObject(l4);
            }
            l3 = OS.SendMessage(this.handle, 4170, l3, l3);
        }
        if (OS.IsWindowVisible(this.handle)) {
            n = 1;
            if (this.explorerTheme && this.columnCount == 0) {
                long l5 = nMLVCUSTOMDRAW.hdc;
                RECT rECT = new RECT();
                OS.SetRect(rECT, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                if (OS.IsWindowEnabled(this.handle) || this.findImageControl() != null) {
                    this.drawBackground(l5, rECT);
                } else {
                    this.fillBackground(l5, OS.GetSysColor(OS.COLOR_3DFACE), rECT);
                }
                n = 0;
            }
            if (n != 0) {
                Control control = this.findBackgroundControl();
                if (control != null && control.backgroundImage != null) {
                    RECT rECT = new RECT();
                    OS.SetRect(rECT, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                    this.fillImageBackground(nMLVCUSTOMDRAW.hdc, control, rECT, 0, 0);
                } else if ((int)OS.SendMessage(this.handle, 4096, 0L, 0L) == -1 && OS.IsWindowEnabled(this.handle)) {
                    int n4;
                    RECT rECT = new RECT();
                    OS.SetRect(rECT, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                    if (control == null) {
                        control = this;
                    }
                    this.fillBackground(nMLVCUSTOMDRAW.hdc, control.getBackgroundPixel(), rECT);
                    if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && (n4 = this.indexOf(this.sortColumn)) != -1) {
                        this.parent.forceResize();
                        int n5 = this.getSortColumnPixel();
                        RECT rECT2 = new RECT();
                        RECT rECT3 = new RECT();
                        OS.GetClientRect(this.handle, rECT2);
                        long l6 = OS.SendMessage(this.handle, 4127, 0L, 0L);
                        if (OS.SendMessage(l6, 4615, (long)n4, rECT3) != 0L) {
                            OS.MapWindowPoints(l6, this.handle, rECT3, 2);
                            rECT2.left = rECT3.left;
                            rECT2.right = rECT3.right;
                            if (OS.IntersectRect(rECT2, rECT2, rECT)) {
                                this.fillBackground(nMLVCUSTOMDRAW.hdc, n5, rECT2);
                            }
                        }
                    }
                }
            }
        }
        return new LRESULT(48L);
    }

    LRESULT CDDS_SUBITEMPOSTPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, long l, long l2) {
        if (this.ignoreCustomDraw) {
            return null;
        }
        if (nMLVCUSTOMDRAW.left == nMLVCUSTOMDRAW.right) {
            return new LRESULT(0L);
        }
        long l3 = nMLVCUSTOMDRAW.hdc;
        if (this.ignoreDrawForeground) {
            OS.RestoreDC(l3, -1);
        }
        if (OS.IsWindowVisible(this.handle)) {
            int n;
            if ((int)OS.SendMessage(this.handle, 4096, 0L, 0L) != -1 && (this.sortDirection & 0x480) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed() && (n = (int)OS.SendMessage(this.handle, 4270, 0L, 0L)) == -1) {
                int n2 = this.indexOf(this.sortColumn);
                int n3 = 0;
                long l4 = 0L;
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    l4 = OS.CreateRectRgn(0, 0, 0, 0);
                    n3 = OS.GetUpdateRgn(this.handle, l4, true);
                }
                OS.SendMessage(this.handle, 4236, (long)n2, 0L);
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    OS.ValidateRect(this.handle, null);
                    if (n3 != 1) {
                        OS.InvalidateRgn(this.handle, l4, true);
                    }
                    OS.DeleteObject(l4);
                }
            }
            if (this.hooks(42)) {
                TableItem tableItem = this._getItem((int)nMLVCUSTOMDRAW.dwItemSpec);
                this.sendPaintItemEvent(tableItem, nMLVCUSTOMDRAW);
            }
            if (!this.ignoreDrawFocus && this.focusRect != null) {
                OS.SetTextColor(nMLVCUSTOMDRAW.hdc, 0);
                OS.SetBkColor(nMLVCUSTOMDRAW.hdc, 0xFFFFFF);
                OS.DrawFocusRect(nMLVCUSTOMDRAW.hdc, this.focusRect);
                this.focusRect = null;
            }
        }
        return null;
    }

    LRESULT CDDS_SUBITEMPREPAINT(NMLVCUSTOMDRAW nMLVCUSTOMDRAW, long l, long l2) {
        long l3;
        Object object;
        int n;
        int n2;
        int n3;
        TableItem tableItem;
        long l4 = nMLVCUSTOMDRAW.hdc;
        if (this.explorerTheme && !this.ignoreCustomDraw && this.hooks(40) && nMLVCUSTOMDRAW.left != nMLVCUSTOMDRAW.right) {
            OS.RestoreDC(l4, -1);
        }
        if ((tableItem = this._getItem((int)nMLVCUSTOMDRAW.dwItemSpec)) == null || tableItem.isDisposed()) {
            return null;
        }
        long l5 = tableItem.fontHandle(nMLVCUSTOMDRAW.iSubItem);
        if (l5 != -1L) {
            OS.SelectObject(l4, l5);
        }
        if (this.ignoreCustomDraw || nMLVCUSTOMDRAW.left == nMLVCUSTOMDRAW.right) {
            return new LRESULT(l5 == -1L ? 0 : 2);
        }
        int n4 = 0;
        this.selectionForeground = -1;
        this.ignoreDrawBackground = false;
        this.ignoreDrawFocus = false;
        this.ignoreDrawSelection = false;
        this.ignoreDrawForeground = false;
        if (OS.IsWindowVisible(this.handle)) {
            Event event = null;
            if (this.hooks(41)) {
                event = this.sendMeasureItemEvent(tableItem, (int)nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, nMLVCUSTOMDRAW.hdc);
                if (this.isDisposed() || tableItem.isDisposed()) {
                    return null;
                }
            }
            if (this.hooks(40)) {
                this.sendEraseItemEvent(tableItem, nMLVCUSTOMDRAW, l2, event);
                if (this.isDisposed() || tableItem.isDisposed()) {
                    return null;
                }
                n4 |= 0x10;
            }
            if (this.ignoreDrawForeground || this.hooks(42)) {
                n4 |= 0x10;
            }
        }
        int n5 = n3 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n3 == -1) {
            n3 = tableItem.foreground;
        }
        int n6 = n2 = tableItem.cellBackground != null ? tableItem.cellBackground[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n2 == -1) {
            n2 = tableItem.background;
        }
        if (this.selectionForeground != -1) {
            n3 = this.selectionForeground;
        }
        if (OS.IsWindowVisible(this.handle) && OS.IsWindowEnabled(this.handle) && !this.explorerTheme && !this.ignoreDrawSelection && (this.style & 0x10000) != 0 && ((n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 0x20) == 0) {
            object = new LVITEM();
            ((LVITEM)object).mask = 8;
            ((LVITEM)object).stateMask = 2;
            ((LVITEM)object).iItem = (int)nMLVCUSTOMDRAW.dwItemSpec;
            l3 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0L, (LVITEM)object);
            if (l3 != 0L && (((LVITEM)object).state & 2) != 0) {
                int n7 = -1;
                if (nMLVCUSTOMDRAW.iSubItem == 0) {
                    if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                        n7 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                    } else if ((this.style & 0x8000) == 0) {
                        n7 = OS.GetSysColor(OS.COLOR_3DFACE);
                    }
                } else if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                    n3 = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                    n2 = n7 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                } else if ((this.style & 0x8000) == 0) {
                    n2 = n7 = OS.GetSysColor(OS.COLOR_3DFACE);
                }
                if (n7 != -1) {
                    RECT rECT = tableItem.getBounds((int)nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, nMLVCUSTOMDRAW.iSubItem != 0, true, false, l4);
                    this.fillBackground(l4, n7, rECT);
                }
            }
        }
        if (!this.ignoreDrawForeground) {
            long l6;
            int n8;
            n = 1;
            if (l5 == -1L && n3 == -1 && n2 == -1 && tableItem.cellForeground == null && tableItem.cellBackground == null && tableItem.cellFont == null && (n8 = (int)OS.SendMessage(l6 = OS.SendMessage(this.handle, 4127, 0L, 0L), 4608, 0L, 0L)) == 1) {
                n = 0;
            }
            if (n != 0) {
                if (l5 == -1L) {
                    l5 = OS.SendMessage(this.handle, 49, 0L, 0L);
                }
                OS.SelectObject(l4, l5);
                if (OS.IsWindowEnabled(this.handle)) {
                    int n9 = nMLVCUSTOMDRAW.clrText = n3 == -1 ? this.getForegroundPixel() : n3;
                    if (n2 == -1) {
                        nMLVCUSTOMDRAW.clrTextBk = -1;
                        if (this.selectionForeground == -1) {
                            object = this.findBackgroundControl();
                            if (object == null) {
                                object = this;
                            }
                            if (((Control)object).backgroundImage == null && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) != -1) {
                                nMLVCUSTOMDRAW.clrTextBk = ((Control)object).getBackgroundPixel();
                            }
                        }
                    } else {
                        nMLVCUSTOMDRAW.clrTextBk = this.selectionForeground != -1 ? -1 : n2;
                    }
                    OS.MoveMemory(l2, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
                }
                n4 |= 2;
            }
        }
        if (OS.IsWindowEnabled(this.handle)) {
            if (n2 != -1 && (n = (int)OS.SendMessage(this.handle, 4270, 0L, 0L)) != -1 && n == nMLVCUSTOMDRAW.iSubItem) {
                int n10 = 0;
                l3 = 0L;
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    l3 = OS.CreateRectRgn(0, 0, 0, 0);
                    n10 = OS.GetUpdateRgn(this.handle, l3, true);
                }
                OS.SendMessage(this.handle, 4236, -1L, 0L);
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    OS.ValidateRect(this.handle, null);
                    if (n10 != 1) {
                        OS.InvalidateRgn(this.handle, l3, true);
                    }
                    OS.DeleteObject(l3);
                }
                n4 |= 0x10;
            }
        } else {
            nMLVCUSTOMDRAW.clrText = OS.GetSysColor(OS.COLOR_GRAYTEXT);
            nMLVCUSTOMDRAW.clrTextBk = this.findImageControl() != null ? -1 : OS.GetSysColor(OS.COLOR_3DFACE);
            nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFFE;
            OS.MoveMemory(l2, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
            n4 |= 2;
        }
        return new LRESULT(n4);
    }

    void checkBuffered() {
        super.checkBuffered();
        if (OS.COMCTL32_MAJOR >= 6) {
            this.style |= 0x20000000;
        }
        if ((this.style & 0x10000000) != 0) {
            this.style |= 0x20000000;
        }
    }

    boolean checkData(TableItem tableItem, boolean bl) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        return this.checkData(tableItem, this.indexOf(tableItem), bl);
    }

    boolean checkData(TableItem tableItem, int n, boolean bl) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        if (!tableItem.cached) {
            tableItem.cached = true;
            Event event = new Event();
            event.item = tableItem;
            event.index = n;
            this.currentItem = tableItem;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || tableItem.isDisposed()) {
                return false;
            }
            if (bl && !this.setScrollWidth(tableItem, false)) {
                tableItem.redraw();
            }
        }
        return true;
    }

    boolean checkHandle(long l) {
        if (l == this.handle) {
            return true;
        }
        return l == OS.SendMessage(this.handle, 4127, 0L, 0L);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int n) {
        TableItem tableItem;
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        if ((tableItem = this._getItem(n, false)) != null) {
            if (tableItem != this.currentItem) {
                tableItem.clear();
            }
            if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 17;
                lVITEM.pszText = -1L;
                lVITEM.iItem = n;
                OS.SendMessage(this.handle, OS.LVM_SETITEM, 0L, lVITEM);
                tableItem.cached = false;
            }
            if (this.currentItem == null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                OS.SendMessage(this.handle, 4117, (long)n, (long)n);
            }
            this.setScrollWidth(tableItem, false);
        }
    }

    public void clear(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        if (n == 0 && n2 == n3 - 1) {
            this.clearAll();
        } else {
            LVITEM lVITEM = null;
            boolean bl = false;
            int n4 = n;
            while (n4 <= n2) {
                TableItem tableItem = this._getItem(n4, false);
                if (tableItem != null) {
                    if (tableItem != this.currentItem) {
                        bl = true;
                        tableItem.clear();
                    }
                    if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                        if (lVITEM == null) {
                            lVITEM = new LVITEM();
                            lVITEM.mask = 17;
                            lVITEM.pszText = -1L;
                        }
                        lVITEM.iItem = n4;
                        OS.SendMessage(this.handle, OS.LVM_SETITEM, 0L, lVITEM);
                        tableItem.cached = false;
                    }
                }
                ++n4;
            }
            if (bl) {
                if (this.currentItem == null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                    OS.SendMessage(this.handle, 4117, (long)n, (long)n2);
                }
                TableItem tableItem = n == n2 ? this._getItem(n, false) : null;
                this.setScrollWidth(tableItem, false);
            }
        }
    }

    public void clear(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int n = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] < 0 || nArray[n2] >= n) {
                this.error(6);
            }
            ++n2;
        }
        LVITEM lVITEM = null;
        boolean bl = false;
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = nArray[n3];
            TableItem tableItem = this._getItem(n4, false);
            if (tableItem != null) {
                if (tableItem != this.currentItem) {
                    bl = true;
                    tableItem.clear();
                }
                if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                    if (lVITEM == null) {
                        lVITEM = new LVITEM();
                        lVITEM.mask = 17;
                        lVITEM.pszText = -1L;
                    }
                    lVITEM.iItem = n3;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0L, lVITEM);
                    tableItem.cached = false;
                }
                if (this.currentItem == null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                    OS.SendMessage(this.handle, 4117, (long)n4, (long)n4);
                }
            }
            ++n3;
        }
        if (bl) {
            this.setScrollWidth(null, false);
        }
    }

    public void clearAll() {
        this.checkWidget();
        LVITEM lVITEM = null;
        boolean bl = false;
        int n = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = this._getItem(n2, false);
            if (tableItem != null) {
                if (tableItem != this.currentItem) {
                    bl = true;
                    tableItem.clear();
                }
                if ((this.style & 0x10000000) == 0 && tableItem.cached) {
                    if (lVITEM == null) {
                        lVITEM = new LVITEM();
                        lVITEM.mask = 17;
                        lVITEM.pszText = -1L;
                    }
                    lVITEM.iItem = n2;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0L, lVITEM);
                    tableItem.cached = false;
                }
            }
            ++n2;
        }
        if (bl) {
            if (this.currentItem == null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
                OS.SendMessage(this.handle, 4117, 0L, (long)(n - 1));
            }
            this.setScrollWidth(null, false);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        this.checkWidget();
        if (this.fixScrollWidth) {
            this.setScrollWidth(null, true);
        }
        long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
        RECT rECT = new RECT();
        OS.GetWindowRect(l, rECT);
        int n4 = rECT.bottom - rECT.top;
        int n5 = 0;
        if (n != -1) {
            n5 |= n & 0xFFFF;
        } else {
            int n6 = 0;
            int n7 = (int)OS.SendMessage(l, 4608, 0L, 0L);
            n3 = 0;
            while (n3 < n7) {
                n6 = (int)((long)n6 + OS.SendMessage(this.handle, 4125, (long)n3, 0L));
                ++n3;
            }
            n5 |= n6 & 0xFFFF;
        }
        long l2 = OS.SendMessage(this.handle, 4160, -1L, OS.MAKELPARAM(n5, 65535));
        n3 = OS.LOWORD(l2);
        long l3 = OS.SendMessage(this.handle, 4160, 0L, 0L);
        long l4 = OS.SendMessage(this.handle, 4160, 1L, 0L);
        int n8 = OS.HIWORD(l4) - OS.HIWORD(l3);
        n4 += (int)OS.SendMessage(this.handle, 4100, 0L, 0L) * n8;
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n9 = this.getBorderWidth();
        n3 += n9 * 2;
        n4 += n9 * 2;
        if ((this.style & 0x200) != 0) {
            n3 += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            n4 += OS.GetSystemMetrics(3);
        }
        return new Point(n3, n4);
    }

    void createHandle() {
        long l;
        long l2;
        super.createHandle();
        this.state &= 0xFFFFFEFD;
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && OS.IsAppThemed()) {
            this.explorerTheme = true;
            OS.SetWindowTheme(this.handle, Display.EXPLORER, null);
        }
        if (HeaderProc == 0L) {
            l2 = OS.SendMessage(this.handle, 4127, 0L, 0L);
            HeaderProc = OS.GetWindowLongPtr(l2, -4);
        }
        if (!OS.IsWinCE && OS.COMCTL32_MAJOR < 6) {
            OS.SendMessage(this.handle, 8199, 5L, 0L);
        }
        if ((this.style & 0x20) != 0) {
            int n;
            l2 = OS.SendMessage(this.handle, 4160, 0L, 0L);
            long l3 = OS.SendMessage(this.handle, 4160, 1L, 0L);
            int n2 = n = OS.HIWORD(l3) - OS.HIWORD(l2);
            this.setCheckboxImageList(n, n2, false);
            OS.SendMessage(this.handle, 4107, 61440L, 0L);
        }
        l2 = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, l2, 0L);
        LVCOLUMN lVCOLUMN = new LVCOLUMN();
        lVCOLUMN.mask = 6;
        long l4 = OS.GetProcessHeap();
        lVCOLUMN.pszText = l = OS.HeapAlloc(l4, 8, TCHAR.sizeof);
        OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, 0L, lVCOLUMN);
        OS.HeapFree(l4, 0, l);
        int n = 16384;
        if ((this.style & 0x10000) != 0) {
            n |= 0x20;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            n |= 0x10000;
        }
        OS.SendMessage(this.handle, 4150, (long)n, (long)n);
        if (OS.WIN32_VERSION >= OS.VERSION(4, 10) && (this.style & 0x4000000) != 0) {
            long l5 = OS.SendMessage(this.handle, 4127, 0L, 0L);
            int n3 = OS.GetWindowLong(l5, -20);
            OS.SetWindowLong(l5, -20, n3 | 0x400000);
            long l6 = OS.SendMessage(this.handle, 4174, 0L, 0L);
            int n4 = OS.GetWindowLong(l6, -20);
            OS.SetWindowLong(l6, -20, n4 | 0x400000);
        }
    }

    void createHeaderToolTips() {
        if (OS.IsWinCE) {
            return;
        }
        if (this.headerToolTipHandle != 0L) {
            return;
        }
        int n = 0;
        if (OS.WIN32_VERSION >= OS.VERSION(4, 10) && (this.style & 0x4000000) != 0) {
            n |= 0x400000;
        }
        this.headerToolTipHandle = OS.CreateWindowEx(n, new TCHAR(0, "tooltips_class32", true), null, 2, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, this.handle, 0L, OS.GetModuleHandle(null), null);
        if (this.headerToolTipHandle == 0L) {
            this.error(2);
        }
        OS.SendMessage(this.headerToolTipHandle, 1048, 0L, 32767L);
    }

    void createItem(TableColumn tableColumn, int n) {
        Object object;
        int n2;
        if (n < 0 || n > this.columnCount) {
            this.error(6);
        }
        if ((n2 = (int)OS.SendMessage(this.handle, 4270, 0L, 0L)) >= n) {
            OS.SendMessage(this.handle, 4236, (long)(n2 + 1), 0L);
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] tableColumnArray = new TableColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columns.length);
            this.columns = tableColumnArray;
        }
        int n3 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        int n4 = 0;
        while (n4 < n3) {
            object = this._getItem(n4, false);
            if (object != null) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3;
                String[] stringArray = ((TableItem)object).strings;
                if (stringArray != null) {
                    objectArray3 = new String[this.columnCount + 1];
                    System.arraycopy(stringArray, 0, objectArray3, 0, n);
                    System.arraycopy(stringArray, n, objectArray3, n + 1, this.columnCount - n);
                    ((TableItem)object).strings = objectArray3;
                }
                if ((objectArray3 = ((TableItem)object).images) != null) {
                    objectArray2 = new Image[this.columnCount + 1];
                    System.arraycopy(objectArray3, 0, objectArray2, 0, n);
                    System.arraycopy(objectArray3, n, objectArray2, n + 1, this.columnCount - n);
                    ((TableItem)object).images = objectArray2;
                }
                if (n == 0 && this.columnCount != 0) {
                    if (stringArray == null) {
                        ((TableItem)object).strings = new String[this.columnCount + 1];
                        ((TableItem)object).strings[1] = ((TableItem)object).text;
                    }
                    ((TableItem)object).text = "";
                    if (objectArray3 == null) {
                        ((TableItem)object).images = new Image[this.columnCount + 1];
                        ((TableItem)object).images[1] = ((TableItem)object).image;
                    }
                    ((TableItem)object).image = null;
                }
                if (((TableItem)object).cellBackground != null) {
                    objectArray2 = ((TableItem)object).cellBackground;
                    objectArray = new int[this.columnCount + 1];
                    System.arraycopy(objectArray2, 0, objectArray, 0, n);
                    System.arraycopy(objectArray2, n, objectArray, n + 1, this.columnCount - n);
                    objectArray[n] = -1;
                    ((TableItem)object).cellBackground = objectArray;
                }
                if (((TableItem)object).cellForeground != null) {
                    objectArray2 = ((TableItem)object).cellForeground;
                    objectArray = new int[this.columnCount + 1];
                    System.arraycopy(objectArray2, 0, objectArray, 0, n);
                    System.arraycopy(objectArray2, n, objectArray, n + 1, this.columnCount - n);
                    objectArray[n] = -1;
                    ((TableItem)object).cellForeground = objectArray;
                }
                if (((TableItem)object).cellFont != null) {
                    objectArray2 = ((TableItem)object).cellFont;
                    objectArray = new Font[this.columnCount + 1];
                    System.arraycopy(objectArray2, 0, objectArray, 0, n);
                    System.arraycopy(objectArray2, n, objectArray, n + 1, this.columnCount - n);
                    ((TableItem)object).cellFont = (Font[])objectArray;
                }
            }
            ++n4;
        }
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = tableColumn;
        this.ignoreColumnResize = true;
        if (n == 0) {
            if (this.columnCount > 1) {
                LVCOLUMN lVCOLUMN = new LVCOLUMN();
                lVCOLUMN.mask = 2;
                OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, 1L, lVCOLUMN);
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 1L, lVCOLUMN);
                int n5 = lVCOLUMN.cx;
                int n6 = 1024;
                long l = OS.GetProcessHeap();
                int n7 = n6 * TCHAR.sizeof;
                long l2 = OS.HeapAlloc(l, 8, n7);
                lVCOLUMN.mask = 23;
                lVCOLUMN.pszText = l2;
                lVCOLUMN.cchTextMax = n6;
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 0L, lVCOLUMN);
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 1L, lVCOLUMN);
                lVCOLUMN.fmt = 2048;
                lVCOLUMN.cx = n5;
                lVCOLUMN.iImage = -2;
                lVCOLUMN.cchTextMax = 0;
                lVCOLUMN.pszText = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0L, lVCOLUMN);
                lVCOLUMN.mask = 1;
                lVCOLUMN.fmt = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0L, lVCOLUMN);
                if (l2 != 0L) {
                    OS.HeapFree(l, 0, l2);
                }
            } else {
                OS.SendMessage(this.handle, 4126, 0L, 0L);
            }
            if ((this.style & 0x10000000) == 0) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 3;
                lVITEM.pszText = -1L;
                lVITEM.iImage = -1;
                int n8 = 0;
                while (n8 < n3) {
                    lVITEM.iItem = n8++;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0L, lVITEM);
                }
            }
        } else {
            n4 = 0;
            if ((tableColumn.style & 0x1000000) == 0x1000000) {
                n4 = 2;
            }
            if ((tableColumn.style & 0x20000) == 131072) {
                n4 = 1;
            }
            object = new LVCOLUMN();
            ((LVCOLUMN)object).mask = 3;
            ((LVCOLUMN)object).fmt = n4;
            OS.SendMessage(this.handle, OS.LVM_INSERTCOLUMN, (long)n, (LVCOLUMN)object);
        }
        this.ignoreColumnResize = false;
        if (this.headerToolTipHandle != 0L) {
            RECT rECT = new RECT();
            long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
            if (OS.SendMessage(l, 4615, (long)n, rECT) != 0L) {
                TOOLINFO tOOLINFO = new TOOLINFO();
                tOOLINFO.cbSize = TOOLINFO.sizeof;
                tOOLINFO.uFlags = 16;
                tOOLINFO.hwnd = l;
                tableColumn.id = this.display.nextToolTipId++;
                tOOLINFO.uId = tableColumn.id;
                tOOLINFO.left = rECT.left;
                tOOLINFO.top = rECT.top;
                tOOLINFO.right = rECT.right;
                tOOLINFO.bottom = rECT.bottom;
                tOOLINFO.lpszText = -1L;
                OS.SendMessage(this.headerToolTipHandle, OS.TTM_ADDTOOL, 0L, tOOLINFO);
            }
        }
    }

    void createItem(TableItem tableItem, int n) {
        int n2 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (n < 0 || n > n2) {
            this.error(6);
        }
        this._checkGrow(n2);
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 3;
        lVITEM.iItem = n;
        lVITEM.pszText = -1L;
        lVITEM.iImage = -1;
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        int n3 = (int)OS.SendMessage(this.handle, OS.LVM_INSERTITEM, 0L, lVITEM);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (n3 == -1) {
            this.error(14);
        }
        this._insertItem(n, tableItem, n2);
        this.setDeferResize(false);
        if (n2 == 0) {
            this.setScrollWidth(tableItem, false);
        }
    }

    void createWidget() {
        super.createWidget();
        this.hotIndex = -1;
        this.itemHeight = -1;
        this._initItems();
        this.columns = new TableColumn[4];
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    void deregister() {
        super.deregister();
        long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
        if (l != 0L) {
            this.display.removeControl(l);
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.stateMask = 2;
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= 0) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, (long)nArray[n], lVITEM);
                this.ignoreSelect = false;
            }
            ++n;
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, (long)n, lVITEM);
        this.ignoreSelect = false;
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        int n3 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (n == 0 && n2 == n3 - 1) {
            this.deselectAll();
        } else {
            LVITEM lVITEM = new LVITEM();
            lVITEM.stateMask = 2;
            int n4 = n = Math.max(0, n);
            while (n4 <= n2) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, (long)n4, lVITEM);
                this.ignoreSelect = false;
                ++n4;
            }
        }
    }

    public void deselectAll() {
        this.checkWidget();
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1L, lVITEM);
        this.ignoreSelect = false;
    }

    void destroyItem(TableColumn tableColumn) {
        TableColumn[] tableColumnArray;
        int n;
        int n2 = 0;
        while (n2 < this.columnCount) {
            if (this.columns[n2] == tableColumn) break;
            ++n2;
        }
        int n3 = (int)OS.SendMessage(this.handle, 4270, 0L, 0L);
        if (n3 == n2) {
            OS.SendMessage(this.handle, 4236, -1L, 0L);
        } else if (n3 > n2) {
            OS.SendMessage(this.handle, 4236, (long)(n3 - 1), 0L);
        }
        int n4 = 0;
        int[] nArray = new int[this.columnCount];
        OS.SendMessage(this.handle, 4155, (long)this.columnCount, nArray);
        while (n4 < this.columnCount) {
            if (nArray[n4] == n2) break;
            ++n4;
        }
        this.ignoreColumnResize = true;
        boolean bl = false;
        if (n2 == 0) {
            bl = true;
            this.setRedraw(false);
            if (this.columnCount > 1) {
                n2 = 1;
                n = 1024;
                long l = OS.GetProcessHeap();
                int n5 = n * TCHAR.sizeof;
                long l2 = OS.HeapAlloc(l, 8, n5);
                LVCOLUMN lVCOLUMN = new LVCOLUMN();
                lVCOLUMN.mask = 23;
                lVCOLUMN.pszText = l2;
                lVCOLUMN.cchTextMax = n;
                OS.SendMessage(this.handle, OS.LVM_GETCOLUMN, 1L, lVCOLUMN);
                lVCOLUMN.fmt &= 0xFFFFFFFC;
                lVCOLUMN.fmt |= 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0L, lVCOLUMN);
                if (l2 != 0L) {
                    OS.HeapFree(l, 0, l2);
                }
            } else {
                long l = OS.GetProcessHeap();
                long l3 = OS.HeapAlloc(l, 8, TCHAR.sizeof);
                LVCOLUMN lVCOLUMN = new LVCOLUMN();
                lVCOLUMN.mask = 23;
                lVCOLUMN.pszText = l3;
                lVCOLUMN.iImage = -2;
                lVCOLUMN.fmt = 0;
                OS.SendMessage(this.handle, OS.LVM_SETCOLUMN, 0L, lVCOLUMN);
                if (l3 != 0L) {
                    OS.HeapFree(l, 0, l3);
                }
                if (OS.COMCTL32_MAJOR >= 6) {
                    tableColumnArray = new HDITEM();
                    tableColumnArray.mask = 4;
                    tableColumnArray.fmt = 0;
                    long l4 = OS.SendMessage(this.handle, 4127, 0L, 0L);
                    OS.SendMessage(l4, OS.HDM_SETITEM, (long)n2, (HDITEM)tableColumnArray);
                }
            }
            this.setRedraw(true);
            if ((this.style & 0x10000000) == 0) {
                LVITEM lVITEM = new LVITEM();
                lVITEM.mask = 3;
                lVITEM.pszText = -1L;
                lVITEM.iImage = -1;
                int n6 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
                int n7 = 0;
                while (n7 < n6) {
                    lVITEM.iItem = n7++;
                    OS.SendMessage(this.handle, OS.LVM_SETITEM, 0L, lVITEM);
                }
            }
        }
        if (this.columnCount > 1 && OS.SendMessage(this.handle, 4124, (long)n2, 0L) == 0L) {
            this.error(15);
        }
        if (bl) {
            n2 = 0;
        }
        System.arraycopy(this.columns, n2 + 1, this.columns, n2, --this.columnCount - n2);
        this.columns[this.columnCount] = null;
        n = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        int n8 = 0;
        while (n8 < n) {
            TableItem tableItem = this._getItem(n8, false);
            if (tableItem != null) {
                if (this.columnCount == 0) {
                    tableItem.strings = null;
                    tableItem.images = null;
                    tableItem.cellBackground = null;
                    tableItem.cellForeground = null;
                    tableItem.cellFont = null;
                } else {
                    if (tableItem.strings != null) {
                        String[] stringArray = tableItem.strings;
                        if (n2 == 0) {
                            tableItem.text = stringArray[1] != null ? stringArray[1] : "";
                        }
                        String[] stringArray2 = new String[this.columnCount];
                        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
                        System.arraycopy(stringArray, n2 + 1, stringArray2, n2, this.columnCount - n2);
                        tableItem.strings = stringArray2;
                    } else if (n2 == 0) {
                        tableItem.text = "";
                    }
                    if (tableItem.images != null) {
                        Image[] imageArray = tableItem.images;
                        if (n2 == 0) {
                            tableItem.image = imageArray[1];
                        }
                        Image[] imageArray2 = new Image[this.columnCount];
                        System.arraycopy(imageArray, 0, imageArray2, 0, n2);
                        System.arraycopy(imageArray, n2 + 1, imageArray2, n2, this.columnCount - n2);
                        tableItem.images = imageArray2;
                    } else if (n2 == 0) {
                        tableItem.image = null;
                    }
                    if (tableItem.cellBackground != null) {
                        int[] nArray2 = tableItem.cellBackground;
                        int[] nArray3 = new int[this.columnCount];
                        System.arraycopy(nArray2, 0, nArray3, 0, n2);
                        System.arraycopy(nArray2, n2 + 1, nArray3, n2, this.columnCount - n2);
                        tableItem.cellBackground = nArray3;
                    }
                    if (tableItem.cellForeground != null) {
                        int[] nArray4 = tableItem.cellForeground;
                        int[] nArray5 = new int[this.columnCount];
                        System.arraycopy(nArray4, 0, nArray5, 0, n2);
                        System.arraycopy(nArray4, n2 + 1, nArray5, n2, this.columnCount - n2);
                        tableItem.cellForeground = nArray5;
                    }
                    if (tableItem.cellFont != null) {
                        Font[] fontArray = tableItem.cellFont;
                        Font[] fontArray2 = new Font[this.columnCount];
                        System.arraycopy(fontArray, 0, fontArray2, 0, n2);
                        System.arraycopy(fontArray, n2 + 1, fontArray2, n2, this.columnCount - n2);
                        tableItem.cellFont = fontArray2;
                    }
                }
            }
            ++n8;
        }
        if (this.columnCount == 0) {
            this.setScrollWidth(null, true);
        }
        this.updateMoveable();
        this.ignoreColumnResize = false;
        if (this.columnCount != 0) {
            n8 = 0;
            int n9 = nArray[n4];
            int[] nArray6 = new int[this.columnCount];
            int n10 = 0;
            while (n10 < nArray.length) {
                if (nArray[n10] != n9) {
                    int n11 = nArray[n10] <= n9 ? nArray[n10] : nArray[n10] - 1;
                    nArray6[n8++] = n11;
                }
                ++n10;
            }
            OS.SendMessage(this.handle, 4155, (long)this.columnCount, nArray);
            n10 = 0;
            while (n10 < nArray6.length) {
                if (nArray[n10] != nArray6[n10]) break;
                ++n10;
            }
            if (n10 != nArray6.length) {
                OS.SendMessage(this.handle, 4154, (long)nArray6.length, nArray6);
                OS.InvalidateRect(this.handle, null, true);
            }
            tableColumnArray = new TableColumn[this.columnCount - n4];
            int n12 = n4;
            while (n12 < nArray6.length) {
                tableColumnArray[n12 - n4] = this.columns[nArray6[n12]];
                tableColumnArray[n12 - n4].updateToolTip(nArray6[n12]);
                ++n12;
            }
            n12 = 0;
            while (n12 < tableColumnArray.length) {
                if (!tableColumnArray[n12].isDisposed()) {
                    tableColumnArray[n12].sendEvent(10);
                }
                ++n12;
            }
        }
        if (this.headerToolTipHandle != 0L) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            tOOLINFO.uId = tableColumn.id;
            tOOLINFO.hwnd = OS.SendMessage(this.handle, 4127, 0L, 0L);
            OS.SendMessage(this.headerToolTipHandle, OS.TTM_DELTOOL, 0L, tOOLINFO);
        }
    }

    void destroyItem(TableItem tableItem) {
        int n = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        int n2 = 0;
        while (n2 < n) {
            if (this._getItem(n2, false) == tableItem) break;
            ++n2;
        }
        if (n2 == n) {
            return;
        }
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        long l = OS.SendMessage(this.handle, 4104, (long)n2, 0L);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (l == 0L) {
            this.error(15);
        }
        this._removeItem(n2, n);
        if (--n == 0) {
            this.setTableEmpty();
        }
        this.setDeferResize(false);
    }

    void fixCheckboxImageList(boolean bl) {
        if ((this.style & 0x20) == 0) {
            return;
        }
        long l = OS.SendMessage(this.handle, 4098, 1L, 0L);
        if (l == 0L) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(l, nArray, nArray2);
        long l2 = OS.SendMessage(this.handle, 4098, 2L, 0L);
        if (l2 == 0L) {
            return;
        }
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        OS.ImageList_GetIconSize(l2, nArray3, nArray4);
        if (nArray[0] == nArray3[0] && nArray2[0] == nArray4[0]) {
            return;
        }
        this.setCheckboxImageList(nArray[0], nArray2[0], bl);
    }

    void fixCheckboxImageListColor(boolean bl) {
        if ((this.style & 0x20) == 0) {
            return;
        }
        long l = OS.SendMessage(this.handle, 4098, 2L, 0L);
        if (l == 0L) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.ImageList_GetIconSize(l, nArray, nArray2);
        this.setCheckboxImageList(nArray[0], nArray2[0], bl);
    }

    void fixItemHeight(boolean bl) {
        long l;
        if (this.itemHeight != -1) {
            return;
        }
        if (OS.COMCTL32_VERSION >= OS.VERSION(5, 80)) {
            return;
        }
        int n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
        if ((n & 1) == 0) {
            return;
        }
        n = OS.GetWindowLong(this.handle, -16);
        if ((n & 0x4000) != 0) {
            return;
        }
        int n2 = this.getTopIndex();
        if (bl && n2 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if ((l = OS.SendMessage(this.handle, 4098, 1L, 0L)) != 0L) {
            return;
        }
        long l2 = OS.SendMessage(this.handle, 4127, 0L, 0L);
        RECT rECT = new RECT();
        OS.GetWindowRect(l2, rECT);
        int n3 = rECT.bottom - rECT.top - 1;
        long l3 = OS.ImageList_Create(1, n3, 0, 0, 0);
        OS.SendMessage(this.handle, 4099, 1L, l3);
        this.fixCheckboxImageList(false);
        OS.SendMessage(this.handle, 4099, 1L, 0L);
        if (this.headerImageList != null) {
            long l4 = this.headerImageList.getHandle();
            OS.SendMessage(l2, 4616, 0L, l4);
        }
        OS.ImageList_Destroy(l3);
        if (bl && n2 != 0) {
            this.setTopIndex(n2);
            this.setRedraw(true);
        }
    }

    public TableColumn getColumn(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        int[] nArray = new int[this.columnCount];
        OS.SendMessage(this.handle, 4155, (long)this.columnCount, nArray);
        return nArray;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
        return tableColumnArray;
    }

    int getFocusIndex() {
        return (int)OS.SendMessage(this.handle, 4108, -1L, 1L);
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
        if (l == 0L) {
            return 0;
        }
        RECT rECT = new RECT();
        OS.GetWindowRect(l, rECT);
        return rECT.bottom - rECT.top;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        int n = OS.GetWindowLong(this.handle, -16);
        return (n & 0x4000) == 0;
    }

    public TableItem getItem(int n) {
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        return this._getItem(n);
    }

    public TableItem getItem(Point point) {
        int n;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((n = (int)OS.SendMessage(this.handle, 4100, 0L, 0L)) == 0) {
            return null;
        }
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = point.x;
        lVHITTESTINFO.y = point.y;
        if ((this.style & 0x10000) == 0 && this.hooks(41)) {
            if (OS.SendMessage(this.handle, 4153, 0L, lVHITTESTINFO) < 0L) {
                RECT rECT = new RECT();
                rECT.left = 1;
                this.ignoreCustomDraw = true;
                long l = OS.SendMessage(this.handle, 4110, 0L, rECT);
                this.ignoreCustomDraw = false;
                if (l != 0L) {
                    lVHITTESTINFO.x = rECT.left;
                    OS.SendMessage(this.handle, 4153, 0L, lVHITTESTINFO);
                    if (lVHITTESTINFO.iItem < 0) {
                        lVHITTESTINFO.iItem = -1;
                    }
                }
            }
            if (lVHITTESTINFO.iItem != -1 && lVHITTESTINFO.iSubItem == 0 && this.hitTestSelection(lVHITTESTINFO.iItem, lVHITTESTINFO.x, lVHITTESTINFO.y)) {
                return this._getItem(lVHITTESTINFO.iItem);
            }
            return null;
        }
        OS.SendMessage(this.handle, 4114, 0L, lVHITTESTINFO);
        if (lVHITTESTINFO.iItem != -1) {
            long l;
            int n2;
            if (lVHITTESTINFO.iItem == 0 && ((n2 = OS.GetWindowLong(this.handle, -16)) & 0x4000) == 0 && (l = OS.SendMessage(this.handle, 4127, 0L, 0L)) != 0L) {
                RECT rECT = new RECT();
                OS.GetWindowRect(l, rECT);
                POINT pOINT = new POINT();
                pOINT.x = lVHITTESTINFO.x;
                pOINT.y = lVHITTESTINFO.y;
                OS.MapWindowPoints(this.handle, 0L, pOINT, 1);
                if (OS.PtInRect(rECT, pOINT)) {
                    return null;
                }
            }
            return this._getItem(lVHITTESTINFO.iItem);
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
    }

    public int getItemHeight() {
        this.checkWidget();
        if (!this.painted && this.hooks(41)) {
            this.hitTestSelection(0, 0, 0);
        }
        long l = OS.SendMessage(this.handle, 4160, 0L, 0L);
        long l2 = OS.SendMessage(this.handle, 4160, 1L, 0L);
        return OS.HIWORD(l2) - OS.HIWORD(l);
    }

    public TableItem[] getItems() {
        this.checkWidget();
        int n = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        TableItem[] tableItemArray = new TableItem[n];
        if ((this.style & 0x10000000) != 0) {
            int n2 = 0;
            while (n2 < n) {
                tableItemArray[n2] = this._getItem(n2);
                ++n2;
            }
        } else {
            this._getItems(tableItemArray, n);
        }
        return tableItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        int n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
        return (n & 1) != 0;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int n = -1;
        int n2 = 0;
        int n3 = (int)OS.SendMessage(this.handle, 4146, 0L, 0L);
        TableItem[] tableItemArray = new TableItem[n3];
        while ((n = (int)OS.SendMessage(this.handle, 4108, (long)n, 2L)) != -1) {
            tableItemArray[n2++] = this._getItem(n);
        }
        return tableItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return (int)OS.SendMessage(this.handle, 4146, 0L, 0L);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int n = (int)OS.SendMessage(this.handle, 4108, -1L, 1L);
        int n2 = (int)OS.SendMessage(this.handle, 4108, -1L, 2L);
        if (n == n2) {
            return n2;
        }
        int n3 = -1;
        while ((n3 = (int)OS.SendMessage(this.handle, 4108, (long)n3, 2L)) != -1) {
            if (n3 != n) continue;
            return n3;
        }
        return n2;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int n = -1;
        int n2 = 0;
        int n3 = (int)OS.SendMessage(this.handle, 4146, 0L, 0L);
        int[] nArray = new int[n3];
        while ((n = (int)OS.SendMessage(this.handle, 4108, (long)n, 2L)) != -1) {
            nArray[n2++] = n;
        }
        return nArray;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    int getSortColumnPixel() {
        int n = OS.IsWindowEnabled(this.handle) ? this.getBackgroundPixel() : OS.GetSysColor(OS.COLOR_3DFACE);
        int n2 = n & 0xFF;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = (n & 0xFF0000) >> 16;
        if (n2 > 240 && n3 > 240 && n4 > 240) {
            n2 -= 8;
            n3 -= 8;
            n4 -= 8;
        } else {
            n2 = Math.min(255, n2 / 10 + n2);
            n3 = Math.min(255, n3 / 10 + n3);
            n4 = Math.min(255, n4 / 10 + n4);
        }
        return n2 & 0xFF | (n3 & 0xFF) << 8 | (n4 & 0xFF) << 16;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        this.checkWidget();
        return Math.max(0, (int)OS.SendMessage(this.handle, 4135, 0L, 0L));
    }

    boolean hasChildren() {
        long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
        long l2 = OS.GetWindow(this.handle, 5);
        while (l2 != 0L) {
            if (l2 != l) {
                return true;
            }
            l2 = OS.GetWindow(l2, 2);
        }
        return false;
    }

    boolean hitTestSelection(int n, int n2, int n3) {
        int n4 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (n4 == 0) {
            return false;
        }
        if (!this.hooks(41)) {
            return false;
        }
        boolean bl = false;
        if (n >= 0 && n < n4) {
            Event event;
            long l;
            TableItem tableItem = this._getItem(n);
            long l2 = OS.GetDC(this.handle);
            long l3 = 0L;
            long l4 = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (l4 != 0L) {
                l3 = OS.SelectObject(l2, l4);
            }
            if ((l = tableItem.fontHandle(0)) != -1L) {
                l = OS.SelectObject(l2, l);
            }
            if ((event = this.sendMeasureItemEvent(tableItem, n, 0, l2)).getBounds().contains(n2, n3)) {
                bl = true;
            }
            if (l != -1L) {
                l = OS.SelectObject(l2, l);
            }
            if (l4 != 0L) {
                OS.SelectObject(l2, l3);
            }
            OS.ReleaseDC(this.handle, l2);
        }
        return bl;
    }

    int imageIndex(Image image, int n) {
        if (image == null) {
            return -2;
        }
        if (n == 0) {
            this.firstColumnImage = true;
        } else {
            this.setSubImagesVisible(true);
        }
        if (this.imageList == null) {
            Rectangle rectangle = image.getBounds();
            this.imageList = this.display.getImageList(this.style & 0x4000000, rectangle.width, rectangle.height);
            int n2 = this.imageList.indexOf(image);
            if (n2 == -1) {
                n2 = this.imageList.add(image);
            }
            long l = this.imageList.getHandle();
            int n3 = this.getTopIndex();
            if (n3 != 0) {
                this.setRedraw(false);
                this.setTopIndex(0);
            }
            OS.SendMessage(this.handle, 4099, 1L, l);
            if (this.headerImageList != null) {
                long l2 = OS.SendMessage(this.handle, 4127, 0L, 0L);
                long l3 = this.headerImageList.getHandle();
                OS.SendMessage(l2, 4616, 0L, l3);
            }
            this.fixCheckboxImageList(false);
            this.setItemHeight(false);
            if (n3 != 0) {
                this.setTopIndex(n3);
                this.setRedraw(true);
            }
            return n2;
        }
        int n4 = this.imageList.indexOf(image);
        if (n4 != -1) {
            return n4;
        }
        return this.imageList.add(image);
    }

    int imageIndexHeader(Image image) {
        if (image == null) {
            return -2;
        }
        if (this.headerImageList == null) {
            Rectangle rectangle = image.getBounds();
            this.headerImageList = this.display.getImageList(this.style & 0x4000000, rectangle.width, rectangle.height);
            int n = this.headerImageList.indexOf(image);
            if (n == -1) {
                n = this.headerImageList.add(image);
            }
            long l = this.headerImageList.getHandle();
            long l2 = OS.SendMessage(this.handle, 4127, 0L, 0L);
            OS.SendMessage(l2, 4616, 0L, l);
            return n;
        }
        int n = this.headerImageList.indexOf(image);
        if (n != -1) {
            return n;
        }
        return this.headerImageList.add(image);
    }

    public int indexOf(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n] == tableColumn) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOf(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (this.keys == null) {
            int n = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
            if (1 <= this.lastIndexOf && this.lastIndexOf < n - 1) {
                if (this._getItem(this.lastIndexOf, false) == tableItem) {
                    return this.lastIndexOf;
                }
                if (this._getItem(this.lastIndexOf + 1, false) == tableItem) {
                    return ++this.lastIndexOf;
                }
                if (this._getItem(this.lastIndexOf - 1, false) == tableItem) {
                    return --this.lastIndexOf;
                }
            }
            if (this.lastIndexOf < n / 2) {
                int n2 = 0;
                while (n2 < n) {
                    if (this._getItem(n2, false) == tableItem) {
                        this.lastIndexOf = n2;
                        return this.lastIndexOf;
                    }
                    ++n2;
                }
            } else {
                int n3 = n - 1;
                while (n3 >= 0) {
                    if (this._getItem(n3, false) == tableItem) {
                        this.lastIndexOf = n3;
                        return this.lastIndexOf;
                    }
                    --n3;
                }
            }
        } else {
            int n = 0;
            while (n < this.keyCount) {
                if (this.items[n] == tableItem) {
                    return this.keys[n];
                }
                ++n;
            }
        }
        return -1;
    }

    boolean isCustomToolTip() {
        return this.hooks(41);
    }

    boolean isOptimizedRedraw() {
        if ((this.style & 0x100) == 0 || (this.style & 0x200) == 0) {
            return false;
        }
        return !this.hasChildren() && !this.hooks(9) && !this.filters(9);
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        lVITEM.iItem = n;
        long l = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0L, lVITEM);
        return l != 0L && (lVITEM.state & 2) != 0;
    }

    void register() {
        super.register();
        long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
        if (l != 0L) {
            this.display.addControl(l, this);
        }
    }

    void releaseChildren(boolean bl) {
        int n;
        if (this._hasItems()) {
            TableItem tableItem;
            int n2;
            n = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
            if (OS.IsWin95 && this.columnCount > 1) {
                this.resizeCount = 1;
                OS.SendMessage(this.handle, 11, 0L, 0L);
                n2 = n - 1;
                while (n2 >= 0) {
                    tableItem = this._getItem(n2, false);
                    if (tableItem != null && !tableItem.isDisposed()) {
                        tableItem.release(false);
                    }
                    this.ignoreShrink = true;
                    this.ignoreSelect = true;
                    OS.SendMessage(this.handle, 4104, (long)n2, 0L);
                    this.ignoreShrink = false;
                    this.ignoreSelect = false;
                    --n2;
                }
            } else if (this.keys == null) {
                n2 = 0;
                while (n2 < n) {
                    tableItem = this._getItem(n2, false);
                    if (tableItem != null && !tableItem.isDisposed()) {
                        tableItem.release(false);
                    }
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < this.keyCount) {
                    tableItem = this.items[n2];
                    if (tableItem != null && !tableItem.isDisposed()) {
                        tableItem.release(false);
                    }
                    ++n2;
                }
            }
            this._clearItems();
        }
        if (this.columns != null) {
            n = 0;
            while (n < this.columnCount) {
                TableColumn tableColumn = this.columns[n];
                if (!tableColumn.isDisposed()) {
                    tableColumn.release(false);
                }
                ++n;
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        long l;
        super.releaseWidget();
        this.customDraw = false;
        this.currentItem = null;
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 4099, 1L, 0L);
            this.display.releaseImageList(this.imageList);
        }
        if (this.headerImageList != null) {
            l = OS.SendMessage(this.handle, 4127, 0L, 0L);
            OS.SendMessage(l, 4616, 0L, 0L);
            this.display.releaseImageList(this.headerImageList);
        }
        this.headerImageList = null;
        this.imageList = null;
        l = OS.SendMessage(this.handle, 4098, 2L, 0L);
        OS.SendMessage(this.handle, 4099, 2L, 0L);
        if (l != 0L) {
            OS.ImageList_Destroy(l);
        }
        if (this.headerToolTipHandle != 0L) {
            OS.DestroyWindow(this.headerToolTipHandle);
        }
        this.headerToolTipHandle = 0L;
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        int n3 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        this.setDeferResize(true);
        int n4 = -1;
        int n5 = 0;
        while (n5 < nArray2.length) {
            int n6 = nArray2[n5];
            if (n6 != n4) {
                TableItem tableItem = this._getItem(n6, false);
                if (tableItem != null && !tableItem.isDisposed()) {
                    tableItem.release(false);
                }
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                long l = OS.SendMessage(this.handle, 4104, (long)n6, 0L);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (l == 0L) {
                    this.error(15);
                }
                this._removeItem(n6, n3);
                --n3;
                n4 = n6;
            }
            ++n5;
        }
        if (n3 == 0) {
            this.setTableEmpty();
        }
        this.setDeferResize(false);
    }

    public void remove(int n) {
        TableItem tableItem;
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        if ((tableItem = this._getItem(n, false)) != null && !tableItem.isDisposed()) {
            tableItem.release(false);
        }
        this.setDeferResize(true);
        this.ignoreShrink = true;
        this.ignoreSelect = true;
        long l = OS.SendMessage(this.handle, 4104, (long)n, 0L);
        this.ignoreShrink = false;
        this.ignoreSelect = false;
        if (l == 0L) {
            this.error(15);
        }
        this._removeItem(n, n2);
        if (--n2 == 0) {
            this.setTableEmpty();
        }
        this.setDeferResize(false);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        if (n == 0 && n2 == n3 - 1) {
            this.removeAll();
        } else {
            this.setDeferResize(true);
            int n4 = n;
            while (n4 <= n2) {
                TableItem tableItem = this._getItem(n4, false);
                if (tableItem != null && !tableItem.isDisposed()) {
                    tableItem.release(false);
                }
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                long l = OS.SendMessage(this.handle, 4104, (long)n, 0L);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (l == 0L) break;
                ++n4;
            }
            this._removeItems(n, n4, n3);
            if (n4 <= n2) {
                this.error(15);
            }
            this.setDeferResize(false);
        }
    }

    public void removeAll() {
        this.checkWidget();
        int n = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = this._getItem(n2, false);
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            ++n2;
        }
        this.setDeferResize(true);
        if (OS.IsWin95 && this.columnCount > 1) {
            int n3 = n2 = this.getDrawing() && OS.IsWindowVisible(this.handle) ? 1 : 0;
            if (n2 != 0) {
                OS.SendMessage(this.handle, 11, 0L, 0L);
            }
            int n4 = n - 1;
            while (n4 >= 0) {
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                long l = OS.SendMessage(this.handle, 4104, (long)n4, 0L);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (l == 0L) break;
                --n4;
            }
            if (n2 != 0) {
                OS.SendMessage(this.handle, 11, 1L, 0L);
            }
            if (n4 != -1) {
                this.error(15);
            }
        } else {
            this.ignoreShrink = true;
            this.ignoreSelect = true;
            long l = OS.SendMessage(this.handle, 4105, 0L, 0L);
            this.ignoreShrink = false;
            this.ignoreSelect = false;
            if (l == 0L) {
                this.error(15);
            }
        }
        this.setTableEmpty();
        this.setDeferResize(false);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.state = 2;
        lVITEM.stateMask = 2;
        int n2 = n - 1;
        while (n2 >= 0) {
            if (nArray[n2] >= 0) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, (long)nArray[n2], lVITEM);
                this.ignoreSelect = false;
            }
            --n2;
        }
    }

    void reskinChildren(int n) {
        int n2;
        if (this._hasItems()) {
            n2 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
            int n3 = 0;
            while (n3 < n2) {
                TableItem tableItem = this._getItem(n3, false);
                if (tableItem != null) {
                    tableItem.reskin(n);
                }
                ++n3;
            }
        }
        if (this.columns != null) {
            n2 = 0;
            while (n2 < this.columnCount) {
                TableColumn tableColumn = this.columns[n2];
                if (!tableColumn.isDisposed()) {
                    tableColumn.reskin(n);
                }
                ++n2;
            }
        }
        super.reskinChildren(n);
    }

    public void select(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.state = 2;
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, (long)n, lVITEM);
        this.ignoreSelect = false;
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        if (n == 0 && n2 == n3 - 1) {
            this.selectAll();
        } else {
            LVITEM lVITEM = new LVITEM();
            lVITEM.state = 2;
            lVITEM.stateMask = 2;
            int n4 = n;
            while (n4 <= n2) {
                this.ignoreSelect = true;
                OS.SendMessage(this.handle, 4139, (long)n4, lVITEM);
                this.ignoreSelect = false;
                ++n4;
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.state = 2;
        lVITEM.stateMask = 2;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, -1L, lVITEM);
        this.ignoreSelect = false;
    }

    void sendEraseItemEvent(TableItem tableItem, NMLVCUSTOMDRAW nMLVCUSTOMDRAW, long l, Event event) {
        RECT rECT;
        long l2;
        boolean bl;
        int n;
        int n2;
        long l3 = nMLVCUSTOMDRAW.hdc;
        int n3 = n2 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n2 == -1) {
            n2 = tableItem.foreground;
        }
        int n4 = -1;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && this.sortColumn != null && this.sortDirection != 0 && this.findImageControl() == null && this.indexOf(this.sortColumn) == nMLVCUSTOMDRAW.iSubItem) {
            n4 = this.getSortColumnPixel();
        }
        int n5 = n4 = tableItem.cellBackground != null ? tableItem.cellBackground[nMLVCUSTOMDRAW.iSubItem] : -1;
        if (n4 == -1) {
            n4 = tableItem.background;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        lVITEM.iItem = (int)nMLVCUSTOMDRAW.dwItemSpec;
        long l4 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0L, lVITEM);
        boolean bl2 = l4 != 0L && (lVITEM.state & 2) != 0;
        GCData gCData = new GCData();
        gCData.device = this.display;
        int n6 = -1;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) {
            bl5 = (long)this.hotIndex == nMLVCUSTOMDRAW.dwItemSpec;
            boolean bl7 = bl6 = (nMLVCUSTOMDRAW.uItemState & 0x1000) != 0;
        }
        if (OS.IsWindowEnabled(this.handle)) {
            if (bl2 && (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0)) {
                if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                    bl3 = true;
                    gCData.foreground = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                    gCData.background = n6 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                } else {
                    bl3 = (this.style & 0x8000) == 0;
                    gCData.foreground = OS.GetTextColor(l3);
                    gCData.background = n6 = OS.GetSysColor(OS.COLOR_3DFACE);
                }
                if (this.explorerTheme) {
                    gCData.foreground = n2 != -1 ? n2 : this.getForegroundPixel();
                }
            } else {
                boolean bl8 = bl4 = n4 != -1;
                if (n2 == -1 || n4 == -1) {
                    Control control = this.findBackgroundControl();
                    if (control == null) {
                        control = this;
                    }
                    if (n2 == -1) {
                        n2 = control.getForegroundPixel();
                    }
                    if (n4 == -1) {
                        n4 = control.getBackgroundPixel();
                    }
                }
                gCData.foreground = n2 != -1 ? n2 : OS.GetTextColor(l3);
                gCData.background = n4 != -1 ? n4 : OS.GetBkColor(l3);
            }
        } else {
            gCData.foreground = OS.GetSysColor(OS.COLOR_GRAYTEXT);
            gCData.background = OS.GetSysColor(OS.COLOR_3DFACE);
            if (bl2) {
                n6 = gCData.background;
            }
        }
        gCData.font = tableItem.getFont(nMLVCUSTOMDRAW.iSubItem);
        gCData.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
        int n7 = OS.SaveDC(l3);
        GC gC = GC.win32_new(l3, gCData);
        RECT rECT2 = tableItem.getBounds((int)nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, true, true, true, l3);
        Event event2 = new Event();
        event2.item = tableItem;
        event2.gc = gC;
        event2.index = nMLVCUSTOMDRAW.iSubItem;
        event2.detail |= 0x10;
        if (OS.SendMessage(this.handle, 4108, -1L, 1L) == nMLVCUSTOMDRAW.dwItemSpec && (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) && this.handle == OS.GetFocus() && ((n = (int)OS.SendMessage(this.handle, 297, 0L, 0L)) & 1) == 0) {
            event2.detail |= 4;
        }
        int n8 = n = (event2.detail & 4) != 0 ? 1 : 0;
        if (bl5) {
            event2.detail |= 0x20;
        }
        if (bl3) {
            event2.detail |= 2;
        }
        if (bl4) {
            event2.detail |= 8;
        }
        event2.x = rECT2.left;
        event2.y = rECT2.top;
        event2.width = rECT2.right - rECT2.left;
        event2.height = rECT2.bottom - rECT2.top;
        gC.setClipping(event2.x, event2.y, event2.width, event2.height);
        this.sendEvent(40, event2);
        event2.gc = null;
        int n9 = gCData.foreground;
        gC.dispose();
        OS.RestoreDC(l3, n7);
        if (this.isDisposed() || tableItem.isDisposed()) {
            return;
        }
        if (event2.doit) {
            this.ignoreDrawForeground = (event2.detail & 0x10) == 0;
            this.ignoreDrawBackground = (event2.detail & 8) == 0;
            this.ignoreDrawSelection = (event2.detail & 2) == 0;
            this.ignoreDrawFocus = (event2.detail & 4) == 0;
            this.ignoreDrawHot = (event2.detail & 0x20) == 0;
        } else {
            this.ignoreDrawHot = true;
            this.ignoreDrawFocus = true;
            this.ignoreDrawSelection = true;
            this.ignoreDrawBackground = true;
            this.ignoreDrawForeground = true;
        }
        if (bl3) {
            if (this.ignoreDrawSelection) {
                this.ignoreDrawHot = true;
                if (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) {
                    this.selectionForeground = n9;
                }
                nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFFE;
                OS.MoveMemory(l, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
            }
        } else if (this.ignoreDrawSelection) {
            nMLVCUSTOMDRAW.uItemState |= 1;
            OS.MoveMemory(l, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
        }
        boolean bl9 = bl = (long)nMLVCUSTOMDRAW.iSubItem == OS.SendMessage(l2 = OS.SendMessage(this.handle, 4127, 0L, 0L), 4623, 0L, 0L);
        if (this.ignoreDrawForeground && this.ignoreDrawHot && !bl6 && !this.ignoreDrawBackground && bl4) {
            rECT = tableItem.getBounds((int)nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, false, true, false, l3);
            this.fillBackground(l3, n4, rECT);
        }
        this.focusRect = null;
        if (!this.ignoreDrawHot || !this.ignoreDrawSelection || !this.ignoreDrawFocus || bl6) {
            boolean bl10 = (this.style & 0x10000) != 0 || !bl;
            RECT rECT3 = tableItem.getBounds((int)nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, false, bl10, false, l3);
            if ((this.style & 0x10000) == 0) {
                if (event != null) {
                    rECT3.right = Math.min(rECT2.right, event.x + event.width);
                }
                if (!this.ignoreDrawFocus) {
                    nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFEF;
                    OS.MoveMemory(l, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
                    this.focusRect = rECT3;
                }
            }
            if (this.explorerTheme) {
                if (!this.ignoreDrawHot || bl6 || !this.ignoreDrawSelection && n6 != -1) {
                    int n10;
                    RECT rECT4 = new RECT();
                    OS.SetRect(rECT4, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                    RECT rECT5 = new RECT();
                    OS.SetRect(rECT5, nMLVCUSTOMDRAW.left, nMLVCUSTOMDRAW.top, nMLVCUSTOMDRAW.right, nMLVCUSTOMDRAW.bottom);
                    if ((this.style & 0x10000) != 0) {
                        int n11 = (int)OS.SendMessage(l2, 4608, 0L, 0L);
                        int n12 = (int)OS.SendMessage(l2, 4623, (long)(n11 - 1), 0L);
                        RECT rECT6 = new RECT();
                        OS.SendMessage(l2, 4615, (long)n12, rECT6);
                        OS.MapWindowPoints(l2, this.handle, rECT6, 2);
                        rECT5.right = rECT6.right;
                        n12 = (int)OS.SendMessage(l2, 4623, 0L, 0L);
                        OS.SendMessage(l2, 4615, (long)n12, rECT6);
                        OS.MapWindowPoints(l2, this.handle, rECT6, 2);
                        rECT5.left = rECT6.left;
                        rECT4.left = rECT2.left;
                        rECT4.right += 2;
                    } else {
                        rECT5.right += 2;
                        rECT4.right += 2;
                    }
                    long l5 = OS.OpenThemeData(this.handle, Display.LISTVIEW);
                    int n13 = n10 = bl2 ? 3 : 2;
                    if (OS.GetFocus() != this.handle && bl2 && !bl5) {
                        n10 = 5;
                    }
                    if (bl6) {
                        n10 = 3;
                    }
                    OS.DrawThemeBackground(l5, l3, 1, n10, rECT5, rECT4);
                    OS.CloseThemeData(l5);
                }
            } else if (!this.ignoreDrawSelection && n6 != -1) {
                this.fillBackground(l3, n6, rECT3);
            }
        }
        if (n != 0 && this.ignoreDrawFocus) {
            nMLVCUSTOMDRAW.uItemState &= 0xFFFFFFEF;
            OS.MoveMemory(l, nMLVCUSTOMDRAW, NMLVCUSTOMDRAW.sizeof);
        }
        if (this.ignoreDrawForeground) {
            rECT = tableItem.getBounds((int)nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, true, true, false, l3);
            OS.SaveDC(l3);
            OS.SelectClipRgn(l3, 0L);
            OS.ExcludeClipRect(l3, rECT.left, rECT.top, rECT.right, rECT.bottom);
        }
    }

    Event sendEraseItemEvent(TableItem tableItem, NMTTCUSTOMDRAW nMTTCUSTOMDRAW, int n, RECT rECT) {
        int n2 = OS.SaveDC(nMTTCUSTOMDRAW.hdc);
        RECT rECT2 = this.toolTipInset(rECT);
        OS.SetWindowOrgEx(nMTTCUSTOMDRAW.hdc, rECT2.left, rECT2.top, null);
        GCData gCData = new GCData();
        gCData.device = this.display;
        gCData.foreground = OS.GetTextColor(nMTTCUSTOMDRAW.hdc);
        gCData.background = OS.GetBkColor(nMTTCUSTOMDRAW.hdc);
        gCData.font = tableItem.getFont(n);
        gCData.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
        GC gC = GC.win32_new(nMTTCUSTOMDRAW.hdc, gCData);
        Event event = new Event();
        event.item = tableItem;
        event.index = n;
        event.gc = gC;
        event.detail |= 0x10;
        event.x = rECT.left;
        event.y = rECT.top;
        event.width = rECT.right - rECT.left;
        event.height = rECT.bottom - rECT.top;
        this.sendEvent(40, event);
        event.gc = null;
        gC.dispose();
        OS.RestoreDC(nMTTCUSTOMDRAW.hdc, n2);
        return event;
    }

    Event sendMeasureItemEvent(TableItem tableItem, int n, int n2, long l) {
        GCData gCData = new GCData();
        gCData.device = this.display;
        gCData.font = tableItem.getFont(n2);
        int n3 = OS.SaveDC(l);
        GC gC = GC.win32_new(l, gCData);
        RECT rECT = tableItem.getBounds(n, n2, true, true, false, false, l);
        Event event = new Event();
        event.item = tableItem;
        event.gc = gC;
        event.index = n2;
        event.x = rECT.left;
        event.y = rECT.top;
        event.width = rECT.right - rECT.left;
        event.height = rECT.bottom - rECT.top;
        boolean bl = false;
        if (OS.IsWindowEnabled(this.handle)) {
            boolean bl2;
            LVITEM lVITEM = new LVITEM();
            lVITEM.mask = 8;
            lVITEM.stateMask = 2;
            lVITEM.iItem = n;
            long l2 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0L, lVITEM);
            boolean bl3 = bl2 = l2 != 0L && (lVITEM.state & 2) != 0;
            if (bl2 && (n2 == 0 || (this.style & 0x10000) != 0)) {
                if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                    bl = true;
                } else {
                    boolean bl4 = bl = (this.style & 0x8000) == 0;
                }
            }
        }
        if (bl) {
            event.detail |= 2;
        }
        this.sendEvent(41, event);
        event.gc = null;
        gC.dispose();
        OS.RestoreDC(l, n3);
        if (!this.isDisposed() && !tableItem.isDisposed()) {
            int n4;
            if (this.columnCount == 0 && event.x + event.width > (n4 = (int)OS.SendMessage(this.handle, 4125, 0L, 0L))) {
                this.setScrollWidth(event.x + event.width);
            }
            long l3 = OS.SendMessage(this.handle, 4160, 0L, 0L);
            long l4 = OS.SendMessage(this.handle, 4160, 1L, 0L);
            int n5 = OS.HIWORD(l4) - OS.HIWORD(l3);
            if (event.height > n5) {
                this.setItemHeight(event.height);
            }
        }
        return event;
    }

    LRESULT sendMouseDownEvent(int n, int n2, int n3, long l, long l2) {
        boolean bl;
        int n4;
        Display display = this.display;
        display.captureChanged = false;
        if (!this.sendMouseEvent(n, n2, this.handle, n3, l, l2)) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = OS.GET_X_LPARAM(l2);
        lVHITTESTINFO.y = OS.GET_Y_LPARAM(l2);
        OS.SendMessage(this.handle, 4114, 0L, lVHITTESTINFO);
        if ((this.style & 0x10000) == 0 && this.hooks(41)) {
            if (OS.SendMessage(this.handle, 4153, 0L, lVHITTESTINFO) < 0L) {
                n4 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
                if (n4 != 0) {
                    RECT rECT = new RECT();
                    rECT.left = 1;
                    this.ignoreCustomDraw = true;
                    long l3 = OS.SendMessage(this.handle, 4110, 0L, rECT);
                    this.ignoreCustomDraw = false;
                    if (l3 != 0L) {
                        lVHITTESTINFO.x = rECT.left;
                        OS.SendMessage(this.handle, 4153, 0L, lVHITTESTINFO);
                        if (lVHITTESTINFO.iItem < 0) {
                            lVHITTESTINFO.iItem = -1;
                        }
                        lVHITTESTINFO.flags &= 0xFFFFFFF9;
                    }
                }
            } else if (lVHITTESTINFO.iSubItem != 0) {
                lVHITTESTINFO.iItem = -1;
            }
        }
        OS.SetFocus(this.handle);
        if (((this.style & 4) != 0 || this.hooks(3) || this.hooks(4)) && lVHITTESTINFO.iItem == -1) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        n4 = 0;
        int n5 = (int)OS.SendMessage(this.handle, 4146, 0L, 0L);
        if (n5 == 1 && lVHITTESTINFO.iItem != -1) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.mask = 8;
            lVITEM.stateMask = 2;
            lVITEM.iItem = lVHITTESTINFO.iItem;
            OS.SendMessage(this.handle, OS.LVM_GETITEM, 0L, lVITEM);
            if ((lVITEM.state & 2) != 0) {
                n4 = 1;
            }
        }
        this.fullRowSelect = false;
        if (lVHITTESTINFO.iItem != -1 && (this.style & 0x10000) == 0 && this.hooks(41)) {
            int n6;
            this.fullRowSelect = this.hitTestSelection(lVHITTESTINFO.iItem, lVHITTESTINFO.x, lVHITTESTINFO.y);
            if (this.fullRowSelect && (lVHITTESTINFO.flags & (n6 = 6)) != 0) {
                this.fullRowSelect = false;
            }
        }
        boolean bl2 = bl = (this.state & 0x8000) != 0 && this.hooks(29);
        if (!bl) {
            int n7 = 6;
            boolean bl3 = bl = lVHITTESTINFO.iItem == -1 || (lVHITTESTINFO.flags & n7) == 0;
            if (this.fullRowSelect) {
                bl = true;
            }
        }
        if (this.fullRowSelect) {
            OS.UpdateWindow(this.handle);
            OS.DefWindowProc(this.handle, 11, 0L, 0L);
            OS.SendMessage(this.handle, 4150, 32L, 32L);
        }
        this.dragStarted = false;
        display.dragCancelled = false;
        if (!bl) {
            display.runDragDrop = false;
        }
        long l4 = this.callWindowProc(this.handle, n3, l, l2, n4 != 0);
        if (!bl) {
            display.runDragDrop = true;
        }
        if (this.fullRowSelect) {
            this.fullRowSelect = false;
            OS.DefWindowProc(this.handle, 11, 1L, 0L);
            OS.SendMessage(this.handle, 4150, 32L, 0L);
        }
        if (this.dragStarted || display.dragCancelled) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
        } else {
            boolean bl4;
            int n8 = 6;
            boolean bl5 = bl4 = (lVHITTESTINFO.flags & n8) != 0;
            if (!bl4 && (this.style & 2) != 0) {
                boolean bl6 = bl4 = (lVHITTESTINFO.flags & 8) == 0;
            }
            if (bl4) {
                this.sendMouseEvent(4, n2, this.handle, n3, l, l2);
            }
        }
        return new LRESULT(l4);
    }

    void sendPaintItemEvent(TableItem tableItem, NMLVCUSTOMDRAW nMLVCUSTOMDRAW) {
        int n;
        Object object;
        int n2;
        long l = nMLVCUSTOMDRAW.hdc;
        GCData gCData = new GCData();
        gCData.device = this.display;
        gCData.font = tableItem.getFont(nMLVCUSTOMDRAW.iSubItem);
        LVITEM lVITEM = new LVITEM();
        lVITEM.mask = 8;
        lVITEM.stateMask = 2;
        lVITEM.iItem = (int)nMLVCUSTOMDRAW.dwItemSpec;
        long l2 = OS.SendMessage(this.handle, OS.LVM_GETITEM, 0L, lVITEM);
        boolean bl = l2 != 0L && (lVITEM.state & 2) != 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) {
            boolean bl5 = bl4 = (long)this.hotIndex == nMLVCUSTOMDRAW.dwItemSpec;
        }
        if (OS.IsWindowEnabled(this.handle)) {
            if (bl && (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0)) {
                if (OS.GetFocus() == this.handle || this.display.getHighContrast()) {
                    bl2 = true;
                    gCData.foreground = this.selectionForeground != -1 ? this.selectionForeground : OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                    gCData.background = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                } else {
                    bl2 = (this.style & 0x8000) == 0;
                    gCData.foreground = OS.GetTextColor(l);
                    gCData.background = OS.GetSysColor(OS.COLOR_3DFACE);
                }
                if (this.explorerTheme && this.selectionForeground == -1) {
                    int n3 = n2 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
                    if (n2 == -1) {
                        n2 = tableItem.foreground;
                    }
                    gCData.foreground = n2 != -1 ? n2 : this.getForegroundPixel();
                }
            } else {
                int n4;
                int n5 = n2 = tableItem.cellForeground != null ? tableItem.cellForeground[nMLVCUSTOMDRAW.iSubItem] : -1;
                if (n2 == -1) {
                    n2 = tableItem.foreground;
                }
                int n6 = n4 = tableItem.cellBackground != null ? tableItem.cellBackground[nMLVCUSTOMDRAW.iSubItem] : -1;
                if (n4 == -1) {
                    n4 = tableItem.background;
                }
                boolean bl6 = bl3 = n4 != -1;
                if (n2 == -1 || n4 == -1) {
                    object = this.findBackgroundControl();
                    if (object == null) {
                        object = this;
                    }
                    if (n2 == -1) {
                        n2 = ((Control)object).getForegroundPixel();
                    }
                    if (n4 == -1) {
                        n4 = ((Control)object).getBackgroundPixel();
                    }
                }
                gCData.foreground = n2 != -1 ? n2 : OS.GetTextColor(l);
                gCData.background = n4 != -1 ? n4 : OS.GetBkColor(l);
            }
        } else {
            gCData.foreground = OS.GetSysColor(OS.COLOR_GRAYTEXT);
            gCData.background = OS.GetSysColor(OS.COLOR_3DFACE);
        }
        gCData.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
        n2 = OS.SaveDC(l);
        GC gC = GC.win32_new(l, gCData);
        object = tableItem.getBounds((int)nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, true, false, false, l);
        Event event = new Event();
        event.item = tableItem;
        event.gc = gC;
        event.index = nMLVCUSTOMDRAW.iSubItem;
        event.detail |= 0x10;
        if (OS.SendMessage(this.handle, 4108, -1L, 1L) == nMLVCUSTOMDRAW.dwItemSpec && (nMLVCUSTOMDRAW.iSubItem == 0 || (this.style & 0x10000) != 0) && this.handle == OS.GetFocus() && ((n = (int)OS.SendMessage(this.handle, 297, 0L, 0L)) & 1) == 0) {
            event.detail |= 4;
        }
        if (bl4) {
            event.detail |= 0x20;
        }
        if (bl2) {
            event.detail |= 2;
        }
        if (bl3) {
            event.detail |= 8;
        }
        event.x = ((RECT)object).left;
        event.y = ((RECT)object).top;
        event.width = ((RECT)object).right - ((RECT)object).left;
        event.height = ((RECT)object).bottom - ((RECT)object).top;
        RECT rECT = tableItem.getBounds((int)nMLVCUSTOMDRAW.dwItemSpec, nMLVCUSTOMDRAW.iSubItem, true, true, true, true, l);
        int n7 = rECT.right - rECT.left;
        int n8 = rECT.bottom - rECT.top;
        gC.setClipping(rECT.left, rECT.top, n7, n8);
        this.sendEvent(42, event);
        if (gCData.focusDrawn) {
            this.focusRect = null;
        }
        event.gc = null;
        gC.dispose();
        OS.RestoreDC(l, n2);
    }

    Event sendPaintItemEvent(TableItem tableItem, NMTTCUSTOMDRAW nMTTCUSTOMDRAW, int n, RECT rECT) {
        int n2 = OS.SaveDC(nMTTCUSTOMDRAW.hdc);
        RECT rECT2 = this.toolTipInset(rECT);
        OS.SetWindowOrgEx(nMTTCUSTOMDRAW.hdc, rECT2.left, rECT2.top, null);
        GCData gCData = new GCData();
        gCData.device = this.display;
        gCData.font = tableItem.getFont(n);
        gCData.foreground = OS.GetTextColor(nMTTCUSTOMDRAW.hdc);
        gCData.background = OS.GetBkColor(nMTTCUSTOMDRAW.hdc);
        gCData.uiState = (int)OS.SendMessage(this.handle, 297, 0L, 0L);
        GC gC = GC.win32_new(nMTTCUSTOMDRAW.hdc, gCData);
        Event event = new Event();
        event.item = tableItem;
        event.index = n;
        event.gc = gC;
        event.detail |= 0x10;
        event.x = rECT.left;
        event.y = rECT.top;
        event.width = rECT.right - rECT.left;
        event.height = rECT.bottom - rECT.top;
        this.sendEvent(42, event);
        event.gc = null;
        gC.dispose();
        OS.RestoreDC(nMTTCUSTOMDRAW.hdc, n2);
        return event;
    }

    void setBackgroundImage(long l) {
        super.setBackgroundImage(l);
        if (l != 0L) {
            this.setBackgroundTransparent(true);
        } else if (!(this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            this.setBackgroundTransparent(false);
        }
    }

    void setBackgroundPixel(int n) {
        int n2 = (int)OS.SendMessage(this.handle, 4096, 0L, 0L);
        if (n2 != -1) {
            if (this.findImageControl() != null) {
                return;
            }
            if (n == -1) {
                n = this.defaultBackground();
            }
            if (n2 != n) {
                OS.SendMessage(this.handle, 4097, 0L, (long)n);
                OS.SendMessage(this.handle, 4134, 0L, (long)n);
                if ((this.style & 0x20) != 0) {
                    this.fixCheckboxImageListColor(true);
                }
            }
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    void setBackgroundTransparent(boolean bl) {
        int n = (int)OS.SendMessage(this.handle, 4096, 0L, 0L);
        if (bl) {
            if (n != -1) {
                OS.SendMessage(this.handle, 4097, 0L, -1L);
                OS.SendMessage(this.handle, 4134, 0L, -1L);
                OS.InvalidateRect(this.handle, null, true);
                if (!this.explorerTheme && (this.style & 0x10000) != 0) {
                    int n2 = 32;
                    OS.SendMessage(this.handle, 4150, (long)n2, 0L);
                }
                if ((this.sortDirection & 0x480) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed()) {
                    OS.SendMessage(this.handle, 4236, -1L, 0L);
                    OS.InvalidateRect(this.handle, null, true);
                }
            }
        } else if (n == -1) {
            int n3;
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            if (control.backgroundImage == null) {
                n3 = control.getBackgroundPixel();
                OS.SendMessage(this.handle, 4097, 0L, (long)n3);
                OS.SendMessage(this.handle, 4134, 0L, (long)n3);
                if ((this.style & 0x20) != 0) {
                    this.fixCheckboxImageListColor(true);
                }
                OS.InvalidateRect(this.handle, null, true);
            }
            if (!(this.explorerTheme || (this.style & 0x10000) == 0 || this.hooks(40) || this.hooks(42))) {
                n3 = 32;
                OS.SendMessage(this.handle, 4150, (long)n3, (long)n3);
            }
            if ((this.sortDirection & 0x480) != 0 && this.sortColumn != null && !this.sortColumn.isDisposed() && (n3 = this.indexOf(this.sortColumn)) != -1) {
                OS.SendMessage(this.handle, 4236, (long)n3, 0L);
                OS.InvalidateRect(this.handle, null, true);
            }
        }
    }

    void setBounds(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.setDeferResize(true);
        super.setBounds(n, n2, n3, n4, n5, false);
        this.setDeferResize(false);
    }

    public void setColumnOrder(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
        if (this.columnCount == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        int[] nArray2 = new int[this.columnCount];
        OS.SendMessage(this.handle, 4155, (long)this.columnCount, nArray2);
        boolean bl = false;
        boolean[] blArray = new boolean[this.columnCount];
        int n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[n2];
            if (n < 0 || n >= this.columnCount) {
                this.error(6);
            }
            if (blArray[n]) {
                this.error(5);
            }
            blArray[n] = true;
            if (n != nArray2[n2]) {
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            RECT[] rECTArray = new RECT[this.columnCount];
            n = 0;
            while (n < this.columnCount) {
                rECTArray[n] = new RECT();
                OS.SendMessage(l, 4615, (long)n, rECTArray[n]);
                ++n;
            }
            OS.SendMessage(this.handle, 4154, (long)nArray.length, nArray);
            OS.InvalidateRect(this.handle, null, true);
            TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
            System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
            RECT rECT = new RECT();
            int n3 = 0;
            while (n3 < this.columnCount) {
                TableColumn tableColumn = tableColumnArray[n3];
                if (!tableColumn.isDisposed()) {
                    OS.SendMessage(l, 4615, (long)n3, rECT);
                    if (rECT.left != rECTArray[n3].left) {
                        tableColumn.updateToolTip(n3);
                        tableColumn.sendEvent(10);
                    }
                }
                ++n3;
            }
        }
    }

    void setCustomDraw(boolean bl) {
        if (this.customDraw == bl) {
            return;
        }
        if (!this.customDraw && bl && this.currentItem != null) {
            OS.InvalidateRect(this.handle, null, true);
        }
        this.customDraw = bl;
    }

    void setDeferResize(boolean bl) {
        if (bl) {
            if (this.resizeCount++ == 0) {
                this.wasResized = false;
                if ((this.hooks(41) || this.hooks(40) || this.hooks(42)) && this.drawCount++ == 0 && OS.IsWindowVisible(this.handle)) {
                    OS.DefWindowProc(this.handle, 11, 0L, 0L);
                    OS.SendMessage(this.handle, 4097, 0L, 0xFFFFFFL);
                }
            }
        } else if (--this.resizeCount == 0) {
            if ((this.hooks(41) || this.hooks(40) || this.hooks(42)) && --this.drawCount == 0) {
                OS.SendMessage(this.handle, 4097, 0L, -1L);
                OS.DefWindowProc(this.handle, 11, 1L, 0L);
                if (OS.IsWinCE) {
                    long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
                    if (l != 0L) {
                        OS.InvalidateRect(l, null, true);
                    }
                    OS.InvalidateRect(this.handle, null, true);
                } else {
                    int n = 1157;
                    OS.RedrawWindow(this.handle, null, 0L, n);
                }
            }
            if (this.wasResized) {
                this.wasResized = false;
                this.setResizeChildren(false);
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false, false);
                }
                this.setResizeChildren(true);
            }
        }
    }

    void setCheckboxImageList(int n, int n2, boolean bl) {
        int n3;
        long l;
        if ((this.style & 0x20) == 0) {
            return;
        }
        int n4 = 8;
        int n5 = 0;
        if (OS.IsWinCE) {
            n5 |= 0;
        } else {
            l = OS.GetDC(this.handle);
            int n6 = OS.GetDeviceCaps(l, 12);
            int n7 = OS.GetDeviceCaps(l, 14);
            OS.ReleaseDC(this.handle, l);
            int n8 = n6 * n7;
            switch (n8) {
                case 4: {
                    n5 |= 4;
                    break;
                }
                case 8: {
                    n5 |= 8;
                    break;
                }
                case 16: {
                    n5 |= 0x10;
                    break;
                }
                case 24: {
                    n5 |= 0x18;
                    break;
                }
                case 32: {
                    n5 |= 0x20;
                    break;
                }
                default: {
                    n5 |= 0;
                }
            }
        }
        if ((this.style & 0x4000000) != 0) {
            n5 |= 0x2000;
        }
        if (OS.COMCTL32_MAJOR < 6 || !OS.IsAppThemed()) {
            n5 |= 1;
        }
        l = OS.ImageList_Create(n, n2, n5, n4, n4);
        long l2 = OS.GetDC(this.handle);
        long l3 = OS.CreateCompatibleDC(l2);
        long l4 = OS.CreateCompatibleBitmap(l2, n * n4, n2);
        long l5 = OS.SelectObject(l3, l4);
        RECT rECT = new RECT();
        OS.SetRect(rECT, 0, 0, n * n4, n2);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            n3 = control.getBackgroundPixel();
        } else {
            n3 = 0x20000FF;
            if ((n3 & 0xFFFFFF) == OS.GetSysColor(OS.COLOR_WINDOW)) {
                n3 = 0x200FF00;
            }
        }
        long l6 = OS.CreateSolidBrush(n3);
        OS.FillRect(l3, rECT, l6);
        OS.DeleteObject(l6);
        long l7 = OS.SelectObject(l2, this.defaultFont());
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.GetTextMetrics(l2, tEXTMETRIC);
        OS.SelectObject(l2, l7);
        int n9 = Math.min(tEXTMETRIC.tmHeight, n);
        int n10 = Math.min(tEXTMETRIC.tmHeight, n2);
        int n11 = (n - n9) / 2;
        int n12 = (n2 - n10) / 2 + 1;
        OS.SetRect(rECT, n11, n12, n11 + n9, n12 + n10);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            long l8 = this.display.hButtonTheme();
            OS.DrawThemeBackground(l8, l3, 3, 1, rECT, null);
            rECT.left += n;
            rECT.right += n;
            OS.DrawThemeBackground(l8, l3, 3, 5, rECT, null);
            rECT.left += n;
            rECT.right += n;
            OS.DrawThemeBackground(l8, l3, 3, 1, rECT, null);
            rECT.left += n;
            rECT.right += n;
            OS.DrawThemeBackground(l8, l3, 3, 9, rECT, null);
            rECT.left += n;
            rECT.right += n;
            OS.DrawThemeBackground(l8, l3, 3, 4, rECT, null);
            rECT.left += n;
            rECT.right += n;
            OS.DrawThemeBackground(l8, l3, 3, 8, rECT, null);
            rECT.left += n;
            rECT.right += n;
            OS.DrawThemeBackground(l8, l3, 3, 4, rECT, null);
            rECT.left += n;
            rECT.right += n;
            OS.DrawThemeBackground(l8, l3, 3, 12, rECT, null);
        } else {
            OS.DrawFrameControl(l3, rECT, 4, 16384);
            rECT.left += n;
            rECT.right += n;
            OS.DrawFrameControl(l3, rECT, 4, 17408);
            rECT.left += n;
            rECT.right += n;
            OS.DrawFrameControl(l3, rECT, 4, 16640);
            rECT.left += n;
            rECT.right += n;
            OS.DrawFrameControl(l3, rECT, 4, 17664);
            rECT.left += n;
            rECT.right += n;
            OS.DrawFrameControl(l3, rECT, 4, 16384);
            rECT.left += n;
            rECT.right += n;
            OS.DrawFrameControl(l3, rECT, 4, 17408);
            rECT.left += n;
            rECT.right += n;
            OS.DrawFrameControl(l3, rECT, 4, 16640);
            rECT.left += n;
            rECT.right += n;
            OS.DrawFrameControl(l3, rECT, 4, 17664);
        }
        OS.SelectObject(l3, l5);
        OS.DeleteDC(l3);
        OS.ReleaseDC(this.handle, l2);
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            OS.ImageList_Add(l, l4, 0L);
        } else {
            OS.ImageList_AddMasked(l, l4, n3);
        }
        OS.DeleteObject(l4);
        int n13 = this.getTopIndex();
        if (bl && n13 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        long l9 = OS.SendMessage(this.handle, 4098, 2L, 0L);
        OS.SendMessage(this.handle, 4099, 2L, l);
        if (l9 != 0L) {
            OS.ImageList_Destroy(l9);
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            long l10 = OS.SendMessage(this.handle, 4098, 1L, 0L);
            OS.SendMessage(this.handle, 4099, 1L, l10);
        }
        if (bl && n13 != 0) {
            this.setTopIndex(n13);
            this.setRedraw(true);
        }
    }

    void setFocusIndex(int n) {
        if (n < 0) {
            return;
        }
        LVITEM lVITEM = new LVITEM();
        lVITEM.state = 1;
        lVITEM.stateMask = 1;
        this.ignoreSelect = true;
        OS.SendMessage(this.handle, 4139, (long)n, lVITEM);
        this.ignoreSelect = false;
        OS.SendMessage(this.handle, 4163, 0L, (long)n);
    }

    public void setFont(Font font) {
        int n;
        this.checkWidget();
        int n2 = this.getTopIndex();
        if (n2 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if (this.itemHeight != -1) {
            n = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n | 0x400);
        }
        super.setFont(font);
        if (this.itemHeight != -1) {
            n = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n & 0xFFFFFBFF);
        }
        this.setScrollWidth(null, true);
        if (n2 != 0) {
            this.setTopIndex(n2);
            this.setRedraw(true);
        }
        long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
        OS.InvalidateRect(l, null, true);
    }

    void setForegroundPixel(int n) {
        if (n == -1) {
            n = -16777216;
        }
        OS.SendMessage(this.handle, 4132, 0L, (long)n);
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setHeaderVisible(boolean bl) {
        int n;
        this.checkWidget();
        int n2 = OS.GetWindowLong(this.handle, -16);
        n2 &= 0xFFFFBFFF;
        if (!bl) {
            n2 |= 0x4000;
        }
        int n3 = this.getTopIndex();
        OS.SetWindowLong(this.handle, -16, n2);
        int n4 = this.getTopIndex();
        if (n4 != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if (bl && ((n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 1) != 0) {
            this.fixItemHeight(false);
        }
        this.setTopIndex(n3);
        if (n4 != 0) {
            this.setRedraw(true);
        }
        this.updateHeaderToolTips();
    }

    public void setItemCount(int n) {
        boolean bl;
        this.checkWidget();
        n = Math.max(0, n);
        int n2 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (n == n2) {
            return;
        }
        this.setDeferResize(true);
        boolean bl2 = bl = (this.style & 0x10000000) != 0;
        if (!bl) {
            this.setRedraw(false);
        }
        int n3 = n;
        while (n3 < n2) {
            TableItem tableItem = this._getItem(n3, false);
            if (tableItem != null && !tableItem.isDisposed()) {
                tableItem.release(false);
            }
            if (!bl) {
                this.ignoreShrink = true;
                this.ignoreSelect = true;
                long l = OS.SendMessage(this.handle, 4104, (long)n, 0L);
                this.ignoreShrink = false;
                this.ignoreSelect = false;
                if (l == 0L) break;
            }
            ++n3;
        }
        if (n3 < n2) {
            this.error(15);
        }
        this._setItemCount(n, n2);
        if (bl) {
            int n4 = 3;
            OS.SendMessage(this.handle, 4143, (long)n, (long)n4);
            if (n == 0 && n2 != 0) {
                OS.InvalidateRect(this.handle, null, true);
            }
        } else {
            int n5 = n2;
            while (n5 < n) {
                new TableItem(this, 0, n5, true);
                ++n5;
            }
        }
        if (!bl) {
            this.setRedraw(true);
        }
        if (n2 == 0) {
            this.setScrollWidth(null, false);
        }
        this.setDeferResize(false);
    }

    void setItemHeight(boolean bl) {
        int n = this.getTopIndex();
        if (bl && n != 0) {
            this.setRedraw(false);
            this.setTopIndex(0);
        }
        if (this.itemHeight == -1) {
            long l = OS.SendMessage(this.handle, 49, 0L, 0L);
            OS.SendMessage(this.handle, 48, l, 0L);
        } else {
            this.forceResize();
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            int n2 = rECT.right - rECT.left;
            int n3 = rECT.bottom - rECT.top;
            int n4 = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n4 | 0x400);
            int n5 = 30;
            this.ignoreResize = true;
            this.SetWindowPos(this.handle, 0L, 0, 0, n2, n3 + 1, n5);
            this.SetWindowPos(this.handle, 0L, 0, 0, n2, n3, n5);
            this.ignoreResize = false;
            OS.SetWindowLong(this.handle, -16, n4);
        }
        if (bl && n != 0) {
            this.setTopIndex(n);
            this.setRedraw(true);
        }
    }

    void setItemHeight(int n) {
        this.checkWidget();
        if (n < -1) {
            this.error(5);
        }
        this.itemHeight = n;
        this.setItemHeight(true);
        this.setScrollWidth(null, true);
    }

    public void setLinesVisible(boolean bl) {
        int n;
        this.checkWidget();
        int n2 = bl ? 1 : 0;
        OS.SendMessage(this.handle, 4150, 1L, (long)n2);
        if (bl && ((n = OS.GetWindowLong(this.handle, -16)) & 0x4000) == 0) {
            this.fixItemHeight(true);
        }
    }

    public void setRedraw(boolean bl) {
        int n;
        this.checkWidget();
        if (this.drawCount == 0 && ((n = OS.GetWindowLong(this.handle, -16)) & 0x10000000) == 0) {
            this.state |= 0x10;
        }
        if (bl) {
            if (--this.drawCount == 0) {
                this.setScrollWidth(null, true);
                this.setDeferResize(true);
                OS.SendMessage(this.handle, 11, 1L, 0L);
                long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
                if (l != 0L) {
                    OS.SendMessage(l, 11, 1L, 0L);
                }
                if ((this.state & 0x10) != 0) {
                    this.state &= 0xFFFFFFEF;
                    OS.ShowWindow(this.handle, 0);
                } else if (OS.IsWinCE) {
                    OS.InvalidateRect(this.handle, null, false);
                    if (l != 0L) {
                        OS.InvalidateRect(l, null, false);
                    }
                } else {
                    int n2 = 1157;
                    OS.RedrawWindow(this.handle, null, 0L, n2);
                }
                this.setDeferResize(false);
            }
        } else if (this.drawCount++ == 0) {
            OS.SendMessage(this.handle, 11, 0L, 0L);
            long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
            if (l != 0L) {
                OS.SendMessage(l, 11, 0L, 0L);
            }
        }
    }

    void setScrollWidth(int n) {
        if (n != (int)OS.SendMessage(this.handle, 4125, 0L, 0L)) {
            boolean bl = false;
            if (this.hooks(41)) {
                boolean bl2 = bl = this.getDrawing() && OS.IsWindowVisible(this.handle);
            }
            if (bl) {
                OS.DefWindowProc(this.handle, 11, 0L, 0L);
            }
            OS.SendMessage(this.handle, 4126, 0L, (long)n);
            if (bl) {
                OS.DefWindowProc(this.handle, 11, 1L, 0L);
                if (OS.IsWinCE) {
                    long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
                    if (l != 0L) {
                        OS.InvalidateRect(l, null, true);
                    }
                    OS.InvalidateRect(this.handle, null, true);
                } else {
                    int n2 = 1157;
                    OS.RedrawWindow(this.handle, null, 0L, n2);
                }
            }
        }
    }

    boolean setScrollWidth(TableItem tableItem, boolean bl) {
        if (this.currentItem != null) {
            if (this.currentItem != tableItem) {
                this.fixScrollWidth = true;
            }
            return false;
        }
        if (!(bl || this.getDrawing() && OS.IsWindowVisible(this.handle))) {
            this.fixScrollWidth = true;
            return false;
        }
        this.fixScrollWidth = false;
        if (this.columnCount == 0) {
            long l;
            long l2;
            Object object;
            Object object2;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
            while (n3 < n4) {
                object2 = null;
                long l3 = -1L;
                if (tableItem != null) {
                    object2 = tableItem.text;
                    n2 = Math.max(n2, tableItem.imageIndent);
                    l3 = tableItem.fontHandle(0);
                } else {
                    object = this._getItem(n3, false);
                    if (object != null) {
                        object2 = ((TableItem)object).text;
                        n2 = Math.max(n2, ((TableItem)object).imageIndent);
                        l3 = ((TableItem)object).fontHandle(0);
                    }
                }
                if (object2 != null && ((String)object2).length() != 0) {
                    if (l3 != -1L) {
                        long l4 = OS.GetDC(this.handle);
                        long l5 = OS.SelectObject(l4, l3);
                        int n5 = 3104;
                        TCHAR tCHAR = new TCHAR(this.getCodePage(), (String)object2, false);
                        RECT rECT = new RECT();
                        OS.DrawText(l4, tCHAR, tCHAR.length(), rECT, n5);
                        OS.SelectObject(l4, l5);
                        OS.ReleaseDC(this.handle, l4);
                        n = Math.max(n, rECT.right - rECT.left);
                    } else {
                        object = new TCHAR(this.getCodePage(), (String)object2, true);
                        n = Math.max(n, (int)OS.SendMessage(this.handle, OS.LVM_GETSTRINGWIDTH, 0L, (TCHAR)object));
                    }
                }
                if (tableItem != null) break;
                ++n3;
            }
            if (n == 0) {
                object2 = new TCHAR(this.getCodePage(), " ", true);
                n = Math.max(n, (int)OS.SendMessage(this.handle, OS.LVM_GETSTRINGWIDTH, 0L, (TCHAR)object2));
            }
            if ((l2 = OS.SendMessage(this.handle, 4098, 2L, 0L)) != 0L) {
                int[] nArray = new int[1];
                object = new int[1];
                OS.ImageList_GetIconSize(l2, nArray, (int[])object);
                n += nArray[0] + 4;
            }
            if ((l = OS.SendMessage(this.handle, 4098, 1L, 0L)) != 0L) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                OS.ImageList_GetIconSize(l, nArray, nArray2);
                n += (n2 + 1) * nArray[0];
            } else {
                ++n;
            }
            n += 8;
            int n6 = (int)OS.SendMessage(this.handle, 4125, 0L, 0L);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                n += 2;
            }
            if (n > n6) {
                this.setScrollWidth(n);
                return true;
            }
        }
        return false;
    }

    public void setSelection(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = nArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.select(nArray);
        int n2 = nArray[0];
        if (n2 != -1) {
            this.setFocusIndex(n2);
        }
        this.showSelection();
    }

    public void setSelection(TableItem tableItem) {
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{tableItem});
    }

    public void setSelection(TableItem[] tableItemArray) {
        this.checkWidget();
        if (tableItemArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = tableItemArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int n2 = -1;
        int n3 = n - 1;
        while (n3 >= 0) {
            int n4 = this.indexOf(tableItemArray[n3]);
            if (n4 != -1) {
                n2 = n4;
                this.select(n2);
            }
            --n3;
        }
        if (n2 != -1) {
            this.setFocusIndex(n2);
        }
        this.showSelection();
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        this.select(n);
        if (n != -1) {
            this.setFocusIndex(n);
        }
        this.showSelection();
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        this.select(n, n2);
        this.setFocusIndex(n);
        this.showSelection();
    }

    public void setSortColumn(TableColumn tableColumn) {
        this.checkWidget();
        if (tableColumn != null && tableColumn.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = tableColumn;
        if (this.sortColumn != null && this.sortDirection != 0) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if ((n & 0x480) == 0 && n != 0) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(n);
        }
    }

    void setSubImagesVisible(boolean bl) {
        int n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
        if ((n & 2) != 0 == bl) {
            return;
        }
        int n2 = bl ? 2 : 0;
        OS.SendMessage(this.handle, 4150, 2L, (long)n2);
    }

    void setTableEmpty() {
        if (this.imageList != null) {
            long l = OS.ImageList_Create(1, 1, 0, 0, 0);
            OS.SendMessage(this.handle, 4099, 1L, l);
            OS.SendMessage(this.handle, 4099, 1L, 0L);
            if (this.headerImageList != null) {
                long l2 = this.headerImageList.getHandle();
                long l3 = OS.SendMessage(this.handle, 4127, 0L, 0L);
                OS.SendMessage(l3, 4616, 0L, l2);
            }
            OS.ImageList_Destroy(l);
            this.display.releaseImageList(this.imageList);
            this.imageList = null;
            if (this.itemHeight != -1) {
                this.setItemHeight(false);
            }
        }
        if (!(this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            if (control.backgroundImage == null) {
                this.setCustomDraw(false);
                this.setBackgroundTransparent(false);
                if (OS.COMCTL32_MAJOR < 6) {
                    this.style &= 0xDFFFFFFF;
                }
            }
        }
        this._initItems();
        if (this.columnCount == 0) {
            OS.SendMessage(this.handle, 4126, 0L, 0L);
            this.setScrollWidth(null, false);
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        int n2 = (int)OS.SendMessage(this.handle, 4135, 0L, 0L);
        if (n == n2) {
            return;
        }
        if (!this.painted && this.hooks(41)) {
            this.hitTestSelection(n, 0, 0);
        }
        if (OS.SendMessage(this.handle, 4136, 0L, 0L) <= 0L) {
            OS.SendMessage(this.handle, 4115, (long)n, 1L);
            if ((long)n != OS.SendMessage(this.handle, 4135, 0L, 0L)) {
                OS.SendMessage(this.handle, 4115, (long)n, 1L);
            }
            return;
        }
        RECT rECT = new RECT();
        rECT.left = 0;
        this.ignoreCustomDraw = true;
        OS.SendMessage(this.handle, 4110, 0L, rECT);
        this.ignoreCustomDraw = false;
        int n3 = (n - n2) * (rECT.bottom - rECT.top);
        OS.SendMessage(this.handle, 4116, 0L, (long)n3);
    }

    public void showColumn(TableColumn tableColumn) {
        int n;
        int n2;
        Object object;
        int n3;
        this.checkWidget();
        if (tableColumn == null) {
            this.error(4);
        }
        if (tableColumn.isDisposed()) {
            this.error(5);
        }
        if (tableColumn.parent != this) {
            return;
        }
        int n4 = this.indexOf(tableColumn);
        if (n4 < 0 || n4 >= this.columnCount) {
            return;
        }
        RECT rECT = new RECT();
        rECT.left = 0;
        if (n4 == 0) {
            rECT.top = 1;
            this.ignoreCustomDraw = true;
            OS.SendMessage(this.handle, 4152, -1L, rECT);
            this.ignoreCustomDraw = false;
            rECT.right = rECT.left;
            n3 = (int)OS.SendMessage(this.handle, 4125, 0L, 0L);
            rECT.left = rECT.right - n3;
        } else {
            rECT.top = n4;
            this.ignoreCustomDraw = true;
            OS.SendMessage(this.handle, 4152, -1L, rECT);
            this.ignoreCustomDraw = false;
        }
        n3 = 0;
        int n5 = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
        if ((n5 & 1) != 0) {
            object = new SCROLLINFO();
            ((SCROLLINFO)object).cbSize = SCROLLINFO.sizeof;
            ((SCROLLINFO)object).fMask = 4;
            OS.GetScrollInfo(this.handle, 0, (SCROLLINFO)object);
            n3 = ((SCROLLINFO)object).nPos;
        }
        object = new RECT();
        OS.GetClientRect(this.handle, (RECT)object);
        if (rECT.left < ((RECT)object).left) {
            n2 = rECT.left - ((RECT)object).left;
            OS.SendMessage(this.handle, 4116, (long)n2, 0L);
        } else {
            n2 = Math.min(((RECT)object).right - ((RECT)object).left, rECT.right - rECT.left);
            if (rECT.left + n2 > ((RECT)object).right) {
                n = rECT.left + n2 - ((RECT)object).right;
                OS.SendMessage(this.handle, 4116, (long)n, 0L);
            }
        }
        if ((n5 & 1) != 0) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, sCROLLINFO);
            n = sCROLLINFO.nPos;
            if (n < n3) {
                ((RECT)object).right = n3 - n + 1;
                OS.InvalidateRect(this.handle, (RECT)object, true);
            }
        }
    }

    void showItem(int n) {
        if (!this.painted && this.hooks(41)) {
            this.hitTestSelection(n, 0, 0);
        }
        if (OS.SendMessage(this.handle, 4136, 0L, 0L) <= 0L) {
            OS.SendMessage(this.handle, 4115, (long)n, 1L);
            if ((long)n != OS.SendMessage(this.handle, 4135, 0L, 0L)) {
                OS.SendMessage(this.handle, 4115, (long)n, 1L);
            }
        } else {
            OS.SendMessage(this.handle, 4115, (long)n, 0L);
        }
    }

    public void showItem(TableItem tableItem) {
        int n;
        this.checkWidget();
        if (tableItem == null) {
            this.error(4);
        }
        if (tableItem.isDisposed()) {
            this.error(5);
        }
        if ((n = this.indexOf(tableItem)) != -1) {
            this.showItem(n);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int n = (int)OS.SendMessage(this.handle, 4108, -1L, 2L);
        if (n != -1) {
            this.showItem(n);
        }
    }

    void sort() {
        this.checkWidget();
    }

    void subclass() {
        super.subclass();
        if (HeaderProc != 0L) {
            long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
            OS.SetWindowLongPtr(l, -4, this.display.windowProc);
        }
    }

    RECT toolTipInset(RECT rECT) {
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            RECT rECT2 = new RECT();
            OS.SetRect(rECT2, rECT.left - 1, rECT.top - 1, rECT.right + 1, rECT.bottom + 1);
            return rECT2;
        }
        return rECT;
    }

    RECT toolTipRect(RECT rECT) {
        RECT rECT2 = new RECT();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            OS.SetRect(rECT2, rECT.left - 1, rECT.top - 1, rECT.right + 1, rECT.bottom + 1);
        } else {
            long l = OS.SendMessage(this.handle, 4174, 0L, 0L);
            OS.SetRect(rECT2, rECT.left, rECT.top, rECT.right, rECT.bottom);
            int n = OS.GetWindowLong(l, -16);
            int n2 = OS.GetWindowLong(l, -20);
            OS.AdjustWindowRectEx(rECT2, n, false, n2);
        }
        return rECT2;
    }

    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        long l = OS.SendMessage(this.handle, 4174, 0L, 0L);
        if (l == nMTTDISPINFO.hwndFrom && this.toolTipText != null) {
            return "";
        }
        if (this.headerToolTipHandle == nMTTDISPINFO.hwndFrom) {
            int n = 0;
            while (n < this.columnCount) {
                TableColumn tableColumn = this.columns[n];
                if ((long)tableColumn.id == nMTTDISPINFO.idFrom) {
                    return tableColumn.toolTipText;
                }
                ++n;
            }
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    void unsubclass() {
        super.unsubclass();
        if (HeaderProc != 0L) {
            long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
            OS.SetWindowLongPtr(l, -4, HeaderProc);
        }
    }

    void update(boolean bl) {
        long l = 0L;
        long l2 = 0L;
        long l3 = OS.SendMessage(this.handle, 4127, 0L, 0L);
        boolean bl2 = this.isOptimizedRedraw();
        if (bl2) {
            l2 = OS.SetWindowLongPtr(this.handle, -4, TableProc);
            l = OS.SetWindowLongPtr(l3, -4, HeaderProc);
        }
        super.update(bl);
        if (bl2) {
            OS.SetWindowLongPtr(this.handle, -4, l2);
            OS.SetWindowLongPtr(l3, -4, l);
        }
    }

    void updateHeaderToolTips() {
        if (this.headerToolTipHandle == 0L) {
            return;
        }
        long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
        RECT rECT = new RECT();
        TOOLINFO tOOLINFO = new TOOLINFO();
        tOOLINFO.cbSize = TOOLINFO.sizeof;
        tOOLINFO.uFlags = 16;
        tOOLINFO.hwnd = l;
        tOOLINFO.lpszText = -1L;
        int n = 0;
        while (n < this.columnCount) {
            TableColumn tableColumn = this.columns[n];
            if (OS.SendMessage(l, 4615, (long)n, rECT) != 0L) {
                ++this.display.nextToolTipId;
                tableColumn.id = tableColumn.id;
                tOOLINFO.uId = tableColumn.id;
                tOOLINFO.left = rECT.left;
                tOOLINFO.top = rECT.top;
                tOOLINFO.right = rECT.right;
                tOOLINFO.bottom = rECT.bottom;
                OS.SendMessage(this.headerToolTipHandle, OS.TTM_ADDTOOL, 0L, tOOLINFO);
            }
            ++n;
        }
    }

    void updateImages() {
        if (this.sortColumn != null && !this.sortColumn.isDisposed() && OS.COMCTL32_MAJOR < 6) {
            switch (this.sortDirection) {
                case 128: 
                case 1024: {
                    this.sortColumn.setImage(this.display.getSortImage(this.sortDirection), true, true);
                }
            }
        }
    }

    void updateMenuLocation(Event event) {
        Object object;
        Rectangle rectangle = this.getClientArea();
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = this.getFocusIndex();
        if (n3 != -1) {
            object = this.getItem(n3);
            Rectangle rectangle2 = ((TableItem)object).getBounds(0);
            if (((TableItem)object).text != null && ((TableItem)object).text.length() != 0) {
                rectangle2 = ((TableItem)object).getBounds();
            }
            n = Math.max(n, rectangle2.x + rectangle2.width / 2);
            n = Math.min(n, rectangle.x + rectangle.width);
            n2 = Math.max(n2, rectangle2.y + rectangle2.height);
            n2 = Math.min(n2, rectangle.y + rectangle.height);
        }
        object = this.toDisplay(n, n2);
        event.x = ((Point)object).x;
        event.y = ((Point)object).y;
    }

    void updateMoveable() {
        int n = 0;
        while (n < this.columnCount) {
            if (this.columns[n].moveable) break;
            ++n;
        }
        int n2 = n < this.columnCount ? 16 : 0;
        OS.SendMessage(this.handle, 4150, 16L, (long)n2);
    }

    void updateOrientation() {
        int n;
        Object object;
        int n2;
        super.updateOrientation();
        long l = OS.SendMessage(this.handle, 4127, 0L, 0L);
        if (l != 0L) {
            int n3 = OS.GetWindowLong(l, -20);
            n3 = (this.style & 0x4000000) != 0 ? (n3 |= 0x400000) : (n3 &= 0xFFBFFFFF);
            OS.SetWindowLong(l, -20, n3);
            OS.InvalidateRect(l, null, true);
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            n2 = rECT.right - rECT.left;
            int n4 = rECT.bottom - rECT.top;
            OS.SetWindowPos(this.handle, 0L, 0, 0, n2 - 1, n4 - 1, 6);
            OS.SetWindowPos(this.handle, 0L, 0, 0, n2, n4, 6);
        }
        if ((this.style & 0x20) != 0) {
            this.fixCheckboxImageListColor(false);
        }
        if (this.imageList != null) {
            Point point = this.imageList.getImageSize();
            this.display.releaseImageList(this.imageList);
            this.imageList = this.display.getImageList(this.style & 0x4000000, point.x, point.y);
            int n5 = (int)OS.SendMessage(this.handle, 4100, 0L, 0L);
            n2 = 0;
            while (n2 < n5) {
                TableItem tableItem = this._getItem(n2, false);
                if (tableItem != null && (object = tableItem.image) != null && (n = this.imageList.indexOf((Image)object)) == -1) {
                    this.imageList.add((Image)object);
                }
                ++n2;
            }
            long l2 = this.imageList.getHandle();
            OS.SendMessage(this.handle, 4099, 1L, l2);
        }
        if (l != 0L && this.headerImageList != null) {
            Point point = this.headerImageList.getImageSize();
            this.display.releaseImageList(this.headerImageList);
            this.headerImageList = this.display.getImageList(this.style & 0x4000000, point.x, point.y);
            if (this.columns != null) {
                int n6 = 0;
                while (n6 < this.columns.length) {
                    Image image;
                    TableColumn tableColumn = this.columns[n6];
                    if (tableColumn != null && (image = tableColumn.image) != null) {
                        if (OS.COMCTL32_MAJOR < 6) {
                            object = new HDITEM();
                            ((HDITEM)object).mask = 4;
                            OS.SendMessage(l, OS.HDM_GETITEM, (long)n6, (HDITEM)object);
                            if ((((HDITEM)object).fmt & 0x800) != 0) {
                                n = this.headerImageList.indexOf(image);
                                if (n == -1) {
                                    this.headerImageList.add(image);
                                }
                                ((HDITEM)object).mask = 32;
                                ((HDITEM)object).iImage = n;
                                OS.SendMessage(l, OS.HDM_SETITEM, (long)n6, (HDITEM)object);
                            }
                        } else {
                            object = new LVCOLUMN();
                            ((LVCOLUMN)object).mask = 1;
                            OS.SendMessage(l, OS.LVM_GETCOLUMN, (long)n6, (LVCOLUMN)object);
                            if ((((LVCOLUMN)object).fmt & 0x800) != 0) {
                                n = this.headerImageList.indexOf(image);
                                if (n == -1) {
                                    this.headerImageList.add(image);
                                }
                                ((LVCOLUMN)object).iImage = n;
                                ((LVCOLUMN)object).mask = 16;
                                OS.SendMessage(l, OS.LVM_SETCOLUMN, (long)n6, (LVCOLUMN)object);
                            }
                        }
                    }
                    ++n6;
                }
            }
            long l3 = this.headerImageList.getHandle();
            OS.SendMessage(l, 4616, 0L, l3);
        }
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x40;
        if ((this.style & 0x8000) == 0) {
            n |= 8;
        }
        if ((this.style & 4) != 0) {
            n |= 4;
        }
        n |= 0x4001;
        if ((this.style & 0x10000000) != 0) {
            n |= 0x1000;
        }
        return n;
    }

    TCHAR windowClass() {
        return TableClass;
    }

    long windowProc() {
        return TableProc;
    }

    long windowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        if (l != this.handle) {
            switch (n) {
                case 123: {
                    LRESULT lRESULT = this.wmContextMenu(l, l2, l3);
                    if (lRESULT == null) break;
                    return lRESULT.value;
                }
                case 533: {
                    long l4;
                    if (OS.COMCTL32_MAJOR >= 6 || l3 == 0L || l3 == (l4 = OS.SendMessage(this.handle, 4127, 0L, 0L))) break;
                    OS.InvalidateRect(l4, null, true);
                    break;
                }
                case 675: {
                    if (OS.COMCTL32_MAJOR >= 6) {
                        this.updateHeaderToolTips();
                    }
                    this.updateHeaderToolTips();
                    break;
                }
                case 78: {
                    NMHDR nMHDR = new NMHDR();
                    OS.MoveMemory(nMHDR, l3, NMHDR.sizeof);
                    switch (nMHDR.code) {
                        case -530: 
                        case -522: 
                        case -521: 
                        case -520: {
                            return OS.SendMessage(this.handle, n, l2, l3);
                        }
                    }
                    break;
                }
                case 32: {
                    short s;
                    if (l2 != l || (s = (short)OS.LOWORD(l3)) != 1) break;
                    HDHITTESTINFO hDHITTESTINFO = new HDHITTESTINFO();
                    int n2 = OS.GetMessagePos();
                    POINT pOINT = new POINT();
                    OS.POINTSTOPOINT(pOINT, n2);
                    OS.ScreenToClient(l, pOINT);
                    hDHITTESTINFO.x = pOINT.x;
                    hDHITTESTINFO.y = pOINT.y;
                    long l5 = OS.SendMessage(this.handle, 4127, 0L, 0L);
                    int n3 = (int)OS.SendMessage(l5, 4614, 0L, hDHITTESTINFO);
                    if (n3 < 0 || n3 >= this.columnCount || this.columns[n3].resizable || (hDHITTESTINFO.flags & 0xC) == 0) break;
                    OS.SetCursor(OS.LoadCursor(0L, 32512L));
                    return 1L;
                }
            }
            return this.callWindowProc(l, n, l2, l3);
        }
        if (n == Display.DI_GETDRAGIMAGE && (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) || (this.style & 0x10000000) != 0 || this.hooks(40) || this.hooks(42))) {
            int n4 = (int)OS.SendMessage(this.handle, 4135, 0L, 0L);
            int n5 = (int)OS.SendMessage(this.handle, 4108, (long)(n4 - 1), 2L);
            if (n5 == -1) {
                return 0L;
            }
            POINT pOINT = new POINT();
            OS.POINTSTOPOINT(pOINT, OS.GetMessagePos());
            OS.MapWindowPoints(0L, this.handle, pOINT, 1);
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            TableItem tableItem = this._getItem(n5);
            RECT rECT2 = tableItem.getBounds(n5, 0, true, true, true);
            if ((this.style & 0x10000) != 0) {
                int n6 = 301;
                rECT2.left = Math.max(rECT.left, pOINT.x - n6 / 2);
                if (rECT.right > rECT2.left + n6) {
                    rECT2.right = rECT2.left + n6;
                } else {
                    rECT2.right = rECT.right;
                    rECT2.left = Math.max(rECT.left, rECT2.right - n6);
                }
            }
            long l6 = OS.CreateRectRgn(rECT2.left, rECT2.top, rECT2.right, rECT2.bottom);
            while ((n5 = (int)OS.SendMessage(this.handle, 4108, (long)n5, 2L)) != -1) {
                if (rECT2.bottom - rECT2.top > 301 || rECT2.bottom > rECT.bottom) break;
                RECT rECT3 = tableItem.getBounds(n5, 0, true, true, true);
                long l7 = OS.CreateRectRgn(rECT2.left, rECT3.top, rECT2.right, rECT3.bottom);
                OS.CombineRgn(l6, l6, l7, 2);
                OS.DeleteObject(l7);
                rECT2.bottom = rECT3.bottom;
            }
            OS.GetRgnBox(l6, rECT2);
            long l8 = OS.GetDC(this.handle);
            long l9 = OS.CreateCompatibleDC(l8);
            BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
            bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
            bITMAPINFOHEADER.biWidth = rECT2.right - rECT2.left;
            bITMAPINFOHEADER.biHeight = -(rECT2.bottom - rECT2.top);
            bITMAPINFOHEADER.biPlanes = 1;
            bITMAPINFOHEADER.biBitCount = (short)32;
            bITMAPINFOHEADER.biCompression = 0;
            byte[] byArray = new byte[BITMAPINFOHEADER.sizeof];
            OS.MoveMemory(byArray, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
            long[] lArray = new long[1];
            long l10 = OS.CreateDIBSection(0L, byArray, 0, lArray, 0L, 0);
            if (l10 == 0L) {
                this.error(2);
            }
            long l11 = OS.SelectObject(l9, l10);
            int n7 = 253;
            POINT pOINT2 = new POINT();
            OS.SetWindowOrgEx(l9, rECT2.left, rECT2.top, pOINT2);
            OS.FillRect(l9, rECT2, this.findBrush(n7, 0));
            OS.OffsetRgn(l6, -rECT2.left, -rECT2.top);
            OS.SelectClipRgn(l9, l6);
            OS.PrintWindow(this.handle, l9, 0);
            OS.SetWindowOrgEx(l9, pOINT2.x, pOINT2.y, null);
            OS.SelectObject(l9, l11);
            OS.DeleteDC(l9);
            OS.ReleaseDC(0L, l8);
            OS.DeleteObject(l6);
            SHDRAGIMAGE sHDRAGIMAGE = new SHDRAGIMAGE();
            sHDRAGIMAGE.hbmpDragImage = l10;
            sHDRAGIMAGE.crColorKey = n7;
            sHDRAGIMAGE.sizeDragImage.cx = bITMAPINFOHEADER.biWidth;
            sHDRAGIMAGE.sizeDragImage.cy = -bITMAPINFOHEADER.biHeight;
            sHDRAGIMAGE.ptOffset.x = pOINT.x - rECT2.left;
            sHDRAGIMAGE.ptOffset.y = pOINT.y - rECT2.top;
            if ((this.style & 0x8000000) != 0) {
                sHDRAGIMAGE.ptOffset.x = sHDRAGIMAGE.sizeDragImage.cx - sHDRAGIMAGE.ptOffset.x;
            }
            OS.MoveMemory(l3, sHDRAGIMAGE, SHDRAGIMAGE.sizeof);
            return 1L;
        }
        return super.windowProc(l, n, l2, l3);
    }

    LRESULT WM_CHAR(long l, long l2) {
        LRESULT lRESULT = super.WM_CHAR(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch ((int)l) {
            case 32: {
                int n;
                if ((this.style & 0x20) != 0 && (n = (int)OS.SendMessage(this.handle, 4108, -1L, 1L)) != -1) {
                    TableItem tableItem;
                    tableItem.setChecked(!(tableItem = this._getItem(n)).getChecked(), true);
                    if (!OS.IsWinCE) {
                        OS.NotifyWinEvent(32773, this.handle, -4, n + 1);
                    }
                }
                long l3 = this.callWindowProc(this.handle, 256, l, l2);
                return new LRESULT(l3);
            }
            case 13: {
                int n = (int)OS.SendMessage(this.handle, 4108, -1L, 1L);
                if (n != -1) {
                    Event event = new Event();
                    event.item = this._getItem(n);
                    this.sendSelectionEvent(14, event, false);
                }
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_CONTEXTMENU(long l, long l2) {
        if (!this.display.runDragDrop) {
            return LRESULT.ZERO;
        }
        return super.WM_CONTEXTMENU(l, l2);
    }

    LRESULT WM_ERASEBKGND(long l, long l2) {
        int n;
        LRESULT lRESULT = super.WM_ERASEBKGND(l, l2);
        if (this.findImageControl() != null) {
            return LRESULT.ONE;
        }
        if (!OS.IsWinCE && OS.COMCTL32_MAJOR < 6 && (this.style & 0x20000000) != 0 && ((n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 0x10000) == 0) {
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    LRESULT WM_GETOBJECT(long l, long l2) {
        if ((this.style & 0x20) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(l, l2);
    }

    LRESULT WM_KEYDOWN(long l, long l2) {
        LRESULT lRESULT = super.WM_KEYDOWN(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch ((int)l) {
            case 32: {
                return LRESULT.ZERO;
            }
            case 107: {
                if (OS.GetKeyState(17) >= 0) break;
                int n = 0;
                while (n < this.columnCount) {
                    if (!this.columns[n].getResizable()) break;
                    ++n;
                }
                if (n == this.columnCount && !this.hooks(41)) break;
                TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
                System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
                int n2 = 0;
                while (n2 < tableColumnArray.length) {
                    TableColumn tableColumn = tableColumnArray[n2];
                    if (!tableColumn.isDisposed() && tableColumn.getResizable()) {
                        tableColumn.pack();
                    }
                    ++n2;
                }
                return LRESULT.ZERO;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                long l3;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = OS.SendMessage(this.handle, 4127, 0L, 0L);
                boolean bl = this.isOptimizedRedraw();
                if (bl) {
                    l5 = OS.SetWindowLongPtr(this.handle, -4, TableProc);
                    l4 = OS.SetWindowLongPtr(l6, -4, HeaderProc);
                }
                LRESULT lRESULT2 = lRESULT = (l3 = this.callWindowProc(this.handle, 256, l, l2)) == 0L ? LRESULT.ZERO : new LRESULT(l3);
                if (bl) {
                    OS.SetWindowLongPtr(this.handle, -4, l5);
                    OS.SetWindowLongPtr(l6, -4, l4);
                }
            }
            case 38: 
            case 40: {
                OS.SendMessage(this.handle, 295, 3L, 0L);
            }
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(long l, long l2) {
        LRESULT lRESULT = super.WM_KILLFOCUS(l, l2);
        if (this.imageList != null || (this.style & 0x20) != 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
        return lRESULT;
    }

    LRESULT WM_LBUTTONDBLCLK(long l, long l2) {
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = OS.GET_X_LPARAM(l2);
        lVHITTESTINFO.y = OS.GET_Y_LPARAM(l2);
        int n = (int)OS.SendMessage(this.handle, 4114, 0L, lVHITTESTINFO);
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 1, this.handle, 513, l, l2);
        if (!this.sendMouseEvent(8, 1, this.handle, 515, l, l2)) {
            if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
                OS.SetCapture(this.handle);
            }
            return LRESULT.ZERO;
        }
        if (lVHITTESTINFO.iItem != -1) {
            this.callWindowProc(this.handle, 515, l, l2);
        }
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if ((this.style & 0x20) != 0 && n != -1 && lVHITTESTINFO.flags == 8) {
            TableItem tableItem;
            tableItem.setChecked(!(tableItem = this._getItem(n)).getChecked(), true);
            if (!OS.IsWinCE) {
                OS.NotifyWinEvent(32773, this.handle, -4, n + 1);
            }
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_LBUTTONDOWN(long l, long l2) {
        LRESULT lRESULT = this.sendMouseDownEvent(3, 1, 513, l, l2);
        if (lRESULT == LRESULT.ZERO) {
            return lRESULT;
        }
        if ((this.style & 0x20) != 0) {
            LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
            lVHITTESTINFO.x = OS.GET_X_LPARAM(l2);
            lVHITTESTINFO.y = OS.GET_Y_LPARAM(l2);
            int n = (int)OS.SendMessage(this.handle, 4114, 0L, lVHITTESTINFO);
            if (n != -1 && lVHITTESTINFO.flags == 8) {
                TableItem tableItem;
                tableItem.setChecked(!(tableItem = this._getItem(n)).getChecked(), true);
                if (!OS.IsWinCE) {
                    OS.NotifyWinEvent(32773, this.handle, -4, n + 1);
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEHOVER(long l, long l2) {
        int n;
        LRESULT lRESULT = super.WM_MOUSEHOVER(l, l2);
        int n2 = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
        if ((n2 & (n = 200)) != 0) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_PAINT(long l, long l2) {
        int n;
        this._checkShrink();
        if (this.fixScrollWidth) {
            this.setScrollWidth(null, true);
        }
        if (!(OS.IsWinCE || OS.COMCTL32_MAJOR >= 6 || (this.style & 0x20000000) == 0 && this.findImageControl() == null || ((n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 0x10000) != 0)) {
            boolean bl;
            GC gC = null;
            long l3 = 0L;
            PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
            boolean bl2 = bl = this.hooks(9) || this.filters(9);
            if (bl) {
                GCData gCData = new GCData();
                gCData.ps = pAINTSTRUCT;
                gCData.hwnd = this.handle;
                gC = GC.win32_new(this, gCData);
                l3 = gC.handle;
            } else {
                l3 = OS.BeginPaint(this.handle, pAINTSTRUCT);
            }
            int n2 = pAINTSTRUCT.right - pAINTSTRUCT.left;
            int n3 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
            if (n2 != 0 && n3 != 0) {
                Object object;
                long l4 = OS.CreateCompatibleDC(l3);
                POINT pOINT = new POINT();
                POINT pOINT2 = new POINT();
                OS.SetWindowOrgEx(l4, pAINTSTRUCT.left, pAINTSTRUCT.top, pOINT);
                OS.SetBrushOrgEx(l4, pAINTSTRUCT.left, pAINTSTRUCT.top, pOINT2);
                long l5 = OS.CreateCompatibleBitmap(l3, n2, n3);
                long l6 = OS.SelectObject(l4, l5);
                if ((int)OS.SendMessage(this.handle, 4096, 0L, 0L) != -1) {
                    object = new RECT();
                    OS.SetRect((RECT)object, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right, pAINTSTRUCT.bottom);
                    this.drawBackground(l4, (RECT)object);
                }
                this.callWindowProc(this.handle, 15, l4, 0L);
                OS.SetWindowOrgEx(l4, pOINT.x, pOINT.y, null);
                OS.SetBrushOrgEx(l4, pOINT2.x, pOINT2.y, null);
                OS.BitBlt(l3, pAINTSTRUCT.left, pAINTSTRUCT.top, n2, n3, l4, 0, 0, 0xCC0020);
                OS.SelectObject(l4, l6);
                OS.DeleteObject(l5);
                OS.DeleteObject(l4);
                if (bl) {
                    object = new Event();
                    ((Event)object).gc = gC;
                    ((Event)object).x = pAINTSTRUCT.left;
                    ((Event)object).y = pAINTSTRUCT.top;
                    ((Event)object).width = pAINTSTRUCT.right - pAINTSTRUCT.left;
                    ((Event)object).height = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
                    this.sendEvent(9, (Event)object);
                    ((Event)object).gc = null;
                }
            }
            if (bl) {
                gC.dispose();
            } else {
                OS.EndPaint(this.handle, pAINTSTRUCT);
            }
            return LRESULT.ZERO;
        }
        return super.WM_PAINT(l, l2);
    }

    LRESULT WM_RBUTTONDBLCLK(long l, long l2) {
        LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
        lVHITTESTINFO.x = OS.GET_X_LPARAM(l2);
        lVHITTESTINFO.y = OS.GET_Y_LPARAM(l2);
        OS.SendMessage(this.handle, 4114, 0L, lVHITTESTINFO);
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 3, this.handle, 516, l, l2);
        if (this.sendMouseEvent(8, 3, this.handle, 518, l, l2) && lVHITTESTINFO.iItem != -1) {
            this.callWindowProc(this.handle, 518, l, l2);
        }
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_RBUTTONDOWN(long l, long l2) {
        return this.sendMouseDownEvent(3, 3, 516, l, l2);
    }

    LRESULT WM_SETFOCUS(long l, long l2) {
        int n;
        LRESULT lRESULT = super.WM_SETFOCUS(l, l2);
        if (this.imageList != null || (this.style & 0x20) != 0) {
            OS.InvalidateRect(this.handle, null, false);
        }
        if ((n = (int)OS.SendMessage(this.handle, 4100, 0L, 0L)) == 0) {
            return lRESULT;
        }
        int n2 = (int)OS.SendMessage(this.handle, 4108, -1L, 1L);
        if (n2 == -1) {
            LVITEM lVITEM = new LVITEM();
            lVITEM.state = 1;
            lVITEM.stateMask = 1;
            this.ignoreSelect = true;
            OS.SendMessage(this.handle, 4139, 0L, lVITEM);
            this.ignoreSelect = false;
        }
        return lRESULT;
    }

    LRESULT WM_SETFONT(long l, long l2) {
        LRESULT lRESULT = super.WM_SETFONT(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        long l3 = OS.SendMessage(this.handle, 4127, 0L, 0L);
        OS.SendMessage(l3, 48, 0L, l2);
        if (this.headerToolTipHandle != 0L) {
            OS.SendMessage(this.headerToolTipHandle, 48, l, l2);
        }
        return lRESULT;
    }

    LRESULT WM_SETREDRAW(long l, long l2) {
        LRESULT lRESULT = super.WM_SETREDRAW(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (l == 1L && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) != -1 && (this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            OS.SendMessage(this.handle, 4097, 0L, -1L);
        }
        OS.DefWindowProc(this.handle, 11, l, l2);
        long l3 = this.callWindowProc(this.handle, 11, l, l2);
        if (l == 0L && (int)OS.SendMessage(this.handle, 4096, 0L, 0L) == -1) {
            OS.SendMessage(this.handle, 4097, 0L, 0xFFFFFFL);
        }
        return l3 == 0L ? LRESULT.ZERO : new LRESULT(l3);
    }

    LRESULT WM_SIZE(long l, long l2) {
        if (this.ignoreResize) {
            return null;
        }
        if (this.hooks(40) || this.hooks(42)) {
            OS.InvalidateRect(this.handle, null, true);
        }
        if (this.resizeCount != 0) {
            this.wasResized = true;
            return null;
        }
        return super.WM_SIZE(l, l2);
    }

    LRESULT WM_SYSCOLORCHANGE(long l, long l2) {
        LRESULT lRESULT = super.WM_SYSCOLORCHANGE(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.findBackgroundControl() == null) {
            this.setBackgroundPixel(this.defaultBackground());
        } else {
            int n = (int)OS.SendMessage(this.handle, 4096, 0L, 0L);
            if (n != -1 && this.findImageControl() == null && (this.style & 0x20) != 0) {
                this.fixCheckboxImageListColor(true);
            }
        }
        return lRESULT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    LRESULT WM_HSCROLL(long l, long l2) {
        RECT rECT;
        int n;
        int n2 = 0;
        int n3 = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
        if ((n3 & 1) != 0) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, sCROLLINFO);
            n2 = sCROLLINFO.nPos;
        }
        long l3 = 0L;
        long l4 = 0L;
        long l5 = OS.SendMessage(this.handle, 4127, 0L, 0L);
        boolean bl = this.isOptimizedRedraw();
        if (bl) {
            l4 = OS.SetWindowLongPtr(this.handle, -4, TableProc);
            l3 = OS.SetWindowLongPtr(l5, -4, HeaderProc);
        }
        boolean bl2 = false;
        if (OS.LOWORD(l) != 8 && OS.COMCTL32_MAJOR >= 6 && this.columnCount > 32 && (n = (int)OS.SendMessage(this.handle, 4136, 0L, 0L)) > 16) {
            boolean bl3 = bl2 = this.getDrawing() && OS.IsWindowVisible(this.handle);
        }
        if (bl2) {
            OS.DefWindowProc(this.handle, 11, 0L, 0L);
        }
        LRESULT lRESULT = super.WM_HSCROLL(l, l2);
        if (bl2) {
            OS.DefWindowProc(this.handle, 11, 1L, 0L);
            int n4 = 1157;
            OS.RedrawWindow(this.handle, null, 0L, n4);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                RECT rECT2 = new RECT();
                rECT = new RECT();
                OS.GetClientRect(this.handle, rECT);
                boolean[] blArray = new boolean[this.columnCount];
                int n5 = 0;
                while (n5 < this.columnCount) {
                    blArray[n5] = true;
                    if (OS.SendMessage(l5, 4615, (long)n5, rECT2) != 0L) {
                        OS.MapWindowPoints(l5, this.handle, rECT2, 2);
                        blArray[n5] = OS.IntersectRect(rECT2, rECT, rECT2);
                    }
                    ++n5;
                }
                try {
                    this.display.hwndParent = OS.GetParent(this.handle);
                    this.display.columnVisible = blArray;
                    OS.UpdateWindow(this.handle);
                    Object var20_21 = null;
                    this.display.columnVisible = null;
                }
                catch (Throwable throwable) {
                    Object var20_20 = null;
                    this.display.columnVisible = null;
                    throw throwable;
                }
            }
        }
        if (bl) {
            OS.SetWindowLongPtr(this.handle, -4, l4);
            OS.SetWindowLongPtr(l5, -4, l3);
        }
        if ((n3 & 1) != 0) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            OS.GetScrollInfo(this.handle, 0, sCROLLINFO);
            int n6 = sCROLLINFO.nPos;
            if (n6 < n2) {
                rECT = new RECT();
                OS.GetClientRect(this.handle, rECT);
                rECT.right = n2 - n6 + 1;
                OS.InvalidateRect(this.handle, rECT, true);
            }
        }
        return lRESULT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    LRESULT WM_VSCROLL(long l, long l2) {
        RECT rECT;
        RECT rECT2;
        int n;
        int n2;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = OS.SendMessage(this.handle, 4127, 0L, 0L);
        boolean bl = this.isOptimizedRedraw();
        if (bl) {
            l4 = OS.SetWindowLongPtr(this.handle, -4, TableProc);
            l3 = OS.SetWindowLongPtr(l5, -4, HeaderProc);
        }
        boolean bl2 = false;
        if (OS.LOWORD(l) != 8 && OS.COMCTL32_MAJOR >= 6 && this.columnCount > 32 && (n2 = (int)OS.SendMessage(this.handle, 4136, 0L, 0L)) > 16) {
            boolean bl3 = bl2 = this.getDrawing() && OS.IsWindowVisible(this.handle);
        }
        if (bl2) {
            OS.DefWindowProc(this.handle, 11, 0L, 0L);
        }
        LRESULT lRESULT = super.WM_VSCROLL(l, l2);
        if (bl2) {
            OS.DefWindowProc(this.handle, 11, 1L, 0L);
            n = 1157;
            OS.RedrawWindow(this.handle, null, 0L, n);
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                RECT rECT3 = new RECT();
                rECT2 = new RECT();
                OS.GetClientRect(this.handle, rECT2);
                boolean[] blArray = new boolean[this.columnCount];
                int n3 = 0;
                while (n3 < this.columnCount) {
                    blArray[n3] = true;
                    if (OS.SendMessage(l5, 4615, (long)n3, rECT3) != 0L) {
                        OS.MapWindowPoints(l5, this.handle, rECT3, 2);
                        blArray[n3] = OS.IntersectRect(rECT3, rECT2, rECT3);
                    }
                    ++n3;
                }
                try {
                    this.display.hwndParent = OS.GetParent(this.handle);
                    this.display.columnVisible = blArray;
                    OS.UpdateWindow(this.handle);
                    rECT = null;
                    this.display.columnVisible = null;
                }
                catch (Throwable throwable) {
                    Object var18_17 = null;
                    this.display.columnVisible = null;
                    throw throwable;
                }
            }
        }
        if (bl) {
            OS.SetWindowLongPtr(this.handle, -4, l4);
            OS.SetWindowLongPtr(l5, -4, l3);
        }
        if (((n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 1) == 0) return lRESULT;
        int n4 = OS.LOWORD(l);
        switch (n4) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return lRESULT;
            }
            case 0: 
            case 1: {
                rECT2 = new RECT();
                OS.GetWindowRect(l5, rECT2);
                int n5 = rECT2.bottom - rECT2.top;
                rECT = new RECT();
                OS.GetClientRect(this.handle, rECT);
                rECT.top += n5;
                long l6 = OS.SendMessage(this.handle, 4160, 0L, 0L);
                long l7 = OS.SendMessage(this.handle, 4160, 1L, 0L);
                int n6 = OS.HIWORD(l7) - OS.HIWORD(l6);
                if (n4 == 1) {
                    rECT.top = rECT.bottom - n6 - 1;
                } else {
                    rECT.bottom = rECT.top + n6 + 1;
                }
                OS.InvalidateRect(this.handle, rECT, true);
                return lRESULT;
            }
            case 2: 
            case 3: {
                OS.InvalidateRect(this.handle, null, true);
                return lRESULT;
            }
        }
        return lRESULT;
    }

    LRESULT wmMeasureChild(long l, long l2) {
        MEASUREITEMSTRUCT mEASUREITEMSTRUCT = new MEASUREITEMSTRUCT();
        OS.MoveMemory(mEASUREITEMSTRUCT, l2, MEASUREITEMSTRUCT.sizeof);
        if (this.itemHeight == -1) {
            long l3 = OS.SendMessage(this.handle, 4160, 0L, 0L);
            long l4 = OS.SendMessage(this.handle, 4160, 1L, 0L);
            mEASUREITEMSTRUCT.itemHeight = OS.HIWORD(l4) - OS.HIWORD(l3);
        } else {
            mEASUREITEMSTRUCT.itemHeight = this.itemHeight;
        }
        OS.MoveMemory(l2, mEASUREITEMSTRUCT, MEASUREITEMSTRUCT.sizeof);
        return null;
    }

    LRESULT wmNotify(NMHDR nMHDR, long l, long l2) {
        LRESULT lRESULT;
        LRESULT lRESULT2;
        long l3 = OS.SendMessage(this.handle, 4174, 0L, 0L);
        if (nMHDR.hwndFrom == l3 && (lRESULT2 = this.wmNotifyToolTip(nMHDR, l, l2)) != null) {
            return lRESULT2;
        }
        long l4 = OS.SendMessage(this.handle, 4127, 0L, 0L);
        if (nMHDR.hwndFrom == l4 && (lRESULT = this.wmNotifyHeader(nMHDR, l, l2)) != null) {
            return lRESULT;
        }
        return super.wmNotify(nMHDR, l, l2);
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, long l, long l2) {
        switch (nMHDR.code) {
            case -179: 
            case -152: {
                if ((this.style & 0x10000000) == 0) break;
                return new LRESULT(-1L);
            }
            case -115: {
                boolean bl;
                if ((this.style & 0x10000000) == 0 || this.ignoreSelect) break;
                NMLVODSTATECHANGE nMLVODSTATECHANGE = new NMLVODSTATECHANGE();
                OS.MoveMemory(nMLVODSTATECHANGE, l2, NMLVODSTATECHANGE.sizeof);
                boolean bl2 = (nMLVODSTATECHANGE.uOldState & 2) != 0;
                boolean bl3 = bl = (nMLVODSTATECHANGE.uNewState & 2) != 0;
                if (bl2 == bl) break;
                this.wasSelected = true;
                break;
            }
            case -177: 
            case -150: {
                Object[] objectArray;
                Object object;
                TableItem tableItem;
                NMLVDISPINFO nMLVDISPINFO = new NMLVDISPINFO();
                OS.MoveMemory(nMLVDISPINFO, l2, NMLVDISPINFO.sizeof);
                boolean[] blArray = this.display.columnVisible;
                if (blArray != null && !blArray[nMLVDISPINFO.iSubItem] || (tableItem = this._getItem(nMLVDISPINFO.iItem)) == null) break;
                if (this.ignoreShrink) {
                    if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                        RECT rECT = new RECT();
                        rECT.left = 0;
                        this.ignoreCustomDraw = true;
                        long l3 = OS.SendMessage(this.handle, 4110, (long)nMLVDISPINFO.iItem, rECT);
                        this.ignoreCustomDraw = false;
                        if (l3 == 0L) break;
                        OS.InvalidateRect(this.handle, rECT, true);
                        break;
                    }
                    if ((this.style & 0x10000000) != 0 && !tableItem.cached) {
                        OS.SendMessage(this.handle, 4117, (long)nMLVDISPINFO.iItem, (long)nMLVDISPINFO.iItem);
                        break;
                    }
                }
                if (!tableItem.cached) {
                    if ((this.style & 0x10000000) != 0) {
                        this.lastIndexOf = nMLVDISPINFO.iItem;
                        if (!this.checkData(tableItem, this.lastIndexOf, false)) break;
                        Object object2 = object = this.fixScrollWidth ? null : tableItem;
                        if (this.setScrollWidth((TableItem)object, true)) {
                            OS.InvalidateRect(this.handle, null, true);
                        }
                    }
                    tableItem.cached = true;
                }
                if ((nMLVDISPINFO.mask & 1) != 0) {
                    object = null;
                    if (nMLVDISPINFO.iSubItem == 0) {
                        object = tableItem.text;
                    } else {
                        String[] stringArray = tableItem.strings;
                        if (stringArray != null && nMLVDISPINFO.iSubItem < stringArray.length) {
                            object = stringArray[nMLVDISPINFO.iSubItem];
                        }
                    }
                    if (object != null) {
                        int n = Math.min(((String)object).length(), nMLVDISPINFO.cchTextMax - 1);
                        if (!this.tipRequested && nMLVDISPINFO.iSubItem == 0 && n == 0) {
                            object = " ";
                            n = 1;
                        }
                        if ((objectArray = (Object[])this.display.tableBuffer) == null || nMLVDISPINFO.cchTextMax > objectArray.length) {
                            this.display.tableBuffer = new char[nMLVDISPINFO.cchTextMax];
                            objectArray = this.display.tableBuffer;
                        }
                        ((String)object).getChars(0, n, (char[])objectArray, 0);
                        objectArray[n++] = (Image)false;
                        if (OS.IsUnicode) {
                            OS.MoveMemory(nMLVDISPINFO.pszText, (char[])objectArray, n * 2);
                        } else {
                            OS.WideCharToMultiByte(this.getCodePage(), 0, (char[])objectArray, n, nMLVDISPINFO.pszText, nMLVDISPINFO.cchTextMax, null, null);
                            OS.MoveMemory(nMLVDISPINFO.pszText + (long)nMLVDISPINFO.cchTextMax - 1L, new byte[1], 1);
                        }
                    }
                }
                boolean bl = false;
                if ((nMLVDISPINFO.mask & 2) != 0) {
                    Image image = null;
                    if (nMLVDISPINFO.iSubItem == 0) {
                        image = tableItem.image;
                    } else {
                        objectArray = tableItem.images;
                        if (objectArray != null && nMLVDISPINFO.iSubItem < objectArray.length) {
                            image = objectArray[nMLVDISPINFO.iSubItem];
                        }
                    }
                    if (image != null) {
                        nMLVDISPINFO.iImage = this.imageIndex(image, nMLVDISPINFO.iSubItem);
                        bl = true;
                    }
                }
                if ((nMLVDISPINFO.mask & 8) != 0 && nMLVDISPINFO.iSubItem == 0) {
                    int n = 1;
                    if (tableItem.checked) {
                        ++n;
                    }
                    if (tableItem.grayed) {
                        n += 2;
                    }
                    if (!OS.IsWindowEnabled(this.handle)) {
                        n += 4;
                    }
                    nMLVDISPINFO.state = n << 12;
                    nMLVDISPINFO.stateMask = 61440;
                    bl = true;
                }
                if ((nMLVDISPINFO.mask & 0x10) != 0 && nMLVDISPINFO.iSubItem == 0) {
                    nMLVDISPINFO.iIndent = tableItem.imageIndent;
                    bl = true;
                }
                if (!bl) break;
                OS.MoveMemory(l2, nMLVDISPINFO, NMLVDISPINFO.sizeof);
                break;
            }
            case -12: {
                long l4 = OS.SendMessage(this.handle, 4127, 0L, 0L);
                if (nMHDR.hwndFrom == l4 || !this.customDraw && this.findImageControl() == null && OS.IsWindowEnabled(this.handle) && (!this.explorerTheme || this.columnCount != 0)) break;
                NMLVCUSTOMDRAW nMLVCUSTOMDRAW = new NMLVCUSTOMDRAW();
                OS.MoveMemory(nMLVCUSTOMDRAW, l2, NMLVCUSTOMDRAW.sizeof);
                switch (nMLVCUSTOMDRAW.dwDrawStage) {
                    case 1: {
                        return this.CDDS_PREPAINT(nMLVCUSTOMDRAW, l, l2);
                    }
                    case 65537: {
                        return this.CDDS_ITEMPREPAINT(nMLVCUSTOMDRAW, l, l2);
                    }
                    case 65538: {
                        return this.CDDS_ITEMPOSTPAINT(nMLVCUSTOMDRAW, l, l2);
                    }
                    case 196609: {
                        return this.CDDS_SUBITEMPREPAINT(nMLVCUSTOMDRAW, l, l2);
                    }
                    case 196610: {
                        return this.CDDS_SUBITEMPOSTPAINT(nMLVCUSTOMDRAW, l, l2);
                    }
                    case 2: {
                        return this.CDDS_POSTPAINT(nMLVCUSTOMDRAW, l, l2);
                    }
                }
                break;
            }
            case -156: {
                if ((this.style & 4) != 0) {
                    return LRESULT.ONE;
                }
                if (this.hooks(3) || this.hooks(4)) {
                    return LRESULT.ONE;
                }
                if ((this.style & 0x4000000) == 0 || this.findImageControl() == null) break;
                return LRESULT.ONE;
            }
            case -111: 
            case -109: {
                if (OS.GetKeyState(1) >= 0) break;
                this.dragStarted = true;
                if (nMHDR.code != -109) break;
                int n = OS.GetMessagePos();
                POINT pOINT = new POINT();
                OS.POINTSTOPOINT(pOINT, n);
                OS.ScreenToClient(this.handle, pOINT);
                this.sendDragEvent(1, pOINT.x, pOINT.y);
                break;
            }
            case -108: {
                NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                OS.MoveMemory(nMLISTVIEW, l2, NMLISTVIEW.sizeof);
                TableColumn tableColumn = this.columns[nMLISTVIEW.iSubItem];
                if (tableColumn == null) break;
                tableColumn.sendSelectionEvent(13);
                break;
            }
            case -114: {
                if (this.ignoreActivate) break;
                NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                OS.MoveMemory(nMLISTVIEW, l2, NMLISTVIEW.sizeof);
                if (nMLISTVIEW.iItem == -1) break;
                Event event = new Event();
                event.item = this._getItem(nMLISTVIEW.iItem);
                this.sendSelectionEvent(14, event, false);
                break;
            }
            case -101: {
                long l5;
                int n;
                if (this.fullRowSelect) {
                    this.fullRowSelect = false;
                    OS.DefWindowProc(this.handle, 11, 1L, 0L);
                    OS.SendMessage(this.handle, 4150, 32L, 0L);
                }
                if (!this.ignoreSelect) {
                    NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                    OS.MoveMemory(nMLISTVIEW, l2, NMLISTVIEW.sizeof);
                    if ((nMLISTVIEW.uChanged & 8) != 0) {
                        if (nMLISTVIEW.iItem == -1) {
                            this.wasSelected = true;
                        } else {
                            int n2 = (nMLISTVIEW.uOldState & 2) != 0 ? 1 : 0;
                            int n3 = n = (nMLISTVIEW.uNewState & 2) != 0 ? 1 : 0;
                            if (n2 != n) {
                                this.wasSelected = true;
                            }
                        }
                    }
                }
                if (!this.hooks(40) && !this.hooks(42) || (n = (int)OS.SendMessage(l5 = OS.SendMessage(this.handle, 4127, 0L, 0L), 4608, 0L, 0L)) == 0) break;
                this.forceResize();
                RECT rECT = new RECT();
                OS.GetClientRect(this.handle, rECT);
                NMLISTVIEW nMLISTVIEW = new NMLISTVIEW();
                OS.MoveMemory(nMLISTVIEW, l2, NMLISTVIEW.sizeof);
                if (nMLISTVIEW.iItem == -1) break;
                RECT rECT2 = new RECT();
                rECT2.left = 0;
                this.ignoreCustomDraw = true;
                OS.SendMessage(this.handle, 4110, (long)nMLISTVIEW.iItem, rECT2);
                this.ignoreCustomDraw = false;
                RECT rECT3 = new RECT();
                int n4 = (int)OS.SendMessage(l5, 4623, (long)(n - 1), 0L);
                OS.SendMessage(l5, 4615, (long)n4, rECT3);
                OS.MapWindowPoints(l5, this.handle, rECT3, 2);
                rECT.left = rECT3.right;
                rECT.top = rECT2.top;
                rECT.bottom = rECT2.bottom;
                OS.InvalidateRect(this.handle, rECT, true);
                break;
            }
            case -16: {
                boolean bl;
                if (!OS.IsPPC) break;
                boolean bl4 = bl = this.menu != null && !this.menu.isDisposed();
                if (bl || this.hooks(35)) break;
                return LRESULT.ONE;
            }
            case 1000: {
                boolean bl;
                if (!OS.IsPPC) break;
                boolean bl5 = bl = this.menu != null && !this.menu.isDisposed();
                if (!bl && !this.hooks(35)) break;
                NMRGINFO nMRGINFO = new NMRGINFO();
                OS.MoveMemory(nMRGINFO, l2, NMRGINFO.sizeof);
                this.showMenu(nMRGINFO.x, nMRGINFO.y);
                return LRESULT.ONE;
            }
        }
        return super.wmNotifyChild(nMHDR, l, l2);
    }

    LRESULT wmNotifyHeader(NMHDR nMHDR, long l, long l2) {
        block0 : switch (nMHDR.code) {
            case -326: 
            case -325: 
            case -306: 
            case -305: {
                if (this.columnCount == 0) {
                    return LRESULT.ONE;
                }
                NMHEADER nMHEADER = new NMHEADER();
                OS.MoveMemory(nMHEADER, l2, NMHEADER.sizeof);
                TableColumn tableColumn = this.columns[nMHEADER.iItem];
                if (tableColumn != null && !tableColumn.getResizable()) {
                    return LRESULT.ONE;
                }
                this.ignoreColumnMove = true;
                switch (nMHDR.code) {
                    case -325: 
                    case -305: {
                        boolean bl = false;
                        if (!OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0)) {
                            boolean bl2 = bl = nMHEADER.iItem == 0 && !this.firstColumnImage;
                        }
                        if (tableColumn == null || !bl && !this.hooks(41)) break block0;
                        tableColumn.pack();
                        return LRESULT.ONE;
                    }
                }
                break;
            }
            case -16: {
                if (!this.ignoreColumnMove) {
                    int n = 0;
                    while (n < this.columnCount) {
                        TableColumn tableColumn = this.columns[n];
                        tableColumn.updateToolTip(n);
                        ++n;
                    }
                }
                this.ignoreColumnMove = false;
                break;
            }
            case -310: {
                TableColumn tableColumn;
                if (this.ignoreColumnMove) {
                    return LRESULT.ONE;
                }
                int n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
                if ((n & 0x10) == 0) break;
                if (this.columnCount == 0) {
                    return LRESULT.ONE;
                }
                NMHEADER nMHEADER = new NMHEADER();
                OS.MoveMemory(nMHEADER, l2, NMHEADER.sizeof);
                if (nMHEADER.iItem == -1 || (tableColumn = this.columns[nMHEADER.iItem]) == null || tableColumn.getMoveable()) break;
                this.ignoreColumnMove = true;
                return LRESULT.ONE;
            }
            case -311: {
                int n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L);
                if ((n & 0x10) == 0) break;
                NMHEADER nMHEADER = new NMHEADER();
                OS.MoveMemory(nMHEADER, l2, NMHEADER.sizeof);
                if (nMHEADER.iItem == -1 || nMHEADER.pitem == 0L) break;
                HDITEM hDITEM = new HDITEM();
                OS.MoveMemory(hDITEM, nMHEADER.pitem, HDITEM.sizeof);
                if ((hDITEM.mask & 0x80) == 0 || hDITEM.iOrder == -1 || this.columnCount == 0) break;
                int[] nArray = new int[this.columnCount];
                OS.SendMessage(this.handle, 4155, (long)this.columnCount, nArray);
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] == nMHEADER.iItem) break;
                    ++n2;
                }
                if (n2 == nArray.length) {
                    n2 = 0;
                }
                if (n2 == hDITEM.iOrder) break;
                int n3 = Math.min(n2, hDITEM.iOrder);
                int n4 = Math.max(n2, hDITEM.iOrder);
                this.ignoreColumnMove = false;
                int n5 = n3;
                while (n5 <= n4) {
                    TableColumn tableColumn = this.columns[nArray[n5]];
                    if (!tableColumn.isDisposed()) {
                        tableColumn.postEvent(10);
                    }
                    ++n5;
                }
                break;
            }
            case -321: 
            case -301: {
                TableColumn tableColumn;
                Object object;
                int n;
                int n6 = (int)OS.SendMessage(this.handle, 4125, 0L, 0L);
                if (this.lastWidth == 0 && n6 > 0 && ((n = (int)OS.SendMessage(this.handle, 4151, 0L, 0L)) & 1) != 0) {
                    object = new RECT();
                    OS.GetClientRect(this.handle, (RECT)object);
                    ((RECT)object).right = ((RECT)object).left + n6;
                    OS.InvalidateRect(this.handle, (RECT)object, true);
                }
                this.lastWidth = n6;
                if (this.ignoreColumnResize) break;
                NMHEADER nMHEADER = new NMHEADER();
                OS.MoveMemory(nMHEADER, l2, NMHEADER.sizeof);
                if (nMHEADER.pitem == 0L) break;
                object = new HDITEM();
                OS.MoveMemory((HDITEM)object, nMHEADER.pitem, HDITEM.sizeof);
                if ((((HDITEM)object).mask & 1) == 0 || (tableColumn = this.columns[nMHEADER.iItem]) == null) break;
                tableColumn.updateToolTip(nMHEADER.iItem);
                tableColumn.sendEvent(11);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
                TableColumn[] tableColumnArray = new TableColumn[this.columnCount];
                System.arraycopy(this.columns, 0, tableColumnArray, 0, this.columnCount);
                int[] nArray = new int[this.columnCount];
                OS.SendMessage(this.handle, 4155, (long)this.columnCount, nArray);
                boolean bl = false;
                int n7 = 0;
                while (n7 < this.columnCount) {
                    TableColumn tableColumn2 = tableColumnArray[nArray[n7]];
                    if (bl && !tableColumn2.isDisposed()) {
                        tableColumn2.updateToolTip(nArray[n7]);
                        tableColumn2.sendEvent(10);
                    }
                    if (tableColumn2 == tableColumn) {
                        bl = true;
                    }
                    ++n7;
                }
                break;
            }
            case -323: 
            case -303: {
                NMHEADER nMHEADER = new NMHEADER();
                OS.MoveMemory(nMHEADER, l2, NMHEADER.sizeof);
                TableColumn tableColumn = this.columns[nMHEADER.iItem];
                if (tableColumn == null) break;
                tableColumn.sendSelectionEvent(14);
            }
        }
        return null;
    }

    LRESULT wmNotifyToolTip(NMHDR nMHDR, long l, long l2) {
        if (OS.IsWinCE) {
            return null;
        }
        switch (nMHDR.code) {
            case -12: {
                if (this.toolTipText != null || !this.isCustomToolTip()) break;
                NMTTCUSTOMDRAW nMTTCUSTOMDRAW = new NMTTCUSTOMDRAW();
                OS.MoveMemory(nMTTCUSTOMDRAW, l2, NMTTCUSTOMDRAW.sizeof);
                return this.wmNotifyToolTip(nMTTCUSTOMDRAW, l2);
            }
            case -530: 
            case -521: 
            case -520: {
                LRESULT lRESULT = super.wmNotify(nMHDR, l, l2);
                if (lRESULT != null) {
                    return lRESULT;
                }
                if (nMHDR.code != -521) {
                    this.tipRequested = true;
                }
                long l3 = this.callWindowProc(this.handle, 78, l, l2);
                if (nMHDR.code != -521) {
                    this.tipRequested = false;
                }
                if (this.toolTipText != null) break;
                if (this.isCustomToolTip()) {
                    LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
                    int n = OS.GetMessagePos();
                    POINT pOINT = new POINT();
                    OS.POINTSTOPOINT(pOINT, n);
                    OS.ScreenToClient(this.handle, pOINT);
                    lVHITTESTINFO.x = pOINT.x;
                    lVHITTESTINFO.y = pOINT.y;
                    if (OS.SendMessage(this.handle, 4153, 0L, lVHITTESTINFO) >= 0L) {
                        long l4;
                        TableItem tableItem = this._getItem(lVHITTESTINFO.iItem);
                        long l5 = OS.GetDC(this.handle);
                        long l6 = 0L;
                        long l7 = OS.SendMessage(this.handle, 49, 0L, 0L);
                        if (l7 != 0L) {
                            l6 = OS.SelectObject(l5, l7);
                        }
                        if ((l4 = tableItem.fontHandle(lVHITTESTINFO.iSubItem)) != -1L) {
                            l4 = OS.SelectObject(l5, l4);
                        }
                        Event event = this.sendMeasureItemEvent(tableItem, lVHITTESTINFO.iItem, lVHITTESTINFO.iSubItem, l5);
                        if (!this.isDisposed() && !tableItem.isDisposed()) {
                            RECT rECT = new RECT();
                            OS.SetRect(rECT, event.x, event.y, event.x + event.width, event.y + event.height);
                            if (nMHDR.code == -521) {
                                RECT rECT2 = this.toolTipRect(rECT);
                                OS.MapWindowPoints(this.handle, 0L, rECT2, 2);
                                long l8 = OS.SendMessage(this.handle, 4174, 0L, 0L);
                                int n2 = 20;
                                int n3 = rECT2.right - rECT2.left;
                                int n4 = rECT2.bottom - rECT2.top;
                                this.SetWindowPos(l8, 0L, rECT2.left, rECT2.top, n3, n4, n2);
                            } else {
                                String string;
                                NMTTDISPINFO nMTTDISPINFO = null;
                                if (nMHDR.code == -520) {
                                    nMTTDISPINFO = new NMTTDISPINFOA();
                                    OS.MoveMemory(nMTTDISPINFO, l2, NMTTDISPINFOA.sizeof);
                                    if (nMTTDISPINFO.lpszText != 0L) {
                                        OS.MoveMemory(nMTTDISPINFO.lpszText, new byte[1], 1);
                                        OS.MoveMemory(l2, nMTTDISPINFO, NMTTDISPINFOA.sizeof);
                                    }
                                } else {
                                    nMTTDISPINFO = new NMTTDISPINFOW();
                                    OS.MoveMemory((NMTTDISPINFOW)nMTTDISPINFO, l2, NMTTDISPINFOW.sizeof);
                                    if (nMTTDISPINFO.lpszText != 0L) {
                                        OS.MoveMemory(nMTTDISPINFO.lpszText, new char[1], 2);
                                        OS.MoveMemory(l2, (NMTTDISPINFOW)nMTTDISPINFO, NMTTDISPINFOW.sizeof);
                                    }
                                }
                                RECT rECT3 = tableItem.getBounds(lVHITTESTINFO.iItem, lVHITTESTINFO.iSubItem, true, true, true, true, l5);
                                RECT rECT4 = new RECT();
                                OS.GetClientRect(this.handle, rECT4);
                                if ((rECT.right > rECT3.right || rECT.right > rECT4.right) && (string = " ") != null) {
                                    Shell shell = this.getShell();
                                    char[] cArray = new char[string.length() + 1];
                                    string.getChars(0, string.length(), cArray, 0);
                                    if (nMHDR.code == -520) {
                                        byte[] byArray = new byte[cArray.length * 2];
                                        OS.WideCharToMultiByte(this.getCodePage(), 0, cArray, cArray.length, byArray, byArray.length, null, null);
                                        shell.setToolTipText(nMTTDISPINFO, byArray);
                                        OS.MoveMemory(l2, nMTTDISPINFO, NMTTDISPINFOA.sizeof);
                                    } else {
                                        shell.setToolTipText(nMTTDISPINFO, cArray);
                                        OS.MoveMemory(l2, (NMTTDISPINFOW)nMTTDISPINFO, NMTTDISPINFOW.sizeof);
                                    }
                                }
                            }
                        }
                        if (l4 != -1L) {
                            l4 = OS.SelectObject(l5, l4);
                        }
                        if (l7 != 0L) {
                            OS.SelectObject(l5, l6);
                        }
                        OS.ReleaseDC(this.handle, l5);
                    }
                }
                return new LRESULT(l3);
            }
        }
        return null;
    }

    LRESULT wmNotifyToolTip(NMTTCUSTOMDRAW nMTTCUSTOMDRAW, long l) {
        if (OS.IsWinCE) {
            return null;
        }
        switch (nMTTCUSTOMDRAW.dwDrawStage) {
            case 1: {
                if (!this.isCustomToolTip()) break;
                return new LRESULT(18L);
            }
            case 2: {
                Object object;
                LVHITTESTINFO lVHITTESTINFO = new LVHITTESTINFO();
                int n = OS.GetMessagePos();
                POINT pOINT = new POINT();
                OS.POINTSTOPOINT(pOINT, n);
                OS.ScreenToClient(this.handle, pOINT);
                lVHITTESTINFO.x = pOINT.x;
                lVHITTESTINFO.y = pOINT.y;
                if (OS.SendMessage(this.handle, 4153, 0L, lVHITTESTINFO) < 0L) break;
                TableItem tableItem = this._getItem(lVHITTESTINFO.iItem);
                long l2 = OS.GetDC(this.handle);
                long l3 = tableItem.fontHandle(lVHITTESTINFO.iSubItem);
                if (l3 == -1L) {
                    l3 = OS.SendMessage(this.handle, 49, 0L, 0L);
                }
                long l4 = OS.SelectObject(l2, l3);
                boolean bl = true;
                RECT rECT = tableItem.getBounds(lVHITTESTINFO.iItem, lVHITTESTINFO.iSubItem, true, true, false, false, l2);
                if (this.hooks(40)) {
                    object = this.sendEraseItemEvent(tableItem, nMTTCUSTOMDRAW, lVHITTESTINFO.iSubItem, rECT);
                    if (this.isDisposed() || tableItem.isDisposed()) break;
                    bl = ((Event)object).doit ? (((Event)object).detail & 0x10) != 0 : false;
                }
                if (bl) {
                    Object object2;
                    Object object3;
                    Image image;
                    int n2 = OS.SaveDC(nMTTCUSTOMDRAW.hdc);
                    int n3 = this.getLinesVisible() ? 1 : 0;
                    RECT rECT2 = this.toolTipInset(rECT);
                    OS.SetWindowOrgEx(nMTTCUSTOMDRAW.hdc, rECT2.left, rECT2.top, null);
                    GCData gCData = new GCData();
                    gCData.device = this.display;
                    gCData.foreground = OS.GetTextColor(nMTTCUSTOMDRAW.hdc);
                    gCData.background = OS.GetBkColor(nMTTCUSTOMDRAW.hdc);
                    gCData.font = Font.win32_new(this.display, l3);
                    GC gC = GC.win32_new(nMTTCUSTOMDRAW.hdc, gCData);
                    int n4 = rECT.left;
                    if (lVHITTESTINFO.iSubItem != 0) {
                        n4 -= n3;
                    }
                    if ((image = tableItem.getImage(lVHITTESTINFO.iSubItem)) != null) {
                        object3 = image.getBounds();
                        RECT rECT3 = tableItem.getBounds(lVHITTESTINFO.iItem, lVHITTESTINFO.iSubItem, false, true, false, false, l2);
                        object2 = this.imageList == null ? new Point(((Rectangle)object3).width, ((Rectangle)object3).height) : this.imageList.getImageSize();
                        int n5 = rECT3.top;
                        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                            n5 += Math.max(0, (rECT3.bottom - rECT3.top - ((Point)object2).y) / 2);
                        }
                        gC.drawImage(image, ((Rectangle)object3).x, ((Rectangle)object3).y, ((Rectangle)object3).width, ((Rectangle)object3).height, n4, n5, ((Point)object2).x, ((Point)object2).y);
                        n4 += ((Point)object2).x + 4 + (lVHITTESTINFO.iSubItem == 0 ? -2 : 4);
                    } else {
                        n4 += 6;
                    }
                    object3 = tableItem.getText(lVHITTESTINFO.iSubItem);
                    if (object3 != null) {
                        int n6 = 2084;
                        Object object4 = object2 = this.columns != null ? this.columns[lVHITTESTINFO.iSubItem] : null;
                        if (object2 != null) {
                            if ((((TableColumn)object2).style & 0x1000000) != 0) {
                                n6 |= 1;
                            }
                            if ((((TableColumn)object2).style & 0x20000) != 0) {
                                n6 |= 2;
                            }
                        }
                        TCHAR tCHAR = new TCHAR(this.getCodePage(), (String)object3, false);
                        RECT rECT4 = new RECT();
                        OS.SetRect(rECT4, n4, rECT.top, rECT.right, rECT.bottom);
                        OS.DrawText(nMTTCUSTOMDRAW.hdc, tCHAR, tCHAR.length(), rECT4, n6);
                    }
                    gC.dispose();
                    OS.RestoreDC(nMTTCUSTOMDRAW.hdc, n2);
                }
                if (this.hooks(42)) {
                    object = tableItem.getBounds(lVHITTESTINFO.iItem, lVHITTESTINFO.iSubItem, true, true, false, false, l2);
                    this.sendPaintItemEvent(tableItem, nMTTCUSTOMDRAW, lVHITTESTINFO.iSubItem, (RECT)object);
                }
                OS.SelectObject(l2, l4);
                OS.ReleaseDC(this.handle, l2);
            }
        }
        return null;
    }
}

