/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScroller;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    NSScroller view;
    Scrollable parent;
    int minimum;
    int maximum = 100;
    int thumb = 10;
    int increment = 1;
    int pageIncrement = 10;
    id target;
    long actionSelector;

    ScrollBar() {
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ScrollBar.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.view);
    }

    boolean getDrawing() {
        return this.parent.getDrawing();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        NSScroller nSScroller = this.view;
        double d = nSScroller.doubleValue();
        return (int)(0.5 + ((double)(this.maximum - this.thumb - this.minimum) * d + (double)this.minimum));
    }

    public Point getSize() {
        this.checkWidget();
        NSRect nSRect = this.view.frame();
        return new Point((int)nSRect.width, (int)nSRect.height);
    }

    public int getThumb() {
        this.checkWidget();
        return this.thumb;
    }

    public Rectangle getThumbBounds() {
        this.checkWidget();
        NSRect nSRect = this.view.rectForPart(2L);
        nSRect = this.view.convertRect_toView_(nSRect, this.parent.view);
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    public Rectangle getThumbTrackBounds() {
        this.checkWidget();
        NSRect nSRect = this.view.rectForPart(6L);
        nSRect = this.view.convertRect_toView_(nSRect, this.parent.view);
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)nSRect.width, (int)nSRect.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0 && !this.view.isHidden();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void register() {
        super.register();
        this.display.addWidget(this.view, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.view != null) {
            this.view.release();
        }
        this.view = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    void sendSelection() {
        NSPoint nSPoint;
        NSWindow nSWindow = this.view.window();
        if (this.target == null) {
            this.parent.getShell().deferFlushing();
        }
        int n = 0;
        if (this.target != null) {
            this.view.sendAction(this.actionSelector, this.target);
        } else {
            n = this.getSelection();
        }
        NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
        if (nSEvent != null) {
            nSPoint = nSEvent.locationInWindow();
            if (nSEvent.window() == null) {
                nSPoint = nSWindow.convertScreenToBase(nSPoint);
            }
        } else {
            nSPoint = nSWindow.mouseLocationOutsideOfEventStream();
        }
        int n2 = (int)this.view.testPart(nSPoint);
        Event event = new Event();
        switch (n2) {
            case 4: {
                n -= this.increment;
                event.detail = 0x1000001;
                break;
            }
            case 1: {
                n -= this.pageIncrement;
                event.detail = 0x1000005;
                break;
            }
            case 5: {
                n += this.increment;
                event.detail = 0x1000002;
                break;
            }
            case 3: {
                n += this.pageIncrement;
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 1;
            }
        }
        if (this.target == null && event.detail != 1) {
            this.setSelection(n);
        }
        this.sendSelectionEvent(13, event, true);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.increment = n;
    }

    void setClipRegion(NSView nSView) {
        this.parent.setClipRegion(nSView);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (bl) {
            if ((this.state & 8) == 0) {
                return;
            }
            this.state &= 0xFFFFFFF7;
        } else {
            if ((this.state & 8) != 0) {
                return;
            }
            this.state |= 8;
        }
        this.enableWidget(bl);
    }

    void enableWidget(boolean bl) {
        if (!bl || (this.state & 8) == 0) {
            this.view.setEnabled(bl);
        }
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n <= this.minimum) {
            return;
        }
        if (n - this.minimum < this.thumb) {
            this.thumb = n - this.minimum;
        }
        int n2 = Math.max(this.minimum, Math.min(this.getSelection(), n - this.thumb));
        this.maximum = n;
        this.updateBar(n2, this.minimum, n, this.thumb);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n >= this.maximum) {
            return;
        }
        if (this.maximum - n < this.thumb) {
            this.thumb = this.maximum - n;
        }
        int n2 = Math.min(this.maximum - this.thumb, Math.max(this.getSelection(), n));
        this.minimum = n;
        this.updateBar(n2, n, this.maximum, this.thumb);
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.pageIncrement = n;
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.updateBar(n, this.minimum, this.maximum, this.thumb);
    }

    public void setThumb(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        n = Math.min(n, this.maximum - this.minimum);
        this.updateBar(this.getSelection(), this.minimum, this.maximum, n);
        this.thumb = n;
    }

    public void setValues(int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        if (n3 < 0) {
            return;
        }
        if (n4 < 1) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        this.thumb = n4 = Math.min(n4, n3 - n2);
        this.maximum = n3;
        this.minimum = n2;
        this.increment = n5;
        this.pageIncrement = n6;
        this.updateBar(n, n2, n3, n4);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        this.parent.setScrollBarVisible(this, bl);
    }

    void updateBar(int n, int n2, int n3, int n4) {
        NSScroller nSScroller = this.view;
        n = Math.max(n2, Math.min(n3 - n4, n));
        int n5 = n3 - n4 - n2;
        float f = n5 <= 0 ? 1.0f : (float)(n - n2) / (float)n5;
        float f2 = n5 <= 0 ? 1.0f : (float)n4 / (float)(n3 - n2);
        double d = nSScroller.doubleValue();
        double d2 = nSScroller.knobProportion();
        nSScroller.setDoubleValue(f);
        nSScroller.setKnobProportion(f2);
        nSScroller.setEnabled(n5 > 0);
        if (OS.VERSION >= 4208 && this.target == null && ((double)f2 != d2 || (double)f != d)) {
            OS.objc_msgSend(this.parent.scrollView.id, OS.sel_flashScrollers);
        }
    }
}

