/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.internal.mozilla.nsIFocusManager;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class MozillaDelegate {
    Browser browser;
    Vector childWindows = new Vector(9);
    static long MozillaProc;
    static Callback SubclassProc;
    static Callback SubclassProc_UpdateUIState;
    static /* synthetic */ Class class$org$eclipse$swt$browser$MozillaDelegate;

    MozillaDelegate(Browser browser) {
        this.browser = browser;
    }

    static Browser findBrowser(long l) {
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(l);
    }

    static String getCacheParentPath() {
        TCHAR tCHAR = new TCHAR(0, 260);
        if (OS.SHGetFolderPath(0L, 28, 0L, 0, tCHAR) == 0) {
            return tCHAR.toString(0, tCHAR.strlen()) + Mozilla.SEPARATOR_OS + "eclipse";
        }
        return MozillaDelegate.getProfilePath();
    }

    static String[] getJSLibraryNames() {
        return new String[]{"mozjs.dll", "xul.dll"};
    }

    static String getJSLibraryName_Pre4() {
        return "js3250.dll";
    }

    static String getLibraryName() {
        return "xpcom.dll";
    }

    static String getProfilePath() {
        TCHAR tCHAR = new TCHAR(0, 260);
        String string = OS.SHGetFolderPath(0L, 26, 0L, 0, tCHAR) == 0 ? tCHAR.toString(0, tCHAR.strlen()) : System.getProperty("user.home");
        return string + Mozilla.SEPARATOR_OS + "Mozilla" + Mozilla.SEPARATOR_OS + "eclipse";
    }

    static String getSWTInitLibraryName() {
        return "swt-xulrunner";
    }

    static void loadAdditionalLibraries(String string) {
    }

    static char[] mbcsToWcs(String string, byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = OS.MultiByteToWideChar(0, 1, byArray, byArray.length, cArray, cArray.length);
        if (n == cArray.length) {
            return cArray;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    static boolean needsSpinup() {
        return false;
    }

    static boolean supportsXULRunner17() {
        return true;
    }

    static byte[] wcsToMbcs(String string, String string2, boolean bl) {
        char[] cArray = new char[string2.length()];
        string2.getChars(0, cArray.length, cArray, 0);
        int n = cArray.length * 2 + (bl ? 1 : 0);
        byte[] byArray = new byte[n];
        n = OS.WideCharToMultiByte(0, 0, cArray, cArray.length, byArray, n, null, null);
        if (bl) {
            ++n;
        } else if (byArray.length != n) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        return byArray;
    }

    static long windowProc(long l, long l2, long l3, long l4) {
        switch ((int)l2) {
            case 296: {
                return 0L;
            }
            case 20: {
                RECT rECT = new RECT();
                OS.GetClientRect(l, rECT);
                OS.FillRect(l3, rECT, OS.GetSysColorBrush(OS.COLOR_WINDOW));
            }
        }
        return OS.CallWindowProc(MozillaProc, l, (int)l2, l3, l4);
    }

    static long windowProc1(long l, long l2, long l3, long l4) {
        switch ((int)l2) {
            case 296: {
                return 0L;
            }
        }
        return OS.CallWindowProc(MozillaProc, l, (int)l2, l3, l4);
    }

    void addWindowSubclass() {
        long l = OS.GetWindow(this.browser.handle, 5);
        if (SubclassProc == null) {
            SubclassProc = new Callback(class$org$eclipse$swt$browser$MozillaDelegate == null ? (class$org$eclipse$swt$browser$MozillaDelegate = MozillaDelegate.class$("org.eclipse.swt.browser.MozillaDelegate")) : class$org$eclipse$swt$browser$MozillaDelegate, "windowProc", 4);
            MozillaProc = OS.GetWindowLongPtr(l, -4);
        }
        OS.SetWindowLongPtr(l, -4, SubclassProc.getAddress());
    }

    int createBaseWindow(nsIBaseWindow nsIBaseWindow2) {
        return nsIBaseWindow2.Create();
    }

    long getHandle() {
        return this.browser.handle;
    }

    long getSiteWindow() {
        if (Mozilla.IsPre_4 || Mozilla.IsGettingSiteWindow) {
            return this.getHandle();
        }
        Composite composite = new Composite(this.browser, 0);
        this.childWindows.addElement(composite);
        return composite.handle;
    }

    void handleFocus() {
    }

    void handleMouseDown() {
    }

    boolean hookEnterExit() {
        return true;
    }

    void init() {
        if (!Mozilla.IsPre_4) {
            this.browser.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    switch (event.detail) {
                        case 2: 
                        case 4: {
                            event.doit = false;
                            break;
                        }
                        case 8: 
                        case 16: {
                            long[] lArray = new long[1];
                            int n = XPCOM.NS_GetServiceManager(lArray);
                            if (n != 0) {
                                Mozilla.error(n);
                            }
                            if (lArray[0] == 0L) {
                                Mozilla.error(-2147467262);
                            }
                            nsIServiceManager nsIServiceManager2 = new nsIServiceManager(lArray[0]);
                            lArray[0] = 0L;
                            byte[] byArray = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/focus-manager;1", true);
                            n = nsIServiceManager2.GetServiceByContractID(byArray, nsIFocusManager.NS_IFOCUSMANAGER_10_IID, lArray);
                            nsIServiceManager2.Release();
                            if (n != 0 || lArray[0] == 0L) break;
                            nsIFocusManager nsIFocusManager2 = new nsIFocusManager(lArray[0]);
                            lArray[0] = 0L;
                            n = nsIFocusManager2.GetFocusedElement(lArray);
                            nsIFocusManager2.Release();
                            boolean bl = event.doit = lArray[0] == 0L;
                            if (n != 0 || lArray[0] == 0L) break;
                            new nsISupports(lArray[0]).Release();
                            break;
                        }
                    }
                }
            });
            this.browser.addLocationListener(new LocationAdapter(){

                public void changing(LocationEvent locationEvent) {
                    Enumeration enumeration = MozillaDelegate.this.childWindows.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Composite)enumeration.nextElement()).dispose();
                    }
                    MozillaDelegate.this.childWindows.clear();
                }
            });
        }
    }

    void onDispose(long l) {
        if (SubclassProc == null && SubclassProc_UpdateUIState == null) {
            return;
        }
        long l2 = OS.GetWindow(this.browser.handle, 5);
        OS.SetWindowLongPtr(l2, -4, MozillaProc);
        this.childWindows = null;
        this.browser = null;
    }

    void removeWindowSubclass() {
        long l = OS.GetWindow(this.browser.handle, 5);
        if (Mozilla.IsPre_17) {
            if (SubclassProc != null) {
                OS.SetWindowLongPtr(l, -4, MozillaProc);
            }
        } else {
            if (SubclassProc_UpdateUIState == null) {
                SubclassProc_UpdateUIState = new Callback(class$org$eclipse$swt$browser$MozillaDelegate == null ? (class$org$eclipse$swt$browser$MozillaDelegate = MozillaDelegate.class$("org.eclipse.swt.browser.MozillaDelegate")) : class$org$eclipse$swt$browser$MozillaDelegate, "windowProc1", 4);
            }
            OS.SetWindowLongPtr(l, -4, SubclassProc_UpdateUIState.getAddress());
        }
    }

    boolean sendTraverse() {
        return false;
    }

    void setSize(long l, int n, int n2) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

