/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.ATSFontMetrics;
import org.eclipse.swt.internal.carbon.ATSTrapezoid;
import org.eclipse.swt.internal.carbon.ATSUTab;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.CGSize;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;

public final class GC
extends Resource {
    public int handle;
    Drawable drawable;
    GCData data;
    static final int TAB_COUNT = 32;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_CAP = 16;
    static final int LINE_JOIN = 32;
    static final int LINE_WIDTH = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int FOREGROUND_FILL = 256;
    static final int DRAW_OFFSET = 512;
    static final int DRAW = 761;
    static final int FILL = 2;
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int n) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData gCData = new GCData();
        gCData.style = GC.checkStyle(n);
        int n2 = drawable.internal_new_GC(gCData);
        Device device = gCData.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = gCData.device = device;
        this.init(drawable, gCData, n2);
        this.init();
    }

    static int checkStyle(int n) {
        if ((n & 0x2000000) != 0) {
            n &= 0xFBFFFFFF;
        }
        return n & 0x6000000;
    }

    public static GC carbon_new(Drawable drawable, GCData gCData) {
        GC gC = new GC();
        int n = drawable.internal_new_GC(gCData);
        gC.device = gCData.device;
        gC.init(drawable, gCData, n);
        return gC;
    }

    public static GC carbon_new(int n, GCData gCData) {
        GC gC = new GC();
        gC.device = gCData.device;
        gC.init(null, gCData, n);
        return gC;
    }

    void checkGC(int n) {
        int n2;
        Object object;
        int n3 = this.data.state;
        if ((n3 & n) == n) {
            return;
        }
        n3 = (n3 ^ n) & n;
        this.data.state |= n;
        if ((n3 & 1) != 0) {
            object = this.data.foregroundPattern;
            if (object != null) {
                n2 = OS.CGColorSpaceCreatePattern(this.data.device.colorspace);
                OS.CGContextSetStrokeColorSpace(this.handle, n2);
                OS.CGColorSpaceRelease(n2);
                if (this.data.forePattern == 0) {
                    this.data.forePattern = ((Pattern)object).createPattern(this.handle);
                }
                OS.CGContextSetStrokePattern(this.handle, this.data.forePattern, this.data.foreground);
            } else {
                OS.CGContextSetStrokeColorSpace(this.handle, this.data.device.colorspace);
                OS.CGContextSetStrokeColor(this.handle, this.data.foreground);
            }
        }
        if ((n3 & 0x100) != 0) {
            object = this.data.foregroundPattern;
            if (object != null) {
                n2 = OS.CGColorSpaceCreatePattern(this.data.device.colorspace);
                OS.CGContextSetFillColorSpace(this.handle, n2);
                OS.CGColorSpaceRelease(n2);
                if (this.data.forePattern == 0) {
                    this.data.forePattern = ((Pattern)object).createPattern(this.handle);
                }
                OS.CGContextSetFillPattern(this.handle, this.data.forePattern, this.data.foreground);
            } else {
                OS.CGContextSetFillColorSpace(this.handle, this.data.device.colorspace);
                OS.CGContextSetFillColor(this.handle, this.data.foreground);
            }
            this.data.state &= 0xFFFFFFFD;
        }
        if ((n3 & 2) != 0) {
            object = this.data.backgroundPattern;
            if (object != null) {
                n2 = OS.CGColorSpaceCreatePattern(this.data.device.colorspace);
                OS.CGContextSetFillColorSpace(this.handle, n2);
                OS.CGColorSpaceRelease(n2);
                if (this.data.backPattern == 0) {
                    this.data.backPattern = ((Pattern)object).createPattern(this.handle);
                }
                OS.CGContextSetFillPattern(this.handle, this.data.backPattern, this.data.background);
            } else {
                OS.CGContextSetFillColorSpace(this.handle, this.data.device.colorspace);
                OS.CGContextSetFillColor(this.handle, this.data.background);
            }
            this.data.state &= 0xFFFFFEFF;
        }
        if ((n3 & 4) != 0) {
            this.setCGFont();
        }
        if ((n3 & 0x40) != 0) {
            OS.CGContextSetLineWidth(this.handle, this.data.lineWidth == 0.0f ? 1.0f : this.data.lineWidth);
            switch (this.data.lineStyle) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n3 |= 8;
                }
            }
        }
        if ((n3 & 8) != 0) {
            object = null;
            float f = this.data.lineWidth;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    object = f != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    object = f != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    object = f != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    object = f != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    object = this.data.lineDashes;
                }
            }
            if (object != null) {
                float[] fArray = new float[((Object)object).length];
                int n4 = 0;
                while (n4 < fArray.length) {
                    fArray[n4] = (float)(f == 0.0f || this.data.lineStyle == 6 ? object[n4] : object[n4] * f);
                    ++n4;
                }
                OS.CGContextSetLineDash(this.handle, this.data.lineDashesOffset, fArray, fArray.length);
            } else {
                OS.CGContextSetLineDash(this.handle, 0.0f, null, 0);
            }
        }
        if ((n3 & 0x80) != 0) {
            OS.CGContextSetMiterLimit(this.handle, this.data.lineMiterLimit);
        }
        if ((n3 & 0x20) != 0) {
            int n5 = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    n5 = 0;
                    break;
                }
                case 2: {
                    n5 = 1;
                    break;
                }
                case 3: {
                    n5 = 2;
                }
            }
            OS.CGContextSetLineJoin(this.handle, n5);
        }
        if ((n3 & 0x10) != 0) {
            int n6 = 0;
            switch (this.data.lineCap) {
                case 2: {
                    n6 = 1;
                    break;
                }
                case 1: {
                    n6 = 0;
                    break;
                }
                case 3: {
                    n6 = 2;
                }
            }
            OS.CGContextSetLineCap(this.handle, n6);
        }
        if ((n3 & 0x200) != 0) {
            float f;
            float f2;
            this.data.drawYOffset = 0.0f;
            this.data.drawXOffset = 0.0f;
            CGSize cGSize = new CGSize();
            cGSize.height = 1.0f;
            cGSize.width = 1.0f;
            if (this.data.transform != null) {
                OS.CGSizeApplyAffineTransform(cGSize, this.data.transform, cGSize);
            }
            if ((f2 = cGSize.width) < 0.0f) {
                f2 = -f2;
            }
            if ((f = this.data.lineWidth * f2) == 0.0f || (int)f % 2 == 1) {
                this.data.drawXOffset = 0.5f / f2;
            }
            if ((f2 = cGSize.height) < 0.0f) {
                f2 = -f2;
            }
            if ((f = this.data.lineWidth * f2) == 0.0f || (int)f % 2 == 1) {
                this.data.drawYOffset = 0.5f / f2;
            }
        }
    }

    int convertRgn(int n, float[] fArray) {
        int n2 = OS.NewRgn();
        Callback callback = new Callback(this, "convertRgn", 4);
        int n3 = callback.getAddress();
        if (n3 == 0) {
            SWT.error(3);
        }
        float[] fArray2 = this.data.clippingTransform;
        this.data.clippingTransform = fArray;
        OS.QDRegionToRects(n, 5, n3, n2);
        this.data.clippingTransform = fArray2;
        callback.dispose();
        return n2;
    }

    int convertRgn(int n, int n2, int n3, int n4) {
        if (n == 2) {
            Rect rect = new Rect();
            OS.memmove(rect, n3, 8);
            CGPoint cGPoint = new CGPoint();
            int n5 = OS.NewRgn();
            OS.OpenRgn();
            cGPoint.x = rect.left;
            cGPoint.y = rect.top;
            float[] fArray = this.data.clippingTransform;
            OS.CGPointApplyAffineTransform(cGPoint, fArray, cGPoint);
            short s = (short)cGPoint.x;
            short s2 = (short)cGPoint.y;
            OS.MoveTo(s, s2);
            cGPoint.x = rect.right;
            cGPoint.y = rect.top;
            OS.CGPointApplyAffineTransform(cGPoint, fArray, cGPoint);
            OS.LineTo((short)Math.round(cGPoint.x), (short)cGPoint.y);
            cGPoint.x = rect.right;
            cGPoint.y = rect.bottom;
            OS.CGPointApplyAffineTransform(cGPoint, fArray, cGPoint);
            OS.LineTo((short)Math.round(cGPoint.x), (short)Math.round(cGPoint.y));
            cGPoint.x = rect.left;
            cGPoint.y = rect.bottom;
            OS.CGPointApplyAffineTransform(cGPoint, fArray, cGPoint);
            OS.LineTo((short)cGPoint.x, (short)Math.round(cGPoint.y));
            OS.LineTo(s, s2);
            OS.CloseRgn(n5);
            OS.UnionRgn(n4, n5, n4);
            OS.DisposeRgn(n5);
        }
        return 0;
    }

    public void copyArea(Image image, int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.image != null) {
            this.copyArea(image, n, n2, this.data.image.handle);
        } else if (this.data.control != 0) {
            int n3 = image.handle;
            int n4 = OS.CGImageGetWidth(n3);
            int n5 = OS.CGImageGetHeight(n3);
            int n6 = OS.GetControlOwner(this.data.control);
            Rect rect = new Rect();
            CGPoint cGPoint = new CGPoint();
            int[] nArray = new int[1];
            OS.HIViewFindByID(OS.HIViewGetRoot(n6), OS.kHIViewWindowContentID(), nArray);
            OS.HIViewConvertPoint(cGPoint, this.data.control, nArray[0]);
            n += (int)cGPoint.x;
            n2 += (int)cGPoint.y;
            Rect rect2 = this.data.insetRect;
            rect.left = (short)(n -= rect2.left);
            rect.top = (short)(n2 -= rect2.top);
            rect.right = (short)(n + n4);
            rect.bottom = (short)(n2 + n5);
            Rect rect3 = new Rect();
            rect3.right = (short)n4;
            rect3.bottom = (short)n5;
            int n7 = n4 * 4;
            int[] nArray2 = new int[1];
            int n8 = OS.GetWindowPort(n6);
            OS.NewGWorldFromPtr(nArray2, 32, rect3, 0, 0, 0, image.data, n7);
            OS.CopyBits(OS.GetPortBitMapForCopyBits(n8), OS.GetPortBitMapForCopyBits(nArray2[0]), rect, rect3, (short)0, 0);
            OS.DisposeGWorld(nArray2[0]);
        } else if (this.data.window != 0) {
            int n9 = image.handle;
            CGRect cGRect = new CGRect();
            cGRect.x = n;
            cGRect.y = n2;
            cGRect.width = OS.CGImageGetWidth(n9);
            cGRect.height = OS.CGImageGetHeight(n9);
            int[] nArray = new int[16];
            int[] nArray3 = new int[1];
            if (OS.CGGetDisplaysWithRect(cGRect, nArray.length, nArray, nArray3) != 0) {
                return;
            }
            int n10 = 0;
            while (n10 < nArray3[0]) {
                int n11;
                int n12 = nArray[n10];
                OS.CGDisplayBounds(n12, cGRect);
                int n13 = 0;
                int n14 = n11 = OS.VERSION >= 4208 ? 0 : OS.CGDisplayBaseAddress(n12);
                if (n11 != 0) {
                    int n15;
                    int n16 = OS.CGDisplayPixelsWide(n12);
                    int n17 = OS.CGDisplayPixelsHigh(n12);
                    int n18 = OS.CGDisplayBytesPerRow(n12);
                    int n19 = OS.CGDisplayBitsPerPixel(n12);
                    int n20 = OS.CGDisplayBitsPerSample(n12);
                    int n21 = 6;
                    switch (n19) {
                        case 16: {
                            n21 |= OS.kCGBitmapByteOrder16Host;
                            break;
                        }
                        case 32: {
                            n21 |= OS.kCGBitmapByteOrder32Host;
                        }
                    }
                    if (OS.__BIG_ENDIAN__() && OS.VERSION >= 4160) {
                        n15 = OS.CGBitmapContextCreate(n11, n16, n17, n20, n18, this.data.device.colorspace, n21);
                        n13 = OS.CGBitmapContextCreateImage(n15);
                        OS.CGContextRelease(n15);
                    } else {
                        n15 = OS.CGDataProviderCreateWithData(0, n11, n18 * n17, 0);
                        n13 = OS.CGImageCreate(n16, n17, n20, n19, n18, this.data.device.colorspace, n21, n15, null, true, 0);
                        OS.CGDataProviderRelease(n15);
                    }
                } else if (OS.VERSION >= 4192) {
                    n13 = OS.CGDisplayCreateImage(n12);
                }
                if (n13 != 0) {
                    this.copyArea(image, n - (int)cGRect.x, n2 - (int)cGRect.y, n13);
                    if (n13 != 0) {
                        OS.CGImageRelease(n13);
                    }
                }
                ++n10;
            }
        }
    }

    void copyArea(Image image, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (n3 == 0) {
            return;
        }
        int n7 = image.handle;
        int n8 = OS.CGImageGetBitsPerComponent(n7);
        int n9 = OS.CGImageGetWidth(n7);
        int n10 = OS.CGBitmapContextCreate(image.data, n9, n6 = OS.CGImageGetHeight(n7), n8, n5 = OS.CGImageGetBytesPerRow(n7), this.data.device.colorspace, n4 = OS.CGImageGetAlphaInfo(n7));
        if (n10 != 0) {
            CGRect cGRect = new CGRect();
            cGRect.x = -n;
            cGRect.y = n2;
            cGRect.width = OS.CGImageGetWidth(n3);
            cGRect.height = OS.CGImageGetHeight(n3);
            OS.CGContextTranslateCTM(n10, 0.0f, -(cGRect.height - (float)n6));
            OS.CGContextDrawImage(n10, cGRect, n3);
            OS.CGContextRelease(n10);
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyArea(n, n2, n3, n4, n5, n6, true);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n7 = n5 - n;
        int n8 = n6 - n2;
        if (n7 == 0 && n8 == 0) {
            return;
        }
        if (this.data.image != null) {
            OS.CGContextSaveGState(this.handle);
            OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
            OS.CGContextTranslateCTM(this.handle, 0.0f, -(n4 + 2 * n6));
            CGRect cGRect = new CGRect();
            cGRect.x = n5;
            cGRect.y = n6;
            cGRect.width = n3;
            cGRect.height = n4;
            int n9 = OS.CGImageGetHeight(this.data.image.handle);
            int n10 = OS.CGImageGetBytesPerRow(this.data.image.handle);
            int n11 = OS.CGDataProviderCreateWithData(0, this.data.image.data, n10 * n9, 0);
            if (n11 != 0) {
                int n12 = this.device.colorspace;
                int n13 = OS.CGImageCreate(n3, n4, 8, 32, n10, n12, 6, n11, null, true, 0);
                OS.CGDataProviderRelease(n11);
                OS.CGContextDrawImage(this.handle, cGRect, n13);
                OS.CGImageRelease(n13);
            }
            OS.CGContextRestoreGState(this.handle);
            return;
        }
        if (this.data.control != 0) {
            int n14;
            int n15 = this.data.port;
            int n16 = OS.GetControlOwner(this.data.control);
            if (n15 == 0) {
                n15 = OS.GetWindowPort(n16);
            }
            Rect rect = new Rect();
            OS.GetControlBounds(this.data.control, rect);
            int n17 = 0;
            int n18 = 0;
            CGPoint cGPoint = new CGPoint();
            int[] nArray = new int[1];
            OS.HIViewFindByID(OS.HIViewGetRoot(n16), OS.kHIViewWindowContentID(), nArray);
            OS.HIViewConvertPoint(cGPoint, OS.HIViewGetSuperview(this.data.control), nArray[0]);
            n17 = rect.left + (int)cGPoint.x;
            n18 = rect.top + (int)cGPoint.y;
            rect.left = (short)(rect.left + (int)cGPoint.x);
            rect.top = (short)(rect.top + (int)cGPoint.y);
            rect.right = (short)(rect.right + (int)cGPoint.x);
            rect.bottom = (short)(rect.bottom + (int)cGPoint.y);
            Rect rect2 = new Rect();
            int n19 = rect.left + n;
            int n20 = rect.top + n2;
            OS.SetRect(rect2, (short)n19, (short)n20, (short)(n19 + n3), (short)(n20 + n4));
            int n21 = OS.NewRgn();
            OS.RectRgn(n21, rect2);
            OS.SectRect(rect, rect2, rect2);
            Rect rect3 = new Rect();
            OS.SetRect(rect3, rect2.left, rect2.top, rect2.right, rect2.bottom);
            OS.OffsetRect(rect3, (short)n7, (short)n8);
            int n22 = OS.NewRgn();
            OS.RectRgn(n22, rect3);
            if (!OS.EmptyRect(rect2) && (this.data.visibleRgn == 0 || OS.RectInRgn(rect2, this.data.visibleRgn))) {
                n14 = this.data.visibleRgn;
                if (this.data.clipRgn != 0) {
                    n14 = OS.NewRgn();
                    OS.SectRgn(this.data.clipRgn, this.data.visibleRgn, n14);
                }
                if (!OS.EmptyRgn(n14)) {
                    boolean bl2;
                    boolean bl3 = bl2 = n5 + n3 < n || n + n3 < n5 || n6 + n4 < n2 || n2 + n4 < n6;
                    if (!(bl2 || n7 != 0 && n8 != 0)) {
                        int[] nArray2 = new int[1];
                        OS.GetPort(nArray2);
                        OS.SetPort(n15);
                        int n23 = OS.NewRgn();
                        OS.GetClip(n23);
                        OS.SetClip(n14);
                        OS.UnionRect(rect2, rect3, rect);
                        OS.ScrollRect(rect, (short)n7, (short)n8, 0);
                        OS.SetClip(n23);
                        OS.DisposeRgn(n23);
                        OS.SetPort(nArray2[0]);
                    } else {
                        int n24 = OS.GetPortBitMapForCopyBits(n15);
                        OS.CopyBits(n24, n24, rect2, rect3, (short)0, n14);
                        OS.QDFlushPortBuffer(n15, n22);
                    }
                }
                if (n14 != this.data.visibleRgn) {
                    OS.DisposeRgn(n14);
                }
            }
            if (bl) {
                n14 = OS.NewRgn();
                OS.DiffRgn(n21, this.data.visibleRgn, n14);
                OS.OffsetRgn(n14, (short)n7, (short)n8);
                OS.DiffRgn(n21, n22, n21);
                OS.UnionRgn(n21, n14, n14);
                OS.SectRgn(this.data.visibleRgn, n14, n14);
                OS.OffsetRgn(n14, (short)(-n17), (short)(-n18));
                OS.HIViewSetNeedsDisplayInRegion(this.data.control, n14, true);
                OS.DisposeRgn(n14);
            }
            OS.DisposeRgn(n22);
            OS.DisposeRgn(n21);
        }
    }

    void createLayout() {
        int[] nArray = new int[1];
        OS.ATSUCreateTextLayout(nArray);
        if (nArray[0] == 0) {
            SWT.error(2);
        }
        this.data.layout = nArray[0];
        int n = OS.NewPtr(4);
        nArray[0] = this.handle;
        OS.memmove(n, nArray, 4);
        int n2 = OS.NewPtr(4);
        nArray[0] = 0x1000000;
        OS.memmove(n2, nArray, 4);
        boolean bl = false;
        if ((this.data.style & 0x4000000) != 0) {
            bl = true;
        }
        int n3 = OS.NewPtr(1);
        OS.memmove(n3, new byte[]{(byte)(bl ? 1 : 0)}, 1);
        int[] nArray2 = new int[]{Short.MAX_VALUE, 7, 3};
        int[] nArray3 = new int[]{4, 4, 1};
        int[] nArray4 = new int[]{n, n2, n3};
        OS.ATSUSetLayoutControls(this.data.layout, nArray2.length, nArray2, nArray3, nArray4);
        OS.DisposePtr(n);
        OS.DisposePtr(n2);
        OS.DisposePtr(n3);
    }

    void createTabs() {
        ATSUTab aTSUTab = new ATSUTab();
        int n = this.getCharWidth(' ') * 8;
        int n2 = OS.NewPtr(192);
        int n3 = 0;
        int n4 = n2;
        while (n3 < 32) {
            aTSUTab.tabPosition += OS.Long2Fix(n);
            OS.memmove(n4, aTSUTab, 6);
            ++n3;
            n4 += 6;
        }
        this.data.tabs = n2;
    }

    void destroy() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Image image;
        int n7 = this.data.clipRgn;
        if (n7 != 0) {
            OS.DisposeRgn(n7);
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
            image.createAlpha();
        }
        if ((n6 = this.data.layout) != 0) {
            OS.ATSUDisposeTextLayout(n6);
        }
        if ((n5 = this.data.atsuiStyle) != 0) {
            OS.ATSUDisposeStyle(n5);
        }
        if ((n4 = this.data.stringPtr) != 0) {
            OS.DisposePtr(n4);
        }
        if ((n3 = this.data.tabs) != 0) {
            OS.DisposePtr(n3);
        }
        if ((n2 = this.data.forePattern) != 0) {
            OS.CGPatternRelease(n2);
        }
        if ((n = this.data.backPattern) != 0) {
            OS.CGPatternRelease(n);
        }
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle, this.data);
        }
        this.data.backPattern = 0;
        this.data.forePattern = 0;
        this.data.tabs = 0;
        this.data.layout = 0;
        this.data.stringPtr = 0;
        this.data.atsuiStyle = 0;
        this.data.clipRgn = 0;
        this.drawable = null;
        this.data.image = null;
        this.data.string = null;
        this.data = null;
        this.handle = 0;
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        float f = this.data.drawXOffset;
        float f2 = this.data.drawYOffset;
        OS.CGContextTranslateCTM(this.handle, (float)n + f + (float)n3 / 2.0f, (float)n2 + f2 + (float)n4 / 2.0f);
        OS.CGContextScaleCTM(this.handle, (float)n3 / 2.0f, (float)n4 / 2.0f);
        if (n6 < 0) {
            OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, true);
        } else {
            OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f, true);
        }
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawFocus(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        int[] nArray = new int[1];
        OS.GetThemeMetric(7, nArray);
        CGRect cGRect = new CGRect();
        cGRect.x = n + nArray[0];
        cGRect.y = n2 + nArray[0];
        cGRect.width = n3 - nArray[0] * 2;
        cGRect.height = n4 - nArray[0] * 2;
        OS.HIThemeDrawFocusRect(cGRect, true, this.handle, 0);
        this.flush();
    }

    public void drawImage(Image image, int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, n, n2, -1, -1, true);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0 || n7 == 0 || n8 == 0) {
            return;
        }
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n7 < 0 || n8 < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, false);
    }

    void drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        int n9 = image.handle;
        int n10 = OS.CGImageGetWidth(n9);
        int n11 = OS.CGImageGetHeight(n9);
        if (bl) {
            n3 = n7 = n10;
            n4 = n8 = n11;
        } else {
            boolean bl2 = bl = n == 0 && n2 == 0 && n3 == n7 && n7 == n10 && n4 == n8 && n8 == n11;
            if (n + n3 > n10 || n2 + n4 > n11) {
                SWT.error(5);
            }
        }
        if (image.memGC != null) {
            image.createAlpha();
        }
        OS.CGContextSaveGState(this.handle);
        OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
        OS.CGContextTranslateCTM(this.handle, 0.0f, -(n8 + 2 * n6));
        CGRect cGRect = new CGRect();
        cGRect.x = n5;
        cGRect.y = n6;
        cGRect.width = n7;
        cGRect.height = n8;
        if (bl) {
            OS.CGContextDrawImage(this.handle, cGRect, n9);
        } else if (OS.VERSION >= 4160) {
            CGRect cGRect2 = new CGRect();
            cGRect2.x = n;
            cGRect2.y = n2;
            cGRect2.width = n3;
            cGRect2.height = n4;
            int n12 = OS.CGImageCreateWithImageInRect(n9, cGRect2);
            if (n12 != 0) {
                OS.CGContextDrawImage(this.handle, cGRect, n12);
                OS.CGImageRelease(n12);
            }
        } else {
            int n13 = OS.CGImageGetBitsPerComponent(n9);
            int n14 = OS.CGImageGetBitsPerPixel(n9);
            int n15 = OS.CGImageGetBytesPerRow(n9);
            int n16 = OS.CGImageGetColorSpace(n9);
            int n17 = OS.CGImageGetAlphaInfo(n9);
            int n18 = image.data + n2 * n15 + n * 4;
            int n19 = OS.CGDataProviderCreateWithData(0, n18, n4 * n15, 0);
            if (n19 != 0) {
                int n20 = OS.CGImageCreate(n3, n4, n13, n14, n15, n16, n17, n19, null, true, 0);
                OS.CGDataProviderRelease(n19);
                if (n20 != 0) {
                    OS.CGContextDrawImage(this.handle, cGRect, n20);
                    OS.CGImageRelease(n20);
                }
            }
        }
        OS.CGContextRestoreGState(this.handle);
        this.flush();
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (n == n3 && n2 == n4 && this.data.lineWidth <= 1.0f) {
            this.drawPoint(n, n2);
            return;
        }
        OS.CGContextBeginPath(this.handle);
        float f = this.data.drawXOffset;
        float f2 = this.data.drawYOffset;
        OS.CGContextMoveToPoint(this.handle, (float)n + f, (float)n2 + f2);
        OS.CGContextAddLineToPoint(this.handle, (float)n3 + f, (float)n4 + f2);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        float f = this.data.drawXOffset;
        float f2 = this.data.drawYOffset;
        OS.CGContextTranslateCTM(this.handle, (float)n + f + (float)n3 / 2.0f, (float)n2 + f2 + (float)n4 / 2.0f);
        OS.CGContextScaleCTM(this.handle, (float)n3 / 2.0f, (float)n4 / 2.0f);
        OS.CGContextMoveToPoint(this.handle, 1.0f, 0.0f);
        OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, 0.0f, (float)(2.0 * Compatibility.PI), true);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        float f = this.data.drawXOffset;
        float f2 = this.data.drawYOffset;
        OS.CGContextTranslateCTM(this.handle, f, f2);
        OS.CGContextAddPath(this.handle, path.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawPoint(int n, int n2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(256);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        CGRect cGRect = new CGRect();
        cGRect.x = n;
        cGRect.y = n2;
        cGRect.width = 1.0f;
        cGRect.height = 1.0f;
        OS.CGContextFillRect(this.handle, cGRect);
        this.flush();
    }

    public void drawPolygon(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        float f = this.data.drawXOffset;
        float f2 = this.data.drawYOffset;
        float[] fArray = new float[nArray.length / 2 * 2];
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = (float)nArray[n] + f;
            fArray[n + 1] = (float)nArray[n + 1] + f2;
            n += 2;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextAddLines(this.handle, fArray, fArray.length / 2);
        OS.CGContextClosePath(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawPolyline(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        float f = this.data.drawXOffset;
        float f2 = this.data.drawYOffset;
        float[] fArray = new float[nArray.length / 2 * 2];
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = (float)nArray[n] + f;
            fArray[n + 1] = (float)nArray[n + 1] + f2;
            n += 2;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextAddLines(this.handle, fArray, fArray.length / 2);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawRectangle(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        CGRect cGRect = new CGRect();
        float f = this.data.drawXOffset;
        float f2 = this.data.drawYOffset;
        cGRect.x = (float)n + f;
        cGRect.y = (float)n2 + f2;
        cGRect.width = n3;
        cGRect.height = n4;
        OS.CGContextStrokeRect(this.handle, cGRect);
        this.flush();
    }

    public void drawRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            SWT.error(4);
        }
        this.drawRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void drawRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(761);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (n5 == 0 || n6 == 0) {
            this.drawRectangle(n, n2, n3, n4);
            return;
        }
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        if (n9 < 0) {
            n9 = 0 - n9;
            n7 -= n9;
        }
        if (n10 < 0) {
            n10 = 0 - n10;
            n8 -= n10;
        }
        if (n11 < 0) {
            n11 = 0 - n11;
        }
        if (n12 < 0) {
            n12 = 0 - n12;
        }
        if (n11 > n9) {
            n11 = n9;
        }
        if (n12 > n10) {
            n12 = n10;
        }
        float f = (float)n11 / 2.0f;
        float f2 = (float)n12 / 2.0f;
        float f3 = (float)n9 / f;
        float f4 = (float)n10 / f2;
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        float f5 = this.data.drawXOffset;
        float f6 = this.data.drawYOffset;
        OS.CGContextTranslateCTM(this.handle, (float)n7 + f5, (float)n8 + f6);
        OS.CGContextScaleCTM(this.handle, f, f2);
        OS.CGContextMoveToPoint(this.handle, f3 - 1.0f, 0.0f);
        OS.CGContextAddArcToPoint(this.handle, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, 0.0f, f4, 1.0f, f4, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, f3, f4, f3, f4 - 1.0f, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, f3, 0.0f, f3 - 1.0f, 0.0f, 1.0f);
        OS.CGContextClosePath(this.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextStrokePath(this.handle);
        this.flush();
    }

    public void drawString(String string, int n, int n2) {
        this.drawString(string, n, n2, false);
    }

    public void drawString(String string, int n, int n2, boolean bl) {
        this.drawText(string, n, n2, bl ? 1 : 0);
    }

    public void drawText(String string, int n, int n2) {
        this.drawText(string, n, n2, 6);
    }

    public void drawText(String string, int n, int n2, boolean bl) {
        int n3 = 6;
        if (bl) {
            n3 |= 1;
        }
        this.drawText(string, n, n2, n3);
    }

    public void drawText(String string, int n, int n2, int n3) {
        int n4;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.checkGC(260);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if ((n4 = string.length()) == 0) {
            return;
        }
        OS.CGContextSaveGState(this.handle);
        OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
        boolean bl = true;
        switch (this.data.textAntialias) {
            case -1: {
                if (this.data.window != 0 || this.data.control != 0 || this.data.image != null) break;
                bl = false;
                break;
            }
            case 0: {
                bl = false;
            }
        }
        OS.CGContextSetShouldAntialias(this.handle, bl);
        n4 = this.setString(string, n3);
        if ((n3 & 2) != 0) {
            int n5 = this.data.layout;
            int[] nArray = new int[1];
            OS.ATSUGetSoftLineBreaks(n5, 0, n4, 0, null, nArray);
            int[] nArray2 = new int[nArray[0] + 1];
            OS.ATSUGetSoftLineBreaks(n5, 0, n4, nArray[0], nArray2, nArray);
            nArray2[nArray[0]] = n4;
            int n6 = 0;
            int n7 = 0;
            while (n6 < nArray2.length) {
                int n8 = nArray2[n6];
                this.drawText(n, n2, n7, n8 - n7, n3);
                n2 += this.data.fontAscent + this.data.fontDescent;
                n7 = n8;
                ++n6;
            }
        } else {
            this.drawText(n, n2, 0, n4, n3);
        }
        OS.CGContextRestoreGState(this.handle);
        this.flush();
    }

    void drawText(int n, int n2, int n3, int n4, int n5) {
        int n6 = this.data.layout;
        if ((n5 & 1) == 0) {
            ATSTrapezoid aTSTrapezoid = new ATSTrapezoid();
            OS.ATSUGetGlyphBounds(n6, 0, 0, n3, n4, (short)1, 1, aTSTrapezoid, null);
            int n7 = OS.Fix2Long(aTSTrapezoid.lowerRight_x) - OS.Fix2Long(aTSTrapezoid.lowerLeft_x);
            int n8 = OS.Fix2Long(aTSTrapezoid.lowerRight_y) - OS.Fix2Long(aTSTrapezoid.upperRight_y);
            CGRect cGRect = new CGRect();
            cGRect.x = n;
            cGRect.y = -(n2 + n8);
            cGRect.width = n7;
            cGRect.height = n8;
            OS.CGContextSaveGState(this.handle);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                int n9 = OS.CGColorSpaceCreatePattern(this.data.device.colorspace);
                OS.CGContextSetFillColorSpace(this.handle, n9);
                OS.CGColorSpaceRelease(n9);
                if (this.data.backPattern == 0) {
                    this.data.backPattern = pattern.createPattern(this.handle);
                }
                OS.CGContextSetFillPattern(this.handle, this.data.backPattern, this.data.background);
            } else {
                OS.CGContextSetFillColorSpace(this.handle, this.data.device.colorspace);
                OS.CGContextSetFillColor(this.handle, this.data.background);
            }
            OS.CGContextFillRect(this.handle, cGRect);
            OS.CGContextRestoreGState(this.handle);
        }
        OS.ATSUDrawText(n6, n3, n4, OS.Long2Fix(n), OS.Long2Fix(-(n2 + this.data.fontAscent)));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n3 == 0 || n4 == 0 || n6 == 0) {
            return;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        OS.CGContextTranslateCTM(this.handle, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
        OS.CGContextScaleCTM(this.handle, (float)n3 / 2.0f, (float)n4 / 2.0f);
        OS.CGContextMoveToPoint(this.handle, 0.0f, 0.0f);
        if (n6 < 0) {
            OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, true);
        } else {
            OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, (float)(-n5) * (float)Compatibility.PI / 180.0f, (float)(-(n5 + n6)) * (float)Compatibility.PI / 180.0f, true);
        }
        OS.CGContextClosePath(this.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextFillPath(this.handle);
        this.flush();
    }

    public void fillGradientRectangle(int n, int n2, int n3, int n4, boolean bl) {
        RGB rGB;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 == 0 || n4 == 0) {
            return;
        }
        RGB rGB2 = this.getBackground().getRGB();
        RGB rGB3 = rGB = this.getForeground().getRGB();
        RGB rGB4 = rGB2;
        boolean bl2 = false;
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
            if (!bl) {
                bl2 = true;
            }
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
            if (bl) {
                bl2 = true;
            }
        }
        if (bl2) {
            rGB3 = rGB2;
            rGB4 = rGB;
        }
        if (rGB3.equals(rGB4)) {
            this.fillRectangle(n, n2, n3, n4);
            return;
        }
        ImageData.fillGradientRectangle(this, this.data.device, n, n2, n3, n4, bl, rGB3, rGB4, 8, 8, 8);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        OS.CGContextTranslateCTM(this.handle, (float)n + (float)n3 / 2.0f, (float)n2 + (float)n4 / 2.0f);
        OS.CGContextScaleCTM(this.handle, (float)n3 / 2.0f, (float)n4 / 2.0f);
        OS.CGContextMoveToPoint(this.handle, 1.0f, 0.0f);
        OS.CGContextAddArc(this.handle, 0.0f, 0.0f, 1.0f, 0.0f, (float)(Compatibility.PI * 2.0), false);
        OS.CGContextClosePath(this.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextFillPath(this.handle);
        this.flush();
    }

    public void fillPath(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == 0) {
            SWT.error(5);
        }
        this.checkGC(2);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextAddPath(this.handle, path.handle);
        if (this.data.fillRule == 2) {
            OS.CGContextFillPath(this.handle);
        } else {
            OS.CGContextEOFillPath(this.handle);
        }
        this.flush();
    }

    public void fillPolygon(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (nArray == null) {
            SWT.error(4);
        }
        this.checkGC(2);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        float[] fArray = new float[nArray.length];
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = nArray[n];
            ++n;
        }
        OS.CGContextBeginPath(this.handle);
        OS.CGContextAddLines(this.handle, fArray, fArray.length / 2);
        OS.CGContextClosePath(this.handle);
        if (this.data.fillRule == 2) {
            OS.CGContextFillPath(this.handle);
        } else {
            OS.CGContextEOFillPath(this.handle);
        }
        this.flush();
    }

    public void fillRectangle(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        CGRect cGRect = new CGRect();
        cGRect.x = n;
        cGRect.y = n2;
        cGRect.width = n3;
        cGRect.height = n4;
        Pattern pattern = this.data.backgroundPattern;
        if (pattern != null) {
            pattern.drawRect = cGRect;
        }
        OS.CGContextFillRect(this.handle, cGRect);
        if (pattern != null) {
            pattern.drawRect = null;
        }
        this.flush();
    }

    public void fillRectangle(Rectangle rectangle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rectangle == null) {
            SWT.error(4);
        }
        this.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void fillRoundRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(2);
        if (this.data.updateClip) {
            this.setCGClipping();
        }
        if (n5 == 0 || n6 == 0) {
            this.fillRectangle(n, n2, n3, n4);
            return;
        }
        int n7 = n;
        int n8 = n2;
        int n9 = n3;
        int n10 = n4;
        int n11 = n5;
        int n12 = n6;
        if (n9 < 0) {
            n9 = 0 - n9;
            n7 -= n9;
        }
        if (n10 < 0) {
            n10 = 0 - n10;
            n8 -= n10;
        }
        if (n11 < 0) {
            n11 = 0 - n11;
        }
        if (n12 < 0) {
            n12 = 0 - n12;
        }
        if (n11 > n9) {
            n11 = n9;
        }
        if (n12 > n10) {
            n12 = n10;
        }
        float f = (float)n11 / 2.0f;
        float f2 = (float)n12 / 2.0f;
        float f3 = (float)n9 / f;
        float f4 = (float)n10 / f2;
        OS.CGContextBeginPath(this.handle);
        OS.CGContextSaveGState(this.handle);
        OS.CGContextTranslateCTM(this.handle, n7, n8);
        OS.CGContextScaleCTM(this.handle, f, f2);
        OS.CGContextMoveToPoint(this.handle, f3 - 1.0f, 0.0f);
        OS.CGContextAddArcToPoint(this.handle, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, 0.0f, f4, 1.0f, f4, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, f3, f4, f3, f4 - 1.0f, 1.0f);
        OS.CGContextAddArcToPoint(this.handle, f3, 0.0f, f3 - 1.0f, 0.0f, 1.0f);
        OS.CGContextClosePath(this.handle);
        OS.CGContextRestoreGState(this.handle);
        OS.CGContextFillPath(this.handle);
        this.flush();
    }

    void flush() {
        if (this.data.control != 0 && this.data.paintEvent == 0) {
            if (this.data.thread != Thread.currentThread()) {
                OS.CGContextFlush(this.handle);
            } else {
                OS.CGContextSynchronize(this.handle);
            }
        }
        if (this.data.control == 0 && this.data.window != 0) {
            OS.CGContextSynchronize(this.handle);
        }
    }

    public int getAdvanceWidth(char c) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{c})).x;
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Color.carbon_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return this.data.backgroundPattern;
    }

    public boolean getAdvanced() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return true;
    }

    public int getAlpha() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.antialias;
    }

    public int getCharWidth(char c) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{c})).x;
    }

    public Rectangle getClipping() {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        Rect rect = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.data.control != 0) {
            if (rect == null) {
                rect = new Rect();
            }
            OS.GetControlBounds(this.data.control, rect);
            n4 = rect.right - rect.left;
            n5 = rect.bottom - rect.top;
        } else if (this.data.image != null) {
            n = this.data.image.handle;
            n4 = OS.CGImageGetWidth(n);
            n5 = OS.CGImageGetHeight(n);
        } else if (this.data.portRect != null) {
            n4 = this.data.portRect.right - this.data.portRect.left;
            n5 = this.data.portRect.bottom - this.data.portRect.top;
        }
        n = this.data.clipRgn;
        int n6 = this.data.visibleRgn;
        if (n != 0 || n6 != 0 || this.data.inverseTransform != null) {
            int n7 = OS.NewRgn();
            OS.SetRectRgn(n7, (short)n2, (short)n3, (short)(n2 + n4), (short)(n3 + n5));
            if (n6 != 0) {
                OS.SectRgn(n7, n6, n7);
            }
            if (n != 0) {
                if (this.data.clippingTransform != null) {
                    n = this.convertRgn(n, this.data.clippingTransform);
                    OS.SectRgn(n7, n, n7);
                    OS.DisposeRgn(n);
                } else {
                    OS.SectRgn(n7, n, n7);
                }
            }
            if (this.data.inverseTransform != null) {
                n = this.convertRgn(n7, this.data.inverseTransform);
                OS.DisposeRgn(n7);
                n7 = n;
            }
            if (rect == null) {
                rect = new Rect();
            }
            OS.GetRegionBounds(n7, rect);
            OS.DisposeRgn(n7);
            n2 = rect.left;
            n3 = rect.top;
            n4 = rect.right - rect.left;
            n5 = rect.bottom - rect.top;
        }
        return new Rectangle(n2, n3, n4, n5);
    }

    public void getClipping(Region region) {
        int n;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        Rect rect = null;
        int n2 = region.handle;
        if (this.data.clipRgn == 0) {
            n = 0;
            int n3 = 0;
            if (this.data.control != 0) {
                if (rect == null) {
                    rect = new Rect();
                }
                OS.GetControlBounds(this.data.control, rect);
                n = rect.right - rect.left;
                n3 = rect.bottom - rect.top;
            } else if (this.data.image != null) {
                int n4 = this.data.image.handle;
                n = OS.CGImageGetWidth(n4);
                n3 = OS.CGImageGetHeight(n4);
            } else if (this.data.portRect != null) {
                n = this.data.portRect.right - this.data.portRect.left;
                n3 = this.data.portRect.bottom - this.data.portRect.top;
            }
            OS.SetRectRgn(n2, (short)0, (short)0, (short)n, (short)n3);
        } else if (this.data.clippingTransform != null) {
            n = this.convertRgn(this.data.clipRgn, this.data.clippingTransform);
            OS.CopyRgn(n, n2);
            OS.DisposeRgn(n);
        } else {
            OS.CopyRgn(this.data.clipRgn, n2);
        }
        if (this.data.paintEvent != 0 && this.data.visibleRgn != 0) {
            if (rect == null) {
                rect = new Rect();
            }
            OS.GetControlBounds(this.data.control, rect);
            if (this.data.paintEvent == 0) {
                OS.OffsetRgn(this.data.visibleRgn, -rect.left, -rect.top);
            }
            OS.SectRgn(this.data.visibleRgn, n2, n2);
            if (this.data.paintEvent == 0) {
                OS.OffsetRgn(this.data.visibleRgn, rect.left, rect.top);
            }
        }
        if (this.data.inverseTransform != null) {
            n = this.convertRgn(n2, this.data.inverseTransform);
            OS.CopyRgn(n, n2);
            OS.DisposeRgn(n);
        }
    }

    public int getFillRule() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.fillRule;
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.checkGC(4);
        Font font = this.data.font;
        ATSFontMetrics aTSFontMetrics = new ATSFontMetrics();
        OS.ATSFontGetVerticalMetrics(font.handle, 0, aTSFontMetrics);
        OS.ATSFontGetHorizontalMetrics(font.handle, 0, aTSFontMetrics);
        int n = (int)(0.5f + aTSFontMetrics.ascent * font.size);
        int n2 = (int)(0.5f + (-aTSFontMetrics.descent + aTSFontMetrics.leading) * font.size);
        String string = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        int n3 = this.stringExtent((String)string).x / string.length();
        return FontMetrics.carbon_new(n, n2, n3, 0, n + n2);
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return Color.carbon_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == 0) {
            SWT.error(24);
        }
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n = OS.CGContextGetInterpolationQuality(this.handle);
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] fArray = null;
        if (this.data.lineDashes != null) {
            fArray = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, fArray, 0, fArray.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, fArray, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] nArray = new int[this.data.lineDashes.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = (int)this.data.lineDashes[n];
            ++n;
        }
        return nArray;
    }

    public int getLineJoin() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.textAntialias;
    }

    public void getTransform(Transform transform) {
        float[] fArray;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((fArray = this.data.transform) != null) {
            transform.setElements(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Drawable drawable, GCData gCData, int n) {
        if (gCData.foreground != null) {
            gCData.state &= 0xFFFFFEFE;
        }
        if (gCData.background != null) {
            gCData.state &= 0xFFFFFFFD;
        }
        if (gCData.font != null) {
            gCData.state &= 0xFFFFFFFB;
        }
        gCData.state &= 0xFFFFFDFF;
        Image image = gCData.image;
        if (image != null) {
            image.memGC = this;
        }
        this.drawable = drawable;
        this.data = gCData;
        this.handle = n;
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return this.data.clipRgn != 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    boolean isIdentity(float[] fArray) {
        return fArray[0] == 1.0f && fArray[1] == 0.0f && fArray[2] == 0.0f && fArray[3] == 1.0f && fArray[4] == 0.0f && fArray[5] == 0.0f;
    }

    public void setAdvanced(boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (!bl) {
            this.setAlpha(255);
            this.setAntialias(-1);
            this.setBackgroundPattern(null);
            this.setClipping(0);
            this.setForegroundPattern(null);
            this.setInterpolation(-1);
            this.setTextAntialias(-1);
            this.setTransform(null);
        }
    }

    public void setAlpha(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.alpha = n & 0xFF;
        OS.CGContextSetAlpha(this.handle, (float)this.data.alpha / 255.0f);
    }

    public void setAntialias(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        boolean bl = true;
        switch (n) {
            case -1: {
                if (this.data.window != 0 || this.data.control != 0 || this.data.image != null) break;
                bl = false;
                break;
            }
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.antialias = n;
        OS.CGContextSetShouldAntialias(this.handle, bl);
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        if (this.data.backPattern != 0) {
            OS.CGPatternRelease(this.data.backPattern);
        }
        this.data.backPattern = 0;
        this.data.backgroundPattern = null;
        this.data.state &= 0xFFFFFFFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        if (this.data.backPattern != 0) {
            OS.CGPatternRelease(this.data.backPattern);
        }
        this.data.backPattern = 0;
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    void setClipping(int n) {
        if (n == 0) {
            if (this.data.clipRgn != 0) {
                OS.DisposeRgn(this.data.clipRgn);
                this.data.clipRgn = 0;
            }
            this.data.clippingTransform = null;
        } else {
            if (this.data.clipRgn == 0) {
                this.data.clipRgn = OS.NewRgn();
            }
            OS.CopyRgn(n, this.data.clipRgn);
            if (this.data.transform != null) {
                if (this.data.clippingTransform == null) {
                    this.data.clippingTransform = new float[6];
                }
                System.arraycopy(this.data.transform, 0, this.data.clippingTransform, 0, this.data.transform.length);
            }
        }
        this.data.updateClip = true;
        this.setCGClipping();
    }

    public void setClipping(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        int n5 = OS.NewRgn();
        OS.SetRectRgn(n5, (short)n, (short)n2, (short)(n + n3), (short)(n2 + n4));
        this.setClipping(n5);
        OS.DisposeRgn(n5);
    }

    public void setClipping(Path path) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(0);
        if (path != null) {
            OS.CGContextAddPath(this.handle, path.handle);
            OS.CGContextEOClip(this.handle);
        }
    }

    public void setClipping(Rectangle rectangle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rectangle == null) {
            this.setClipping(0);
        } else {
            this.setClipping(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        this.setClipping(region != null ? region.handle : 0);
    }

    void setCGClipping() {
        boolean bl;
        this.data.updateClip = false;
        if (this.data.control == 0) {
            if (this.data.window != 0 && !OS.IsWindowVisible(this.data.window)) {
                OS.ShowWindow(this.data.window);
            }
            OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
            if (this.data.clipRgn != 0) {
                OS.ClipCGContextToRegion(this.handle, new Rect(), this.data.clipRgn);
            } else {
                int n = OS.NewRgn();
                OS.SetRectRgn(n, (short)Short.MIN_VALUE, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)Short.MAX_VALUE);
                OS.ClipCGContextToRegion(this.handle, new Rect(), n);
                OS.DisposeRgn(n);
            }
            OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
            return;
        }
        int n = this.data.port;
        int n2 = OS.GetControlOwner(this.data.control);
        if (n == 0) {
            n = OS.GetWindowPort(n2);
        }
        Rect rect = this.data.portRect;
        Rect rect2 = this.data.controlRect;
        OS.CGContextTranslateCTM(this.handle, -rect2.left, rect.bottom - rect.top - rect2.top);
        OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
        OS.GetPortBounds(n, rect);
        OS.GetControlBounds(this.data.control, rect2);
        boolean bl2 = bl = this.data.paintEvent != 0;
        if (bl) {
            rect2.right = (short)(rect2.right + rect2.left);
            rect2.bottom = (short)(rect2.bottom + rect2.top);
            rect2.top = 0;
            rect2.left = 0;
        } else {
            int[] nArray = new int[1];
            OS.HIViewFindByID(OS.HIViewGetRoot(n2), OS.kHIViewWindowContentID(), nArray);
            CGPoint cGPoint = new CGPoint();
            OS.HIViewConvertPoint(cGPoint, OS.HIViewGetSuperview(this.data.control), nArray[0]);
            rect2.left = (short)(rect2.left + (int)cGPoint.x);
            rect2.top = (short)(rect2.top + (int)cGPoint.y);
            rect2.right = (short)(rect2.right + (int)cGPoint.x);
            rect2.bottom = (short)(rect2.bottom + (int)cGPoint.y);
        }
        if (this.data.clipRgn != 0) {
            int n3 = OS.NewRgn();
            OS.CopyRgn(this.data.clipRgn, n3);
            OS.OffsetRgn(n3, rect2.left, rect2.top);
            OS.SectRgn(this.data.visibleRgn, n3, n3);
            OS.ClipCGContextToRegion(this.handle, rect, n3);
            OS.DisposeRgn(n3);
        } else {
            OS.ClipCGContextToRegion(this.handle, rect, this.data.visibleRgn);
        }
        OS.CGContextScaleCTM(this.handle, 1.0f, -1.0f);
        OS.CGContextTranslateCTM(this.handle, rect2.left, -(rect.bottom - rect.top) + rect2.top);
    }

    void setCGFont() {
        int n = this.data.tabs;
        if (n != 0) {
            OS.DisposePtr(n);
        }
        this.data.tabs = 0;
        Font font = this.data.font;
        ATSFontMetrics aTSFontMetrics = new ATSFontMetrics();
        OS.ATSFontGetVerticalMetrics(font.handle, 0, aTSFontMetrics);
        OS.ATSFontGetHorizontalMetrics(font.handle, 0, aTSFontMetrics);
        this.data.fontAscent = (int)(0.5f + aTSFontMetrics.ascent * font.size);
        this.data.fontDescent = (int)(0.5f + (-aTSFontMetrics.descent + aTSFontMetrics.leading) * font.size);
        if (font.atsuiStyle == 0) {
            if (this.data.atsuiStyle != 0) {
                OS.ATSUDisposeStyle(this.data.atsuiStyle);
            }
            this.data.atsuiStyle = font.createStyle();
        }
        this.data.string = null;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
    }

    public void setFillRule(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (n) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.fillRule = n;
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        if (this.data.forePattern != 0) {
            OS.CGPatternRelease(this.data.forePattern);
        }
        this.data.forePattern = 0;
        this.data.foregroundPattern = null;
        this.data.state &= 0xFFFFFEFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        if (this.data.forePattern != 0) {
            OS.CGPatternRelease(this.data.forePattern);
        }
        this.data.forePattern = 0;
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFEFE;
    }

    public void setInterpolation(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int n2 = 0;
        switch (n) {
            case -1: {
                n2 = 0;
                break;
            }
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.CGContextSetInterpolationQuality(this.handle, n2);
    }

    public void setLineAttributes(LineAttributes lineAttributes) {
        float f;
        int n;
        int n2;
        int n3;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (lineAttributes == null) {
            SWT.error(4);
        }
        int n4 = 0;
        float f2 = lineAttributes.width;
        if (f2 != this.data.lineWidth) {
            n4 |= 0x240;
        }
        if ((n3 = lineAttributes.style) != this.data.lineStyle) {
            n4 |= 8;
            switch (n3) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (lineAttributes.dash != null) break;
                    n3 = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n2 = lineAttributes.join) != this.data.lineJoin) {
            n4 |= 0x20;
            switch (n2) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((n = lineAttributes.cap) != this.data.lineCap) {
            n4 |= 0x10;
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] fArray = lineAttributes.dash;
        float[] fArray2 = this.data.lineDashes;
        if (fArray != null && fArray.length > 0) {
            boolean bl = fArray2 == null || fArray2.length != fArray.length;
            int n5 = 0;
            while (n5 < fArray.length) {
                float f3 = fArray[n5];
                if (f3 <= 0.0f) {
                    SWT.error(5);
                }
                if (!bl && fArray2[n5] != f3) {
                    bl = true;
                }
                ++n5;
            }
            if (bl) {
                float[] fArray3 = new float[fArray.length];
                System.arraycopy(fArray, 0, fArray3, 0, fArray.length);
                fArray = fArray3;
                n4 |= 8;
            } else {
                fArray = fArray2;
            }
        } else if (fArray2 != null && fArray2.length > 0) {
            n4 |= 8;
        } else {
            fArray = fArray2;
        }
        float f4 = lineAttributes.dashOffset;
        if (f4 != this.data.lineDashesOffset) {
            n4 |= 8;
        }
        if ((f = lineAttributes.miterLimit) != this.data.lineMiterLimit) {
            n4 |= 0x80;
        }
        if (n4 == 0) {
            return;
        }
        this.data.lineWidth = f2;
        this.data.lineStyle = n3;
        this.data.lineCap = n;
        this.data.lineJoin = n2;
        this.data.lineDashes = fArray;
        this.data.lineDashesOffset = f4;
        this.data.lineMiterLimit = f;
        this.data.state &= ~n4;
    }

    public void setLineCap(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineCap == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = n;
        this.data.state &= 0xFFFFFFEF;
    }

    public void setLineDash(int[] nArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        float[] fArray = this.data.lineDashes;
        if (nArray != null && nArray.length > 0) {
            boolean bl = this.data.lineStyle != 6 || fArray == null || fArray.length != nArray.length;
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                if (n2 <= 0) {
                    SWT.error(5);
                }
                if (!bl && fArray[n] != (float)n2) {
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                return;
            }
            this.data.lineDashes = new float[nArray.length];
            n = 0;
            while (n < nArray.length) {
                this.data.lineDashes[n] = nArray[n];
                ++n;
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (fArray == null || fArray.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineJoin == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = n;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineStyle(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineStyle == n) {
            return;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                n = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = n;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)n) {
            return;
        }
        this.data.lineWidth = n;
        this.data.state &= 0xFFFFFDBF;
    }

    int setString(String string, int n) {
        int n2;
        int n3;
        int n4;
        if (this.data.layout == 0) {
            this.createLayout();
        }
        if (string == this.data.string && (n & 0xFFFFFFFE) == (this.data.drawFlags & 0xFFFFFFFE)) {
            return this.data.stringLength;
        }
        int n5 = this.data.layout;
        int n6 = string.length();
        char[] cArray = new char[n6];
        string.getChars(0, n6, cArray, 0);
        int n7 = 0;
        int[] nArray = null;
        if ((n & 0xA) != 0) {
            n4 = 0;
            n3 = 0;
            block4: while (n4 < cArray.length) {
                int n8 = n3++;
                int n9 = cArray[n4++];
                cArray[n8] = n9;
                n2 = n9;
                switch (n2) {
                    case 38: {
                        if ((n & 8) == 0 || n4 == cArray.length) continue block4;
                        if (cArray[n4] == '&') {
                            ++n4;
                            break;
                        }
                        --n3;
                        break;
                    }
                    case 10: 
                    case 13: {
                        if ((n & 2) == 0) break;
                        if (n2 == 13 && n4 != cArray.length && cArray[n4] == '\n') {
                            ++n4;
                        }
                        --n3;
                        if (nArray == null) {
                            nArray = new int[4];
                        } else if (n7 == nArray.length) {
                            int[] nArray2 = new int[nArray.length + 4];
                            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                            nArray = nArray2;
                        }
                        nArray[n7++] = n3;
                    }
                }
            }
            n6 = n3;
        }
        if ((n & 4) != 0) {
            if (this.data.tabs == 0) {
                this.createTabs();
            }
            OS.ATSUSetTabArray(n5, this.data.tabs, 32);
        } else {
            OS.ATSUSetTabArray(n5, 0, 0);
        }
        n4 = OS.NewPtr(n6 * 2);
        OS.memmove(n4, cArray, n6 * 2);
        OS.ATSUSetTextPointerLocation(n5, n4, 0, n6, n6);
        if ((n & 2) != 0 && nArray != null) {
            n3 = 0;
            while (n3 < n7) {
                OS.ATSUSetSoftLineBreak(n5, nArray[n3]);
                ++n3;
            }
        }
        Font font = this.data.font;
        n2 = font.atsuiStyle != 0 ? font.atsuiStyle : this.data.atsuiStyle;
        OS.ATSUSetRunStyle(n5, n2, 0, n6);
        OS.ATSUSetTransientFontMatching(n5, true);
        if (this.data.stringPtr != 0) {
            OS.DisposePtr(this.data.stringPtr);
        }
        this.data.stringPtr = n4;
        this.data.string = string;
        this.data.stringLength = n6;
        this.data.stringHeight = -1;
        this.data.stringWidth = -1;
        this.data.drawFlags = n;
        return n6;
    }

    public void setXORMode(boolean bl) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.data.xorMode = bl;
        if (OS.VERSION >= 4160) {
            OS.CGContextSetBlendMode(this.handle, bl ? 10 : 0);
        }
    }

    public void setTextAntialias(int n) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        switch (n) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.textAntialias = n;
    }

    public void setTransform(Transform transform) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.inverseTransform != null) {
            OS.CGContextConcatCTM(this.handle, this.data.inverseTransform);
        }
        if (transform != null) {
            OS.CGContextConcatCTM(this.handle, transform.handle);
            if (this.data.transform == null) {
                this.data.transform = new float[6];
            }
            if (this.data.inverseTransform == null) {
                this.data.inverseTransform = new float[6];
            }
            System.arraycopy(transform.handle, 0, this.data.transform, 0, this.data.transform.length);
            System.arraycopy(transform.handle, 0, this.data.inverseTransform, 0, this.data.inverseTransform.length);
            OS.CGAffineTransformInvert(this.data.inverseTransform, this.data.inverseTransform);
        } else {
            this.data.inverseTransform = null;
            this.data.transform = null;
        }
        if (this.data.forePattern != 0) {
            OS.CGPatternRelease(this.data.forePattern);
            this.data.forePattern = 0;
            this.data.state &= 0xFFFFFEFE;
        }
        if (this.data.backPattern != 0) {
            OS.CGPatternRelease(this.data.backPattern);
            this.data.backPattern = 0;
            this.data.state &= 0xFFFFFFFD;
        }
        this.data.state &= 0xFFFFFDFF;
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int n) {
        int n2;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.checkGC(4);
        int n3 = this.setString(string, n);
        if (this.data.stringWidth != -1) {
            return new Point(this.data.stringWidth, this.data.stringHeight);
        }
        int n4 = 0;
        if (n3 == 0) {
            n2 = this.data.fontAscent + this.data.fontDescent;
        } else {
            ATSTrapezoid aTSTrapezoid = new ATSTrapezoid();
            if ((n & 2) != 0) {
                n2 = 0;
                int n5 = this.data.layout;
                int[] nArray = new int[1];
                OS.ATSUGetSoftLineBreaks(n5, 0, n3, 0, null, nArray);
                int[] nArray2 = new int[nArray[0] + 1];
                OS.ATSUGetSoftLineBreaks(n5, 0, n3, nArray[0], nArray2, nArray);
                nArray2[nArray[0]] = n3;
                int n6 = 0;
                int n7 = 0;
                while (n6 < nArray2.length) {
                    int n8 = nArray2[n6];
                    OS.ATSUGetGlyphBounds(n5, 0, 0, n7, n8 - n7, (short)1, 1, aTSTrapezoid, null);
                    n4 = Math.max(n4, OS.Fix2Long(aTSTrapezoid.lowerRight_x) - OS.Fix2Long(aTSTrapezoid.lowerLeft_x));
                    n2 += OS.Fix2Long(aTSTrapezoid.lowerRight_y) - OS.Fix2Long(aTSTrapezoid.upperRight_y);
                    n7 = n8;
                    ++n6;
                }
            } else {
                OS.ATSUGetGlyphBounds(this.data.layout, 0, 0, 0, n3, (short)1, 1, aTSTrapezoid, null);
                n4 = OS.Fix2Long(aTSTrapezoid.lowerRight_x) - OS.Fix2Long(aTSTrapezoid.lowerLeft_x);
                n2 = OS.Fix2Long(aTSTrapezoid.lowerRight_y) - OS.Fix2Long(aTSTrapezoid.upperRight_y);
            }
        }
        this.data.stringWidth = n4;
        this.data.stringHeight = n2;
        return new Point(this.data.stringWidth, this.data.stringHeight);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }
}

