/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSClipView;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSCursor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSTextView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTextView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    NSScrollView scrollView;
    String text;
    Point[] offsets;
    String[] ids;
    int[] mnemonics;
    NSColor linkColor;
    int focusIndex;
    boolean ignoreNextMouseUp;

    public Link(Composite composite, int n) {
        super(composite, n);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    boolean textView_clickOnLink_atIndex(long l, long l2, long l3, long l4, long l5) {
        NSString nSString = new NSString(l4);
        Event event = new Event();
        event.text = nSString.getString();
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return true;
        }
        for (int i = 0; i < this.offsets.length; ++i) {
            if (l5 < (long)this.offsets[i].x || l5 > (long)this.offsets[i].y) continue;
            this.focusIndex = i;
            break;
        }
        this.redrawWidget(this.view, false);
        this.ignoreNextMouseUp = true;
        return true;
    }

    boolean sendMouseEvent(NSEvent nSEvent, int n, boolean bl) {
        if (n == 5 && this.view.window().firstResponder().id != this.view.id) {
            this.mouseMoved(this.view.id, OS.sel_mouseMoved_, nSEvent.id);
        }
        return super.sendMouseEvent(nSEvent, n, bl);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int n3 = 0;
        int n4 = 0;
        NSLayoutManager nSLayoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
        NSTextContainer nSTextContainer = (NSTextContainer)new NSTextContainer().alloc();
        NSSize nSSize = new NSSize();
        nSSize.height = 5000000.0;
        nSSize.width = 5000000.0;
        if (n != -1) {
            nSSize.width = n;
        }
        if (n2 != -1) {
            nSSize.height = n2;
        }
        nSTextContainer.initWithContainerSize(nSSize);
        nSTextContainer.setLineFragmentPadding(2.0);
        nSLayoutManager.addTextContainer(nSTextContainer);
        NSTextStorage nSTextStorage = (NSTextStorage)new NSTextStorage().alloc().init();
        nSTextStorage.setAttributedString(((NSTextView)this.view).textStorage());
        nSLayoutManager.setTextStorage(nSTextStorage);
        nSLayoutManager.glyphRangeForTextContainer(nSTextContainer);
        NSRect nSRect = nSLayoutManager.usedRectForTextContainer(nSTextContainer);
        n3 = nSLayoutManager.numberOfGlyphs() == 0L ? 64 : (int)Math.ceil(nSRect.width);
        n4 = (int)Math.ceil(nSRect.height);
        nSTextStorage.release();
        nSTextContainer.release();
        nSLayoutManager.release();
        if (n3 <= 0) {
            n3 = 64;
        }
        if (n4 <= 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        nSSize.width = n3;
        nSSize.height = n4;
        int n5 = this.hasBorder() ? 2 : 0;
        nSSize = NSScrollView.frameSizeForContentSize(nSSize, false, false, n5);
        n3 = (int)nSSize.width;
        n4 = (int)nSSize.height;
        if (!this.hasBorder()) {
            n3 += 2;
            n4 += 2;
        }
        return new Point(n3, n4);
    }

    void createHandle() {
        this.state |= 0x800;
        NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
        nSScrollView.init();
        nSScrollView.setDrawsBackground(false);
        nSScrollView.setAutoresizesSubviews(true);
        nSScrollView.setBorderType(this.hasBorder() ? 2L : 0L);
        if (OS.VERSION_MMB >= OS.VERSION_MMB(10, 7, 0)) {
            nSScrollView.setVerticalScrollElasticity(1L);
        }
        NSTextView nSTextView = (NSTextView)new SWTTextView().alloc();
        nSTextView.init();
        nSTextView.setEditable(false);
        NSSize nSSize = new NSSize();
        nSSize.height = 3.4028234663852886E38;
        nSSize.width = 3.4028234663852886E38;
        nSTextView.setMaxSize(nSSize);
        nSTextView.setDisplaysLinkToolTips(false);
        nSTextView.setDrawsBackground(false);
        nSTextView.setDelegate(nSTextView);
        nSTextView.setAutoresizingMask(18L);
        nSTextView.textContainer().setLineFragmentPadding(2.0);
        nSTextView.setFont(this.getFont().handle);
        nSTextView.setAlignment(0L);
        NSMutableDictionary nSMutableDictionary = NSMutableDictionary.dictionaryWithCapacity(4L);
        nSMutableDictionary.setDictionary(nSTextView.selectedTextAttributes());
        nSMutableDictionary.removeObjectForKey(OS.NSBackgroundColorAttributeName);
        nSMutableDictionary.setObject(NSCursor.arrowCursor(), OS.NSCursorAttributeName);
        nSTextView.setSelectedTextAttributes(nSMutableDictionary);
        this.scrollView = nSScrollView;
        this.view = nSTextView;
    }

    void createWidget() {
        super.createWidget();
        this.text = "";
        NSDictionary nSDictionary = ((NSTextView)this.view).linkTextAttributes();
        this.linkColor = new NSColor(nSDictionary.valueForKey(OS.NSForegroundColorAttributeName));
        this.offsets = new Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.focusIndex = -1;
    }

    NSFont defaultNSFont() {
        return this.display.textFieldFont;
    }

    void deregister() {
        super.deregister();
        if (this.scrollView != null) {
            this.display.removeWidget(this.scrollView);
        }
    }

    void drawBackground(long l, NSGraphicsContext nSGraphicsContext, NSRect nSRect) {
        this.fillBackground(this.view, nSGraphicsContext, nSRect, -1);
        if (!this.hasFocus() || this.focusIndex == -1) {
            return;
        }
        int[] nArray = new int[1];
        OS.GetThemeMetric(7, nArray);
        nArray[0] = nArray[0] - 1;
        CGRect cGRect = new CGRect();
        NSRect[] nSRectArray = this.getRectangles(this.focusIndex);
        if (nSRectArray == null) {
            return;
        }
        for (int i = 0; i < nSRectArray.length && nSRectArray[i] != null; ++i) {
            cGRect.origin.x = nSRectArray[i].x + (double)nArray[0];
            cGRect.origin.y = nSRectArray[i].y + (double)nArray[0];
            cGRect.size.width = nSRectArray[i].width - (double)nArray[0];
            cGRect.size.height = nSRectArray[i].height - (double)(2 * nArray[0]);
            OS.HIThemeDrawFocusRect(cGRect, true, nSGraphicsContext.graphicsPort(), 0);
        }
    }

    Cursor findCursor() {
        Cursor cursor = super.findCursor();
        if (cursor != null) {
            return cursor;
        }
        NSTextView nSTextView = (NSTextView)this.view;
        NSWindow nSWindow = this.view.window();
        NSPoint nSPoint = this.view.convertPoint_fromView_(nSWindow.convertScreenToBase(NSEvent.mouseLocation()), null);
        if (nSTextView.characterIndexForInsertionAtPoint(nSPoint) == nSTextView.textStorage().length()) {
            return this.display.getSystemCursor(0);
        }
        return null;
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        NSColor nSColor = null;
        nSColor = bl ? (this.foreground == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(this.foreground[0], this.foreground[1], this.foreground[2], this.foreground[3])) : NSColor.disabledControlTextColor();
        NSTextView nSTextView = (NSTextView)this.view;
        nSTextView.setTextColor(nSColor);
        NSDictionary nSDictionary = nSTextView.linkTextAttributes();
        int n = (int)nSDictionary.count();
        NSMutableDictionary nSMutableDictionary = NSMutableDictionary.dictionaryWithCapacity(n);
        nSMutableDictionary.setDictionary(nSDictionary);
        nSMutableDictionary.setValue(bl ? this.linkColor : nSColor, OS.NSForegroundColorAttributeName);
        nSTextView.setLinkTextAttributes(nSMutableDictionary);
        this.redrawWidget(this.view, false);
    }

    NSRect[] getRectangles(int n) {
        if (n == -1) {
            return null;
        }
        NSTextView nSTextView = (NSTextView)this.view;
        NSLayoutManager nSLayoutManager = nSTextView.layoutManager();
        NSRange nSRange = new NSRange();
        nSRange.location = this.offsets[n].x;
        nSRange.length = this.offsets[n].y - this.offsets[n].x + 1;
        NSRange nSRange2 = nSLayoutManager.glyphRangeForCharacterRange(nSRange, 0L);
        long l = OS.malloc(NSRange.sizeof);
        NSRange nSRange3 = new NSRange();
        int n2 = 0;
        long l2 = nSRange2.location;
        long l3 = nSRange2.location + nSRange2.length;
        while (l2 < l3) {
            ++n2;
            nSLayoutManager.lineFragmentUsedRectForGlyphAtIndex(l2, l, true);
            OS.memmove(nSRange3, l, (long)NSRange.sizeof);
            l2 = nSRange3.location + nSRange3.length;
        }
        NSRect[] nSRectArray = new NSRect[n2];
        l2 = nSRange2.location;
        for (int i = 0; l2 < l3 && i < n2; ++i) {
            NSRect nSRect = nSLayoutManager.lineFragmentUsedRectForGlyphAtIndex(l2, l, true);
            OS.memmove(nSRange3, l, (long)NSRange.sizeof);
            l2 = nSRange3.location + nSRange3.length;
            if (nSRange3.location < nSRange2.location) {
                nSRange3.length = l2 - nSRange2.location;
                nSRange3.location = nSRange2.location;
            }
            if (l2 > l3) {
                nSRange3.length = l3 - nSRange3.location;
            }
            NSRect nSRect2 = nSLayoutManager.boundingRectForGlyphRange(nSRange3, nSTextView.textContainer());
            nSRectArray[i] = new NSRect();
            OS.NSIntersectionRect(nSRectArray[i], nSRect, nSRect2);
        }
        OS.free(l);
        return nSRectArray;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    void mouseUp(long l, long l2, long l3) {
        if (this.ignoreNextMouseUp) {
            this.ignoreNextMouseUp = false;
            return;
        }
        super.mouseUp(l, l2, l3);
    }

    boolean shouldDrawInsertionPoint(long l, long l2) {
        return false;
    }

    void register() {
        super.register();
        this.display.addWidget(this.scrollView, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.scrollView != null) {
            this.scrollView.release();
        }
        this.scrollView = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
        this.linkColor = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    String parse(String string) {
        int n;
        int n2;
        int n3 = string.length();
        this.offsets = new Point[n3 / 4];
        this.ids = new String[n3 / 4];
        this.mnemonics = new int[n3 / 4 + 1];
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[n3];
        string.getChars(0, string.length(), cArray, 0);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        block22: for (int i = 0; i < n3; ++i) {
            n2 = Character.toLowerCase(cArray[i]);
            switch (n4) {
                case 0: {
                    if (n2 != 60) continue block22;
                    n7 = i;
                    ++n4;
                    continue block22;
                }
                case 1: {
                    if (n2 != 97) continue block22;
                    ++n4;
                    continue block22;
                }
                case 2: {
                    switch (n2) {
                        case 104: {
                            n4 = 7;
                            continue block22;
                        }
                        case 62: {
                            n8 = i + 1;
                            ++n4;
                            continue block22;
                        }
                    }
                    if (Character.isWhitespace((char)n2)) continue block22;
                    n4 = 13;
                    continue block22;
                }
                case 3: {
                    if (n2 != 60) continue block22;
                    n9 = i;
                    ++n4;
                    continue block22;
                }
                case 4: {
                    n4 = n2 == 47 ? n4 + 1 : 3;
                    continue block22;
                }
                case 5: {
                    n4 = n2 == 97 ? n4 + 1 : 3;
                    continue block22;
                }
                case 6: {
                    if (n2 == 62) {
                        this.mnemonics[n5] = this.parseMnemonics(cArray, n6, n7, stringBuffer);
                        n = stringBuffer.length();
                        this.parseMnemonics(cArray, n8, n9, stringBuffer);
                        this.offsets[n5] = new Point(n, stringBuffer.length() - 1);
                        if (this.ids[n5] == null) {
                            this.ids[n5] = new String(cArray, n8, n9 - n8);
                        }
                        ++n5;
                        n9 = n10 = i + 1;
                        n8 = n10;
                        n7 = n10;
                        n6 = n10;
                        n4 = 0;
                        continue block22;
                    }
                    n4 = 3;
                    continue block22;
                }
                case 7: {
                    n4 = n2 == 114 ? n4 + 1 : 0;
                    continue block22;
                }
                case 8: {
                    n4 = n2 == 101 ? n4 + 1 : 0;
                    continue block22;
                }
                case 9: {
                    n4 = n2 == 102 ? n4 + 1 : 0;
                    continue block22;
                }
                case 10: {
                    n4 = n2 == 61 ? n4 + 1 : 0;
                    continue block22;
                }
                case 11: {
                    if (n2 == 34) {
                        ++n4;
                        n10 = i + 1;
                        continue block22;
                    }
                    n4 = 0;
                    continue block22;
                }
                case 12: {
                    if (n2 != 34) continue block22;
                    this.ids[n5] = new String(cArray, n10, i - n10);
                    n4 = 2;
                    continue block22;
                }
                case 13: {
                    if (Character.isWhitespace((char)n2)) {
                        n4 = 0;
                        continue block22;
                    }
                    if (n2 != 61) continue block22;
                    ++n4;
                    continue block22;
                }
                case 14: {
                    n4 = n2 == 34 ? n4 + 1 : 0;
                    continue block22;
                }
                case 15: {
                    if (n2 != 34) continue block22;
                    n4 = 2;
                    continue block22;
                }
                default: {
                    n4 = 0;
                }
            }
        }
        if (n6 < n3) {
            n2 = this.parseMnemonics(cArray, n6, n7, stringBuffer);
            n = this.parseMnemonics(cArray, Math.max(n7, n8), n3, stringBuffer);
            if (n == -1) {
                n = n2;
            }
            this.mnemonics[n5] = n;
        } else {
            this.mnemonics[n5] = -1;
        }
        if (this.offsets.length != n5) {
            Point[] pointArray = new Point[n5];
            System.arraycopy(this.offsets, 0, pointArray, 0, n5);
            this.offsets = pointArray;
            String[] stringArray = new String[n5];
            System.arraycopy(this.ids, 0, stringArray, 0, n5);
            this.ids = stringArray;
            int[] nArray = new int[n5 + 1];
            System.arraycopy(this.mnemonics, 0, nArray, 0, n5 + 1);
            this.mnemonics = nArray;
        }
        return stringBuffer.toString();
    }

    int parseMnemonics(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        int n3 = -1;
        for (int i = n; i < n2; ++i) {
            if (cArray[i] == '&') {
                if (i + 1 < n2 && cArray[i + 1] == '&') {
                    stringBuffer.append(cArray[i]);
                    ++i;
                    continue;
                }
                n3 = stringBuffer.length();
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        return n3;
    }

    void scrollWheel(long l, long l2, long l3) {
        super.scrollWheel(l, l2, l3);
        this.parent.scrollWheel(this.parent.view.id, l2, l3);
    }

    void sendFocusEvent(int n) {
        if (this.focusIndex != -1) {
            this.redrawWidget(this.view, false);
        }
        super.sendFocusEvent(n);
    }

    boolean sendKeyEvent(int n, Event event) {
        boolean bl = super.sendKeyEvent(n, event);
        if (!bl) {
            return bl;
        }
        if (this.focusIndex == -1) {
            return bl;
        }
        if (n != 1) {
            return bl;
        }
        int n2 = event.keyCode;
        switch (n2) {
            case 13: 
            case 32: 
            case 0x1000050: {
                Event event2 = new Event();
                event2.text = this.ids[this.focusIndex];
                this.sendEvent(13, event2);
                break;
            }
            case 9: {
                boolean bl2;
                int n3 = event.stateMask;
                boolean bl3 = bl2 = (n3 & 0x20000) == 0;
                if (bl2) {
                    if (this.focusIndex >= this.offsets.length - 1) break;
                    ++this.focusIndex;
                    this.redraw();
                    return false;
                }
                if (this.focusIndex <= 0) break;
                --this.focusIndex;
                this.redraw();
                return false;
            }
        }
        return bl;
    }

    void setBackgroundColor(NSColor nSColor) {
        this.setBackground(nSColor);
    }

    void setBackgroundImage(NSImage nSImage) {
        ((NSTextView)this.view).setDrawsBackground(nSImage == null);
    }

    void setBackground(NSColor nSColor) {
        NSTextView nSTextView = (NSTextView)this.view;
        if (nSColor == null) {
            nSTextView.setDrawsBackground(false);
        } else {
            nSTextView.setDrawsBackground(true);
            nSTextView.setBackgroundColor(nSColor);
        }
    }

    void setFont(NSFont nSFont) {
        ((NSTextView)this.view).setFont(nSFont);
    }

    void setForeground(double[] dArray) {
        if (!this.getEnabled()) {
            return;
        }
        NSColor nSColor = dArray == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(dArray[0], dArray[1], dArray[2], 1.0);
        ((NSTextView)this.view).setTextColor(nSColor);
    }

    void setOrientation() {
        NSTextView nSTextView = (NSTextView)this.view;
        int n = (this.style & 0x4000000) != 0 ? 1 : 0;
        nSTextView.setBaseWritingDirection(n);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        NSTextView nSTextView = (NSTextView)this.view;
        nSTextView.setString(NSString.stringWith(this.parse(string)));
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        NSTextStorage nSTextStorage = nSTextView.textStorage();
        NSRange nSRange = new NSRange();
        nSRange.length = nSTextStorage.length();
        nSTextStorage.removeAttribute(OS.NSLinkAttributeName, nSRange);
        nSTextStorage.addAttribute(OS.NSCursorAttributeName, NSCursor.arrowCursor(), nSRange);
        for (int i = 0; i < this.offsets.length; ++i) {
            nSRange.location = this.offsets[i].x;
            nSRange.length = this.offsets[i].y - this.offsets[i].x + 1;
            nSTextStorage.addAttribute(OS.NSLinkAttributeName, NSString.stringWith(this.ids[i]), nSRange);
        }
    }

    void setZOrder() {
        super.setZOrder();
        if (this.scrollView != null) {
            this.scrollView.setDocumentView(this.view);
        }
    }

    NSView topView() {
        return this.scrollView;
    }

    int traversalCode(int n, NSEvent nSEvent) {
        if (this.offsets.length == 0) {
            return 0;
        }
        int n2 = super.traversalCode(n, nSEvent);
        if (n == 48 && nSEvent != null) {
            boolean bl;
            long l = nSEvent.modifierFlags();
            boolean bl2 = bl = (l & 0x20000L) == 0L;
            if (bl && this.focusIndex < this.offsets.length - 1) {
                return n2 & 0xFFFFFFEF;
            }
            if (!bl && this.focusIndex > 0) {
                return n2 & 0xFFFFFFF7;
            }
        }
        return n2;
    }

    void updateCursorRects(boolean bl) {
        super.updateCursorRects(bl);
        if (this.scrollView == null) {
            return;
        }
        this.updateCursorRects(bl, this.scrollView);
        NSClipView nSClipView = this.scrollView.contentView();
        this.updateCursorRects(bl, nSClipView);
        nSClipView.setDocumentCursor(bl ? NSCursor.arrowCursor() : null);
    }
}

