/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    Control parent;
    boolean tracking;
    boolean cancelled;
    boolean stippled;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int resizeCursor;
    Cursor clientCursor;
    int cursorOrientation = 0;
    boolean inEvent = false;
    boolean drawn;
    int hwndTransparent;
    int hwndOpaque;
    int oldTransparentProc;
    int oldOpaqueProc;
    int oldX;
    int oldY;
    static boolean IsVista = !OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0);
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite composite, int n) {
        super(composite, Tracker.checkStyle(n));
        this.parent = composite;
    }

    public Tracker(Display display, int n) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(n);
        this.display = display;
        this.reskinWidget();
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n = this.bounds.x + this.bounds.width / 2;
        int n2 = this.bounds.y;
        POINT pOINT = new POINT();
        pOINT.x = n;
        pOINT.y = n2;
        if (this.parent != null) {
            OS.ClientToScreen(this.parent.handle, pOINT);
        }
        OS.SetCursorPos(pOINT.x, pOINT.y);
        return new Point(pOINT.x, pOINT.y);
    }

    Point adjustResizeCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int n2 = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        POINT pOINT = new POINT();
        pOINT.x = n;
        pOINT.y = n2;
        if (this.parent != null) {
            OS.ClientToScreen(this.parent.handle, pOINT);
        }
        OS.SetCursorPos(pOINT.x, pOINT.y);
        if (this.clientCursor == null) {
            int n3 = 0;
            switch (this.cursorOrientation) {
                case 128: {
                    n3 = OS.LoadCursor(0, 32645);
                    break;
                }
                case 1024: {
                    n3 = OS.LoadCursor(0, 32645);
                    break;
                }
                case 16384: {
                    n3 = OS.LoadCursor(0, 32644);
                    break;
                }
                case 131072: {
                    n3 = OS.LoadCursor(0, 32644);
                    break;
                }
                case 16512: {
                    n3 = OS.LoadCursor(0, 32642);
                    break;
                }
                case 132096: {
                    n3 = OS.LoadCursor(0, 32642);
                    break;
                }
                case 17408: {
                    n3 = OS.LoadCursor(0, 32643);
                    break;
                }
                case 131200: {
                    n3 = OS.LoadCursor(0, 32643);
                    break;
                }
                default: {
                    n3 = OS.LoadCursor(0, 32646);
                }
            }
            OS.SetCursor(n3);
            if (this.resizeCursor != 0) {
                OS.DestroyCursor(this.resizeCursor);
            }
            this.resizeCursor = n3;
        }
        return new Point(pOINT.x, pOINT.y);
    }

    static int checkStyle(int n) {
        if ((n & 0x24480) == 0) {
            n |= 0x24480;
        }
        return n;
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int n = this.rectangles[0].x;
        int n2 = this.rectangles[0].y;
        int n3 = this.rectangles[0].x + this.rectangles[0].width;
        int n4 = this.rectangles[0].y + this.rectangles[0].height;
        for (int i = 1; i < this.rectangles.length; ++i) {
            int n5;
            int n6;
            if (this.rectangles[i].x < n) {
                n = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < n2) {
                n2 = this.rectangles[i].y;
            }
            if ((n6 = this.rectangles[i].x + this.rectangles[i].width) > n3) {
                n3 = n6;
            }
            if ((n5 = this.rectangles[i].y + this.rectangles[i].height) <= n4) continue;
            n4 = n5;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    Rectangle[] computeProportions(Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            for (int i = 0; i < rectangleArray.length; ++i) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (this.bounds.width != 0) {
                    n = (rectangleArray[i].x - this.bounds.x) * 100 / this.bounds.width;
                    n3 = rectangleArray[i].width * 100 / this.bounds.width;
                } else {
                    n3 = 100;
                }
                if (this.bounds.height != 0) {
                    n2 = (rectangleArray[i].y - this.bounds.y) * 100 / this.bounds.height;
                    n4 = rectangleArray[i].height * 100 / this.bounds.height;
                } else {
                    n4 = 100;
                }
                rectangleArray2[i] = new Rectangle(n, n2, n3, n4);
            }
        }
        return rectangleArray2;
    }

    void drawRectangles(Rectangle[] rectangleArray, boolean bl) {
        if (this.hwndOpaque != 0) {
            RECT rECT = new RECT();
            int n = bl ? 3 : 1;
            for (int i = 0; i < rectangleArray.length; ++i) {
                Rectangle rectangle = rectangleArray[i];
                rECT.left = rectangle.x - n;
                rECT.top = rectangle.y - n;
                rECT.right = rectangle.x + rectangle.width + n * 2;
                rECT.bottom = rectangle.y + rectangle.height + n * 2;
                OS.MapWindowPoints(0, this.hwndOpaque, rECT, 2);
                OS.RedrawWindow(this.hwndOpaque, rECT, 0, 1);
            }
            return;
        }
        int n = 1;
        int n2 = this.parent == null ? OS.GetDesktopWindow() : this.parent.handle;
        int n3 = OS.GetDCEx(n2, 0, 2);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (bl) {
            n = 3;
            byte[] byArray = new byte[]{-86, 0, 85, 0, -86, 0, 85, 0, -86, 0, 85, 0, -86, 0, 85, 0};
            n4 = OS.CreateBitmap(8, 8, 1, 1, byArray);
            n5 = OS.CreatePatternBrush(n4);
            n6 = OS.SelectObject(n3, n5);
        }
        for (int i = 0; i < rectangleArray.length; ++i) {
            Rectangle rectangle = rectangleArray[i];
            OS.PatBlt(n3, rectangle.x, rectangle.y, rectangle.width, n, 5898313);
            OS.PatBlt(n3, rectangle.x, rectangle.y + n, n, rectangle.height - n * 2, 5898313);
            OS.PatBlt(n3, rectangle.x + rectangle.width - n, rectangle.y + n, n, rectangle.height - n * 2, 5898313);
            OS.PatBlt(n3, rectangle.x, rectangle.y + rectangle.height - n, rectangle.width, n, 5898313);
        }
        if (bl) {
            OS.SelectObject(n3, n6);
            OS.DeleteObject(n5);
            OS.DeleteObject(n4);
        }
        OS.ReleaseDC(n2, n3);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i = 0; i < this.rectangles.length; ++i) {
            Rectangle rectangle = this.rectangles[i];
            rectangleArray[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return rectangleArray;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    void moveRectangles(int n, int n2) {
        if (this.bounds == null) {
            return;
        }
        if (n < 0 && (this.style & 0x4000) == 0) {
            n = 0;
        }
        if (n > 0 && (this.style & 0x20000) == 0) {
            n = 0;
        }
        if (n2 < 0 && (this.style & 0x80) == 0) {
            n2 = 0;
        }
        if (n2 > 0 && (this.style & 0x400) == 0) {
            n2 = 0;
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        this.bounds.x += n;
        this.bounds.y += n2;
        for (int i = 0; i < this.rectangles.length; ++i) {
            this.rectangles[i].x += n;
            this.rectangles[i].y += n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        Callback callback;
        block32: {
            int n;
            SerializableCompatibility serializableCompatibility;
            boolean bl;
            int n2;
            this.checkWidget();
            this.cancelled = false;
            this.tracking = true;
            int n3 = this.style & 0x480;
            if (n3 == 128 || n3 == 1024) {
                this.cursorOrientation |= n3;
            }
            if ((n2 = this.style & 0x24000) == 16384 || n2 == 131072) {
                this.cursorOrientation |= n2;
            }
            callback = null;
            boolean bl2 = bl = OS.GetKeyState(1) < 0;
            if (IsVista && this.parent == null) {
                serializableCompatibility = this.display.getBounds();
                this.hwndTransparent = OS.CreateWindowEx(0x8080080, this.display.windowClass, null, Integer.MIN_VALUE, serializableCompatibility.x, serializableCompatibility.y, serializableCompatibility.width, serializableCompatibility.height, 0, 0, OS.GetModuleHandle(null), null);
                OS.SetLayeredWindowAttributes(this.hwndTransparent, 0, (byte)1, 2);
                this.hwndOpaque = OS.CreateWindowEx(0x8080080, this.display.windowClass, null, Integer.MIN_VALUE, serializableCompatibility.x, serializableCompatibility.y, serializableCompatibility.width, serializableCompatibility.height, this.hwndTransparent, 0, OS.GetModuleHandle(null), null);
                OS.SetLayeredWindowAttributes(this.hwndOpaque, 0xFFFFFF, (byte)0, 3);
                this.drawn = false;
                callback = new Callback(this, "transparentProc", 4);
                n = callback.getAddress();
                if (n == 0) {
                    this.error(3);
                }
                this.oldTransparentProc = OS.GetWindowLongPtr(this.hwndTransparent, -4);
                OS.SetWindowLongPtr(this.hwndTransparent, -4, n);
                this.oldOpaqueProc = OS.GetWindowLongPtr(this.hwndOpaque, -4);
                OS.SetWindowLongPtr(this.hwndOpaque, -4, n);
                OS.ShowWindow(this.hwndTransparent, 4);
                OS.ShowWindow(this.hwndOpaque, 4);
            } else if (!bl) {
                serializableCompatibility = this.display.getBounds();
                this.hwndTransparent = OS.CreateWindowEx(32, this.display.windowClass, null, Integer.MIN_VALUE, serializableCompatibility.x, serializableCompatibility.y, serializableCompatibility.width, serializableCompatibility.height, 0, 0, OS.GetModuleHandle(null), null);
                callback = new Callback(this, "transparentProc", 4);
                n = callback.getAddress();
                if (n == 0) {
                    this.error(3);
                }
                this.oldTransparentProc = OS.GetWindowLongPtr(this.hwndTransparent, -4);
                OS.SetWindowLongPtr(this.hwndTransparent, -4, n);
                OS.ShowWindow(this.hwndTransparent, 4);
            }
            this.update();
            this.drawRectangles(this.rectangles, this.stippled);
            serializableCompatibility = null;
            if (bl) {
                POINT pOINT = new POINT();
                OS.GetCursorPos(pOINT);
                serializableCompatibility = new Point(pOINT.x, pOINT.y);
            } else {
                serializableCompatibility = (this.style & 0x10) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
            }
            if (serializableCompatibility != null) {
                this.oldX = ((Point)serializableCompatibility).x;
                this.oldY = ((Point)serializableCompatibility).y;
            }
            Display display = this.display;
            try {
                MSG mSG = new MSG();
                while (!(!this.tracking || this.cancelled || this.parent != null && this.parent.isDisposed())) {
                    display.runSkin();
                    display.runDeferredLayouts();
                    display.sendPreExternalEventDispatchEvent();
                    OS.GetMessage(mSG, 0, 0, 0);
                    display.sendPostExternalEventDispatchEvent();
                    OS.TranslateMessage(mSG);
                    switch (mSG.message) {
                        case 512: 
                        case 514: {
                            this.wmMouse(mSG.message, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 646: {
                            this.wmIMEChar(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 258: {
                            this.wmChar(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 256: {
                            this.wmKeyDown(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 257: {
                            this.wmKeyUp(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 262: {
                            this.wmSysChar(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 260: {
                            this.wmSysKeyDown(mSG.hwnd, mSG.wParam, mSG.lParam);
                            break;
                        }
                        case 261: {
                            this.wmSysKeyUp(mSG.hwnd, mSG.wParam, mSG.lParam);
                        }
                    }
                    if (256 <= mSG.message && mSG.message <= 264 || 512 <= mSG.message && mSG.message <= 525) continue;
                    if (this.hwndOpaque == 0 && mSG.message == 15) {
                        this.update();
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    OS.DispatchMessage(mSG);
                    if (this.hwndOpaque == 0 && mSG.message == 15) {
                        this.drawRectangles(this.rectangles, this.stippled);
                    }
                    display.runAsyncMessages(false);
                }
                if (bl) {
                    OS.ReleaseCapture();
                }
                if (!this.isDisposed()) {
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                Object var9_10 = null;
                if (this.hwndTransparent == 0) break block32;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (this.hwndTransparent != 0) {
                    OS.DestroyWindow(this.hwndTransparent);
                    this.hwndTransparent = 0;
                }
                this.hwndOpaque = 0;
                if (callback != null) {
                    callback.dispose();
                    this.oldOpaqueProc = 0;
                    this.oldTransparentProc = 0;
                }
                if (this.resizeCursor != 0) {
                    OS.DestroyCursor(this.resizeCursor);
                    this.resizeCursor = 0;
                }
                throw throwable;
            }
            OS.DestroyWindow(this.hwndTransparent);
            this.hwndTransparent = 0;
        }
        this.hwndOpaque = 0;
        if (callback != null) {
            callback.dispose();
            this.oldOpaqueProc = 0;
            this.oldTransparentProc = 0;
        }
        if (this.resizeCursor != 0) {
            OS.DestroyCursor(this.resizeCursor);
            this.resizeCursor = 0;
        }
        this.tracking = false;
        return !this.cancelled;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, controlListener);
        this.eventTable.unhook(10, controlListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    void resizeRectangles(int n, int n2) {
        Rectangle rectangle;
        int n3;
        if (this.bounds == null) {
            return;
        }
        if (n < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (n > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (n2 < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (n2 > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (n > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                n -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    for (n3 = 0; n3 < this.proportions.length; ++n3) {
                        rectangle = this.proportions[n3];
                        rectangle.x = 100 - rectangle.x - rectangle.width;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -n) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            n += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                for (n3 = 0; n3 < this.proportions.length; ++n3) {
                    rectangle = this.proportions[n3];
                    rectangle.x = 100 - rectangle.x - rectangle.width;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (n2 > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                n2 -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    for (n3 = 0; n3 < this.proportions.length; ++n3) {
                        rectangle = this.proportions[n3];
                        rectangle.y = 100 - rectangle.y - rectangle.height;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -n2) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            n2 += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                for (n3 = 0; n3 < this.proportions.length; ++n3) {
                    rectangle = this.proportions[n3];
                    rectangle.y = 100 - rectangle.y - rectangle.height;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += n;
            this.bounds.width -= n;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += n;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += n2;
            this.bounds.height -= n2;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += n2;
        }
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i = 0; i < this.rectangles.length; ++i) {
            Rectangle rectangle2 = this.proportions[i];
            rectangleArray[i] = new Rectangle(rectangle2.x * this.bounds.width / 100 + this.bounds.x, rectangle2.y * this.bounds.height / 100 + this.bounds.y, rectangle2.width * this.bounds.width / 100, rectangle2.height * this.bounds.height / 100);
        }
        this.rectangles = rectangleArray;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.clientCursor = cursor;
        if (cursor != null && this.inEvent) {
            OS.SetCursor(this.clientCursor.handle);
        }
    }

    public void setRectangles(Rectangle[] rectangleArray) {
        this.checkWidget();
        if (rectangleArray == null) {
            this.error(4);
        }
        this.rectangles = new Rectangle[rectangleArray.length];
        for (int i = 0; i < rectangleArray.length; ++i) {
            Rectangle rectangle = rectangleArray[i];
            if (rectangle == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.proportions = this.computeProportions(rectangleArray);
    }

    public void setStippled(boolean bl) {
        this.checkWidget();
        this.stippled = bl;
    }

    int transparentProc(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 132: {
                if (!this.inEvent) break;
                return -1;
            }
            case 32: {
                if (this.clientCursor != null) {
                    OS.SetCursor(this.clientCursor.handle);
                    return 1;
                }
                if (this.resizeCursor == 0) break;
                OS.SetCursor(this.resizeCursor);
                return 1;
            }
            case 15: {
                Object[] objectArray;
                if (this.hwndOpaque != n) break;
                PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
                int n5 = OS.BeginPaint(n, pAINTSTRUCT);
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = OS.CreateSolidBrush(0xFFFFFF);
                n8 = OS.SelectObject(n5, n9);
                OS.PatBlt(n5, pAINTSTRUCT.left, pAINTSTRUCT.top, pAINTSTRUCT.right - pAINTSTRUCT.left, pAINTSTRUCT.bottom - pAINTSTRUCT.top, 15728673);
                OS.SelectObject(n5, n8);
                OS.DeleteObject(n9);
                int n10 = 1;
                if (this.stippled) {
                    n10 = 3;
                    objectArray = new byte[]{-86, 0, 85, 0, -86, 0, 85, 0, -86, 0, 85, 0, -86, 0, 85, 0};
                    n6 = OS.CreateBitmap(8, 8, 1, 1, (byte[])objectArray);
                    n7 = OS.CreatePatternBrush(n6);
                    n8 = OS.SelectObject(n5, n7);
                    OS.SetBkColor(n5, 0xF0F0F0);
                } else {
                    n8 = OS.SelectObject(n5, OS.GetStockObject(4));
                }
                objectArray = this.rectangles;
                RECT rECT = new RECT();
                for (int i = 0; i < objectArray.length; ++i) {
                    Rectangle rectangle = objectArray[i];
                    rECT.left = rectangle.x;
                    rECT.top = rectangle.y;
                    rECT.right = rectangle.x + rectangle.width;
                    rECT.bottom = rectangle.y + rectangle.height;
                    OS.MapWindowPoints(0, this.hwndOpaque, rECT, 2);
                    int n11 = rECT.right - rECT.left;
                    int n12 = rECT.bottom - rECT.top;
                    OS.PatBlt(n5, rECT.left, rECT.top, n11, n10, 15728673);
                    OS.PatBlt(n5, rECT.left, rECT.top + n10, n10, n12 - n10 * 2, 15728673);
                    OS.PatBlt(n5, rECT.right - n10, rECT.top + n10, n10, n12 - n10 * 2, 15728673);
                    OS.PatBlt(n5, rECT.left, rECT.bottom - n10, n11, n10, 15728673);
                }
                OS.SelectObject(n5, n8);
                if (this.stippled) {
                    OS.DeleteObject(n7);
                    OS.DeleteObject(n6);
                }
                OS.EndPaint(n, pAINTSTRUCT);
                if (!this.drawn) {
                    OS.SetLayeredWindowAttributes(this.hwndOpaque, 0xFFFFFF, (byte)-1, 3);
                    this.drawn = true;
                }
                return 0;
            }
        }
        return OS.CallWindowProc(n == this.hwndTransparent ? this.oldTransparentProc : this.oldOpaqueProc, n, n2, n3, n4);
    }

    void update() {
        if (this.hwndOpaque != 0) {
            return;
        }
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            Shell shell = this.parent.getShell();
            shell.update(true);
        } else {
            this.display.update();
        }
    }

    LRESULT wmKeyDown(int n, int n2, int n3) {
        LRESULT lRESULT = super.wmKeyDown(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        boolean bl = this.parent != null && (this.parent.style & 0x8000000) != 0;
        int n4 = OS.GetKeyState(17) < 0 ? 1 : 9;
        int n5 = 0;
        int n6 = 0;
        switch (n2) {
            case 27: {
                this.cancelled = true;
                this.tracking = false;
                break;
            }
            case 13: {
                this.tracking = false;
                break;
            }
            case 37: {
                n5 = bl ? n4 : -n4;
                break;
            }
            case 39: {
                n5 = bl ? -n4 : n4;
                break;
            }
            case 38: {
                n6 = -n4;
                break;
            }
            case 40: {
                n6 = n4;
            }
        }
        if (n5 != 0 || n6 != 0) {
            SerializableCompatibility serializableCompatibility;
            Rectangle[] rectangleArray = this.rectangles;
            boolean bl2 = this.stippled;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            for (int i = 0; i < this.rectangles.length; ++i) {
                serializableCompatibility = this.rectangles[i];
                rectangleArray2[i] = new Rectangle(serializableCompatibility.x, serializableCompatibility.y, serializableCompatibility.width, serializableCompatibility.height);
            }
            Event event = new Event();
            event.x = this.oldX + n5;
            event.y = this.oldY + n6;
            if ((this.style & 0x10) != 0) {
                this.resizeRectangles(n5, n6);
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return LRESULT.ONE;
                }
                boolean bl3 = false;
                if (this.rectangles != rectangleArray) {
                    int n7 = this.rectangles.length;
                    if (n7 != rectangleArray2.length) {
                        bl3 = true;
                    } else {
                        for (int i = 0; i < n7; ++i) {
                            if (this.rectangles[i].equals(rectangleArray2[i])) continue;
                            bl3 = true;
                            break;
                        }
                    }
                } else {
                    bl3 = true;
                }
                if (bl3) {
                    this.drawRectangles(rectangleArray2, bl2);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                serializableCompatibility = this.adjustResizeCursor();
            } else {
                this.moveRectangles(n5, n6);
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return LRESULT.ONE;
                }
                boolean bl4 = false;
                if (this.rectangles != rectangleArray) {
                    int n8 = this.rectangles.length;
                    if (n8 != rectangleArray2.length) {
                        bl4 = true;
                    } else {
                        for (int i = 0; i < n8; ++i) {
                            if (this.rectangles[i].equals(rectangleArray2[i])) continue;
                            bl4 = true;
                            break;
                        }
                    }
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    this.drawRectangles(rectangleArray2, bl2);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                serializableCompatibility = this.adjustMoveCursor();
            }
            if (serializableCompatibility != null) {
                this.oldX = ((Point)serializableCompatibility).x;
                this.oldY = ((Point)serializableCompatibility).y;
            }
        }
        return lRESULT;
    }

    LRESULT wmSysKeyDown(int n, int n2, int n3) {
        LRESULT lRESULT = super.wmSysKeyDown(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.cancelled = true;
        this.tracking = false;
        return lRESULT;
    }

    LRESULT wmMouse(int n, int n2, int n3) {
        boolean bl = this.parent != null && (this.parent.style & 0x8000000) != 0;
        int n4 = OS.GetMessagePos();
        int n5 = OS.GET_X_LPARAM(n4);
        int n6 = OS.GET_Y_LPARAM(n4);
        if (n5 != this.oldX || n6 != this.oldY) {
            Rectangle[] rectangleArray = this.rectangles;
            boolean bl2 = this.stippled;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            for (int i = 0; i < this.rectangles.length; ++i) {
                Rectangle rectangle = this.rectangles[i];
                rectangleArray2[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            Event event = new Event();
            event.x = n5;
            event.y = n6;
            if ((this.style & 0x10) != 0) {
                Point point;
                if (bl) {
                    this.resizeRectangles(this.oldX - n5, n6 - this.oldY);
                } else {
                    this.resizeRectangles(n5 - this.oldX, n6 - this.oldY);
                }
                this.inEvent = true;
                this.sendEvent(11, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return LRESULT.ONE;
                }
                boolean bl3 = false;
                if (this.rectangles != rectangleArray) {
                    int n7 = this.rectangles.length;
                    if (n7 != rectangleArray2.length) {
                        bl3 = true;
                    } else {
                        for (int i = 0; i < n7; ++i) {
                            if (this.rectangles[i].equals(rectangleArray2[i])) continue;
                            bl3 = true;
                            break;
                        }
                    }
                } else {
                    bl3 = true;
                }
                if (bl3) {
                    this.drawRectangles(rectangleArray2, bl2);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
                if ((point = this.adjustResizeCursor()) != null) {
                    n5 = point.x;
                    n6 = point.y;
                }
            } else {
                if (bl) {
                    this.moveRectangles(this.oldX - n5, n6 - this.oldY);
                } else {
                    this.moveRectangles(n5 - this.oldX, n6 - this.oldY);
                }
                this.inEvent = true;
                this.sendEvent(10, event);
                this.inEvent = false;
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return LRESULT.ONE;
                }
                boolean bl4 = false;
                if (this.rectangles != rectangleArray) {
                    int n8 = this.rectangles.length;
                    if (n8 != rectangleArray2.length) {
                        bl4 = true;
                    } else {
                        for (int i = 0; i < n8; ++i) {
                            if (this.rectangles[i].equals(rectangleArray2[i])) continue;
                            bl4 = true;
                            break;
                        }
                    }
                } else {
                    bl4 = true;
                }
                if (bl4) {
                    this.drawRectangles(rectangleArray2, bl2);
                    this.update();
                    this.drawRectangles(this.rectangles, this.stippled);
                }
            }
            this.oldX = n5;
            this.oldY = n6;
        }
        this.tracking = n != 514;
        return null;
    }
}

