/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.internal.cocoa.Cocoa;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class WebKit
extends WebBrowser {
    int delegate;
    int webViewHandle;
    int webView;
    int windowBoundsHandler;
    int preferences;
    boolean loadingText;
    boolean hasNewFocusElement;
    boolean untrustedText;
    String lastHoveredLinkURL;
    String lastNavigateURL;
    String html;
    int identifier;
    int resourceCount;
    int lastMouseMoveX;
    int lastMouseMoveY;
    String url = "";
    org.eclipse.swt.graphics.Point location;
    org.eclipse.swt.graphics.Point size;
    boolean statusBar = true;
    boolean toolBar = true;
    boolean ignoreDispose;
    static boolean Initialized;
    static Callback Callback3;
    static Callback Callback7;
    static final int MIN_SIZE = 16;
    static final int MAX_PROGRESS = 100;
    static final String WebElementLinkURLKey = "WebElementLinkURL";
    static final String AGENT_STRING = "Safari/412.0";
    static final String URI_FILEROOT = "file:///";
    static final String PROTOCOL_FILE = "file://";
    static final String PROTOCOL_HTTP = "http://";
    static final String URI_APPLEWEBDATA = "applewebdata://";
    static final String ABOUT_BLANK = "about:blank";
    static final String HEADER_SETCOOKIE = "Set-Cookie";
    static final String POST = "POST";
    static final String USER_AGENT = "user-agent";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String BROWSER_WINDOW = "org.eclipse.swt.browser.Browser.Window";
    static final String WEBKIT_EVENTS_FIX_KEY = "org.eclipse.swt.internal.webKitEventsFix";
    static final String DOMEVENT_KEYUP = "keyup";
    static final String DOMEVENT_KEYDOWN = "keydown";
    static final String DOMEVENT_MOUSEDOWN = "mousedown";
    static final String DOMEVENT_MOUSEUP = "mouseup";
    static final String DOMEVENT_MOUSEMOVE = "mousemove";
    static final String DOMEVENT_MOUSEWHEEL = "mousewheel";
    static final String DOMEVENT_FOCUSIN = "DOMFocusIn";
    static final String DOMEVENT_FOCUSOUT = "DOMFocusOut";

    static {
        Cocoa.WebInitForCarbon();
        NativeClearSessions = new Runnable(){

            public void run() {
                int n = Cocoa.objc_msgSend(Cocoa.C_NSHTTPCookieStorage, Cocoa.S_sharedHTTPCookieStorage);
                int n2 = Cocoa.objc_msgSend(n, Cocoa.S_cookies);
                int n3 = Cocoa.objc_msgSend(n2, Cocoa.S_count);
                int n4 = 0;
                while (n4 < n3) {
                    boolean bl;
                    int n5 = Cocoa.objc_msgSend(n2, Cocoa.S_objectAtIndex, n4);
                    boolean bl2 = bl = Cocoa.objc_msgSend(n5, Cocoa.S_isSessionOnly) != 0;
                    if (bl) {
                        Cocoa.objc_msgSend(n, Cocoa.S_deleteCookie, n5);
                    }
                    ++n4;
                }
            }
        };
        NativeGetCookie = new Runnable(){

            public void run() {
                int n = Cocoa.objc_msgSend(Cocoa.C_NSHTTPCookieStorage, Cocoa.S_sharedHTTPCookieStorage);
                int n2 = WebKit.createNSString(CookieUrl);
                int n3 = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, n2);
                OS.CFRelease(n2);
                int n4 = Cocoa.objc_msgSend(n, Cocoa.S_cookiesForURL, n3);
                int n5 = Cocoa.objc_msgSend(n4, Cocoa.S_count);
                if (n5 == 0) {
                    return;
                }
                int n6 = WebKit.createNSString(CookieName);
                int n7 = 0;
                while (n7 < n5) {
                    int n8 = Cocoa.objc_msgSend(n4, Cocoa.S_objectAtIndex, n7);
                    int n9 = Cocoa.objc_msgSend(n8, Cocoa.S_name);
                    if (Cocoa.objc_msgSend(n9, Cocoa.S_compare, n6) == 0) {
                        int n10 = Cocoa.objc_msgSend(n8, Cocoa.S_value);
                        int n11 = OS.CFStringGetLength(n10);
                        char[] cArray = new char[n11];
                        CFRange cFRange = new CFRange();
                        cFRange.length = n11;
                        OS.CFStringGetCharacters(n10, cFRange, cArray);
                        CookieValue = new String(cArray);
                        OS.CFRelease(n6);
                        return;
                    }
                    ++n7;
                }
                OS.CFRelease(n6);
            }
        };
        NativeSetCookie = new Runnable(){

            public void run() {
                int n = WebKit.createNSString(CookieUrl);
                int n2 = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, n);
                OS.CFRelease(n);
                int n3 = WebKit.createNSString(CookieValue);
                int n4 = WebKit.createNSString(WebKit.HEADER_SETCOOKIE);
                int n5 = Cocoa.objc_msgSend(Cocoa.C_NSMutableDictionary, Cocoa.S_dictionaryWithCapacity, 1);
                Cocoa.objc_msgSend(n5, Cocoa.S_setValue, n3, n4);
                OS.CFRelease(n4);
                OS.CFRelease(n3);
                int n6 = Cocoa.objc_msgSend(Cocoa.C_NSHTTPCookie, Cocoa.S_cookiesWithResponseHeaderFields, n5, n2);
                if (Cocoa.objc_msgSend(n6, Cocoa.S_count) == 0) {
                    return;
                }
                int n7 = Cocoa.objc_msgSend(n6, Cocoa.S_objectAtIndex, 0);
                int n8 = Cocoa.objc_msgSend(Cocoa.C_NSHTTPCookieStorage, Cocoa.S_sharedHTTPCookieStorage);
                Cocoa.objc_msgSend(n8, Cocoa.S_setCookie, n7);
                CookieResult = true;
            }
        };
        if (NativePendingCookies != null) {
            WebKit.SetPendingCookies(NativePendingCookies);
        }
        NativePendingCookies = null;
    }

    WebKit() {
    }

    public void create(Composite composite, int n) {
        int n2;
        int n3;
        int[] nArray;
        if (OS.VERSION < 4144) {
            this.browser.dispose();
            SWT.error(2);
        }
        int[] nArray2 = new int[1];
        if (OS.VERSION >= 4176) {
            this.webView = Cocoa.objc_msgSend(Cocoa.objc_msgSend(Cocoa.C_WebView, Cocoa.S_alloc), Cocoa.S_initWithFrame_frameName_groupName, new NSRect(), 0, 0);
            if (this.webView != 0) {
                Cocoa.HICocoaViewCreate(this.webView, 0, nArray2);
                this.webViewHandle = nArray2[0];
                Cocoa.objc_msgSend(this.webView, Cocoa.S_release);
            }
        } else {
            Cocoa.HIWebViewCreate(nArray2);
            this.webViewHandle = nArray2[0];
            if (this.webViewHandle != 0) {
                this.webView = Cocoa.HIWebViewGetWebView(this.webViewHandle);
            }
        }
        if (this.webViewHandle == 0) {
            this.browser.dispose();
            SWT.error(2);
        }
        Display display = this.browser.getDisplay();
        display.setData(ADD_WIDGET_KEY, new Object[]{new Integer(this.webViewHandle), this.browser});
        if (OS.VERSION >= 4160) {
            this.browser.setData(WEBKIT_EVENTS_FIX_KEY);
        }
        if (display.getData(BROWSER_WINDOW) == null) {
            Rect rect = new Rect();
            OS.SetRect(rect, (short)0, (short)0, (short)1, (short)1);
            nArray = new int[1];
            OS.CreateNewWindow(14, 0, rect, nArray);
            OS.ShowWindow(nArray[0]);
            OS.HIObjectSetAccessibilityIgnored(nArray[0], true);
            display.disposeExec(new Runnable(){

                public void run() {
                    if (nArray[0] != 0) {
                        OS.DisposeWindow(nArray[0]);
                    }
                    nArray[0] = 0;
                }
            });
            display.setData(BROWSER_WINDOW, nArray);
        }
        int n4 = OS.GetControlOwner(this.browser.handle);
        nArray = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(n4), OS.kHIViewWindowContentID(), nArray);
        OS.HIViewAddSubview(nArray[0], this.webViewHandle);
        OS.HIViewChangeFeatures(this.webViewHandle, 0x2000000, 0);
        OS.HIViewSetVisible(this.webViewHandle, true);
        if (this.browser.getShell().isVisible()) {
            int[] nArray3 = new int[1];
            OS.CreateEvent(0, 2003398244, 24, 0.0, 1, nArray3);
            OS.SetEventParameter(nArray3[0], 0x2D2D2D2D, 2003398244, 4, new int[]{OS.GetControlOwner(this.browser.handle)});
            OS.SendEventToEventTarget(nArray3[0], OS.GetWindowEventTarget(n4));
            if (nArray3[0] != 0) {
                OS.ReleaseEvent(nArray3[0]);
            }
        }
        final int n5 = Cocoa.objc_msgSend(Cocoa.C_NSNotificationCenter, Cocoa.S_defaultCenter);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (WebKit.this.ignoreDispose) {
                            WebKit.this.ignoreDispose = false;
                            break;
                        }
                        WebKit.this.ignoreDispose = true;
                        WebKit.this.browser.notifyListeners(event.type, event);
                        event.type = 0;
                        if (!WebKit.this.browser.isClosing && !WebKit.this.browser.isDisposed()) {
                            WebKit.this.close(false);
                        }
                        OS.RemoveEventHandler(WebKit.this.windowBoundsHandler);
                        WebKit.this.windowBoundsHandler = 0;
                        Object[] objectArray = new Object[2];
                        objectArray[0] = new Integer(WebKit.this.webViewHandle);
                        event.display.setData(WebKit.ADD_WIDGET_KEY, objectArray);
                        Cocoa.objc_msgSend(WebKit.this.webView, Cocoa.S_setFrameLoadDelegate, 0);
                        Cocoa.objc_msgSend(WebKit.this.webView, Cocoa.S_setResourceLoadDelegate, 0);
                        Cocoa.objc_msgSend(WebKit.this.webView, Cocoa.S_setUIDelegate, 0);
                        Cocoa.objc_msgSend(WebKit.this.webView, Cocoa.S_setPolicyDelegate, 0);
                        Cocoa.objc_msgSend(WebKit.this.webView, Cocoa.S_setDownloadDelegate, 0);
                        Cocoa.objc_msgSend(n5, Cocoa.S_removeObserver, WebKit.this.delegate);
                        Cocoa.objc_msgSend(WebKit.this.delegate, Cocoa.S_release);
                        OS.DisposeControl(WebKit.this.webViewHandle);
                        WebKit.this.webViewHandle = 0;
                        WebKit.this.webView = 0;
                        WebKit.this.html = null;
                        WebKit.this.lastNavigateURL = null;
                        WebKit.this.lastHoveredLinkURL = null;
                        Enumeration enumeration = WebKit.this.functions.elements();
                        while (enumeration.hasMoreElements()) {
                            ((BrowserFunction)enumeration.nextElement()).dispose(false);
                        }
                        WebKit.this.functions = null;
                        if (WebKit.this.preferences != 0) {
                            Cocoa.objc_msgSend(WebKit.this.preferences, Cocoa.S_release);
                        }
                        WebKit.this.preferences = 0;
                        break;
                    }
                    case 15: {
                        WebKit.this.hasNewFocusElement = true;
                        OS.SetKeyboardFocus(OS.GetControlOwner(WebKit.this.browser.handle), WebKit.this.webViewHandle, (short)-1);
                    }
                }
            }
        };
        this.browser.addListener(12, listener);
        this.browser.addListener(15, listener);
        this.browser.addListener(1, listener);
        if (Callback3 == null) {
            Callback3 = new Callback(this.getClass(), "eventProc3", 3);
        }
        if ((n3 = Callback3.getAddress()) == 0) {
            SWT.error(3);
        }
        int[] nArray4 = new int[]{1801812322, 1, 1668183148, 4, 1668183148, 17, 1668183148, 11, 1952807028, 2};
        OS.InstallEventHandler(OS.GetControlEventTarget(this.webViewHandle), n3, nArray4.length / 2, nArray4, this.webViewHandle, null);
        int[] nArray5 = new int[]{1668183148, 154, 1668183148, 157, 1668183148, 159};
        OS.InstallEventHandler(OS.GetControlEventTarget(this.browser.handle), n3, nArray5.length / 2, nArray5, this.browser.handle, null);
        int[] nArray6 = new int[]{2003398244, 27};
        int[] nArray7 = new int[1];
        OS.InstallEventHandler(OS.GetWindowEventTarget(n4), n3, nArray6.length / 2, nArray6, this.browser.handle, nArray7);
        this.windowBoundsHandler = nArray7[0];
        if (Callback7 == null) {
            Callback7 = new Callback(this.getClass(), "eventProc7", 7);
        }
        if ((n2 = Callback7.getAddress()) == 0) {
            SWT.error(3);
        }
        this.delegate = Cocoa.objc_msgSend(Cocoa.C_WebKitDelegate, Cocoa.S_alloc);
        this.delegate = Cocoa.objc_msgSend(this.delegate, Cocoa.S_initWithProc, n2, this.webViewHandle);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setFrameLoadDelegate, this.delegate);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setResourceLoadDelegate, this.delegate);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setUIDelegate, this.delegate);
        Cocoa.objc_msgSend(n5, Cocoa.S_addObserver_selector_name_object, this.delegate, Cocoa.S_handleNotification, 0, this.webView);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setPolicyDelegate, this.delegate);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setDownloadDelegate, this.delegate);
        int n6 = WebKit.createNSString(AGENT_STRING);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setApplicationNameForUserAgent, n6);
        OS.CFRelease(n6);
        if (OS.VERSION < 4176 && display.getActiveShell() == this.browser.getShell()) {
            Cocoa.objc_msgSend(Cocoa.objc_msgSend(this.webView, Cocoa.S_window), Cocoa.S_makeKeyWindow);
        }
        if (!Initialized) {
            Initialized = true;
            int n7 = Cocoa.objc_msgSend(Cocoa.C_WebPreferences, Cocoa.S_standardPreferences);
            Cocoa.objc_msgSend(n7, Cocoa.S_setJavaEnabled, 0);
        }
    }

    static int eventProc3(int n, int n2, int n3) {
        Widget widget = Display.getCurrent().findWidget(n3);
        if (widget instanceof Browser) {
            return ((WebKit)((Browser)widget).webBrowser).handleCallback(n, n2);
        }
        return -9874;
    }

    static int eventProc7(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Widget widget = Display.getCurrent().findWidget(n2);
        if (widget instanceof Browser) {
            return ((WebKit)((Browser)widget).webBrowser).handleCallback(n3, n4, n5, n6, n7);
        }
        return 0;
    }

    static int createNSString(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        return OS.CFStringCreateWithCharacters(0, cArray, n);
    }

    static String getString(int n) {
        int n2 = OS.CFStringGetLength(n);
        char[] cArray = new char[n2];
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        return new String(cArray);
    }

    public boolean back() {
        this.html = null;
        return Cocoa.objc_msgSend(this.webView, Cocoa.S_goBack) != 0;
    }

    public boolean close() {
        return this.close(true);
    }

    boolean close(boolean bl) {
        if (!this.jsEnabled) {
            return true;
        }
        String string = "SWTExecuteTemporaryFunctionCLOSE";
        StringBuffer stringBuffer = new StringBuffer("function ");
        stringBuffer.append(string);
        stringBuffer.append("(win) {\n");
        stringBuffer.append("var fn = win.onbeforeunload; if (fn != null) {try {var str = fn(); ");
        if (bl) {
            stringBuffer.append("if (str != null) { ");
            stringBuffer.append("var result = window.external.callRunBeforeUnloadConfirmPanelWithMessage(str);");
            stringBuffer.append("if (!result) return false;}");
        }
        stringBuffer.append("} catch (e) {}}");
        stringBuffer.append("try {for (var i = 0; i < win.frames.length; i++) {var result = ");
        stringBuffer.append(string);
        stringBuffer.append("(win.frames[i]); if (!result) return false;}} catch (e) {} return true;");
        stringBuffer.append("\n};");
        this.execute(stringBuffer.toString());
        Boolean bl2 = (Boolean)this.evaluate("return " + string + "(window);");
        if (bl2 == null) {
            return false;
        }
        return bl2;
    }

    public boolean execute(String string) {
        int n = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        int n2 = Cocoa.objc_msgSend(n, Cocoa.S_globalContext);
        byte[] byArray = null;
        try {
            byArray = (String.valueOf(string) + '\u0000').getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = (String.valueOf(string) + '\u0000').getBytes();
        }
        int n3 = OS.JSStringCreateWithUTF8CString(byArray);
        try {
            byArray = (String.valueOf(this.getUrl()) + '\u0000').getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = (String.valueOf(this.getUrl()) + '\u0000').getBytes();
        }
        int n4 = OS.JSStringCreateWithUTF8CString(byArray);
        int n5 = OS.JSEvaluateScript(n2, n3, 0, n4, 0, null);
        OS.JSStringRelease(n4);
        OS.JSStringRelease(n3);
        return n5 != 0;
    }

    public boolean forward() {
        this.html = null;
        return Cocoa.objc_msgSend(this.webView, Cocoa.S_goForward) != 0;
    }

    public String getBrowserType() {
        return "webkit";
    }

    public String getText() {
        int n = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        int n2 = Cocoa.objc_msgSend(n, Cocoa.S_dataSource);
        if (n2 == 0) {
            return "";
        }
        int n3 = Cocoa.objc_msgSend(n2, Cocoa.S_representation);
        if (n3 == 0) {
            return "";
        }
        int n4 = Cocoa.objc_msgSend(n3, Cocoa.S_documentSource);
        if (n4 == 0) {
            return "";
        }
        int n5 = OS.CFStringGetLength(n4);
        char[] cArray = new char[n5];
        CFRange cFRange = new CFRange();
        cFRange.length = n5;
        OS.CFStringGetCharacters(n4, cFRange, cArray);
        return new String(cArray);
    }

    public String getUrl() {
        if (this.url.length() == 0) {
            return ABOUT_BLANK;
        }
        return this.url;
    }

    int handleCallback(int n, int n2) {
        int n3 = OS.GetEventKind(n2);
        switch (OS.GetEventClass(n2)) {
            case 1668183148: {
                Object[] objectArray;
                int[] nArray;
                Object object;
                switch (n3) {
                    case 17: {
                        OS.SetEventParameter(n2, 1668047203, 1668047203, 4, new int[]{3});
                        return 0;
                    }
                    case 11: {
                        return 0;
                    }
                    case 4: {
                        if (this.browser.isVisible()) break;
                        return 0;
                    }
                    case 159: {
                        int n4 = OS.GetControlOwner(this.browser.handle);
                        object = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(n4), OS.kHIViewWindowContentID(), object);
                        OS.HIViewAddSubview(object[0], this.webViewHandle);
                        OS.RemoveEventHandler(this.windowBoundsHandler);
                        nArray = new int[]{2003398244, 27};
                        objectArray = new int[1];
                        OS.InstallEventHandler(OS.GetWindowEventTarget(n4), Callback3.getAddress(), nArray.length / 2, nArray, this.browser.handle, objectArray);
                        this.windowBoundsHandler = objectArray[0];
                        break;
                    }
                    case 154: 
                    case 157: {
                        CGRect cGRect = new CGRect();
                        if (!this.browser.isVisible()) {
                            cGRect.y = -16.0f;
                            cGRect.x = -16.0f;
                            cGRect.height = 16.0f;
                            cGRect.width = 16.0f;
                            OS.HIViewSetFrame(this.webViewHandle, cGRect);
                            break;
                        }
                        OS.HIViewGetBounds(this.browser.handle, cGRect);
                        object = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.browser.handle)), OS.kHIViewWindowContentID(), object);
                        OS.HIViewConvertRect(cGRect, this.browser.handle, object[0]);
                        if (cGRect.width <= 16.0f) {
                            cGRect.width = 16.0f;
                        }
                        if (cGRect.height <= 16.0f) {
                            cGRect.height = 16.0f;
                        }
                        OS.HIViewSetFrame(this.webViewHandle, cGRect);
                    }
                }
            }
            case 2003398244: {
                int[] nArray;
                Object object;
                switch (n3) {
                    case 27: {
                        if (!this.browser.isVisible()) break;
                        CGRect cGRect = new CGRect();
                        OS.GetEventParameter(n2, 1869767540, 1751741027, null, 16, null, cGRect);
                        object = new CGRect();
                        OS.GetEventParameter(n2, 1668440948, 1751741027, null, 16, null, (CGRect)object);
                        if (cGRect.height == object.height) break;
                        OS.HIViewGetBounds(this.browser.handle, (CGRect)object);
                        nArray = new int[1];
                        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.browser.handle)), OS.kHIViewWindowContentID(), nArray);
                        OS.HIViewConvertRect((CGRect)object, this.browser.handle, nArray[0]);
                        if (object.width <= 16.0f) {
                            object.width = 16.0f;
                        }
                        if (object.height <= 16.0f) {
                            object.height = 16.0f;
                        }
                        object.x += 1.0f;
                        OS.HIViewSetFrame(this.webViewHandle, (CGRect)object);
                        object.x -= 1.0f;
                        OS.HIViewSetFrame(this.webViewHandle, (CGRect)object);
                    }
                }
            }
            case 1801812322: {
                Object[] objectArray;
                int[] nArray;
                switch (n3) {
                    case 1: {
                        int[] nArray2 = new int[1];
                        int n5 = OS.GetEventParameter(n2, 1802858089, 1970567284, null, 4, nArray2, null);
                        if (n5 == 0 && nArray2[0] != 0) {
                            nArray = new int[1];
                            OS.GetEventParameter(n2, 1802334052, 1835100014, null, 4, null, nArray);
                            objectArray = new char[1];
                            OS.GetEventParameter(n2, 1802858089, 1970567284, null, 2, null, objectArray);
                            if ((nArray[0] & 0x100) != 0) {
                                switch (objectArray[0]) {
                                    case 'v': {
                                        Cocoa.objc_msgSend(this.webView, Cocoa.S_paste);
                                        return 0;
                                    }
                                    case 'c': {
                                        Cocoa.objc_msgSend(this.webView, Cocoa.S_copy);
                                        return 0;
                                    }
                                    case 'x': {
                                        Cocoa.objc_msgSend(this.webView, Cocoa.S_cut);
                                        return 0;
                                    }
                                }
                            }
                        }
                        int n6 = this.webViewHandle;
                        int n7 = OS.HIViewGetSuperview(this.webViewHandle);
                        OS.CFRetain(n6);
                        OS.CFRetain(n7);
                        int n8 = OS.CallNextEventHandler(n, n2);
                        OS.CFRelease(n6);
                        OS.CFRelease(n7);
                        return n8;
                    }
                }
            }
            case 1952807028: {
                switch (n3) {
                    default: 
                }
            }
        }
        return -9874;
    }

    int handleCallback(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        switch (n) {
            case 1: {
                this.didFailProvisionalLoadWithError(n2, n3);
                break;
            }
            case 2: {
                this.didFinishLoadForFrame(n2);
                break;
            }
            case 3: {
                this.didReceiveTitle(n2, n3);
                break;
            }
            case 4: {
                this.didStartProvisionalLoadForFrame(n2);
                break;
            }
            case 5: {
                this.didFinishLoadingFromDataSource(n2, n3);
                break;
            }
            case 6: {
                this.didFailLoadingWithError(n2, n3, n4);
                break;
            }
            case 7: {
                n6 = this.identifierForInitialRequest(n2, n3);
                break;
            }
            case 8: {
                n6 = this.willSendRequest(n2, n3, n4, n5);
                break;
            }
            case 9: {
                this.handleNotification(n2);
                break;
            }
            case 10: {
                this.didCommitLoadForFrame(n2);
                break;
            }
            case 11: {
                n6 = this.createWebViewWithRequest(n2);
                break;
            }
            case 12: {
                this.webViewShow(n2);
                break;
            }
            case 13: {
                this.setFrame(n2);
                break;
            }
            case 14: {
                this.webViewClose();
                break;
            }
            case 15: {
                n6 = this.contextMenuItemsForElement(n2, n3);
                break;
            }
            case 16: {
                this.setStatusBarVisible(n2);
                break;
            }
            case 17: {
                this.setResizable(n2);
                break;
            }
            case 18: {
                this.setToolbarsVisible(n2);
                break;
            }
            case 19: {
                this.decidePolicyForMIMEType(n2, n3, n4, n5);
                break;
            }
            case 20: {
                this.decidePolicyForNavigationAction(n2, n3, n4, n5);
                break;
            }
            case 21: {
                this.decidePolicyForNewWindowAction(n2, n3, n4, n5);
                break;
            }
            case 22: {
                this.unableToImplementPolicyWithError(n2, n3);
                break;
            }
            case 23: {
                this.setStatusText(n2);
                break;
            }
            case 24: {
                this.webViewFocus();
                break;
            }
            case 25: {
                this.webViewUnfocus();
                break;
            }
            case 26: {
                this.runJavaScriptAlertPanelWithMessage(n2);
                break;
            }
            case 27: {
                n6 = this.runJavaScriptConfirmPanelWithMessage(n2);
                break;
            }
            case 28: {
                this.runOpenPanelForFileButtonWithResultListener(n2);
                break;
            }
            case 29: {
                this.decideDestinationWithSuggestedFilename(n2, n3);
                break;
            }
            case 30: {
                this.mouseDidMoveOverElement(n2, n3);
                break;
            }
            case 31: {
                this.didChangeLocationWithinPageForFrame(n2);
                break;
            }
            case 32: {
                this.handleEvent(n2);
                break;
            }
            case 33: {
                this.windowScriptObjectAvailable(n2);
                break;
            }
            case 34: {
                n6 = this.callJava(n2, n3, n4, n5);
                break;
            }
            case 35: {
                this.didReceiveAuthenticationChallengefromDataSource(n2, n3, n4);
                break;
            }
            case 36: {
                n6 = this.runBeforeUnloadConfirmPanelWithMessage(n2, n3);
                break;
            }
            case 37: {
                n6 = this.callRunBeforeUnloadConfirmPanelWithMessage(n2, n3);
                break;
            }
            case 38: {
                this.createPanelDidEnd(n2, n3, n4);
            }
        }
        return n6;
    }

    public boolean isBackEnabled() {
        return Cocoa.objc_msgSend(this.webView, Cocoa.S_canGoBack) != 0;
    }

    public boolean isForwardEnabled() {
        return Cocoa.objc_msgSend(this.webView, Cocoa.S_canGoForward) != 0;
    }

    public void refresh() {
        this.html = null;
        Cocoa.objc_msgSend(this.webView, Cocoa.S_reload, 0);
    }

    public boolean setText(String string, boolean bl) {
        boolean bl2 = this.html != null;
        this.html = string;
        boolean bl3 = this.untrustedText = !bl;
        if (bl2) {
            return true;
        }
        int n = WebKit.createNSString(ABOUT_BLANK);
        int n2 = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, n);
        OS.CFRelease(n);
        int n3 = Cocoa.objc_msgSend(Cocoa.C_NSURLRequest, Cocoa.S_requestWithURL, n2);
        int n4 = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        Cocoa.objc_msgSend(n4, Cocoa.S_loadRequest, n3);
        return true;
    }

    public boolean setUrl(String string, String string2, String[] stringArray) {
        int n;
        int n2;
        this.html = null;
        if (string.indexOf(47) == 0) {
            string = PROTOCOL_FILE + string;
        } else if (string.indexOf(58) == -1) {
            string = PROTOCOL_HTTP + string;
        }
        int n3 = 0;
        int n4 = WebKit.createNSString(string);
        if (n4 != 0) {
            char[] cArray = new char[]{'%', '#'};
            n2 = OS.CFStringCreateWithCharacters(0, cArray, cArray.length);
            int n5 = OS.CFURLCreateStringByAddingPercentEscapes(0, n4, n2, 0, 0x8000100);
            if (n5 != 0) {
                n3 = OS.CFURLCreateWithString(0, n5, 0);
                OS.CFRelease(n5);
            }
            if (n2 != 0) {
                OS.CFRelease(n2);
            }
            OS.CFRelease(n4);
        }
        if (n3 == 0) {
            return false;
        }
        int n6 = Cocoa.objc_msgSend(Cocoa.C_NSMutableURLRequest, Cocoa.S_requestWithURL, n3);
        OS.CFRelease(n3);
        if (string2 != null) {
            n2 = WebKit.createNSString(POST);
            Cocoa.objc_msgSend(n6, Cocoa.S_setHTTPMethod, n2);
            OS.CFRelease(n2);
            byte[] byArray = string2.getBytes();
            n = Cocoa.objc_msgSend(Cocoa.C_NSData, Cocoa.S_dataWithBytes, byArray, byArray.length);
            Cocoa.objc_msgSend(n6, Cocoa.S_setHTTPBody, n);
        }
        if (stringArray != null) {
            n2 = 0;
            while (n2 < stringArray.length) {
                String string3 = stringArray[n2];
                if (string3 != null && (n = string3.indexOf(58)) != -1) {
                    String string4 = string3.substring(0, n).trim();
                    String string5 = string3.substring(n + 1).trim();
                    if (string4.length() > 0 && string5.length() > 0) {
                        int n7;
                        if (string4.equalsIgnoreCase(USER_AGENT)) {
                            n7 = WebKit.createNSString(string5);
                            Cocoa.objc_msgSend(this.webView, Cocoa.S_setCustomUserAgent, n7);
                            OS.CFRelease(n7);
                        } else {
                            n7 = WebKit.createNSString(string4);
                            int n8 = WebKit.createNSString(string5);
                            Cocoa.objc_msgSend(n6, Cocoa.S_setValueForHTTPHeaderField, n8, n7);
                            OS.CFRelease(n8);
                            OS.CFRelease(n7);
                        }
                    }
                }
                ++n2;
            }
        }
        n2 = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        Cocoa.objc_msgSend(n2, Cocoa.S_loadRequest, n6);
        Cocoa.objc_msgSend(this.webView, Cocoa.S_setCustomUserAgent, 0);
        return true;
    }

    public void stop() {
        this.html = null;
        Cocoa.objc_msgSend(this.webView, Cocoa.S_stopLoading, 0);
    }

    boolean translateMnemonics() {
        return false;
    }

    void didChangeLocationWithinPageForFrame(int n) {
        int n2;
        TypedEvent typedEvent;
        boolean bl;
        int n3 = Cocoa.objc_msgSend(n, Cocoa.S_dataSource);
        int n4 = Cocoa.objc_msgSend(n3, Cocoa.S_request);
        int n5 = Cocoa.objc_msgSend(n4, Cocoa.S_URL);
        int n6 = Cocoa.objc_msgSend(n5, Cocoa.S_absoluteString);
        int n7 = OS.CFStringGetLength(n6);
        if (n7 == 0) {
            return;
        }
        char[] cArray = new char[n7];
        CFRange cFRange = new CFRange();
        cFRange.length = n7;
        OS.CFStringGetCharacters(n6, cFRange, cArray);
        String string = new String(cArray);
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n7 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n7) == '#') {
                string = ABOUT_BLANK + string.substring(n7);
            }
        }
        Display display = this.browser.getDisplay();
        boolean bl2 = bl = n == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        if (bl) {
            typedEvent = new StatusTextEvent(this.browser);
            typedEvent.display = display;
            typedEvent.widget = this.browser;
            typedEvent.text = string;
            n2 = 0;
            while (n2 < this.statusTextListeners.length) {
                this.statusTextListeners[n2].changed((StatusTextEvent)typedEvent);
                ++n2;
            }
        }
        typedEvent = new LocationEvent(this.browser);
        ((LocationEvent)typedEvent).display = display;
        ((LocationEvent)typedEvent).widget = this.browser;
        ((LocationEvent)typedEvent).location = string;
        ((LocationEvent)typedEvent).top = bl;
        n2 = 0;
        while (n2 < this.locationListeners.length) {
            this.locationListeners[n2].changed((LocationEvent)typedEvent);
            ++n2;
        }
    }

    void didFailProvisionalLoadWithError(int n, int n2) {
        Object object;
        Object object2;
        int n3;
        int n4;
        if (n2 == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame)) {
            this.identifier = 0;
        }
        if (-1000 < (n4 = Cocoa.objc_msgSend(n, Cocoa.S_code))) {
            return;
        }
        int n5 = 0;
        int n6 = Cocoa.objc_msgSend(n, Cocoa.S_userInfo);
        if (n6 != 0) {
            n3 = WebKit.createNSString("NSErrorFailingURLKey");
            n5 = Cocoa.objc_msgSend(n6, Cocoa.S_valueForKey, n3);
            OS.CFRelease(n3);
        }
        if (n5 != 0 && -1204 <= n4 && n4 <= -1200) {
            n3 = WebKit.createNSString("NSErrorPeerCertificateChainKey");
            int n7 = Cocoa.objc_msgSend(n6, Cocoa.S_objectForKey, n3);
            OS.CFRelease(n3);
            object2 = new int[1];
            object = new int[1];
            int[] nArray = new int[1];
            boolean bl = false;
            int n8 = OS.SecPolicySearchCreate(3, 0, 0, (int[])object2);
            if (n8 == 0 && object2[0] != false && (n8 = OS.SecPolicySearchCopyNext((int)object2[0], (int[])object)) == 0 && object[0] != false && (n8 = OS.SecTrustCreateWithCertificates(n7, (int)object[0], nArray)) == 0 && nArray[0] != 0) {
                int n9 = Cocoa.objc_msgSend(Cocoa.C_SFCertificateTrustPanel, Cocoa.S_sharedCertificateTrustPanel);
                String string = WebKit.getString(Cocoa.objc_msgSend(n5, Cocoa.S_absoluteString));
                String string2 = Compatibility.getMessage("SWT_InvalidCert_Message", new Object[]{string});
                int n10 = WebKit.createNSString(Compatibility.getMessage("SWT_Cancel"));
                Cocoa.objc_msgSend(n9, Cocoa.S_setAlternateButtonTitle, n10);
                OS.CFRelease(n10);
                Cocoa.objc_msgSend(n9, Cocoa.S_setShowsHelp, 1);
                Cocoa.objc_msgSend(n5, Cocoa.S_retain);
                int n11 = Cocoa.objc_msgSend(this.webView, Cocoa.S_window);
                n10 = WebKit.createNSString(string2);
                Cocoa.objc_msgSend(n9, Cocoa.S_beginSheetForWindow, n11, this.delegate, Cocoa.S_createPanelDidEnd, n5, nArray[0], n10);
                OS.CFRelease(n10);
                bl = true;
            }
            if (nArray[0] != 0) {
                OS.CFRelease(nArray[0]);
            }
            if (object[0] != false) {
                OS.CFRelease((int)object[0]);
            }
            if (object2[0] != false) {
                OS.CFRelease((int)object2[0]);
            }
            if (bl) {
                return;
            }
        }
        if ((n3 = Cocoa.objc_msgSend(n, Cocoa.S_localizedDescription)) != 0) {
            String string = WebKit.getString(n3);
            object2 = n5 != 0 ? String.valueOf(WebKit.getString(Cocoa.objc_msgSend(n5, Cocoa.S_absoluteString))) + "\n\n" : "";
            object2 = String.valueOf(object2) + Compatibility.getMessage("SWT_Page_Load_Failed", new Object[]{string});
            object = new MessageBox(this.browser.getShell(), 33);
            ((MessageBox)object).setMessage((String)object2);
            ((MessageBox)object).open();
        }
    }

    void createPanelDidEnd(int n, int n2, int n3) {
        Cocoa.objc_msgSend(n3, Cocoa.S_autorelease);
        if (n2 != 1) {
            return;
        }
        int n4 = Cocoa.class_getClassMethod(Cocoa.C_NSURLRequest, Cocoa.S_setAllowsAnyHTTPSCertificate);
        if (n4 != 0) {
            int n5 = Cocoa.objc_msgSend(n3, Cocoa.S_host);
            int n6 = Cocoa.objc_msgSend(n3, Cocoa.S_absoluteString);
            Cocoa.objc_msgSend(Cocoa.C_NSURLRequest, Cocoa.S_setAllowsAnyHTTPSCertificate, 1, n5);
            this.setUrl(WebKit.getString(n6), null, null);
        }
    }

    void didFinishLoadForFrame(int n) {
        if (n == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame)) {
            int n2;
            int n3;
            int n4;
            if (this.html != null && this.getUrl().startsWith(ABOUT_BLANK)) {
                this.loadingText = true;
                int n5 = WebKit.createNSString(this.html);
                n4 = this.untrustedText ? WebKit.createNSString(ABOUT_BLANK) : WebKit.createNSString(URI_FILEROOT);
                n3 = Cocoa.objc_msgSend(Cocoa.C_NSURL, Cocoa.S_URLWithString, n4);
                n2 = Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
                Cocoa.objc_msgSend(n2, Cocoa.S_loadHTMLStringBaseURL, n5, n3);
                OS.CFRelease(n4);
                OS.CFRelease(n5);
                this.html = null;
            }
            if (!this.loadingText) {
                Display display = this.browser.getDisplay();
                n4 = Cocoa.objc_msgSend(n, Cocoa.S_dataSource);
                if (n4 != 0 && (n3 = Cocoa.objc_msgSend(n4, Cocoa.S_pageTitle)) == 0) {
                    TitleEvent titleEvent = new TitleEvent(this.browser);
                    titleEvent.display = display;
                    titleEvent.widget = this.browser;
                    titleEvent.title = this.getUrl();
                    int n6 = 0;
                    while (n6 < this.titleListeners.length) {
                        this.titleListeners[n6].changed(titleEvent);
                        ++n6;
                    }
                    if (this.browser.isDisposed()) {
                        return;
                    }
                }
                ProgressEvent progressEvent = new ProgressEvent(this.browser);
                progressEvent.display = display;
                progressEvent.widget = this.browser;
                progressEvent.current = 100;
                progressEvent.total = 100;
                n2 = 0;
                while (n2 < this.progressListeners.length) {
                    this.progressListeners[n2].completed(progressEvent);
                    ++n2;
                }
            }
            this.loadingText = false;
            if (this.browser.isDisposed()) {
                return;
            }
            this.identifier = 0;
        }
    }

    void hookDOMFocusListeners(int n) {
        if (4160 > OS.VERSION || OS.VERSION >= 4176) {
            return;
        }
        int n2 = Cocoa.objc_msgSend(n, Cocoa.S_DOMDocument);
        if (n2 == 0) {
            return;
        }
        int n3 = WebKit.createNSString(DOMEVENT_FOCUSIN);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n3, this.delegate, 0);
        OS.CFRelease(n3);
        n3 = WebKit.createNSString(DOMEVENT_FOCUSOUT);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n3, this.delegate, 0);
        OS.CFRelease(n3);
    }

    void hookDOMKeyListeners(int n) {
        if (OS.VERSION < 4160) {
            return;
        }
        int n2 = Cocoa.objc_msgSend(n, Cocoa.S_DOMDocument);
        if (n2 == 0) {
            return;
        }
        int n3 = WebKit.createNSString(DOMEVENT_KEYDOWN);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n3, this.delegate, 0);
        OS.CFRelease(n3);
        n3 = WebKit.createNSString(DOMEVENT_KEYUP);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n3, this.delegate, 0);
        OS.CFRelease(n3);
    }

    void hookDOMMouseListeners(int n) {
        if (OS.VERSION < 4160) {
            return;
        }
        int n2 = Cocoa.objc_msgSend(n, Cocoa.S_DOMDocument);
        if (n2 == 0) {
            return;
        }
        int n3 = WebKit.createNSString(DOMEVENT_MOUSEDOWN);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n3, this.delegate, 0);
        OS.CFRelease(n3);
        n3 = WebKit.createNSString(DOMEVENT_MOUSEUP);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n3, this.delegate, 0);
        OS.CFRelease(n3);
        n3 = WebKit.createNSString(DOMEVENT_MOUSEMOVE);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n3, this.delegate, 0);
        OS.CFRelease(n3);
        n3 = WebKit.createNSString(DOMEVENT_MOUSEWHEEL);
        Cocoa.objc_msgSend(n2, Cocoa.S_addEventListener, n3, this.delegate, 0);
        OS.CFRelease(n3);
    }

    void didReceiveTitle(int n, int n2) {
        if (n2 == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame)) {
            int n3 = OS.CFStringGetLength(n);
            char[] cArray = new char[n3];
            CFRange cFRange = new CFRange();
            cFRange.length = n3;
            OS.CFStringGetCharacters(n, cFRange, cArray);
            String string = new String(cArray);
            TitleEvent titleEvent = new TitleEvent(this.browser);
            titleEvent.display = this.browser.getDisplay();
            titleEvent.widget = this.browser;
            titleEvent.title = string;
            int n4 = 0;
            while (n4 < this.titleListeners.length) {
                this.titleListeners[n4].changed(titleEvent);
                ++n4;
            }
        }
    }

    void didStartProvisionalLoadForFrame(int n) {
    }

    void didCommitLoadForFrame(int n) {
        Object object;
        boolean bl;
        int n2 = Cocoa.objc_msgSend(n, Cocoa.S_dataSource);
        int n3 = Cocoa.objc_msgSend(n2, Cocoa.S_request);
        int n4 = Cocoa.objc_msgSend(n3, Cocoa.S_URL);
        int n5 = Cocoa.objc_msgSend(n4, Cocoa.S_absoluteString);
        int n6 = OS.CFStringGetLength(n5);
        if (n6 == 0) {
            return;
        }
        char[] cArray = new char[n6];
        CFRange cFRange = new CFRange();
        cFRange.length = n6;
        OS.CFStringGetCharacters(n5, cFRange, cArray);
        String string = new String(cArray);
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n6 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n6) == '#') {
                string = ABOUT_BLANK + string.substring(n6);
            }
        }
        Display display = this.browser.getDisplay();
        boolean bl2 = bl = n == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame);
        if (bl) {
            Object object2;
            this.resourceCount = 0;
            this.url = string;
            if (string.startsWith(ABOUT_BLANK) && this.html != null) {
                return;
            }
            object = this.functions.elements();
            while (object.hasMoreElements()) {
                object2 = (BrowserFunction)object.nextElement();
                this.execute(((BrowserFunction)object2).functionString);
            }
            object2 = new ProgressEvent(this.browser);
            ((ProgressEvent)object2).display = display;
            ((ProgressEvent)object2).widget = this.browser;
            ((ProgressEvent)object2).current = 1;
            ((ProgressEvent)object2).total = 100;
            int n7 = 0;
            while (n7 < this.progressListeners.length) {
                this.progressListeners[n7].changed((ProgressEvent)object2);
                ++n7;
            }
            if (this.browser.isDisposed()) {
                return;
            }
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = display;
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = string;
            int n8 = 0;
            while (n8 < this.statusTextListeners.length) {
                this.statusTextListeners[n8].changed(statusTextEvent);
                ++n8;
            }
            if (this.browser.isDisposed()) {
                return;
            }
            this.hookDOMKeyListeners(n);
        }
        this.hookDOMFocusListeners(n);
        this.hookDOMMouseListeners(n);
        object = new LocationEvent(this.browser);
        ((LocationEvent)object).display = display;
        ((LocationEvent)object).widget = this.browser;
        ((LocationEvent)object).location = string;
        ((LocationEvent)object).top = bl;
        int n9 = 0;
        while (n9 < this.locationListeners.length) {
            this.locationListeners[n9].changed((LocationEvent)object);
            ++n9;
        }
    }

    void windowScriptObjectAvailable(int n) {
        int n2 = WebKit.createNSString("external");
        if (n2 != 0) {
            Cocoa.objc_msgSend(n, Cocoa.S_setValue, this.delegate, n2);
            OS.CFRelease(n2);
        }
    }

    void didFinishLoadingFromDataSource(int n, int n2) {
    }

    void didFailLoadingWithError(int n, int n2, int n3) {
    }

    void didReceiveAuthenticationChallengefromDataSource(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        String[] stringArray;
        int n8;
        int n9 = Cocoa.objc_msgSend(n2, Cocoa.S_previousFailureCount);
        if (n9 < 3) {
            n8 = 0;
            while (n8 < this.authenticationListeners.length) {
                stringArray = new AuthenticationEvent(this.browser);
                stringArray.location = this.lastNavigateURL;
                this.authenticationListeners[n8].authenticate((AuthenticationEvent)stringArray);
                if (!stringArray.doit) {
                    int n10 = Cocoa.objc_msgSend(n2, Cocoa.S_sender);
                    Cocoa.objc_msgSend(n10, Cocoa.S_cancelAuthenticationChallenge, n2);
                    return;
                }
                if (stringArray.user != null && stringArray.password != null) {
                    int n11 = Cocoa.objc_msgSend(n2, Cocoa.S_sender);
                    int n12 = WebKit.createNSString(stringArray.user);
                    int n13 = WebKit.createNSString(stringArray.password);
                    int n14 = Cocoa.objc_msgSend(Cocoa.C_NSURLCredential, Cocoa.S_credentialWithUser, n12, n13, 1);
                    Cocoa.objc_msgSend(n11, Cocoa.S_useCredential, n14, n2);
                    OS.CFRelease(n13);
                    OS.CFRelease(n12);
                    return;
                }
                ++n8;
            }
        }
        if ((n8 = Cocoa.C_WebPanelAuthenticationHandler) != 0 && (n7 = Cocoa.class_getClassMethod(n8, Cocoa.S_sharedHandler)) != 0 && (n6 = Cocoa.objc_msgSend(n8, Cocoa.S_sharedHandler)) != 0) {
            int n15 = Cocoa.objc_msgSend(this.webView, Cocoa.S_window);
            Cocoa.objc_msgSend(n6, Cocoa.S_startAuthentication, n2, n15);
            return;
        }
        stringArray = new String[1];
        String[] stringArray2 = new String[1];
        int n16 = Cocoa.objc_msgSend(n2, Cocoa.S_proposedCredential);
        if (n16 != 0) {
            n5 = Cocoa.objc_msgSend(n16, Cocoa.S_user);
            stringArray[0] = WebKit.getString(n5);
            int n17 = n4 = Cocoa.objc_msgSend(n16, Cocoa.S_hasPassword) != 0 ? 1 : 0;
            if (n4 != 0) {
                int n18 = Cocoa.objc_msgSend(n16, Cocoa.S_password);
                stringArray2[0] = WebKit.getString(n18);
            }
        }
        n5 = Cocoa.objc_msgSend(n2, Cocoa.S_protectionSpace);
        n4 = Cocoa.objc_msgSend(n5, Cocoa.S_host);
        String string = String.valueOf(WebKit.getString(n4)) + ':';
        int n19 = Cocoa.objc_msgSend(n5, Cocoa.S_port);
        string = String.valueOf(string) + n19;
        int n20 = Cocoa.objc_msgSend(n5, Cocoa.S_realm);
        String string2 = WebKit.getString(n20);
        boolean bl = this.showAuthenticationDialog(stringArray, stringArray2, string, string2);
        int n21 = Cocoa.objc_msgSend(n2, Cocoa.S_sender);
        if (!bl) {
            Cocoa.objc_msgSend(n21, Cocoa.S_cancelAuthenticationChallenge, n2);
            return;
        }
        int n22 = WebKit.createNSString(stringArray[0]);
        int n23 = WebKit.createNSString(stringArray2[0]);
        int n24 = Cocoa.objc_msgSend(Cocoa.C_NSURLCredential, Cocoa.S_credentialWithUser, n22, n23, 1);
        Cocoa.objc_msgSend(n21, Cocoa.S_useCredential, n24, n2);
        OS.CFRelease(n23);
        OS.CFRelease(n22);
    }

    boolean showAuthenticationDialog(final String[] stringArray, final String[] stringArray2, String string, String string2) {
        final Shell shell = new Shell(this.browser.getShell());
        shell.setLayout(new GridLayout());
        String string3 = SWT.getMessage("SWT_Authentication_Required");
        shell.setText(string3);
        Label label = new Label(shell, 64);
        label.setText(Compatibility.getMessage("SWT_Enter_Username_and_Password", new String[]{string2, string}));
        GridData gridData = new GridData();
        Monitor monitor = this.browser.getMonitor();
        int n = monitor.getBounds().width * 2 / 3;
        int n2 = label.computeSize((int)-1, (int)-1).x;
        gridData.widthHint = Math.min(n2, n);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        Label label2 = new Label(shell, 0);
        label2.setText(SWT.getMessage("SWT_Username"));
        final Text text = new Text(shell, 2048);
        if (stringArray[0] != null) {
            text.setText(stringArray[0]);
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData(gridData);
        Label label3 = new Label(shell, 0);
        label3.setText(SWT.getMessage("SWT_Password"));
        final Text text2 = new Text(shell, 0x400800);
        if (stringArray2[0] != null) {
            text2.setText(stringArray2[0]);
        }
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        text2.setLayoutData(gridData);
        final boolean[] blArray = new boolean[1];
        final Button[] buttonArray = new Button[2];
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                stringArray[0] = text.getText();
                stringArray2[0] = text2.getText();
                blArray[0] = event.widget == buttonArray[1];
                shell.close();
            }
        };
        Composite composite = new Composite(shell, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        composite.setLayoutData(gridData);
        composite.setLayout(new GridLayout(2, true));
        buttonArray[0] = new Button(composite, 8);
        buttonArray[0].setText(SWT.getMessage("SWT_Cancel"));
        buttonArray[0].setLayoutData(new GridData(768));
        buttonArray[0].addListener(13, listener);
        buttonArray[1] = new Button(composite, 8);
        buttonArray[1].setText(SWT.getMessage("SWT_OK"));
        buttonArray[1].setLayoutData(new GridData(768));
        buttonArray[1].addListener(13, listener);
        shell.setDefaultButton(buttonArray[1]);
        shell.pack();
        shell.open();
        Display display = this.browser.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return blArray[0];
    }

    int identifierForInitialRequest(int n, int n2) {
        int n3;
        Display display = this.browser.getDisplay();
        ProgressEvent progressEvent = new ProgressEvent(this.browser);
        progressEvent.display = display;
        progressEvent.widget = this.browser;
        progressEvent.current = this.resourceCount;
        progressEvent.total = Math.max(this.resourceCount, 100);
        int n4 = 0;
        while (n4 < this.progressListeners.length) {
            this.progressListeners[n4].changed(progressEvent);
            ++n4;
        }
        if (this.browser.isDisposed()) {
            return 0;
        }
        n4 = Cocoa.objc_msgSend(Cocoa.C_NSNumber, Cocoa.S_numberWithInt, this.resourceCount++);
        if (this.identifier == 0 && (n3 = Cocoa.objc_msgSend(n2, Cocoa.S_webFrame)) == Cocoa.objc_msgSend(this.webView, Cocoa.S_mainFrame)) {
            this.identifier = n4;
        }
        return n4;
    }

    int willSendRequest(int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = Cocoa.objc_msgSend(n2, Cocoa.S_URL);
        boolean bl2 = bl = Cocoa.objc_msgSend(n5, Cocoa.S_isFileURL) != 0;
        if (bl) {
            int n6 = Cocoa.objc_msgSend(n2, Cocoa.S_mutableCopy);
            Cocoa.objc_msgSend(n6, Cocoa.S_autorelease);
            Cocoa.objc_msgSend(n6, Cocoa.S_setCachePolicy, 1);
            return n6;
        }
        return n2;
    }

    void handleNotification(int n) {
    }

    int createWebViewWithRequest(int n) {
        int n2;
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        windowEvent.required = true;
        if (this.openWindowListeners != null) {
            n2 = 0;
            while (n2 < this.openWindowListeners.length) {
                this.openWindowListeners[n2].open(windowEvent);
                ++n2;
            }
        }
        n2 = 0;
        Widget widget = null;
        if (windowEvent.browser != null && windowEvent.browser.webBrowser instanceof WebKit) {
            widget = windowEvent.browser;
        }
        if (widget != null && !widget.isDisposed()) {
            n2 = ((WebKit)((Browser)widget).webBrowser).webView;
            if (n != 0) {
                int n3 = Cocoa.objc_msgSend(n2, Cocoa.S_mainFrame);
                Cocoa.objc_msgSend(n3, Cocoa.S_loadRequest, n);
            }
        }
        return n2;
    }

    void webViewShow(int n) {
        Shell shell = this.browser.getShell();
        org.eclipse.swt.graphics.Point point = shell.getSize();
        shell.setSize(point.x + 1, point.y);
        shell.setSize(point.x, point.y);
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        if (this.location != null) {
            windowEvent.location = this.location;
        }
        if (this.size != null) {
            windowEvent.size = this.size;
        }
        windowEvent.addressBar = this.toolBar;
        windowEvent.menuBar = true;
        windowEvent.statusBar = this.statusBar;
        windowEvent.toolBar = this.toolBar;
        int n2 = 0;
        while (n2 < this.visibilityWindowListeners.length) {
            this.visibilityWindowListeners[n2].show(windowEvent);
            ++n2;
        }
        this.location = null;
        this.size = null;
    }

    void setFrame(int n) {
        float[] fArray = new float[4];
        OS.memmove(fArray, n, 16);
        Rectangle rectangle = this.browser.getDisplay().getBounds();
        this.location = new org.eclipse.swt.graphics.Point((int)fArray[0], rectangle.height - (int)fArray[1] - (int)fArray[3]);
        this.size = new org.eclipse.swt.graphics.Point((int)fArray[2], (int)fArray[3]);
    }

    void webViewFocus() {
    }

    void webViewUnfocus() {
    }

    int callRunBeforeUnloadConfirmPanelWithMessage(int n, int n2) {
        int n3 = this.runBeforeUnloadConfirmPanelWithMessage(n, 0);
        return Cocoa.objc_msgSend(Cocoa.C_NSNumber, Cocoa.S_numberWithBool, n3);
    }

    int runBeforeUnloadConfirmPanelWithMessage(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(Compatibility.getMessage("SWT_OnBeforeUnload_Message1"));
        stringBuffer.append("\n\n");
        int n3 = OS.CFStringGetLength(n);
        char[] cArray = new char[n3];
        CFRange cFRange = new CFRange();
        cFRange.length = n3;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        stringBuffer.append(new String(cArray));
        stringBuffer.append("\n\n");
        stringBuffer.append(Compatibility.getMessage("SWT_OnBeforeUnload_Message2"));
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 292);
        messageBox.setMessage(stringBuffer.toString());
        return messageBox.open() == 32 ? 1 : 0;
    }

    void runJavaScriptAlertPanelWithMessage(int n) {
        int n2 = OS.CFStringGetLength(n);
        char[] cArray = new char[n2];
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        String string = new String(cArray);
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 40);
        messageBox.setText("Javascript");
        messageBox.setMessage(string);
        messageBox.open();
    }

    int runJavaScriptConfirmPanelWithMessage(int n) {
        int n2 = OS.CFStringGetLength(n);
        char[] cArray = new char[n2];
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        String string = new String(cArray);
        MessageBox messageBox = new MessageBox(this.browser.getShell(), 292);
        messageBox.setText("Javascript");
        messageBox.setMessage(string);
        return messageBox.open() == 32 ? 1 : 0;
    }

    void runOpenPanelForFileButtonWithResultListener(int n) {
        FileDialog fileDialog = new FileDialog(this.browser.getShell(), 0);
        String string = fileDialog.open();
        if (string == null) {
            Cocoa.objc_msgSend(n, Cocoa.S_cancel);
            return;
        }
        int n2 = WebKit.createNSString(string);
        Cocoa.objc_msgSend(n, Cocoa.S_chooseFilename, n2);
        OS.CFRelease(n2);
    }

    void webViewClose() {
        Shell shell = this.browser.getShell();
        WindowEvent windowEvent = new WindowEvent(this.browser);
        windowEvent.display = this.browser.getDisplay();
        windowEvent.widget = this.browser;
        int n = 0;
        while (n < this.closeWindowListeners.length) {
            this.closeWindowListeners[n].close(windowEvent);
            ++n;
        }
        this.browser.dispose();
        if (shell.isDisposed()) {
            return;
        }
        org.eclipse.swt.graphics.Point point = shell.getSize();
        shell.setSize(point.x + 1, point.y);
        shell.setSize(point.x, point.y);
    }

    int contextMenuItemsForElement(int n, int n2) {
        Point point = new Point();
        OS.GetGlobalMouse(point);
        Event event = new Event();
        event.x = point.h;
        event.y = point.v;
        this.browser.notifyListeners(35, event);
        if (!event.doit || this.browser.isDisposed()) {
            return 0;
        }
        Menu menu = this.browser.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (event.x != point.h || event.y != point.v) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return 0;
        }
        return n2;
    }

    void setStatusBarVisible(int n) {
        this.statusBar = n != 0;
    }

    void setStatusText(int n) {
        int n2 = OS.CFStringGetLength(n);
        if (n2 == 0) {
            return;
        }
        char[] cArray = new char[n2];
        CFRange cFRange = new CFRange();
        cFRange.length = n2;
        OS.CFStringGetCharacters(n, cFRange, cArray);
        StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
        statusTextEvent.display = this.browser.getDisplay();
        statusTextEvent.widget = this.browser;
        statusTextEvent.text = new String(cArray);
        int n3 = 0;
        while (n3 < this.statusTextListeners.length) {
            this.statusTextListeners[n3].changed(statusTextEvent);
            ++n3;
        }
    }

    void setResizable(int n) {
    }

    void setToolbarsVisible(int n) {
        this.toolBar = n != 0;
    }

    void mouseDidMoveOverElement(int n, int n2) {
        Object object;
        String string;
        if (n == 0) {
            return;
        }
        if (!this.browser.isEnabled()) {
            return;
        }
        int n3 = WebKit.createNSString(WebElementLinkURLKey);
        int n4 = Cocoa.objc_msgSend(n, Cocoa.S_valueForKey, n3);
        OS.CFRelease(n3);
        if (n4 == 0) {
            if (this.lastHoveredLinkURL == null) {
                return;
            }
            this.lastHoveredLinkURL = null;
            StatusTextEvent statusTextEvent = new StatusTextEvent(this.browser);
            statusTextEvent.display = this.browser.getDisplay();
            statusTextEvent.widget = this.browser;
            statusTextEvent.text = "";
            int n5 = 0;
            while (n5 < this.statusTextListeners.length) {
                this.statusTextListeners[n5].changed(statusTextEvent);
                ++n5;
            }
            return;
        }
        int n6 = Cocoa.objc_msgSend(n4, Cocoa.S_absoluteString);
        int n7 = OS.CFStringGetLength(n6);
        if (n7 == 0) {
            string = "";
        } else {
            object = new char[n7];
            CFRange cFRange = new CFRange();
            cFRange.length = n7;
            OS.CFStringGetCharacters(n6, cFRange, object);
            string = new String((char[])object);
        }
        if (string.equals(this.lastHoveredLinkURL)) {
            return;
        }
        this.lastHoveredLinkURL = string;
        object = new StatusTextEvent(this.browser);
        object.display = this.browser.getDisplay();
        object.widget = this.browser;
        object.text = string;
        int n8 = 0;
        while (n8 < this.statusTextListeners.length) {
            this.statusTextListeners[n8].changed((StatusTextEvent)object);
            ++n8;
        }
    }

    void decidePolicyForMIMEType(int n, int n2, int n3, int n4) {
        boolean bl = Cocoa.objc_msgSend(Cocoa.C_WebView, Cocoa.S_canShowMIMEType, n) != 0;
        Cocoa.objc_msgSend(n4, bl ? Cocoa.S_use : Cocoa.S_download);
    }

    void decidePolicyForNavigationAction(int n, int n2, int n3, int n4) {
        boolean bl;
        int n5 = Cocoa.objc_msgSend(n2, Cocoa.S_URL);
        if (this.loadingText) {
            Cocoa.objc_msgSend(n4, Cocoa.S_use);
            return;
        }
        if (n5 == 0) {
            Cocoa.objc_msgSend(n4, Cocoa.S_ignore);
            return;
        }
        boolean bl2 = bl = Cocoa.objc_msgSend(n5, Cocoa.S_isFileURL) != 0;
        if (bl && this.getUrl().startsWith(ABOUT_BLANK) && this.untrustedText) {
            Cocoa.objc_msgSend(n4, Cocoa.S_ignore);
            return;
        }
        int n6 = Cocoa.objc_msgSend(n5, Cocoa.S_absoluteString);
        int n7 = OS.CFStringGetLength(n6);
        char[] cArray = new char[n7];
        CFRange cFRange = new CFRange();
        cFRange.length = n7;
        OS.CFStringGetCharacters(n6, cFRange, cArray);
        String string = new String(cArray);
        if (string.equals(URI_FILEROOT)) {
            string = ABOUT_BLANK;
        } else {
            n7 = URI_FILEROOT.length();
            if (string.startsWith(URI_FILEROOT) && string.charAt(n7) == '#') {
                string = ABOUT_BLANK + string.substring(n7);
            }
        }
        if (string.startsWith(URI_APPLEWEBDATA)) {
            Cocoa.objc_msgSend(n4, Cocoa.S_use);
        } else {
            LocationEvent locationEvent = new LocationEvent(this.browser);
            locationEvent.display = this.browser.getDisplay();
            locationEvent.widget = this.browser;
            locationEvent.location = string;
            locationEvent.doit = true;
            if (this.locationListeners != null) {
                int n8 = 0;
                while (n8 < this.locationListeners.length) {
                    this.locationListeners[n8].changing(locationEvent);
                    ++n8;
                }
            }
            if (locationEvent.doit) {
                if (this.jsEnabledChanged) {
                    this.jsEnabledChanged = false;
                    if (this.preferences == 0) {
                        this.preferences = Cocoa.objc_msgSend(Cocoa.C_WebPreferences, Cocoa.S_alloc);
                        Cocoa.objc_msgSend(this.preferences, Cocoa.S_init);
                        Cocoa.objc_msgSend(this.webView, Cocoa.S_setPreferences, this.preferences);
                    }
                    Cocoa.objc_msgSend(this.preferences, Cocoa.S_setJavaScriptEnabled, this.jsEnabled ? 1 : 0);
                }
                this.lastNavigateURL = string;
            }
            Cocoa.objc_msgSend(n4, locationEvent.doit ? Cocoa.S_use : Cocoa.S_ignore);
        }
    }

    void decidePolicyForNewWindowAction(int n, int n2, int n3, int n4) {
        Cocoa.objc_msgSend(n4, Cocoa.S_use);
    }

    void unableToImplementPolicyWithError(int n, int n2) {
    }

    void decideDestinationWithSuggestedFilename(int n, int n2) {
        int n3 = OS.CFStringGetLength(n2);
        char[] cArray = new char[n3];
        CFRange cFRange = new CFRange();
        cFRange.length = n3;
        OS.CFStringGetCharacters(n2, cFRange, cArray);
        String string = new String(cArray);
        String string2 = null;
        if (OS.VERSION >= 4181) {
            int n4 = Cocoa.NSSearchPathForDirectoriesInDomains(12, 65535, true);
            int n5 = Cocoa.objc_msgSend(n4, Cocoa.S_count);
            if (n5 == 0 && (n5 = Cocoa.objc_msgSend(n4 = Cocoa.NSSearchPathForDirectoriesInDomains(15, 65535, true), Cocoa.S_count)) == 0 && (n5 = Cocoa.objc_msgSend(n4 = Cocoa.NSSearchPathForDirectoriesInDomains(9, 65535, true), Cocoa.S_count)) == 0) {
                Cocoa.objc_msgSend(n, Cocoa.S_cancel);
                return;
            }
            int n6 = Cocoa.objc_msgSend(n4, Cocoa.S_objectAtIndex, 0);
            n3 = OS.CFStringGetLength(n6);
            cArray = new char[n3];
            cFRange = new CFRange();
            cFRange.length = n3;
            OS.CFStringGetCharacters(n6, cFRange, cArray);
            string2 = String.valueOf(new String(cArray)) + '/' + string;
        } else {
            FileDialog fileDialog = new FileDialog(this.browser.getShell(), 8192);
            fileDialog.setText(SWT.getMessage("SWT_FileDownload"));
            fileDialog.setFileName(string);
            string2 = fileDialog.open();
        }
        if (string2 == null) {
            Cocoa.objc_msgSend(n, Cocoa.S_cancel);
            return;
        }
        int n7 = WebKit.createNSString(string2);
        Cocoa.objc_msgSend(n, Cocoa.S_setDestinationAllowOverwrite, n7, 1);
        OS.CFRelease(n7);
    }

    void handleEvent(int n) {
        int n2;
        boolean bl;
        if (!this.browser.isEnabled()) {
            return;
        }
        int n3 = Cocoa.objc_msgSend(n, Cocoa.S_type);
        int n4 = OS.CFStringGetLength(n3);
        char[] cArray = new char[n4];
        CFRange cFRange = new CFRange();
        cFRange.length = n4;
        OS.CFStringGetCharacters(n3, cFRange, cArray);
        String string = new String(cArray);
        if (string.equals(DOMEVENT_FOCUSIN)) {
            this.hasNewFocusElement = true;
            return;
        }
        if (string.equals(DOMEVENT_FOCUSOUT)) {
            this.hasNewFocusElement = false;
            return;
        }
        boolean bl2 = Cocoa.objc_msgSend(n, Cocoa.S_ctrlKey) != 0;
        boolean bl3 = Cocoa.objc_msgSend(n, Cocoa.S_shiftKey) != 0;
        boolean bl4 = Cocoa.objc_msgSend(n, Cocoa.S_altKey) != 0;
        boolean bl5 = bl = Cocoa.objc_msgSend(n, Cocoa.S_metaKey) != 0;
        if (DOMEVENT_KEYDOWN.equals(string) || DOMEVENT_KEYUP.equals(string)) {
            boolean bl6;
            int n5 = Cocoa.objc_msgSend(n, Cocoa.S_keyCode);
            int n6 = Cocoa.objc_msgSend(n, Cocoa.S_charCode);
            Event event = new Event();
            event.widget = this.browser;
            event.type = DOMEVENT_KEYDOWN.equals(string) ? 1 : 2;
            event.keyCode = this.translateKey(n5);
            event.character = event.keyCode == 127 ? (char)127 : (char)n6;
            event.stateMask = (bl4 ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl ? 0x400000 : 0);
            if (event.type == 1) {
                bl6 = this.sendKeyEvent(event);
            } else {
                this.browser.notifyListeners(event.type, event);
                bl6 = event.doit;
            }
            if (this.browser.isDisposed()) {
                Cocoa.objc_msgSend(n, Cocoa.S_preventDefault);
                return;
            }
            if (bl6 && OS.VERSION < 4176 && event.keyCode == 9 && (event.stateMask & 0x20000) != 0) {
                bl6 = false;
            }
            if (!bl6) {
                Cocoa.objc_msgSend(n, Cocoa.S_preventDefault);
            } else if (!this.hasNewFocusElement && event.keyCode == 9 && DOMEVENT_KEYUP.equals(string)) {
                this.hasNewFocusElement = false;
            }
            return;
        }
        int n7 = Cocoa.objc_msgSend(n, Cocoa.S_screenX);
        int n8 = Cocoa.objc_msgSend(n, Cocoa.S_screenY);
        org.eclipse.swt.graphics.Point point = new org.eclipse.swt.graphics.Point(n7, n8);
        point = this.browser.getDisplay().map(null, (Control)this.browser, point);
        int n9 = Cocoa.objc_msgSend(n, Cocoa.S_detail);
        Event event = new Event();
        event.widget = this.browser;
        event.x = point.x;
        event.y = point.y;
        event.stateMask = (bl4 ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl ? 0x400000 : 0);
        if (DOMEVENT_MOUSEDOWN.equals(string)) {
            event.type = 3;
            n2 = Cocoa.objc_msgSend(n, Cocoa.S_button);
            event.button = n2 + 1;
            event.count = n9;
        } else if (DOMEVENT_MOUSEUP.equals(string)) {
            event.type = 4;
            n2 = Cocoa.objc_msgSend(n, Cocoa.S_button);
            event.button = n2 + 1;
            event.count = n9;
            switch (event.button) {
                case 1: {
                    event.stateMask |= 0x80000;
                    break;
                }
                case 2: {
                    event.stateMask |= 0x100000;
                    break;
                }
                case 3: {
                    event.stateMask |= 0x200000;
                    break;
                }
                case 4: {
                    event.stateMask |= 0x800000;
                    break;
                }
                case 5: {
                    event.stateMask |= 0x2000000;
                }
            }
        } else if (DOMEVENT_MOUSEMOVE.equals(string)) {
            if (event.x == this.lastMouseMoveX && event.y == this.lastMouseMoveY) {
                return;
            }
            event.type = 5;
            this.lastMouseMoveX = event.x;
            this.lastMouseMoveY = event.y;
        } else if (DOMEVENT_MOUSEWHEEL.equals(string)) {
            event.type = 37;
            n2 = Cocoa.objc_msgSend(n, Cocoa.S_wheelDelta);
            event.count = n2 / 120;
        }
        this.browser.notifyListeners(event.type, event);
        if (this.browser.isDisposed()) {
            return;
        }
        if (n9 == 2 && DOMEVENT_MOUSEDOWN.equals(string)) {
            n2 = Cocoa.objc_msgSend(n, Cocoa.S_button);
            event = new Event();
            event.widget = this.browser;
            event.x = point.x;
            event.y = point.y;
            event.stateMask = (bl4 ? 65536 : 0) | (bl2 ? 262144 : 0) | (bl3 ? 131072 : 0) | (bl ? 0x400000 : 0);
            event.type = 8;
            event.button = n2 + 1;
            event.count = n9;
            this.browser.notifyListeners(event.type, event);
        }
    }

    Object convertToJava(int n) {
        int n2;
        if (Cocoa.objc_msgSend(n, Cocoa.S_isKindOfClass, Cocoa.C_NSString) != 0) {
            int n3 = Cocoa.objc_msgSend(n, Cocoa.S_length);
            char[] cArray = new char[n3];
            Cocoa.objc_msgSend(n, Cocoa.S_getCharacters_, cArray);
            return new String(cArray);
        }
        if (Cocoa.objc_msgSend(n, Cocoa.S_isKindOfClass, Cocoa.C_NSNumber) != 0) {
            n2 = Cocoa.objc_msgSend(n, Cocoa.S_objCType);
            byte[] byArray = new byte[1];
            OS.memmove(byArray, n2, 1);
            if (byArray[0] == 99 || byArray[0] == 66) {
                int n4 = Cocoa.objc_msgSend(n, Cocoa.S_boolValue);
                return new Boolean(n4 != 0);
            }
            if ("islqISLQfd".indexOf(byArray[0]) != -1) {
                double d = Cocoa.objc_msgSend_fpret(n, Cocoa.S_doubleValue);
                return new Double(d);
            }
        }
        if (Cocoa.objc_msgSend(n, Cocoa.S_isKindOfClass, Cocoa.C_WebScriptObject) != 0) {
            n2 = WebKit.createNSString("length");
            int n5 = Cocoa.objc_msgSend(n, Cocoa.S_valueForKey, n2);
            OS.CFRelease(n2);
            int n6 = Cocoa.objc_msgSend(n5, Cocoa.S_intValue);
            Object[] objectArray = new Object[n6];
            int n7 = 0;
            while (n7 < n6) {
                int n8 = Cocoa.objc_msgSend(n, Cocoa.S_webScriptValueAtIndex, n7);
                if (n8 != 0) {
                    objectArray[n7] = this.convertToJava(n8);
                }
                ++n7;
            }
            return objectArray;
        }
        if (Cocoa.objc_msgSend(n, Cocoa.S_isKindOfClass, Cocoa.C_WebUndefined) != 0) {
            return null;
        }
        SWT.error(5);
        return null;
    }

    int convertToJS(Object object) {
        if (object == null) {
            return Cocoa.objc_msgSend(Cocoa.C_WebUndefined, Cocoa.S_undefined);
        }
        if (object instanceof String) {
            return WebKit.createNSString((String)object);
        }
        if (object instanceof Boolean) {
            int n = (Boolean)object != false ? 1 : 0;
            return Cocoa.objc_msgSend(Cocoa.C_NSNumber, Cocoa.S_numberWithBool, n);
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            return Cocoa.objc_msgSend(Cocoa.C_NSNumber, Cocoa.S_numberWithDouble, d);
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = Cocoa.objc_msgSend(Cocoa.C_NSMutableArray, Cocoa.S_arrayWithCapacity, n);
            int n3 = 0;
            while (n3 < n) {
                Object object2 = objectArray[n3];
                int n4 = this.convertToJS(object2);
                Cocoa.objc_msgSend(n2, Cocoa.S_addObject, n4);
                ++n3;
            }
            return n2;
        }
        SWT.error(51);
        return 0;
    }

    int callJava(int n, int n2, int n3, int n4) {
        Object object = null;
        if (Cocoa.objc_msgSend(n, Cocoa.S_isKindOfClass, Cocoa.C_NSNumber) != 0) {
            int n5 = Cocoa.objc_msgSend(n, Cocoa.S_intValue);
            if (Cocoa.objc_msgSend(n2, Cocoa.S_isKindOfClass, Cocoa.C_NSNumber) != 0) {
                long l = (long)Cocoa.objc_msgSend_fpret(n2, Cocoa.S_doubleValue);
                Integer n6 = new Integer(n5);
                BrowserFunction browserFunction = (BrowserFunction)this.functions.get(n6);
                if (browserFunction != null && l == browserFunction.token) {
                    try {
                        Object object2 = this.convertToJava(n3);
                        if (object2 instanceof Object[]) {
                            Object[] objectArray = (Object[])object2;
                            try {
                                object = browserFunction.function(objectArray);
                            }
                            catch (Exception exception) {
                                object = WebBrowser.CreateErrorString(exception.getLocalizedMessage());
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if (browserFunction.isEvaluate) {
                            browserFunction.function(new String[]{WebBrowser.CreateErrorString(new SWTException(51).getLocalizedMessage())});
                        }
                        object = WebBrowser.CreateErrorString(illegalArgumentException.getLocalizedMessage());
                    }
                }
            }
        }
        try {
            return this.convertToJS(object);
        }
        catch (SWTException sWTException) {
            return this.convertToJS(WebBrowser.CreateErrorString(sWTException.getLocalizedMessage()));
        }
    }
}

