/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSFontManager;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.OS;

public final class Font
extends Resource {
    public NSFont handle;
    public int extraTraits;
    FontMetrics metrics = null;
    static final double SYNTHETIC_BOLD = -2.5;
    static final double SYNTHETIC_ITALIC = 0.2;

    Font(Device device) {
        super(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font(Device device, FontData fontData) {
        super(device);
        if (fontData == null) {
            SWT.error(4);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(fontData.getName(), fontData.getHeightF(), fontData.getStyle(), fontData.nsName);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font(Device device, FontData[] fontDataArray) {
        super(device);
        if (fontDataArray == null) {
            SWT.error(4);
        }
        if (fontDataArray.length == 0) {
            SWT.error(5);
        }
        for (int i = 0; i < fontDataArray.length; ++i) {
            if (fontDataArray[i] != null) continue;
            SWT.error(5);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            FontData fontData = fontDataArray[0];
            this.init(fontData.getName(), fontData.getHeightF(), fontData.getStyle(), fontData.nsName);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Font(Device device, String string, int n, int n2) {
        super(device);
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.init(string, n, n2, null);
            this.init();
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    Font(Device device, String string, float f, int n) {
        super(device);
        this.init(string, f, n, null);
        this.init();
    }

    void addTraits(NSMutableAttributedString nSMutableAttributedString, NSRange nSRange) {
        if ((this.extraTraits & 2) != 0) {
            nSMutableAttributedString.addAttribute(OS.NSStrokeWidthAttributeName, NSNumber.numberWithDouble(-2.5), nSRange);
        }
        if ((this.extraTraits & 1) != 0) {
            nSMutableAttributedString.addAttribute(OS.NSObliquenessAttributeName, NSNumber.numberWithDouble(0.2), nSRange);
        }
    }

    void addTraits(NSMutableDictionary nSMutableDictionary) {
        if ((this.extraTraits & 2) != 0) {
            nSMutableDictionary.setObject(NSNumber.numberWithDouble(-2.5), OS.NSStrokeWidthAttributeName);
        }
        if ((this.extraTraits & 1) != 0) {
            nSMutableDictionary.setObject(NSNumber.numberWithDouble(0.2), OS.NSObliquenessAttributeName);
        }
    }

    @Override
    void destroy() {
        this.handle.release();
        this.handle = null;
        this.metrics = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        Font font = (Font)object;
        return this.handle == font.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        NSAutoreleasePool nSAutoreleasePool = null;
        if (!NSThread.isMainThread()) {
            nSAutoreleasePool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSString nSString = this.handle.familyName();
            String string = nSString.getString();
            NSString nSString2 = this.handle.fontName();
            String string2 = nSString2.getString();
            NSFontManager nSFontManager = NSFontManager.sharedFontManager();
            long l = nSFontManager.traitsOfFont(this.handle);
            int n = 0;
            if ((l & 1L) != 0L) {
                n |= 2;
            }
            if ((l & 2L) != 0L) {
                n |= 1;
            }
            if ((this.extraTraits & 1) != 0) {
                n |= 2;
            }
            if ((this.extraTraits & 2) != 0) {
                n |= 1;
            }
            Point point = this.device.dpi;
            Point point2 = this.device.getScreenDPI();
            FontData fontData = new FontData(string, (float)this.handle.pointSize() * (float)point2.y / (float)point.y, n);
            fontData.nsName = string2;
            FontData[] fontDataArray = new FontData[]{fontData};
            return fontDataArray;
        }
        finally {
            if (nSAutoreleasePool != null) {
                nSAutoreleasePool.release();
            }
        }
    }

    public static Font cocoa_new(Device device, NSFont nSFont) {
        Font font = new Font(device);
        font.handle = nSFont;
        return font;
    }

    public int hashCode() {
        return this.handle != null ? (int)this.handle.id : 0;
    }

    void init(String string, float f, int n, String string2) {
        if (string == null) {
            SWT.error(4);
        }
        if (f < 0.0f) {
            SWT.error(5);
        }
        Point point = this.device.dpi;
        Point point2 = this.device.getScreenDPI();
        float f2 = f * (float)point.y / (float)point2.y;
        if (string2 != null) {
            this.handle = NSFont.fontWithName(NSString.stringWith(string2), f2);
        } else {
            NSString nSString = NSString.stringWith(string);
            NSFont nSFont = NSFont.fontWithName(nSString, f2);
            if (nSFont == null) {
                nSFont = NSFont.systemFontOfSize(f2);
            }
            NSFontManager nSFontManager = NSFontManager.sharedFontManager();
            if (nSFont != null) {
                if ((n & 3) == 0) {
                    this.handle = nSFont;
                } else {
                    int n2 = 0;
                    if ((n & 2) != 0) {
                        n2 |= 1;
                    }
                    if ((n & 1) != 0) {
                        n2 |= 2;
                    }
                    this.handle = nSFontManager.convertFont(nSFont, n2);
                    if ((n & 2) != 0 && (this.handle == null || (nSFontManager.traitsOfFont(this.handle) & 1L) == 0L)) {
                        n2 &= 0xFFFFFFFE;
                        this.handle = null;
                        if ((n & 1) != 0) {
                            this.handle = nSFontManager.convertFont(nSFont, n2);
                        }
                    }
                    if ((n & 1) != 0 && this.handle == null) {
                        n2 &= 0xFFFFFFFD;
                        if ((n & 2) != 0) {
                            this.handle = nSFontManager.convertFont(nSFont, n2 |= 1);
                        }
                    }
                    if (this.handle == null) {
                        this.handle = nSFont;
                    }
                }
            }
            if (this.handle == null) {
                this.handle = NSFont.systemFontOfSize(f2);
            }
            if ((n & 2) != 0 && (nSFontManager.traitsOfFont(this.handle) & 1L) == 0L) {
                this.extraTraits |= 1;
            }
            if ((n & 1) != 0 && (nSFontManager.traitsOfFont(this.handle) & 2L) == 0L) {
                this.extraTraits |= 2;
            }
        }
        if (this.handle == null) {
            this.handle = this.device.systemFont.handle;
        }
        this.handle.retain();
    }

    @Override
    public boolean isDisposed() {
        return this.handle == null;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }
}

