/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static boolean loaded;
    static boolean swingInitialized;

    static final native long getAWTHandle(Canvas var0);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        Toolkit.getDefaultToolkit();
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        try {
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", new Class[0]);
            if (method != null) {
                method.invoke(clazz, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Frame getFrame(Composite composite) {
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)composite.getData(EMBEDDED_FRAME_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Frame new_Frame(final Composite composite) {
        Object object;
        Object object2;
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        final long l = composite.handle;
        final Frame[] frameArray = new Frame[1];
        final Throwable[] throwableArray = new Throwable[1];
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    String string;
                    Frame[] frameArray4 = null;
                    try {
                        string = embeddedFrameClass != null ? embeddedFrameClass : "sun.awt.windows.WEmbeddedFrame";
                        frameArray4 = Class.forName(string);
                    }
                    catch (Throwable throwable) {
                        throwableArray[0] = throwable;
                        Frame[] frameArray2 = frameArray;
                        synchronized (frameArray) {
                            frameArray.notify();
                            // ** MonitorExit[var3_4] (shouldn't be in output)
                            return;
                        }
                    }
                    SWT_AWT.initializeSwing();
                    string = null;
                    Constructor<?> constructor = null;
                    try {
                        constructor = frameArray4.getConstructor(Integer.TYPE);
                        string = constructor.newInstance(new Integer((int)l));
                    }
                    catch (Throwable throwable) {
                        try {
                            constructor = frameArray4.getConstructor(Long.TYPE);
                            string = constructor.newInstance(new Long(l));
                        }
                        catch (Throwable throwable2) {
                            throwableArray[0] = throwable2;
                            Frame[] frameArray3 = frameArray;
                            synchronized (frameArray) {
                                frameArray.notify();
                                // ** MonitorExit[var6_12] (shouldn't be in output)
                                return;
                            }
                        }
                    }
                    Frame frame = (Frame)((Object)string);
                    try {
                        frameArray4 = Class.forName("sun.awt.windows.WComponentPeer");
                        Field field = frameArray4.getDeclaredField("winGraphicsConfig");
                        field.setAccessible(true);
                        field.set(frame.getPeer(), frame.getGraphicsConfiguration());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    frameArray[0] = frame;
                }
                finally {
                    Frame[] frameArray5 = frameArray;
                    synchronized (frameArray) {
                        frameArray.notify();
                        // ** MonitorExit[var10_16] (shouldn't be in output)
                    }
                }
            }
        };
        if (EventQueue.isDispatchThread() || composite.getDisplay().getSyncThread() != null) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
            OS.ReplyMessage(0L);
            boolean bl = false;
            object2 = new MSG();
            int n = 0x400002;
            while (frameArray[0] == null && throwableArray[0] == null) {
                OS.PeekMessage((MSG)object2, 0L, 0, 0, n);
                try {
                    object = frameArray;
                    // MONITORENTER : frameArray
                    frameArray.wait(50L);
                    // MONITOREXIT : object
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
        if (throwableArray[0] != null) {
            SWT.error(20, throwableArray[0]);
        }
        final Frame frame = frameArray[0];
        composite.setData(EMBEDDED_FRAME_KEY, frame);
        object2 = new Listener(){

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 20: {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                frame.dispatchEvent(new WindowEvent(frame, 204));
                            }
                        });
                        break;
                    }
                    case 19: {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                frame.dispatchEvent(new WindowEvent(frame, 203));
                            }
                        });
                    }
                }
            }
        };
        Shell shell = composite.getShell();
        shell.addListener(20, (Listener)object2);
        shell.addListener(19, (Listener)object2);
        object = new Listener((Listener)object2, frame){
            final /* synthetic */ Listener val$shellListener;
            final /* synthetic */ Frame val$frame;
            {
                this.val$shellListener = listener;
                this.val$frame = frame;
            }

            @Override
            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        Shell shell = composite.getShell();
                        shell.removeListener(20, this.val$shellListener);
                        shell.removeListener(19, this.val$shellListener);
                        composite.setVisible(false);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    val$frame.dispose();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                        break;
                    }
                    case 15: 
                    case 26: {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (val$frame.isActive()) {
                                    return;
                                }
                                try {
                                    Class<?> clazz = val$frame.getClass();
                                    Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                                    if (method != null) {
                                        method.invoke((Object)val$frame, Boolean.TRUE);
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                        break;
                    }
                    case 27: {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!val$frame.isActive()) {
                                    return;
                                }
                                try {
                                    Class<?> clazz = val$frame.getClass();
                                    Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                                    if (method != null) {
                                        method.invoke((Object)val$frame, Boolean.FALSE);
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }
            }
        };
        composite.addListener(15, (Listener)object);
        composite.addListener(27, (Listener)object);
        composite.addListener(12, (Listener)object);
        composite.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (composite.isDisposed()) {
                    return;
                }
                final Rectangle rectangle = DPIUtil.autoScaleUp(composite.getClientArea());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        frame.setSize(rectangle.width, rectangle.height);
                        frame.validate();
                    }
                });
            }
        });
        return frame;
    }

    public static Shell new_Shell(final Display display, final Canvas canvas) {
        if (display == null) {
            SWT.error(4);
        }
        if (canvas == null) {
            SWT.error(4);
        }
        long l = 0L;
        try {
            SWT_AWT.loadLibrary();
            l = SWT_AWT.getAWTHandle(canvas);
        }
        catch (Throwable throwable) {
            SWT.error(20, throwable);
        }
        if (l == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.win32_new(display, l);
        final ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (shell.isDisposed()) {
                            return;
                        }
                        Dimension dimension = canvas.getSize();
                        shell.setSize(DPIUtil.autoScaleDown(new Point(dimension.width, dimension.height)));
                    }
                });
            }
        };
        canvas.addComponentListener(componentAdapter);
        shell.addListener(12, new Listener(){

            @Override
            public void handleEvent(Event event) {
                canvas.removeComponentListener(componentAdapter);
            }
        });
        shell.setVisible(true);
        return shell;
    }

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
    }
}

