/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;

public class ScaleDrawData
extends RangeDrawData {
    public int increment;
    public int pageIncrement;
    static final int TICS_MARGIN = 10;

    public ScaleDrawData() {
        this.state = new int[4];
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            int n = this.style;
            int n2 = this.minimum;
            int n3 = this.maximum;
            int n4 = this.selection;
            int n5 = this.pageIncrement;
            int n6 = OS.OpenThemeData(0, this.getClassId());
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rECT.left + rectangle.width;
            rECT.top = rectangle.y;
            rECT.bottom = rECT.top + rectangle.height;
            SIZE sIZE = new SIZE();
            if ((n & 0x200) != 0) {
                int n7;
                OS.GetThemePartSize(n6, gC.handle, 2, 0, null, 1, sIZE);
                int n8 = sIZE.cx - 1;
                OS.GetThemePartSize(n6, gC.handle, 6, 0, null, 1, sIZE);
                int n9 = sIZE.cx;
                int n10 = sIZE.cy;
                OS.GetThemePartSize(n6, gC.handle, 9, 0, rECT, 1, sIZE);
                int n11 = sIZE.cx;
                int n12 = n7 = (n9 - n8) / 2;
                rECT.left += (n7 += 10);
                rECT.top += n12;
                rECT.right = rECT.left + n8;
                rECT.bottom -= n12;
                int n13 = rECT.bottom - rECT.top;
                OS.DrawThemeBackground(n6, gC.handle, 2, 0, rECT, null);
                rECT.top += (n13 - n10) * (n4 - n2) / Math.max(1, n3 - n2);
                rECT.left -= (n9 - n8) / 2;
                rECT.right = rECT.left + n9;
                rECT.bottom = rECT.top + n10;
                OS.DrawThemeBackground(n6, gC.handle, 6, 0, rECT, null);
                rECT.top = rectangle.y + n12 + n10 / 2;
                rECT.bottom = rECT.top + 1;
                for (int i = n2; i <= n3; i += n5) {
                    rECT.left = rectangle.x + 5;
                    rECT.right = rECT.left + n11;
                    if (i != n2 && i != n3) {
                        ++rECT.left;
                    }
                    rECT.top = rectangle.y + n12 + n10 / 2;
                    rECT.top += (n13 - n10) * (i - n2) / Math.max(1, n3 - n2);
                    rECT.bottom = rECT.top + 1;
                    OS.DrawThemeBackground(n6, gC.handle, 10, 1, rECT, null);
                    gC.drawLine(DPIUtil.autoScaleDown(rECT.left), DPIUtil.autoScaleDown(rECT.top), DPIUtil.autoScaleDown(rECT.right), DPIUtil.autoScaleDown(rECT.top));
                    rECT.left = rectangle.x + 10 + n9 + 1;
                    rECT.right = rECT.left + n11;
                    if (i != n2 && i != n3) {
                        --rECT.right;
                    }
                    OS.DrawThemeBackground(n6, gC.handle, 10, 1, rECT, null);
                    gC.drawLine(DPIUtil.autoScaleDown(rECT.left), DPIUtil.autoScaleDown(rECT.top), DPIUtil.autoScaleDown(rECT.right), DPIUtil.autoScaleDown(rECT.top));
                }
            }
            OS.CloseThemeData(n6);
        }
    }

    @Override
    char[] getClassId() {
        return TRACKBAR;
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }
}

