/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Scale
extends Control {
    int increment = 1;
    int pageIncrement = 10;

    public Scale(Composite composite, int n) {
        super(composite, Scale.checkStyle(n));
    }

    int actionProc(int n, int n2) {
        int n3 = super.actionProc(n, n2);
        if (n3 == 0) {
            return n3;
        }
        this.sendSelectionEvent(13, null, true);
        return n3;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Scale.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 0x100) != 0) {
            int[] nArray = new int[1];
            OS.GetThemeMetric(41, nArray);
            n4 = nArray[0];
            n3 = n4 * 10;
        } else {
            int[] nArray = new int[1];
            OS.GetThemeMetric(45, nArray);
            n3 = nArray[0];
            n4 = n3 * 10;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        return new Point(n3, n4);
    }

    void createHandle() {
        this.state |= 0x800;
        int n = this.display.actionProc;
        int[] nArray = new int[1];
        int n2 = OS.GetControlOwner(this.parent.handle);
        int n3 = (this.style & 0x200) != 0 ? 100 : 0;
        OS.CreateSliderControl(n2, null, n3, 0, 100, 2, (short)0, true, n, nArray);
        if (nArray[0] == 0) {
            this.error(2);
        }
        this.handle = nArray[0];
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return OS.GetControl32BitMaximum(this.handle);
    }

    public int getMinimum() {
        this.checkWidget();
        return OS.GetControl32BitMinimum(this.handle);
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        int n = OS.GetControl32BitValue(this.handle);
        if ((this.style & 0x200) != 0) {
            int n2 = OS.GetControl32BitMinimum(this.handle);
            int n3 = OS.GetControl32BitMaximum(this.handle);
            n = n3 - n + n2;
        }
        return n;
    }

    int kEventMouseDown(int n, int n2, int n3) {
        int n4 = super.kEventMouseDown(n, n2, n3);
        if (n4 == 0) {
            return n4;
        }
        if (!this.hasFocus()) {
            return n4;
        }
        this.display.ignoreFocus = true;
        int n5 = OS.GetControlOwner(this.handle);
        OS.ClearKeyboardFocus(n5);
        n4 = OS.CallNextEventHandler(n, n2);
        if (!this.isDisposed()) {
            OS.SetKeyboardFocus(n5, this.handle, (short)this.focusPart());
        }
        this.display.ignoreFocus = false;
        return n4;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.increment = n;
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.GetControl32BitMinimum(this.handle);
        if (n > n2) {
            OS.SetControl32BitMaximum(this.handle, n);
        }
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int n2 = OS.GetControl32BitMaximum(this.handle);
        if (n < n2) {
            OS.SetControl32BitMinimum(this.handle, n);
        }
    }

    public void setPageIncrement(int n) {
        this.checkWidget();
        if (n < 1) {
            return;
        }
        this.pageIncrement = n;
    }

    public void setSelection(int n) {
        this.checkWidget();
        if ((this.style & 0x200) != 0) {
            int n2 = OS.GetControl32BitMinimum(this.handle);
            int n3 = OS.GetControl32BitMaximum(this.handle);
            n = Math.min(n3, Math.max(n2, n3 - n + n2));
        }
        OS.SetControl32BitValue(this.handle, n);
    }
}

