/*
 *  Copyright (C) 2006-2016  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.test;

import static org.junit.Assert.assertTrue;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.dbgl.model.conf.Settings;
import org.dbgl.model.conf.SharedConf;
import org.junit.Test;


public class DBConfWSTest {

	@Test
	public void testGetEntries() {
		Client client = ClientBuilder.newClient();
		GenericType<java.util.List<SharedConf>> confType = new GenericType<java.util.List<SharedConf>>() {};
		java.util.List<SharedConf> confs = client.target(
			Settings.getInstance().getSettings().getValue("confsharing", "endpoint")).path("/submissions").request().accept(MediaType.APPLICATION_XML).get(confType);
		client.close();
		
		assertTrue(confs.size() > 500);
	}
}
