/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.DROPFILES;
import org.eclipse.swt.internal.win32.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String CF_HDROP = "CF_HDROP ";
    private static final int CF_HDROPID = 15;

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] fileNames = (String[])object;
        StringBuffer allFiles = new StringBuffer();
        for (int i = 0; i < fileNames.length; ++i) {
            allFiles.append(fileNames[i]);
            allFiles.append('\u0000');
        }
        allFiles.append('\u0000');
        char[] buffer = new char[allFiles.length()];
        allFiles.getChars(0, allFiles.length(), buffer, 0);
        DROPFILES dropfiles = new DROPFILES();
        dropfiles.pFiles = DROPFILES.sizeof;
        dropfiles.pt_y = 0;
        dropfiles.pt_x = 0;
        dropfiles.fNC = 0;
        dropfiles.fWide = 1;
        int byteCount = buffer.length * 2;
        long newPtr = OS.GlobalAlloc(64, DROPFILES.sizeof + byteCount);
        OS.MoveMemory(newPtr, dropfiles, DROPFILES.sizeof);
        OS.MoveMemory(newPtr + (long)DROPFILES.sizeof, buffer, byteCount);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = newPtr;
        transferData.stgmedium.pUnkForRelease = 0L;
        transferData.result = 0;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pIDataObject == 0L) {
            return null;
        }
        IDataObject dataObject = new IDataObject(transferData.pIDataObject);
        dataObject.AddRef();
        FORMATETC formatetc = new FORMATETC();
        formatetc.cfFormat = 15;
        formatetc.ptd = 0L;
        formatetc.dwAspect = 1;
        formatetc.lindex = -1;
        formatetc.tymed = 1;
        STGMEDIUM stgmedium = new STGMEDIUM();
        stgmedium.tymed = 1;
        transferData.result = this.getData(dataObject, formatetc, stgmedium);
        dataObject.Release();
        if (transferData.result != 0) {
            return null;
        }
        int count = OS.DragQueryFile(stgmedium.unionField, -1, null, 0);
        String[] fileNames = new String[count];
        for (int i = 0; i < count; ++i) {
            int size = OS.DragQueryFile(stgmedium.unionField, i, null, 0);
            char[] lpszFile = new char[size + 1];
            OS.DragQueryFile(stgmedium.unionField, i, lpszFile, size + 1);
            fileNames[i] = new String(lpszFile, 0, size);
        }
        OS.DragFinish(stgmedium.unionField);
        return fileNames;
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{15};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{CF_HDROP};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] strings = (String[])object;
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] != null && strings[i].length() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

