/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageDataProvider;
import org.eclipse.swt.graphics.ImageFileNameProvider;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.BitmapData;
import org.eclipse.swt.internal.gdip.ColorPalette;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.DIBSECTION;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public long handle;
    int transparentPixel = -1;
    int transparentColor = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    private ImageFileNameProvider imageFileNameProvider;
    private ImageDataProvider imageDataProvider;
    private int styleFlag = 0;
    private int currentDeviceZoom = 100;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
    }

    public Image(Device device, int width, int height) {
        super(device);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        width = DPIUtil.autoScaleUp(width);
        height = DPIUtil.autoScaleUp(height);
        this.init(width, height);
        this.init();
    }

    public Image(Device device, Image srcImage, int flag) {
        super(device);
        device = this.device;
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = srcImage.getBoundsInPixels();
        this.type = srcImage.type;
        this.imageDataProvider = srcImage.imageDataProvider;
        this.imageFileNameProvider = srcImage.imageFileNameProvider;
        this.styleFlag = srcImage.styleFlag | flag;
        this.currentDeviceZoom = srcImage.currentDeviceZoom;
        block0 : switch (flag) {
            case 0: {
                switch (this.type) {
                    case 0: {
                        long hDC = device.internal_new_GC(null);
                        long hdcSource = OS.CreateCompatibleDC(hDC);
                        long hdcDest = OS.CreateCompatibleDC(hDC);
                        long hOldSrc = OS.SelectObject(hdcSource, srcImage.handle);
                        BITMAP bm = new BITMAP();
                        OS.GetObject(srcImage.handle, BITMAP.sizeof, bm);
                        this.handle = OS.CreateCompatibleBitmap(hdcSource, rect.width, bm.bmBits != 0L ? -rect.height : rect.height);
                        if (this.handle == 0L) {
                            SWT.error(2);
                        }
                        long hOldDest = OS.SelectObject(hdcDest, this.handle);
                        OS.BitBlt(hdcDest, 0, 0, rect.width, rect.height, hdcSource, 0, 0, 0xCC0020);
                        OS.SelectObject(hdcSource, hOldSrc);
                        OS.SelectObject(hdcDest, hOldDest);
                        OS.DeleteDC(hdcSource);
                        OS.DeleteDC(hdcDest);
                        device.internal_dispose_GC(hDC, null);
                        this.transparentPixel = srcImage.transparentPixel;
                        this.alpha = srcImage.alpha;
                        if (srcImage.alphaData == null) break block0;
                        this.alphaData = new byte[srcImage.alphaData.length];
                        System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                        break;
                    }
                    case 1: {
                        this.handle = OS.CopyImage(srcImage.handle, 1, rect.width, rect.height, 0);
                        if (this.handle != 0L) break block0;
                        SWT.error(2);
                        break;
                    }
                    default: {
                        SWT.error(40);
                        break;
                    }
                }
                break;
            }
            case 1: {
                ImageData data = srcImage.getImageDataAtCurrentZoom();
                PaletteData palette = data.palette;
                RGB[] rgbs = new RGB[]{device.getSystemColor(2).getRGB(), device.getSystemColor(18).getRGB(), device.getSystemColor(22).getRGB()};
                ImageData newData = new ImageData(rect.width, rect.height, 8, new PaletteData(rgbs));
                newData.alpha = data.alpha;
                newData.alphaData = data.alphaData;
                newData.maskData = data.maskData;
                newData.maskPad = data.maskPad;
                if (data.transparentPixel != -1) {
                    newData.transparentPixel = 0;
                }
                int[] scanline = new int[rect.width];
                int[] maskScanline = null;
                ImageData mask = null;
                if (data.maskData != null) {
                    mask = data.getTransparencyMask();
                }
                if (mask != null) {
                    maskScanline = new int[rect.width];
                }
                int redMask = palette.redMask;
                int greenMask = palette.greenMask;
                int blueMask = palette.blueMask;
                int redShift = palette.redShift;
                int greenShift = palette.greenShift;
                int blueShift = palette.blueShift;
                for (int y = 0; y < rect.height; ++y) {
                    int offset = y * newData.bytesPerLine;
                    data.getPixels(0, y, rect.width, scanline, 0);
                    if (mask != null) {
                        mask.getPixels(0, y, rect.width, maskScanline, 0);
                    }
                    for (int x = 0; x < rect.width; ++x) {
                        int pixel = scanline[x];
                        if (!(data.transparentPixel != -1 && pixel == data.transparentPixel || mask != null && maskScanline[x] == 0)) {
                            int blue;
                            int green;
                            int red;
                            if (palette.isDirect) {
                                red = pixel & redMask;
                                red = redShift < 0 ? red >>> -redShift : red << redShift;
                                green = pixel & greenMask;
                                green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                                blue = pixel & blueMask;
                                blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                            } else {
                                red = palette.colors[pixel].red;
                                green = palette.colors[pixel].green;
                                blue = palette.colors[pixel].blue;
                            }
                            int intensity = red * red + green * green + blue * blue;
                            newData.data[offset] = intensity < 98304 ? 1 : 2;
                        }
                        ++offset;
                    }
                }
                this.init(newData);
                break;
            }
            case 2: {
                ImageData data = srcImage.getImageDataAtCurrentZoom();
                PaletteData palette = data.palette;
                ImageData newData = data;
                if (!palette.isDirect) {
                    RGB[] rgbs = palette.getRGBs();
                    for (int i = 0; i < rgbs.length; ++i) {
                        int intensity;
                        if (data.transparentPixel == i) continue;
                        RGB color = rgbs[i];
                        int red = color.red;
                        int green = color.green;
                        int blue = color.blue;
                        color.green = color.blue = (intensity = red + red + green + green + green + green + green + blue >> 3);
                        color.red = color.blue;
                    }
                    newData.palette = new PaletteData(rgbs);
                } else {
                    RGB[] rgbs = new RGB[256];
                    for (int i = 0; i < rgbs.length; ++i) {
                        rgbs[i] = new RGB(i, i, i);
                    }
                    newData = new ImageData(rect.width, rect.height, 8, new PaletteData(rgbs));
                    newData.alpha = data.alpha;
                    newData.alphaData = data.alphaData;
                    newData.maskData = data.maskData;
                    newData.maskPad = data.maskPad;
                    if (data.transparentPixel != -1) {
                        newData.transparentPixel = 254;
                    }
                    int[] scanline = new int[rect.width];
                    int redMask = palette.redMask;
                    int greenMask = palette.greenMask;
                    int blueMask = palette.blueMask;
                    int redShift = palette.redShift;
                    int greenShift = palette.greenShift;
                    int blueShift = palette.blueShift;
                    for (int y = 0; y < rect.height; ++y) {
                        int offset = y * newData.bytesPerLine;
                        data.getPixels(0, y, rect.width, scanline, 0);
                        for (int x = 0; x < rect.width; ++x) {
                            int pixel = scanline[x];
                            if (pixel != data.transparentPixel) {
                                int red = pixel & redMask;
                                red = redShift < 0 ? red >>> -redShift : red << redShift;
                                int green = pixel & greenMask;
                                green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                                int blue = pixel & blueMask;
                                blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                                int intensity = red + red + green + green + green + green + green + blue >> 3;
                                if (newData.transparentPixel == intensity) {
                                    intensity = 255;
                                }
                                newData.data[offset] = (byte)intensity;
                            } else {
                                newData.data[offset] = -2;
                            }
                            ++offset;
                        }
                    }
                }
                this.init(newData);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.init();
    }

    public Image(Device device, Rectangle bounds) {
        super(device);
        if (bounds == null) {
            SWT.error(4);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        bounds = DPIUtil.autoScaleUp(bounds);
        this.init(bounds.width, bounds.height);
        this.init();
    }

    public Image(Device device, ImageData data) {
        super(device);
        if (data == null) {
            SWT.error(4);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        data = DPIUtil.autoScaleUp(device, data);
        this.init(data);
        this.init();
    }

    public Image(Device device, ImageData source, ImageData mask) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        source = DPIUtil.autoScaleUp(device, source);
        mask = DPIUtil.autoScaleUp(device, mask);
        mask = ImageData.convertMask(mask);
        Image.init(this.device, this, source, mask);
        this.init();
    }

    public Image(Device device, InputStream stream) {
        super(device);
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        ImageData data = DPIUtil.autoScaleUp(device, new ImageData(stream));
        this.init(data);
        this.init();
    }

    public Image(Device device, String filename) {
        super(device);
        if (filename == null) {
            SWT.error(4);
        }
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        ImageData data = DPIUtil.autoScaleUp(device, new ImageData(filename));
        this.init(data);
        this.init();
    }

    public Image(Device device, ImageFileNameProvider imageFileNameProvider) {
        super(device);
        this.imageFileNameProvider = imageFileNameProvider;
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        boolean[] found = new boolean[1];
        String fileName = DPIUtil.validateAndGetImagePathAtZoom(imageFileNameProvider, this.currentDeviceZoom, found);
        if (found[0]) {
            this.initNative(fileName);
            if (this.handle == 0L) {
                this.init(new ImageData(fileName));
            }
        } else {
            ImageData resizedData = DPIUtil.autoScaleUp(device, new ImageData(fileName));
            this.init(resizedData);
        }
        this.init();
    }

    public Image(Device device, ImageDataProvider imageDataProvider) {
        super(device);
        this.imageDataProvider = imageDataProvider;
        this.currentDeviceZoom = DPIUtil.getDeviceZoom();
        boolean[] found = new boolean[1];
        ImageData data = DPIUtil.validateAndGetImageDataAtZoom(imageDataProvider, this.currentDeviceZoom, found);
        if (found[0]) {
            this.init(data);
        } else {
            ImageData resizedData = DPIUtil.autoScaleUp(device, data);
            this.init(resizedData);
        }
        this.init();
    }

    boolean refreshImageForZoom() {
        boolean refreshed = false;
        int deviceZoomLevel = DPIUtil.getDeviceZoom();
        if (this.imageFileNameProvider != null) {
            if (deviceZoomLevel != this.currentDeviceZoom) {
                boolean[] found = new boolean[1];
                String filename = DPIUtil.validateAndGetImagePathAtZoom(this.imageFileNameProvider, deviceZoomLevel, found);
                if (found[0] || this.currentDeviceZoom != 100) {
                    this.destroy();
                    this.initNative(filename);
                    if (this.handle == 0L) {
                        this.init(new ImageData(filename));
                    }
                    this.init();
                    refreshed = true;
                }
                if (!found[0]) {
                    this.destroy();
                    ImageData resizedData = DPIUtil.autoScaleUp(this.device, new ImageData(filename));
                    this.init(resizedData);
                    this.init();
                    refreshed = true;
                }
                this.currentDeviceZoom = deviceZoomLevel;
            }
        } else if (this.imageDataProvider != null) {
            if (deviceZoomLevel != this.currentDeviceZoom) {
                boolean[] found = new boolean[1];
                ImageData data = DPIUtil.validateAndGetImageDataAtZoom(this.imageDataProvider, deviceZoomLevel, found);
                if (found[0] || this.currentDeviceZoom != 100) {
                    this.destroy();
                    this.init(data);
                    this.init();
                    refreshed = true;
                }
                if (!found[0]) {
                    this.destroy();
                    ImageData resizedData = DPIUtil.autoScaleUp(this.device, data);
                    this.init(resizedData);
                    this.init();
                    refreshed = true;
                }
                this.currentDeviceZoom = deviceZoomLevel;
            }
        } else if (deviceZoomLevel != this.currentDeviceZoom) {
            ImageData data = this.getImageDataAtCurrentZoom();
            this.destroy();
            ImageData resizedData = DPIUtil.autoScaleImageData(this.device, data, deviceZoomLevel, this.currentDeviceZoom);
            this.init(resizedData);
            this.init();
            refreshed = true;
            this.currentDeviceZoom = deviceZoomLevel;
        }
        return refreshed;
    }

    void initNative(String filename) {
        this.device.checkGDIP();
        boolean gdip = true;
        if (gdip && C.PTR_SIZEOF == 8 && filename.toLowerCase().endsWith(".gif")) {
            gdip = false;
        }
        if (OS.WIN32_VERSION >= OS.VERSION(6, 1) && filename.toLowerCase().endsWith(".gif")) {
            gdip = false;
        }
        if (gdip) {
            int length = filename.length();
            char[] chars = new char[length + 1];
            filename.getChars(0, length, chars, 0);
            long bitmap = Gdip.Bitmap_new(chars, false);
            if (bitmap != 0L) {
                int error = 2;
                int status = Gdip.Image_GetLastStatus(bitmap);
                if (status == 0) {
                    if (filename.toLowerCase().endsWith(".ico")) {
                        this.type = 1;
                        long[] hicon = new long[1];
                        status = Gdip.Bitmap_GetHICON(bitmap, hicon);
                        this.handle = hicon[0];
                    } else {
                        this.type = 0;
                        int width = Gdip.Image_GetWidth(bitmap);
                        int height = Gdip.Image_GetHeight(bitmap);
                        int pixelFormat = Gdip.Image_GetPixelFormat(bitmap);
                        switch (pixelFormat) {
                            case 135173: 
                            case 135174: {
                                this.handle = Image.createDIB(width, height, 16);
                                break;
                            }
                            case 8207: 
                            case 137224: {
                                this.handle = Image.createDIB(width, height, 24);
                                break;
                            }
                            case 139273: 
                            case 925707: 
                            case 0x101004: 
                            case 1060876: 
                            case 1851406: 
                            case 3424269: {
                                this.handle = Image.createDIB(width, height, 32);
                            }
                        }
                        if (this.handle != 0L) {
                            long hDC = this.device.internal_new_GC(null);
                            long srcHDC = OS.CreateCompatibleDC(hDC);
                            long oldSrcBitmap = OS.SelectObject(srcHDC, this.handle);
                            long graphics = Gdip.Graphics_new(srcHDC);
                            if (graphics != 0L) {
                                Rect rect = new Rect();
                                rect.Width = width;
                                rect.Height = height;
                                status = Gdip.Graphics_DrawImage(graphics, bitmap, rect, 0, 0, width, height, 2, 0L, 0L, 0L);
                                if (status != 0) {
                                    error = 40;
                                    OS.DeleteObject(this.handle);
                                    this.handle = 0L;
                                }
                                Gdip.Graphics_delete(graphics);
                            }
                            OS.SelectObject(srcHDC, oldSrcBitmap);
                            OS.DeleteDC(srcHDC);
                            this.device.internal_dispose_GC(hDC, null);
                        } else {
                            long lockedBitmapData = Gdip.BitmapData_new();
                            if (lockedBitmapData != 0L) {
                                status = Gdip.Bitmap_LockBits(bitmap, 0L, 0, pixelFormat, lockedBitmapData);
                                if (status == 0) {
                                    BitmapData bitmapData = new BitmapData();
                                    Gdip.MoveMemory(bitmapData, lockedBitmapData);
                                    int stride = bitmapData.Stride;
                                    long pixels = bitmapData.Scan0;
                                    int depth = 0;
                                    int scanlinePad = 4;
                                    int transparentPixel = -1;
                                    switch (bitmapData.PixelFormat) {
                                        case 196865: {
                                            depth = 1;
                                            break;
                                        }
                                        case 197634: {
                                            depth = 4;
                                            break;
                                        }
                                        case 198659: {
                                            depth = 8;
                                            break;
                                        }
                                        case 135173: 
                                        case 135174: 
                                        case 397319: {
                                            depth = 16;
                                            break;
                                        }
                                        case 137224: {
                                            depth = 24;
                                            break;
                                        }
                                        case 139273: 
                                        case 2498570: {
                                            depth = 32;
                                        }
                                    }
                                    if (depth != 0) {
                                        PaletteData paletteData = null;
                                        switch (bitmapData.PixelFormat) {
                                            case 196865: 
                                            case 197634: 
                                            case 198659: {
                                                int paletteSize = Gdip.Image_GetPaletteSize(bitmap);
                                                long hHeap = OS.GetProcessHeap();
                                                long palette = OS.HeapAlloc(hHeap, 8, paletteSize);
                                                if (palette == 0L) {
                                                    SWT.error(2);
                                                }
                                                Gdip.Image_GetPalette(bitmap, palette, paletteSize);
                                                ColorPalette colorPalette = new ColorPalette();
                                                Gdip.MoveMemory(colorPalette, palette, ColorPalette.sizeof);
                                                int[] entries = new int[colorPalette.Count];
                                                OS.MoveMemory(entries, palette + 8L, entries.length * 4);
                                                OS.HeapFree(hHeap, 0, palette);
                                                RGB[] rgbs = new RGB[colorPalette.Count];
                                                paletteData = new PaletteData(rgbs);
                                                for (int i = 0; i < entries.length; ++i) {
                                                    if ((entries[i] >> 24 & 0xFF) == 0 && (colorPalette.Flags & 1) != 0) {
                                                        transparentPixel = i;
                                                    }
                                                    rgbs[i] = new RGB((entries[i] & 0xFF0000) >> 16, (entries[i] & 0xFF00) >> 8, (entries[i] & 0xFF) >> 0);
                                                }
                                                break;
                                            }
                                            case 135173: 
                                            case 397319: {
                                                paletteData = new PaletteData(31744, 992, 31);
                                                break;
                                            }
                                            case 135174: {
                                                paletteData = new PaletteData(63488, 2016, 31);
                                                break;
                                            }
                                            case 137224: {
                                                paletteData = new PaletteData(255, 65280, 0xFF0000);
                                                break;
                                            }
                                            case 139273: 
                                            case 2498570: {
                                                paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                                            }
                                        }
                                        byte[] data = new byte[stride * height];
                                        byte[] alphaData = null;
                                        OS.MoveMemory(data, pixels, data.length);
                                        switch (bitmapData.PixelFormat) {
                                            case 397319: {
                                                alphaData = new byte[width * height];
                                                int i = 1;
                                                int j = 0;
                                                while (i < data.length) {
                                                    alphaData[j] = (byte)((data[i] & 0x80) != 0 ? 255 : 0);
                                                    i += 2;
                                                    ++j;
                                                }
                                                break;
                                            }
                                            case 2498570: {
                                                alphaData = new byte[width * height];
                                                int i = 3;
                                                int j = 0;
                                                while (i < data.length) {
                                                    alphaData[j] = data[i];
                                                    i += 4;
                                                    ++j;
                                                }
                                                break;
                                            }
                                        }
                                        ImageData img = new ImageData(width, height, depth, paletteData, scanlinePad, data);
                                        img.transparentPixel = transparentPixel;
                                        img.alphaData = alphaData;
                                        this.init(img);
                                    }
                                    Gdip.Bitmap_UnlockBits(bitmap, lockedBitmapData);
                                } else {
                                    error = 40;
                                }
                                Gdip.BitmapData_delete(lockedBitmapData);
                            }
                        }
                    }
                }
                Gdip.Bitmap_delete(bitmap);
                if (status == 0 && this.handle == 0L) {
                    SWT.error(error);
                }
            }
        }
    }

    long[] createGdipImage() {
        switch (this.type) {
            case 0: {
                if (this.alpha != -1 || this.alphaData != null || this.transparentPixel != -1) {
                    long hHeap;
                    long pixels;
                    int x;
                    int y;
                    BITMAP bm = new BITMAP();
                    OS.GetObject(this.handle, BITMAP.sizeof, bm);
                    int imgWidth = bm.bmWidth;
                    int imgHeight = bm.bmHeight;
                    long hDC = this.device.internal_new_GC(null);
                    long srcHdc = OS.CreateCompatibleDC(hDC);
                    long oldSrcBitmap = OS.SelectObject(srcHdc, this.handle);
                    long memHdc = OS.CreateCompatibleDC(hDC);
                    long memDib = Image.createDIB(imgWidth, imgHeight, 32);
                    if (memDib == 0L) {
                        SWT.error(2);
                    }
                    long oldMemBitmap = OS.SelectObject(memHdc, memDib);
                    BITMAP dibBM = new BITMAP();
                    OS.GetObject(memDib, BITMAP.sizeof, dibBM);
                    int sizeInBytes = dibBM.bmWidthBytes * dibBM.bmHeight;
                    OS.BitBlt(memHdc, 0, 0, imgWidth, imgHeight, srcHdc, 0, 0, 0xCC0020);
                    byte red = 0;
                    byte green = 0;
                    byte blue = 0;
                    if (this.transparentPixel != -1) {
                        if (bm.bmBitsPixel <= 8) {
                            byte[] color = new byte[4];
                            OS.GetDIBColorTable(srcHdc, this.transparentPixel, 1, color);
                            blue = color[0];
                            green = color[1];
                            red = color[2];
                        } else {
                            switch (bm.bmBitsPixel) {
                                case 16: {
                                    int blueMask = 31;
                                    int blueShift = ImageData.getChannelShift(blueMask);
                                    byte[] blues = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(blueMask, blueShift)];
                                    blue = blues[(this.transparentPixel & blueMask) >> blueShift];
                                    int greenMask = 992;
                                    int greenShift = ImageData.getChannelShift(greenMask);
                                    byte[] greens = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(greenMask, greenShift)];
                                    green = greens[(this.transparentPixel & greenMask) >> greenShift];
                                    int redMask = 31744;
                                    int redShift = ImageData.getChannelShift(redMask);
                                    byte[] reds = ImageData.ANY_TO_EIGHT[ImageData.getChannelWidth(redMask, redShift)];
                                    red = reds[(this.transparentPixel & redMask) >> redShift];
                                    break;
                                }
                                case 24: {
                                    blue = (byte)((this.transparentPixel & 0xFF0000) >> 16);
                                    green = (byte)((this.transparentPixel & 0xFF00) >> 8);
                                    red = (byte)(this.transparentPixel & 0xFF);
                                    break;
                                }
                                case 32: {
                                    blue = (byte)((this.transparentPixel & 0xFF000000) >>> 24);
                                    green = (byte)((this.transparentPixel & 0xFF0000) >> 16);
                                    red = (byte)((this.transparentPixel & 0xFF00) >> 8);
                                }
                            }
                        }
                    }
                    OS.SelectObject(srcHdc, oldSrcBitmap);
                    OS.SelectObject(memHdc, oldMemBitmap);
                    OS.DeleteObject(srcHdc);
                    OS.DeleteObject(memHdc);
                    byte[] srcData = new byte[sizeInBytes];
                    OS.MoveMemory(srcData, dibBM.bmBits, sizeInBytes);
                    OS.DeleteObject(memDib);
                    this.device.internal_dispose_GC(hDC, null);
                    if (this.alpha != -1) {
                        int dp = 0;
                        for (y = 0; y < imgHeight; ++y) {
                            for (x = 0; x < imgWidth; ++x) {
                                srcData[dp + 3] = (byte)this.alpha;
                                dp += 4;
                            }
                        }
                    } else if (this.alphaData != null) {
                        int dp = 0;
                        int ap = 0;
                        for (y = 0; y < imgHeight; ++y) {
                            for (int x2 = 0; x2 < imgWidth; ++x2) {
                                srcData[dp + 3] = this.alphaData[ap++];
                                dp += 4;
                            }
                        }
                    } else if (this.transparentPixel != -1) {
                        int dp = 0;
                        for (y = 0; y < imgHeight; ++y) {
                            for (x = 0; x < imgWidth; ++x) {
                                srcData[dp + 3] = srcData[dp] == blue && srcData[dp + 1] == green && srcData[dp + 2] == red ? 0 : -1;
                                dp += 4;
                            }
                        }
                    }
                    if ((pixels = OS.HeapAlloc(hHeap = OS.GetProcessHeap(), 8, srcData.length)) == 0L) {
                        SWT.error(2);
                    }
                    OS.MoveMemory(pixels, srcData, sizeInBytes);
                    return new long[]{Gdip.Bitmap_new(imgWidth, imgHeight, dibBM.bmWidthBytes, 2498570, pixels), pixels};
                }
                return new long[]{Gdip.Bitmap_new(this.handle, 0L), 0L};
            }
            case 1: {
                ICONINFO iconInfo = new ICONINFO();
                OS.GetIconInfo(this.handle, iconInfo);
                long hBitmap = iconInfo.hbmColor;
                if (hBitmap == 0L) {
                    hBitmap = iconInfo.hbmMask;
                }
                BITMAP bm = new BITMAP();
                OS.GetObject(hBitmap, BITMAP.sizeof, bm);
                int imgWidth = bm.bmWidth;
                int imgHeight = hBitmap == iconInfo.hbmMask ? bm.bmHeight / 2 : bm.bmHeight;
                long img = 0L;
                long pixels = 0L;
                if (imgWidth > imgHeight || bm.bmBitsPixel == 32) {
                    long hDC = this.device.internal_new_GC(null);
                    long srcHdc = OS.CreateCompatibleDC(hDC);
                    long oldSrcBitmap = OS.SelectObject(srcHdc, hBitmap);
                    long memHdc = OS.CreateCompatibleDC(hDC);
                    long memDib = Image.createDIB(imgWidth, imgHeight, 32);
                    if (memDib == 0L) {
                        SWT.error(2);
                    }
                    long oldMemBitmap = OS.SelectObject(memHdc, memDib);
                    BITMAP dibBM = new BITMAP();
                    OS.GetObject(memDib, BITMAP.sizeof, dibBM);
                    OS.BitBlt(memHdc, 0, 0, imgWidth, imgHeight, srcHdc, 0, hBitmap == iconInfo.hbmMask ? imgHeight : 0, 0xCC0020);
                    OS.SelectObject(memHdc, oldMemBitmap);
                    OS.DeleteObject(memHdc);
                    byte[] srcData = new byte[dibBM.bmWidthBytes * dibBM.bmHeight];
                    OS.MoveMemory(srcData, dibBM.bmBits, srcData.length);
                    OS.DeleteObject(memDib);
                    OS.SelectObject(srcHdc, iconInfo.hbmMask);
                    int dp = 3;
                    for (int y = 0; y < imgHeight; ++y) {
                        for (int x = 0; x < imgWidth; ++x) {
                            if (srcData[dp] == 0) {
                                srcData[dp] = OS.GetPixel(srcHdc, x, y) != 0 ? 0 : -1;
                            }
                            dp += 4;
                        }
                    }
                    OS.SelectObject(srcHdc, oldSrcBitmap);
                    OS.DeleteObject(srcHdc);
                    this.device.internal_dispose_GC(hDC, null);
                    long hHeap = OS.GetProcessHeap();
                    pixels = OS.HeapAlloc(hHeap, 8, srcData.length);
                    if (pixels == 0L) {
                        SWT.error(2);
                    }
                    OS.MoveMemory(pixels, srcData, srcData.length);
                    img = Gdip.Bitmap_new(imgWidth, imgHeight, dibBM.bmWidthBytes, 2498570, pixels);
                } else {
                    img = Gdip.Bitmap_new(this.handle);
                }
                if (iconInfo.hbmColor != 0L) {
                    OS.DeleteObject(iconInfo.hbmColor);
                }
                if (iconInfo.hbmMask != 0L) {
                    OS.DeleteObject(iconInfo.hbmMask);
                }
                return new long[]{img, pixels};
            }
        }
        SWT.error(40);
        return null;
    }

    @Override
    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        if (this.type == 1) {
            OS.DestroyIcon(this.handle);
        } else {
            OS.DeleteObject(this.handle);
        }
        this.handle = 0L;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        if (this.device != image.device || this.transparentPixel != image.transparentPixel) {
            return false;
        }
        if (this.imageDataProvider != null && image.imageDataProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageDataProvider.equals(image.imageDataProvider);
        }
        if (this.imageFileNameProvider != null && image.imageFileNameProvider != null) {
            return this.styleFlag == image.styleFlag && this.imageFileNameProvider.equals(image.imageFileNameProvider);
        }
        return this.handle == image.handle;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        long hDC = this.device.internal_new_GC(null);
        BITMAP bm = new BITMAP();
        OS.GetObject(this.handle, BITMAP.sizeof, bm);
        long hdcMem = OS.CreateCompatibleDC(hDC);
        long hOldObject = OS.SelectObject(hdcMem, this.handle);
        int red = 0;
        int green = 0;
        int blue = 0;
        if (bm.bmBitsPixel <= 8) {
            byte[] color = new byte[4];
            OS.GetDIBColorTable(hdcMem, this.transparentPixel, 1, color);
            blue = color[0] & 0xFF;
            green = color[1] & 0xFF;
            red = color[2] & 0xFF;
        } else {
            switch (bm.bmBitsPixel) {
                case 16: {
                    blue = (this.transparentPixel & 0x1F) << 3;
                    green = (this.transparentPixel & 0x3E0) >> 2;
                    red = (this.transparentPixel & 0x7C00) >> 7;
                    break;
                }
                case 24: {
                    blue = (this.transparentPixel & 0xFF0000) >> 16;
                    green = (this.transparentPixel & 0xFF00) >> 8;
                    red = this.transparentPixel & 0xFF;
                    break;
                }
                case 32: {
                    blue = (this.transparentPixel & 0xFF000000) >>> 24;
                    green = (this.transparentPixel & 0xFF0000) >> 16;
                    red = (this.transparentPixel & 0xFF00) >> 8;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        OS.SelectObject(hdcMem, hOldObject);
        OS.DeleteDC(hdcMem);
        this.device.internal_dispose_GC(hDC, null);
        return Color.win32_new(this.device, blue << 16 | green << 8 | red);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getBounds(100);
    }

    Rectangle getBounds(int zoom) {
        Rectangle bounds = this.getBoundsInPixels();
        if (bounds != null && zoom != this.currentDeviceZoom) {
            bounds = DPIUtil.autoScaleBounds(bounds, zoom, this.currentDeviceZoom);
        }
        return bounds;
    }

    @Deprecated
    public Rectangle getBoundsInPixels() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        switch (this.type) {
            case 0: {
                BITMAP bm = new BITMAP();
                OS.GetObject(this.handle, BITMAP.sizeof, bm);
                this.width = bm.bmWidth;
                this.height = bm.bmHeight;
                return new Rectangle(0, 0, this.width, this.height);
            }
            case 1: {
                ICONINFO info = new ICONINFO();
                OS.GetIconInfo(this.handle, info);
                long hBitmap = info.hbmColor;
                if (hBitmap == 0L) {
                    hBitmap = info.hbmMask;
                }
                BITMAP bm = new BITMAP();
                OS.GetObject(hBitmap, BITMAP.sizeof, bm);
                if (hBitmap == info.hbmMask) {
                    bm.bmHeight /= 2;
                }
                if (info.hbmColor != 0L) {
                    OS.DeleteObject(info.hbmColor);
                }
                if (info.hbmMask != 0L) {
                    OS.DeleteObject(info.hbmMask);
                }
                this.width = bm.bmWidth;
                this.height = bm.bmHeight;
                return new Rectangle(0, 0, this.width, this.height);
            }
        }
        SWT.error(40);
        return null;
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.getImageData(100);
    }

    public ImageData getImageData(int zoom) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (zoom == this.currentDeviceZoom) {
            return this.getImageDataAtCurrentZoom();
        }
        if (this.imageDataProvider != null) {
            boolean[] found = new boolean[1];
            ImageData data = DPIUtil.validateAndGetImageDataAtZoom(this.imageDataProvider, zoom, found);
            if (found[0]) {
                return data;
            }
            return DPIUtil.autoScaleImageData(this.device, data, zoom, 100);
        }
        if (this.imageFileNameProvider != null) {
            boolean[] found = new boolean[1];
            String fileName = DPIUtil.validateAndGetImagePathAtZoom(this.imageFileNameProvider, zoom, found);
            if (found[0]) {
                return new ImageData(fileName);
            }
            return DPIUtil.autoScaleImageData(this.device, new ImageData(fileName), zoom, 100);
        }
        return DPIUtil.autoScaleImageData(this.device, this.getImageDataAtCurrentZoom(), zoom, this.currentDeviceZoom);
    }

    @Deprecated
    public ImageData getImageDataAtCurrentZoom() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        switch (this.type) {
            case 1: {
                int i;
                ICONINFO info = new ICONINFO();
                OS.GetIconInfo(this.handle, info);
                long hBitmap = info.hbmColor;
                if (hBitmap == 0L) {
                    hBitmap = info.hbmMask;
                }
                BITMAP bm = new BITMAP();
                OS.GetObject(hBitmap, BITMAP.sizeof, bm);
                int depth = bm.bmPlanes * bm.bmBitsPixel;
                int width = bm.bmWidth;
                if (hBitmap == info.hbmMask) {
                    bm.bmHeight /= 2;
                }
                int height = bm.bmHeight;
                int numColors = 0;
                if (depth <= 8) {
                    numColors = 1 << depth;
                }
                BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
                bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                bmiHeader.biWidth = width;
                bmiHeader.biHeight = -height;
                bmiHeader.biPlanes = 1;
                bmiHeader.biBitCount = (short)depth;
                bmiHeader.biCompression = 0;
                byte[] bmi = new byte[BITMAPINFOHEADER.sizeof + numColors * 4];
                OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
                long hDC = this.device.internal_new_GC(null);
                long hBitmapDC = OS.CreateCompatibleDC(hDC);
                long hOldBitmap = OS.SelectObject(hBitmapDC, hBitmap);
                OS.GetDIBits(hBitmapDC, hBitmap, 0, height, null, bmi, 0);
                OS.MoveMemory(bmiHeader, bmi, BITMAPINFOHEADER.sizeof);
                int imageSize = bmiHeader.biSizeImage;
                byte[] data = new byte[imageSize];
                OS.GetDIBits(hBitmapDC, hBitmap, 0, height, data, bmi, 0);
                PaletteData palette = null;
                if (depth <= 8) {
                    RGB[] rgbs = new RGB[numColors];
                    int srcIndex = 40;
                    for (i = 0; i < numColors; ++i) {
                        rgbs[i] = new RGB(bmi[srcIndex + 2] & 0xFF, bmi[srcIndex + 1] & 0xFF, bmi[srcIndex] & 0xFF);
                        srcIndex += 4;
                    }
                    palette = new PaletteData(rgbs);
                } else if (depth == 16) {
                    palette = new PaletteData(31744, 992, 31);
                } else if (depth == 24) {
                    palette = new PaletteData(255, 65280, 0xFF0000);
                } else if (depth == 32) {
                    palette = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                byte[] maskData = null;
                if (info.hbmColor == 0L) {
                    maskData = new byte[imageSize];
                    OS.GetDIBits(hBitmapDC, hBitmap, height, height, maskData, bmi, 0);
                } else {
                    int calcBpl;
                    int maskPad;
                    bmiHeader = new BITMAPINFOHEADER();
                    bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                    bmiHeader.biWidth = width;
                    bmiHeader.biHeight = -height;
                    bmiHeader.biPlanes = 1;
                    bmiHeader.biBitCount = 1;
                    bmiHeader.biCompression = 0;
                    bmi = new byte[BITMAPINFOHEADER.sizeof + 8];
                    OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
                    int offset = BITMAPINFOHEADER.sizeof;
                    bmi[offset + 6] = -1;
                    bmi[offset + 5] = -1;
                    bmi[offset + 4] = -1;
                    bmi[offset + 7] = 0;
                    OS.SelectObject(hBitmapDC, info.hbmMask);
                    OS.GetDIBits(hBitmapDC, info.hbmMask, 0, height, null, bmi, 0);
                    OS.MoveMemory(bmiHeader, bmi, BITMAPINFOHEADER.sizeof);
                    imageSize = bmiHeader.biSizeImage;
                    maskData = new byte[imageSize];
                    OS.GetDIBits(hBitmapDC, info.hbmMask, 0, height, maskData, bmi, 0);
                    i = 0;
                    while (i < maskData.length) {
                        int n = i++;
                        maskData[n] = ~maskData[n];
                    }
                    int bpl = imageSize / height;
                    for (maskPad = 1; maskPad < 128 && (calcBpl = ((width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad) != bpl; ++maskPad) {
                    }
                    maskData = ImageData.convertPad(maskData, width, height, 1, maskPad, 2);
                }
                OS.SelectObject(hBitmapDC, hOldBitmap);
                OS.DeleteDC(hBitmapDC);
                this.device.internal_dispose_GC(hDC, null);
                if (info.hbmColor != 0L) {
                    OS.DeleteObject(info.hbmColor);
                }
                if (info.hbmMask != 0L) {
                    OS.DeleteObject(info.hbmMask);
                }
                ImageData imageData = new ImageData(width, height, depth, palette, 4, data);
                imageData.maskData = maskData;
                imageData.maskPad = 2;
                return imageData;
            }
            case 0: {
                int imageSize;
                BITMAP bm = new BITMAP();
                OS.GetObject(this.handle, BITMAP.sizeof, bm);
                int depth = bm.bmPlanes * bm.bmBitsPixel;
                int width = bm.bmWidth;
                int height = bm.bmHeight;
                boolean isDib = bm.bmBits != 0L;
                long hDC = this.device.internal_new_GC(null);
                DIBSECTION dib = null;
                if (isDib) {
                    dib = new DIBSECTION();
                    OS.GetObject(this.handle, DIBSECTION.sizeof, dib);
                }
                int numColors = 0;
                if (depth <= 8) {
                    numColors = isDib ? dib.biClrUsed : 1 << depth;
                }
                byte[] bmi = null;
                BITMAPINFOHEADER bmiHeader = null;
                if (!isDib) {
                    bmiHeader = new BITMAPINFOHEADER();
                    bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
                    bmiHeader.biWidth = width;
                    bmiHeader.biHeight = -height;
                    bmiHeader.biPlanes = 1;
                    bmiHeader.biBitCount = (short)depth;
                    bmiHeader.biCompression = 0;
                    bmi = new byte[BITMAPINFOHEADER.sizeof + numColors * 4];
                    OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
                }
                long hBitmapDC = OS.CreateCompatibleDC(hDC);
                long hOldBitmap = OS.SelectObject(hBitmapDC, this.handle);
                if (isDib) {
                    imageSize = dib.biSizeImage;
                } else {
                    OS.GetDIBits(hBitmapDC, this.handle, 0, height, null, bmi, 0);
                    OS.MoveMemory(bmiHeader, bmi, BITMAPINFOHEADER.sizeof);
                    imageSize = bmiHeader.biSizeImage;
                }
                byte[] data = new byte[imageSize];
                if (isDib) {
                    OS.MoveMemory(data, bm.bmBits, imageSize);
                } else {
                    OS.GetDIBits(hBitmapDC, this.handle, 0, height, data, bmi, 0);
                }
                PaletteData palette = null;
                if (depth <= 8) {
                    RGB[] rgbs = new RGB[numColors];
                    if (isDib) {
                        byte[] colors = new byte[numColors * 4];
                        OS.GetDIBColorTable(hBitmapDC, 0, numColors, colors);
                        int colorIndex = 0;
                        for (int i = 0; i < rgbs.length; ++i) {
                            rgbs[i] = new RGB(colors[colorIndex + 2] & 0xFF, colors[colorIndex + 1] & 0xFF, colors[colorIndex] & 0xFF);
                            colorIndex += 4;
                        }
                    } else {
                        int srcIndex = BITMAPINFOHEADER.sizeof;
                        for (int i = 0; i < numColors; ++i) {
                            rgbs[i] = new RGB(bmi[srcIndex + 2] & 0xFF, bmi[srcIndex + 1] & 0xFF, bmi[srcIndex] & 0xFF);
                            srcIndex += 4;
                        }
                    }
                    palette = new PaletteData(rgbs);
                } else if (depth == 16) {
                    palette = new PaletteData(31744, 992, 31);
                } else if (depth == 24) {
                    palette = new PaletteData(255, 65280, 0xFF0000);
                } else if (depth == 32) {
                    palette = new PaletteData(65280, 0xFF0000, -16777216);
                } else {
                    SWT.error(38);
                }
                OS.SelectObject(hBitmapDC, hOldBitmap);
                OS.DeleteDC(hBitmapDC);
                this.device.internal_dispose_GC(hDC, null);
                ImageData imageData = new ImageData(width, height, depth, palette, 4, data);
                imageData.transparentPixel = this.transparentPixel;
                imageData.alpha = this.alpha;
                if (this.alpha == -1 && this.alphaData != null) {
                    imageData.alphaData = new byte[this.alphaData.length];
                    System.arraycopy(this.alphaData, 0, imageData.alphaData, 0, this.alphaData.length);
                }
                return imageData;
            }
        }
        SWT.error(40);
        return null;
    }

    public int hashCode() {
        if (this.imageDataProvider != null) {
            return this.imageDataProvider.hashCode();
        }
        if (this.imageFileNameProvider != null) {
            return this.imageFileNameProvider.hashCode();
        }
        return (int)this.handle;
    }

    void init(int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        long hDC = this.device.internal_new_GC(null);
        this.handle = OS.CreateCompatibleBitmap(hDC, width, height);
        if (this.handle == 0L) {
            int planes;
            int bits = OS.GetDeviceCaps(hDC, 12);
            int depth = bits * (planes = OS.GetDeviceCaps(hDC, 14));
            if (depth < 16) {
                depth = 16;
            }
            this.handle = Image.createDIB(width, height, depth);
        }
        if (this.handle != 0L) {
            long memDC = OS.CreateCompatibleDC(hDC);
            long hOldBitmap = OS.SelectObject(memDC, this.handle);
            OS.PatBlt(memDC, 0, 0, width, height, 15728673);
            OS.SelectObject(memDC, hOldBitmap);
            OS.DeleteDC(memDC);
        }
        this.device.internal_dispose_GC(hDC, null);
        if (this.handle == 0L) {
            SWT.error(2, null, this.device.getLastError());
        }
    }

    static long createDIB(int width, int height, int depth) {
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biWidth = width;
        bmiHeader.biHeight = -height;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)depth;
        bmiHeader.biCompression = 0;
        byte[] bmi = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
        long[] pBits = new long[1];
        return OS.CreateDIBSection(0L, bmi, 0, pBits, 0L, 0);
    }

    static long[] init(Device device, Image image, ImageData i) {
        long[] pBits;
        long hDib;
        if (i.depth == 2) {
            ImageData img = new ImageData(i.width, i.height, 4, i.palette);
            ImageData.blit(1, i.data, i.depth, i.bytesPerLine, i.getByteOrder(), 0, 0, i.width, i.height, null, null, null, 255, null, 0, 0, 0, img.data, img.depth, img.bytesPerLine, i.getByteOrder(), 0, 0, img.width, img.height, null, null, null, false, false);
            img.transparentPixel = i.transparentPixel;
            img.maskPad = i.maskPad;
            img.maskData = i.maskData;
            img.alpha = i.alpha;
            img.alphaData = i.alphaData;
            i = img;
        }
        if (i.palette.isDirect) {
            PaletteData palette = i.palette;
            int redMask = palette.redMask;
            int greenMask = palette.greenMask;
            int blueMask = palette.blueMask;
            int newDepth = i.depth;
            int newOrder = 1;
            PaletteData newPalette = null;
            switch (i.depth) {
                case 8: {
                    newDepth = 16;
                    newOrder = 0;
                    newPalette = new PaletteData(31744, 992, 31);
                    break;
                }
                case 16: {
                    newOrder = 0;
                    if (redMask == 31744 && greenMask == 992 && blueMask == 31) break;
                    newPalette = new PaletteData(31744, 992, 31);
                    break;
                }
                case 24: {
                    if (redMask == 255 && greenMask == 65280 && blueMask == 0xFF0000) break;
                    newPalette = new PaletteData(255, 65280, 0xFF0000);
                    break;
                }
                case 32: {
                    if (redMask == 65280 && greenMask == 0xFF0000 && blueMask == -16777216) break;
                    newPalette = new PaletteData(65280, 0xFF0000, -16777216);
                    break;
                }
                default: {
                    SWT.error(38);
                }
            }
            if (newPalette != null) {
                ImageData img = new ImageData(i.width, i.height, newDepth, newPalette);
                ImageData.blit(1, i.data, i.depth, i.bytesPerLine, i.getByteOrder(), 0, 0, i.width, i.height, redMask, greenMask, blueMask, 255, null, 0, 0, 0, img.data, img.depth, img.bytesPerLine, newOrder, 0, 0, img.width, img.height, newPalette.redMask, newPalette.greenMask, newPalette.blueMask, false, false);
                if (i.transparentPixel != -1) {
                    img.transparentPixel = newPalette.getPixel(palette.getRGB(i.transparentPixel));
                }
                img.maskPad = i.maskPad;
                img.maskData = i.maskData;
                img.alpha = i.alpha;
                img.alphaData = i.alphaData;
                i = img;
            }
        }
        RGB[] rgbs = i.palette.getRGBs();
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = BITMAPINFOHEADER.sizeof;
        bmiHeader.biWidth = i.width;
        bmiHeader.biHeight = -i.height;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)i.depth;
        bmiHeader.biCompression = 0;
        bmiHeader.biClrUsed = rgbs == null ? 0 : rgbs.length;
        byte[] bmi = i.palette.isDirect ? new byte[BITMAPINFOHEADER.sizeof] : new byte[BITMAPINFOHEADER.sizeof + rgbs.length * 4];
        OS.MoveMemory(bmi, bmiHeader, BITMAPINFOHEADER.sizeof);
        int offset = BITMAPINFOHEADER.sizeof;
        if (!i.palette.isDirect) {
            for (int j = 0; j < rgbs.length; ++j) {
                bmi[offset] = (byte)rgbs[j].blue;
                bmi[offset + 1] = (byte)rgbs[j].green;
                bmi[offset + 2] = (byte)rgbs[j].red;
                bmi[offset + 3] = 0;
                offset += 4;
            }
        }
        if ((hDib = OS.CreateDIBSection(0L, bmi, 0, pBits = new long[1], 0L, 0)) == 0L) {
            SWT.error(2);
        }
        byte[] data = i.data;
        if (i.scanlinePad != 4 && i.bytesPerLine % 4 != 0) {
            data = ImageData.convertPad(data, i.width, i.height, i.depth, i.scanlinePad, 4);
        }
        OS.MoveMemory(pBits[0], data, data.length);
        long[] result = null;
        if (i.getTransparencyType() == 2) {
            long hDC = device.internal_new_GC(null);
            long hdcSrc = OS.CreateCompatibleDC(hDC);
            OS.SelectObject(hdcSrc, hDib);
            long hBitmap = OS.CreateCompatibleBitmap(hDC, i.width, i.height);
            if (hBitmap == 0L) {
                SWT.error(2);
            }
            long hdcDest = OS.CreateCompatibleDC(hDC);
            OS.SelectObject(hdcDest, hBitmap);
            OS.BitBlt(hdcDest, 0, 0, i.width, i.height, hdcSrc, 0, 0, 0xCC0020);
            device.internal_dispose_GC(hDC, null);
            byte[] maskData = ImageData.convertPad(i.maskData, i.width, i.height, 1, i.maskPad, 2);
            long hMask = OS.CreateBitmap(i.width, i.height, 1, 1, maskData);
            if (hMask == 0L) {
                SWT.error(2);
            }
            OS.SelectObject(hdcSrc, hMask);
            OS.PatBlt(hdcSrc, 0, 0, i.width, i.height, 0x550009);
            OS.DeleteDC(hdcSrc);
            OS.DeleteDC(hdcDest);
            OS.DeleteObject(hDib);
            if (image == null) {
                result = new long[]{hBitmap, hMask};
            } else {
                ICONINFO info = new ICONINFO();
                info.fIcon = true;
                info.hbmColor = hBitmap;
                info.hbmMask = hMask;
                long hIcon = OS.CreateIconIndirect(info);
                if (hIcon == 0L) {
                    SWT.error(2);
                }
                OS.DeleteObject(hBitmap);
                OS.DeleteObject(hMask);
                image.handle = hIcon;
                image.type = 1;
            }
        } else if (image == null) {
            result = new long[]{hDib};
        } else {
            image.handle = hDib;
            image.type = 0;
            image.transparentPixel = i.transparentPixel;
            if (image.transparentPixel == -1) {
                image.alpha = i.alpha;
                if (i.alpha == -1 && i.alphaData != null) {
                    int length = i.alphaData.length;
                    image.alphaData = new byte[length];
                    System.arraycopy(i.alphaData, 0, image.alphaData, 0, length);
                }
            }
        }
        return result;
    }

    static long[] init(Device device, Image image, ImageData source, ImageData mask) {
        int blackIndex;
        int i;
        ImageData imageData;
        if (source.palette.isDirect) {
            imageData = new ImageData(source.width, source.height, source.depth, source.palette);
        } else {
            RGB[] newRGBs;
            RGB black = new RGB(0, 0, 0);
            RGB[] rgbs = source.getRGBs();
            if (source.transparentPixel != -1) {
                newRGBs = new RGB[rgbs.length];
                System.arraycopy(rgbs, 0, newRGBs, 0, rgbs.length);
                if (source.transparentPixel >= newRGBs.length) {
                    rgbs = new RGB[source.transparentPixel + 1];
                    System.arraycopy(newRGBs, 0, rgbs, 0, newRGBs.length);
                    for (i = newRGBs.length; i <= source.transparentPixel; ++i) {
                        rgbs[i] = new RGB(0, 0, 0);
                    }
                } else {
                    newRGBs[source.transparentPixel] = black;
                    rgbs = newRGBs;
                }
                blackIndex = source.transparentPixel;
                imageData = new ImageData(source.width, source.height, source.depth, new PaletteData(rgbs));
            } else {
                for (blackIndex = 0; blackIndex < rgbs.length && !rgbs[blackIndex].equals(black); ++blackIndex) {
                }
                if (blackIndex == rgbs.length) {
                    if (1 << source.depth > rgbs.length) {
                        newRGBs = new RGB[rgbs.length + 1];
                        System.arraycopy(rgbs, 0, newRGBs, 0, rgbs.length);
                        newRGBs[rgbs.length] = black;
                        rgbs = newRGBs;
                    } else {
                        blackIndex = -1;
                    }
                }
                imageData = new ImageData(source.width, source.height, source.depth, new PaletteData(rgbs));
            }
        }
        if (blackIndex == -1) {
            System.arraycopy(source.data, 0, imageData.data, 0, imageData.data.length);
        } else {
            int[] imagePixels = new int[imageData.width];
            int[] maskPixels = new int[mask.width];
            for (int y = 0; y < imageData.height; ++y) {
                source.getPixels(0, y, imageData.width, imagePixels, 0);
                mask.getPixels(0, y, mask.width, maskPixels, 0);
                for (i = 0; i < imagePixels.length; ++i) {
                    if (maskPixels[i] != 0) continue;
                    imagePixels[i] = blackIndex;
                }
                imageData.setPixels(0, y, source.width, imagePixels, 0);
            }
        }
        imageData.maskPad = mask.scanlinePad;
        imageData.maskData = mask.data;
        return Image.init(device, image, imageData);
    }

    void init(ImageData i) {
        if (i == null) {
            SWT.error(4);
        }
        Image.init(this.device, this, i);
    }

    @Override
    public long internal_new_GC(GCData data) {
        if (this.handle == 0L) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        long hDC = this.device.internal_new_GC(null);
        long imageDC = OS.CreateCompatibleDC(hDC);
        this.device.internal_dispose_GC(hDC, null);
        if (imageDC == 0L) {
            SWT.error(2);
        }
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) != 0) {
                data.layout = (data.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                data.style |= 0x2000000;
            }
            data.device = this.device;
            data.image = this;
            data.font = this.device.systemFont;
        }
        return imageDC;
    }

    @Override
    public void internal_dispose_GC(long hDC, GCData data) {
        OS.DeleteDC(hDC);
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        this.transparentColor = -1;
        long hDC = this.device.internal_new_GC(null);
        BITMAP bm = new BITMAP();
        OS.GetObject(this.handle, BITMAP.sizeof, bm);
        long hdcMem = OS.CreateCompatibleDC(hDC);
        OS.SelectObject(hdcMem, this.handle);
        int maxColors = 1 << bm.bmBitsPixel;
        byte[] colors = new byte[maxColors * 4];
        int numColors = OS.GetDIBColorTable(hdcMem, 0, maxColors, colors);
        int offset = this.transparentPixel * 4;
        colors[offset] = (byte)color.getBlue();
        colors[offset + 1] = (byte)color.getGreen();
        colors[offset + 2] = (byte)color.getRed();
        OS.SetDIBColorTable(hdcMem, 0, numColors, colors);
        OS.DeleteDC(hdcMem);
        this.device.internal_dispose_GC(hDC, null);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }

    public static Image win32_new(Device device, int type, long handle) {
        Image image = new Image(device);
        image.type = type;
        image.handle = handle;
        return image;
    }
}

