/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.EMR;
import org.eclipse.swt.internal.win32.EMREXTCREATEFONTINDIRECTW;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRIC;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    String segmentsText;
    int lineSpacingInPoints = 0;
    int ascentInPixels = -1;
    int descentInPixels = -1;
    int alignment;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int textDirection = 0x2000000;
    int indent;
    int wrapIndent;
    boolean justify;
    int[] tabs;
    int[] segments;
    char[] segmentsChars;
    StyleItem[] styles = new StyleItem[2];
    int stylesCount;
    StyleItem[] allRuns;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    long mLangFontLink2;
    int verticalIndentInPoints = 0;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;
    static final byte[] CLSID_CMultiLanguage = new byte[16];
    static final byte[] IID_IMLangFontLink2 = new byte[16];
    static final int MERGE_MAX = 512;
    static final int TOO_MANY_RUNS = 1024;
    static final int UNDERLINE_IME_DOT = 65536;
    static final int UNDERLINE_IME_DASH = 131072;
    static final int UNDERLINE_IME_THICK = 196608;

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.text = "";
        long[] ppv = new long[1];
        OS.OleInitialize(0L);
        if (OS.CoCreateInstance(CLSID_CMultiLanguage, 0L, 1, IID_IMLangFontLink2, ppv) == 0) {
            this.mLangFontLink2 = ppv[0];
        }
        this.init();
    }

    RECT addClipRect(StyleItem run, RECT clipRect, RECT rect, int selectionStart, int selectionEnd) {
        if (rect != null) {
            boolean isRTL;
            if (clipRect == null) {
                clipRect = new RECT();
                OS.SetRect(clipRect, -1, rect.top, -1, rect.bottom);
            }
            boolean bl = isRTL = (this.orientation & 0x4000000) != 0;
            if (run.start <= selectionStart && selectionStart <= run.start + run.length) {
                if (run.analysis.fRTL ^ isRTL) {
                    clipRect.right = rect.left;
                } else {
                    clipRect.left = rect.left;
                }
            }
            if (run.start <= selectionEnd && selectionEnd <= run.start + run.length) {
                if (run.analysis.fRTL ^ isRTL) {
                    clipRect.left = rect.right;
                } else {
                    clipRect.right = rect.right;
                }
            }
        }
        return clipRect;
    }

    void breakRun(StyleItem run) {
        if (run.psla != 0L) {
            return;
        }
        char[] chars = new char[run.length];
        this.segmentsText.getChars(run.start, run.start + run.length, chars, 0);
        long hHeap = OS.GetProcessHeap();
        run.psla = OS.HeapAlloc(hHeap, 8, SCRIPT_LOGATTR.sizeof * chars.length);
        if (run.psla == 0L) {
            SWT.error(2);
        }
        OS.ScriptBreak(chars, chars.length, run.analysis, run.psla);
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gc) {
        if (this.runs != null) {
            return;
        }
        long hDC = gc != null ? gc.handle : this.device.internal_new_GC(null);
        long srcHdc = OS.CreateCompatibleDC(hDC);
        this.allRuns = this.itemize();
        for (int i = 0; i < this.allRuns.length - 1; ++i) {
            StyleItem run = this.allRuns[i];
            OS.SelectObject(srcHdc, this.getItemFont(run));
            this.shape(srcHdc, run);
        }
        SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES properties = new SCRIPT_PROPERTIES();
        int lineWidth = this.indent;
        int lineStart = 0;
        int lineCount = 1;
        for (int i = 0; i < this.allRuns.length - 1; ++i) {
            StyleItem run = this.allRuns[i];
            if (this.tabs != null && run.tab) {
                int length;
                int j;
                int tabsLength = this.tabs.length;
                for (j = 0; j < tabsLength; ++j) {
                    if (this.tabs[j] <= lineWidth) continue;
                    run.width = this.tabs[j] - lineWidth;
                    break;
                }
                if (j == tabsLength) {
                    int lastTabWidth;
                    int n = lastTabWidth = tabsLength > 1 ? this.tabs[tabsLength - 1] - this.tabs[tabsLength - 2] : this.tabs[0];
                    if (lastTabWidth > 0) {
                        int tabX;
                        for (tabX = this.tabs[tabsLength - 1]; tabX <= lineWidth; tabX += lastTabWidth) {
                        }
                        run.width = tabX - lineWidth;
                    }
                }
                if ((length = run.length) > 1) {
                    int stop = j + length - 1;
                    if (stop < tabsLength) {
                        run.width += this.tabs[stop] - this.tabs[j];
                    } else {
                        if (j < tabsLength) {
                            run.width += this.tabs[tabsLength - 1] - this.tabs[j];
                            length -= tabsLength - 1 - j;
                        }
                        int lastTabWidth = tabsLength > 1 ? this.tabs[tabsLength - 1] - this.tabs[tabsLength - 2] : this.tabs[0];
                        run.width += lastTabWidth * (length - 1);
                    }
                }
            }
            if (this.wrapWidth != -1 && lineWidth + run.width > this.wrapWidth && !run.tab && !run.lineBreak) {
                boolean wrapEntireRun;
                int start = 0;
                int[] piDx = new int[run.length];
                if (run.style != null && run.style.metrics != null) {
                    piDx[0] = run.width;
                } else {
                    OS.ScriptGetLogicalWidths(run.analysis, run.length, run.glyphCount, run.advances, run.clusters, run.visAttrs, piDx);
                }
                int width = 0;
                int maxWidth = this.wrapWidth - lineWidth;
                while (width + piDx[start] < maxWidth) {
                    width += piDx[start++];
                }
                int firstStart = start;
                int firstIndice = i;
                while (i >= lineStart) {
                    this.breakRun(run);
                    while (start >= 0) {
                        OS.MoveMemory(logAttr, run.psla + (long)(start * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                        if (logAttr.fSoftBreak || logAttr.fWhiteSpace) break;
                        --start;
                    }
                    if (start == 0 && i != lineStart && !run.tab && logAttr.fSoftBreak && !logAttr.fWhiteSpace) {
                        OS.MoveMemory(properties, this.device.scripts[run.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        short langID = properties.langid;
                        StyleItem pRun = this.allRuns[i - 1];
                        OS.MoveMemory(properties, this.device.scripts[pRun.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        if (properties.langid == langID || langID == 0 || properties.langid == 0) {
                            this.breakRun(pRun);
                            OS.MoveMemory(logAttr, pRun.psla + (long)((pRun.length - 1) * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                            if (!logAttr.fWhiteSpace) {
                                start = -1;
                            }
                        }
                    }
                    if (start >= 0 || i == lineStart) break;
                    run = this.allRuns[--i];
                    start = run.length - 1;
                }
                boolean bl = wrapEntireRun = start == 0 && i != lineStart && !run.tab;
                if (wrapEntireRun) {
                    this.breakRun(run);
                    OS.MoveMemory(logAttr, run.psla + (long)(start * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                    boolean bl2 = wrapEntireRun = !logAttr.fWhiteSpace;
                }
                if (wrapEntireRun) {
                    run = this.allRuns[--i];
                    start = run.length;
                } else if (start <= 0 && i == lineStart) {
                    if (firstStart == 0 && firstIndice > lineStart) {
                        i = firstIndice - 1;
                        run = this.allRuns[i];
                        start = run.length;
                    } else {
                        i = firstIndice;
                        run = this.allRuns[i];
                        start = Math.max(1, firstStart);
                    }
                }
                this.breakRun(run);
                while (start < run.length) {
                    OS.MoveMemory(logAttr, run.psla + (long)(start * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                    if (!logAttr.fWhiteSpace) break;
                    ++start;
                }
                if (0 < start && start < run.length) {
                    StyleItem newRun = new StyleItem();
                    newRun.start = run.start + start;
                    newRun.length = run.length - start;
                    newRun.style = run.style;
                    newRun.analysis = this.cloneScriptAnalysis(run.analysis);
                    run.free();
                    run.length = start;
                    OS.SelectObject(srcHdc, this.getItemFont(run));
                    run.analysis.fNoGlyphIndex = false;
                    this.shape(srcHdc, run);
                    OS.SelectObject(srcHdc, this.getItemFont(newRun));
                    newRun.analysis.fNoGlyphIndex = false;
                    this.shape(srcHdc, newRun);
                    StyleItem[] newAllRuns = new StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, newAllRuns, 0, i + 1);
                    System.arraycopy(this.allRuns, i + 1, newAllRuns, i + 2, this.allRuns.length - i - 1);
                    this.allRuns = newAllRuns;
                    this.allRuns[i + 1] = newRun;
                }
                if (i != this.allRuns.length - 2) {
                    run.lineBreak = true;
                    run.softBreak = true;
                }
            }
            lineWidth += run.width;
            if (!run.lineBreak) continue;
            lineStart = i + 1;
            lineWidth = run.softBreak ? this.wrapIndent : this.indent;
            ++lineCount;
        }
        lineWidth = 0;
        this.runs = new StyleItem[lineCount][];
        this.lineOffset = new int[lineCount + 1];
        this.lineY = new int[lineCount + 1];
        this.lineWidth = new int[lineCount];
        int lineRunCount = 0;
        int line = 0;
        int ascentInPoints = Math.max(0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.ascentInPixels));
        int descentInPoints = Math.max(0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.descentInPixels));
        StyleItem[] lineRuns = new StyleItem[this.allRuns.length];
        for (int i = 0; i < this.allRuns.length; ++i) {
            StyleItem run = this.allRuns[i];
            lineRuns[lineRunCount++] = run;
            lineWidth += run.width;
            ascentInPoints = Math.max(ascentInPoints, run.ascentInPoints);
            descentInPoints = Math.max(descentInPoints, run.descentInPoints);
            if (!run.lineBreak && i != this.allRuns.length - 1) continue;
            if (!(lineRunCount != 1 || i != this.allRuns.length - 1 && run.softBreak)) {
                TEXTMETRIC lptm = new TEXTMETRIC();
                OS.SelectObject(srcHdc, this.getItemFont(run));
                OS.GetTextMetrics(srcHdc, lptm);
                run.ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmAscent);
                run.descentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmDescent);
                ascentInPoints = Math.max(ascentInPoints, run.ascentInPoints);
                descentInPoints = Math.max(descentInPoints, run.descentInPoints);
            }
            this.runs[line] = new StyleItem[lineRunCount];
            System.arraycopy(lineRuns, 0, this.runs[line], 0, lineRunCount);
            if (this.justify && this.wrapWidth != -1 && run.softBreak && lineWidth > 0) {
                int lineIndent = this.wrapIndent;
                if (line == 0) {
                    lineIndent = this.indent;
                } else {
                    StyleItem[] previousLine = this.runs[line - 1];
                    StyleItem previousRun = previousLine[previousLine.length - 1];
                    if (previousRun.lineBreak && !previousRun.softBreak) {
                        lineIndent = this.indent;
                    }
                }
                lineWidth += lineIndent;
                long hHeap = OS.GetProcessHeap();
                int newLineWidth = 0;
                for (int j = 0; j < this.runs[line].length; ++j) {
                    StyleItem item = this.runs[line][j];
                    int iDx = item.width * this.wrapWidth / lineWidth;
                    if (iDx != item.width) {
                        item.justify = OS.HeapAlloc(hHeap, 8, item.glyphCount * 4);
                        if (item.justify == 0L) {
                            SWT.error(2);
                        }
                        OS.ScriptJustify(item.visAttrs, item.advances, item.glyphCount, iDx - item.width, 2, item.justify);
                        item.width = iDx;
                    }
                    newLineWidth += item.width;
                }
                lineWidth = newLineWidth;
            }
            this.lineWidth[line] = lineWidth;
            StyleItem lastRun = this.runs[line][lineRunCount - 1];
            int lastOffset = lastRun.start + lastRun.length;
            this.runs[line] = this.reorder(this.runs[line], i == this.allRuns.length - 1);
            lastRun = this.runs[line][lineRunCount - 1];
            if (run.softBreak && run != lastRun) {
                run.lineBreak = false;
                run.softBreak = false;
                lastRun.lineBreak = true;
                lastRun.softBreak = true;
            }
            lineWidth = this.getLineIndent(line);
            for (int j = 0; j < this.runs[line].length; ++j) {
                this.runs[line][j].x = lineWidth;
                lineWidth += this.runs[line][j].width;
            }
            this.lineY[++line] = this.lineY[line - 1] + ascentInPoints + descentInPoints + this.lineSpacingInPoints;
            this.lineOffset[line] = lastOffset;
            lineWidth = 0;
            lineRunCount = 0;
            ascentInPoints = Math.max(0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.ascentInPixels));
            descentInPoints = Math.max(0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.descentInPixels));
        }
        if (srcHdc != 0L) {
            OS.DeleteDC(srcHdc);
        }
        if (gc == null) {
            this.device.internal_dispose_GC(hDC, null);
        }
    }

    @Override
    void destroy() {
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        this.segments = null;
        this.segmentsChars = null;
        if (this.mLangFontLink2 != 0L) {
            OS.VtblCall(2, this.mLangFontLink2);
            this.mLangFontLink2 = 0L;
        }
        OS.OleUninitialize();
    }

    SCRIPT_ANALYSIS cloneScriptAnalysis(SCRIPT_ANALYSIS src) {
        SCRIPT_ANALYSIS dst = new SCRIPT_ANALYSIS();
        dst.eScript = src.eScript;
        dst.fRTL = src.fRTL;
        dst.fLayoutRTL = src.fLayoutRTL;
        dst.fLinkBefore = src.fLinkBefore;
        dst.fLinkAfter = src.fLinkAfter;
        dst.fLogicalOrder = src.fLogicalOrder;
        dst.fNoGlyphIndex = src.fNoGlyphIndex;
        dst.s = new SCRIPT_STATE();
        dst.s.uBidiLevel = src.s.uBidiLevel;
        dst.s.fOverrideDirection = src.s.fOverrideDirection;
        dst.s.fInhibitSymSwap = src.s.fInhibitSymSwap;
        dst.s.fCharShape = src.s.fCharShape;
        dst.s.fDigitSubstitute = src.s.fDigitSubstitute;
        dst.s.fInhibitLigate = src.s.fInhibitLigate;
        dst.s.fDisplayZWG = src.s.fDisplayZWG;
        dst.s.fArabicNumContext = src.s.fArabicNumContext;
        dst.s.fGcpClusters = src.s.fGcpClusters;
        dst.s.fReserved = src.s.fReserved;
        dst.s.fEngineReserved = src.s.fEngineReserved;
        return dst;
    }

    int[] computePolyline(int left, int top, int right, int bottom) {
        int length;
        int height = bottom - top;
        int width = 2 * height;
        int peaks = Compatibility.ceil(right - left, width);
        if (peaks == 0 && right - left > 2) {
            peaks = 1;
        }
        if ((length = (2 * peaks + 1) * 2) < 0) {
            return new int[0];
        }
        int[] coordinates = new int[length];
        for (int i = 0; i < peaks; ++i) {
            int index = 4 * i;
            coordinates[index] = left + width * i;
            coordinates[index + 1] = bottom;
            coordinates[index + 2] = coordinates[index] + width / 2;
            coordinates[index + 3] = top;
        }
        coordinates[length - 2] = left + width * peaks;
        coordinates[length - 1] = bottom;
        return coordinates;
    }

    long createGdipBrush(int pixel, int alpha) {
        int argb = (alpha & 0xFF) << 24 | pixel >> 16 & 0xFF | pixel & 0xFF00 | (pixel & 0xFF) << 16;
        return Gdip.SolidBrush_new(argb);
    }

    long createGdipBrush(Color color, int alpha) {
        return this.createGdipBrush(color.handle, alpha);
    }

    public void draw(GC gc, int x, int y) {
        this.checkLayout();
        this.drawInPixels(gc, DPIUtil.autoScaleUp((Drawable)this.getDevice(), x), DPIUtil.autoScaleUp((Drawable)this.getDevice(), y));
    }

    void drawInPixels(GC gc, int x, int y) {
        this.drawInPixels(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.checkLayout();
        this.drawInPixels(gc, DPIUtil.autoScaleUp((Drawable)this.getDevice(), x), DPIUtil.autoScaleUp((Drawable)this.getDevice(), y), selectionStart, selectionEnd, selectionForeground, selectionBackground);
    }

    void drawInPixels(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.drawInPixels(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        this.checkLayout();
        this.drawInPixels(gc, DPIUtil.autoScaleUp((Drawable)this.getDevice(), x), DPIUtil.autoScaleUp((Drawable)this.getDevice(), y), selectionStart, selectionEnd, selectionForeground, selectionBackground, flags);
    }

    void drawInPixels(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        int length;
        this.computeRuns(gc);
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        if ((length = this.text.length()) == 0 && flags == 0) {
            return;
        }
        y += this.getScaledVerticalIndent();
        long hdc = gc.handle;
        Rectangle clip = gc.getClippingInPixels();
        GCData data = gc.data;
        long gdipGraphics = data.gdipGraphics;
        int foreground = data.foreground;
        int linkColor = OS.GetSysColor(26);
        int alpha = data.alpha;
        boolean gdip = gdipGraphics != 0L;
        long gdipForeground = 0L;
        long gdipLinkColor = 0L;
        int state = 0;
        if (gdip) {
            gc.checkGC(1);
            gdipForeground = gc.getFgBrush();
        } else {
            state = OS.SaveDC(hdc);
            if ((data.style & 0x8000000) != 0) {
                OS.SetLayout(hdc, OS.GetLayout(hdc) | 1);
            }
        }
        boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        long gdipSelBackground = 0L;
        long gdipSelForeground = 0L;
        long gdipFont = 0L;
        long lastHFont = 0L;
        long selBackground = 0L;
        int selForeground = 0;
        if (hasSelection || (flags & 0x100000) != 0 && (flags & 0x30000) != 0) {
            int bgSel;
            int fgSel = selectionForeground != null ? selectionForeground.handle : OS.GetSysColor(14);
            int n = bgSel = selectionBackground != null ? selectionBackground.handle : OS.GetSysColor(13);
            if (gdip) {
                gdipSelBackground = this.createGdipBrush(bgSel, alpha);
                gdipSelForeground = this.createGdipBrush(fgSel, alpha);
            } else {
                selBackground = OS.CreateSolidBrush(bgSel);
                selForeground = fgSel;
            }
            if (hasSelection) {
                selectionStart = this.translateOffset(Math.min(Math.max(0, selectionStart), length - 1));
                selectionEnd = this.translateOffset(Math.min(Math.max(0, selectionEnd), length - 1));
            }
        }
        RECT rect = new RECT();
        OS.SetBkMode(hdc, 1);
        block0: for (int line = 0; line < this.runs.length; ++line) {
            int drawX = x + this.getLineIndent(line);
            int drawY = y + DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[line]);
            StyleItem[] lineRuns = this.runs[line];
            int lineHeight = DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[line + 1] - this.lineY[line] - this.lineSpacingInPoints);
            if ((flags & 0x30000) != 0 && (hasSelection || (flags & 0x100000) != 0)) {
                boolean extents = false;
                if (line == this.runs.length - 1 && (flags & 0x100000) != 0) {
                    extents = true;
                } else {
                    StyleItem run = lineRuns[lineRuns.length - 1];
                    if (run.lineBreak && !run.softBreak) {
                        if (selectionStart <= run.start && run.start <= selectionEnd) {
                            extents = true;
                        }
                    } else {
                        int endOffset = run.start + run.length - 1;
                        if (selectionStart <= endOffset && endOffset < selectionEnd && (flags & 0x10000) != 0) {
                            extents = true;
                        }
                    }
                }
                if (extents) {
                    int width = (flags & 0x10000) != 0 ? 0x6FFFFFF : lineHeight / 3;
                    if (gdip) {
                        Gdip.Graphics_FillRectangle(gdipGraphics, gdipSelBackground, drawX + this.lineWidth[line], drawY, width, lineHeight);
                    } else {
                        OS.SelectObject(hdc, selBackground);
                        OS.PatBlt(hdc, drawX + this.lineWidth[line], drawY, width, lineHeight, 15728673);
                    }
                }
            }
            if (drawX > clip.x + clip.width || drawX + this.lineWidth[line] < clip.x) continue;
            int alignmentX = drawX;
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                if (run.length == 0) continue;
                if (drawX > clip.x + clip.width) break;
                if (drawX + run.width >= clip.x && (!run.lineBreak || run.softBreak)) {
                    OS.SetRect(rect, drawX, drawY, drawX + run.width, drawY + lineHeight);
                    if (gdip) {
                        this.drawRunBackgroundGDIP(run, gdipGraphics, rect, selectionStart, selectionEnd, alpha, gdipSelBackground, hasSelection);
                    } else {
                        this.drawRunBackground(run, hdc, rect, selectionStart, selectionEnd, selBackground, hasSelection);
                    }
                }
                drawX += run.width;
            }
            int baselineInPixels = Math.max(0, this.ascentInPixels);
            int lineUnderlinePos = 0;
            for (int i = 0; i < lineRuns.length; ++i) {
                baselineInPixels = Math.max(baselineInPixels, DPIUtil.autoScaleUp((Drawable)this.getDevice(), lineRuns[i].ascentInPoints));
                lineUnderlinePos = Math.min(lineUnderlinePos, lineRuns[i].underlinePos);
            }
            RECT borderClip = null;
            RECT underlineClip = null;
            RECT strikeoutClip = null;
            RECT pRect = null;
            drawX = alignmentX;
            for (int i = 0; i < lineRuns.length; ++i) {
                boolean hasAdorners;
                StyleItem run = lineRuns[i];
                TextStyle style = run.style;
                boolean bl = hasAdorners = style != null && (style.underline || style.strikeout || style.borderStyle != 0);
                if (run.length == 0) continue;
                if (drawX > clip.x + clip.width) continue block0;
                if (drawX + run.width >= clip.x) {
                    boolean skipTab;
                    boolean bl2 = skipTab = run.tab && !hasAdorners;
                    if (!(skipTab || run.lineBreak && !run.softBreak || style != null && style.metrics != null)) {
                        OS.SetRect(rect, drawX, drawY, drawX + run.width, drawY + lineHeight);
                        if (gdip) {
                            long hFont = this.getItemFont(run);
                            if (hFont != lastHFont) {
                                lastHFont = hFont;
                                if (gdipFont != 0L) {
                                    Gdip.Font_delete(gdipFont);
                                }
                                long oldFont = OS.SelectObject(hdc, hFont);
                                gdipFont = Gdip.Font_new(hdc, hFont);
                                OS.SelectObject(hdc, oldFont);
                                if (gdipFont == 0L) {
                                    SWT.error(2);
                                }
                                if (!Gdip.Font_IsAvailable(gdipFont)) {
                                    Gdip.Font_delete(gdipFont);
                                    gdipFont = 0L;
                                }
                            }
                            long gdipFg = gdipForeground;
                            if (style != null && style.underline && style.underlineStyle == 4) {
                                if (gdipLinkColor == 0L) {
                                    gdipLinkColor = this.createGdipBrush(linkColor, alpha);
                                }
                                gdipFg = gdipLinkColor;
                            }
                            if (gdipFont != 0L && !run.analysis.fNoGlyphIndex) {
                                pRect = this.drawRunTextGDIP(gdipGraphics, run, rect, gdipFont, baselineInPixels, gdipFg, gdipSelForeground, selectionStart, selectionEnd, alpha);
                            } else {
                                int fg = style != null && style.underline && style.underlineStyle == 4 ? linkColor : foreground;
                                pRect = this.drawRunTextGDIPRaster(gdipGraphics, run, rect, baselineInPixels, fg, selForeground, selectionStart, selectionEnd);
                            }
                            underlineClip = this.drawUnderlineGDIP(gdipGraphics, x, drawY + baselineInPixels, lineUnderlinePos, drawY + lineHeight, lineRuns, i, gdipFg, gdipSelForeground, underlineClip, pRect, selectionStart, selectionEnd, alpha, clip);
                            strikeoutClip = this.drawStrikeoutGDIP(gdipGraphics, x, drawY + baselineInPixels, lineRuns, i, gdipFg, gdipSelForeground, strikeoutClip, pRect, selectionStart, selectionEnd, alpha, clip);
                            borderClip = this.drawBorderGDIP(gdipGraphics, x, drawY, lineHeight, lineRuns, i, gdipFg, gdipSelForeground, borderClip, pRect, selectionStart, selectionEnd, alpha, clip);
                        } else {
                            int fg = style != null && style.underline && style.underlineStyle == 4 ? linkColor : foreground;
                            pRect = this.drawRunText(hdc, run, rect, baselineInPixels, fg, selForeground, selectionStart, selectionEnd);
                            underlineClip = this.drawUnderline(hdc, x, drawY + baselineInPixels, lineUnderlinePos, drawY + lineHeight, lineRuns, i, fg, selForeground, underlineClip, pRect, selectionStart, selectionEnd, clip);
                            strikeoutClip = this.drawStrikeout(hdc, x, drawY + baselineInPixels, lineRuns, i, fg, selForeground, strikeoutClip, pRect, selectionStart, selectionEnd, clip);
                            borderClip = this.drawBorder(hdc, x, drawY, lineHeight, lineRuns, i, fg, selForeground, borderClip, pRect, selectionStart, selectionEnd, clip);
                        }
                    }
                }
                drawX += run.width;
            }
        }
        if (gdipSelBackground != 0L) {
            Gdip.SolidBrush_delete(gdipSelBackground);
        }
        if (gdipSelForeground != 0L) {
            Gdip.SolidBrush_delete(gdipSelForeground);
        }
        if (gdipLinkColor != 0L) {
            Gdip.SolidBrush_delete(gdipLinkColor);
        }
        if (gdipFont != 0L) {
            Gdip.Font_delete(gdipFont);
        }
        if (state != 0) {
            OS.RestoreDC(hdc, state);
        }
        if (selBackground != 0L) {
            OS.DeleteObject(selBackground);
        }
    }

    RECT drawBorder(long hdc, int x, int y, int lineHeight, StyleItem[] line, int index, int color, int selectionColor, RECT clipRect, RECT pRect, int selectionStart, int selectionEnd, Rectangle drawClip) {
        boolean lastRunVisible;
        StyleItem run = line[index];
        TextStyle style = run.style;
        if (style == null) {
            return null;
        }
        if (style.borderStyle == 0) {
            return null;
        }
        clipRect = this.addClipRect(run, clipRect, pRect, selectionStart, selectionEnd);
        boolean bl = lastRunVisible = drawClip != null && x + run.x + run.width > drawClip.x + drawClip.width;
        if (index + 1 >= line.length || lastRunVisible || !style.isAdherentBorder(line[index + 1].style)) {
            boolean fullSelection;
            int left = run.x;
            int start = run.start;
            int end = run.start + run.length - 1;
            for (int i = index; i > 0 && style.isAdherentBorder(line[i - 1].style); --i) {
                left = line[i - 1].x;
                start = Math.min(start, line[i - 1].start);
                end = Math.max(end, line[i - 1].start + line[i - 1].length - 1);
            }
            boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            boolean bl2 = fullSelection = hasSelection && selectionStart <= start && end <= selectionEnd;
            if (style.borderColor != null) {
                color = style.borderColor.handle;
                clipRect = null;
            } else if (fullSelection) {
                color = selectionColor;
                clipRect = null;
            } else if (style.foreground != null) {
                color = style.foreground.handle;
            }
            int lineWidth = 1;
            int pattern = 1;
            int lineStyle = 0;
            switch (style.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    lineStyle = 1;
                    pattern = 4;
                    break;
                }
                case 4: {
                    lineStyle = 2;
                    pattern = 2;
                }
            }
            long oldBrush = OS.SelectObject(hdc, OS.GetStockObject(5));
            LOGBRUSH logBrush = new LOGBRUSH();
            logBrush.lbStyle = 0;
            logBrush.lbColor = color;
            long newPen = OS.ExtCreatePen(lineStyle | 0x10000, lineWidth, logBrush, 0, null);
            long oldPen = OS.SelectObject(hdc, newPen);
            RECT drawRect = new RECT();
            OS.SetRect(drawRect, x + left, y, x + run.x + run.width, y + lineHeight);
            if (drawClip != null) {
                int remainder;
                if (drawRect.left < drawClip.x) {
                    remainder = drawRect.left % pattern;
                    drawRect.left = drawClip.x / pattern * pattern + remainder - pattern;
                }
                if (drawRect.right > drawClip.x + drawClip.width) {
                    remainder = drawRect.right % pattern;
                    drawRect.right = (drawClip.x + drawClip.width) / pattern * pattern + remainder + pattern;
                }
            }
            OS.Rectangle(hdc, drawRect.left, drawRect.top, drawRect.right, drawRect.bottom);
            OS.SelectObject(hdc, oldPen);
            OS.DeleteObject(newPen);
            if (clipRect != null) {
                int state = OS.SaveDC(hdc);
                if (clipRect.left == -1) {
                    clipRect.left = 0;
                }
                if (clipRect.right == -1) {
                    clipRect.right = 524287;
                }
                OS.IntersectClipRect(hdc, clipRect.left, clipRect.top, clipRect.right, clipRect.bottom);
                logBrush.lbColor = selectionColor;
                long selPen = OS.ExtCreatePen(lineStyle | 0x10000, lineWidth, logBrush, 0, null);
                oldPen = OS.SelectObject(hdc, selPen);
                OS.Rectangle(hdc, drawRect.left, drawRect.top, drawRect.right, drawRect.bottom);
                OS.RestoreDC(hdc, state);
                OS.SelectObject(hdc, oldPen);
                OS.DeleteObject(selPen);
            }
            OS.SelectObject(hdc, oldBrush);
            return null;
        }
        return clipRect;
    }

    RECT drawBorderGDIP(long graphics, int x, int y, int lineHeight, StyleItem[] line, int index, long color, long selectionColor, RECT clipRect, RECT pRect, int selectionStart, int selectionEnd, int alpha, Rectangle drawClip) {
        boolean lastRunVisible;
        StyleItem run = line[index];
        TextStyle style = run.style;
        if (style == null) {
            return null;
        }
        if (style.borderStyle == 0) {
            return null;
        }
        clipRect = this.addClipRect(run, clipRect, pRect, selectionStart, selectionEnd);
        boolean bl = lastRunVisible = drawClip != null && x + run.x + run.width > drawClip.x + drawClip.width;
        if (index + 1 >= line.length || lastRunVisible || !style.isAdherentBorder(line[index + 1].style)) {
            int left = run.x;
            int start = run.start;
            int end = run.start + run.length - 1;
            for (int i = index; i > 0 && style.isAdherentBorder(line[i - 1].style); --i) {
                left = line[i - 1].x;
                start = Math.min(start, line[i - 1].start);
                end = Math.max(end, line[i - 1].start + line[i - 1].length - 1);
            }
            boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            boolean fullSelection = hasSelection && selectionStart <= start && end <= selectionEnd;
            long brush = color;
            if (style.borderColor != null) {
                brush = this.createGdipBrush(style.borderColor, alpha);
                clipRect = null;
            } else if (fullSelection) {
                brush = selectionColor;
                clipRect = null;
            } else if (style.foreground != null) {
                brush = this.createGdipBrush(style.foreground, alpha);
            }
            boolean lineWidth = true;
            int lineStyle = 0;
            switch (style.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    lineStyle = 1;
                    break;
                }
                case 4: {
                    lineStyle = 2;
                }
            }
            long pen = Gdip.Pen_new(brush, (float)lineWidth);
            Gdip.Pen_SetDashStyle(pen, lineStyle);
            Gdip.Graphics_SetPixelOffsetMode(graphics, 3);
            int smoothingMode = Gdip.Graphics_GetSmoothingMode(graphics);
            Gdip.Graphics_SetSmoothingMode(graphics, 3);
            if (clipRect != null) {
                int gstate = Gdip.Graphics_Save(graphics);
                if (clipRect.left == -1) {
                    clipRect.left = 0;
                }
                if (clipRect.right == -1) {
                    clipRect.right = 524287;
                }
                Rect gdipRect = new Rect();
                gdipRect.X = clipRect.left;
                gdipRect.Y = clipRect.top;
                gdipRect.Width = clipRect.right - clipRect.left;
                gdipRect.Height = clipRect.bottom - clipRect.top;
                Gdip.Graphics_SetClip(graphics, gdipRect, 4);
                Gdip.Graphics_DrawRectangle(graphics, pen, x + left, y, run.x + run.width - left - 1, lineHeight - 1);
                Gdip.Graphics_Restore(graphics, gstate);
                gstate = Gdip.Graphics_Save(graphics);
                Gdip.Graphics_SetClip(graphics, gdipRect, 1);
                long selPen = Gdip.Pen_new(selectionColor, (float)lineWidth);
                Gdip.Pen_SetDashStyle(selPen, lineStyle);
                Gdip.Graphics_DrawRectangle(graphics, selPen, x + left, y, run.x + run.width - left - 1, lineHeight - 1);
                Gdip.Pen_delete(selPen);
                Gdip.Graphics_Restore(graphics, gstate);
            } else {
                Gdip.Graphics_DrawRectangle(graphics, pen, x + left, y, run.x + run.width - left - 1, lineHeight - 1);
            }
            Gdip.Graphics_SetPixelOffsetMode(graphics, 4);
            Gdip.Graphics_SetSmoothingMode(graphics, smoothingMode);
            Gdip.Pen_delete(pen);
            if (brush != selectionColor && brush != color) {
                Gdip.SolidBrush_delete(brush);
            }
            return null;
        }
        return clipRect;
    }

    void drawRunBackground(StyleItem run, long hdc, RECT rect, int selectionStart, int selectionEnd, long selBrush, boolean hasSelection) {
        boolean fullSelection;
        int end = run.start + run.length - 1;
        boolean bl = fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
        if (fullSelection) {
            OS.SelectObject(hdc, selBrush);
            OS.PatBlt(hdc, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 15728673);
        } else {
            boolean partialSelection;
            if (run.style != null && run.style.background != null) {
                int bg = run.style.background.handle;
                long hBrush = OS.CreateSolidBrush(bg);
                long oldBrush = OS.SelectObject(hdc, hBrush);
                OS.PatBlt(hdc, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 15728673);
                OS.SelectObject(hdc, oldBrush);
                OS.DeleteObject(hBrush);
            }
            boolean bl2 = partialSelection = hasSelection && selectionStart <= end && run.start <= selectionEnd;
            if (partialSelection) {
                this.getPartialSelection(run, selectionStart, selectionEnd, rect);
                OS.SelectObject(hdc, selBrush);
                OS.PatBlt(hdc, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top, 15728673);
            }
        }
    }

    void drawRunBackgroundGDIP(StyleItem run, long graphics, RECT rect, int selectionStart, int selectionEnd, int alpha, long selBrush, boolean hasSelection) {
        boolean fullSelection;
        int end = run.start + run.length - 1;
        boolean bl = fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
        if (fullSelection) {
            Gdip.Graphics_FillRectangle(graphics, selBrush, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
        } else {
            boolean partialSelection;
            if (run.style != null && run.style.background != null) {
                long brush = this.createGdipBrush(run.style.background, alpha);
                Gdip.Graphics_FillRectangle(graphics, brush, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
                Gdip.SolidBrush_delete(brush);
            }
            boolean bl2 = partialSelection = hasSelection && selectionStart <= end && run.start <= selectionEnd;
            if (partialSelection) {
                this.getPartialSelection(run, selectionStart, selectionEnd, rect);
                if (rect.left > rect.right) {
                    int tmp = rect.left;
                    rect.left = rect.right;
                    rect.right = tmp;
                }
                Gdip.Graphics_FillRectangle(graphics, selBrush, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
            }
        }
    }

    RECT drawRunText(long hdc, StyleItem run, RECT rect, int baselineInPixels, int color, int selectionColor, int selectionStart, int selectionEnd) {
        int end = run.start + run.length - 1;
        boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        boolean fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
        boolean partialSelection = hasSelection && !fullSelection && selectionStart <= end && run.start <= selectionEnd;
        int offset = (this.orientation & 0x4000000) != 0 ? -1 : 0;
        int x = rect.left + offset;
        int y = rect.top + (baselineInPixels - DPIUtil.autoScaleUp((Drawable)this.getDevice(), run.ascentInPoints));
        long hFont = this.getItemFont(run);
        OS.SelectObject(hdc, hFont);
        if (fullSelection) {
            color = selectionColor;
        } else if (run.style != null && run.style.foreground != null) {
            color = run.style.foreground.handle;
        }
        OS.SetTextColor(hdc, color);
        OS.ScriptTextOut(hdc, run.psc, x, y, 0, null, run.analysis, 0L, 0, run.glyphs, run.glyphCount, run.advances, run.justify, run.goffsets);
        if (partialSelection) {
            this.getPartialSelection(run, selectionStart, selectionEnd, rect);
            OS.SetTextColor(hdc, selectionColor);
            OS.ScriptTextOut(hdc, run.psc, x, y, 4, rect, run.analysis, 0L, 0, run.glyphs, run.glyphCount, run.advances, run.justify, run.goffsets);
        }
        return fullSelection || partialSelection ? rect : null;
    }

    RECT drawRunTextGDIP(long graphics, StyleItem run, RECT rect, long gdipFont, int baselineInPixels, long color, long selectionColor, int selectionStart, int selectionEnd, int alpha) {
        boolean isMirrored;
        int end = run.start + run.length - 1;
        boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        boolean fullSelection = hasSelection && selectionStart <= run.start && selectionEnd >= end;
        boolean partialSelection = hasSelection && !fullSelection && selectionStart <= end && run.start <= selectionEnd;
        int drawY = rect.top + baselineInPixels;
        if (run.style != null && run.style.rise != 0) {
            drawY -= DPIUtil.autoScaleUp((Drawable)this.getDevice(), run.style.rise);
        }
        int drawX = rect.left;
        long brush = color;
        if (fullSelection) {
            brush = selectionColor;
        } else if (run.style != null && run.style.foreground != null) {
            brush = this.createGdipBrush(run.style.foreground, alpha);
        }
        int gstate = 0;
        Rect gdipRect = null;
        if (partialSelection) {
            gdipRect = new Rect();
            this.getPartialSelection(run, selectionStart, selectionEnd, rect);
            gdipRect.X = rect.left;
            gdipRect.Y = rect.top;
            gdipRect.Width = rect.right - rect.left;
            gdipRect.Height = rect.bottom - rect.top;
            gstate = Gdip.Graphics_Save(graphics);
            Gdip.Graphics_SetClip(graphics, gdipRect, 4);
        }
        int gstateMirrored = 0;
        boolean bl = isMirrored = (this.orientation & 0x4000000) != 0;
        if (isMirrored) {
            switch (Gdip.Brush_GetType(brush)) {
                case 4: {
                    Gdip.LinearGradientBrush_ScaleTransform(brush, -1.0f, 1.0f, 0);
                    Gdip.LinearGradientBrush_TranslateTransform(brush, -2 * drawX - run.width, 0.0f, 0);
                    break;
                }
                case 2: {
                    Gdip.TextureBrush_ScaleTransform(brush, -1.0f, 1.0f, 0);
                    Gdip.TextureBrush_TranslateTransform(brush, -2 * drawX - run.width, 0.0f, 0);
                }
            }
            gstateMirrored = Gdip.Graphics_Save(graphics);
            Gdip.Graphics_ScaleTransform(graphics, -1.0f, 1.0f, 0);
            Gdip.Graphics_TranslateTransform(graphics, -2 * drawX - run.width, 0.0f, 0);
        }
        int[] advances = new int[run.glyphCount];
        float[] points = new float[run.glyphCount * 2];
        C.memmove(advances, run.justify != 0L ? run.justify : run.advances, (long)(run.glyphCount * 4));
        int glyphX = drawX;
        int j = 0;
        for (int h = 0; h < advances.length; ++h) {
            points[j++] = glyphX;
            points[j++] = drawY;
            glyphX += advances[h];
        }
        Gdip.Graphics_DrawDriverString(graphics, run.glyphs, run.glyphCount, gdipFont, brush, points, 0, 0L);
        if (partialSelection) {
            if (isMirrored) {
                Gdip.Graphics_Restore(graphics, gstateMirrored);
            }
            Gdip.Graphics_Restore(graphics, gstate);
            gstate = Gdip.Graphics_Save(graphics);
            Gdip.Graphics_SetClip(graphics, gdipRect, 1);
            if (isMirrored) {
                gstateMirrored = Gdip.Graphics_Save(graphics);
                Gdip.Graphics_ScaleTransform(graphics, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(graphics, -2 * drawX - run.width, 0.0f, 0);
            }
            Gdip.Graphics_DrawDriverString(graphics, run.glyphs, run.glyphCount, gdipFont, selectionColor, points, 0, 0L);
            Gdip.Graphics_Restore(graphics, gstate);
        }
        if (isMirrored) {
            switch (Gdip.Brush_GetType(brush)) {
                case 4: {
                    Gdip.LinearGradientBrush_ResetTransform(brush);
                    break;
                }
                case 2: {
                    Gdip.TextureBrush_ResetTransform(brush);
                }
            }
            Gdip.Graphics_Restore(graphics, gstateMirrored);
        }
        if (brush != selectionColor && brush != color) {
            Gdip.SolidBrush_delete(brush);
        }
        return fullSelection || partialSelection ? rect : null;
    }

    RECT drawRunTextGDIPRaster(long graphics, StyleItem run, RECT rect, int baselineInPixels, int color, int selectionColor, int selectionStart, int selectionEnd) {
        long clipRgn = 0L;
        Gdip.Graphics_SetPixelOffsetMode(graphics, 3);
        long rgn = Gdip.Region_new();
        if (rgn == 0L) {
            SWT.error(2);
        }
        Gdip.Graphics_GetClip(graphics, rgn);
        if (!Gdip.Region_IsInfinite(rgn, graphics)) {
            clipRgn = Gdip.Region_GetHRGN(rgn, graphics);
        }
        Gdip.Region_delete(rgn);
        Gdip.Graphics_SetPixelOffsetMode(graphics, 4);
        float[] lpXform = null;
        long matrix = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        if (matrix == 0L) {
            SWT.error(2);
        }
        Gdip.Graphics_GetTransform(graphics, matrix);
        if (!Gdip.Matrix_IsIdentity(matrix)) {
            lpXform = new float[6];
            Gdip.Matrix_GetElements(matrix, lpXform);
        }
        Gdip.Matrix_delete(matrix);
        long hdc = Gdip.Graphics_GetHDC(graphics);
        int state = OS.SaveDC(hdc);
        if (lpXform != null) {
            OS.SetGraphicsMode(hdc, 2);
            OS.SetWorldTransform(hdc, lpXform);
        }
        if (clipRgn != 0L) {
            OS.SelectClipRgn(hdc, clipRgn);
            OS.DeleteObject(clipRgn);
        }
        if ((this.orientation & 0x4000000) != 0) {
            OS.SetLayout(hdc, OS.GetLayout(hdc) | 1);
        }
        OS.SetBkMode(hdc, 1);
        RECT pRect = this.drawRunText(hdc, run, rect, baselineInPixels, color, selectionColor, selectionStart, selectionEnd);
        OS.RestoreDC(hdc, state);
        Gdip.Graphics_ReleaseHDC(graphics, hdc);
        return pRect;
    }

    RECT drawStrikeout(long hdc, int x, int baselineInPixels, StyleItem[] line, int index, int color, int selectionColor, RECT clipRect, RECT pRect, int selectionStart, int selectionEnd, Rectangle drawClip) {
        boolean lastRunVisible;
        StyleItem run = line[index];
        TextStyle style = run.style;
        if (style == null) {
            return null;
        }
        if (!style.strikeout) {
            return null;
        }
        clipRect = this.addClipRect(run, clipRect, pRect, selectionStart, selectionEnd);
        boolean bl = lastRunVisible = drawClip != null && x + run.x + run.width > drawClip.x + drawClip.width;
        if (index + 1 >= line.length || lastRunVisible || !style.isAdherentStrikeout(line[index + 1].style)) {
            boolean fullSelection;
            int left = run.x;
            int start = run.start;
            int end = run.start + run.length - 1;
            for (int i = index; i > 0 && style.isAdherentStrikeout(line[i - 1].style); --i) {
                left = line[i - 1].x;
                start = Math.min(start, line[i - 1].start);
                end = Math.max(end, line[i - 1].start + line[i - 1].length - 1);
            }
            boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            boolean bl2 = fullSelection = hasSelection && selectionStart <= start && end <= selectionEnd;
            if (style.strikeoutColor != null) {
                color = style.strikeoutColor.handle;
                clipRect = null;
            } else if (fullSelection) {
                color = selectionColor;
                clipRect = null;
            } else if (style.foreground != null) {
                color = style.foreground.handle;
            }
            RECT rect = new RECT();
            int riseInPixels = DPIUtil.autoScaleUp((Drawable)this.getDevice(), style.rise);
            OS.SetRect(rect, x + left, baselineInPixels - run.strikeoutPos - riseInPixels, x + run.x + run.width, baselineInPixels - run.strikeoutPos + run.strikeoutThickness - riseInPixels);
            long brush = OS.CreateSolidBrush(color);
            OS.FillRect(hdc, rect, brush);
            OS.DeleteObject(brush);
            if (clipRect != null) {
                long selBrush = OS.CreateSolidBrush(selectionColor);
                if (clipRect.left == -1) {
                    clipRect.left = 0;
                }
                if (clipRect.right == -1) {
                    clipRect.right = 524287;
                }
                OS.SetRect(clipRect, Math.max(rect.left, clipRect.left), rect.top, Math.min(rect.right, clipRect.right), rect.bottom);
                OS.FillRect(hdc, clipRect, selBrush);
                OS.DeleteObject(selBrush);
            }
            return null;
        }
        return clipRect;
    }

    RECT drawStrikeoutGDIP(long graphics, int x, int baselineInPixels, StyleItem[] line, int index, long color, long selectionColor, RECT clipRect, RECT pRect, int selectionStart, int selectionEnd, int alpha, Rectangle drawClip) {
        boolean lastRunVisible;
        StyleItem run = line[index];
        TextStyle style = run.style;
        if (style == null) {
            return null;
        }
        if (!style.strikeout) {
            return null;
        }
        clipRect = this.addClipRect(run, clipRect, pRect, selectionStart, selectionEnd);
        boolean bl = lastRunVisible = drawClip != null && x + run.x + run.width > drawClip.x + drawClip.width;
        if (index + 1 >= line.length || lastRunVisible || !style.isAdherentStrikeout(line[index + 1].style)) {
            int left = run.x;
            int start = run.start;
            int end = run.start + run.length - 1;
            for (int i = index; i > 0 && style.isAdherentStrikeout(line[i - 1].style); --i) {
                left = line[i - 1].x;
                start = Math.min(start, line[i - 1].start);
                end = Math.max(end, line[i - 1].start + line[i - 1].length - 1);
            }
            boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            boolean fullSelection = hasSelection && selectionStart <= start && end <= selectionEnd;
            long brush = color;
            if (style.strikeoutColor != null) {
                brush = this.createGdipBrush(style.strikeoutColor, alpha);
                clipRect = null;
            } else if (fullSelection) {
                brush = selectionColor;
                clipRect = null;
            } else if (style.foreground != null) {
                brush = this.createGdipBrush(style.foreground, alpha);
            }
            int riseInPixels = DPIUtil.autoScaleUp((Drawable)this.getDevice(), style.rise);
            if (clipRect != null) {
                int gstate = Gdip.Graphics_Save(graphics);
                if (clipRect.left == -1) {
                    clipRect.left = 0;
                }
                if (clipRect.right == -1) {
                    clipRect.right = 524287;
                }
                Rect gdipRect = new Rect();
                gdipRect.X = clipRect.left;
                gdipRect.Y = clipRect.top;
                gdipRect.Width = clipRect.right - clipRect.left;
                gdipRect.Height = clipRect.bottom - clipRect.top;
                Gdip.Graphics_SetClip(graphics, gdipRect, 4);
                Gdip.Graphics_FillRectangle(graphics, brush, x + left, baselineInPixels - run.strikeoutPos - riseInPixels, run.x + run.width - left, run.strikeoutThickness);
                Gdip.Graphics_Restore(graphics, gstate);
                gstate = Gdip.Graphics_Save(graphics);
                Gdip.Graphics_SetClip(graphics, gdipRect, 1);
                Gdip.Graphics_FillRectangle(graphics, selectionColor, x + left, baselineInPixels - run.strikeoutPos - riseInPixels, run.x + run.width - left, run.strikeoutThickness);
                Gdip.Graphics_Restore(graphics, gstate);
            } else {
                Gdip.Graphics_FillRectangle(graphics, brush, x + left, baselineInPixels - run.strikeoutPos - riseInPixels, run.x + run.width - left, run.strikeoutThickness);
            }
            if (brush != selectionColor && brush != color) {
                Gdip.SolidBrush_delete(brush);
            }
            return null;
        }
        return clipRect;
    }

    RECT drawUnderline(long hdc, int x, int baselineInPixels, int lineUnderlinePos, int lineBottom, StyleItem[] line, int index, int color, int selectionColor, RECT clipRect, RECT pRect, int selectionStart, int selectionEnd, Rectangle drawClip) {
        boolean lastRunVisible;
        StyleItem run = line[index];
        TextStyle style = run.style;
        if (style == null) {
            return null;
        }
        if (!style.underline) {
            return null;
        }
        clipRect = this.addClipRect(run, clipRect, pRect, selectionStart, selectionEnd);
        boolean bl = lastRunVisible = drawClip != null && x + run.x + run.width > drawClip.x + drawClip.width;
        if (index + 1 >= line.length || lastRunVisible || !style.isAdherentUnderline(line[index + 1].style)) {
            boolean fullSelection;
            int left = run.x;
            int start = run.start;
            int end = run.start + run.length - 1;
            for (int i = index; i > 0 && style.isAdherentUnderline(line[i - 1].style); --i) {
                left = line[i - 1].x;
                start = Math.min(start, line[i - 1].start);
                end = Math.max(end, line[i - 1].start + line[i - 1].length - 1);
            }
            boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            boolean bl2 = fullSelection = hasSelection && selectionStart <= start && end <= selectionEnd;
            if (style.underlineColor != null) {
                color = style.underlineColor.handle;
                clipRect = null;
            } else if (fullSelection) {
                color = selectionColor;
                clipRect = null;
            } else if (style.foreground != null) {
                color = style.foreground.handle;
            }
            RECT rect = new RECT();
            int riseInPixels = DPIUtil.autoScaleUp((Drawable)this.getDevice(), style.rise);
            OS.SetRect(rect, x + left, baselineInPixels - lineUnderlinePos - riseInPixels, x + run.x + run.width, baselineInPixels - lineUnderlinePos + run.underlineThickness - riseInPixels);
            if (clipRect != null) {
                if (clipRect.left == -1) {
                    clipRect.left = 0;
                }
                if (clipRect.right == -1) {
                    clipRect.right = 524287;
                }
                OS.SetRect(clipRect, Math.max(rect.left, clipRect.left), rect.top, Math.min(rect.right, clipRect.right), rect.bottom);
            }
            switch (style.underlineStyle) {
                case 2: 
                case 3: {
                    int squigglyThickness = 1;
                    int squigglyHeight = 2 * squigglyThickness;
                    int squigglyY = Math.min(rect.top - squigglyHeight / 2, lineBottom - squigglyHeight - 1);
                    int[] points = this.computePolyline(rect.left, squigglyY, rect.right, squigglyY + squigglyHeight);
                    long pen = OS.CreatePen(0, squigglyThickness, color);
                    long oldPen = OS.SelectObject(hdc, pen);
                    int state = OS.SaveDC(hdc);
                    OS.IntersectClipRect(hdc, rect.left, squigglyY, rect.right + 1, squigglyY + squigglyHeight + 1);
                    OS.Polyline(hdc, points, points.length / 2);
                    int length = points.length;
                    if (length >= 2 && squigglyThickness <= 1) {
                        OS.SetPixel(hdc, points[length - 2], points[length - 1], color);
                    }
                    OS.SelectObject(hdc, oldPen);
                    OS.DeleteObject(pen);
                    OS.RestoreDC(hdc, state);
                    if (clipRect == null) break;
                    pen = OS.CreatePen(0, squigglyThickness, selectionColor);
                    oldPen = OS.SelectObject(hdc, pen);
                    state = OS.SaveDC(hdc);
                    OS.IntersectClipRect(hdc, clipRect.left, squigglyY, clipRect.right + 1, squigglyY + squigglyHeight + 1);
                    OS.Polyline(hdc, points, points.length / 2);
                    if (length >= 2 && squigglyThickness <= 1) {
                        OS.SetPixel(hdc, points[length - 2], points[length - 1], selectionColor);
                    }
                    OS.SelectObject(hdc, oldPen);
                    OS.DeleteObject(pen);
                    OS.RestoreDC(hdc, state);
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 196608: {
                    int bottom;
                    if (style.underlineStyle == 196608) {
                        rect.top -= run.underlineThickness;
                        if (clipRect != null) {
                            clipRect.top -= run.underlineThickness;
                        }
                    }
                    int n = bottom = style.underlineStyle == 1 ? rect.bottom + run.underlineThickness * 2 : rect.bottom;
                    if (bottom > lineBottom) {
                        OS.OffsetRect(rect, 0, lineBottom - bottom);
                        if (clipRect != null) {
                            OS.OffsetRect(clipRect, 0, lineBottom - bottom);
                        }
                    }
                    long brush = OS.CreateSolidBrush(color);
                    OS.FillRect(hdc, rect, brush);
                    if (style.underlineStyle == 1) {
                        OS.SetRect(rect, rect.left, rect.top + run.underlineThickness * 2, rect.right, rect.bottom + run.underlineThickness * 2);
                        OS.FillRect(hdc, rect, brush);
                    }
                    OS.DeleteObject(brush);
                    if (clipRect == null) break;
                    long selBrush = OS.CreateSolidBrush(selectionColor);
                    OS.FillRect(hdc, clipRect, selBrush);
                    if (style.underlineStyle == 1) {
                        OS.SetRect(clipRect, clipRect.left, rect.top, clipRect.right, rect.bottom);
                        OS.FillRect(hdc, clipRect, selBrush);
                    }
                    OS.DeleteObject(selBrush);
                    break;
                }
                case 65536: 
                case 131072: {
                    int penStyle = style.underlineStyle == 131072 ? 1 : 2;
                    long pen = OS.CreatePen(penStyle, 1, color);
                    long oldPen = OS.SelectObject(hdc, pen);
                    int descentInPixels = DPIUtil.autoScaleUp((Drawable)this.getDevice(), run.descentInPoints);
                    OS.SetRect(rect, rect.left, baselineInPixels + descentInPixels, rect.right, baselineInPixels + descentInPixels + run.underlineThickness);
                    OS.MoveToEx(hdc, rect.left, rect.top, 0L);
                    OS.LineTo(hdc, rect.right, rect.top);
                    OS.SelectObject(hdc, oldPen);
                    OS.DeleteObject(pen);
                    if (clipRect == null) break;
                    pen = OS.CreatePen(penStyle, 1, selectionColor);
                    oldPen = OS.SelectObject(hdc, pen);
                    OS.SetRect(clipRect, clipRect.left, rect.top, clipRect.right, rect.bottom);
                    OS.MoveToEx(hdc, clipRect.left, clipRect.top, 0L);
                    OS.LineTo(hdc, clipRect.right, clipRect.top);
                    OS.SelectObject(hdc, oldPen);
                    OS.DeleteObject(pen);
                    break;
                }
            }
            return null;
        }
        return clipRect;
    }

    RECT drawUnderlineGDIP(long graphics, int x, int baselineInPixels, int lineUnderlinePos, int lineBottom, StyleItem[] line, int index, long color, long selectionColor, RECT clipRect, RECT pRect, int selectionStart, int selectionEnd, int alpha, Rectangle drawClip) {
        boolean lastRunVisible;
        StyleItem run = line[index];
        TextStyle style = run.style;
        if (style == null) {
            return null;
        }
        if (!style.underline) {
            return null;
        }
        clipRect = this.addClipRect(run, clipRect, pRect, selectionStart, selectionEnd);
        boolean bl = lastRunVisible = drawClip != null && x + run.x + run.width > drawClip.x + drawClip.width;
        if (index + 1 >= line.length || lastRunVisible || !style.isAdherentUnderline(line[index + 1].style)) {
            int left = run.x;
            int start = run.start;
            int end = run.start + run.length - 1;
            for (int i = index; i > 0 && style.isAdherentUnderline(line[i - 1].style); --i) {
                left = line[i - 1].x;
                start = Math.min(start, line[i - 1].start);
                end = Math.max(end, line[i - 1].start + line[i - 1].length - 1);
            }
            boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
            boolean fullSelection = hasSelection && selectionStart <= start && end <= selectionEnd;
            long brush = color;
            if (style.underlineColor != null) {
                brush = this.createGdipBrush(style.underlineColor, alpha);
                clipRect = null;
            } else if (fullSelection) {
                brush = selectionColor;
                clipRect = null;
            } else if (style.foreground != null) {
                brush = this.createGdipBrush(style.foreground, alpha);
            }
            RECT rect = new RECT();
            int riseInPixels = DPIUtil.autoScaleUp((Drawable)this.getDevice(), style.rise);
            OS.SetRect(rect, x + left, baselineInPixels - lineUnderlinePos - riseInPixels, x + run.x + run.width, baselineInPixels - lineUnderlinePos + run.underlineThickness - riseInPixels);
            Rect gdipRect = null;
            if (clipRect != null) {
                if (clipRect.left == -1) {
                    clipRect.left = 0;
                }
                if (clipRect.right == -1) {
                    clipRect.right = 524287;
                }
                OS.SetRect(clipRect, Math.max(rect.left, clipRect.left), rect.top, Math.min(rect.right, clipRect.right), rect.bottom);
                gdipRect = new Rect();
                gdipRect.X = clipRect.left;
                gdipRect.Y = clipRect.top;
                gdipRect.Width = clipRect.right - clipRect.left;
                gdipRect.Height = clipRect.bottom - clipRect.top;
            }
            int gstate = 0;
            Gdip.Graphics_SetPixelOffsetMode(graphics, 3);
            int smoothingMode = Gdip.Graphics_GetSmoothingMode(graphics);
            Gdip.Graphics_SetSmoothingMode(graphics, 3);
            switch (style.underlineStyle) {
                case 2: 
                case 3: {
                    int squigglyThickness = 1;
                    int squigglyHeight = 2 * squigglyThickness;
                    int squigglyY = Math.min(rect.top - squigglyHeight / 2, lineBottom - squigglyHeight - 1);
                    int[] points = this.computePolyline(rect.left, squigglyY, rect.right, squigglyY + squigglyHeight);
                    long pen = Gdip.Pen_new(brush, squigglyThickness);
                    gstate = Gdip.Graphics_Save(graphics);
                    if (gdipRect != null) {
                        Gdip.Graphics_SetClip(graphics, gdipRect, 4);
                    } else {
                        Rect r = new Rect();
                        r.X = rect.left;
                        r.Y = squigglyY;
                        r.Width = rect.right - rect.left;
                        r.Height = squigglyHeight + 1;
                        Gdip.Graphics_SetClip(graphics, r, 1);
                    }
                    Gdip.Graphics_DrawLines(graphics, pen, points, points.length / 2);
                    if (gdipRect != null) {
                        long selPen = Gdip.Pen_new(selectionColor, squigglyThickness);
                        Gdip.Graphics_Restore(graphics, gstate);
                        gstate = Gdip.Graphics_Save(graphics);
                        Gdip.Graphics_SetClip(graphics, gdipRect, 1);
                        Gdip.Graphics_DrawLines(graphics, selPen, points, points.length / 2);
                        Gdip.Pen_delete(selPen);
                    }
                    Gdip.Graphics_Restore(graphics, gstate);
                    Gdip.Pen_delete(pen);
                    if (gstate == 0) break;
                    Gdip.Graphics_Restore(graphics, gstate);
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 196608: {
                    int bottom;
                    if (style.underlineStyle == 196608) {
                        rect.top -= run.underlineThickness;
                    }
                    int n = bottom = style.underlineStyle == 1 ? rect.bottom + run.underlineThickness * 2 : rect.bottom;
                    if (bottom > lineBottom) {
                        OS.OffsetRect(rect, 0, lineBottom - bottom);
                    }
                    if (gdipRect != null) {
                        gdipRect.Y = rect.top;
                        if (style.underlineStyle == 196608) {
                            gdipRect.Height = run.underlineThickness * 2;
                        }
                        if (style.underlineStyle == 1) {
                            gdipRect.Height = run.underlineThickness * 3;
                        }
                        gstate = Gdip.Graphics_Save(graphics);
                        Gdip.Graphics_SetClip(graphics, gdipRect, 4);
                    }
                    Gdip.Graphics_FillRectangle(graphics, brush, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
                    if (style.underlineStyle == 1) {
                        Gdip.Graphics_FillRectangle(graphics, brush, rect.left, rect.top + run.underlineThickness * 2, rect.right - rect.left, rect.bottom - rect.top);
                    }
                    if (gdipRect == null) break;
                    Gdip.Graphics_Restore(graphics, gstate);
                    gstate = Gdip.Graphics_Save(graphics);
                    Gdip.Graphics_SetClip(graphics, gdipRect, 1);
                    Gdip.Graphics_FillRectangle(graphics, selectionColor, rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
                    if (style.underlineStyle == 1) {
                        Gdip.Graphics_FillRectangle(graphics, selectionColor, rect.left, rect.top + run.underlineThickness * 2, rect.right - rect.left, rect.bottom - rect.top);
                    }
                    Gdip.Graphics_Restore(graphics, gstate);
                    break;
                }
                case 65536: 
                case 131072: {
                    long pen = Gdip.Pen_new(brush, 1.0f);
                    int dashStyle = style.underlineStyle == 65536 ? 2 : 1;
                    Gdip.Pen_SetDashStyle(pen, dashStyle);
                    if (gdipRect != null) {
                        gstate = Gdip.Graphics_Save(graphics);
                        Gdip.Graphics_SetClip(graphics, gdipRect, 4);
                    }
                    int descentInPixels = DPIUtil.autoScaleUp((Drawable)this.getDevice(), run.descentInPoints);
                    Gdip.Graphics_DrawLine(graphics, pen, rect.left, baselineInPixels + descentInPixels, run.width - run.length, baselineInPixels + descentInPixels);
                    if (gdipRect != null) {
                        Gdip.Graphics_Restore(graphics, gstate);
                        gstate = Gdip.Graphics_Save(graphics);
                        Gdip.Graphics_SetClip(graphics, gdipRect, 1);
                        long selPen = Gdip.Pen_new(brush, 1.0f);
                        Gdip.Pen_SetDashStyle(selPen, dashStyle);
                        Gdip.Graphics_DrawLine(graphics, selPen, rect.left, baselineInPixels + descentInPixels, run.width - run.length, baselineInPixels + descentInPixels);
                        Gdip.Graphics_Restore(graphics, gstate);
                        Gdip.Pen_delete(selPen);
                    }
                    Gdip.Pen_delete(pen);
                    break;
                }
            }
            if (brush != selectionColor && brush != color) {
                Gdip.SolidBrush_delete(brush);
            }
            Gdip.Graphics_SetPixelOffsetMode(graphics, 4);
            Gdip.Graphics_SetSmoothingMode(graphics, smoothingMode);
            return null;
        }
        return clipRect;
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        for (int i = 0; i < this.allRuns.length; ++i) {
            StyleItem run = this.allRuns[i];
            run.free();
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.ascentInPixels);
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int width = 0;
        if (this.wrapWidth != -1) {
            width = this.wrapWidth;
        } else {
            for (int line = 0; line < this.runs.length; ++line) {
                width = Math.max(width, this.lineWidth[line] + this.getLineIndent(line));
            }
        }
        return new Rectangle(0, 0, DPIUtil.autoScaleDown((Drawable)this.getDevice(), width), this.lineY[this.lineY.length - 1] + this.getScaledVerticalIndent());
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getBoundsInPixels(start, end));
    }

    Rectangle getBoundsInPixels(int start, int end) {
        this.computeRuns(null);
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        length = this.segmentsText.length();
        char ch = this.segmentsText.charAt(start);
        if ('\udc00' <= ch && ch <= '\udfff' && start - 1 >= 0 && '\ud800' <= (ch = this.segmentsText.charAt(start - 1)) && ch <= '\udbff') {
            --start;
        }
        if ('\ud800' <= (ch = this.segmentsText.charAt(end)) && ch <= '\udbff' && end + 1 < length && '\udc00' <= (ch = this.segmentsText.charAt(end + 1)) && ch <= '\udfff') {
            ++end;
        }
        int left = Integer.MAX_VALUE;
        int right = 0;
        int top = Integer.MAX_VALUE;
        int bottom = 0;
        boolean isRTL = (this.orientation & 0x4000000) != 0;
        for (int i = 0; i < this.allRuns.length - 1; ++i) {
            int lineIndex;
            long advances;
            int[] piX;
            GlyphMetrics metrics;
            int cx;
            StyleItem run = this.allRuns[i];
            int runEnd = run.start + run.length;
            if (runEnd <= start) continue;
            if (run.start > end) break;
            int runLead = run.x;
            int runTrail = run.x + run.width;
            if (run.start <= start && start < runEnd) {
                cx = 0;
                if (run.style != null && run.style.metrics != null) {
                    metrics = run.style.metrics;
                    cx = metrics.getWidthInPixels() * (start - run.start);
                } else if (!run.tab) {
                    piX = new int[1];
                    advances = run.justify != 0L ? run.justify : run.advances;
                    OS.ScriptCPtoX(start - run.start, false, run.length, run.glyphCount, run.clusters, run.visAttrs, advances, run.analysis, piX);
                    int n = cx = isRTL ? run.width - piX[0] : piX[0];
                }
                if (run.analysis.fRTL ^ isRTL) {
                    runTrail = run.x + cx;
                } else {
                    runLead = run.x + cx;
                }
            }
            if (run.start <= end && end < runEnd) {
                cx = run.width;
                if (run.style != null && run.style.metrics != null) {
                    metrics = run.style.metrics;
                    cx = metrics.getWidthInPixels() * (end - run.start + 1);
                } else if (!run.tab) {
                    piX = new int[1];
                    advances = run.justify != 0L ? run.justify : run.advances;
                    OS.ScriptCPtoX(end - run.start, true, run.length, run.glyphCount, run.clusters, run.visAttrs, advances, run.analysis, piX);
                    int n = cx = isRTL ? run.width - piX[0] : piX[0];
                }
                if (run.analysis.fRTL ^ isRTL) {
                    runLead = run.x + cx;
                } else {
                    runTrail = run.x + cx;
                }
            }
            for (lineIndex = 0; lineIndex < this.runs.length && this.lineOffset[lineIndex + 1] <= run.start; ++lineIndex) {
            }
            left = Math.min(left, runLead);
            right = Math.max(right, runTrail);
            top = Math.min(top, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[lineIndex]));
            bottom = Math.max(bottom, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[lineIndex + 1] - this.lineSpacingInPoints));
        }
        return new Rectangle(left, top, right - left, bottom - top + this.getScaledVerticalIndent());
    }

    public int getDescent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.descentInPixels);
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getIndentInPixels());
    }

    int getIndentInPixels() {
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    long getItemFont(StyleItem item) {
        if (item.fallbackFont != 0L) {
            return item.fallbackFont;
        }
        if (item.style != null && item.style.font != null) {
            return item.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.systemFont.handle;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        for (int i = 1; i < this.allRuns.length; ++i) {
            if (this.allRuns[i].start <= offset) continue;
            return this.allRuns[i - 1].analysis.s.uBidiLevel;
        }
        return (this.resolveTextDirection() & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getLineBoundsInPixels(lineIndex));
    }

    Rectangle getLineBoundsInPixels(int lineIndex) {
        this.computeRuns(null);
        if (0 > lineIndex || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        int x = this.getLineIndent(lineIndex);
        int y = DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[lineIndex]);
        int width = this.lineWidth[lineIndex];
        int height = DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[lineIndex + 1] - this.lineY[lineIndex] - this.lineSpacingInPoints);
        return new Rectangle(x, y, width, height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    int getLineIndent(int lineIndex) {
        int lineIndent = this.wrapIndent;
        if (lineIndex == 0) {
            lineIndent = this.indent;
        } else {
            StyleItem[] previousLine = this.runs[lineIndex - 1];
            StyleItem previousRun = previousLine[previousLine.length - 1];
            if (previousRun.lineBreak && !previousRun.softBreak) {
                lineIndent = this.indent;
            }
        }
        if (this.wrapWidth != -1) {
            boolean partialLine = true;
            if (this.justify) {
                StyleItem[] lineRun = this.runs[lineIndex];
                if (lineRun[lineRun.length - 1].softBreak) {
                    partialLine = false;
                }
            }
            if (partialLine) {
                int lineWidth = this.lineWidth[lineIndex] + lineIndent;
                switch (this.alignment) {
                    case 0x1000000: {
                        lineIndent += (this.wrapWidth - lineWidth) / 2;
                        break;
                    }
                    case 131072: {
                        lineIndent += this.wrapWidth - lineWidth;
                    }
                }
            }
        }
        return lineIndent;
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns(null);
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        for (int line = 0; line < this.runs.length; ++line) {
            if (this.lineOffset[line + 1] <= offset) continue;
            return line;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        this.checkLayout();
        this.computeRuns(null);
        if (0 > lineIndex || lineIndex >= this.runs.length) {
            SWT.error(6);
        }
        long hDC = this.device.internal_new_GC(null);
        long srcHdc = OS.CreateCompatibleDC(hDC);
        TEXTMETRIC lptm = new TEXTMETRIC();
        OS.SelectObject(srcHdc, this.font != null ? this.font.handle : this.device.systemFont.handle);
        OS.GetTextMetrics(srcHdc, lptm);
        OS.DeleteDC(srcHdc);
        this.device.internal_dispose_GC(hDC, null);
        int ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), Math.max(lptm.tmAscent, this.ascentInPixels));
        int descentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), Math.max(lptm.tmDescent, this.descentInPixels));
        int leadingInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmInternalLeading);
        if (this.text.length() != 0) {
            StyleItem[] lineRuns = this.runs[lineIndex];
            for (int i = 0; i < lineRuns.length; ++i) {
                StyleItem run = lineRuns[i];
                if (run.ascentInPoints > ascentInPoints) {
                    ascentInPoints = run.ascentInPoints;
                    leadingInPoints = run.leadingInPoints;
                }
                descentInPoints = Math.max(descentInPoints, run.descentInPoints);
            }
        }
        lptm.tmAscent = DPIUtil.autoScaleUp((Drawable)this.getDevice(), ascentInPoints);
        lptm.tmDescent = DPIUtil.autoScaleUp((Drawable)this.getDevice(), descentInPoints);
        lptm.tmHeight = DPIUtil.autoScaleUp((Drawable)this.getDevice(), ascentInPoints + descentInPoints);
        lptm.tmInternalLeading = DPIUtil.autoScaleUp((Drawable)this.getDevice(), leadingInPoints);
        lptm.tmAveCharWidth = 0;
        return FontMetrics.win32_new(lptm);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] offsets = new int[this.lineOffset.length];
        for (int i = 0; i < offsets.length; ++i) {
            offsets[i] = this.untranslateOffset(this.lineOffset[i]);
        }
        return offsets;
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getLocationInPixels(offset, trailing));
    }

    Point getLocationInPixels(int offset, boolean trailing) {
        int line;
        this.computeRuns(null);
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6);
        }
        length = this.segmentsText.length();
        offset = this.translateOffset(offset);
        for (line = 0; line < this.runs.length && this.lineOffset[line + 1] <= offset; ++line) {
        }
        line = Math.min(line, this.runs.length - 1);
        if (offset == length) {
            return new Point(this.getLineIndent(line) + this.lineWidth[line], DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[line]));
        }
        char ch = this.segmentsText.charAt(offset);
        if (trailing) {
            if ('\ud800' <= ch && ch <= '\udbff' && offset + 1 < length && '\udc00' <= (ch = this.segmentsText.charAt(offset + 1)) && ch <= '\udfff') {
                ++offset;
            }
        } else if ('\udc00' <= ch && ch <= '\udfff' && offset - 1 >= 0 && '\ud800' <= (ch = this.segmentsText.charAt(offset - 1)) && ch <= '\udbff') {
            --offset;
        }
        int low = -1;
        int high = this.allRuns.length;
        while (high - low > 1) {
            int width;
            int index = (high + low) / 2;
            StyleItem run = this.allRuns[index];
            if (run.start > offset) {
                high = index;
                continue;
            }
            if (run.start + run.length <= offset) {
                low = index;
                continue;
            }
            if (run.style != null && run.style.metrics != null) {
                GlyphMetrics metrics = run.style.metrics;
                width = metrics.getWidthInPixels() * (offset - run.start + (trailing ? 1 : 0));
            } else if (run.tab) {
                width = trailing || offset == length ? run.width : 0;
            } else {
                int runOffset = offset - run.start;
                int cChars = run.length;
                int gGlyphs = run.glyphCount;
                int[] piX = new int[1];
                long advances = run.justify != 0L ? run.justify : run.advances;
                OS.ScriptCPtoX(runOffset, trailing, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
                width = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
            }
            return new Point(run.x + width, DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[line]) + this.getScaledVerticalIndent());
        }
        return new Point(0, 0);
    }

    public int getNextOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.computeRuns(null);
        int length = this.text.length();
        if (0 > offset || offset > length) {
            SWT.error(6, null, " [offset value: " + offset + "]");
        }
        if (forward && offset == length) {
            return length;
        }
        if (!forward && offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        length = this.segmentsText.length();
        offset = this.translateOffset(offset);
        SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES properties = new SCRIPT_PROPERTIES();
        int i = forward ? 0 : this.allRuns.length - 1;
        offset = this.validadeOffset(offset, step);
        do {
            boolean isComplex;
            StyleItem run = this.allRuns[i];
            if (run.start > offset || offset >= run.start + run.length) continue;
            if (run.lineBreak && !run.softBreak) {
                return this.untranslateOffset(run.start);
            }
            if (run.tab) {
                return this.untranslateOffset(run.start);
            }
            OS.MoveMemory(properties, this.device.scripts[run.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
            boolean bl = isComplex = properties.fNeedsCaretInfo || properties.fNeedsWordBreaking;
            if (isComplex) {
                this.breakRun(run);
            }
            while (run.start <= offset && offset < run.start + run.length) {
                if (isComplex) {
                    OS.MoveMemory(logAttr, run.psla + (long)((offset - run.start) * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                }
                switch (movement) {
                    case 2: {
                        if (properties.fNeedsCaretInfo && (logAttr.fInvalid || !logAttr.fCharStop)) break;
                        char ch = this.segmentsText.charAt(offset);
                        if ('\udc00' <= ch && ch <= '\udfff' && offset > 0 && '\ud800' <= (ch = this.segmentsText.charAt(offset - 1)) && ch <= '\udbff') {
                            offset += step;
                        }
                        return this.untranslateOffset(offset);
                    }
                    case 4: 
                    case 16: {
                        boolean previousLetterOrDigit;
                        boolean letterOrDigit;
                        if (!(properties.fNeedsWordBreaking ? !logAttr.fInvalid && logAttr.fWordStop : offset > 0 && ((letterOrDigit = Character.isLetterOrDigit(this.segmentsText.charAt(offset))) != (previousLetterOrDigit = Character.isLetterOrDigit(this.segmentsText.charAt(offset - 1))) || !letterOrDigit) && !Character.isWhitespace(this.segmentsText.charAt(offset)))) break;
                        return this.untranslateOffset(offset);
                    }
                    case 8: {
                        if (offset <= 0) break;
                        boolean isLetterOrDigit = Character.isLetterOrDigit(this.segmentsText.charAt(offset));
                        boolean previousLetterOrDigit = Character.isLetterOrDigit(this.segmentsText.charAt(offset - 1));
                        if (isLetterOrDigit || !previousLetterOrDigit) break;
                        return this.untranslateOffset(offset);
                    }
                }
                offset = this.validadeOffset(offset, step);
            }
        } while (0 <= (i += step) && i < this.allRuns.length - 1 && 0 <= offset && offset < length);
        return forward ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffsetInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), point), trailing);
    }

    int getOffsetInPixels(Point point, int[] trailing) {
        return this.getOffsetInPixels(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        this.checkLayout();
        return this.getOffsetInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), x), DPIUtil.autoScaleUp((Drawable)this.getDevice(), y), trailing);
    }

    int getOffsetInPixels(int x, int y, int[] trailing) {
        int line;
        this.computeRuns(null);
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        int lineCount = this.runs.length;
        for (line = 0; line < lineCount && DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.lineY[line + 1]) <= y; ++line) {
        }
        line = Math.min(line, this.runs.length - 1);
        StyleItem[] lineRuns = this.runs[line];
        int lineIndent = this.getLineIndent(line);
        if (x >= lineIndent + this.lineWidth[line]) {
            x = lineIndent + this.lineWidth[line] - 1;
        }
        if (x < lineIndent) {
            x = lineIndent;
        }
        int low = -1;
        int high = lineRuns.length;
        while (high - low > 1) {
            char ch;
            GlyphMetrics metrics;
            int index = (high + low) / 2;
            StyleItem run = lineRuns[index];
            if (run.x > x) {
                high = index;
                continue;
            }
            if (run.x + run.width <= x) {
                low = index;
                continue;
            }
            if (run.lineBreak && !run.softBreak) {
                return this.untranslateOffset(run.start);
            }
            int xRun = x - run.x;
            if (run.style != null && run.style.metrics != null && (metrics = run.style.metrics).getWidthInPixels() > 0) {
                if (trailing != null) {
                    trailing[0] = xRun % metrics.getWidthInPixels() < metrics.getWidthInPixels() / 2 ? 0 : 1;
                }
                return this.untranslateOffset(run.start + xRun / metrics.getWidthInPixels());
            }
            if (run.tab) {
                if (trailing != null) {
                    trailing[0] = x < run.x + run.width / 2 ? 0 : 1;
                }
                return this.untranslateOffset(run.start);
            }
            int cChars = run.length;
            int cGlyphs = run.glyphCount;
            int[] piCP = new int[1];
            int[] piTrailing = new int[1];
            if ((this.orientation & 0x4000000) != 0) {
                xRun = run.width - xRun;
            }
            long advances = run.justify != 0L ? run.justify : run.advances;
            OS.ScriptXtoCP(xRun, cChars, cGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piCP, piTrailing);
            int offset = run.start + piCP[0];
            int length = this.segmentsText.length();
            char c = ch = offset < length ? this.segmentsText.charAt(offset) : (char)'\u0000';
            if ('\ud800' <= ch && ch <= '\udbff' && piTrailing[0] <= 1) {
                if (offset + 1 < length && '\udc00' <= (ch = this.segmentsText.charAt(offset + 1)) && ch <= '\udfff' && trailing != null) {
                    trailing[0] = 0;
                }
            } else if ('\udc00' <= ch && ch <= '\udfff' && piTrailing[0] <= 1) {
                if (offset - 1 >= 0 && '\ud800' <= (ch = this.segmentsText.charAt(offset - 1)) && ch <= '\udbff') {
                    --offset;
                    if (trailing != null) {
                        trailing[0] = 2;
                    }
                }
            } else if (trailing != null) {
                trailing[0] = piTrailing[0];
            }
            return this.untranslateOffset(offset);
        }
        if (trailing != null) {
            trailing[0] = 0;
        }
        if (lineRuns.length == 1) {
            StyleItem run = lineRuns[0];
            if (run.lineBreak && !run.softBreak) {
                return this.untranslateOffset(run.start);
            }
        }
        return this.untranslateOffset(this.lineOffset[line + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    void getPartialSelection(StyleItem run, int selectionStart, int selectionEnd, RECT rect) {
        int end = run.start + run.length - 1;
        int selStart = Math.max(selectionStart, run.start) - run.start;
        int selEnd = Math.min(selectionEnd, end) - run.start;
        int cChars = run.length;
        int gGlyphs = run.glyphCount;
        int[] piX = new int[1];
        int x = rect.left;
        long advances = run.justify != 0L ? run.justify : run.advances;
        OS.ScriptCPtoX(selStart, false, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
        int runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
        rect.left = x + runX;
        OS.ScriptCPtoX(selEnd, true, cChars, gGlyphs, run.clusters, run.visAttrs, advances, run.analysis, piX);
        runX = (this.orientation & 0x4000000) != 0 ? run.width - piX[0] : piX[0];
        rect.right = x + runX;
    }

    public int getPreviousOffset(int offset, int movement) {
        this.checkLayout();
        return this._getOffset(offset, movement, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result = new int[this.stylesCount * 2];
        int count = 0;
        for (int i = 0; i < this.stylesCount - 1; ++i) {
            if (this.styles[i].style == null) continue;
            result[count++] = this.styles[i].start;
            result[count++] = this.styles[i + 1].start - 1;
        }
        if (count != result.length) {
            int[] newResult = new int[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int separator;
        int defaultSeparator;
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return this.text;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return this.text;
            }
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int n = defaultSeparator = (this.resolveTextDirection() & 0x4000000) != 0 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                separator = this.segmentsChars != null && this.segmentsChars.length > segmentCount ? this.segmentsChars[segmentCount] : defaultSeparator;
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        while (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            separator = this.segmentsChars != null && this.segmentsChars.length > segmentCount ? this.segmentsChars[segmentCount] : defaultSeparator;
            newChars[charCount + segmentCount++] = separator;
        }
        return new String(newChars, 0, newChars.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacingInPoints;
    }

    public int getVerticalIndent() {
        this.checkLayout();
        return this.verticalIndentInPoints;
    }

    private int getScaledVerticalIndent() {
        if (this.verticalIndentInPoints == 0) {
            return this.verticalIndentInPoints;
        }
        return DPIUtil.autoScaleUp((Drawable)this.getDevice(), this.verticalIndentInPoints);
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (0 > offset || offset >= length) {
            SWT.error(6);
        }
        for (int i = 1; i < this.stylesCount; ++i) {
            if (this.styles[i].start <= offset) continue;
            return this.styles[i - 1].style;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result = new TextStyle[this.stylesCount];
        int count = 0;
        for (int i = 0; i < this.stylesCount; ++i) {
            if (this.styles[i].style == null) continue;
            result[count++] = this.styles[i].style;
        }
        if (count != result.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getTabs() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getTabsInPixels());
    }

    int[] getTabsInPixels() {
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getTextDirection() {
        this.checkLayout();
        return this.resolveTextDirection();
    }

    public int getWidth() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getWidthInPixels());
    }

    int getWidthInPixels() {
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return DPIUtil.autoScaleDown((Drawable)this.getDevice(), this.getWrapIndentInPixels());
    }

    int getWrapIndentInPixels() {
        return this.wrapIndent;
    }

    @Override
    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        this.segmentsText = this.getSegmentsText();
        int length = this.segmentsText.length();
        SCRIPT_CONTROL scriptControl = new SCRIPT_CONTROL();
        SCRIPT_STATE scriptState = new SCRIPT_STATE();
        int MAX_ITEM = length + 1;
        if ((this.resolveTextDirection() & 0x4000000) != 0) {
            scriptState.uBidiLevel = 1;
            scriptState.fArabicNumContext = true;
        }
        OS.ScriptApplyDigitSubstitution(null, scriptControl, scriptState);
        long hHeap = OS.GetProcessHeap();
        long pItems = OS.HeapAlloc(hHeap, 8, MAX_ITEM * SCRIPT_ITEM.sizeof);
        if (pItems == 0L) {
            SWT.error(2);
        }
        int[] pcItems = new int[1];
        char[] chars = new char[length];
        this.segmentsText.getChars(0, length, chars, 0);
        OS.ScriptItemize(chars, length, MAX_ITEM, scriptControl, scriptState, pItems, pcItems);
        StyleItem[] runs = this.merge(pItems, pcItems[0]);
        OS.HeapFree(hHeap, 0, pItems);
        return runs;
    }

    StyleItem[] merge(long items, int itemCount) {
        StyleItem item;
        if (this.styles.length > this.stylesCount) {
            StyleItem[] newStyles = new StyleItem[this.stylesCount];
            System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
            this.styles = newStyles;
        }
        int count = 0;
        int start = 0;
        int end = this.segmentsText.length();
        int itemIndex = 0;
        int styleIndex = 0;
        StyleItem[] runs = new StyleItem[itemCount + this.stylesCount];
        SCRIPT_ITEM scriptItem = new SCRIPT_ITEM();
        int itemLimit = -1;
        int nextItemIndex = 0;
        boolean linkBefore = false;
        boolean merge = itemCount > 1024;
        SCRIPT_PROPERTIES sp = new SCRIPT_PROPERTIES();
        while (start < end) {
            int styleLimit;
            item = new StyleItem();
            item.start = start;
            item.style = this.styles[styleIndex].style;
            runs[count++] = item;
            OS.MoveMemory(scriptItem, items + (long)(itemIndex * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
            item.analysis = scriptItem.a;
            scriptItem.a = new SCRIPT_ANALYSIS();
            if (linkBefore) {
                item.analysis.fLinkBefore = true;
                linkBefore = false;
            }
            char ch = this.segmentsText.charAt(start);
            switch (ch) {
                case '\n': 
                case '\r': {
                    item.lineBreak = true;
                    break;
                }
                case '\t': {
                    item.tab = true;
                }
            }
            if (itemLimit == -1) {
                nextItemIndex = itemIndex + 1;
                OS.MoveMemory(scriptItem, items + (long)(nextItemIndex * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
                itemLimit = scriptItem.iCharPos;
                if (nextItemIndex < itemCount && ch == '\r' && this.segmentsText.charAt(itemLimit) == '\n') {
                    nextItemIndex = itemIndex + 2;
                    OS.MoveMemory(scriptItem, items + (long)(nextItemIndex * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
                    itemLimit = scriptItem.iCharPos;
                }
                if (nextItemIndex < itemCount && merge && !item.lineBreak) {
                    OS.MoveMemory(sp, this.device.scripts[item.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                    if (!sp.fComplex || item.tab) {
                        char c;
                        for (int i = 0; i < 512 && nextItemIndex != itemCount && (c = this.segmentsText.charAt(itemLimit)) != '\n' && c != '\r' && c == '\t' == item.tab; ++i) {
                            OS.MoveMemory(sp, this.device.scripts[scriptItem.a.eScript], SCRIPT_PROPERTIES.sizeof);
                            if (!item.tab && sp.fComplex) break;
                            OS.MoveMemory(scriptItem, items + (long)(++nextItemIndex * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
                            itemLimit = scriptItem.iCharPos;
                        }
                    }
                }
            }
            if ((styleLimit = this.translateOffset(this.styles[styleIndex + 1].start)) <= itemLimit) {
                ++styleIndex;
                start = styleLimit;
                if (start < itemLimit && 0 < start && start < end) {
                    char pChar = this.segmentsText.charAt(start - 1);
                    char tChar = this.segmentsText.charAt(start);
                    if (Character.isLetter(pChar) && Character.isLetter(tChar)) {
                        item.analysis.fLinkAfter = true;
                        linkBefore = true;
                    }
                }
            }
            if (itemLimit <= styleLimit) {
                itemIndex = nextItemIndex;
                start = itemLimit;
                itemLimit = -1;
            }
            item.length = start - item.start;
        }
        item = new StyleItem();
        item.start = end;
        OS.MoveMemory(scriptItem, items + (long)(itemCount * SCRIPT_ITEM.sizeof), SCRIPT_ITEM.sizeof);
        item.analysis = scriptItem.a;
        runs[count++] = item;
        if (runs.length != count) {
            StyleItem[] result = new StyleItem[count];
            System.arraycopy(runs, 0, result, 0, count);
            return result;
        }
        return runs;
    }

    int resolveTextDirection() {
        return this.textDirection == 0x6000000 ? BidiUtil.resolveTextDirection(this.text) : this.textDirection;
    }

    StyleItem[] reorder(StyleItem[] runs, boolean terminate) {
        int i;
        int length = runs.length;
        if (length <= 1) {
            return runs;
        }
        byte[] bidiLevels = new byte[length];
        for (int i2 = 0; i2 < length; ++i2) {
            bidiLevels[i2] = (byte)(runs[i2].analysis.s.uBidiLevel & 0x1F);
        }
        StyleItem lastRun = runs[length - 1];
        if (lastRun.lineBreak && !lastRun.softBreak) {
            bidiLevels[length - 1] = 0;
        }
        int[] log2vis = new int[length];
        OS.ScriptLayout(length, bidiLevels, null, log2vis);
        StyleItem[] result = new StyleItem[length];
        for (i = 0; i < length; ++i) {
            result[log2vis[i]] = runs[i];
        }
        if ((this.orientation & 0x4000000) != 0) {
            if (terminate) {
                --length;
            }
            for (i = 0; i < length / 2; ++i) {
                StyleItem tmp = result[i];
                result[i] = result[length - i - 1];
                result[length - i - 1] = tmp;
            }
        }
        return result;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        if (this.alignment == alignment) {
            return;
        }
        this.freeRuns();
        this.alignment = alignment;
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascentInPixels == (ascent = DPIUtil.autoScaleUp((Drawable)this.getDevice(), ascent))) {
            return;
        }
        this.freeRuns();
        this.ascentInPixels = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descentInPixels == (descent = DPIUtil.autoScaleUp((Drawable)this.getDevice(), descent))) {
            return;
        }
        this.freeRuns();
        this.descentInPixels = descent;
    }

    public void setFont(Font font) {
        Font oldFont;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((oldFont = this.font) == font) {
            return;
        }
        this.font = font;
        if (oldFont != null && oldFont.equals(font)) {
            return;
        }
        this.freeRuns();
    }

    public void setIndent(int indent) {
        this.checkLayout();
        this.setIndentInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), indent));
    }

    void setIndentInPixels(int indent) {
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        this.freeRuns();
        this.indent = indent;
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        if (this.justify == justify) {
            return;
        }
        this.freeRuns();
        this.justify = justify;
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (this.orientation == orientation) {
            return;
        }
        this.textDirection = this.orientation = orientation;
        this.freeRuns();
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i;
            for (i = 0; i < segments.length && this.segments[i] == segments[i]; ++i) {
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setSegmentsChars(char[] segmentsChars) {
        this.checkLayout();
        if (this.segmentsChars == null && segmentsChars == null) {
            return;
        }
        if (this.segmentsChars != null && segmentsChars != null && this.segmentsChars.length == segmentsChars.length) {
            int i;
            for (i = 0; i < segmentsChars.length && this.segmentsChars[i] == segmentsChars[i]; ++i) {
            }
            if (i == segmentsChars.length) {
                return;
            }
        }
        this.freeRuns();
        this.segmentsChars = segmentsChars;
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.lineSpacingInPoints == spacing) {
            return;
        }
        this.freeRuns();
        this.lineSpacingInPoints = spacing;
    }

    public void setVerticalIndent(int verticalIndent) {
        this.checkLayout();
        if (verticalIndent < 0) {
            SWT.error(5);
        }
        if (this.verticalIndentInPoints == verticalIndent) {
            return;
        }
        this.verticalIndentInPoints = verticalIndent;
    }

    public void setStyle(TextStyle style, int start, int end) {
        int newLength;
        int modifyStart;
        int modifyEnd;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int low = -1;
        int high = this.stylesCount;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (this.styles[index + 1].start > start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (0 <= high && high < this.stylesCount) {
            StyleItem item = this.styles[high];
            if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style))) {
                return;
            }
        }
        this.freeRuns();
        for (modifyEnd = modifyStart = high; modifyEnd < this.stylesCount && this.styles[modifyEnd + 1].start <= end; ++modifyEnd) {
        }
        if (modifyStart == modifyEnd) {
            int styleStart = this.styles[modifyStart].start;
            int styleEnd = this.styles[modifyEnd + 1].start - 1;
            if (styleStart == start && styleEnd == end) {
                this.styles[modifyStart].style = style;
                return;
            }
            if (styleStart != start && styleEnd != end) {
                int newLength2 = this.stylesCount + 2;
                if (newLength2 > this.styles.length) {
                    int newSize = Math.min(newLength2 + 1024, Math.max(64, newLength2 * 2));
                    StyleItem[] newStyles = new StyleItem[newSize];
                    System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
                    this.styles = newStyles;
                }
                System.arraycopy(this.styles, modifyEnd + 1, this.styles, modifyEnd + 3, this.stylesCount - modifyEnd - 1);
                StyleItem item = new StyleItem();
                item.start = start;
                item.style = style;
                this.styles[modifyStart + 1] = item;
                item = new StyleItem();
                item.start = end + 1;
                item.style = this.styles[modifyStart].style;
                this.styles[modifyStart + 2] = item;
                this.stylesCount = newLength2;
                return;
            }
        }
        if (start == this.styles[modifyStart].start) {
            --modifyStart;
        }
        if (end == this.styles[modifyEnd + 1].start - 1) {
            ++modifyEnd;
        }
        if ((newLength = this.stylesCount + 1 - (modifyEnd - modifyStart - 1)) > this.styles.length) {
            int newSize = Math.min(newLength + 1024, Math.max(64, newLength * 2));
            StyleItem[] newStyles = new StyleItem[newSize];
            System.arraycopy(this.styles, 0, newStyles, 0, this.stylesCount);
            this.styles = newStyles;
        }
        System.arraycopy(this.styles, modifyEnd, this.styles, modifyStart + 2, this.stylesCount - modifyEnd);
        StyleItem item = new StyleItem();
        item.start = start;
        item.style = style;
        this.styles[modifyStart + 1] = item;
        this.styles[modifyStart + 2].start = end + 1;
        this.stylesCount = newLength;
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        this.setTabsInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), tabs));
    }

    void setTabsInPixels(int[] tabs) {
        if (Arrays.equals(this.tabs, tabs)) {
            return;
        }
        this.freeRuns();
        this.tabs = tabs;
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = text.length();
        this.stylesCount = 2;
    }

    public void setTextDirection(int textDirection) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((textDirection &= mask) == 0) {
            return;
        }
        if (textDirection != 0x6000000) {
            if ((textDirection & 0x2000000) != 0) {
                textDirection = 0x2000000;
            }
            if (this.textDirection == textDirection) {
                return;
            }
        }
        this.textDirection = textDirection;
        this.freeRuns();
    }

    public void setWidth(int width) {
        this.checkLayout();
        this.setWidthInPixels(width != -1 ? DPIUtil.autoScaleUp((Drawable)this.getDevice(), width) : width);
    }

    void setWidthInPixels(int width) {
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == width) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = width;
    }

    public void setWrapIndent(int wrapIndent) {
        this.checkLayout();
        this.setWrapIndentInPixels(DPIUtil.autoScaleUp((Drawable)this.getDevice(), wrapIndent));
    }

    void setWrapIndentInPixels(int wrapIndent) {
        if (wrapIndent < 0) {
            return;
        }
        if (this.wrapIndent == wrapIndent) {
            return;
        }
        this.freeRuns();
        this.wrapIndent = wrapIndent;
    }

    boolean shape(long hdc, StyleItem run, char[] chars, int[] glyphCount, int maxGlyphs, SCRIPT_PROPERTIES sp) {
        short[] glyphs;
        boolean useCMAPcheck;
        boolean bl = useCMAPcheck = !sp.fComplex && !run.analysis.fNoGlyphIndex;
        if (useCMAPcheck && OS.ScriptGetCMap(hdc, run.psc, chars, chars.length, 0, glyphs = new short[chars.length]) != 0) {
            if (run.psc != 0L) {
                OS.ScriptFreeCache(run.psc);
                glyphCount[0] = 0;
                OS.MoveMemory(run.psc, new long[1], C.PTR_SIZEOF);
            }
            return false;
        }
        int hr = OS.ScriptShape(hdc, run.psc, chars, chars.length, maxGlyphs, run.analysis, run.glyphs, run.clusters, run.visAttrs, glyphCount);
        run.glyphCount = glyphCount[0];
        if (useCMAPcheck) {
            return true;
        }
        if (hr != -2147220992) {
            int i;
            if (run.analysis.fNoGlyphIndex) {
                return true;
            }
            SCRIPT_FONTPROPERTIES fp = new SCRIPT_FONTPROPERTIES();
            fp.cBytes = SCRIPT_FONTPROPERTIES.sizeof;
            OS.ScriptGetFontProperties(hdc, run.psc, fp);
            short[] glyphs2 = new short[glyphCount[0]];
            OS.MoveMemory(glyphs2, run.glyphs, glyphs2.length * 2);
            for (i = 0; i < glyphs2.length && glyphs2[i] != fp.wgDefault; ++i) {
            }
            if (i == glyphs2.length) {
                return true;
            }
        }
        if (run.psc != 0L) {
            OS.ScriptFreeCache(run.psc);
            glyphCount[0] = 0;
            OS.MoveMemory(run.psc, new long[1], C.PTR_SIZEOF);
        }
        run.glyphCount = 0;
        return false;
    }

    long createMetafileWithChars(long hdc, long hFont, char[] chars, int charCount) {
        long hHeap = OS.GetProcessHeap();
        int nativeStringSize = charCount * 2;
        long nativeString = OS.HeapAlloc(hHeap, 8, nativeStringSize);
        OS.MoveMemory(nativeString, chars, nativeStringSize);
        long ssa = OS.HeapAlloc(hHeap, 8, OS.SCRIPT_STRING_ANALYSIS_sizeof());
        long metaFileDc = OS.CreateEnhMetaFile(hdc, null, null, null);
        long oldMetaFont = OS.SelectObject(metaFileDc, hFont);
        int flags = 6304;
        if (OS.ScriptStringAnalyse(metaFileDc, nativeString, charCount, 0, -1, flags, 0, null, null, 0L, 0L, 0L, ssa) == 0) {
            OS.ScriptStringOut(ssa, 0, 0, 0, null, 0, 0, false);
            OS.ScriptStringFree(ssa);
        }
        OS.HeapFree(hHeap, 0, nativeString);
        OS.HeapFree(hHeap, 0, ssa);
        OS.SelectObject(metaFileDc, oldMetaFont);
        return OS.CloseEnhMetaFile(metaFileDc);
    }

    void shape(long hdc, StyleItem run) {
        if (run.lineBreak) {
            return;
        }
        if (run.glyphs != 0L) {
            return;
        }
        int[] buffer = new int[1];
        char[] chars = new char[run.length];
        this.segmentsText.getChars(run.start, run.start + run.length, chars, 0);
        int maxGlyphs = chars.length * 3 / 2 + 16;
        long hHeap = OS.GetProcessHeap();
        run.glyphs = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        if (run.glyphs == 0L) {
            SWT.error(2);
        }
        run.clusters = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        if (run.clusters == 0L) {
            SWT.error(2);
        }
        run.visAttrs = OS.HeapAlloc(hHeap, 8, maxGlyphs * 2);
        if (run.visAttrs == 0L) {
            SWT.error(2);
        }
        run.psc = OS.HeapAlloc(hHeap, 8, C.PTR_SIZEOF);
        if (run.psc == 0L) {
            SWT.error(2);
        }
        short script = run.analysis.eScript;
        SCRIPT_PROPERTIES sp = new SCRIPT_PROPERTIES();
        OS.MoveMemory(sp, this.device.scripts[script], SCRIPT_PROPERTIES.sizeof);
        boolean shapeSucceed = this.shape(hdc, run, chars, buffer, maxGlyphs, sp);
        if (!shapeSucceed && sp.fPrivateUseArea) {
            run.analysis.fNoGlyphIndex = true;
            shapeSucceed = this.shape(hdc, run, chars, buffer, maxGlyphs, sp);
        }
        if (!shapeSucceed) {
            long hFont = OS.GetCurrentObject(hdc, 6);
            long newFont = 0L;
            char[] sampleChars = new char[Math.min(chars.length, 2)];
            SCRIPT_LOGATTR logAttr = new SCRIPT_LOGATTR();
            this.breakRun(run);
            int count = 0;
            for (int i = 0; i < chars.length; ++i) {
                OS.MoveMemory(logAttr, run.psla + (long)(i * SCRIPT_LOGATTR.sizeof), SCRIPT_LOGATTR.sizeof);
                if (logAttr.fWhiteSpace) continue;
                sampleChars[count++] = chars[i];
                if (count == sampleChars.length) break;
            }
            if (count > 0) {
                Callback callback;
                long address;
                long metaFile = this.createMetafileWithChars(hdc, hFont, sampleChars, count);
                final EMREXTCREATEFONTINDIRECTW emr = new EMREXTCREATEFONTINDIRECTW();
                class MetaFileEnumProc {
                    MetaFileEnumProc() {
                    }

                    long metaFileEnumProc(long hDC, long table, long record, long nObj, long lpData) {
                        OS.MoveMemory(emr.emr, record, EMR.sizeof);
                        switch (emr.emr.iType) {
                            case 82: {
                                OS.MoveMemory(emr, record, EMREXTCREATEFONTINDIRECTW.sizeof);
                                break;
                            }
                            case 84: {
                                return 0L;
                            }
                        }
                        return 1L;
                    }
                }
                MetaFileEnumProc object = new MetaFileEnumProc();
                boolean compilerWarningWorkaround = false;
                if (compilerWarningWorkaround) {
                    object.metaFileEnumProc(0L, 0L, 0L, 0L, 0L);
                }
                if ((address = (callback = new Callback(object, "metaFileEnumProc", 5)).getAddress()) == 0L) {
                    SWT.error(3);
                }
                OS.EnumEnhMetaFile(0L, metaFile, address, 0L, null);
                OS.DeleteEnhMetaFile(metaFile);
                callback.dispose();
                newFont = OS.CreateFontIndirect(emr.elfw.elfLogFont);
            } else {
                for (int index = 0; index < this.allRuns.length - 1; ++index) {
                    LOGFONT logFont;
                    if (this.allRuns[index] != run) continue;
                    if (index > 0) {
                        StyleItem pRun = this.allRuns[index - 1];
                        if (pRun.analysis.eScript == run.analysis.eScript) {
                            long pFont = this.getItemFont(pRun);
                            logFont = new LOGFONT();
                            OS.GetObject(pFont, LOGFONT.sizeof, logFont);
                            newFont = OS.CreateFontIndirect(logFont);
                        }
                    }
                    if (newFont != 0L || index + 1 >= this.allRuns.length - 1) break;
                    StyleItem nRun = this.allRuns[index + 1];
                    if (nRun.analysis.eScript != run.analysis.eScript) break;
                    OS.SelectObject(hdc, this.getItemFont(nRun));
                    this.shape(hdc, nRun);
                    long nFont = this.getItemFont(nRun);
                    logFont = new LOGFONT();
                    OS.GetObject(nFont, LOGFONT.sizeof, logFont);
                    newFont = OS.CreateFontIndirect(logFont);
                    break;
                }
            }
            if (newFont != 0L) {
                OS.SelectObject(hdc, newFont);
                shapeSucceed = this.shape(hdc, run, chars, buffer, maxGlyphs, sp);
                if (shapeSucceed) {
                    run.fallbackFont = newFont;
                }
            }
            if (!shapeSucceed && !sp.fComplex) {
                run.analysis.fNoGlyphIndex = true;
                shapeSucceed = this.shape(hdc, run, chars, buffer, maxGlyphs, sp);
                if (shapeSucceed) {
                    run.fallbackFont = newFont;
                } else {
                    run.analysis.fNoGlyphIndex = false;
                }
            }
            if (!shapeSucceed && this.mLangFontLink2 != 0L) {
                long[] hNewFont = new long[1];
                int[] dwCodePages = new int[1];
                int[] cchCodePages = new int[1];
                OS.VtblCall(4, this.mLangFontLink2, chars, chars.length, 0, dwCodePages, cchCodePages);
                if (OS.VtblCall(10, this.mLangFontLink2, hdc, dwCodePages[0], (int)chars[0], hNewFont) == 0) {
                    LOGFONT logFont = new LOGFONT();
                    OS.GetObject(hNewFont[0], LOGFONT.sizeof, logFont);
                    OS.VtblCall(8, this.mLangFontLink2, hNewFont[0]);
                    long mLangFont = OS.CreateFontIndirect(logFont);
                    long oldFont = OS.SelectObject(hdc, mLangFont);
                    shapeSucceed = this.shape(hdc, run, chars, buffer, maxGlyphs, sp);
                    if (shapeSucceed) {
                        run.fallbackFont = mLangFont;
                    } else {
                        OS.SelectObject(hdc, oldFont);
                        OS.DeleteObject(mLangFont);
                    }
                }
            }
            if (!shapeSucceed) {
                OS.SelectObject(hdc, hFont);
            }
            if (newFont != 0L && newFont != run.fallbackFont) {
                OS.DeleteObject(newFont);
            }
        }
        if (!shapeSucceed) {
            OS.ScriptShape(hdc, run.psc, chars, chars.length, maxGlyphs, run.analysis, run.glyphs, run.clusters, run.visAttrs, buffer);
            run.glyphCount = buffer[0];
        }
        int[] abc = new int[3];
        run.advances = OS.HeapAlloc(hHeap, 8, run.glyphCount * 4);
        if (run.advances == 0L) {
            SWT.error(2);
        }
        run.goffsets = OS.HeapAlloc(hHeap, 8, run.glyphCount * 8);
        if (run.goffsets == 0L) {
            SWT.error(2);
        }
        OS.ScriptPlace(hdc, run.psc, run.glyphs, run.glyphCount, run.visAttrs, run.analysis, run.advances, run.goffsets, abc);
        run.width = abc[0] + abc[1] + abc[2];
        TextStyle style = run.style;
        if (style != null) {
            OUTLINETEXTMETRIC lotm = null;
            if ((style.underline || style.strikeout) && OS.GetOutlineTextMetrics(hdc, OUTLINETEXTMETRIC.sizeof, lotm = new OUTLINETEXTMETRIC()) == 0) {
                lotm = null;
            }
            if (style.metrics != null) {
                GlyphMetrics metrics = style.metrics;
                run.width = metrics.getWidthInPixels() * Math.max(1, run.glyphCount);
                run.ascentInPoints = metrics.ascent;
                run.descentInPoints = metrics.descent;
                run.leadingInPoints = 0;
            } else {
                TEXTMETRIC lptm = null;
                if (lotm != null) {
                    lptm = lotm.otmTextMetrics;
                } else {
                    lptm = new TEXTMETRIC();
                    OS.GetTextMetrics(hdc, lptm);
                }
                run.ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmAscent);
                run.descentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmDescent);
                run.leadingInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmInternalLeading);
            }
            if (lotm != null) {
                run.underlinePos = lotm.otmsUnderscorePosition;
                run.underlineThickness = Math.max(1, lotm.otmsUnderscoreSize);
                run.strikeoutPos = lotm.otmsStrikeoutPosition;
                run.strikeoutThickness = Math.max(1, lotm.otmsStrikeoutSize);
            } else {
                run.underlinePos = 1;
                run.underlineThickness = 1;
                run.strikeoutPos = DPIUtil.autoScaleUp((Drawable)this.getDevice(), run.ascentInPoints) / 2;
                run.strikeoutThickness = 1;
            }
            run.ascentInPoints += style.rise;
            run.descentInPoints -= style.rise;
        } else {
            TEXTMETRIC lptm = new TEXTMETRIC();
            OS.GetTextMetrics(hdc, lptm);
            run.ascentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmAscent);
            run.descentInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmDescent);
            run.leadingInPoints = DPIUtil.autoScaleDown((Drawable)this.getDevice(), lptm.tmInternalLeading);
        }
    }

    int validadeOffset(int offset, int step) {
        offset = this.untranslateOffset(offset);
        return this.translateOffset(offset + step);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return offset;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return offset;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return offset;
            }
        }
        for (int i = 0; i < nSegments && offset - i >= this.segments[i]; ++i) {
            ++offset;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.segments == null) {
            return offset;
        }
        int nSegments = this.segments.length;
        if (nSegments == 0) {
            return offset;
        }
        if (this.segmentsChars == null) {
            if (nSegments == 1) {
                return offset;
            }
            if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
                return offset;
            }
        }
        for (int i = 0; i < nSegments && offset > this.segments[i]; --offset, ++i) {
        }
        return offset;
    }

    public void setDefaultTabWidth(int tabLength) {
    }

    static {
        OS.IIDFromString("{275c23e2-3747-11d0-9fea-00aa003f8646}\u0000".toCharArray(), CLSID_CMultiLanguage);
        OS.IIDFromString("{DCCFC162-2B38-11d2-B7EC-00C04F8F5D9A}\u0000".toCharArray(), IID_IMLangFontLink2);
    }

    class StyleItem {
        TextStyle style;
        int start;
        int length;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;
        SCRIPT_ANALYSIS analysis;
        long psc = 0L;
        long glyphs;
        int glyphCount;
        long clusters;
        long visAttrs;
        long advances;
        long goffsets;
        int width;
        int ascentInPoints;
        int descentInPoints;
        int leadingInPoints;
        int x;
        int underlinePos;
        int underlineThickness;
        int strikeoutPos;
        int strikeoutThickness;
        long justify;
        long psla;
        long fallbackFont;

        StyleItem() {
        }

        void free() {
            long hHeap = OS.GetProcessHeap();
            if (this.psc != 0L) {
                OS.ScriptFreeCache(this.psc);
                OS.HeapFree(hHeap, 0, this.psc);
                this.psc = 0L;
            }
            if (this.glyphs != 0L) {
                OS.HeapFree(hHeap, 0, this.glyphs);
                this.glyphs = 0L;
                this.glyphCount = 0;
            }
            if (this.clusters != 0L) {
                OS.HeapFree(hHeap, 0, this.clusters);
                this.clusters = 0L;
            }
            if (this.visAttrs != 0L) {
                OS.HeapFree(hHeap, 0, this.visAttrs);
                this.visAttrs = 0L;
            }
            if (this.advances != 0L) {
                OS.HeapFree(hHeap, 0, this.advances);
                this.advances = 0L;
            }
            if (this.goffsets != 0L) {
                OS.HeapFree(hHeap, 0, this.goffsets);
                this.goffsets = 0L;
            }
            if (this.justify != 0L) {
                OS.HeapFree(hHeap, 0, this.justify);
                this.justify = 0L;
            }
            if (this.psla != 0L) {
                OS.HeapFree(hHeap, 0, this.psla);
                this.psla = 0L;
            }
            if (this.fallbackFont != 0L) {
                OS.DeleteObject(this.fallbackFont);
                this.fallbackFont = 0L;
            }
            this.x = 0;
            this.descentInPoints = 0;
            this.ascentInPoints = 0;
            this.width = 0;
            this.softBreak = false;
            this.lineBreak = false;
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

