/*
 *  Copyright (C) 2006-2019  Ronald Blankendaal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
package org.dbgl.gui.dialog;

import org.dbgl.gui.abstractdialog.SizeControlledTabbedDialog;
import org.dbgl.model.ImgSizeCommand;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;


public class EditImgSizeDialog extends SizeControlledTabbedDialog<String> {

	private ImgSizeCommand sizeCommand;

	public EditImgSizeDialog(Shell parent, String command) {
		super(parent, "imgsizedialog");
		sizeCommand = new ImgSizeCommand(command);
	}

	@Override
	protected String getDialogTitle() {
		return text_.get("dialog.imgsize.title");
	}

	@Override
	protected void onShellCreated() {
		Composite composite = createTabWithComposite(text_.get("dialog.imgsize.params"), 2);

		Spinner bytesPerSector = createLabelAndSpinner(composite, text_.get("dialog.imgsize.bytespersector"), sizeCommand.getBytesPerSector(), 1, 4096, 0, 1, 512);
		Spinner sectorsPerTrack = createLabelAndSpinner(composite, text_.get("dialog.imgsize.sectorspertrack"), sizeCommand.getSectorsPerTrack(), 1, 255, 0, 1, 64);
		Spinner heads = createLabelAndSpinner(composite, text_.get("dialog.imgsize.heads"), sizeCommand.getHeads(), 1, 64, 0, 1, 16);
		Spinner cylinders = createLabelAndSpinner(composite, text_.get("dialog.imgsize.cylinders"), sizeCommand.getCylinders(), 1, 8192, 0, 1, 20);

		bytesPerSector.setFocus();

		Text totalSize = createLabelAndText(composite, text_.get("dialog.imgsize.totalsize"),
			text_.get("dialog.imgsize.totalsize.value", new Long[] {sizeCommand.getTotalSize(), sizeCommand.getTotalSizeInMB()}));
		totalSize.setEditable(false);

		ModifyListener listener = new ModifyListener() {
			public void modifyText(ModifyEvent arg0) {
				sizeCommand = new ImgSizeCommand(bytesPerSector.getSelection(), sectorsPerTrack.getSelection(), heads.getSelection(), cylinders.getSelection());
				totalSize.setText(text_.get("dialog.imgsize.totalsize.value", new Long[] {sizeCommand.getTotalSize(), sizeCommand.getTotalSizeInMB()}));
				composite.layout();
			}
		};

		bytesPerSector.addModifyListener(listener);
		sectorsPerTrack.addModifyListener(listener);
		heads.addModifyListener(listener);
		cylinders.addModifyListener(listener);

		createOkCancelButtons(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				result_ = sizeCommand.toString();
				shell_.close();
			}
		});
	}
}
