/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.OleEnumFORMATETC;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    Composite topControl;
    long hwndDrag;
    COMObject iDropSource;
    COMObject iDataObject;
    int refCount;
    int dataEffect = 0;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static final int CFSTR_PERFORMEDDROPEFFECT = Transfer.registerType("Performed DropEffect");
    static final TCHAR WindowClass = new TCHAR(0, "#32770", true);

    public DragSource(Control control, int style) {
        super(control, DragSource.checkStyle(style));
        this.control = control;
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        this.controlListener = event -> {
            if (event.type == 12 && !this.isDisposed()) {
                this.dispose();
            }
            if (event.type == 29 && !this.isDisposed()) {
                this.drag(event);
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, e -> this.onDispose());
        Object effect = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (effect instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)effect;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    public void addDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        typedListener.dndWidget = this;
        this.addListener(2008, typedListener);
        this.addListener(2001, typedListener);
        this.addListener(2000, typedListener);
    }

    private int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private void createCOMInterfaces() {
        this.disposeCOMInterfaces();
        this.iDropSource = new COMObject(new int[]{2, 0, 0, 2, 1}){

            @Override
            public long method0(long[] args) {
                return DragSource.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public long method1(long[] args) {
                return DragSource.this.AddRef();
            }

            @Override
            public long method2(long[] args) {
                return DragSource.this.Release();
            }

            @Override
            public long method3(long[] args) {
                return DragSource.this.QueryContinueDrag((int)args[0], (int)args[1]);
            }

            @Override
            public long method4(long[] args) {
                return DragSource.this.GiveFeedback((int)args[0]);
            }
        };
        this.iDataObject = new COMObject(new int[]{2, 0, 0, 2, 2, 1, 2, 3, 2, 4, 1, 1}){

            @Override
            public long method0(long[] args) {
                return DragSource.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public long method1(long[] args) {
                return DragSource.this.AddRef();
            }

            @Override
            public long method2(long[] args) {
                return DragSource.this.Release();
            }

            @Override
            public long method3(long[] args) {
                return DragSource.this.GetData(args[0], args[1]);
            }

            @Override
            public long method5(long[] args) {
                return DragSource.this.QueryGetData(args[0]);
            }

            @Override
            public long method7(long[] args) {
                return DragSource.this.SetData(args[0], args[1], (int)args[2]);
            }

            @Override
            public long method8(long[] args) {
                return DragSource.this.EnumFormatEtc((int)args[0], args[1]);
            }
        };
        this.refCount = 1;
    }

    @Override
    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = DragSource.class.getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    private void disposeCOMInterfaces() {
        if (this.iDropSource != null) {
            this.iDropSource.dispose();
        }
        this.iDropSource = null;
        if (this.iDataObject != null) {
            this.iDataObject.dispose();
        }
        this.iDataObject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drag(Event dragEvent) {
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.x = dragEvent.x;
        event.y = dragEvent.y;
        event.time = OS.GetMessageTime();
        event.doit = true;
        this.notifyListeners(2008, event);
        if (!event.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            return;
        }
        this.createCOMInterfaces();
        int[] pdwEffect = new int[1];
        int operations = this.opToOs(this.getStyle());
        Display display = this.control.getDisplay();
        String key = "org.eclipse.swt.internal.win32.runMessagesInIdle";
        Object oldValue = display.getData(key);
        display.setData(key, Boolean.TRUE);
        ImageList imagelist = null;
        Image image = event.image;
        this.hwndDrag = 0L;
        this.topControl = null;
        if (image != null) {
            imagelist = new ImageList(0);
            imagelist.add(image);
            this.topControl = this.control.getShell();
            int offsetX = event.offsetX;
            this.hwndDrag = this.topControl.handle;
            if ((this.topControl.getStyle() & 0x4000000) != 0) {
                offsetX = image.getBoundsInPixels().width - offsetX;
                RECT rect = new RECT();
                OS.GetClientRect(this.topControl.handle, rect);
                this.hwndDrag = OS.CreateWindowEx(0x100020, WindowClass, null, 0x44000000, 0, 0, rect.right - rect.left, rect.bottom - rect.top, this.topControl.handle, 0L, OS.GetModuleHandle(null), null);
                OS.ShowWindow(this.hwndDrag, 5);
            }
            OS.ImageList_BeginDrag(imagelist.getHandle(), 0, offsetX, event.offsetY);
            int flags = 384;
            OS.RedrawWindow(this.topControl.handle, null, 0L, flags);
            POINT pt = new POINT();
            pt.x = DPIUtil.autoScaleUp(dragEvent.x);
            pt.y = DPIUtil.autoScaleUp(dragEvent.y);
            OS.MapWindowPoints(this.control.handle, 0L, pt, 1);
            RECT rect = new RECT();
            OS.GetWindowRect(this.hwndDrag, rect);
            OS.ImageList_DragEnter(this.hwndDrag, pt.x - rect.left, pt.y - rect.top);
        }
        int result = 262401;
        try {
            result = COM.DoDragDrop(this.iDataObject.getAddress(), this.iDropSource.getAddress(), operations, pdwEffect);
        }
        finally {
            if (this.hwndDrag != 0L) {
                OS.ImageList_DragLeave(this.hwndDrag);
                OS.ImageList_EndDrag();
                imagelist.dispose();
                if (this.hwndDrag != this.topControl.handle) {
                    OS.DestroyWindow(this.hwndDrag);
                }
                this.hwndDrag = 0L;
                this.topControl = null;
            }
            display.setData(key, oldValue);
            this.Release();
        }
        int operation = this.osToOp(pdwEffect[0]);
        if (this.dataEffect == 2) {
            operation = operation == 0 || operation == 1 ? 8 : 2;
        } else if (this.dataEffect != 0) {
            operation = this.dataEffect;
        }
        long start = System.currentTimeMillis();
        while (this.refCount > 0 && System.currentTimeMillis() - start < 1000L) {
            if (display.readAndDispatch()) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        this.disposeCOMInterfaces();
        event = new DNDEvent();
        event.widget = this;
        event.time = OS.GetMessageTime();
        event.doit = result == 262400;
        event.detail = operation;
        this.notifyListeners(2000, event);
        this.dataEffect = 0;
    }

    private int EnumFormatEtc(int dwDirection, long ppenumFormatetc) {
        if (dwDirection == 2) {
            return -2147467263;
        }
        TransferData[] allowedDataTypes = new TransferData[]{};
        for (int i = 0; i < this.transferAgents.length; ++i) {
            Transfer transferAgent = this.transferAgents[i];
            if (transferAgent == null) continue;
            TransferData[] formats = transferAgent.getSupportedTypes();
            TransferData[] newAllowedDataTypes = new TransferData[allowedDataTypes.length + formats.length];
            System.arraycopy(allowedDataTypes, 0, newAllowedDataTypes, 0, allowedDataTypes.length);
            System.arraycopy(formats, 0, newAllowedDataTypes, allowedDataTypes.length, formats.length);
            allowedDataTypes = newAllowedDataTypes;
        }
        OleEnumFORMATETC enumFORMATETC = new OleEnumFORMATETC();
        enumFORMATETC.AddRef();
        FORMATETC[] formats = new FORMATETC[allowedDataTypes.length];
        for (int i = 0; i < formats.length; ++i) {
            formats[i] = allowedDataTypes[i].formatetc;
        }
        enumFORMATETC.setFormats(formats);
        OS.MoveMemory(ppenumFormatetc, new long[]{enumFORMATETC.getAddress()}, C.PTR_SIZEOF);
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    private int GetData(long pFormatetc, long pmedium) {
        if (pFormatetc == 0L || pmedium == 0L) {
            return -2147024809;
        }
        if (this.QueryGetData(pFormatetc) != 0) {
            return -2147221404;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, pFormatetc, FORMATETC.sizeof);
        transferData.type = transferData.formatetc.cfFormat;
        transferData.stgmedium = new STGMEDIUM();
        transferData.result = -2147467259;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = OS.GetMessageTime();
        event.dataType = transferData;
        this.notifyListeners(2001, event);
        if (!event.doit) {
            return -2147467259;
        }
        Transfer transfer = null;
        for (int i = 0; i < this.transferAgents.length; ++i) {
            Transfer transferAgent = this.transferAgents[i];
            if (transferAgent == null || !transferAgent.isSupportedType(transferData)) continue;
            transfer = transferAgent;
            break;
        }
        if (transfer == null) {
            return -2147221404;
        }
        transfer.javaToNative(event.data, transferData);
        if (transferData.result != 0) {
            return transferData.result;
        }
        COM.MoveMemory(pmedium, transferData.stgmedium, STGMEDIUM.sizeof);
        return transferData.result;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listeners = this.getListeners(2008);
        int length = listeners.length;
        DragSourceListener[] dragListeners = new DragSourceListener[length];
        int count = 0;
        for (int i = 0; i < length; ++i) {
            Listener listener = listeners[i];
            if (!(listener instanceof DNDListener)) continue;
            dragListeners[count] = (DragSourceListener)((DNDListener)listener).getEventListener();
            ++count;
        }
        if (count == length) {
            return dragListeners;
        }
        DragSourceListener[] result = new DragSourceListener[count];
        System.arraycopy(dragListeners, 0, result, 0, count);
        return result;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    private int GiveFeedback(int dwEffect) {
        return 262402;
    }

    private int QueryContinueDrag(int fEscapePressed, int grfKeyState) {
        if (this.topControl != null && this.topControl.isDisposed()) {
            return 262401;
        }
        if (fEscapePressed != 0) {
            if (this.hwndDrag != 0L) {
                OS.ImageList_DragLeave(this.hwndDrag);
            }
            return 262401;
        }
        int mask = 19;
        if ((grfKeyState & mask) == 0) {
            if (this.hwndDrag != 0L) {
                OS.ImageList_DragLeave(this.hwndDrag);
            }
            return 262400;
        }
        if (this.hwndDrag != 0L) {
            POINT pt = new POINT();
            OS.GetCursorPos(pt);
            RECT rect = new RECT();
            OS.GetWindowRect(this.hwndDrag, rect);
            OS.ImageList_DragMove(pt.x - rect.left, pt.y - rect.top);
        }
        return 0;
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        this.Release();
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
    }

    private int opToOs(int operation) {
        int osOperation = 0;
        if ((operation & 1) != 0) {
            osOperation |= 1;
        }
        if ((operation & 4) != 0) {
            osOperation |= 4;
        }
        if ((operation & 2) != 0) {
            osOperation |= 2;
        }
        return osOperation;
    }

    private int osToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 1) != 0) {
            operation |= 1;
        }
        if ((osOperation & 4) != 0) {
            operation |= 4;
        }
        if ((osOperation & 2) != 0) {
            operation |= 2;
        }
        return operation;
    }

    private int QueryGetData(long pFormatetc) {
        if (this.transferAgents == null) {
            return -2147467259;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, pFormatetc, FORMATETC.sizeof);
        transferData.type = transferData.formatetc.cfFormat;
        for (int i = 0; i < this.transferAgents.length; ++i) {
            Transfer transfer = this.transferAgents[i];
            if (transfer == null || !transfer.isSupportedType(transferData)) continue;
            return 0;
        }
        return -2147221404;
    }

    private int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147024809;
        }
        GUID guid = new GUID();
        COM.MoveMemory(guid, riid, GUID.sizeof);
        if (COM.IsEqualGUID(guid, COM.IIDIUnknown) || COM.IsEqualGUID(guid, COM.IIDIDropSource)) {
            OS.MoveMemory(ppvObject, new long[]{this.iDropSource.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(guid, COM.IIDIDataObject)) {
            OS.MoveMemory(ppvObject, new long[]{this.iDataObject.getAddress()}, C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        OS.MoveMemory(ppvObject, new long[]{0L}, C.PTR_SIZEOF);
        return -2147467262;
    }

    private int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            if (COM.FreeUnusedLibraries) {
                COM.CoFreeUnusedLibraries();
            }
        }
        return this.refCount;
    }

    public void removeDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2008, listener);
        this.removeListener(2001, listener);
        this.removeListener(2000, listener);
    }

    private int SetData(long pFormatetc, long pmedium, int fRelease) {
        if (pFormatetc == 0L || pmedium == 0L) {
            return -2147024809;
        }
        FORMATETC formatetc = new FORMATETC();
        COM.MoveMemory(formatetc, pFormatetc, FORMATETC.sizeof);
        if (formatetc.cfFormat == CFSTR_PERFORMEDDROPEFFECT && formatetc.tymed == 1) {
            STGMEDIUM stgmedium = new STGMEDIUM();
            COM.MoveMemory(stgmedium, pmedium, STGMEDIUM.sizeof);
            long[] ptrEffect = new long[1];
            OS.MoveMemory(ptrEffect, stgmedium.unionField, C.PTR_SIZEOF);
            int[] effect = new int[1];
            OS.MoveMemory(effect, ptrEffect[0], 4);
            this.dataEffect = this.osToOp(effect[0]);
        }
        if (fRelease == 1) {
            COM.ReleaseStgMedium(pmedium);
        }
        return 0;
    }

    public void setDragSourceEffect(DragSourceEffect effect) {
        this.dragEffect = effect;
    }

    public void setTransfer(Transfer ... transferAgents) {
        this.transferAgents = transferAgents;
    }
}

